"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateLicenseFile = generateLicenseFile;
const tslib_1 = require("tslib");
const getLicenseFileText_1 = require("./getLicenseFileText");
const file_utils_1 = require("./utils/file.utils");
function generateLicenseFile(pathsToPackageJsons, outputPath, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (typeof pathsToPackageJsons === "string") {
            pathsToPackageJsons = [pathsToPackageJsons];
        }
        const licenseFileText = yield (0, getLicenseFileText_1.getLicenseFileText)(pathsToPackageJsons, options);
        yield (0, file_utils_1.writeFileAsync)(outputPath, licenseFileText);
    });
}
//# sourceMappingURL=generateLicenseFile.js.map