"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseSchema = exports.configSchema = void 0;
const zod_1 = require("zod");
exports.configSchema = zod_1.z
    .object({
    inputs: zod_1.z.string().nonempty().array().optional(),
    output: zod_1.z.string().nonempty().optional(),
    overwrite: zod_1.z
        .boolean()
        .optional()
        // TODO: Remove. With the addition of config files the user has the ability to
        // set overwrite to false. This was not possible via the CLI (which only ever
        // gave true or undefined), and the usage of the overwrite flag in the output
        // resolution no longer worked. This overrides any false value with undefined
        // to restore output resolution.
        .transform(o => (o ? o : undefined)),
    spinner: zod_1.z.boolean().optional(),
    ci: zod_1.z.boolean().optional(),
    eol: zod_1.z.union([zod_1.z.literal("crlf"), zod_1.z.literal("lf")]).optional(),
    replace: zod_1.z.record(zod_1.z.string().nonempty(), zod_1.z.string().nonempty()).optional(),
    exclude: zod_1.z.string().nonempty().array().optional(),
    append: zod_1.z.string().nonempty().array().optional(),
})
    .optional();
const parseSchema = (input) => {
    const parseResult = exports.configSchema.safeParse(input);
    if (parseResult.success) {
        return parseResult.data;
    }
    throw new Error(`Invalid config: ${JSON.stringify(parseResult.error.issues)}`);
};
exports.parseSchema = parseSchema;
//# sourceMappingURL=schema.js.map