"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadConfigFile = void 0;
const tslib_1 = require("tslib");
const path_1 = require("path");
const file_utils_1 = require("../../utils/file.utils");
const configFile_1 = require("./configFile");
const schema_1 = require("./schema");
const loadConfigFile = (path) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    if (path && (yield (0, file_utils_1.doesFileExist)(path))) {
        return loadAndParseConfig(path);
    }
    else if (path) {
        // TODO Should this be nicer? (yes).
        throw new Error("Config file could not be found.");
    }
    return findAndParseConfig(process.cwd());
});
exports.loadConfigFile = loadConfigFile;
const findAndParseConfig = (directory) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const configFile = yield (0, configFile_1.findConfig)(directory);
    return yield parseConfig(configFile, directory);
});
const loadAndParseConfig = (filePath) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const configFile = yield (0, configFile_1.loadConfig)(filePath);
    const directory = (0, path_1.dirname)(filePath);
    return yield parseConfig(configFile, directory);
});
const parseConfig = (configFile, directory) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const config = (0, schema_1.parseSchema)(configFile === null || configFile === void 0 ? void 0 : configFile.config);
    if (config === undefined) {
        return;
    }
    for (const replacement in config === null || config === void 0 ? void 0 : config.replace) {
        const replacementPath = config.replace[replacement];
        // The replacement value could be multiple things (e.g. file path, or a
        // URL). If it's a file path, then at this stage the CLI is aware of the
        // execution directory and needs to make the path absolute before handing
        // it off to the library implementation. Otherwise, pass the raw replacement
        // value into the library so it can handle it however it wants.
        const absolutePath = (0, path_1.join)(directory, replacementPath);
        if (yield (0, file_utils_1.doesFileExist)(absolutePath)) {
            config.replace[replacement] = absolutePath;
        }
    }
    if (config.append) {
        for (let i = 0; i < config.append.length; i++) {
            const appendixPath = config.append[i];
            if ((0, path_1.isAbsolute)(appendixPath)) {
                continue;
            }
            const absolutePath = (0, path_1.join)(directory, appendixPath);
            config.append[i] = absolutePath;
        }
    }
    return config;
});
//# sourceMappingURL=index.js.map