"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Output = void 0;
const tslib_1 = require("tslib");
const file_utils_1 = require("../../utils/file.utils");
const argument_1 = require("./argument");
class Output extends argument_1.Argument {
    constructor() {
        super(...arguments);
        this.question = "Output location: ";
        this.initialValue = "third-party-licenses.txt";
    }
    resolve(config) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            let { output, overwrite } = config;
            let outputExists = output ? yield (0, file_utils_1.doesFileExist)(output) : false;
            while (!output || (outputExists && !overwrite)) {
                if (!output) {
                    output = yield this.promptForString(this.question, this.initialValue);
                }
                outputExists = yield (0, file_utils_1.doesFileExist)(output);
                if (outputExists && overwrite === undefined) {
                    overwrite = yield this.promptForBoolean("This file already exists - do you want to overwrite it?");
                }
                if (outputExists && overwrite === false) {
                    output = undefined;
                    overwrite = undefined;
                }
            }
            return output;
        });
    }
    parse(config) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { output, overwrite } = config;
            if (!output) {
                throw new Error("No --output argument given.");
            }
            const outputExists = yield (0, file_utils_1.doesFileExist)(output);
            if (outputExists && !overwrite) {
                throw new Error(`Given --output file already exists at '${output}'. Use --overwrite to allow overwriting.`);
            }
            return output;
        });
    }
}
exports.Output = Output;
//# sourceMappingURL=output.js.map