import { CombinedConfig } from "../commands/main";
export type MultipleChoiceOptions<T> = {
    [key: string]: T;
};
export declare abstract class Argument<T> {
    abstract parse(config: CombinedConfig): Promise<T>;
    abstract resolve(config: CombinedConfig): Promise<T>;
    protected promptForString(question: string, initialValue: string): Promise<string>;
    protected promptForBoolean(question: string): Promise<boolean>;
    protected promptForMultipleChoice<T>(question: string, options: MultipleChoiceOptions<T>): Promise<T>;
}
