import type { LineString, Position } from "geojson";
/**
 * Decodes any string into a [longitude, latitude] coordinates array.
 *
 * Any string is a valid polyline, but if you provide this
 * with an arbitrary string, it'll produce coordinates well
 * outside of the normal range.
 */
export declare function decode(str: string, precision?: number): Position[];
/**
 * Encodes the given [latitude, longitude] coordinates array.
 *
 * @param coordinates Coordinates, in longitude, latitude order
 * @returns encoded polyline
 */
export declare function encode(coordinates: number[][], precision?: number): string;
/**
 * Encodes a GeoJSON LineString feature/geometry.
 *
 * @param geojson A LineString
 */
export declare function geoJSONToPolyline(geojson: LineString, precision?: number): string;
/**
 * Decodes to a GeoJSON LineString geometry.
 *
 * @param str An encoded polyline as a string.
 */
export declare function polylineToGeoJSON(str: string, precision?: number): LineString;
