import { Reader } from '@jsonjoy.com/buffers/lib/Reader';
export declare const EMPY_U8: Uint8Array;
export declare const EMPTY_READER: Reader;
export declare const enum Nfsv4Const {
    PROGRAM = 100003,
    VERSION = 4,
    FHSIZE = 128,
    VERIFIER_SIZE = 8,
    OPAQUE_LIMIT = 1024,
    OTHER_SIZE = 12
}
export declare const enum Nfsv4Proc {
    NULL = 0,
    COMPOUND = 1
}
export declare const enum Nfsv4CbProc {
    CB_NULL = 0,
    CB_COMPOUND = 1
}
export declare const enum Nfsv4Op {
    ACCESS = 3,
    CLOSE = 4,
    COMMIT = 5,
    CREATE = 6,
    DELEGPURGE = 7,
    DELEGRETURN = 8,
    GETATTR = 9,
    GETFH = 10,
    LINK = 11,
    LOCK = 12,
    LOCKT = 13,
    LOCKU = 14,
    LOOKUP = 15,
    LOOKUPP = 16,
    NVERIFY = 17,
    OPEN = 18,
    OPENATTR = 19,
    OPEN_CONFIRM = 20,
    OPEN_DOWNGRADE = 21,
    PUTFH = 22,
    PUTPUBFH = 23,
    PUTROOTFH = 24,
    READ = 25,
    READDIR = 26,
    READLINK = 27,
    REMOVE = 28,
    RENAME = 29,
    RENEW = 30,
    RESTOREFH = 31,
    SAVEFH = 32,
    SECINFO = 33,
    SETATTR = 34,
    SETCLIENTID = 35,
    SETCLIENTID_CONFIRM = 36,
    VERIFY = 37,
    WRITE = 38,
    RELEASE_LOCKOWNER = 39,
    ILLEGAL = 10044
}
export declare const enum Nfsv4CbOp {
    CB_GETATTR = 3,
    CB_RECALL = 4,
    CB_ILLEGAL = 10044
}
export declare const enum Nfsv4Stat {
    NFS4_OK = 0,
    NFS4ERR_PERM = 1,
    NFS4ERR_NOENT = 2,
    NFS4ERR_IO = 5,
    NFS4ERR_NXIO = 6,
    NFS4ERR_ACCESS = 13,
    NFS4ERR_EXIST = 17,
    NFS4ERR_XDEV = 18,
    NFS4ERR_NOTDIR = 20,
    NFS4ERR_ISDIR = 21,
    NFS4ERR_INVAL = 22,
    NFS4ERR_FBIG = 27,
    NFS4ERR_NOSPC = 28,
    NFS4ERR_ROFS = 30,
    NFS4ERR_MLINK = 31,
    NFS4ERR_NAMETOOLONG = 63,
    NFS4ERR_NOTEMPTY = 66,
    NFS4ERR_DQUOT = 69,
    NFS4ERR_STALE = 70,
    NFS4ERR_BADHANDLE = 10001,
    NFS4ERR_BAD_COOKIE = 10003,
    NFS4ERR_NOTSUPP = 10004,
    NFS4ERR_TOOSMALL = 10005,
    NFS4ERR_SERVERFAULT = 10006,
    NFS4ERR_BADTYPE = 10007,
    NFS4ERR_DELAY = 10008,
    NFS4ERR_SAME = 10009,
    NFS4ERR_DENIED = 10010,
    NFS4ERR_EXPIRED = 10011,
    NFS4ERR_LOCKED = 10012,
    NFS4ERR_GRACE = 10013,
    NFS4ERR_FHEXPIRED = 10014,
    NFS4ERR_SHARE_DENIED = 10015,
    NFS4ERR_WRONGSEC = 10016,
    NFS4ERR_CLID_INUSE = 10017,
    NFS4ERR_RESOURCE = 10018,
    NFS4ERR_MOVED = 10019,
    NFS4ERR_NOFILEHANDLE = 10020,
    NFS4ERR_MINOR_VERS_MISMATCH = 10021,
    NFS4ERR_STALE_CLIENTID = 10022,
    NFS4ERR_STALE_STATEID = 10023,
    NFS4ERR_OLD_STATEID = 10024,
    NFS4ERR_BAD_STATEID = 10025,
    NFS4ERR_BAD_SEQID = 10026,
    NFS4ERR_NOT_SAME = 10027,
    NFS4ERR_LOCK_RANGE = 10028,
    NFS4ERR_SYMLINK = 10029,
    NFS4ERR_RESTOREFH = 10030,
    NFS4ERR_LEASE_MOVED = 10031,
    NFS4ERR_ATTRNOTSUPP = 10032,
    NFS4ERR_NO_GRACE = 10033,
    NFS4ERR_RECLAIM_BAD = 10034,
    NFS4ERR_RECLAIM_CONFLICT = 10035,
    NFS4ERR_BADXDR = 10036,
    NFS4ERR_LOCKS_HELD = 10037,
    NFS4ERR_OPENMODE = 10038,
    NFS4ERR_BADOWNER = 10039,
    NFS4ERR_BADCHAR = 10040,
    NFS4ERR_BADNAME = 10041,
    NFS4ERR_BAD_RANGE = 10042,
    NFS4ERR_LOCK_NOTSUPP = 10043,
    NFS4ERR_OP_ILLEGAL = 10044,
    NFS4ERR_DEADLOCK = 10045,
    NFS4ERR_FILE_OPEN = 10046,
    NFS4ERR_ADMIN_REVOKED = 10047,
    NFS4ERR_CB_PATH_DOWN = 10048
}
export declare const enum Nfsv4FType {
    NF4REG = 1,
    NF4DIR = 2,
    NF4BLK = 3,
    NF4CHR = 4,
    NF4LNK = 5,
    NF4SOCK = 6,
    NF4FIFO = 7,
    NF4ATTRDIR = 8,
    NF4NAMEDATTR = 9
}
export declare const enum Nfsv4TimeHow {
    SET_TO_SERVER_TIME4 = 0,
    SET_TO_CLIENT_TIME4 = 1
}
export declare const enum Nfsv4StableHow {
    UNSTABLE4 = 0,
    DATA_SYNC4 = 1,
    FILE_SYNC4 = 2
}
export declare const enum Nfsv4CreateMode {
    UNCHECKED4 = 0,
    GUARDED4 = 1,
    EXCLUSIVE4 = 2
}
export declare const enum Nfsv4OpenFlags {
    OPEN4_NOCREATE = 0,
    OPEN4_CREATE = 1
}
export declare const enum Nfsv4OpenAccess {
    OPEN4_SHARE_ACCESS_READ = 1,
    OPEN4_SHARE_ACCESS_WRITE = 2,
    OPEN4_SHARE_ACCESS_BOTH = 3
}
export declare const enum Nfsv4OpenDeny {
    OPEN4_SHARE_DENY_NONE = 0,
    OPEN4_SHARE_DENY_READ = 1,
    OPEN4_SHARE_DENY_WRITE = 2,
    OPEN4_SHARE_DENY_BOTH = 3
}
export declare const enum Nfsv4OpenClaimType {
    CLAIM_NULL = 0,
    CLAIM_PREVIOUS = 1,
    CLAIM_DELEGATE_CUR = 2,
    CLAIM_DELEGATE_PREV = 3
}
export declare const enum Nfsv4DelegType {
    OPEN_DELEGATE_NONE = 0,
    OPEN_DELEGATE_READ = 1,
    OPEN_DELEGATE_WRITE = 2
}
export declare const enum Nfsv4LockType {
    READ_LT = 1,
    WRITE_LT = 2,
    READW_LT = 3,
    WRITEW_LT = 4
}
export declare const enum Nfsv4Access {
    ACCESS4_READ = 1,
    ACCESS4_LOOKUP = 2,
    ACCESS4_MODIFY = 4,
    ACCESS4_EXTEND = 8,
    ACCESS4_DELETE = 16,
    ACCESS4_EXECUTE = 32
}
export declare const enum Nfsv4AceType {
    ACE4_ACCESS_ALLOWED_ACE_TYPE = 0,
    ACE4_ACCESS_DENIED_ACE_TYPE = 1,
    ACE4_SYSTEM_AUDIT_ACE_TYPE = 2,
    ACE4_SYSTEM_ALARM_ACE_TYPE = 3
}
export declare const enum Nfsv4AceFlag {
    ACE4_FILE_INHERIT_ACE = 1,
    ACE4_DIRECTORY_INHERIT_ACE = 2,
    ACE4_NO_PROPAGATE_INHERIT_ACE = 4,
    ACE4_INHERIT_ONLY_ACE = 8,
    ACE4_SUCCESSFUL_ACCESS_ACE_FLAG = 16,
    ACE4_FAILED_ACCESS_ACE_FLAG = 32,
    ACE4_IDENTIFIER_GROUP = 64
}
export declare const enum Nfsv4AceMask {
    ACE4_READ_DATA = 1,
    ACE4_LIST_DIRECTORY = 1,
    ACE4_WRITE_DATA = 2,
    ACE4_ADD_FILE = 2,
    ACE4_APPEND_DATA = 4,
    ACE4_ADD_SUBDIRECTORY = 4,
    ACE4_READ_NAMED_ATTRS = 8,
    ACE4_WRITE_NAMED_ATTRS = 16,
    ACE4_EXECUTE = 32,
    ACE4_DELETE_CHILD = 64,
    ACE4_READ_ATTRIBUTES = 128,
    ACE4_WRITE_ATTRIBUTES = 256,
    ACE4_DELETE = 65536,
    ACE4_READ_ACL = 131072,
    ACE4_WRITE_ACL = 262144,
    ACE4_WRITE_OWNER = 524288,
    ACE4_SYNCHRONIZE = 1048576
}
export declare const enum Nfsv4AclSupport {
    ACL4_SUPPORT_ALLOW_ACL = 1,
    ACL4_SUPPORT_DENY_ACL = 2,
    ACL4_SUPPORT_AUDIT_ACL = 4,
    ACL4_SUPPORT_ALARM_ACL = 8
}
export declare const enum Nfsv4Mode {
    MODE4_SUID = 2048,
    MODE4_SGID = 1024,
    MODE4_SVTX = 512,
    MODE4_RUSR = 256,
    MODE4_WUSR = 128,
    MODE4_XUSR = 64,
    MODE4_RGRP = 32,
    MODE4_WGRP = 16,
    MODE4_XGRP = 8,
    MODE4_ROTH = 4,
    MODE4_WOTH = 2,
    MODE4_XOTH = 1
}
export declare const enum Nfsv4FhExpireType {
    FH4_PERSISTENT = 0,
    FH4_NOEXPIRE_WITH_OPEN = 1,
    FH4_VOLATILE_ANY = 2,
    FH4_VOL_MIGRATION = 4,
    FH4_VOL_RENAME = 8
}
export declare const enum Nfsv4Attr {
    FATTR4_SUPPORTED_ATTRS = 0,
    FATTR4_TYPE = 1,
    FATTR4_FH_EXPIRE_TYPE = 2,
    FATTR4_CHANGE = 3,
    FATTR4_SIZE = 4,
    FATTR4_LINK_SUPPORT = 5,
    FATTR4_SYMLINK_SUPPORT = 6,
    FATTR4_NAMED_ATTR = 7,
    FATTR4_FSID = 8,
    FATTR4_UNIQUE_HANDLES = 9,
    FATTR4_LEASE_TIME = 10,
    FATTR4_RDATTR_ERROR = 11,
    FATTR4_ACL = 12,
    FATTR4_ACLSUPPORT = 13,
    FATTR4_ARCHIVE = 14,
    FATTR4_CANSETTIME = 15,
    FATTR4_CASE_INSENSITIVE = 16,
    FATTR4_CASE_PRESERVING = 17,
    FATTR4_CHOWN_RESTRICTED = 18,
    FATTR4_FILEHANDLE = 19,
    FATTR4_FILEID = 20,
    FATTR4_FILES_AVAIL = 21,
    FATTR4_FILES_FREE = 22,
    FATTR4_FILES_TOTAL = 23,
    FATTR4_FS_LOCATIONS = 24,
    FATTR4_HIDDEN = 25,
    FATTR4_HOMOGENEOUS = 26,
    FATTR4_MAXFILESIZE = 27,
    FATTR4_MAXLINK = 28,
    FATTR4_MAXNAME = 29,
    FATTR4_MAXREAD = 30,
    FATTR4_MAXWRITE = 31,
    FATTR4_MIMETYPE = 32,
    FATTR4_MODE = 33,
    FATTR4_NO_TRUNC = 34,
    FATTR4_NUMLINKS = 35,
    FATTR4_OWNER = 36,
    FATTR4_OWNER_GROUP = 37,
    FATTR4_QUOTA_AVAIL_HARD = 38,
    FATTR4_QUOTA_AVAIL_SOFT = 39,
    FATTR4_QUOTA_USED = 40,
    FATTR4_RAWDEV = 41,
    FATTR4_SPACE_AVAIL = 42,
    FATTR4_SPACE_FREE = 43,
    FATTR4_SPACE_TOTAL = 44,
    FATTR4_SPACE_USED = 45,
    FATTR4_SYSTEM = 46,
    FATTR4_TIME_ACCESS = 47,
    FATTR4_TIME_ACCESS_SET = 48,
    FATTR4_TIME_BACKUP = 49,
    FATTR4_TIME_CREATE = 50,
    FATTR4_TIME_DELTA = 51,
    FATTR4_TIME_METADATA = 52,
    FATTR4_TIME_MODIFY = 53,
    FATTR4_TIME_MODIFY_SET = 54,
    FATTR4_MOUNTED_ON_FILEID = 55
}
