import { WebPlugin } from '@capacitor/core';
export class KeepAwakeWeb extends WebPlugin {
    constructor() {
        super(...arguments);
        this.wakeLock = null;
        this._isSupported = typeof navigator !== 'undefined' && 'wakeLock' in navigator;
        this.handleVisibilityChange = () => {
            if (document.visibilityState === 'visible')
                this.keepAwake();
        };
    }
    async keepAwake() {
        if (!this._isSupported) {
            this.throwUnsupportedError();
        }
        if (this.wakeLock) {
            await this.allowSleep();
        }
        this.wakeLock = await navigator.wakeLock.request('screen');
        document.addEventListener('visibilitychange', this.handleVisibilityChange);
        document.addEventListener('fullscreenchange', this.handleVisibilityChange);
    }
    async allowSleep() {
        var _a;
        if (!this._isSupported) {
            this.throwUnsupportedError();
        }
        (_a = this.wakeLock) === null || _a === void 0 ? void 0 : _a.release();
        this.wakeLock = null;
        document.removeEventListener('visibilitychange', this.handleVisibilityChange);
        document.removeEventListener('fullscreenchange', this.handleVisibilityChange);
    }
    async isSupported() {
        const result = {
            isSupported: this._isSupported,
        };
        return result;
    }
    async isKeptAwake() {
        if (!this._isSupported) {
            this.throwUnsupportedError();
        }
        const result = {
            isKeptAwake: !!this.wakeLock,
        };
        return result;
    }
    throwUnsupportedError() {
        throw this.unavailable('Screen Wake Lock API not available in this browser.');
    }
}
//# sourceMappingURL=web.js.map