/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 33:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "css/assets/acfb7daef2213f42ee79.png";

/***/ }),

/***/ 40:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_unit_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(402);
/* harmony import */ var _action_sheet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1194);
/* harmony import */ var _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2472);
/* harmony import */ var _css_assets_loading_darkgrey_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1838);
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */






/**
 * DOM du contrôle du dessin d'itineraire
 * @mixin RouteDrawDOM
 */
let RouteDrawDOM = {
  dom: {
    container: null,
    title: null,
    titlewrapper: null,
    summary: null,
    details: null,
    detailsList: null,
    changeMode: null,
    modeSelectDom: null
  },
  /**
   * obtenir le container principal
   * @param {*} transport
   * @returns {DOMElement}
   * @public
   */
  getContainer(transport) {
    // nettoyage
    if (this.dom.container) {
      this.dom.container.remove();
    }
    if (this.dom.modeSelectDom) {
      this.dom.modeSelectDom.remove();
    }
    // ajout du container principal
    var container = this.__addResultsContainerDOMElement();
    // ajout du résumé
    this.dom.summary = this.__addResultsSummaryContainerDOMElement(transport);
    container.appendChild(this.dom.summary);
    // ajout des détails (profil alti et détails du parcours)
    this.dom.details = this.__addResultsListDetailsContainerDOMElement();
    container.appendChild(this.dom.details);
    this.dom.modeSelectDom = this.__addModeSelectDOMElement();
    return container;
  },
  /**
   * ajout du container principal
   * @returns {DOMElement}
   * @private
   */
  __addResultsContainerDOMElement() {
    var div = this.dom.container = document.createElement("div");
    div.id = "routeDrawResults";
    div.className = "";
    var wrapper = this.dom.titlewrapper = document.createElement("div");
    wrapper.className = "routeDrawTitleWrapper";
    var title = this.dom.title = document.createElement("p");
    title.classList.add("routeDrawResultsTitle");
    wrapper.appendChild(title);
    var labelAdvancedTools = this.dom.labelAdvancedTools = document.createElement("label");
    labelAdvancedTools.id = "route-draw-show-advanced-tools";
    labelAdvancedTools.title = "Plus d'outils";
    labelAdvancedTools.className = "tools-layer-advanced";
    labelAdvancedTools.role = "button";
    labelAdvancedTools.tabIndex = "0";
    labelAdvancedTools.addEventListener("click", () => {
      _action_sheet__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.show({
        options: [{
          class: "tools-layer-edit",
          text: "Modifier",
          value: "edit"
        }, {
          class: "tools-layer-share",
          text: "Partager",
          value: "share"
        }, {
          class: "tools-layer-visibility",
          text: "Masquer",
          value: "hide"
        }, {
          class: "tools-layer-download",
          text: "Télécharger le plan",
          value: "download"
        }, {
          class: "tools-layer-export",
          text: "Exporter",
          value: "export"
        }, {
          class: "tools-layer-remove confirm-needed",
          text: "Supprimer",
          value: "delete",
          confirmCallback: () => {
            _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
              text: "Confirmez la suppression de l'itinéraire",
              duration: "short",
              position: "bottom"
            });
          }
        }],
        timeToHide: 50
      }).then(value => {
        if (value === "share") {
          this.shareRoute();
        }
        if (value === "hide") {
          this.hideRoute();
        }
        if (value === "edit") {
          this.openEdition();
        }
        if (value === "export") {
          this.exportRoute();
        }
        if (value === "delete") {
          this.deleteRoute();
        }
        if (value === "download") {
          this.downloadRoute();
        }
      });
    });
    wrapper.appendChild(labelAdvancedTools);
    div.appendChild(wrapper);
    return div;
  },
  /**
   * ajoute le container le résumé du parcours
   * @param {*}
   * @param {Boolean} isCopy - si c'est une copie du résumé (pour le track-record)
   * @returns {DOMElement}
   * @private
   */
  __addResultsSummaryContainerDOMElement(transport) {
    let isCopy = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var wrapper = document.createElement("div");
    wrapper.id = "routeDrawSummaryWrapper";
    var div = document.createElement("div");
    div.id = "routeDrawSummary";
    div.className = "";
    var line1 = document.createElement("div");
    var line2 = document.createElement("div");
    line2.className = "routeDrawSummaryDenivele";
    var labelTransport = document.createElement("label");
    labelTransport.className = "routeDrawSummaryTransport lblRouteDrawSummaryTransport" + transport;
    line1.appendChild(labelTransport);
    var labelDuration = document.createElement("label");
    labelDuration.className = "routeDrawSummaryDuration";
    labelDuration.textContent = _utils_unit_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.convertSecondsToTime(0);
    line1.appendChild(labelDuration);
    var labelDistance = document.createElement("label");
    labelDistance.className = "routeDrawSummaryDistance";
    labelDistance.textContent = _utils_unit_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.convertDistance(0);
    line1.appendChild(labelDistance);
    var labelDPlus = document.createElement("label");
    labelDPlus.className = "routeDrawSummaryDPlus";
    labelDPlus.textContent = "0 m";
    line2.appendChild(labelDPlus);
    var labelDMinus = document.createElement("label");
    labelDMinus.className = "routeDrawSummaryDMinus";
    labelDMinus.textContent = "- 0 m";
    line2.appendChild(labelDMinus);
    div.appendChild(line1);
    div.appendChild(line2);
    wrapper.appendChild(div);
    if (!isCopy) {
      var mode = document.createElement("div");
      mode.id = "routeDrawMode";
      mode.class = "d-none";
      mode.innerText = "Saisie guidée";
      mode.addEventListener("click", () => {
        if (this.data.steps.length > 0) {
          if (this.transport === "car") {
            this.__informChangeTransportImpossible();
            return;
          }
        }
        _action_sheet__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.show({
          style: "custom",
          content: this.dom.modeSelectDom
        });
      });
      this.dom.changeMode = mode;
      wrapper.appendChild(mode);
    }
    return wrapper;
  },
  /**
   * ajoute le container sur les détails du parcours
   * @returns {DOMElement}
   * @private
   */
  __addResultsListDetailsContainerDOMElement() {
    var div = document.createElement("div");
    div.id = "routeDrawDetails";
    div.className = "";
    var profileHeader = document.createElement("p");
    profileHeader.className = "elevationLineHeader";
    profileHeader.textContent = "Profil altimétrique";
    div.appendChild(profileHeader);
    var canvasProfile = document.createElement("canvas");
    canvasProfile.id = "routedraw-elevationline";
    canvasProfile.className = "elevationLineCanvas";
    div.appendChild(canvasProfile);
    var detailsHeader = document.createElement("p");
    detailsHeader.className = "detailsHeader";
    detailsHeader.textContent = "Détails du parcours";
    div.appendChild(detailsHeader);
    this.dom.detailsList = document.createElement("div");
    this.dom.detailsList.id = "routedraw-details";
    this.dom.detailsList.className = "routedrawDetails";
    div.appendChild(this.dom.detailsList);
    div.classList.add("d-none");
    return div;
  },
  /**
   * ajoute le DOM de la modale de sélection de mode de saisie
   * @returns {DOMElement}
   * @private
   */
  __addModeSelectDOMElement() {
    var div = document.createElement("div");
    div.id = "routeDrawModeActionSheet";
    var modeSelectHTML = `
      <div>
        <div class="routeDrawModeTitle">
          <span>Mode saisie guidée</span>
          <label class="toggleSwitch">
            <input id="routeDrawModeGuided" class="toggleInput" type="checkbox" checked>
            <span class="toggleSlider"></span>
          </label>
        </div>
        <div>
          Le tracé entre deux points suit le sentier, le chemin, la route. Le mode de locomation n’est pas modifiable en cours de saisie.
        </div>
        <div id="routeDrawVehicleSelect">
          <label class="radio-wrapper">
            <span>À pied</span>
            <input id="routeDrawGuidedPedestrian" type="radio" name="routeDrawGuidedVehicule" value="foot" checked>
            <div class="radio-input"></div>
          </label>
          <label class="radio-wrapper">
            <span>Véhicule</span>
            <input id="routeDrawGuidedCar" type="radio" name="routeDrawGuidedVehicule" value="car">
            <div class="radio-input"></div>
          </label>
        </div>
      </div>
      <div>
        <div class="routeDrawModeTitle">
          <span>Mode saisie libre</span>
          <label class="toggleSwitch">
            <input id="routeDrawModeFree" class="toggleInput" type="checkbox">
            <span class="toggleSlider"></span>
          </label>
        </div>
        <div>
          Le tracé entre deux points forme une ligne droite (à pied uniquement).
        </div>
      </div>
    `;
    div.innerHTML = modeSelectHTML;
    var toggleGuided = div.querySelector("#routeDrawModeGuided");
    var toggleFree = div.querySelector("#routeDrawModeFree");
    var routeDrawVehicleSelect = div.querySelector("#routeDrawVehicleSelect");
    toggleGuided.addEventListener("change", () => {
      if (toggleGuided.checked) {
        this.changeMode(1);
        toggleFree.checked = false;
        routeDrawVehicleSelect.classList.remove("hidden");
        _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
          text: "Mode saisie guidée activé",
          duration: "short",
          position: "bottom"
        });
      } else {
        this.changeMode(0);
        toggleFree.checked = true;
        routeDrawVehicleSelect.classList.add("hidden");
        _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
          text: "Mode saisie libre (piéton) activé",
          duration: "short",
          position: "bottom"
        });
      }
    });
    toggleFree.addEventListener("change", () => {
      if (toggleFree.checked) {
        this.changeMode(0);
        toggleGuided.checked = false;
        routeDrawVehicleSelect.classList.add("hidden");
        _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
          text: "Mode saisie libre (piéton) activé",
          duration: "short",
          position: "bottom"
        });
      } else {
        this.changeMode(1);
        toggleGuided.checked = true;
        routeDrawVehicleSelect.classList.remove("hidden");
        _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
          text: "Mode saisie guidée activé",
          duration: "short",
          position: "bottom"
        });
      }
    });
    var pedestrianRadio = div.querySelector("#routeDrawGuidedPedestrian");
    var carRadio = div.querySelector("#routeDrawGuidedCar");
    pedestrianRadio.addEventListener("change", () => {
      if (pedestrianRadio.checked) {
        this.setTransport("pedestrian");
        _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
          text: "Mode saisie guidée (piéton) activé",
          duration: "short",
          position: "bottom"
        });
      } else {
        this.setTransport("car");
        _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
          text: "Mode saisie guidée (véhicule) activé",
          duration: "short",
          position: "bottom"
        });
      }
    });
    carRadio.addEventListener("change", () => {
      if (carRadio.checked) {
        this.setTransport("car");
        _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
          text: "Mode saisie guidée (véhicule) activé",
          duration: "short",
          position: "bottom"
        });
      } else {
        this.setTransport("pedestrian");
        _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
          text: "Mode saisie guidée (piéton) activé",
          duration: "short",
          position: "bottom"
        });
      }
    });
    routeDrawVehicleSelect.addEventListener("click", () => {
      if (this.data.steps.length > 0) {
        this.__informChangeTransportImpossible();
      }
    });
    return div;
  },
  /**
   * Met à jour le titre de l'itinéraire dans le dom
   * @param {String} title - titre de l'itinéraire
   * @private
   */
  __updateTitle(title) {
    this.dom.title.innerText = title;
  },
  /**
   * Met à jour les infos dans le DOM
   * @param {*} data - RouteDraw.data
   * @returns {DOMElement}
   * @private
   */
  __updateRouteInfo(data) {
    var labelDuration = this.dom.summary.querySelector(".routeDrawSummaryDuration");
    labelDuration.textContent = _utils_unit_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.convertSecondsToTime(data.duration);
    var labelDistance = this.dom.summary.querySelector(".routeDrawSummaryDistance");
    labelDistance.textContent = _utils_unit_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.convertDistance(data.distance);
    if (!this.elevationLoading) {
      var labelDPlus = this.dom.summary.querySelector(".routeDrawSummaryDPlus");
      labelDPlus.textContent = `${data.elevationData.dplus} m`;
      var labelDMinus = this.dom.summary.querySelector(".routeDrawSummaryDMinus");
      labelDMinus.textContent = `- ${data.elevationData.dminus} m`;
    }

    // Ajout du détail du parcours
    let totalSeconds = 0;
    this.dom.detailsList.innerHTML = "";
    if (data.steps.length > 0) {
      // Code facilement adaptable si on veut afficher toutes les étapes (ADDSTEPS)
      // ADDSTEPS:  i += data.points.length - 1 --> i++
      for (let i = 0; i < data.points.length; i += data.points.length - 1) {
        const waypoint = data.points[i];
        var waypointDiv = document.createElement("div");
        waypointDiv.classList.add("routeDrawWaypointDiv");
        var waypointImage = document.createElement("span");
        var waypointLabelText = "Étape";
        var waypointLabelDurationText = "";
        waypointImage.classList.add("routeDrawWaypointImg");
        if (i == 0) {
          waypointImage.classList.add("routeDrawFirstWaypointImg");
          waypointLabelText = "Point de départ";
          waypointLabelDurationText = _utils_unit_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.convertSecondsToTime(totalSeconds);
        } else if (i == data.points.length - 1) {
          waypointLabelText = "Point d'arrivée";
          waypointImage.classList.add("routeDrawLastWaypointImg");
        }
        waypointDiv.appendChild(waypointImage);
        var waypointTextDiv = document.createElement("div");
        waypointTextDiv.classList.add("routeDrawWaypointTextDiv");
        var waypointLabel = document.createElement("div");
        waypointLabel.classList.add("routeDrawWaypointLabel");
        var waypointLabelTextSpan = document.createElement("span");
        waypointLabelTextSpan.innerText = waypointLabelText;
        waypointLabel.appendChild(waypointLabelTextSpan);
        var waypointLabelDurationTextSpan = document.createElement("span");
        waypointLabelDurationTextSpan.innerText = waypointLabelDurationText;
        if (i > 0) {
          // ADDSTEPS: const step = data.steps[i - 1];
          // Ajout de la div du step
          var stepDiv = document.createElement("div");
          stepDiv.classList.add("routeDrawStepDiv");
          stepDiv.innerText = _utils_unit_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.convertDistance(data.distance) +
          // ADDSTEPS: data.distance -> step.porperties.distance
          " / " + _utils_unit_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.convertSecondsToTime(data.duration); // ADDSTEPS: data.duration -> step.porperties.duration
          this.dom.detailsList.appendChild(stepDiv);
          totalSeconds += data.duration; // ADDSTEPS: data.duration -> step.porperties.duration
          waypointLabelDurationTextSpan.innerText = _utils_unit_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.convertSecondsToTime(totalSeconds);
        }
        waypointLabel.appendChild(waypointLabelDurationTextSpan);
        waypointTextDiv.appendChild(waypointLabel);
        var waypointName = document.createElement("span");
        waypointName.classList.add("routeDrawWaypointName");
        waypointName.innerText = waypoint.properties.name;
        waypointTextDiv.appendChild(waypointName);
        waypointDiv.appendChild(waypointTextDiv);
        this.dom.detailsList.appendChild(waypointDiv);
      }
      this.dom.details.classList.remove("d-none");
    } else {
      this.dom.details.classList.add("d-none");
    }
    if (data.steps.length > 0) {
      this.dom.modeSelectDom.querySelector("#routeDrawGuidedPedestrian").disabled = true;
      this.dom.modeSelectDom.querySelector("#routeDrawGuidedCar").disabled = true;
    } else {
      this.dom.modeSelectDom.querySelector("#routeDrawGuidedPedestrian").disabled = false;
      this.dom.modeSelectDom.querySelector("#routeDrawGuidedCar").disabled = false;
    }
  },
  /**
   * bouton de calcul en mode chargement
   * @private
   */
  __setElevationLoading() {
    var loadingImgHtml = `<img src="${_css_assets_loading_darkgrey_svg__WEBPACK_IMPORTED_MODULE_3__}" height="12px">`;
    var labelDPlus = this.dom.summary.querySelector(".routeDrawSummaryDPlus");
    labelDPlus.innerHTML = `${loadingImgHtml} m`;
    var labelDMinus = this.dom.summary.querySelector(".routeDrawSummaryDMinus");
    labelDMinus.innerHTML = `- ${loadingImgHtml} m`;
  },
  /**
   * bouton de calcul: fin du chargement
   * @private
   */
  __unsetElevationLoading() {
    console.debug("Profil alti loaded");
  },
  __informChangeTransportImpossible() {
    let msg = "Vous avez choisi le mode de locomotion véhicule. Vous ne pouvez pas le modifier en cours de saisie.";
    if (this.transport === "pedestrian") {
      msg = "Vous avez choisi le mode de locomotion piéton. Vous ne pouvez pas le modifier en cours de saisie.";
    }
    _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
      text: msg,
      duration: "short",
      position: "bottom"
    });
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RouteDrawDOM);

/***/ }),

/***/ 60:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2116);
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5608);
/* harmony import */ var _utils_popup_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1820);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_0__]);
var __webpack_async_dependencies_result__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
_globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_async_dependencies_result__[0];
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */





/**
 * Indicateur d'activité du Plan IGN interactif et des couches thématiques sur la carte
 */
var _InteractivityIndicator_brand = /*#__PURE__*/new WeakSet();
class InteractivityIndicator {
  /**
   * constructeur
   * @param {*} map
   * @param {*} options
   */
  constructor(map, options) {
    /**
       * Ecouteurs sur :
       * - gestion des ajout / suppression / position des couches
       * - si zooms > piiMinZoom actif pour la couche PII
       * - la couche au dessus est elle un baseLayer ?
       */
    _classPrivateMethodInitSpec(this, _InteractivityIndicator_brand);
    this.options = options || {
      id: "PLAN.IGN.INTERACTIF$TMS"
    };
    this.shown = null;
    this.hardDisabled = false;
    this.map = map;
    this.id = this.options.id || "PLAN.IGN.INTERACTIF$TMS"; // PII

    _assertClassBrand(_InteractivityIndicator_brand, this, _listen).call(this);

    // Do not clear highlighted feature this time
    this.dontClear = false;
    this.pii = false; // couche PII chargée ?
    this.thematic = false; // couche thematic chargée ?
    this.position = false; // couche en position max ?

    this.piiMinZoom = 15; // zoom mini pour l'interactivité

    this.popup = {
      popup: null
    };

    // Timeouts pour l'animation
    this.timeoutID1 = null;
    this.timeoutID2 = null;
    this.timeoutID3 = null;
    return this;
  }
  /**
   * callback on map zoom
   * @param {Object} e event
   */
  onZoom(e) {
    if (this.hardDisabled) {
      return;
    }
    if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.online) {
      return;
    }
    if (this.pii && this.position && Math.floor(e.target.getZoom()) >= this.piiMinZoom) {
      this.active();
    } else {
      this.dontClear = true;
      this.thematic && this.position ? this.active() : this.disable();
    }
  }

  /**
     * callback
     * @param {*} e
     * @private
     */
  onGetLastLayer(e) {
    if (this.hardDisabled) {
      return;
    }
    var layer = e.detail.entries.pop();
    if (!layer) {
      return;
    }
    this.thematic = this.pii = this.position = false;
    if (layer[0] === this.id && layer[1].visibility) {
      this.pii = true;
      this.position = true;
      if (this.hardDisabled) {
        return;
      }
      if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.online) {
        return;
      }
      if (Math.floor(this.map.getZoom()) >= this.piiMinZoom) {
        this.active();
      } else {
        this.disable();
      }
    } else {
      if (layer[1].base && layer[1].visibility) {
        this.disable();
      } else {
        e.detail.entries.push(layer);
        e.detail.entries.forEach(layer => {
          if (layer[1].base && layer[1].visibility) {
            this.pii = false;
            if (layer[0] === this.id) {
              this.pii = true;
            }
            this.thematic = false;
            return;
          }
          if (layer[1].interactive && layer[1].visibility && _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.online) {
            this.thematic = true;
          }
        });
        this.position = true;
        if (this.thematic || this.pii && Math.floor(this.map.getZoom()) >= this.piiMinZoom) {
          this.active();
        } else {
          this.disable();
        }
      }
    }
  }

  /**
   * Active l'indicateur d'activité
   */
  active() {
    this.hardDisabled = false;
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("d-none");
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("noOpacity");
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("textColor");
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("widthOff");
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("backgroundWhite");
    document.getElementById("interactivityBtnText").innerText = "La carte est interactive";
    if (!this.shown) {
      clearTimeout(this.timeoutID1);
      clearTimeout(this.timeoutID2);
      clearTimeout(this.timeoutID3);
      this.timeoutID1 = setTimeout(() => {
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.add("backgroundGreen");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.add("widthOn");
        this.timeoutID2 = setTimeout(() => {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("widthOn");
          this.timeoutID3 = setTimeout(() => {
            _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("backgroundGreen");
          }, 450);
        }, 2000);
      }, 50);
    }
    this.shown = true;
  }

  /**
   * Desactive l'indicateur d'activité
   */
  disable() {
    document.getElementById("interactivityBtnText").innerText = "La carte n'est plus interactive";
    if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.mapInteractivity) {
      return;
    }
    if (!this.dontClear) {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.mapInteractivity.clear();
    }
    this.dontClear = false;
    if (this.shown) {
      clearTimeout(this.timeoutID1);
      clearTimeout(this.timeoutID2);
      clearTimeout(this.timeoutID3);
      this.timeoutID1 = setTimeout(() => {
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.add("textColor");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.add("backgroundWhite");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("backgroundGreen");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.add("widthOff");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("widthOn");
        this.timeoutID2 = setTimeout(() => {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("widthOff");
          this.timeoutID3 = setTimeout(() => {
            _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.remove("backgroundWhite");
            _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$interactivityBtn.classList.add("noOpacity");
          }, 450);
        }, 2400);
      }, 50);
    }
    this.shown = false;
  }

  /**
   * Desactive l'indicateur d'activité jusqu'à nouvel ordre
   */
  hardDisable() {
    this.hardDisabled = true;
    this.disable();
  }

  /**
   * Réactive l'indicateur après désactivation forcée
   */
  enable() {
    this.hardDisabled = false;
    this.map.fire("zoom");
  }

  /**
   * affiche la popup explicative
   * @public
   */
  showPopup() {
    if (!this.shown) {
      return;
    }
    // on supprime la popup
    _utils_popup_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.showPopup(`
      <div id="interactivityPopup">
          <div class="divPositionTitle">La carte est interactive</div>
          <div class="divPopupClose" onclick="onCloseinteractivityPopup(event)"></div>
          <div class="divPopupContent">
          Cliquez sur le plan IGN ou sur une donnée thématique pour afficher la légende ou des informations détaillées (ex : les caractéristiques d’un bâtiment, la culture d’un champ).
          </div>
      </div>
      `, this.map, "interactivityPopup", "onCloseinteractivityPopup", this.popup);
  }
}
function _listen() {
  this.onGetLastLayer = this.onGetLastLayer.bind(this);
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.manager.addEventListener("addlayer", this.onGetLastLayer);
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.manager.addEventListener("removelayer", this.onGetLastLayer);
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.manager.addEventListener("movelayer", this.onGetLastLayer);
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.manager.addEventListener("layervisibility", this.onGetLastLayer);
  this.onZoom = this.onZoom.bind(this);
  this.map.on("zoom", this.onZoom);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InteractivityIndicator);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 61:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2116);
/* harmony import */ var _layer_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(960);
/* harmony import */ var _html_img_image_not_found_png__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2841);
/* harmony import */ var _html_img_3D_BUILDINGS_jpg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2345);
/* harmony import */ var _html_img_3D_TERRAIN_jpg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8669);
/* harmony import */ var _utils_dom_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8554);
/* harmony import */ var _capacitor_toast__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2472);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_0__, _layer_config__WEBPACK_IMPORTED_MODULE_1__]);
([_globals__WEBPACK_IMPORTED_MODULE_0__, _layer_config__WEBPACK_IMPORTED_MODULE_1__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */









/**
 * Gestion des couches thématiques et fonds de carte
 * @fires addlayer
 * @fires addlayeroptions
 * @fires removelayer
 * @description
 *      → manager
 *      	→ instancie this.catalogue & this.switcher
 *     	→ ecouteurs sur les events
 *	      	* addLayer
 *	      	   → this.catalogue → call this.switcher.addLayer
 *	      	   → this.switcher → call this.updateCounter
 *	      	* removeLayer
 *	      	   → this.catalogue → call this.switcher.removeLayer
 *	      	   → this.switcher → call this.updateCounter
 *      	→ loader de couches par defaut
 *         		→ call this.catalogue.addLayer
 *
 *      → catalogue
 *        	→ this.addLayer → call add interface → fire event addLayer
 *        	→ this.removeLayer → call remove interface → fire event removeLayer
 *      → switcher
 *        	→ this.addLayer → call addContainer & addGroup & map.addLayer → fire event addLayer
 *       	→ this.removeLayer → call removeContainer & removeGroup & map.removeLayer → fire event removeLayer
 *        	→ this.moveLayer → call moveContainer & moveGroup & map.moveLayer
 */
var _LayerCatalogue_brand = /*#__PURE__*/new WeakSet();
class LayerCatalogue extends EventTarget {
  /**
   * constructeur
   * @param {*} options
   * @param {*} options.target
   */
  constructor(options) {
    super();
    /**
     * Rendu
     */
    _classPrivateMethodInitSpec(this, _LayerCatalogue_brand);
    this.options = options || {
      target: null
    };

    // options ?
    this.map = _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.map;
    _assertClassBrand(_LayerCatalogue_brand, this, _render).call(this);
    _assertClassBrand(_LayerCatalogue_brand, this, _listeners).call(this);
  }
  /**
   * Ajout de 2 faux "Layers" 3D qui n'apparaissent pas dans le Layer Switcher et du bouton 3D pour les filtrer
   * - Bâtiments 3D
   * - Relief
   */
  add3DThematicLayers() {
    var target = this.options.target || document.getElementById("layer-thematics");
    if (!target) {
      console.warn();
      return;
    }
    var container = document.createElement("div");
    container.classList.add("small-layers");
    var buildings3DLayerHtml = `
      <div class="layer smallLayer" id="3D.BUILDINGS">
        <div class="layerImg">
          <img src="${_html_img_3D_BUILDINGS_jpg__WEBPACK_IMPORTED_MODULE_3__}" alt="Bâtiments 3D" onerror="this.onerror=null;this.src='${_html_img_image_not_found_png__WEBPACK_IMPORTED_MODULE_2__}'" />
        </div>
        <div id="3d-buildings" class="layer-title"><span>Bâtiments 3D</span><span class="beta">BÊTA</span></div>
      </div>
      `;
    var buildings3DLayerElement = _utils_dom_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.stringToHTML(buildings3DLayerHtml.trim());
    buildings3DLayerElement.addEventListener("click", () => {
      if (buildings3DLayerElement.classList.contains("selectedLayer")) {
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.threeD.remove3dBuildings();
        buildings3DLayerElement.classList.remove("selectedLayer");
      } else {
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.threeD.add3dBuildings();
        buildings3DLayerElement.classList.add("selectedLayer");
      }
    });
    container.appendChild(buildings3DLayerElement);
    var terrainLayerHtml = `
      <div class="layer smallLayer" id="3D.TERRAIN">
        <div class="layerImg">
          <img src="${_html_img_3D_TERRAIN_jpg__WEBPACK_IMPORTED_MODULE_4__}" alt="Relief 3D" onerror="this.onerror=null;this.src='${_html_img_image_not_found_png__WEBPACK_IMPORTED_MODULE_2__}'" />
        </div>
        <div id="3d-terrain" class="layer-title"><span>Relief 3D</span><span class="beta">BÊTA</span></div>
      </div>
      `;
    var terrainLayerElement = _utils_dom_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.stringToHTML(terrainLayerHtml.trim());
    terrainLayerElement.addEventListener("click", () => {
      if (terrainLayerElement.classList.contains("selectedLayer")) {
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.threeD.remove3dTerrain();
        terrainLayerElement.classList.remove("selectedLayer");
      } else {
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.threeD.add3dTerrain();
        terrainLayerElement.classList.add("selectedLayer");
      }
    });
    container.appendChild(terrainLayerElement);
    target.querySelector(".layer-thematics").insertBefore(container, target.querySelector("#baseLayers").nextSibling);
  }

  /**
   * Ecouteurs
   */

  /**
   * Ajout de la couche de fonds ou de données sur la carte
   * @param {*} layerName
   * @param {boolean} isTempLayer - true si la couche est temporaire
   * @fires addlayer
   * @public
   */
  addLayer(layerName) {
    let isTempLayer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    if (!layerName) {
      return;
    }
    var element = document.getElementById(layerName);
    element.classList.add("selectedLayer");
    const defaultOpacity = parseFloat(element.dataset.defaultopacity) || 100;

    /**
     * Evenement "addlayer"
     * @event addlayer
     * @type {*}
     * @property {*} id -
     */
    this.dispatchEvent(new CustomEvent("addlayer", {
      bubbles: true,
      detail: {
        id: layerName,
        isTempLayer: isTempLayer,
        defaultOpacity: defaultOpacity
      }
    }));
  }

  /**
   * Ajout de la couche de fonds ou de données sur la carte avec paramètres d'opacité, visibilité et n&b
   * @param {*} layerOptions
   * @fires addlayeroptions
   * @public
   */
  addLayerOptions(layerOptions) {
    if (!layerOptions.id) {
      return;
    }
    var element = document.getElementById(layerOptions.id);
    element.classList.add("selectedLayer");
    layerOptions.isLayerOptions = true; // pour différencier de l'event addLayer
    /**
     * Evenement "addlayer"
     * @event addlayeroptions
     * @type {*}
     * @property {*} id -
     */
    this.dispatchEvent(new CustomEvent("addlayeroptions", {
      bubbles: true,
      detail: layerOptions
    }));
  }

  /**
   * Suppression d'une couche
   * @param {*} layerName
   * @fires removelayer
   * @public
   */
  removeLayer(layerName) {
    let isTempLayer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    if (!layerName) {
      return;
    }
    // Comptage du nombre de fonds de plan affichés
    let nbBaseLayers = 0;
    document.querySelectorAll(".baseLayer").forEach(el => {
      if (el.classList.contains("selectedLayer")) {
        nbBaseLayers++;
      }
    });
    // Si le layer a enlever est le dernier fond de plan, on ne fait rien
    // On n'affiche le message que si c'est l'utilisateur qui a fait l'action
    // (si on est en mode "myaccount", c'est le téléchargeur de carte qui est à l'origine du clic)
    if (!isTempLayer && _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getLayerProps(layerName).base && nbBaseLayers === 1 && _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState !== "myaccount") {
      _capacitor_toast__WEBPACK_IMPORTED_MODULE_6__/* .Toast */ .y.show({
        text: "Impossible d'enlever le seul fond de carte",
        duration: "short",
        position: "bottom"
      });
      return;
    }
    // Si on est hors ligne : impossible d'enlever Plan IGN
    // (si on est en mode "myaccount", c'est le téléchargeur de carte qui est à l'origine du clic)
    if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.online && layerName === "PLAN.IGN.INTERACTIF$TMS" && _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState !== "myaccount") {
      _capacitor_toast__WEBPACK_IMPORTED_MODULE_6__/* .Toast */ .y.show({
        text: "Impossible d'enlever le Plan IGN en mode hors-ligne",
        duration: "short",
        position: "bottom"
      });
      return;
    }
    var element = document.getElementById(layerName);
    element.classList.remove("selectedLayer");

    /**
     * Evenement "removelayer"
     * @event removelayer
     * @type {*}
     * @property {*} id -
     */
    this.dispatchEvent(new CustomEvent("removelayer", {
      bubbles: true,
      detail: {
        id: layerName,
        isTempLayer: isTempLayer
      }
    }));
  }
}
function _render() {
  var target = this.options.target || document.getElementById("layer-thematics");
  if (!target) {
    console.warn();
    return;
  }
  const tplLayer = opts => {
    const defaultOpacity = opts.defaultOpacity || 100;
    return `
      <div class="layer ${opts.type}" id="${opts.layerID}" data-defaultopacity="${defaultOpacity}">
        <div class="layerImg">
          <img src="${opts.layerQuickLook}" alt="${opts.layerTitle}" onerror="this.onerror=null;this.src='${_html_img_image_not_found_png__WEBPACK_IMPORTED_MODULE_2__}'" />
          <div class="layer-badge"></div>
          <div class="layer-interactive-badge-${opts.interactive}" ></div>
        </div>
        <div class="layer-title-thematic">${opts.layerThematic}</div>
        <div id="${opts.layerName}" class="layer-title">${opts.layerTitle}</div>
      </div>
      `;
  };
  var strBaseLayers = "";
  var baseLayers = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getBaseLayers();
  var props;
  for (let i = 0; i < baseLayers.length; i++) {
    props = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getLayerProps(baseLayers[i]);
    strBaseLayers += tplLayer({
      type: "baseLayer",
      layerID: baseLayers[i],
      layerName: props.layer,
      layerQuickLook: props.quickLookUrl || _html_img_image_not_found_png__WEBPACK_IMPORTED_MODULE_2__,
      layerTitle: props.title,
      layerThematic: "",
      interactive: props.interactive,
      defaultOpacity: props.defaultOpacity || 100
    });
  }
  var strThematicButtons = "";
  var strThematicLayers = "";
  var thematicButtons = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getThematics();
  var tempLayers = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getTempLayers();
  if (tempLayers.length > 0) {
    for (let k = 0; k < tempLayers.length; k++) {
      var tempLayer = tempLayers[k];
      strThematicLayers += tplLayer({
        type: "thematicLayer tempLayer layer-hidden",
        // liste cachée par defaut !
        layerID: tempLayer.id,
        layerName: tempLayer.name,
        layerQuickLook: tempLayer.quickLookUrl,
        layerTitle: tempLayer.name,
        layerThematic: "Évènements",
        interactive: true,
        defaultOpacity: tempLayer.defaultOpacity || 100
      });
    }
  }
  for (let l = 0; l < thematicButtons.length; l++) {
    const name = thematicButtons[l];
    strThematicButtons += `
      <button class="thematicButton" data-name="${name}">
        ${name}
      </button>
      `;
    if (tempLayers.length > 0 && l == 0) {
      strThematicButtons += `
        <button class="thematicButton" data-name="Évènements">
          Événements
        </button>
        `;
    }
  }
  var thematicLayers = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getThematicLayers();
  for (let k = 0; k < thematicLayers.length; k++) {
    props = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getLayerProps(thematicLayers[k]);
    var thematic = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getThematicByLayerID(thematicLayers[k]);
    strThematicLayers += tplLayer({
      type: "thematicLayer layer-hidden",
      // liste cachée par defaut !
      layerID: thematicLayers[k],
      layerName: props.layer,
      layerQuickLook: props.quickLookUrl || _html_img_image_not_found_png__WEBPACK_IMPORTED_MODULE_2__,
      layerTitle: props.title,
      layerThematic: thematic,
      interactive: props.interactive,
      defaultOpacity: props.defaultOpacity || 100
    });
  }
  var template = `
    <div class="layer-thematics">
      <h4 id="baseLayersLabel">Fonds de carte</h4>
      <div class="subCatMenu" id="baseLayers">
        ${strBaseLayers}
        <div id="baseLayersAfter" tabindex="0" title="Faire défiler le menu"><div></div></div>
      </div>
      <hr />
      <h4 id="thematicLayersLabel">Données thématiques</h4>
      <div class="subCatButton" id="thematicButtons">
        ${strThematicButtons}
        <div id="subCatButtonAfter" tabindex="0" title="Faire défiler le menu"><div></div></div>
      </div>
      <div class="subCatMenu" id="thematicLayers">
        ${strThematicLayers}
      </div>
    </div>`;

  // transformation du container : String -> DOM
  var container = _utils_dom_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.stringToHTML(template.trim());
  if (!container) {
    console.warn();
    return;
  }
  target.appendChild(container);
}
function _listeners() {
  // clic sur une couche de fonds
  document.querySelectorAll(".baseLayer").forEach(el => {
    el.addEventListener("click", () => {
      if (el.classList.contains("selectedLayer")) {
        this.removeLayer(el.id);
      } else {
        this.addLayer(el.id);
      }
    });
  });
  // clic sur une couche thematique
  document.querySelectorAll(".thematicLayer").forEach(el => {
    el.addEventListener("click", () => {
      let isTempLayer = false;
      if (el.classList.contains("tempLayer")) {
        isTempLayer = true;
      }
      if (el.classList.contains("selectedLayer")) {
        this.removeLayer(el.id, isTempLayer);
      } else {
        this.addLayer(el.id, isTempLayer);
      }
    });
  });
  // clic sur un bouton thematique
  document.querySelectorAll(".thematicButton").forEach(el => {
    // INFO
    // Execution de l'ecouteur sur un clic bouton thématique :
    // - modifie le style des boutons
    // - recherche toutes les couches afin de les rendre 'hidden'
    // - recherche des couches du theme demandé
    // - supprime la classe 'hidden' des ID des couches demandées
    el.addEventListener("click", e => {
      var buttons = document.querySelectorAll(".thematicButton");
      for (let h = 0; h < buttons.length; h++) {
        const element = buttons[h];
        element.classList.remove("thematic-button-active");
      }
      var layers = document.querySelectorAll(".thematicLayer");
      for (let i = 0; i < layers.length; i++) {
        const element = layers[i];
        element.classList.add("layer-hidden");
      }
      var layersId = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getLayersByThematic(e.target.dataset.name);
      for (let j = 0; j < layersId.length; j++) {
        const id = layersId[j];
        var element = document.getElementById(id);
        element.classList.remove("layer-hidden");
      }
      e.target.classList.add("thematic-button-active");
    });
    if (el.getAttribute("data-name") == "Tous") {
      el.click();
    }
  });
  document.getElementById("baseLayersAfter").addEventListener("click", _utils_dom_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.horizontalParentScroll);
  document.getElementById("baseLayersAfter").parentElement.addEventListener("scroll", _utils_dom_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.horizontalParentScrollend);
  document.getElementById("subCatButtonAfter").addEventListener("click", _utils_dom_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.horizontalParentScroll);
  document.getElementById("subCatButtonAfter").parentElement.addEventListener("scroll", _utils_dom_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.horizontalParentScrollend);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LayerCatalogue);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 73:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2116);
/* harmony import */ var _layer_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(960);
/* harmony import */ var _layer_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9583);
/* harmony import */ var _action_sheet__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1194);
/* harmony import */ var sortablejs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9404);
/* harmony import */ var _html_img_image_not_found_png__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2841);
/* harmony import */ var _html_img_legend_not_found_png__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5773);
/* harmony import */ var _utils_dom_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8554);
/* harmony import */ var _capacitor_toast__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(2472);
/* harmony import */ var _capacitor_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(5036);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_0__, _layer_config__WEBPACK_IMPORTED_MODULE_1__, _layer_group__WEBPACK_IMPORTED_MODULE_2__]);
([_globals__WEBPACK_IMPORTED_MODULE_0__, _layer_config__WEBPACK_IMPORTED_MODULE_1__, _layer_group__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */












/**
 * Gestionnaire de couches
 * @fires addlayer
 * @fires removelayer
 * @fires movelayer
 * @description
 *      → manager
 *      	→ instancie this.catalogue & this.switcher
 *     	→ ecouteurs sur les events
 *	      	* addLayer
 *	      	   → this.catalogue → call this.switcher.addLayer
 *	      	   → this.switcher → call this.updateCounter
 *	      	* removeLayer
 *	      	   → this.catalogue → call this.switcher.removeLayer
 *	      	   → this.switcher → call this.updateCounter
 *      	→ loader de couches par defaut
 *         		→ call this.catalogue.addLayer
 *
 *      → catalogue
 *        	→ this.addLayer → call add interface → fire event addLayer
 *        	→ this.removeLayer → call remove interface → fire event removeLayer
 *      → switcher
 *        	→ this.addLayer → call addContainer & addGroup & map.addLayer → fire event addLayer
 *       	  → this.removeLayer → call removeContainer & removeGroup & map.removeLayer → fire event removeLayer
 *        	→ this.moveLayer → call moveContainer & moveGroup & map.moveLayer
 *        	→ this.layervisibility
 */
var _LayerSwitcher_brand = /*#__PURE__*/new WeakSet();
class LayerSwitcher extends EventTarget {
  /**
    * constructeur
    * @param {*} options
    * @param {*} options.target
    */
  constructor(options) {
    super();
    /**
       * Rendu
       */
    _classPrivateMethodInitSpec(this, _LayerSwitcher_brand);
    this.options = options || {
      target: null
    };

    // TODO
    // options d'ajout de couches
    // avec un test si la couche est déjà disponible sur la carte

    this.target = this.options.target || document.getElementById("layer-switcher");
    this.map = _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.map;

    // id unique et incremental pour faire la liaison entre le DOM et this.layers
    this.index = -1;

    /**
       * Options des couches avec position
       * {
       *   id : {
       *    title : "",
       *    quickLookUrl : "",
       *    opacity : 100,
       *    gray : true,
       *    visibility : true,
       *    index : 0,
       *    position : 0,
       *    type: "vector",
       *    base: true, // base ou thematic
       *    style: "http://.../style.json" ou [],
       *    error : false
       *   }
       * }
       */
    this.layers = {};
    _assertClassBrand(_LayerSwitcher_brand, this, _render).call(this);
  }
  /**
   * Ajout d'une couche dans le gestionnaire
   * @param {*} layerOptions
   * @fires addlayer
   * @public
   */
  async addLayer(layerOptions) {
    const id = layerOptions.id;
    var props;
    if (layerOptions.isTempLayer) {
      props = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getTempLayerProps(id);
    } else {
      props = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getLayerProps(id);
    }
    this.index++;
    this.layers[id] = {
      title: props.title,
      quickLookUrl: props.quickLookUrl ? props.quickLookUrl : _html_img_image_not_found_png__WEBPACK_IMPORTED_MODULE_5__,
      legendUrl: props.legendUrl ? props.legendUrl : _html_img_legend_not_found_png__WEBPACK_IMPORTED_MODULE_6__,
      style: props.style,
      fallbackStyle: props.fallbackStyle,
      type: props.type,
      base: props.base,
      opacity: layerOptions.opacity,
      gray: layerOptions.gray,
      visibility: layerOptions.visible,
      index: this.index,
      position: this.index,
      // cf. #updatePosition()
      error: false,
      maxNativeZoom: props.maxNativeZoom,
      minNativeZoom: props.minNativeZoom,
      interactive: props.interactive,
      format: props.format,
      layerType: props.layerType ? props.layerType : props.type,
      layerDef: props.layerDef ? props.layerDef : {},
      isTempLayer: layerOptions.isTempLayer || false
    };
    _assertClassBrand(_LayerSwitcher_brand, this, _addLayerContainer).call(this, id);
    try {
      await _assertClassBrand(_LayerSwitcher_brand, this, _addLayerMap).call(this, id);
      _assertClassBrand(_LayerSwitcher_brand, this, _updatePosition).call(this, id);
      _assertClassBrand(_LayerSwitcher_brand, this, _setOpacity).call(this, id, layerOptions.opacity);
      if (layerOptions.gray) {
        _assertClassBrand(_LayerSwitcher_brand, this, _setColor).call(this, id, !layerOptions.gray);
      }
      _assertClassBrand(_LayerSwitcher_brand, this, _setVisibility).call(this, id, layerOptions.visible);
      // Cas particulier : ajout de l'ombrage à plan IGN si la 3D est activée
      if (id === "PLAN.IGN.INTERACTIF$TMS" && _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.threeD && _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.threeD.terrainOn) {
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.threeD.addHillShadeToPlanIgn();
      }
      /**
       * Evenement "addlayer"
       * @event addlayer
       * @type {*}
       * @property {*} id -
       * @property {*} options -
       */
      this.dispatchEvent(new CustomEvent("addlayer", {
        bubbles: true,
        detail: {
          id: id,
          options: this.layers[id],
          entries: this.getLayersOrder()
        }
      }));

      // Déplacement du base layer juste au-dessus d'un autre base layer pour garder visible les couches de données
      if (!layerOptions.isLayerOptions && props.base) {
        let highestBaseLayer = {
          position: -1
        };
        let highestBaseLayerId = null;
        for (const key in this.layers) {
          if (key === id) {
            continue;
          }
          if (this.layers[key].base) {
            if (this.layers[key].position > highestBaseLayer.position) {
              highestBaseLayer = this.layers[key];
              highestBaseLayerId = key;
            }
          }
        }
        if (highestBaseLayerId !== null) {
          const maxPosition = Object.keys(this.layers).length - 1;
          const index = _assertClassBrand(_LayerSwitcher_brand, this, _getIndex).call(this, id);
          const container = document.getElementById("container_ID_" + index);
          const idexOther = _assertClassBrand(_LayerSwitcher_brand, this, _getIndex).call(this, highestBaseLayerId);
          const otherContainer = document.getElementById("container_ID_" + idexOther);
          // En mode offline : on ne met pas plan IGN au-dessus du plus haut fond de plan, mais juste en dessous
          if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.online && id === "PLAN.IGN.INTERACTIF$TMS") {
            document.getElementById("lst-layer-switcher").insertBefore(container, otherContainer.nextSibling);
            _assertClassBrand(_LayerSwitcher_brand, this, _setPosition).call(this, id, maxPosition - highestBaseLayer.position, maxPosition - this.layers[id].position);
          } else {
            document.getElementById("lst-layer-switcher").insertBefore(container, otherContainer);
            _assertClassBrand(_LayerSwitcher_brand, this, _setPosition).call(this, id, maxPosition - (highestBaseLayer.position + 1), maxPosition - this.layers[id].position);
          }
        }
      }
    } catch (e) {
      this.layers[id].error = true;
      throw e;
    }
  }

  /**
     * Supprime une couche du gestionnaire
     * @param {*} id
     * @fires removelayer
     * @public
     */
  removeLayer(id) {
    let isTempLayer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    // Comptage du nombre de fonds de plan affichés
    let nbBaseLayers = 0;
    // eslint-disable-next-line no-unused-vars
    for (const [_, layer] of Object.entries(this.layers)) {
      if (layer.base) {
        nbBaseLayers++;
      }
    }
    // Si le layer a enlever est le dernier fond de plan, on ne fait rien
    // On n'affiche le message que si c'est l'utilisateur qui a fait l'action
    // (si on est en mode "myaccount", c'est le téléchargeur de carte qui est à l'origine du clic)
    if (!isTempLayer && _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getLayerProps(id).base && nbBaseLayers === 1 && _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState !== "myaccount") {
      _capacitor_toast__WEBPACK_IMPORTED_MODULE_8__/* .Toast */ .y.show({
        text: "Impossible d'enlever le seul fond de carte",
        duration: "short",
        position: "bottom"
      });
      return;
    }
    // Si on est hors ligne : impossible d'enlever Plan IGN
    // (si on est en mode "myaccount", c'est le téléchargeur de carte qui est à l'origine du clic)
    if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.online && id === "PLAN.IGN.INTERACTIF$TMS" && _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState !== "myaccount") {
      _capacitor_toast__WEBPACK_IMPORTED_MODULE_8__/* .Toast */ .y.show({
        text: "Impossible d'enlever le Plan IGN en mode hors-ligne",
        duration: "short",
        position: "bottom"
      });
      return;
    }
    var berror = this.layers[id].error;
    _assertClassBrand(_LayerSwitcher_brand, this, _removeLayerMap).call(this, id);
    _assertClassBrand(_LayerSwitcher_brand, this, _removeLayerContainer).call(this, id);
    delete this.layers[id];
    _assertClassBrand(_LayerSwitcher_brand, this, _updatePosition).call(this);

    /**
       * Evenement "removelayer"
       * @event removelayer
       * @type {*}
       * @property {*} id -
       * @property {*} error -
       */
    this.dispatchEvent(new CustomEvent("removelayer", {
      bubbles: true,
      detail: {
        id: id,
        error: berror,
        entries: this.getLayersOrder()
      }
    }));
  }

  /**
     *
     * @returns Liste des couches ordonnées
     */
  getLayersOrder() {
    const entries = Object.entries(this.layers);
    entries.sort((a, b) => {
      return a[1].position - b[1].position;
    });
    return entries;
  }
}
function _render() {
  var container = document.createElement("div");
  container.id = "lst-layer-switcher";
  container.className = "lst-layer-switcher";
  if (!container) {
    console.warn();
    return;
  }

  // ajout du container
  this.target.appendChild(container);

  // dragn'drop !
  sortablejs__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Ay.create(container, {
    handle: ".handle-draggable-layer",
    draggable: ".draggable-layer",
    animation: 200,
    forceFallback: true,
    // Call event function on drag and drop
    onEnd: evt => {
      var index = evt.item.id.substring(evt.item.id.lastIndexOf("_") + 1);
      var id = _assertClassBrand(_LayerSwitcher_brand, this, _getId).call(this, parseInt(index, 10));
      _assertClassBrand(_LayerSwitcher_brand, this, _setPosition).call(this, id, evt.newDraggableIndex, evt.oldDraggableIndex);
    }
  });
}
/**
   * Obtenir le nom de la couche à partir de son numero d'indexe
   * @param {*} index
   * @returns
   */
function _getId(index) {
  var id = null;
  for (const key in this.layers) {
    if (Object.hasOwnProperty.call(this.layers, key)) {
      const i = this.layers[key].index;
      if (i === index) {
        id = key;
        break;
      }
    }
  }
  return id;
}
/**
   * Obtenir le numero d'indexe à partir du nom de la couche
   * @param {*} id
   * @returns
   */
function _getIndex(id) {
  return this.layers[id].index;
}
/**
   * Position de la couche dans le gestionnaire
   * @param {*} id
   * @param {*} newIndex
   * @param {*} oldIndex
   */
function _setPosition(id, newIndex, oldIndex) {
  // position :
  // * ordre natif à mapbox
  // > cad même position dans le fichier de style !
  // idx pos style
  //  0   0   0 la couche de fonds
  //  1   1   1 la couche intermediaire
  //  2   2   2 la couche la plus au dessus

  // Mais on prévoit un ordre inversé dans le gestionnaire !
  // idx pos style
  //  0   2   2 la couche la plus au dessus
  //  1   1   1 la couche intermediaire
  //  2   0   0 la couche de fonds

  // [
  //   id1 → pos3
  //   id2 → pos2 < newPosition : 2 --> id2 pos-- 1
  //   id3 → pos1 |  id3 pos-- 0
  //   id3 → pos1 |  id3 pos-- 0     oldPosition < newPosition
  //   id3 → pos1 |  id3 pos-- 0
  //   id4 → pos0 ^ oldPosition : 0 --> id4 newPosition 2
  // ]
  // [
  //   id1 → pos3
  //   id2 → pos2 ˇ oldPosition : 2 --> id2 newPosition 0
  //   id3 → pos1 |  id3 pos++ 2
  //   id3 → pos1 |  id3 pos++ 2     oldPosition > newPosition
  //   id3 → pos1 |  id3 pos++ 2
  //   id4 → pos0 < newPosition : 0 --> id4 pos++ 1
  // ]
  if (typeof oldIndex !== "undefined") {
    var maxPosition = Object.keys(this.layers).length - 1;
    var newPosition = maxPosition - newIndex;
    var oldPosition = maxPosition - oldIndex;
    var direction = 1; // sens de deplacement (vers le haut ou bas)
    this.layers[id].position = newPosition;
    for (const e in this.layers) {
      if (Object.hasOwnProperty.call(this.layers, e)) {
        const o = this.layers[e];
        if (oldPosition < newPosition) {
          direction = 1; // deplacement vers le haut
          if (o.position > oldPosition && o.position <= newPosition && e !== id) {
            o.position--; // on decremente de +1 la position des couches situées en dessous + celle que l'on replace
          }
        } else if (oldPosition > newPosition) {
          direction = 0; // deplacement vers le bas
          if (o.position < oldPosition && o.position >= newPosition && e !== id) {
            o.position++; // on incremente de +1 la position des couches situées au dessus + celle que l'on replace
          }
        }
      }
    }
    // INFO
    // les couches raster possedent un seul style,
    // on associe donc position dans le style et position dans le gestionnaire.
    // pour le vecteur tuilé, il faut determiner le nombre de styles pour chaque position.
    var beforeIdx = _assertClassBrand(_LayerSwitcher_brand, this, _getIndexLayer).call(this, newPosition + direction);
    var beforeId = this.map.getStyle().layers[beforeIdx].id;
    _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.moveGroup(id, beforeId);
    /**
       * Evenement "movelayer"
       * @event movelayer
       * @type {*}
       * @property {*} id -
       * @property {*} positions -
       */
    this.dispatchEvent(new CustomEvent("movelayer", {
      bubbles: true,
      detail: {
        id: id,
        entries: this.getLayersOrder(),
        positions: {
          new: newPosition,
          old: oldPosition,
          max: maxPosition
        }
      }
    }));
  }
}
/**
 *
 * @param {*} pos position du layer group (style maplibre) ou layer (raster)
 * @returns index réel du groupe ou du layer dans le style de la map
 */
// INFO
// les couches raster possedent un seul style,
// on associe donc position dans le style et position dans le gestionnaire.
// pour le vecteur tuilé, il faut determiner le nombre de styles pour chaque position.
function _getIndexLayer(pos) {
  var index = 0;
  if (pos === 0) {
    index = 0;
  } else {
    const entries = Object.entries(this.layers);
    for (let i = 0; i < pos; i++) {
      const id = entries.find(e => {
        return e[1].position === i;
      })[0];
      index += _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.getGroupLayers(id).length;
    }
  }
  return index;
}
/**
 * Mise à jour des positions dans le gestionnaire et les styles
 * lors de l'ajout ou suppression d'une couche
 * @param {*} id
 */
function _updatePosition(id) {
  // 1. redefinition des positions dans le gestionnaire
  // - on transforme un obj -> array
  // - puis, on trie ce tableau : [0, 1, 4, 5, 7]
  // - et, on redefinie les positions avec une suite consecutive : [0, 1, 2, 3, 4]
  const entries = Object.entries(this.layers);
  entries.sort((a, b) => {
    return a[1].position - b[1].position;
  });
  for (let pos = 0; pos < entries.length; pos++) {
    const entrie = entries[pos];
    var opts = entrie[1];
    opts.position = pos;
    this.layers[entrie[0]] = opts;
  }
  // 2. redefinition des positions dans les styles
  // on redefinie la position des couches vecteurs tuilés dans les styles
  if (typeof id !== "undefined") {
    if (this.layers[id].type === "vector") {
      var pos = this.layers[id].position;
      var beforeId = 0;
      if (this.map.getStyle().layers.length) {
        beforeId = this.map.getStyle().layers[_assertClassBrand(_LayerSwitcher_brand, this, _getIndexLayer).call(this, pos)].id;
      }
      var max = pos === Object.keys(this.layers).length - 1;
      if (!max) {
        // ne jamais déplacer le groupe avant le background tout blanc
        if (beforeId.split("$$$")[0] === "bckgrd") {
          return;
        }
        _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.moveGroup(id, beforeId);
      }
    }
  }
}
/**
 * Opacité de la couche
 * @param {*} id
 * @param {*} value
 */
function _setOpacity(id, value) {
  this.layers[id].opacity = value;
  let index;
  for (let i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed.length; i++) {
    if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[i].id === id) {
      index = i;
      break;
    }
  }
  if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[index]) {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[index].opacity = value;
  }
  // mise à jour de la couche (style)
  var type = this.layers[id].type;
  if (type === "raster") {
    this.map.setPaintProperty(id, "raster-opacity", value / 100);
  } else if (type === "vector" || type === "geojson") {
    _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.addOpacity(id, value / 100);
  } else {
    throw new Error(`Type not yet implemented or unknow : ${type}`);
  }
}
/**
   * Visualisation de la couche
   * @param {*} id
   * @param {*} value
   */
function _setVisibility(id, value) {
  this.layers[id].visibility = value;
  let index;
  for (let i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed.length; i++) {
    if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[i].id === id) {
      index = i;
      break;
    }
  }
  if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[index]) {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[index].visible = value;
  }
  // mise à jour de la couche (style)
  var type = this.layers[id].type;
  if (type === "raster") {
    this.map.setLayoutProperty(id, "visibility", value ? "visible" : "none");
  } else if (type === "vector" || type === "geojson") {
    _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.addVisibility(id, value);
  } else {
    throw new Error(`Type not yet implemented or unknow : ${type}`);
  }
  this.dispatchEvent(new CustomEvent("layervisibility", {
    bubbles: true,
    detail: {
      id: id,
      options: this.layers[id],
      entries: this.getLayersOrder()
    }
  }));
}
/**
 * Affichage du N&B
 * @param {*} id
 * @param {*} value
 */
function _setColor(id, value) {
  this.layers[id].gray = !value;
  let index;
  for (let i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed.length; i++) {
    if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[i].id === id) {
      index = i;
      break;
    }
  }
  if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[index]) {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[index].gray = !value;
  }
  var type = this.layers[id].type;
  if (type === "raster") {
    // INFO
    // mise à jour de la couche via une property du style,
    !value ? this.map.setPaintProperty(id, "raster-saturation", -1) : this.map.setPaintProperty(id, "raster-saturation", 0);
  } else if (type === "vector") {
    // INFO
    // appliquer un filtre N&B sur les valeurs des couleurs
    !value ? _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.addGray(id) : _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.addColor(id);
  } else {
    throw new Error(`Type not yet implemented or unknow : ${type}`);
  }
}
/**
   * Ajout des ecouteurs pour une couche
   * @description les ecouteurs disparaissent en supprimant le DOM
   */
function _addListeners(id, shadow) {
  var index = _assertClassBrand(_LayerSwitcher_brand, this, _getIndex).call(this, id);

  // outils avancés
  shadow.getElementById(`show-advanced-tools_ID_${index}`).addEventListener("click", () => {
    const invisibleClass = this.layers[id].visibility ? "" : " invisible";
    _action_sheet__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.show({
      options: [{
        class: "tools-layer-color",
        text: !this.layers[id].gray ? "Afficher en noir et blanc" : "Afficher en couleur",
        value: "greyscale"
      }, {
        class: `tools-layer-visibility${invisibleClass}`,
        text: this.layers[id].visibility ? "Masquer" : "Afficher",
        value: "visibility"
      }, {
        class: "tools-layer-info",
        text: "Informations",
        value: "info"
      }, {
        class: "tools-layer-remove",
        text: "Retirer de ma sélection",
        value: "remove"
      }],
      timeToHide: 50
    }).then(value => {
      if (value === "visibility") {
        if (this.layers[id].visibility) {
          document.getElementById(`container_ID_${index}`).classList.add("invisible");
        } else {
          document.getElementById(`container_ID_${index}`).classList.remove("invisible");
        }
        _assertClassBrand(_LayerSwitcher_brand, this, _setVisibility).call(this, id, !this.layers[id].visibility);
      }
      if (value === "remove") {
        this.removeLayer(id, this.layers[id].isTempLayer);
      }
      if (value === "info") {
        var text = document.getElementById("informationsText");
        var p;
        if (this.layers[id].isTempLayer) {
          p = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getTempLayerProps(id);
        } else {
          p = _layer_config__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getLayerProps(id);
        }
        text.innerHTML = `
          <p>${p.desc}</p>
          <p><span class="layerInfoSource">Source :</span> ${p.source}</p>
          <p><span class="layerInfoMaj">Mise à jour :</span> ${p.maj}</p>
          `;
        var img = document.getElementById("informationsImg");
        img.src = this.layers[id].legendUrl || _html_img_legend_not_found_png__WEBPACK_IMPORTED_MODULE_6__;
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open("informations");
      }
      if (value === "greyscale") {
        _assertClassBrand(_LayerSwitcher_brand, this, _setColor).call(this, id, this.layers[id].gray);
      }
    });
  });

  // opacité des couches
  shadow.getElementById(`opacity-value-range_ID_${index}`).addEventListener("change", e => {
    var id = _assertClassBrand(_LayerSwitcher_brand, this, _getId).call(this, index);
    _assertClassBrand(_LayerSwitcher_brand, this, _setOpacity).call(this, id, e.target.value);
  });
  shadow.getElementById(`opacity-value-range_ID_${index}`).addEventListener("input", e => {
    var id = _assertClassBrand(_LayerSwitcher_brand, this, _getId).call(this, index);
    _assertClassBrand(_LayerSwitcher_brand, this, _setOpacity).call(this, id, e.target.value);
  });

  // drag'n drop des couches
  shadow.getElementById(`cross-picto_ID_${index}`).addEventListener("click", () => {});
}
/**
   * Ajout d'une entrée pour une couche (DOM)
   * @param {*} id
   */
function _addLayerContainer(id) {
  var quickLookUrl = this.layers[id].quickLookUrl || _html_img_image_not_found_png__WEBPACK_IMPORTED_MODULE_5__;
  var opacity = this.layers[id].opacity;
  var title = this.layers[id].title || id.split("$")[0];
  var index = _assertClassBrand(_LayerSwitcher_brand, this, _getIndex).call(this, id);
  const invisibleClass = this.layers[id].visibility ? "" : " invisible";

  // Template d'une couche
  var tplContainer = `
      <div class="tools-layer-panel draggable-layer ${invisibleClass}" id="container_ID_${index}">
        <div class="handle-draggable-layer" id="cross-picto_ID_${index}"></div>
        <div id="basic-tools_ID_${index}">
          <div id="thumbnail_ID_${index}">
            <img class="tools-layer-quickLookUrl" src="${quickLookUrl}"/>
          </div>
          <div class="wrap-tools-layers">
            <span id="title_ID_${index}">${title}</span>
            <div id="opacity-range-div_ID_${index}" class="tools-layer-opacity">
              <!-- before:: & after:: 0% / 100% -->
              <input id="opacity-value-range_ID_${index}" type="range" value=${opacity}>
            </div>
          </div>
        </div>
        <label id="show-advanced-tools_ID_${index}" title="Plus d'outils" class="tools-layer-advanced" role="button" tabindex="0"></label>
      </div>
      `;

  // transformation du container : String -> DOM
  var container = _utils_dom_utils__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A.stringToHTML(tplContainer.trim());
  if (!container) {
    console.warn();
    return;
  }

  // ajout du shadow DOM
  const shadow = container.attachShadow({
    mode: "open"
  });
  shadow.innerHTML = tplContainer.trim();
  if (!shadow) {
    console.warn();
    return;
  }

  // ajout des écouteurs
  _assertClassBrand(_LayerSwitcher_brand, this, _addListeners).call(this, id, shadow);

  // pour l'affichage en couleur de la barre à gauche du selecteur
  var sliderProgress = shadow.getElementById(`opacity-value-range_ID_${index}`);
  sliderProgress.style.setProperty("--value", sliderProgress.value);
  sliderProgress.style.setProperty("--min", sliderProgress.min == "" ? "0" : sliderProgress.min);
  sliderProgress.style.setProperty("--max", sliderProgress.max == "" ? "100" : sliderProgress.max);
  sliderProgress.addEventListener("input", () => sliderProgress.style.setProperty("--value", sliderProgress.value));
  var target = document.getElementById("lst-layer-switcher");
  var theFirstChild = target.firstChild;
  target.insertBefore(shadow, theFirstChild);
}
/**
   * Suppression d'une entrée pour une couche (DOM)
   * @param {*} id
   */
function _removeLayerContainer(id) {
  var index = _assertClassBrand(_LayerSwitcher_brand, this, _getIndex).call(this, id);
  var container = document.getElementById("container_ID_" + index);
  container.remove();
}
/**
   * Ajout de la couche
   * @param {*} id
   * @returns
   */
function _addLayerMap(id) {
  var promise = null;
  var type = this.layers[id].type;
  var style = [];
  var fallback = [];
  if (type === "raster") {
    style.push({
      id: id,
      source: id,
      type: "raster"
    });
  } else if (type === "vector" && this.layers[id].style) {
    style = this.layers[id].style; // url !
    fallback = this.layers[id].fallbackStyle; // url !;
  } else if (type === "vector") {
    // PMtiles (temporary layer)
    style.push(this.layers[id].layerDef);
  } else if (type === "geojson") {
    style.push({
      id: id,
      source: id,
      type: this.layers[id].layerType,
      layout: this.layers[id].layerDef.layout
    });
  } else {
    this.layers[id].error = true;
    throw new Error(`Type not yet implemented or unknown : ${type}`);
  }
  // HACK
  // on positionne toujours le style avant ceux du calcul d'itineraires (directions)
  // afin que le calcul soit toujours la couche visible du dessus !
  var layerIndexBefore = this.map.getStyle().layers.findIndex(l => l.source === "maplibre-gl-directions");
  var layerIdBefore = layerIndexBefore !== -1 ? this.map.getStyle().layers[layerIndexBefore].id : null;
  if (Array.isArray(style)) {
    // Raster ou geojson
    promise = new Promise(resolve => {
      _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.addGroup(id, style, layerIdBefore);
      resolve();
    });
  } else {
    // Vecteur
    var fetchStyle = async (style, fallback) => {
      try {
        const response = await fetch(style);
        const data = await response.json();
        // INFO
        // on ajoute les sources !
        // les sources des couches tuiles vectorielles ne sont pas pré chargées
        // car on les connait que maintenant en lisant le fichier de style.
        // l'id des source est different du nom de la couche pour le vecteur !
        for (const key in data.sources) {
          if (Object.hasOwnProperty.call(data.sources, key)) {
            const source = data.sources[key];
            // on ne peut pas ajouter la même source !
            if (!this.map.getStyle().sources[key]) {
              this.map.addSource(key, source);
            }
          }
        }
        const data_1 = data;
        // les sprites et les glyphs sont uniques sinon exceptions !
        // mais, normalement, on ajoute que des couches IGN, on mutualise sur ces informations.
        // FIXME comment gerer les exceptions ?
        if (!data_1.sprite.startsWith("http")) {
          data_1.sprite = document.URL + data_1.sprite;
        }
        this.map.setSprite(data_1.sprite);
        this.map.setGlyphs(data_1.glyphs);
        // Fallback for offline glyphs
        if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.online && _capacitor_core__WEBPACK_IMPORTED_MODULE_9__/* .Capacitor */ .Ii.isNativePlatform()) {
          this.map.setGlyphs("data/fallback_glyphs/{fontstack}/{range}.pbf");
        }
        const data_2 = data_1;
        layerIndexBefore = this.map.getStyle().layers.findIndex(l => l.source === "maplibre-gl-directions");
        layerIdBefore = layerIndexBefore !== -1 ? this.map.getStyle().layers[layerIndexBefore].id : null;
        _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.addGroup(id, data_2.layers, layerIdBefore);
        this.layers[id].style = data_2.layers; // sauvegarde !
      } catch (e) {
        if (fallback) {
          return fetchStyle(fallback, null);
        } else {
          this.layers[id].error = true;
          throw new Error(e);
        }
      }
    };
    promise = fetchStyle(style, fallback);
  }
  return promise;
}
/**
   * Suppression de la couche
   * @param {*} id
   */
function _removeLayerMap(id) {
  _layer_group__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.removeGroup(id);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LayerSwitcher);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 221:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "css/assets/c0a8c9dce75c1dc7d4f2.png";

/***/ }),

/***/ 229:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var chart_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3560);
/* harmony import */ var maplibre_gl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2461);
/* harmony import */ var maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(maplibre_gl__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _services_elevation_line__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3141);
/* harmony import */ var _elevation_line_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4376);
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2116);
/* harmony import */ var _services_location__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3838);
/* harmony import */ var _capacitor_toast__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2472);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_4__, _services_location__WEBPACK_IMPORTED_MODULE_5__]);
([_globals__WEBPACK_IMPORTED_MODULE_4__, _services_location__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */


chart_js__WEBPACK_IMPORTED_MODULE_0__/* .Chart */ .t1.register(chart_js__WEBPACK_IMPORTED_MODULE_0__/* .ScatterController */ .Pz, chart_js__WEBPACK_IMPORTED_MODULE_0__/* .LineElement */ .No, chart_js__WEBPACK_IMPORTED_MODULE_0__/* .PointElement */ .FN, chart_js__WEBPACK_IMPORTED_MODULE_0__/* .LinearScale */ .kc, chart_js__WEBPACK_IMPORTED_MODULE_0__/* .Filler */ .dN, chart_js__WEBPACK_IMPORTED_MODULE_0__/* .Tooltip */ .m_);







/**
 * Interface sur le contrôle profil altimétrique
 * @module ElevationLineControl
 * @todo mise en place d'une patience
 * @todo ajouter les fonctionnalités : cf. DOM
 */
var _ElevationLineControl_brand = /*#__PURE__*/new WeakSet();
class ElevationLineControl {
  /**
   * constructeur
   * @constructs
   * @param {*} map
   * @param {*} options
   */
  constructor(options) {
    /**
     * Active la patience le temps que la requête se termine
     * @private
     */
    _classPrivateMethodInitSpec(this, _ElevationLineControl_brand);
    this.options = options || {
      target: null
    };
    this.target = this.options.target || document.getElementById("directions-elevationline");
    this.coordinates = null; // [{lat: ..., lon: ...}, ...]
    this.elevationData = null; // [{x: <distance>, y: <elevation>}, ...]
    this.profileLngLats = [];
    this.removeCrosshair = false;
    this.dplus = 0; // dénivelé positif
    this.dminus = 0; // dénivelé négatif

    this.unit = "m"; // unité pour la distance

    this.chart = null;
    this.loadingDom = document.createElement("div"); // div de la patience
    this.loadingDom.className = "elevationLineLoadingDom";
    this.loadingDom.classList.add("d-none");
    this.loadingDomInDocument = false;
    return this;
  }

  /**
   * Insère une donnée pré-calculée dans le contrôle
   * @param {*} data
   * @public
   */
  setData(data) {
    this.coordinates = data.coordinates;
    this.elevationData = data.elevationData;
    this.profileLngLats = data.profileLngLats;
    this.dplus = data.dplus;
    this.dminus = data.dminus;
    this.unit = data.unit;
    this.render();
  }

  /**
   * Récupère la donnée du contrôle
   * @param {*} data
   * @public
   */
  getData() {
    return {
      coordinates: this.coordinates,
      elevationData: this.elevationData,
      dplus: this.dplus,
      dminus: this.dminus,
      unit: this.unit,
      profileLngLats: this.profileLngLats
    };
  }

  /**
   * creation de l'interface
   * @public
   */
  render() {
    _assertClassBrand(_ElevationLineControl_brand, this, _unsetLoading).call(this);
    if (this.chart != null) {
      this.clear();
    }
    var target = this.target;
    if (!target) {
      console.warn();
      return;
    }
    const chartData = {
      datasets: [{
        data: this.elevationData,
        fill: false,
        borderWidth: 3,
        borderColor: getComputedStyle(document.body).getPropertyValue("--dark-green"),
        tension: 0.1,
        pointRadius: 0,
        showLine: true,
        hoverRadius: 0
      }]
    };
    const allElevations = this.elevationData.map(elevation => elevation.y);
    const maxElevation = Math.max(...allElevations);
    const minElevation = Math.min(...allElevations);
    let suggestedMin = minElevation;
    let suggestedMax = maxElevation;
    if (maxElevation - minElevation < 10) {
      suggestedMin = (maxElevation - minElevation) / 2 - 5 + minElevation;
      suggestedMax = (maxElevation - minElevation) / 2 + 5 + minElevation;
    }

    // Merci https://stackoverflow.com/a/74443361
    const plugin = {
      id: "crosshair",
      defaults: {
        width: 1,
        color: getComputedStyle(document.body).getPropertyValue("--dark-grey"),
        dash: [3, 3]
      },
      afterInit: chart => {
        chart.crosshair = {
          x: 0,
          y: 0
        };
      },
      afterEvent: (chart, args) => {
        if (this.profileLngLats.length === 0) {
          return;
        }
        const {
          inChartArea
        } = args;
        const point = this.chart.getElementsAtEventForMode(args.event, "index", {
          intersect: false
        }, true)[0];
        if (!this.removeCrosshair && args.event.type !== "click" && point) {
          const x = point.element.x;
          const y = point.element.y;
          _globals__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.map.getSource("elevation-line-location").setData({
            "type": "Feature",
            "geometry": {
              "type": "Point",
              "coordinates": this.profileLngLats[point.element.$context.index]
            }
          });
          const coordinates = [[this.profileLngLats[point.element.$context.index][0] - 0.005, this.profileLngLats[point.element.$context.index][1] - 0.005], [this.profileLngLats[point.element.$context.index][0] + 0.005, this.profileLngLats[point.element.$context.index][1] + 0.005]];
          const bounds = coordinates.reduce((bounds, coord) => {
            return bounds.extend(coord);
          }, new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLatBounds)(coordinates[0], coordinates[0]));
          if (_services_location__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.isTrackingActive()) {
            _services_location__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.disableTracking();
          }
          _globals__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.map.fitBounds(bounds, {
            padding: {
              bottom: window.scrollY
            }
          });
          chart.crosshair = {
            x,
            y,
            draw: inChartArea
          };
          chart.draw();
        } else {
          chart.crosshair = {
            x: 0,
            y: 0,
            draw: null
          };
          _globals__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.map.getSource("elevation-line-location").setData({
            type: "FeatureCollection",
            features: []
          });
          chart.draw();
        }
      },
      beforeDatasetsDraw: (chart, _, opts) => {
        const {
          ctx
        } = chart;
        const {
          top,
          bottom,
          left,
          right
        } = chart.chartArea;
        if (!chart.crosshair) return;
        const {
          x,
          y,
          draw
        } = chart.crosshair;
        if (!draw) return;
        ctx.save();
        ctx.beginPath();
        ctx.lineWidth = opts.width;
        ctx.strokeStyle = opts.color;
        ctx.setLineDash(opts.dash);
        ctx.moveTo(x, bottom);
        ctx.lineTo(x, top);
        ctx.moveTo(left, y);
        ctx.lineTo(right, y);
        ctx.stroke();
        ctx.restore();
      }
    };
    const chartConfig = {
      type: "scatter",
      data: chartData,
      options: {
        scales: {
          x: {
            max: this.elevationData.slice(-1)[0].x,
            title: {
              display: true,
              text: `Distance (${this.unit})`
            }
          },
          y: {
            title: {
              display: true,
              text: "Altitude (m)"
            },
            suggestedMax: suggestedMax,
            suggestedMin: suggestedMin
          }
        },
        plugins: {
          crosshair: {
            color: getComputedStyle(document.body).getPropertyValue("--dark-grey")
          },
          tooltip: {
            mode: "index",
            position: "average",
            intersect: false,
            backgroundColor: "#FFFA",
            borderColor: getComputedStyle(document.body).getPropertyValue("--dark-grey"),
            borderWidth: 1,
            displayColors: false,
            callbacks: {
              label: context => {
                let distanceText = Math.round(context.parsed.x);
                if (this.unit === "km") {
                  distanceText = Math.round(context.parsed.x * 100) / 100;
                }
                return `Altitude : ${context.parsed.y.toLocaleString()} m
Distance du départ : ${distanceText} ${this.unit}`;
              },
              labelTextColor: () => {
                return getComputedStyle(document.body).getPropertyValue("--dark-grey");
              }
            }
          }
        },
        hover: {
          mode: "index",
          intersect: false
        }
      },
      plugins: [plugin]
    };
    chart_js__WEBPACK_IMPORTED_MODULE_0__/* .Chart */ .t1.defaults.font.size = 12;
    chart_js__WEBPACK_IMPORTED_MODULE_0__/* .Chart */ .t1.defaults.font.family = "Open Sans Semibold";
    this.chart = new chart_js__WEBPACK_IMPORTED_MODULE_0__/* .Chart */ .t1(target, chartConfig);
    // Add touchend event listener for mobile devices
    target.addEventListener("touchend", () => {
      // Remove the vertical line and update the chart
      this.removeCrosshair = true;
      this.chart.tooltip.opacity = 0;
      this.chart.crosshair = {
        x: 0,
        y: 0,
        draw: null
      };
      _globals__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.map.getSource("elevation-line-location").setData({
        type: "FeatureCollection",
        features: []
      });
      this.chart.draw();
      const self = this;
      // HACK: disable hover effect for 0.1 seconds
      setTimeout(() => {
        self.removeCrosshair = false;
      }, 100);
    });
  }

  /**
   * requête au service et construction de la donnée
   * @param {float} totalDistance Distance totale réelle de l'itinéraire (différente de celle calculée à cause du sampling)
   * @public
   */
  async compute() {
    let totalDistance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    _assertClassBrand(_ElevationLineControl_brand, this, _setLoading).call(this);
    // Gestion du cas où pas assez de coordonnées sont présentes
    if (this.coordinates.length < 2) {
      this.setData({
        coordinates: this.coordinates,
        elevationData: [{
          x: 0,
          y: 0
        }],
        dplus: 0,
        dminus: 0,
        unit: "m"
      });
      return;
    }
    this.elevationData = [];
    this.profileLngLats = [];
    this.dplus = 0;
    this.dminus = 0;
    let responseElevation;
    try {
      responseElevation = await _services_elevation_line__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.compute(this.coordinates);
    } catch (err) {
      if (!err.message.includes("aborted")) {
        _capacitor_toast__WEBPACK_IMPORTED_MODULE_6__/* .Toast */ .y.show({
          text: "Erreur lors du calcul de profil altimétrique",
          duration: "short",
          position: "bottom"
        });
      } else {
        return true;
      }
      responseElevation = {
        elevations: [{
          lon: 0,
          lat: 0,
          z: 0
        }]
      };
    }
    let lastLngLat = null;
    let lastZ = null;
    let currentDistance = 0;
    this.unit = "m";
    responseElevation.elevations.forEach(elevation => {
      let currentLngLat = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(elevation.lon, elevation.lat);
      if (lastLngLat != null) {
        currentDistance += currentLngLat.distanceTo(lastLngLat);
        if (elevation.z > lastZ) {
          this.dplus += elevation.z - lastZ;
        } else {
          this.dminus += lastZ - elevation.z;
        }
      }
      let elevationValue = elevation.z;
      if (elevationValue == -99999) {
        elevationValue = 0;
      }
      let currentDataPoint = {
        x: currentDistance,
        y: elevationValue
      };
      this.elevationData.push(currentDataPoint);
      this.profileLngLats.push([currentLngLat.lng, currentLngLat.lat]);
      lastLngLat = currentLngLat;
      lastZ = elevation.z;
    });
    this.dplus = Math.round(100 * this.dplus) / 100;
    this.dminus = Math.round(100 * this.dminus) / 100;
    if (totalDistance) {
      // Ratio entre la distance totale réelle de l'itinéraire et la distance calculée (différente à cause du sampling)
      const ratio = totalDistance / currentDistance;
      this.elevationData.forEach(elevation => {
        elevation.x = Math.round(elevation.x * ratio);
      });
    }
    if (currentDistance > 2000) {
      this.unit = "km";
      this.elevationData.forEach(elevation => {
        elevation.x = elevation.x / 1000;
      });
    }
    this.render();
  }
  /**
   * remplissage des coordonnées pour le calcul de profil atlimétrique
   * @param coordinates [[lon, lat], [lon, lat]]
   * @public
   */
  setCoordinates(coordinates) {
    this.coordinates = coordinates;
  }

  /**
   * nettoyage du tracé
   * @public
   */
  clear() {
    _services_elevation_line__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.clear();
    if (this.chart) {
      this.chart.destroy();
    }
  }

  /**
   * Ajout des sources et des couches associées au contrôle
   * @public
   */
  addSourcesAndLayers() {
    // Comme le contrôle est appelé 2 fois (Tracé ET calcul d'iti), on s'assure de n'ajouter qu'une
    // seule fois la source et les layers
    if (!_globals__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.map.getSource("elevation-line-location")) {
      _globals__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.map.addSource("elevation-line-location", {
        "type": "geojson",
        "data": {
          type: "FeatureCollection",
          features: []
        }
      });
      _globals__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.map.addLayer(_elevation_line_styles__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A["point-casing"]);
      _globals__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.map.addLayer(_elevation_line_styles__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A["point"]);
    }
  }
}

// mixins
function _setLoading() {
  if (!this.loadingDomInDocument) {
    this.target.after(this.loadingDom);
    this.loadingDomInDocument = true;
  }
  this.loadingDom.classList.remove("d-none");
}
/**
 * Désactive la patience
 * @private
 */
function _unsetLoading() {
  this.loadingDom.classList.add("d-none");
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ElevationLineControl);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 240:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (/* binding */ index_default)
/* harmony export */ });
/* unused harmony export lineSlice */
/* harmony import */ var _turf_invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2319);
/* harmony import */ var _turf_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2104);
/* harmony import */ var _turf_nearest_point_on_line__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(833);
// index.js



function lineSlice(startPt, stopPt, line) {
  var coords = (0,_turf_invariant__WEBPACK_IMPORTED_MODULE_0__/* .getCoords */ .$R)(line);
  if ((0,_turf_invariant__WEBPACK_IMPORTED_MODULE_0__/* .getType */ .Pw)(line) !== "LineString") throw new Error("line must be a LineString");
  var startVertex = (0,_turf_nearest_point_on_line__WEBPACK_IMPORTED_MODULE_2__/* .nearestPointOnLine */ .W)(line, startPt);
  var stopVertex = (0,_turf_nearest_point_on_line__WEBPACK_IMPORTED_MODULE_2__/* .nearestPointOnLine */ .W)(line, stopPt);
  var ends;
  if (startVertex.properties.index <= stopVertex.properties.index) {
    ends = [startVertex, stopVertex];
  } else {
    ends = [stopVertex, startVertex];
  }
  var clipCoords = [ends[0].geometry.coordinates];
  for (var i = ends[0].properties.index + 1; i < ends[1].properties.index + 1; i++) {
    clipCoords.push(coords[i]);
  }
  clipCoords.push(ends[1].geometry.coordinates);
  return (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_1__/* .lineString */ .wi)(clipCoords, line.properties);
}
var index_default = lineSlice;


/***/ }),

/***/ 264:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ pLimit)
});

// UNUSED EXPORTS: limitFunction

;// ./node_modules/yocto-queue/index.js
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
How it works:
`this.#head` is an instance of `Node` which keeps track of its current value and nests another instance of `Node` that keeps the value that comes after it. When a value is provided to `.enqueue()`, the code needs to iterate through `this.#head`, going deeper and deeper to find the last value. However, iterating through every single item is slow. This problem is solved by saving a reference to the last value as `this.#tail` so that it can reference it to add a new value.
*/

class Node {
  constructor(value) {
    _defineProperty(this, "value", void 0);
    _defineProperty(this, "next", void 0);
    this.value = value;
  }
}
var _head = /*#__PURE__*/new WeakMap();
var _tail = /*#__PURE__*/new WeakMap();
var _size = /*#__PURE__*/new WeakMap();
class Queue {
  constructor() {
    _classPrivateFieldInitSpec(this, _head, void 0);
    _classPrivateFieldInitSpec(this, _tail, void 0);
    _classPrivateFieldInitSpec(this, _size, void 0);
    this.clear();
  }
  enqueue(value) {
    var _this$size, _this$size2;
    const node = new Node(value);
    if (_classPrivateFieldGet(_head, this)) {
      _classPrivateFieldGet(_tail, this).next = node;
      _classPrivateFieldSet(_tail, this, node);
    } else {
      _classPrivateFieldSet(_head, this, node);
      _classPrivateFieldSet(_tail, this, node);
    }
    _classPrivateFieldSet(_size, this, (_this$size = _classPrivateFieldGet(_size, this), _this$size2 = _this$size++, _this$size)), _this$size2;
  }
  dequeue() {
    var _this$size3, _this$size4;
    const current = _classPrivateFieldGet(_head, this);
    if (!current) {
      return;
    }
    _classPrivateFieldSet(_head, this, _classPrivateFieldGet(_head, this).next);
    _classPrivateFieldSet(_size, this, (_this$size3 = _classPrivateFieldGet(_size, this), _this$size4 = _this$size3--, _this$size3)), _this$size4;

    // Clean up tail reference when queue becomes empty
    if (!_classPrivateFieldGet(_head, this)) {
      _classPrivateFieldSet(_tail, this, undefined);
    }
    return current.value;
  }
  peek() {
    if (!_classPrivateFieldGet(_head, this)) {
      return;
    }
    return _classPrivateFieldGet(_head, this).value;

    // TODO: Node.js 18.
    // return this.#head?.value;
  }
  clear() {
    _classPrivateFieldSet(_head, this, undefined);
    _classPrivateFieldSet(_tail, this, undefined);
    _classPrivateFieldSet(_size, this, 0);
  }
  get size() {
    return _classPrivateFieldGet(_size, this);
  }
  *[Symbol.iterator]() {
    let current = _classPrivateFieldGet(_head, this);
    while (current) {
      yield current.value;
      current = current.next;
    }
  }
  *drain() {
    while (_classPrivateFieldGet(_head, this)) {
      yield this.dequeue();
    }
  }
}
;// ./node_modules/p-limit/index.js

function pLimit(concurrency) {
  validateConcurrency(concurrency);
  const queue = new Queue();
  let activeCount = 0;
  const resumeNext = () => {
    if (activeCount < concurrency && queue.size > 0) {
      queue.dequeue()();
      // Since `pendingCount` has been decreased by one, increase `activeCount` by one.
      activeCount++;
    }
  };
  const next = () => {
    activeCount--;
    resumeNext();
  };
  const run = async (function_, resolve, arguments_) => {
    const result = (async () => function_(...arguments_))();
    resolve(result);
    try {
      await result;
    } catch {}
    next();
  };
  const enqueue = (function_, resolve, arguments_) => {
    // Queue `internalResolve` instead of the `run` function
    // to preserve asynchronous context.
    new Promise(internalResolve => {
      queue.enqueue(internalResolve);
    }).then(run.bind(undefined, function_, resolve, arguments_));
    (async () => {
      // This function needs to wait until the next microtask before comparing
      // `activeCount` to `concurrency`, because `activeCount` is updated asynchronously
      // after the `internalResolve` function is dequeued and called. The comparison in the if-statement
      // needs to happen asynchronously as well to get an up-to-date value for `activeCount`.
      await Promise.resolve();
      if (activeCount < concurrency) {
        resumeNext();
      }
    })();
  };
  const generator = function (function_) {
    for (var _len = arguments.length, arguments_ = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      arguments_[_key - 1] = arguments[_key];
    }
    return new Promise(resolve => {
      enqueue(function_, resolve, arguments_);
    });
  };
  Object.defineProperties(generator, {
    activeCount: {
      get: () => activeCount
    },
    pendingCount: {
      get: () => queue.size
    },
    clearQueue: {
      value() {
        queue.clear();
      }
    },
    concurrency: {
      get: () => concurrency,
      set(newConcurrency) {
        validateConcurrency(newConcurrency);
        concurrency = newConcurrency;
        queueMicrotask(() => {
          // eslint-disable-next-line no-unmodified-loop-condition
          while (activeCount < concurrency && queue.size > 0) {
            resumeNext();
          }
        });
      }
    }
  });
  return generator;
}
function limitFunction(function_, option) {
  const {
    concurrency
  } = option;
  const limit = pLimit(concurrency);
  return function () {
    for (var _len2 = arguments.length, arguments_ = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      arguments_[_key2] = arguments[_key2];
    }
    return limit(() => function_(...arguments_));
  };
}
function validateConcurrency(concurrency) {
  if (!((Number.isInteger(concurrency) || concurrency === Number.POSITIVE_INFINITY) && concurrency > 0)) {
    throw new TypeError('Expected `concurrency` to be a number from 1 and up');
  }
}

/***/ }),

/***/ 309:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "css/assets/ddc9315e414b067661d4.png";

/***/ }),

/***/ 402:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */

/**
 * Fonctions utilitaires
 */
let utils = {
  /**
   * convert distance in meters or kilometers
   * @param {Number} distance - distance in meters
   * @returns {String} distance in km
   * @private
   */
  convertDistance(distance) {
    let precision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
    var d = "";
    const factor = 10 ** precision;
    var distanceKm = Math.round(factor * distance / 1000) / factor;
    if (distanceKm < 1) {
      d = Math.round(distance) + " m"; // arrondi !
    } else {
      if (distanceKm > 100) {
        distanceKm = Math.round(distanceKm);
      }
      d = distanceKm.toLocaleString() + " km";
    }
    return d;
  },
  /**
   * convert seconds to time : HH:MM:SS
   * @param {Number} duration - duration in seconds
   * @returns {String} time in hours/minutes/seconds
   * @private
   */
  convertSecondsToTime(duration) {
    let secondsWanted = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    let format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "HH h MM min SS s";
    var time = "";
    var timeDots = "";
    duration = Math.round(duration);
    var hours = Math.floor(duration / (60 * 60));
    var divisor4minutes = duration % (60 * 60);
    var minutes = Math.floor(divisor4minutes / 60);
    var divisor4seconds = divisor4minutes % 60;
    var seconds = Math.ceil(divisor4seconds);
    if (!seconds) {
      seconds = 0;
    }
    if (hours) {
      time = hours + "h ";
      timeDots = (hours < 10 ? "0" + hours : hours) + ":";
    }
    time += minutes + " min";
    timeDots += minutes < 10 ? "0" + minutes : minutes;
    if (secondsWanted) {
      time += " " + seconds + " s";
      timeDots += ":" + (seconds < 10 ? "0" + seconds : seconds);
    }
    if (format === "HH:MM:SS") {
      return timeDots;
    }
    return time;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (utils);

/***/ }),

/***/ 451:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2116);
/* harmony import */ var _poi_legend_rules__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2067);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_0__]);
var __webpack_async_dependencies_result__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
_globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_async_dependencies_result__[0];
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */



function beautifyLayerName(feature, source) {
  // POI OSM
  if (source == "poi_osm") {
    let featureRule = _poi_legend_rules__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.filter(l => {
      let classMatches = true;
      if (l.class) {
        classMatches = l.class == feature.properties.class;
      }
      const subclassMatches = l.subclass == feature.properties.subclass;
      return subclassMatches && classMatches;
    });
    let legend = [];
    let texte = Object.hasOwnProperty.call(feature.properties, "texte") ? feature.properties.texte : "";
    let symbo = Object.hasOwnProperty.call(feature.properties, "symbo") ? feature.properties.symbo : "";
    if (texte) {
      legend.push(texte);
    }
    if (symbo && featureRule.length > 0) {
      symbo = Object.hasOwnProperty.call(featureRule[0], "libelle") ? featureRule[0].libelle : symbo;
      if (!texte) {
        legend.push(symbo);
      }
      if (symbo !== "" && texte) {
        legend.push(`<p class="positionSubTitle">${symbo} - Source : OpenStreetMap</p>`);
      } else {
        legend.push("<p class=\"positionSubTitle\">Source : OpenStreetMap</p>");
      }
    } else {
      legend.push("<p class=\"positionSubTitle\">Source : OpenStreetMap</p>");
    }
    return legend.join("");
  }
  // PLAN IGN
  else {
    let legend = [];
    if (Object.hasOwnProperty.call(feature.properties, "texte") && feature.properties.texte) {
      legend.push(feature.properties.texte);
    } else if (Object.hasOwnProperty.call(feature.layer, "metadata") && Object.hasOwnProperty.call(feature.layer.metadata, "legend-title")) {
      legend.push(feature.layer.metadata["legend-title"]);
    }
    if (legend.length > 0) {
      legend.push("<p class=\"positionSubTitle\">Source : BD Topo® - IGN</p>");
    }
    return legend.join("");
  }
}
function getMapboxPropAtZoom(feature, prop, zoom, defaultValue) {
  if (Object.hasOwnProperty.call(feature.paint, prop)) {
    let p = feature.paint[prop];
    // cas des stops récupère la propriété au bon niveau de zoom
    if (Object.hasOwnProperty.call(p, "stops")) {
      for (let i = p.stops.length - 1; i >= 0; i--) {
        if (zoom >= i) return p.stops[i][1];
      }
    }
    // cas des steps récupère la propriété au bon niveau de zoom
    if (Array.isArray(p) && p[0] == "step" && p[1][0] == "zoom") {
      let steps = p.slice(2);
      let response = steps[0];
      for (let i = 0; i < steps.length; i++) {
        if (i % 2 == 0) response = steps[i];
        if (i % 2 == 1 && steps[i] > zoom) break;
      }
      return response;
    } else {
      return p;
    }
  } else {
    return defaultValue;
  }
}
function MapBoxStyleToSVG(features, zoom) {
  const sprite = _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.poi.getSprite();
  var height = 24;
  var width = 36;
  const multiplicator = 2;
  let lineHeight = 0;
  features.forEach(f => {
    if (f.type == "line") {
      const lineWidth = getMapboxPropAtZoom(f, "line-width", zoom, 1) * multiplicator;
      lineHeight += lineWidth;
    }
    if (f.type == "circle") {
      const circleStrokeWidth = getMapboxPropAtZoom(f, "circle-stroke-width", zoom, 1);
      const radius = getMapboxPropAtZoom(f, "circle-radius", zoom, 0);
      height = circleStrokeWidth + radius > height ? circleStrokeWidth + radius : height;
    }
    if (f.type == "symbol" && Object.hasOwnProperty.call(f.layout, "icon-image")) {
      let symbol = f.source == "poi_osm" ? _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.poi.getFeatureFillPattern(f) : f.layout["icon-image"];
      height = sprite.json[symbol].height;
      width = sprite.json[symbol].width;
    }
  });
  if (lineHeight > 0) height = lineHeight;
  const x = 0;
  const y = height / 2;
  var shape = "";
  features.forEach(f => {
    if (f.type == "symbol" && Object.hasOwnProperty.call(f.layout, "icon-image")) {
      let symbol = f.source == "poi_osm" ? _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.poi.getFeatureFillPattern(f) : f.layout["icon-image"];
      shape += `<svg xmlns='http://www.w3.org/2000/svg' version='1.1' preserveAspectRatio='none'\
            width='${width}'\
            height='${height}'\
            x='0' y='0'\
            viewBox='${sprite.json[symbol].x} ${sprite.json[symbol].y} ${sprite.json[symbol].width} ${sprite.json[symbol].height}'>
            <image\
            width="${sprite.size.w}px"\
            height="${sprite.size.h}px"\
            xlink:href="${sprite.url}.png"/></svg>`;
    }
    if (f.type == "fill") {
      // fill-patern
      if (getMapboxPropAtZoom(f, "fill-pattern", zoom, "")) {
        const fillPattern = getMapboxPropAtZoom(f, "fill-pattern", zoom, "");
        shape += `<svg xmlns='http://www.w3.org/2000/svg' version='1.1' preserveAspectRatio='none'\
                    width='${width}'\
                    height='${height}'\
                    x='0' y='0'\
                    viewBox='${sprite.json[fillPattern].x} ${sprite.json[fillPattern].y} ${sprite.json[fillPattern].width} ${sprite.json[fillPattern].height}'>
                    <image\
                    width="${sprite.size.w}px"\
                    height="${sprite.size.h}px"\
                    xlink:href="${sprite.url}.png"/></svg>`;
      } else {
        const fillcolor = getMapboxPropAtZoom(f, "fill-color", zoom, "#FFFFFF");
        const strokecolor = getMapboxPropAtZoom(f, "fill-outline-color", zoom, "#FFFFFF");
        const strokeopacity = getMapboxPropAtZoom(f, "line-opacity", zoom, 1);
        const fillopacity = getMapboxPropAtZoom(f, "ffill-opacity", zoom, 1);
        shape += `<rect\
                    width="100%"\
                    height="100%"\
                    fill="${fillcolor}"\
                    stroke="${strokecolor}"\
                    stroke-opacity="${strokeopacity}"\
                    opacity="${fillopacity}"/>`;
      }
    }
    if (f.type == "line") {
      const strokecolor = getMapboxPropAtZoom(f, "line-color", zoom, "#FFFFFF");
      const lineWidth = getMapboxPropAtZoom(f, "line-width", zoom, 1);
      const opacity = getMapboxPropAtZoom(f, "line-opacity", zoom, 1);
      let dA = getMapboxPropAtZoom(f, "line-dasharray", zoom, []);
      let dashArr = "";
      if (dA.length > 0) {
        dA = dA.map(x => x * lineWidth).join(" ");
        if (dA) {
          dashArr = `stroke-dasharray="${dA}"`;
        }
      }
      shape += `<line\
                x1=${x}"\
                y1="${y}"\
                x2="${x + width}"\
                y2="${y}"\
                stroke="${strokecolor}"\
                stroke-width="${lineWidth * multiplicator}"\
                stroke-opacity="${opacity}"\
                ${dashArr}"/>`;
    }
    if (f.type == "circle") {
      const circleStrokeWidth = getMapboxPropAtZoom(f, "circle-stroke-width", zoom, 1);
      const strokeOpacity = getMapboxPropAtZoom(f, "circle-stroke-opacity", zoom, 1);
      const circleStroke = getMapboxPropAtZoom(f, "circle-stroke-color", zoom, "#FFFFFF");
      const circleFill = getMapboxPropAtZoom(f, "circle-color", zoom, "#FFFFFF");
      const radius = getMapboxPropAtZoom(f, "circle-radius", zoom, 0);
      shape += `<circle\
                cx="${width / 2}"\
                cy="${height / 2}"\
                r="${radius}"\
                y2="${y}"\
                stroke="${circleStroke}"\
                fill="${circleFill}"\
                stroke-width="${circleStrokeWidth}"\
                stroke-opacity="${strokeOpacity}"/>`;
    }
  });
  let svg = `<svg style='display:inline; transform:translate(0px, 3px)' \
        xmlns='http://www.w3.org/2000/svg' \
        version='1.1' \
        preserveAspectRatio='none' \
        width="${width}" \
        height="${height}" \
        > \
        ${shape}\
        </svg>`;
  return svg;
}
function getLegend(svg, layername) {
  const html = `<div class="divLegendContainer"><div>${svg}</div><div class="divLegendDescription">${layername}</div></div>`;
  return html;
}
function legend(features, zoom) {
  const source = features.length > 0 ? features[0].source : "";
  let legend = "";
  let svg = "";
  var layername = "";

  // Légende pour POI
  if (source == "poi_osm") {
    let featurePOI = features.filter(feat => {
      if (source == "poi_osm" && feat.source == "poi_osm" && feat.layer.type === "symbol") {
        return feat;
      }
    }).map(feat => {
      feat.layer["properties"] = feat.properties;
      return feat.layer;
    });
    layername = featurePOI.length > 0 ? beautifyLayerName(featurePOI[0], source) : "";
    if (featurePOI) {
      svg = MapBoxStyleToSVG(featurePOI, zoom);
      legend = getLegend(svg, layername);
    }
    return legend;
  }

  // PLAN IGN et BDTOPO
  let stylePLANIGN = [];
  if (source == "plan_ign" || source == "bdtopo") {
    stylePLANIGN = _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.manager.layerSwitcher.layers["PLAN.IGN.INTERACTIF$TMS"].style;
  }
  var FeaturesBDTOPO = features.filter(feat => feat.source == "bdtopo");
  if (FeaturesBDTOPO.length == 0) {
    return legend;
  }
  var FeaturesPLANIGN = features.filter(feat => {
    if (source == "plan_ign" || source == "bdtopo") {
      if (feat.source == "plan_ign" && feat.layer.id.split("$$$")[0] !== "bckgrd") {
        // Dans le cas où c'est un symbole textuel et pas une icone on n'affichera pas de légende.
        if (feat.layer.type == "symbol" && !Object.hasOwnProperty.call(feat.layer.layout, "icon-image")) {
          return;
        }
        // les aplats zone bati ne sont jamais représentés dans la bdtopo
        if (feat.layer.id == "zone batie") {
          return;
        }

        // Exceptions à la règle suivante qui évite les désynchronisations
        if (feat.sourceLayer == "toponyme_bati_ponc" && FeaturesBDTOPO[0].sourceLayer == "equipement_de_transport") {
          return feat;
        }
        if (feat.sourceLayer == "bati_ponc" && ["construction_ponctuelle", "detail_hydrographique"].some(name => FeaturesBDTOPO[0].sourceLayer == name)) {
          return feat;
        }

        // pour éviter les désynchronisation Bdtopo PLANIGN  on prend feature de plan ign si correspond au type de feature bdtopo sélectionnée.
        if (feat.layer.type != FeaturesBDTOPO[0].layer.type) {
          return;
        }
        return feat;
      }
    }
  });
  if (FeaturesPLANIGN.length == 0) {
    return legend;
  }

  /**
   *  Cas où 1er élément dans bdtopo est entité dans une ZA
   *  mais 1er élément dans planIGN est ZA
   *
   *  */
  if (FeaturesPLANIGN[0].sourceLayer == "bati_zai") {
    if (FeaturesBDTOPO[0].sourceLayer != "zone_d_activite_ou_d_interet") FeaturesPLANIGN.shift();
  }

  /**
   * Gestion des groupes de légende pour PALN IGN:
   *
   * Dans le style, les éléments qui ont le même nom de groupe,
   * contenu dans cette balise,
   *
   * { "metadata" : { "legend-group" : "group-name"}}
   *
   * sont utilisés pour générer le svg de légende.
   *
   */
  var featuresForLegend = [];
  featuresForLegend = stylePLANIGN.filter(elem => {
    if (elem.id == FeaturesPLANIGN[0].layer.id) {
      return elem;
    }
    if (Object.hasOwnProperty.call(FeaturesPLANIGN[0].layer.metadata, "legend-group") && Object.hasOwnProperty.call(elem, "metadata") && Object.hasOwnProperty.call(elem.metadata, "legend-group") && FeaturesPLANIGN[0].layer.metadata["legend-group"] == elem.metadata["legend-group"]) {
      return elem;
    }
  });
  layername = FeaturesPLANIGN.length > 0 ? beautifyLayerName(FeaturesPLANIGN[0], source) : "";
  if (featuresForLegend) {
    svg = MapBoxStyleToSVG(featuresForLegend, zoom);
    legend = getLegend(svg, layername);
  }
  return legend;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  legend,
  beautifyLayerName
});
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 497:
/***/ ((module) => {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



var R = typeof Reflect === 'object' ? Reflect : null;
var ReflectApply = R && typeof R.apply === 'function' ? R.apply : function ReflectApply(target, receiver, args) {
  return Function.prototype.apply.call(target, receiver, args);
};
var ReflectOwnKeys;
if (R && typeof R.ownKeys === 'function') {
  ReflectOwnKeys = R.ownKeys;
} else if (Object.getOwnPropertySymbols) {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target).concat(Object.getOwnPropertySymbols(target));
  };
} else {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target);
  };
}
function ProcessEmitWarning(warning) {
  if (console && console.warn) console.warn(warning);
}
var NumberIsNaN = Number.isNaN || function NumberIsNaN(value) {
  return value !== value;
};
function EventEmitter() {
  EventEmitter.init.call(this);
}
module.exports = EventEmitter;
module.exports.once = once;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;
EventEmitter.prototype._events = undefined;
EventEmitter.prototype._eventsCount = 0;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
var defaultMaxListeners = 10;
function checkListener(listener) {
  if (typeof listener !== 'function') {
    throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
  }
}
Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
  enumerable: true,
  get: function () {
    return defaultMaxListeners;
  },
  set: function (arg) {
    if (typeof arg !== 'number' || arg < 0 || NumberIsNaN(arg)) {
      throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + '.');
    }
    defaultMaxListeners = arg;
  }
});
EventEmitter.init = function () {
  if (this._events === undefined || this._events === Object.getPrototypeOf(this)._events) {
    this._events = Object.create(null);
    this._eventsCount = 0;
  }
  this._maxListeners = this._maxListeners || undefined;
};

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
  if (typeof n !== 'number' || n < 0 || NumberIsNaN(n)) {
    throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + '.');
  }
  this._maxListeners = n;
  return this;
};
function _getMaxListeners(that) {
  if (that._maxListeners === undefined) return EventEmitter.defaultMaxListeners;
  return that._maxListeners;
}
EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
  return _getMaxListeners(this);
};
EventEmitter.prototype.emit = function emit(type) {
  var args = [];
  for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
  var doError = type === 'error';
  var events = this._events;
  if (events !== undefined) doError = doError && events.error === undefined;else if (!doError) return false;

  // If there is no 'error' event listener then throw.
  if (doError) {
    var er;
    if (args.length > 0) er = args[0];
    if (er instanceof Error) {
      // Note: The comments on the `throw` lines are intentional, they show
      // up in Node's output if this results in an unhandled exception.
      throw er; // Unhandled 'error' event
    }
    // At least give some kind of context to the user
    var err = new Error('Unhandled error.' + (er ? ' (' + er.message + ')' : ''));
    err.context = er;
    throw err; // Unhandled 'error' event
  }
  var handler = events[type];
  if (handler === undefined) return false;
  if (typeof handler === 'function') {
    ReflectApply(handler, this, args);
  } else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i) ReflectApply(listeners[i], this, args);
  }
  return true;
};
function _addListener(target, type, listener, prepend) {
  var m;
  var events;
  var existing;
  checkListener(listener);
  events = target._events;
  if (events === undefined) {
    events = target._events = Object.create(null);
    target._eventsCount = 0;
  } else {
    // To avoid recursion in the case that type === "newListener"! Before
    // adding it to the listeners, first emit "newListener".
    if (events.newListener !== undefined) {
      target.emit('newListener', type, listener.listener ? listener.listener : listener);

      // Re-assign `events` because a newListener handler could have caused the
      // this._events to be assigned to a new object
      events = target._events;
    }
    existing = events[type];
  }
  if (existing === undefined) {
    // Optimize the case of one listener. Don't need the extra array object.
    existing = events[type] = listener;
    ++target._eventsCount;
  } else {
    if (typeof existing === 'function') {
      // Adding the second element, need to change to array.
      existing = events[type] = prepend ? [listener, existing] : [existing, listener];
      // If we've already got an array, just append.
    } else if (prepend) {
      existing.unshift(listener);
    } else {
      existing.push(listener);
    }

    // Check for listener leak
    m = _getMaxListeners(target);
    if (m > 0 && existing.length > m && !existing.warned) {
      existing.warned = true;
      // No error code for this since it is a Warning
      // eslint-disable-next-line no-restricted-syntax
      var w = new Error('Possible EventEmitter memory leak detected. ' + existing.length + ' ' + String(type) + ' listeners ' + 'added. Use emitter.setMaxListeners() to ' + 'increase limit');
      w.name = 'MaxListenersExceededWarning';
      w.emitter = target;
      w.type = type;
      w.count = existing.length;
      ProcessEmitWarning(w);
    }
  }
  return target;
}
EventEmitter.prototype.addListener = function addListener(type, listener) {
  return _addListener(this, type, listener, false);
};
EventEmitter.prototype.on = EventEmitter.prototype.addListener;
EventEmitter.prototype.prependListener = function prependListener(type, listener) {
  return _addListener(this, type, listener, true);
};
function onceWrapper() {
  if (!this.fired) {
    this.target.removeListener(this.type, this.wrapFn);
    this.fired = true;
    if (arguments.length === 0) return this.listener.call(this.target);
    return this.listener.apply(this.target, arguments);
  }
}
function _onceWrap(target, type, listener) {
  var state = {
    fired: false,
    wrapFn: undefined,
    target: target,
    type: type,
    listener: listener
  };
  var wrapped = onceWrapper.bind(state);
  wrapped.listener = listener;
  state.wrapFn = wrapped;
  return wrapped;
}
EventEmitter.prototype.once = function once(type, listener) {
  checkListener(listener);
  this.on(type, _onceWrap(this, type, listener));
  return this;
};
EventEmitter.prototype.prependOnceListener = function prependOnceListener(type, listener) {
  checkListener(listener);
  this.prependListener(type, _onceWrap(this, type, listener));
  return this;
};

// Emits a 'removeListener' event if and only if the listener was removed.
EventEmitter.prototype.removeListener = function removeListener(type, listener) {
  var list, events, position, i, originalListener;
  checkListener(listener);
  events = this._events;
  if (events === undefined) return this;
  list = events[type];
  if (list === undefined) return this;
  if (list === listener || list.listener === listener) {
    if (--this._eventsCount === 0) this._events = Object.create(null);else {
      delete events[type];
      if (events.removeListener) this.emit('removeListener', type, list.listener || listener);
    }
  } else if (typeof list !== 'function') {
    position = -1;
    for (i = list.length - 1; i >= 0; i--) {
      if (list[i] === listener || list[i].listener === listener) {
        originalListener = list[i].listener;
        position = i;
        break;
      }
    }
    if (position < 0) return this;
    if (position === 0) list.shift();else {
      spliceOne(list, position);
    }
    if (list.length === 1) events[type] = list[0];
    if (events.removeListener !== undefined) this.emit('removeListener', type, originalListener || listener);
  }
  return this;
};
EventEmitter.prototype.off = EventEmitter.prototype.removeListener;
EventEmitter.prototype.removeAllListeners = function removeAllListeners(type) {
  var listeners, events, i;
  events = this._events;
  if (events === undefined) return this;

  // not listening for removeListener, no need to emit
  if (events.removeListener === undefined) {
    if (arguments.length === 0) {
      this._events = Object.create(null);
      this._eventsCount = 0;
    } else if (events[type] !== undefined) {
      if (--this._eventsCount === 0) this._events = Object.create(null);else delete events[type];
    }
    return this;
  }

  // emit removeListener for all listeners on all events
  if (arguments.length === 0) {
    var keys = Object.keys(events);
    var key;
    for (i = 0; i < keys.length; ++i) {
      key = keys[i];
      if (key === 'removeListener') continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners('removeListener');
    this._events = Object.create(null);
    this._eventsCount = 0;
    return this;
  }
  listeners = events[type];
  if (typeof listeners === 'function') {
    this.removeListener(type, listeners);
  } else if (listeners !== undefined) {
    // LIFO order
    for (i = listeners.length - 1; i >= 0; i--) {
      this.removeListener(type, listeners[i]);
    }
  }
  return this;
};
function _listeners(target, type, unwrap) {
  var events = target._events;
  if (events === undefined) return [];
  var evlistener = events[type];
  if (evlistener === undefined) return [];
  if (typeof evlistener === 'function') return unwrap ? [evlistener.listener || evlistener] : [evlistener];
  return unwrap ? unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
}
EventEmitter.prototype.listeners = function listeners(type) {
  return _listeners(this, type, true);
};
EventEmitter.prototype.rawListeners = function rawListeners(type) {
  return _listeners(this, type, false);
};
EventEmitter.listenerCount = function (emitter, type) {
  if (typeof emitter.listenerCount === 'function') {
    return emitter.listenerCount(type);
  } else {
    return listenerCount.call(emitter, type);
  }
};
EventEmitter.prototype.listenerCount = listenerCount;
function listenerCount(type) {
  var events = this._events;
  if (events !== undefined) {
    var evlistener = events[type];
    if (typeof evlistener === 'function') {
      return 1;
    } else if (evlistener !== undefined) {
      return evlistener.length;
    }
  }
  return 0;
}
EventEmitter.prototype.eventNames = function eventNames() {
  return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
};
function arrayClone(arr, n) {
  var copy = new Array(n);
  for (var i = 0; i < n; ++i) copy[i] = arr[i];
  return copy;
}
function spliceOne(list, index) {
  for (; index + 1 < list.length; index++) list[index] = list[index + 1];
  list.pop();
}
function unwrapListeners(arr) {
  var ret = new Array(arr.length);
  for (var i = 0; i < ret.length; ++i) {
    ret[i] = arr[i].listener || arr[i];
  }
  return ret;
}
function once(emitter, name) {
  return new Promise(function (resolve, reject) {
    function errorListener(err) {
      emitter.removeListener(name, resolver);
      reject(err);
    }
    function resolver() {
      if (typeof emitter.removeListener === 'function') {
        emitter.removeListener('error', errorListener);
      }
      resolve([].slice.call(arguments));
    }
    ;
    eventTargetAgnosticAddListener(emitter, name, resolver, {
      once: true
    });
    if (name !== 'error') {
      addErrorHandlerIfEventEmitter(emitter, errorListener, {
        once: true
      });
    }
  });
}
function addErrorHandlerIfEventEmitter(emitter, handler, flags) {
  if (typeof emitter.on === 'function') {
    eventTargetAgnosticAddListener(emitter, 'error', handler, flags);
  }
}
function eventTargetAgnosticAddListener(emitter, name, listener, flags) {
  if (typeof emitter.on === 'function') {
    if (flags.once) {
      emitter.once(name, listener);
    } else {
      emitter.on(name, listener);
    }
  } else if (typeof emitter.addEventListener === 'function') {
    // EventTarget does not have `error` event semantics like Node
    // EventEmitters, we do not listen for `error` events here.
    emitter.addEventListener(name, function wrapListener(arg) {
      // IE does not have builtin `{ once: true }` support so we
      // have to do it manually.
      if (flags.once) {
        emitter.removeEventListener(name, wrapListener);
      }
      listener(arg);
    });
  } else {
    throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + typeof emitter);
  }
}

/***/ }),

/***/ 553:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2116);
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5608);
/* harmony import */ var _capacitor_app__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3828);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_0__]);
var __webpack_async_dependencies_result__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
_globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_async_dependencies_result__[0];
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */





/**
 * Back Button
 * @todo rendre cette fonction générique
 * @todo supprimer la dependance à "MenuDisplay"
 */
const onBackKeyDown = () => {
  // Handle the back button
  const previousState = _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState.split("-")[1] || "default";
  const previousStates = _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState.split("-");
  const backState = _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState.split("-")[0];
  /* comportements custom */
  if (backState == "default") {
    _capacitor_app__WEBPACK_IMPORTED_MODULE_2__/* .App */ .q.exitApp();
    return;
  }
  if (backState === "myaccount") {
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.style.removeProperty("animation");
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.myaccount.hide();
    return;
  }
  if (backState === "informationsScreen") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("informationsScreen");
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open("myaccount");
    return;
  }
  if (backState === "newsfeed") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("newsfeed");
    return;
  }
  if (backState === "imageOverlay") {
    document.getElementById("imgOverlayClose").click();
    return;
  }
  if (backState === "layerManager") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("layerManager");
    if (previousState !== "default") {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open(previousState);
      return;
    }
    return;
  }
  if (backState === "directions") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("directions");
    if (previousState !== "default") {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open(previousState);
      return;
    }
    return;
  }
  if (backState === "searchDirections") {
    const closesearch = new Event("closesearch");
    window.dispatchEvent(closesearch);
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("searchDirections");
    return;
  }
  if (backState === "directionsSave") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("directionsSave", "routeDrawSave");
    return;
  }
  if (backState === "isochrone") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("isochrone");
    if (previousState !== "default") {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open(previousState);
      return;
    }
    return;
  }
  if (backState === "landmark") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("landmark");
    if (previousState !== "default") {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open(previousState);
      return;
    }
    return;
  }
  if (backState === "searchIsochrone") {
    const closesearch = new Event("closesearch");
    window.dispatchEvent(closesearch);
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("searchIsochrone");
    return;
  }
  if (backState === "searchLandmark") {
    const closesearch = new Event("closesearch");
    window.dispatchEvent(closesearch);
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("searchLandmark");
    return;
  }
  if (backState === "searchDownload") {
    const closesearch = new Event("closesearch");
    window.dispatchEvent(closesearch);
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("searchDownload");
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open("myaccount");
    return;
  }
  if (backState === "position") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.position.hide();
    // réouverture de menu précédent
    if (!["default", "signalement", "signalementOSM"].includes(previousState)) {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open(previousState, 0);
      return;
    }
    return;
  }
  if (backState === "poi") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("poi");
    // réouverture de menu précédent
    if (previousState !== "default") {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open(previousState);
      return;
    }
    return;
  }
  if (backState === "compareLayers1") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("compareLayers1");
    if (previousStates.includes("compareLandmark")) {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open("compareLandmark");
      return;
    }
    return;
  }
  if (backState === "compareLayers2") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("compareLayers2");
    if (previousStates.includes("compareLandmark")) {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open("compareLandmark");
      return;
    }
    return;
  }
  if (backState === "selectOnMapCompareLandmark") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("selectOnMapCompareLandmark");
    if (previousState === "compareLandmark") {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open("compareLandmark");
      return;
    }
    return;
  }
  if (backState === "routeDraw") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.hide();
    return;
  }
  if (backState === "selectOnMapDirections") {
    const closesearch = new Event("closesearch");
    window.dispatchEvent(closesearch);
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("selectOnMapDirections");
    return;
  }
  if (backState === "selectOnMapIsochrone") {
    const closesearch = new Event("closesearch");
    window.dispatchEvent(closesearch);
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("selectOnMapIsochrone");
    return;
  }
  if (backState === "selectOnMapLandmark") {
    const closesearch = new Event("closesearch");
    window.dispatchEvent(closesearch);
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("selectOnMapLandmark");
    return;
  }
  if (backState === "comparePoiActivated") {
    document.getElementById("comparePoiWindow").querySelector(".comparePoiText").classList.add("d-none");
    document.getElementById("comparePoiWindow").querySelector(".comparePoiButton").classList.remove("d-none");
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open("compare");
    return;
  }
  if (backState === "signalement") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("signalement");
    if (previousState !== "default") {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open(previousState);
      return;
    }
    return;
  }
  if (backState === "signalementOSM") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close("signalementOSM");
    if (previousState !== "default") {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.open(previousState);
      return;
    }
    return;
  }
  if (backState === "offlineMapsLocked") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.offlineMaps.unlockView();
    return;
  }
  if (backState === "offlineMapsDownloading") {
    return;
  }
  if (backState === "offlineMapsName") {
    return;
  }
  if (backState === "offlineMapsFailed") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.offlineMaps.show();
    return;
  }
  if (["informationsScreenLegal"].includes(backState)) {
    const $informationsScreenMenu = document.getElementById("informationsScreenMenu");
    $informationsScreenMenu.style.removeProperty("margin-left");
    setTimeout(() => {
      window.scrollTo({
        top: 0,
        left: 0,
        behavior: "smooth"
      });
    }, 500);
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "informationsScreen";
    return;
  }
  /* comportement par défaut */
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.menu.close(backState);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  onBackKeyDown
});
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 634:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ feature_property_filter)
});

;// ./src/js/map-interactivity/parse-osm-opening-hours.js
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */

const days = {
  "Lu": "lundi",
  "Ma": "mardi",
  "Me": "mercredi",
  "Je": "jeudi",
  "Ve": "vendredi",
  "Sa": "samedi",
  "Di": "dimanche"
};

/**
 *  Convertit un horaire OSM brut en horaire plus sympathique
 * @param {String} horaire Horaire OSM de type : "Lu-Ve 07:00-21:00/ Di 08:00-20:00"
 * @returns String horaire formaté plus joliment
 */
function parseOsmOpeningHours(horaire) {
  if (horaire === "closed") {
    return "Fermé définitivement";
  }
  const result = [];
  // cas où les différents jours sont séparés par des virgules
  if (horaire.match(/, ?[A-Z]/g)) {
    horaire = horaire.replace(/[0-9], ?L/g, "/ L");
    horaire = horaire.replace(/[0-9], ?M/g, "/ M");
    horaire = horaire.replace(/[0-9], ?J/g, "/ J");
    horaire = horaire.replace(/[0-9], ?V/g, "/ V");
    horaire = horaire.replace(/[0-9], ?S/g, "/ S");
    horaire = horaire.replace(/[0-9], ?D/g, "/ D");
  }
  const horaireSplit = horaire.split("/").map(el => el.trim());
  for (let a = 0; a < horaireSplit.length; a++) {
    if (horaireSplit[a].match(/, /g)) {
      horaireSplit[a] = horaireSplit[a].replace(/, /g, ",");
    }
    if (horaireSplit[a].match(/ ?- ?/g)) {
      horaireSplit[a] = horaireSplit[a].replace(/ ?- ?/g, "-");
    }
    const daySplit = horaireSplit[a].split(" ");
    if (daySplit[0].includes("-")) {
      const daysNames = daySplit[0].split("-");
      result.push(`du ${days[daysNames[0]]} au ${days[daysNames[1]]} `);
    } else if (daySplit[0].includes(",")) {
      const daysNames = daySplit[0].split(",");
      for (let i = 0; i < daysNames.length; i++) {
        if (i === daysNames.length - 1) {
          result.push(` et ${days[daysNames[i]]} `);
        } else {
          result.push(days[daysNames[i]]);
        }
        if (i !== daysNames.length - 2) {
          result.push(", ");
        }
      }
    } else {
      result.push(`le ${days[daySplit[0]]} `);
    }
    const hourSplit = daySplit[1].split(",");
    for (let i = 0; i < hourSplit.length; i++) {
      const hourRange = hourSplit[i].split("-");
      if (i === hourSplit.length - 1 && i > 0) {
        result.push(` et de ${hourRange[0]} à ${hourRange[1]}`);
      } else {
        result.push(`de ${hourRange[0]} à ${hourRange[1]}`);
      }
    }
    if (horaireSplit.length >= 2 && a === horaireSplit.length - 2) {
      result.push(" et ");
    } else if (horaireSplit.length > 2 && a < horaireSplit.length - 1) {
      result.push(", ");
    }
  }
  const resultString = result.join("");
  if (resultString.includes("undefined")) {
    return horaire;
  }
  return resultString[0].toUpperCase() + resultString.slice(1);
}
/* harmony default export */ const parse_osm_opening_hours = (parseOsmOpeningHours);
;// ./src/js/map-interactivity/feature-property-filter.js
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */


// import wayNameDictionnary from "./way-name-dictionnary";

/**
 *
 * @param {feature} feature maplibre issue de tuile vecteur
 * @returns chaine de caractère HTML qui décrit la feature
 */

const isIndifferencie = prop => {
  if (prop == "Indifférenciée" || prop == "Indifférencié") return true;else return false;
};
const getProperty = (feature, prop) => {
  return Object.prototype.hasOwnProperty.call(feature.properties, prop) ? feature.properties[prop] : "";
};
const featurePropertyFilter = feature => {
  let result = {
    before: "<div class='positionHtmlBefore'>",
    after: "<div class='positionHtmlAfter'>"
  };
  if (feature.source === "poi_osm") {
    let web = getProperty(feature, "web");
    let telephone = getProperty(feature, "telephone");
    let horaire = getProperty(feature, "horaire");
    if (horaire) {
      try {
        result.after += `<p class="positionHours positionInfo">Horaire : ${parse_osm_opening_hours(horaire)}</p>`;
      } catch {
        console.warn("Could not parse horaire: " + horaire);
        result.after += `<p class="positionHours positionInfo">Horaire : ${horaire}</p>`;
      }
    }
    if (web) {
      result.after += `<p class="positionWeb positionInfo"><a href="${web}" target="_blank">Accéder au site web</a></p>`;
    }
    if (telephone) {
      telephone = telephone.replace(/\s/g, "");
      const telArray = telephone.split("");
      if (telArray[0] === "0") {
        let offset = 0;
        for (let i = 2; i < 10; i += 2) {
          telArray.splice(i + offset, 0, " ");
          offset++;
        }
      } else {
        telArray.splice(3, 0, " ");
        let offset = 0;
        for (let i = 5; i < 13; i += 2) {
          telArray.splice(i + offset, 0, " ");
          offset++;
        }
      }
      result.after += `<p class="positionTelephone positionInfo"><a href="tel:${telephone}">${telArray.join("")}</a></p>`;
    }
    result.after += "</div>";
    result.before = "";
    return result;
  }

  // Pour la plupart des layers bdtopo
  let toponyme = getProperty(feature, "toponyme");
  let nature = getProperty(feature, "nature");
  let nature_detaillee = getProperty(feature, "nature_detaillee");
  let hauteur = getProperty(feature, "hauteur");

  // pas de légende bdtopo
  const noBdtopoAttr = ["surface_hydrographique", "construction_lineaire", "detail_hydrographique", "zone_d_estran", "ligne_orographique"];
  if (noBdtopoAttr.includes(feature.layer["source-layer"])) {
    result.after += "</div>";
    result.before = "";
    return result;
  }
  if (feature.layer["source-layer"] == "surface_hydrographique" && ["Marais salant", "Marais"].includes(nature)) {
    result.after += "</div>";
    result.before = "";
    return result;
  }

  //  Propriétés spécifiques reservoir
  if (feature.layer["source-layer"] == "reservoir") {
    let volume = getProperty(feature, "volume");
    if (hauteur) {
      result.before += `Hauteur : ${hauteur.toLocaleString("fr-FR")} mètres  <br/>`;
    }
    if (volume) {
      result.before = `Volume : ${volume.toLocaleString("fr-FR")} m3 <br/>`;
    }
    result.before += "</div>";
    result.after = "";
    return result;
  }

  // Propriétés spécifiques troncon_de_route
  if (feature.layer["source-layer"] == "troncon_de_route") {
    let cpx_numero = getProperty(feature, "cpx_numero");
    let cpx_toponyme_route_nommee = getProperty(feature, "cpx_toponyme_route_nommee");
    // let nom_1_droite = getProperty(feature, "nom_1_droite");
    // let nom_1_gauche = getProperty(feature, "nom_1_gauche");
    let cpx_toponyme_voie_verte = getProperty(feature, "cpx_toponyme_voie_verte");
    let cpx_toponyme_itineraire_cyclable = getProperty(feature, "cpx_toponyme_itineraire_cyclable");
    let nombre_de_voies = getProperty(feature, "nombre_de_voies");
    let voie_prive = getProperty(feature, "voie_prive");
    let acces_pieton = getProperty(feature, "acces_pieton");
    if (cpx_numero) {
      result.before += `Numéro : ${cpx_numero}<br/>`;
    }
    if (cpx_toponyme_route_nommee) {
      result.before += `Nom : ${cpx_toponyme_route_nommee}<br/>`;
    }
    // TODO: si on veut finalement afficher le nom de la route
    // } else if (nom_1_droite) {
    //   const firstWord = nom_1_droite.split(" ")[0];
    //   if (firstWord in wayNameDictionnary) {
    //     const nom_1_droite_array = nom_1_droite.split(" ");
    //     nom_1_droite_array.splice(0, 1, wayNameDictionnary[firstWord]);
    //     nom_1_droite = nom_1_droite_array.join(" ");
    //   }
    //   result.before += `Nom : ${nom_1_droite}<br/>`;
    // } else if (nom_1_gauche) {
    //   const firstWord = nom_1_gauche.split(" ")[0];
    //   if (firstWord in wayNameDictionnary) {
    //     const nom_1_gauche_array = nom_1_gauche.split(" ");
    //     nom_1_gauche_array.splice(0, 1, wayNameDictionnary[firstWord]);
    //     nom_1_gauche = nom_1_gauche_array.join(" ");
    //   }
    //   result.before += `Nom : ${nom_1_gauche}<br/>`;
    // }
    if (cpx_toponyme_voie_verte) result.before += `${cpx_toponyme_voie_verte}<br/>`;
    if (cpx_toponyme_itineraire_cyclable) result.before += `${cpx_toponyme_itineraire_cyclable}<br/>`;
    if (nombre_de_voies) {
      result.before += `Nombre de voies : ${nombre_de_voies}<br/>`;
    }
    if (acces_pieton) {
      result.before += `Mode d'accès piéton : ${acces_pieton}<br/>`;
    }
    if (voie_prive) {
      result.before += "Voie privée<br/>";
    }
    result.before += "</div>";
    result.after = "";
    return result;
  }

  //  Propriétés spécifiques batiment
  if (feature.layer["source-layer"] == "batiment") {
    // Batiment religieux
    let usage = getProperty(feature, "usage_1");
    if (usage == "Religieux" && !isIndifferencie(nature)) {
      result.before += `${nature}<br/>`;
    }
    // Autres batiments
    else {
      let nombre_de_logements = getProperty(feature, "nombre_de_logements");
      let nombre_d_etages = getProperty(feature, "nombre_d_etages");
      let date_d_apparition = getProperty(feature, "date_d_apparition");
      if (nombre_de_logements && (nature == "Bâtiment résidentiel ou quelconque" || nature == "Indifférenciée")) {
        result.before += `Nombre de logements : ${nombre_de_logements}<br/>`;
      }
      if (nombre_d_etages) {
        if (nombre_d_etages == "0") result.before += "Bâtiment de plain-pied<br/>";else result.before += `Nombre d'étages : ${nombre_d_etages}<br/>`;
      }
      if (hauteur) {
        result.before += `Hauteur : ${hauteur.toLocaleString("fr-FR")} mètres<br/>`;
      }
      if (date_d_apparition) {
        let match = date_d_apparition.match("([0-9]+)/");
        let year = match[1] ? match[1] : "";
        result.before += `Année de construction : ${year}<br/>`;
      }
    }
    result.before += "</div>";
    result.after = "";
    return result;
  }

  //  Propriétés spécifiques ligne de chemin de fer
  if (feature.layer["source-layer"] == "troncon_de_voie_ferree") {
    // Batiment
    let cpx_toponyme = getProperty(feature, "cpx_toponyme");
    let usage = getProperty(feature, "usage");
    let nombre_de_voies = getProperty(feature, "nombre_de_voies");
    if (cpx_toponyme) {
      result.before += `Nom : ${cpx_toponyme}<br/>`;
    }
    if (usage) {
      result.before += `Usage : ${usage}<br/>`;
    }
    if (nombre_de_voies) {
      result.before += `Nombre de voies : ${nombre_de_voies}<br/>`;
    }
    result.before += "</div>";
    result.after = "";
    return result;
  }
  // Régles spécifiques cimetière
  if (feature.layer["source-layer"] == "cimetiere") {
    if (nature) {
      result.before += `Cimetière ${nature.toLowerCase()}<br/>`;
    }
    result.before += "</div>";
    result.after = "";
    return result;
  }

  // Régles spécifiques réservoir
  if (feature.layer["source-layer"] == "reservoir") {
    let volume = getProperty(feature, "volume");
    if (nature) {
      result.before += `${nature}<br/>`;
    }
    if (hauteur) {
      result.before += `Hauteur : ${feature.properties.hauteur.toLocaleString("fr-FR")} mètres  <br/>`;
    }
    if (volume) {
      result.before += `Volume : ${feature.properties.volume.toLocaleString("fr-FR")} mètres  <br/>`;
    }
    result.before += "</div>";
    result.after = "";
    return result;
  }

  // Régles spécifiques construction ponctuelle
  if (feature.layer["source-layer"] == "construction_ponctuelle") {
    let date_d_apparition = getProperty(feature, "date_d_apparition");
    if (nature_detaillee) {
      result.before += `Type : ${nature_detaillee}<br/>`;
    }
    if (hauteur) {
      result.before += `Hauteur : ${feature.properties.hauteur.toLocaleString("fr-FR")} mètres  <br/>`;
    }
    if (date_d_apparition) {
      let match = date_d_apparition.match("([0-9]+)/");
      let year = match[1] ? match[1] : "";
      result.before += `Année de construction : ${year}<br/>`;
    }
    result.before += "</div>";
    result.after = "";
    return result;
  }

  // Régles spécifiques zone_de_vegetation
  if (feature.layer["source-layer"] == "zone_de_vegetation") {
    const vegetationNoAttr = ["Lande ligneuse", "Vigne", "Verger", "Forêt ouverte", "Mangrove"];
    if (!vegetationNoAttr.includes(nature)) {
      result.before += nature + "<br/>";
    }
    result.before += "</div>";
    result.after = "";
    return result;
  }

  // pour toutes les couches qui restent
  if (toponyme) {
    result.before += `<b>${toponyme}</b><br/>`;
  }
  if (nature && nature_detaillee) {
    result.before += nature + ", " + nature_detaillee + "<br/>";
  } else if (nature && !nature_detaillee) {
    result.before += nature + "<br/>";
  }
  result.before += "</div>";
  result.after = "";
  return result;
};
/* harmony default export */ const feature_property_filter = (featurePropertyFilter);

/***/ }),

/***/ 704:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   P2: () => (/* binding */ openDB)
/* harmony export */ });
/* unused harmony exports deleteDB, unwrap, wrap */
const instanceOfAny = (object, constructors) => constructors.some(c => object instanceof c);
let idbProxyableTypes;
let cursorAdvanceMethods;
// This is a function to prevent it throwing up in node environments.
function getIdbProxyableTypes() {
  return idbProxyableTypes || (idbProxyableTypes = [IDBDatabase, IDBObjectStore, IDBIndex, IDBCursor, IDBTransaction]);
}
// This is a function to prevent it throwing up in node environments.
function getCursorAdvanceMethods() {
  return cursorAdvanceMethods || (cursorAdvanceMethods = [IDBCursor.prototype.advance, IDBCursor.prototype.continue, IDBCursor.prototype.continuePrimaryKey]);
}
const transactionDoneMap = new WeakMap();
const transformCache = new WeakMap();
const reverseTransformCache = new WeakMap();
function promisifyRequest(request) {
  const promise = new Promise((resolve, reject) => {
    const unlisten = () => {
      request.removeEventListener('success', success);
      request.removeEventListener('error', error);
    };
    const success = () => {
      resolve(wrap(request.result));
      unlisten();
    };
    const error = () => {
      reject(request.error);
      unlisten();
    };
    request.addEventListener('success', success);
    request.addEventListener('error', error);
  });
  // This mapping exists in reverseTransformCache but doesn't exist in transformCache. This
  // is because we create many promises from a single IDBRequest.
  reverseTransformCache.set(promise, request);
  return promise;
}
function cacheDonePromiseForTransaction(tx) {
  // Early bail if we've already created a done promise for this transaction.
  if (transactionDoneMap.has(tx)) return;
  const done = new Promise((resolve, reject) => {
    const unlisten = () => {
      tx.removeEventListener('complete', complete);
      tx.removeEventListener('error', error);
      tx.removeEventListener('abort', error);
    };
    const complete = () => {
      resolve();
      unlisten();
    };
    const error = () => {
      reject(tx.error || new DOMException('AbortError', 'AbortError'));
      unlisten();
    };
    tx.addEventListener('complete', complete);
    tx.addEventListener('error', error);
    tx.addEventListener('abort', error);
  });
  // Cache it for later retrieval.
  transactionDoneMap.set(tx, done);
}
let idbProxyTraps = {
  get(target, prop, receiver) {
    if (target instanceof IDBTransaction) {
      // Special handling for transaction.done.
      if (prop === 'done') return transactionDoneMap.get(target);
      // Make tx.store return the only store in the transaction, or undefined if there are many.
      if (prop === 'store') {
        return receiver.objectStoreNames[1] ? undefined : receiver.objectStore(receiver.objectStoreNames[0]);
      }
    }
    // Else transform whatever we get back.
    return wrap(target[prop]);
  },
  set(target, prop, value) {
    target[prop] = value;
    return true;
  },
  has(target, prop) {
    if (target instanceof IDBTransaction && (prop === 'done' || prop === 'store')) {
      return true;
    }
    return prop in target;
  }
};
function replaceTraps(callback) {
  idbProxyTraps = callback(idbProxyTraps);
}
function wrapFunction(func) {
  // Due to expected object equality (which is enforced by the caching in `wrap`), we
  // only create one new func per func.
  // Cursor methods are special, as the behaviour is a little more different to standard IDB. In
  // IDB, you advance the cursor and wait for a new 'success' on the IDBRequest that gave you the
  // cursor. It's kinda like a promise that can resolve with many values. That doesn't make sense
  // with real promises, so each advance methods returns a new promise for the cursor object, or
  // undefined if the end of the cursor has been reached.
  if (getCursorAdvanceMethods().includes(func)) {
    return function () {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      // Calling the original function with the proxy as 'this' causes ILLEGAL INVOCATION, so we use
      // the original object.
      func.apply(unwrap(this), args);
      return wrap(this.request);
    };
  }
  return function () {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }
    // Calling the original function with the proxy as 'this' causes ILLEGAL INVOCATION, so we use
    // the original object.
    return wrap(func.apply(unwrap(this), args));
  };
}
function transformCachableValue(value) {
  if (typeof value === 'function') return wrapFunction(value);
  // This doesn't return, it just creates a 'done' promise for the transaction,
  // which is later returned for transaction.done (see idbObjectHandler).
  if (value instanceof IDBTransaction) cacheDonePromiseForTransaction(value);
  if (instanceOfAny(value, getIdbProxyableTypes())) return new Proxy(value, idbProxyTraps);
  // Return the same value back if we're not going to transform it.
  return value;
}
function wrap(value) {
  // We sometimes generate multiple promises from a single IDBRequest (eg when cursoring), because
  // IDB is weird and a single IDBRequest can yield many responses, so these can't be cached.
  if (value instanceof IDBRequest) return promisifyRequest(value);
  // If we've already transformed this value before, reuse the transformed value.
  // This is faster, but it also provides object equality.
  if (transformCache.has(value)) return transformCache.get(value);
  const newValue = transformCachableValue(value);
  // Not all types are transformed.
  // These may be primitive types, so they can't be WeakMap keys.
  if (newValue !== value) {
    transformCache.set(value, newValue);
    reverseTransformCache.set(newValue, value);
  }
  return newValue;
}
const unwrap = value => reverseTransformCache.get(value);

/**
 * Open a database.
 *
 * @param name Name of the database.
 * @param version Schema version.
 * @param callbacks Additional callbacks.
 */
function openDB(name, version) {
  let {
    blocked,
    upgrade,
    blocking,
    terminated
  } = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const request = indexedDB.open(name, version);
  const openPromise = wrap(request);
  if (upgrade) {
    request.addEventListener('upgradeneeded', event => {
      upgrade(wrap(request.result), event.oldVersion, event.newVersion, wrap(request.transaction), event);
    });
  }
  if (blocked) {
    request.addEventListener('blocked', event => blocked(
    // Casting due to https://github.com/microsoft/TypeScript-DOM-lib-generator/pull/1405
    event.oldVersion, event.newVersion, event));
  }
  openPromise.then(db => {
    if (terminated) db.addEventListener('close', () => terminated());
    if (blocking) {
      db.addEventListener('versionchange', event => blocking(event.oldVersion, event.newVersion, event));
    }
  }).catch(() => {});
  return openPromise;
}
/**
 * Delete a database.
 *
 * @param name Name of the database.
 */
function deleteDB(name) {
  let {
    blocked
  } = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const request = indexedDB.deleteDatabase(name);
  if (blocked) {
    request.addEventListener('blocked', event => blocked(
    // Casting due to https://github.com/microsoft/TypeScript-DOM-lib-generator/pull/1405
    event.oldVersion, event));
  }
  return wrap(request).then(() => undefined);
}
const readMethods = ['get', 'getKey', 'getAll', 'getAllKeys', 'count'];
const writeMethods = ['put', 'add', 'delete', 'clear'];
const cachedMethods = new Map();
function getMethod(target, prop) {
  if (!(target instanceof IDBDatabase && !(prop in target) && typeof prop === 'string')) {
    return;
  }
  if (cachedMethods.get(prop)) return cachedMethods.get(prop);
  const targetFuncName = prop.replace(/FromIndex$/, '');
  const useIndex = prop !== targetFuncName;
  const isWrite = writeMethods.includes(targetFuncName);
  if (
  // Bail if the target doesn't exist on the target. Eg, getAll isn't in Edge.
  !(targetFuncName in (useIndex ? IDBIndex : IDBObjectStore).prototype) || !(isWrite || readMethods.includes(targetFuncName))) {
    return;
  }
  const method = async function (storeName) {
    // isWrite ? 'readwrite' : undefined gzipps better, but fails in Edge :(
    const tx = this.transaction(storeName, isWrite ? 'readwrite' : 'readonly');
    let target = tx.store;
    for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
      args[_key3 - 1] = arguments[_key3];
    }
    if (useIndex) target = target.index(args.shift());
    // Must reject if op rejects.
    // If it's a write operation, must reject if tx.done rejects.
    // Must reject with op rejection first.
    // Must resolve with op value.
    // Must handle both promises (no unhandled rejections)
    return (await Promise.all([target[targetFuncName](...args), isWrite && tx.done]))[0];
  };
  cachedMethods.set(prop, method);
  return method;
}
replaceTraps(oldTraps => ({
  ...oldTraps,
  get: (target, prop, receiver) => getMethod(target, prop) || oldTraps.get(target, prop, receiver),
  has: (target, prop) => !!getMethod(target, prop) || oldTraps.has(target, prop)
}));
const advanceMethodProps = ['continue', 'continuePrimaryKey', 'advance'];
const methodMap = {};
const advanceResults = new WeakMap();
const ittrProxiedCursorToOriginalProxy = new WeakMap();
const cursorIteratorTraps = {
  get(target, prop) {
    if (!advanceMethodProps.includes(prop)) return target[prop];
    let cachedFunc = methodMap[prop];
    if (!cachedFunc) {
      cachedFunc = methodMap[prop] = function () {
        advanceResults.set(this, ittrProxiedCursorToOriginalProxy.get(this)[prop](...arguments));
      };
    }
    return cachedFunc;
  }
};
async function* iterate() {
  // tslint:disable-next-line:no-this-assignment
  let cursor = this;
  if (!(cursor instanceof IDBCursor)) {
    cursor = await cursor.openCursor(...arguments);
  }
  if (!cursor) return;
  cursor = cursor;
  const proxiedCursor = new Proxy(cursor, cursorIteratorTraps);
  ittrProxiedCursorToOriginalProxy.set(proxiedCursor, cursor);
  // Map this double-proxy back to the original, so other cursor methods work.
  reverseTransformCache.set(proxiedCursor, unwrap(cursor));
  while (cursor) {
    yield proxiedCursor;
    // If one of the advancing methods was not called, call continue().
    cursor = await (advanceResults.get(proxiedCursor) || cursor.continue());
    advanceResults.delete(proxiedCursor);
  }
}
function isIteratorProp(target, prop) {
  return prop === Symbol.asyncIterator && instanceOfAny(target, [IDBIndex, IDBObjectStore, IDBCursor]) || prop === 'iterate' && instanceOfAny(target, [IDBIndex, IDBObjectStore]);
}
replaceTraps(oldTraps => ({
  ...oldTraps,
  get(target, prop, receiver) {
    if (isIteratorProp(target, prop)) return iterate;
    return oldTraps.get(target, prop, receiver);
  },
  has(target, prop) {
    return isIteratorProp(target, prop) || oldTraps.has(target, prop);
  }
}));


/***/ }),

/***/ 799:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2116);
/* harmony import */ var _layer_switcher__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(73);
/* harmony import */ var _layer_catalogue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61);
/* harmony import */ var _layer_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(960);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_0__, _layer_switcher__WEBPACK_IMPORTED_MODULE_1__, _layer_catalogue__WEBPACK_IMPORTED_MODULE_2__, _layer_config__WEBPACK_IMPORTED_MODULE_3__]);
([_globals__WEBPACK_IMPORTED_MODULE_0__, _layer_switcher__WEBPACK_IMPORTED_MODULE_1__, _layer_catalogue__WEBPACK_IMPORTED_MODULE_2__, _layer_config__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */






/**
 * Manager des couches avec l'initialisation des 2 modules suivants :
 * - gestionnaire des couches (classique)
 * - gestion des thèmatiques et fonds de carte
 * @see LayerSwitcher
 * @see LayerCatalogue
 * @fires addlayer
 * @fires removelayer
 * @fires movelayer
 * @description
 *      → manager
 *      	→ instancie this.catalogue & this.switcher
 *     	→ ecouteurs sur les events
 *	      	* addLayer
 *	      	   → this.catalogue → call this.switcher.addLayer
 *	      	   → this.switcher → call this.updateCounter
 *	      	* removeLayer
 *	      	   → this.catalogue → call this.switcher.removeLayer
 *	      	   → this.switcher → call this.updateCounter
 *      	→ loader de couches par defaut
 *         		→ call this.catalogue.addLayer
 *
 *      → catalogue
 *        	→ this.addLayer → call add interface → fire event addLayer
 *        	→ this.removeLayer → call remove interface → fire event removeLayer
 *      → switcher
 *        	→ this.addLayer → call addContainer & addGroup & map.addLayer → fire event addLayer
 *       	  → this.removeLayer → call removeContainer & removeGroup & map.removeLayer → fire event removeLayer
 *        	→ this.moveLayer → call moveContainer & moveGroup & map.moveLayer
 *        	→ this.layervisibility
 *
 *
 */
var _LayerManager_brand = /*#__PURE__*/new WeakSet();
class LayerManager extends EventTarget {
  /**
   * constructeur
   * @param {*} options -
   * @param {*} options.target - ...
   * @param {*} options.layers - ...
   * @example
   * new LayerManger({
   *   layers : [
   *     layers : "couche1, couche2, ...",
   *     type : "base" // data ou thematic
   *   ]
   * });
   */
  constructor(options) {
    super();
    /**
       * Ecouteurs
       */
    _classPrivateMethodInitSpec(this, _LayerManager_brand);
    this.options = options || {
      /**
       * ["layerid", "layer2id"]
       */
      layers: [],
      target: null
    };
    this.layerCatalogue = null;
    this.layerSwitcher = null;
    _assertClassBrand(_LayerManager_brand, this, _render).call(this);
    _assertClassBrand(_LayerManager_brand, this, _listeners).call(this);
  }
  /**
     * Afficher le menu
     * @public
     */
  show() {}

  /**
     * Fermer le menu
     * @public
     */
  hide() {}

  /**
     * Chargement de plusieurs couches
     */
}
function _listeners() {
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.map.once("load", () => {
    _assertClassBrand(_LayerManager_brand, this, _loadLayers).call(this);
  });
  this.layerCatalogue.addEventListener("addlayer", async e => {
    await this.layerSwitcher.addLayer({
      id: e.detail.id,
      opacity: e.detail.defaultOpacity || 100,
      visible: true,
      gray: false,
      isTempLayer: e.detail.isTempLayer
    }).then(() => {});
  });
  this.layerCatalogue.addEventListener("addlayeroptions", async e => {
    await this.layerSwitcher.addLayer(e.detail).then(() => {});
  });
  this.layerCatalogue.addEventListener("removelayer", e => {
    this.layerSwitcher.removeLayer(e.detail.id, e.detail.isTempLayer);
  });
  this.layerSwitcher.addEventListener("addlayer", e => {
    /**
     * Evenement "addlayer"
     * @event addlayer
     * @type {*}
     * @property {*} id -
     * @property {*} options -
     */
    this.dispatchEvent(new CustomEvent("addlayer", {
      bubbles: true,
      detail: e.detail
    }));
    let layerInLayerDisplayed = false;
    const layerOptions = {
      id: e.detail.id,
      opacity: e.detail.options.opacity,
      visible: e.detail.options.visibility,
      gray: e.detail.options.gray,
      isTempLayer: _layer_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.getTempLayers().map(layer => layer.id).includes(e.detail.id)
    };
    for (let i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed.length; i++) {
      if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[i] === e.detail.id) {
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[i] = layerOptions;
        layerInLayerDisplayed = true;
      }
      if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[i].id === e.detail.id) {
        layerInLayerDisplayed = true;
      }
    }
    if (!layerInLayerDisplayed) {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed.push(layerOptions);
    }
    var element = document.getElementById(e.detail.id);
    element.classList.add("selectedLayer");
    _assertClassBrand(_LayerManager_brand, this, _updateLayersCounter).call(this, e.type);
  });
  this.layerSwitcher.addEventListener("removelayer", e => {
    /**
           * Evenement "removelayer"
           * @event removelayer
           * @type {*}
           * @property {*} id -
           */
    this.dispatchEvent(new CustomEvent("removelayer", {
      bubbles: true,
      detail: e.detail
    }));
    let index = -1;
    for (let i = 0; i < _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed.length; i++) {
      if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed[i].id === e.detail.id) {
        index = i;
        break;
      }
    }
    if (index >= 0) {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed.splice(index, 1);
    }
    var element = document.getElementById(e.detail.id);
    element.classList.remove("selectedLayer");
    if (e.detail.error) {
      return;
    }
    _assertClassBrand(_LayerManager_brand, this, _updateLayersCounter).call(this, e.type);
  });
  this.layerSwitcher.addEventListener("movelayer", e => {
    /**
     * Evenement "movelayer"
     * @event movelayer
     * @type {*}
     * @property {*} id -
     * @property {*} positions -
     */
    this.dispatchEvent(new CustomEvent("movelayer", {
      bubbles: true,
      detail: e.detail
    }));
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed.splice(e.detail.positions.new, 0, _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.layersDisplayed.splice(e.detail.positions.old, 1)[0]);
  });
  this.layerSwitcher.addEventListener("layervisibility", e => {
    /**
     * Evenement "movelayer"
     * @event movelayer
     * @type {*}
     * @property {*} id -
     * @property {*} positions -
     */
    this.dispatchEvent(new CustomEvent("layervisibility", {
      bubbles: true,
      detail: e.detail
    }));
  });
}
/**
   * Rendu du menu de management des couches
   */
function _render() {
  var target = this.options.target || document.getElementById("layerManagerWindow");
  if (!target) {
    console.warn();
    return;
  }

  // ajout du module thematique
  this.layerCatalogue = new _layer_catalogue__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A({
    target: document.getElementById("layer-thematics")
  });

  // ajout du module de gestionnaire de couche
  this.layerSwitcher = new _layer_switcher__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A({
    target: document.getElementById("layer-switcher")
  });
  _assertClassBrand(_LayerManager_brand, this, _getLayersAvailableCounter).call(this);
}
function _loadLayers() {
  // 1. le layer manager demande l'ajout de couches (liste) via le layer catalogue (méthode catalogue.addLayer)
  // 2. le layer catalogue modifie le dom du catalogue (statut selectionné) puis, envoie un event addlayer que le layer manager intercepte
  // 3. le layer manager demande un ajout au layer switcher (méthode switcher.addLayer)
  // 4. le layer switcher traite la demande (creation du dom), puis envoie un event addlayer de fin d'ajout
  // 5. le layer manager traite la demande du layer switcher avec une mise à jour des informations (incremente le nombre de couche)

  // le layer manager n'attend pas la fin de l'ajout de la couche courrante pour enchainer une autre couche
  // le layer manager devrait attendre la fin du 1er ajout de couche avant de passer à la suivante !
  if (this.options.layers) {
    for (let i = 0; i < this.options.layers.length; i++) {
      let layer;
      if (typeof this.options.layers[i] === "string") {
        layer = {
          id: this.options.layers[i],
          opacity: 100,
          visible: true,
          gray: false
        };
      } else {
        layer = this.options.layers[i];
      }
      this.layerCatalogue.addLayerOptions(layer);
    }
  }
}
/**
   * Mise à jour du comtpeur de couches sur le gestionnaire de couches
   * @param {*} type
   */
function _updateLayersCounter(type) {
  // cf. l'abonnement à l'ajout / suppression de couche
  var counter = document.getElementById("layer-switcher-number");
  var value = parseInt(counter.textContent, 10);
  if (type === "addlayer") {
    value++;
  }
  if (type === "removelayer") {
    value--;
  }
  counter.textContent = value;
}
/**
   * Obtient le nombre de couches du catalogue disponibles
   */
function _getLayersAvailableCounter() {
  var counter = document.getElementById("layer-thematics-number");
  var value = _layer_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.getBaseLayers().length + _layer_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.getThematicLayers().length;
  counter.textContent = value;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LayerManager);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 833:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   W: () => (/* binding */ nearestPointOnLine)
/* harmony export */ });
/* unused harmony export default */
/* harmony import */ var _turf_distance__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1906);
/* harmony import */ var _turf_meta__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3096);
/* harmony import */ var _turf_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2104);
/* harmony import */ var _turf_invariant__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2319);
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {})) if (__hasOwnProp.call(b, prop)) __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols) for (var prop of __getOwnPropSymbols(b)) {
    if (__propIsEnum.call(b, prop)) __defNormalProp(a, prop, b[prop]);
  }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));

// index.ts




function nearestPointOnLine(lines, pt) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (!lines || !pt) {
    throw new Error("lines and pt are required arguments");
  }
  const ptPos = (0,_turf_invariant__WEBPACK_IMPORTED_MODULE_3__/* .getCoord */ .uG)(pt);
  let closestPt = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_2__/* .point */ .zx)([Infinity, Infinity], {
    dist: Infinity,
    index: -1,
    multiFeatureIndex: -1,
    location: -1
  });
  let length = 0;
  (0,_turf_meta__WEBPACK_IMPORTED_MODULE_1__/* .flattenEach */ .iw)(lines, function (line, _featureIndex, multiFeatureIndex) {
    const coords = (0,_turf_invariant__WEBPACK_IMPORTED_MODULE_3__/* .getCoords */ .$R)(line);
    for (let i = 0; i < coords.length - 1; i++) {
      const start = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_2__/* .point */ .zx)(coords[i]);
      const startPos = (0,_turf_invariant__WEBPACK_IMPORTED_MODULE_3__/* .getCoord */ .uG)(start);
      const stop = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_2__/* .point */ .zx)(coords[i + 1]);
      const stopPos = (0,_turf_invariant__WEBPACK_IMPORTED_MODULE_3__/* .getCoord */ .uG)(stop);
      const sectionLength = (0,_turf_distance__WEBPACK_IMPORTED_MODULE_0__/* .distance */ .I)(start, stop, options);
      let intersectPos;
      let wasEnd;
      if (stopPos[0] === ptPos[0] && stopPos[1] === ptPos[1]) {
        [intersectPos, wasEnd] = [stopPos, true];
      } else if (startPos[0] === ptPos[0] && startPos[1] === ptPos[1]) {
        [intersectPos, wasEnd] = [startPos, false];
      } else {
        [intersectPos, wasEnd] = nearestPointOnSegment(startPos, stopPos, ptPos);
      }
      const intersectPt = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_2__/* .point */ .zx)(intersectPos, {
        dist: (0,_turf_distance__WEBPACK_IMPORTED_MODULE_0__/* .distance */ .I)(pt, intersectPos, options),
        multiFeatureIndex,
        location: length + (0,_turf_distance__WEBPACK_IMPORTED_MODULE_0__/* .distance */ .I)(start, intersectPos, options)
      });
      if (intersectPt.properties.dist < closestPt.properties.dist) {
        closestPt = __spreadProps(__spreadValues({}, intersectPt), {
          properties: __spreadProps(__spreadValues({}, intersectPt.properties), {
            // Legacy behaviour where index progresses to next segment # if we
            // went with the end point this iteration.
            index: wasEnd ? i + 1 : i
          })
        });
      }
      length += sectionLength;
    }
  });
  return closestPt;
}
function dot(v1, v2) {
  const [v1x, v1y, v1z] = v1;
  const [v2x, v2y, v2z] = v2;
  return v1x * v2x + v1y * v2y + v1z * v2z;
}
function cross(v1, v2) {
  const [v1x, v1y, v1z] = v1;
  const [v2x, v2y, v2z] = v2;
  return [v1y * v2z - v1z * v2y, v1z * v2x - v1x * v2z, v1x * v2y - v1y * v2x];
}
function magnitude(v) {
  return Math.sqrt(Math.pow(v[0], 2) + Math.pow(v[1], 2) + Math.pow(v[2], 2));
}
function normalize(v) {
  const mag = magnitude(v);
  return [v[0] / mag, v[1] / mag, v[2] / mag];
}
function lngLatToVector(a) {
  const lat = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_2__/* .degreesToRadians */ .tR)(a[1]);
  const lng = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_2__/* .degreesToRadians */ .tR)(a[0]);
  return [Math.cos(lat) * Math.cos(lng), Math.cos(lat) * Math.sin(lng), Math.sin(lat)];
}
function vectorToLngLat(v) {
  const [x, y, z] = v;
  const zClamp = Math.min(Math.max(z, -1), 1);
  const lat = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_2__/* .radiansToDegrees */ .nv)(Math.asin(zClamp));
  const lng = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_2__/* .radiansToDegrees */ .nv)(Math.atan2(y, x));
  return [lng, lat];
}
function nearestPointOnSegment(posA, posB, posC) {
  const A = lngLatToVector(posA);
  const B = lngLatToVector(posB);
  const C = lngLatToVector(posC);
  const segmentAxis = cross(A, B);
  if (segmentAxis[0] === 0 && segmentAxis[1] === 0 && segmentAxis[2] === 0) {
    if (dot(A, B) > 0) {
      return [[...posB], true];
    } else {
      return [[...posC], false];
    }
  }
  const targetAxis = cross(segmentAxis, C);
  if (targetAxis[0] === 0 && targetAxis[1] === 0 && targetAxis[2] === 0) {
    return [[...posB], true];
  }
  const intersectionAxis = cross(targetAxis, segmentAxis);
  const I1 = normalize(intersectionAxis);
  const I2 = [-I1[0], -I1[1], -I1[2]];
  const I = dot(C, I1) > dot(C, I2) ? I1 : I2;
  const segmentAxisNorm = normalize(segmentAxis);
  const cmpAI = dot(cross(A, I), segmentAxisNorm);
  const cmpIB = dot(cross(I, B), segmentAxisNorm);
  if (cmpAI >= 0 && cmpIB >= 0) {
    return [vectorToLngLat(I), false];
  }
  if (dot(A, C) > dot(B, C)) {
    return [[...posA], false];
  } else {
    return [[...posB], true];
  }
}
var index_default = (/* unused pure expression or super */ null && (nearestPointOnLine));


/***/ }),

/***/ 835:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _layer_manager_layer_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(960);
/* harmony import */ var maplibre_gl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2461);
/* harmony import */ var maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(maplibre_gl__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var proj4__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3387);
/* harmony import */ var _turf_point_to_line_distance__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5402);
/* harmony import */ var _turf_clean_coords__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3983);
/* harmony import */ var _utils_request_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4307);
/* harmony import */ var _turf_circle__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3348);
/* harmony import */ var _turf_points_within_polygon__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6466);
/* harmony import */ var _utils_config_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(7650);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_layer_manager_layer_config__WEBPACK_IMPORTED_MODULE_0__, _utils_config_utils__WEBPACK_IMPORTED_MODULE_8__]);
([_layer_manager_layer_config__WEBPACK_IMPORTED_MODULE_0__, _utils_config_utils__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */










proj4__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.defs("EPSG:2154", "+proj=lcc +lat_0=46.5 +lon_0=3 +lat_1=49 +lat_2=44 +x_0=700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs +type=crs");

/**
 * Gestion de la "position immersive" avec des requêtes faites aux données autour d'une position
 * @fires dataLoaded
 */
var _ImmersivePosion_brand = /*#__PURE__*/new WeakSet();
class ImmersivePosion extends EventTarget {
  /**
   * constructeur
   * @param {*} options -
   * @param {*} options.lat - latitude
   * @param {*} options.lng - longitude
   */
  constructor(options) {
    super();
    /**
     * Queries GPF's WFS for info defined in the config
     */
    _classPrivateMethodInitSpec(this, _ImmersivePosion_brand);
    this.options = options || {
      lat: 0,
      lng: 0
    };
    this.lat = this.options.lat;
    this.lng = this.options.lng;
    this.data = {};
    this.hasFeuillu = false;
    this.hasConnifere = false;
    this.hasNatural2000 = false;
  }

  /**
   * Computes html string from available data
   */
  computeHtml() {
    let htmlTemplate = "";
    if (_layer_manager_layer_config__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.getTempLayers().length > 0) {
      let eventsHtml = "<div class=\"event\">";
      let hasOneEvent = false;
      for (let i = 0; i < _layer_manager_layer_config__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.getTempLayers().length; i++) {
        const layer = _layer_manager_layer_config__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.getTempLayers()[i];
        if (this.data[layer.id]) {
          hasOneEvent = true;
          eventsHtml += `<p class="eventImmersiveHeader"><span class="eventImmersiveImg" style="background-image:url(${layer.quickLookUrl}"></span> ${layer.name}&nbsp;:</p>${this.data[layer.id]}`;
        }
      }
      eventsHtml += "</div>";
      if (hasOneEvent) {
        htmlTemplate += eventsHtml;
      }
    }
    htmlTemplate += `
      <p>&#x1F3E0; Vous êtes sur la commune de ${this.data["LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:commune"] ? this.data["LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:commune"][0][0] : "chargement..."}, qui compte ${this.data["LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:commune"] ? parseInt(this.data["LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:commune"][0][1]).toLocaleString() : "chargement..."} habitants, située dans le département de ${this.data["LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:departement"] ? this.data["LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:departement"][0] : "chargement..."}</p>
    `;
    if (this.data["BDTOPO_V3:parc_ou_reserve"] && this.data["BDTOPO_V3:parc_ou_reserve"].length) {
      let parcHtml = "<p>";
      for (let i = 0; i < this.data["BDTOPO_V3:parc_ou_reserve"].length; i++) {
        let egalementStr = i === 0 ? "" : "également ";
        if (["Parc naturel régional", "Parc national"].includes(this.data["BDTOPO_V3:parc_ou_reserve"][i][0])) {
          parcHtml += `&#x1F3DE;&#xFE0F; Vous êtes ${egalementStr}situé au sein du ${this.data["BDTOPO_V3:parc_ou_reserve"][i][1]}. `;
        } else if (["Réserve naturelle"].includes(this.data["BDTOPO_V3:parc_ou_reserve"][i][0])) {
          parcHtml += `Vous êtes ${egalementStr}situé au sein de la ${this.data["BDTOPO_V3:parc_ou_reserve"][i][1]}. `;
        } else if (this.data["BDTOPO_V3:parc_ou_reserve"][i][0] === "Site Natura 2000") {
          let name = this.data["BDTOPO_V3:parc_ou_reserve"].length === 1 ? ` (${this.data["BDTOPO_V3:parc_ou_reserve"][i][1]})` : "";
          parcHtml += `Vous êtes sur un site classé Natura 2000${name} où la faune et la flore sont protégées.`;
        } else {
          parcHtml += `Vous êtes ${egalementStr}situé au sein du/de la ${this.data["BDTOPO_V3:parc_ou_reserve"][i][0]} de ${this.data["BDTOPO_V3:parc_ou_reserve"][i][1]}. `;
        }
      }
      parcHtml += "</p>";
      htmlTemplate += parcHtml;
    }
    if (this.data["BDTOPO_V3:foret_publique"] && this.data["BDTOPO_V3:foret_publique"].length) {
      let forestHTML;
      if (this.data["Essence intesection"] && this.data["Essence intesection"].length) {
        forestHTML = `
          <p>Vous vous trouvez dans la ${this.data["BDTOPO_V3:foret_publique"][0]}, dont l'essence principale est ${this.data["Essence intesection"][0]}</p>
        `;
      } else {
        forestHTML = `
          <p>Vous vous trouvez dans la ${this.data["BDTOPO_V3:foret_publique"][0]}.</p>
        `;
      }
      htmlTemplate += forestHTML;
    }
    if (this.data["BDTOPO_V3:toponymie_lieux_nommes"] && this.data["BDTOPO_V3:toponymie_lieux_nommes"].length) {
      let boisList = this.data["BDTOPO_V3:toponymie_lieux_nommes"][0];
      for (let i = 1; i < this.data["BDTOPO_V3:toponymie_lieux_nommes"].length; i++) {
        boisList += ", " + this.data["BDTOPO_V3:toponymie_lieux_nommes"][i];
      }
      const boisHtml = `<p>Vous êtes à proximité des bois suivants : ${boisList}.</p>`;
      htmlTemplate += boisHtml;
    }
    if (this.data["LANDCOVER.FORESTINVENTORY.V2:formation_vegetale"] && this.data["LANDCOVER.FORESTINVENTORY.V2:formation_vegetale"].length) {
      let plantHtml;
      let feuilluStr = this.hasFeuillu ? "&#127795; " : "";
      let connifereStr = this.hasConnifere ? "&#127794; " : "";
      if (this.data["LANDCOVER.FORESTINVENTORY.V2:formation_vegetale"].length === 1) {
        plantHtml = `
          <p>Aux alentours, l’essence des bois et forêts est principalement constituée de ${feuilluStr}${connifereStr} ${this.data["LANDCOVER.FORESTINVENTORY.V2:formation_vegetale"][0]}.`;
      } else {
        let essenceList = this.data["LANDCOVER.FORESTINVENTORY.V2:formation_vegetale"][0];
        for (let i = 1; i < this.data["LANDCOVER.FORESTINVENTORY.V2:formation_vegetale"].length - 1; i++) {
          essenceList += ", " + this.data["LANDCOVER.FORESTINVENTORY.V2:formation_vegetale"][i];
        }
        essenceList += " et " + this.data["LANDCOVER.FORESTINVENTORY.V2:formation_vegetale"][this.data["LANDCOVER.FORESTINVENTORY.V2:formation_vegetale"].length - 1];
        plantHtml = `
          <p>Aux alentours, l’essence des bois et forêts est principalement constituée de ${feuilluStr}${connifereStr} ${essenceList}.`;
      }
      if (this.data["RPG.LATEST:parcelles_graphiques"] && this.data["RPG.LATEST:parcelles_graphiques"].length) {
        let cultureList = this.data["RPG.LATEST:parcelles_graphiques"][0];
        if (this.data["RPG.LATEST:parcelles_graphiques"].length > 1) {
          for (let i = 1; i < this.data["RPG.LATEST:parcelles_graphiques"].length - 1; i++) {
            cultureList += ", " + this.data["RPG.LATEST:parcelles_graphiques"][i];
          }
          cultureList += " et " + this.data["RPG.LATEST:parcelles_graphiques"][this.data["RPG.LATEST:parcelles_graphiques"].length - 1];
        }
        plantHtml += ` L'agriculture est dédiée à la production de cultures telles que ${cultureList}.`;
      }
      plantHtml += "</p>";
      htmlTemplate += plantHtml;
    } else if (this.data["RPG.LATEST:parcelles_graphiques"] && this.data["RPG.LATEST:parcelles_graphiques"].length) {
      let cultureList = this.data["RPG.LATEST:parcelles_graphiques"][0];
      if (this.data["RPG.LATEST:parcelles_graphiques"].length > 1) {
        for (let i = 1; i < this.data["RPG.LATEST:parcelles_graphiques"].length - 1; i++) {
          cultureList += ", " + this.data["RPG.LATEST:parcelles_graphiques"][i];
        }
        cultureList += " et " + this.data["RPG.LATEST:parcelles_graphiques"][this.data["RPG.LATEST:parcelles_graphiques"].length - 1];
      }
      const plantHtml = `Aux alentours, l'agriculture est dédiée à la production de cultures telles que ${cultureList}.</p>`;
      htmlTemplate += plantHtml;
    }
    if (this.data["BDTOPO_V3:cours_d_eau"] && this.data["BDTOPO_V3:cours_d_eau"].length) {
      let waterList = this.data["BDTOPO_V3:cours_d_eau"][0][0];
      for (let i = 1; i < this.data["BDTOPO_V3:cours_d_eau"].length; i++) {
        waterList += ", " + this.data["BDTOPO_V3:cours_d_eau"][i][0];
      }
      if (this.data["BDTOPO_V3:plan_d_eau"] && this.data["BDTOPO_V3:plan_d_eau"].length) {
        for (let i = 0; i < this.data["BDTOPO_V3:plan_d_eau"].length; i++) {
          waterList += ", " + this.data["BDTOPO_V3:plan_d_eau"][i][1];
        }
      }
      const waterHtml = `<p>&#x1F30A; Les cours d'eau environnants sont ${waterList}.</p>`;
      htmlTemplate += waterHtml;
    } else if (this.data["BDTOPO_V3:plan_d_eau"] && this.data["BDTOPO_V3:plan_d_eau"].length) {
      let waterList = this.data["BDTOPO_V3:plan_d_eau"][0][1];
      for (let i = 1; i < this.data["BDTOPO_V3:plan_d_eau"].length; i++) {
        waterList += ", " + this.data["BDTOPO_V3:plan_d_eau"][i][1];
      }
      const waterHtml = `<p>&#x1F30A; Les cours d'eau environnants sont ${waterList}.</p>`;
      htmlTemplate += waterHtml;
    }
    if (this.data["BDTOPO_V3:zone_d_habitation"] && this.data["BDTOPO_V3:zone_d_habitation"].length) {
      let otherList = "&#x1F3F0; " + this.data["BDTOPO_V3:zone_d_habitation"][0];
      for (let i = 1; i < this.data["BDTOPO_V3:zone_d_habitation"].length; i++) {
        otherList += ", " + this.data["BDTOPO_V3:zone_d_habitation"][i];
      }
      if (this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"] && this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"].length) {
        for (let i = 0; i < this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"].length; i++) {
          otherList += `, ${this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"][i][1]} (${this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"][i][0]})`;
        }
      }
      const otherHtml = `<p>&#x1F9D0; Non loin se trouvent également : ${otherList}.</p>`;
      htmlTemplate += otherHtml;
    } else if (this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"] && this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"].length) {
      let otherList = `${this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"][0][1]} (${this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"][0][0]})`;
      for (let i = 1; i < this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"].length; i++) {
        if (this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"][i][0] === "Construction") {
          otherList += `, ${this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"][i][1]}`;
        } else {
          otherList += `, ${this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"][i][1]} (${this.data["BDTOPO_V3:zone_d_activite_ou_d_interet"][i][0]})`;
        }
      }
      const otherHtml = `<p>&#x1F9D0; Non loin se trouvent également : ${otherList}.</p>`;
      htmlTemplate += otherHtml;
    }
    return htmlTemplate;
  }

  /**
   * Computes all data queries
   */
  computeAll() {
    // Regular WFS layers
    _utils_config_utils__WEBPACK_IMPORTED_MODULE_8__/* .config */ .$.queryConfig.forEach(config => {
      _assertClassBrand(_ImmersivePosion_brand, this, _computeFromConfig).call(this, config);
    });

    // Temporary event layers
    if (_layer_manager_layer_config__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.getTempLayers().length > 0) {
      for (let i = 0; i < _layer_manager_layer_config__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.getTempLayers().length; i++) {
        const layer = _layer_manager_layer_config__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.getTempLayers()[i];
        if (layer.dontShowInImmersive) {
          continue;
        }
        let url = layer.layerUrl;
        if (layer.layerUrl.includes("pmtiles://")) {
          url = layer.layerUrl.replace("pmtiles://", "").replace(".pmtiles", ".geojson");
        }
        fetch(url).then(response => {
          if (response.ok) {
            return response.json();
          } else {
            throw new Error("Network response was not ok.");
          }
        }).then(data => {
          const refCircle = (0,_turf_circle__WEBPACK_IMPORTED_MODULE_6__/* .circle */ .n)([this.lng, this.lat], 3);
          const points = (0,_turf_points_within_polygon__WEBPACK_IMPORTED_MODULE_7__/* .pointsWithinPolygon */ .n)(data, refCircle);
          points.features = points.features.sort((a, b) => {
            const coordsA = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(...a.geometry.coordinates);
            const coordsB = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(...b.geometry.coordinates);
            const coordsRef = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(this.lng, this.lat);
            return coordsRef.distanceTo(coordsA) - coordsRef.distanceTo(coordsB);
          }).slice(0, 12);
          const results = [];
          points.features.forEach(feature => {
            results.push("<span class=\"eventPuce\"></span>" + feature.properties.title);
          });
          this.data[layer.id] = results.join("<br />");
          this.dispatchEvent(new CustomEvent("dataLoaded", {
            bubbles: true
          }));
        }).catch(error => {
          console.warn("Error fetching data:", error);
        });
      }
    }
  }
}
async function _computeFromConfig(config) {
  const result = await _assertClassBrand(_ImmersivePosion_brand, this, _computeGenericGPFWFS).call(this, config.layer, config.attributes, config.around || 0, config.geom_name || "geom", config.additional_cql || "", config.epsg || 4326, config.get_geom || false);
  this.data[config.id] = result;
  this.dispatchEvent(new CustomEvent("dataLoaded", {
    bubbles: true
  }));
}
/**
 * Filters the data results according to specific rules
 * @param {String} layer
 * @param {Array} dataResults
 * @returns
 */
function _filterData(layer, dataResults) {
  if (layer === "LANDCOVER.FORESTINVENTORY.V2:formation_vegetale") {
    dataResults = dataResults.filter(essence => essence !== "NC" && essence !== "NR");
  }
  if (layer === "BDTOPO_V3:parc_ou_reserve") {
    dataResults = dataResults.filter(parc => {
      if (!["Site Natura 2000", "Parc naturel régional", "Parc national", "Réserve naturelle"].includes(parc[0])) {
        return false;
      }
      if (["Périmètre de protection d'une réserve naturelle nationale", "Périmètre de protection d'une réserve naturelle régionale"].includes(parc[2])) {
        return false;
      }
      if (parc[0] === "Site Natura 2000") {
        if (this.hasNatural2000) {
          return false;
        }
        this.hasNatural2000 = true;
      }
      return true;
    }).sort((a, b) => {
      if (a[0] === "Parc national") {
        return -1;
      }
      if (b[0] === "Parc national") {
        return 1;
      }
      if (b[0] === "Parc naturel régional" && a[0] !== "Parc national") {
        return 1;
      }
      if (a[0] === "Parc naturel régional" && b[0] !== "Parc national") {
        return -1;
      }
      if (a[0] === "Site Natura 2000") {
        return 1;
      }
      if (b[0] === "Site Natura 2000") {
        return -1;
      }
    });
  }
  if (layer === "BDTOPO_V3:zone_d_activite_ou_d_interet") {
    dataResults = dataResults.filter(zai => zai[1] !== null).sort((a, b) => {
      const coordsA = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(...a[2].coordinates[0][0][0]);
      const coordsB = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(...b[2].coordinates[0][0][0]);
      const coordsRef = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(this.lng, this.lat);
      return coordsRef.distanceTo(coordsA) - coordsRef.distanceTo(coordsB);
    }).slice(0, 5);
  }
  if (layer === "BDTOPO_V3:plan_d_eau") {
    dataResults = dataResults.filter(plan => plan[1] !== null);
  }
  if (layer === "RPG.LATEST:parcelles_graphiques") {
    dataResults = dataResults.map(code_cultu => _utils_config_utils__WEBPACK_IMPORTED_MODULE_8__/* .config */ .$.code_cultuCaption[code_cultu]).filter(culture => culture);
  }
  if (layer === "LANDCOVER.FORESTINVENTORY.V2:formation_vegetale") {
    dataResults = dataResults.map(code_tfv => {
      if (_utils_config_utils__WEBPACK_IMPORTED_MODULE_8__/* .config */ .$.code_tfvCaption[code_tfv]) {
        if (code_tfv[2] === "1") {
          this.hasFeuillu = true;
        }
        if (code_tfv[2] === "2") {
          this.hasConnifere = true;
        }
      }
      return _utils_config_utils__WEBPACK_IMPORTED_MODULE_8__/* .config */ .$.code_tfvCaption[code_tfv];
    }).filter(essence => essence);
  }
  if (layer === "BDTOPO_V3:zone_d_habitation") {
    dataResults = dataResults.filter(feat => feat[0]).sort((a, b) => {
      const coordsA = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(...a[1].coordinates[0][0][0]);
      const coordsB = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(...b[1].coordinates[0][0][0]);
      const coordsRef = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_1___default().LngLat)(this.lng, this.lat);
      return coordsRef.distanceTo(coordsA) - coordsRef.distanceTo(coordsB);
    }).map(feat => feat[0]).slice(0, 5);
  }
  if (layer === "BDTOPO_V3:cours_d_eau") {
    dataResults = dataResults.filter(cours => {
      if (cours[0].split(" ")[0] === "Bras") {
        return false;
      }
      const splitted = cours[0].split(" ");
      for (let word of splitted) {
        if (word.match(/[0-9][0-9]/g)) {
          return false;
        }
      }
      return true;
    }).sort((a, b) => {
      let featureA = a[1];
      if (featureA.type === "MultiLineString") {
        featureA = {
          type: "LineString",
          coordinates: featureA.coordinates[0]
        };
      }
      let featureB = b[1];
      if (featureB.type === "MultiLineString") {
        featureB = {
          type: "LineString",
          coordinates: featureB.coordinates[0]
        };
      }
      const distanceA = (0,_turf_point_to_line_distance__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)([this.lng, this.lat], (0,_turf_clean_coords__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)(featureA));
      const distanceB = (0,_turf_point_to_line_distance__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)([this.lng, this.lat], (0,_turf_clean_coords__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)(featureB));
      return distanceA - distanceB;
    });
  }
  return dataResults;
}
/**
 * Computes data for a given layer of Geoplateforme's WFS
 * @param {string} layer name of the WFS layer
 * @param {Array} attributes list of strings of the relevant attributes to return
 * @param {number} around distance around the point in km for the query, default 0
 * @param {string} geom_name name of the geometry column, default "geom"
 * @param {string} additional_cql cql filter needed other than geometry, e.g. "AND nature_de_l_objet='Bois'", default ""
 * @param {number} epsg epsg number of the layer's CRS, default 4326
 * @returns {Promise(Array)} results of each attributes (no duplicates)
 */
async function _computeGenericGPFWFS(layer, attributes) {
  let around = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
  let geom_name = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "geom";
  let additional_cql = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : "";
  let epsg = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 4326;
  let getGeom = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : false;
  const results_attributes = await _utils_request_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.requestWfs(this.lat, this.lng, layer, attributes, around, geom_name, additional_cql, epsg, getGeom);
  return Array.from(new Set(_assertClassBrand(_ImmersivePosion_brand, this, _filterData).call(this, layer, results_attributes)));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ImmersivePosion);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 960:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_config_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7650);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_config_utils__WEBPACK_IMPORTED_MODULE_0__]);
var __webpack_async_dependencies_result__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
_utils_config_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_async_dependencies_result__[0];
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */

/**
 * API de configuration des couches :
 * - couches de base (fonds de carte)
 * - couches de données
 * - couches thématiques
 * @description
 * Les propriétés des couches sont issues de "l'autoconf",
 * et elles sont transformées en configuration de couches Raster et Vector pour MapLibre.
 * La liste des couches de fonds et thématiques est definie dans un fichier de configuration.
 * @todo prévoir le multi couche pour les couches vecteurs tuilés
 */



/**
 * Obtenir la liste des propriétés d'une couche
 * @param {*} id
 * @returns
 */
const getLayerProps = id => {
  var props = _utils_config_utils__WEBPACK_IMPORTED_MODULE_0__/* .config */ .$.configLayers.layers[id];
  var isVector = id.split("$")[1] === "TMS" ? true : false;
  var style;
  if (isVector) {
    style = props.styles[0];
  } else {
    style = props.style || "normal";
  }
  var fallbackStyle = "";
  if (isVector) {
    fallbackStyle = props.styles[1];
  }
  var format = props.format;
  var minNativeZoom = props.minNativeZoom || 0;
  var maxNativeZoom = props.maxNativeZoom || 20;
  var interactive = !(props.interactive === false);
  var defaultOpacity = props.defaultOpacity || 100;
  var quickLookUrl = props.quickLookUrl || "data/img/layers/" + id.split("$")[0] + ".jpg";
  var legendUrl = props.legendUrl || "data/img/legends/" + id.split("$")[0] + ".png";
  return {
    layer: id.split("$")[0],
    base: getBaseLayers().includes(id),
    // couche de fonds ou autre
    title: props.title,
    desc: props.description,
    source: props.source || "",
    maj: props.maj || "",
    type: isVector ? "vector" : "raster",
    style: isVector ? style : style || "normal",
    fallbackStyle: isVector ? fallbackStyle : style || "normal",
    format: format || "",
    url: props.serverUrl,
    minNativeZoom: minNativeZoom,
    maxNativeZoom: maxNativeZoom,
    interactive: interactive,
    defaultOpacity: defaultOpacity,
    quickLookUrl: quickLookUrl,
    legendUrl: legendUrl
  };
};

/**
 * Obtenir la liste des propriétés d'une couche temporaire
 * @param {*} id
 * @returns
 */
const getTempLayerProps = id => {
  var props = JSON.parse(JSON.stringify(_utils_config_utils__WEBPACK_IMPORTED_MODULE_0__/* .config */ .$.tempLayers)).filter(elem => elem.id === id)[0];
  return {
    layer: props.id,
    base: false,
    // couche de fonds ou autre
    title: props.name,
    desc: props.description,
    source: props.source || "",
    maj: props.maj || "",
    type: props.layerSourceType,
    style: "",
    fallbackStyle: "",
    format: "",
    url: props.layerUrl,
    minNativeZoom: 0,
    maxNativeZoom: 20,
    interactive: true,
    quickLookUrl: props.quickLookUrl,
    layerType: props.layerType,
    layerDef: props.layer
  };
};

/**
 * Liste des couches de fonds
 * @returns
 */
const getBaseLayers = () => {
  return _utils_config_utils__WEBPACK_IMPORTED_MODULE_0__/* .config */ .$.baseLayers["base-layers"];
};

/**
 * Liste des couches RLT
 * @returns
 */
const getRLTLayers = () => {
  return _utils_config_utils__WEBPACK_IMPORTED_MODULE_0__/* .config */ .$.baseLayers["rlt-layers"];
};

/**
 * Liste des couches thématiques
 * (le tri alpha est realisé)
 * @returns
 */
const getThematicLayers = () => {
  var arrays = _utils_config_utils__WEBPACK_IMPORTED_MODULE_0__/* .config */ .$.thematicLayers.filter(o => o.name !== "Évènements").map(o => {
    return o.layers;
  });
  return arrays.flat();
};

/**
 * Liste des couches temporaires
 * @returns
 */
const getTempLayers = () => {
  return JSON.parse(JSON.stringify(_utils_config_utils__WEBPACK_IMPORTED_MODULE_0__/* .config */ .$.tempLayers));
};

/**
 * Liste des thémes
 * (l'ordre est defini dans le json)
 * @returns
 */
const getThematics = () => {
  return _utils_config_utils__WEBPACK_IMPORTED_MODULE_0__/* .config */ .$.thematicLayers.map(o => {
    return o.name;
  });
};

/**
 * Liste des couches pour un théme
 * (le tri alpha est realisé)
 * @param {*} name
 * @returns
 * @todo prévoir les couches vecteurs tuilées
 */
const getLayersByThematic = name => {
  var data = _utils_config_utils__WEBPACK_IMPORTED_MODULE_0__/* .config */ .$.thematicLayers.find(element => {
    return element.name === name;
  });
  if (data.settings && data.settings.generic) {
    return getThematicLayers().concat(getTempLayers().map(layer => layer.id));
  }
  return data.layers;
};

/**
 * Obtenir le thème d'une couche
 * @param {*} id
 * @returns
 */
const getThematicByLayerID = id => {
  var data = _utils_config_utils__WEBPACK_IMPORTED_MODULE_0__/* .config */ .$.thematicLayers.find(element => {
    return element.layers.includes(id);
  });
  return data.name;
};

/**
 * Creer les propriétés d'une couche (source) pour la librairie MapLibre
 * @param {*} id
 */
const createSource = id => {
  // ex. "GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN50.1950$WMTS"
  var name = id.split("$")[0];
  var service = id.split("$")[1];
  var fxt;
  switch (service) {
    case "WMTS":
      fxt = createRasterTileSource;
      break;
    case "WMS":
      fxt = createRasterSource;
      break;
    case "TMS":
      // INFO
      // les couches tuiles vectorielles ne devrait pas être pré chargées car
      // on ne connait pas encore la liste exhaustive des sources contenues
      // dans le fichier de style.
      fxt = createVectorSource;
      break;
    default:
      throw new Error(`LayerConfig : ID layer service (${name}) is not conforme : ${service}`);
  }
  return fxt(id);
};

/**
 * Creer les propriétés d'une couche (source) pour la librairie MapLibre
 * @param {*} layer
 */
const createTempSource = layer => {
  var name = layer.id;
  var type = layer.layerSourceType;
  var fxt;
  switch (type) {
    case "raster":
      fxt = createTempRasterSource;
      break;
    case "vector":
      fxt = createTempVectorSource;
      break;
    case "geojson":
      fxt = createTempGeojsonSource;
      break;
    default:
      throw new Error(`LayerConfig : ID layer service (${name}) is not conforme : ${type}`);
  }
  return fxt(layer);
};

/**
 * Creer les propriétés d'une couche de type Tile Raster pour la librairie MapLibre
 * @param {*} id
 * @returns
 */
const createRasterTileSource = id => {
  var props = getLayerProps(id);
  var url = `${props.url}?` + "REQUEST=GetTile&SERVICE=WMTS&VERSION=1.0.0&" + `STYLE=${props.style}&` + "TILEMATRIXSET=PM&" + `FORMAT=${props.format}&` + `LAYER=${props.layer}&` + "TILEMATRIX={z}&" + "TILEROW={y}&" + "TILECOL={x}";
  if (props.url.includes("/private/")) {
    // Ajout de la clef d'API de l'appli si l'URL est privée
    url += `&apikey=${"FDroid-9kplw8an"}`;
  }
  return {
    type: "raster",
    tiles: [url],
    tileSize: 256,
    maxzoom: props.maxNativeZoom,
    minzoom: props.minNativeZoom
  };
};

/**
 * Creer les propriétés d'une couche de type Vector pour la librairie MapLibre
 * @param {*} id
 */
const createVectorSource = id => {
  var props = getLayerProps(id);
  var url = props.url + props.layer + "/{z}/{x}/{y}.pbf";
  return {
    type: "vector",
    tiles: [url],
    maxzoom: props.maxNativeZoom,
    minzoom: props.minNativeZoom
  };
};

/**
 * Creer les propriétés d'une couche de type Vector pour la librairie MapLibre
 * @param {*} layer
 */
const createTempVectorSource = layer => {
  // PM tiles uniquement pour les temp layers @see https://docs.protomaps.com/pmtiles/maplibre#installation
  return {
    type: "vector",
    url: layer.layerUrl
  };
};

/**
 * Creer les propriétés d'une couche de type geojson pour la librairie MapLibre
 * @param {*} layer
 */
const createTempGeojsonSource = layer => {
  return {
    type: "geojson",
    data: layer.layerUrl,
    maxzoom: layer.maxNativeZoom || 20
  };
};

/**
 * Creer les propriétés d'une couche de type geojson pour la librairie MapLibre
 * @param {*} layer
 */
const createTempRasterSource = layer => {
  return {
    type: "raster",
    tiles: [layer.layerUrl],
    tileSize: layer.tileSize || 256,
    maxzoom: layer.maxNativeZoom || 20,
    minzoom: layer.minNativeZoom || 0
  };
};

/**
 * Creer les propriétés d'une couche de type Raster pour la librairie MapLibre
 * @param {*} id
 */
const createRasterSource = id => {
  var props = getLayerProps(id);
  var url = `${props.url}` + "REQUEST=GetMap&VERSION=1.3.0&" + "BBOX={bbox-epsg-3857}&" + "SRS=EPSG:3857&" + `FORMAT=${props.format}&` + `LAYERS=${props.layer}&` + "TRANSPARENT=true&" + "WIDTH=256&" + "HEIGHT=256";
  if (props.url.includes("/private/")) {
    // Ajout de la clef d'API de l'appli si l'URL est privée
    url += `&apikey=${"FDroid-9kplw8an"}`;
  }
  return {
    type: "raster",
    tiles: [url],
    tileSize: 256,
    maxzoom: props.maxNativeZoom,
    minzoom: props.minNativeZoom
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  getLayerProps,
  getBaseLayers,
  getRLTLayers,
  getThematicLayers,
  getThematics,
  getTempLayers,
  getTempLayerProps,
  getLayersByThematic,
  getThematicByLayerID,
  baseLayerSources: Object.fromEntries(getBaseLayers().map(id => [id, createSource(id)])),
  rltLayerSources: Object.fromEntries(getRLTLayers().map(id => [id, createSource(id)])),
  thematicLayerSources: Object.fromEntries(getThematicLayers().map(id => [id, createSource(id)])),
  tempLayerSources: Object.fromEntries(getTempLayers().map(layer => [layer.id, createTempSource(layer)]))
});
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 965:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2116);
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5608);
/* harmony import */ var _newsfeed__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9353);
/* harmony import */ var _capacitor_toast__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2472);
/* harmony import */ var _services_location__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3838);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_0__, _newsfeed__WEBPACK_IMPORTED_MODULE_2__, _services_location__WEBPACK_IMPORTED_MODULE_4__]);
([_globals__WEBPACK_IMPORTED_MODULE_0__, _newsfeed__WEBPACK_IMPORTED_MODULE_2__, _services_location__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */







/**
 * Menu de navigation principal
 */
var _MenuNavigation_brand = /*#__PURE__*/new WeakSet();
class MenuNavigation {
  constructor() {
    _classPrivateMethodInitSpec(this, _MenuNavigation_brand);
    this.container = document.getElementById("navContainer");
    _assertClassBrand(_MenuNavigation_brand, this, _listeners).call(this);
  }
  /**
     * Cache le menu principal
     */
  hide() {
    this.container.classList.add("d-none");
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("noHeight");
  }

  /**
     * Affiche le menu principal
     */
  show() {
    this.container.classList.remove("d-none");
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("noHeight");
  }

  /**
     * Ouvre le panneau avec le contenu du composant (tab)
     * @param {*} id
     */
  open(id) {
    let scrollIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : -1;
    let previousBackState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState;
    let windowId = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    // Apparition de la croix (cas général)
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabClose.classList.remove("d-none");
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabHeader.classList.remove("d-none");
    if (["isochrone", "directions"].includes(id)) {
      if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.online) {
        _assertClassBrand(_MenuNavigation_brand, this, _offlineWarning).call(this);
        return;
      }
    }
    // on vide tous les panneaux
    var lstElements = _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.childNodes;
    for (let i = 0; i < lstElements.length; i++) {
      var element = lstElements[i];
      if (element.id && element.id !== "tabHeader" && element.tagName.toUpperCase() === "DIV") {
        element.classList.add("d-none");
      }
    }

    // on met à jour l'état du panneau demandé
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = id;
    if (!windowId) {
      windowId = id;
    }

    // on ajoute le panneau demandé
    element = _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A["$" + windowId + "Window"];
    if (element) {
      element.classList.remove("d-none");
    }
    let target = null;

    // y'a t il des particularités sur l'ouverture du panneau demandé ?
    var isSpecific = false;
    switch (id) {
      case "offlineMaps":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.hardDisable();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.add("downloadOverlay");
        // Si ouvert via "selectionner sur la carte"
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$rech.blur();
        if (document.querySelector(".autocompresultselected")) {
          document.querySelector(".autocompresultselected").classList.remove("autocompresultselected");
        }
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("searching");
        document.body.classList.remove("searching");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$altMenuContainer.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$searchresultsWindow.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.offlineMaps.show();
        break;
      case "selectOnMapCompareLandmark":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "selectOnMapCompareLandmark-" + previousBackState;
        document.querySelector("#mapRLT2").classList.add("d-none");
        document.getElementById("mapRLT1").style.removeProperty("opacity");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareMode.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compare.sideBySide.remove();
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$mapCenter.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$mapCenterMenu.classList.remove("d-none");
        break;
      case "compareLandmark":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "compareLandmark";
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$createCompareLandmarkBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("compare");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        break;
      case "landmark":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "landmark-" + previousBackState;
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.hardDisable();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
        break;
      case "signalement":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "signalement-" + previousBackState;
      // falls through
      case "signalementOSM":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "signalementOSM-" + previousBackState;
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$positionWindow.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.hardDisable();
        break;
      case "comparePoi":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        break;
      case "selectOnMapDirections":
      case "selectOnMapIsochrone":
      case "selectOnMapLandmark":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$mapCenter.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$mapCenterMenu.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$rech.blur();
        if (document.querySelector(".autocompresultselected")) {
          document.querySelector(".autocompresultselected").classList.remove("autocompresultselected");
        }
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        document.body.classList.remove("searching");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("searching");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$altMenuContainer.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$selectOnMap.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
        this.updateScrollAnchors();
        break;
      case "compareLayers1":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "compareLayers1-" + previousBackState;
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareLayers2Window.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareLayers1Window.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideLeftLayer.classList.remove("inactive");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideRightLayer.classList.add("inactive");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideLeftLayer.classList.add("compareLayers");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideFadeSlider.classList.add("compareLayers");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        if (window.matchMedia("screen and (min-aspect-ratio: 1/1) and (min-width:400px)").matches) {
          _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
        }
        break;
      case "compareLayers2":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "compareLayers2-" + previousBackState;
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareLayers1Window.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareLayers2Window.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideRightLayer.classList.remove("inactive");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideLeftLayer.classList.add("inactive");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideLeftLayer.classList.add("compareLayers");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideFadeSlider.classList.add("compareLayers");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        if (window.matchMedia("screen and (min-aspect-ratio: 1/1) and (min-width:400px)").matches) {
          _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
        }
        break;
      case "compare":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$geolocateBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareMode.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideLeftLayer.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideRightLayer.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("compareWidth");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.querySelector(".maplibregl-ctrl-bottom-left").classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.querySelector(".maplibregl-ctrl-bottom-right").classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compare.show();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.hardDisable();
        if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.trackRecord.activeRecord) {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.add("d-none");
        }
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
        break;
      case "routeDrawSave":
      case "directionsSave":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawWindow.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.dom.changeMode.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawEdit.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawSaveBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$directionsSaveBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("routeDraw");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
        break;
      case "routeDraw":
        // Disparition de la croix pour le tracé d'itinéraire (décision UI)
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabClose.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.readonly) {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawEdit.classList.remove("d-none");
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawSaveBtn.classList.remove("d-none");
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("routeDraw");
          _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.activate();
        }
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("white");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.hardDisable();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
        if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.trackRecord.activeRecord) {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.add("d-none");
        }
        break;
      case "poi":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "poi-" + previousBackState;
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.deactivate();
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        break;
      case "layerManager":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "layerManager-" + previousBackState;
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerBtn.classList.add("active");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("white");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.readonly) {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawEdit.classList.add("d-none");
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawSaveBtn.classList.add("d-none");
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("routeDraw");
        }
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
        break;
      case "informations":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
        break;
      case "position":
        if (previousBackState.split("-")[0] !== "position") {
          _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "position-" + previousBackState;
        }
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        break;
      case "isochrone":
        // FIXME mettre en place une méthode sur la classe Search
        // ex. Globals.search.hide()
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "isochrone-" + previousBackState;
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.hardDisable();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
        break;
      case "newsfeed":
        if (!_newsfeed__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.generated) {
          _newsfeed__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.generate();
        }
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("noHeight");
        document.body.classList.add("scrollable");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$altMenuContainer.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
        break;
      case "myaccount":
      case "informationsScreen":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("noHeight");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.add("falseWhite");
        document.body.classList.add("scrollable");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$altMenuContainer.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
        break;
      case "directionsResults":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("white");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$directionsSaveBtn.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("noHeight");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        break;
      case "searchDirections":
      case "searchIsochrone":
      case "searchLandmark":
      case "searchDownload":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$selectOnMap.classList.remove("d-none");
      // falls through
      case "search":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$resultsRechRecent.hidden = false;
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$searchresultsWindow.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("searching");
        document.body.classList.add("searching");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$altMenuContainer.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
        break;
      case "directions":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "directions-" + previousBackState;
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.hardDisable();
        // "Ma position" par défaut dans le départ quand disponible
        target = _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.directions.dom.inputDeparture;
        if (!target.value && _services_location__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.getCurrentPosition()) {
          target.dataset.coordinates = "[" + _services_location__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.getCurrentPosition().coords.longitude + "," + _services_location__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.getCurrentPosition().coords.latitude + "]";
          target.value = "Ma position";
        }
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        if (window.matchMedia("screen and (min-aspect-ratio: 1/1) and (min-width:400px)").matches) {
          _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
        }
        break;
      case "trackRecord":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabHeader.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("white");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabHeader.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("routeDraw");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordInfos.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        break;
      default:
        break;
    }
    if (isSpecific) {
      _assertClassBrand(_MenuNavigation_brand, this, _open).call(this, id);
      return;
    }

    // on cache le menu de navigation
    this.hide();
    if (!_dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.contains("d-none") && !_dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.contains("downloadOverlay")) {
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("noHeight");
    }

    // on procede à l'affichage du panneau
    if (scrollIndex !== -1) {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = scrollIndex;
    }
    this.updateScrollAnchors();
  }

  /**
     * Ferme le panneau du composant (tab)
     * @param {*} id
     */
  close(id) {
    let windowId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    if (!windowId) {
      windowId = id;
    }
    var element = _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A["$" + windowId + "Window"];
    if (element) {
      element.classList.add("d-none");
    }

    // y'a t il des particularités sur la fermeture du panneau en cours ?
    var isSpecific = false;
    var isFinished = false; // hack pour search !
    switch (id) {
      case "offlineMaps":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.remove("downloadOverlay");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.offlineMaps.hide();
        break;
      case "selectOnMapCompareLandmark":
        document.querySelector("#mapRLT2").classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareMode.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compare.mapRLT2.setCenter(_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compare.mapRLT1.getCenter());
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compare.mapRLT2.setZoom(_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compare.mapRLT1.getZoom());
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compare.changeMode();
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$mapCenter.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$mapCenterMenu.classList.add("d-none");
        isSpecific = true;
        isFinished = true;
        break;
      case "compareLandmark":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$createCompareLandmarkBtn.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compareLandmark.clear();
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$mapCenter.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
        isSpecific = true;
        isFinished = true;
        break;
      case "landmark":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.landmark.clear();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        break;
      case "signalement":
      case "signalementOSM":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$positionWindow.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.signalement.clear();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.signalementOSM.clear();
        isSpecific = true;
        isFinished = true;
        break;
      case "comparePoi":
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.comparePoi.clearSources();
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        break;
      case "selectOnMapDirections":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
      // falls through
      case "selectOnMapIsochrone":
      case "selectOnMapLandmark":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$mapCenter.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$mapCenterMenu.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
        isSpecific = true;
        isFinished = true;
        break;
      case "compareLayers1":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideLeftLayer.classList.remove("compareLayers");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideFadeSlider.classList.remove("compareLayers");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareLayers1Window.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideRightLayer.classList.remove("inactive");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
        isSpecific = true;
        isFinished = true;
        break;
      case "compareLayers2":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideLeftLayer.classList.remove("compareLayers");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideFadeSlider.classList.remove("compareLayers");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareLayers2Window.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideLeftLayer.classList.remove("inactive");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
        isSpecific = true;
        isFinished = true;
        break;
      case "compare":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$geolocateBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$compareMode.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideLeftLayer.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$sideBySideRightLayer.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$createCompareLandmarkBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("compare");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("compareWidth");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.querySelector(".maplibregl-ctrl-bottom-left").classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.querySelector(".maplibregl-ctrl-bottom-right").classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compare.hide();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.threeD.terrainOn || _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.threeD.buildingsOn) {
          _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.map.setPitch(45);
        }
        if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.trackRecord.activeRecord) {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.remove("d-none");
        }
        break;
      case "directionsSave":
        // Réouverture de directionsResult sans utilisr this.open("directionsResults")
        // Disparition de la croix
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A["$directionsResultsWindow"].classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.add("white");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$directionsSaveBtn.classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("noHeight");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
        isSpecific = true;
        isFinished = true;
        break;
      case "routeDrawSave":
        // Réouverture de routeDraw sans utilisr this.open("routeDraw")
        // Disparition de la croix
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabClose.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A["$routeDrawWindow"].classList.remove("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.dom.changeMode.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawEdit.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawSaveBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.add("routeDraw");
        isSpecific = true;
        isFinished = true;
        break;
      case "routeDraw":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.readonly) {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawEdit.classList.add("d-none");
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$routeDrawSaveBtn.classList.add("d-none");
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("routeDraw");
        }
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("white");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.clear();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.trackRecord.activeRecord) {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.remove("d-none");
        }
        break;
      case "poi":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        break;
      case "layerManager":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerBtn.classList.remove("active");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        break;
      case "informations":
        isSpecific = true;
        isFinished = true;
        break;
      case "position":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.mapInteractivity.clear();
        break;
      case "isochrone":
        // FIXME mettre en place une méthode sur la classe Searchs
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.isochrone.clear();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.isochrone.clearForm();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        break;
      case "search":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$rech.blur();
        if (document.querySelector(".autocompresultselected")) {
          document.querySelector(".autocompresultselected").classList.remove("autocompresultselected");
        }
        document.body.classList.remove("searching");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("searching");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$altMenuContainer.classList.add("d-none");
        isSpecific = true;
        isFinished = false;
        break;
      case "searchDirections":
      case "searchIsochrone":
      case "searchLandmark":
      case "searchDownload":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$rech.blur();
        if (document.querySelector(".autocompresultselected")) {
          document.querySelector(".autocompresultselected").classList.remove("autocompresultselected");
        }
        document.body.classList.remove("searching");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("searching");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$altMenuContainer.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$selectOnMap.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("noHeight");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
      // falls through
      case "directionsResults":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("white");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$directionsSaveBtn.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.hardDisable();
        isSpecific = true;
        isFinished = true;
        break;
      case "myaccount":
      case "informationsScreen":
      case "newsfeed":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.remove("falseWhite");
        document.body.classList.remove("scrollable");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$whiteScreen.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$altMenuContainer.classList.add("d-none");
        break;
      case "directions":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.directions.clear();
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.interactivityIndicator.enable();
        break;
      case "trackRecord":
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabHeader.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("white");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("higher");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$fullScreenBtn.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
        _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.trackRecord.dom.trackRecordContainer.classList.remove("d-none");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$bottomButtons.classList.remove("routeDraw");
        _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordInfos.classList.add("d-none");
        if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.trackRecord.recording || _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.trackRecord.activeRecord) {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.remove("d-none");
          if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.trackRecord.recording) {
            _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.remove("pause");
            _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.add("recording");
          } else {
            _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.remove("recording");
            _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.add("pause");
          }
        } else {
          _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$trackRecordBtn.classList.add("d-none");
        }
        break;
      default:
        break;
    }

    // on est sur une fermeture specifique,
    // on passe donc par un autre mecanisme
    if (isSpecific) {
      _assertClassBrand(_MenuNavigation_brand, this, _close).call(this, id);
      if (isFinished) {
        this.updateScrollAnchors();
        return;
      }
    }
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
    this.updateScrollAnchors();

    // on affiche le menu de navigation
    this.show();

    // on met à jour l'état du panneau : vers le menu de navigation
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "default";
    _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.classList.remove("noHeight");
  }

  /**
     * Ouverture spécifique d'un panneau
     * @param {*} id
     */

  /** ... */
  updateScrollAnchors() {
    if (_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState !== "compare") {
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.style.removeProperty("display");
    }
    if (window.matchMedia("screen and (min-aspect-ratio: 1/1) and (min-width:400px)").matches && _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex !== 0) {
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$tabContainer.style.display = "flex";
    }
    const insetTop = parseFloat(getComputedStyle(document.documentElement).getPropertyValue("--safe-area-inset-top").slice(0, -2));
    const insetBottom = parseFloat(getComputedStyle(document.documentElement).getPropertyValue("--safe-area-inset-bottom").slice(0, -2));
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.maxScroll = Math.min(document.scrollingElement.clientHeight - 149 - insetTop - Math.max(insetBottom, 20), document.scrollingElement.scrollHeight - document.scrollingElement.clientHeight);
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.anchors = [0, _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.maxScroll / 2.5, _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.maxScroll];
    if (window.matchMedia("screen and (min-aspect-ratio: 1/1) and (min-width:400px)").matches) {
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.anchors = [0, document.scrollingElement.clientHeight - 72 - Math.max(insetBottom, 20), _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.maxScroll];
    }
    _assertClassBrand(_MenuNavigation_brand, this, _scrollTo).call(this, _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.anchors[_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex]);
  }

  /** ... */
}
function _offlineWarning() {
  _capacitor_toast__WEBPACK_IMPORTED_MODULE_3__/* .Toast */ .y.show({
    text: "Fonctionnalité indisponible en mode hors ligne.",
    duration: "long",
    position: "bottom"
  });
}
/**
   * Les écouteurs :
   * - event clic sur le menu de navigation
   * - event clic sur un element du DOM ayant une interaction avec le menu de navigation
   */
function _listeners() {
  // Menu global
  document.querySelectorAll(".navbar").forEach(navbar => {
    navbar.shouldOpen = true;
    navbar.addEventListener("click", () => {
      document.querySelectorAll(".navbar").forEach(navbarOther => {
        if (navbarOther != navbar) {
          navbarOther.shouldOpen = true;
        }
      });
      if (navbar.shouldOpen) {
        navbar.classList.add("hoverable");
        navbar.shouldOpen = false;
      } else {
        navbar.classList.remove("hoverable");
        navbar.shouldOpen = true;
      }
    });
  });
  // "Où suis-je ?"
  document.getElementById("position").addEventListener("click", () => {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.position.compute({
      type: "myposition"
    }).then(() => {
      this.open("position");
    });
  });
  // "A proximité"
  document.getElementById("isochrone").addEventListener("click", () => {
    this.open("isochrone");
  });
  // "Créer un point de repère"
  document.getElementById("landmark").addEventListener("click", () => {
    this.open("landmark");
  });
  // "Fil d'actualités"
  // "Créer un point de repère"
  document.getElementById("newsfeed").addEventListener("click", () => {
    this.open("newsfeed");
  });
  // "S'y rendre"
  document.getElementById("directions").addEventListener("click", () => {
    this.open("directions");
  });
  // "Tracer un itinéraire"
  document.getElementById("routeDraw").addEventListener("click", () => {
    if (!_globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.online) {
      _assertClassBrand(_MenuNavigation_brand, this, _offlineWarning).call(this);
      return;
    }
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.routeDraw.show();
  });
  // "Enregistrer ma trace"
  document.getElementById("trackRecord").addEventListener("click", () => {
    this.open("trackRecord");
  });
  // "Compte"
  document.getElementById("myaccount").addEventListener("click", () => {
    this.open("myaccount");
  });
}
function _open() {}
/**
   * Fermeture spécifique d'un panneau
   * @param {*} id
   */
function _close(id) {
  if (["compareLayers1", "compareLayers2", "compareLandmark", "selectOnMapCompareLandmark"].includes(id)) {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "compare"; // on revient sur le contrôle !
    return;
  }
  if (id === "routeDrawSave") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "routeDraw"; // on revient sur le contrôle !
    return;
  }
  if (id === "directionsSave") {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "directionsResults"; // on revient sur le contrôle !
    return;
  }
  if (["signalement", "signalementOSM"].includes(id)) {
    _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "position"; // on revient sur le contrôle !
    return;
  }
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.searchAbortController.abort();
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.searchAbortController = new AbortController();
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.searchAbortSignal = _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.searchAbortController.signal;
  _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$resultDiv.hidden = true;
  _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$resultDiv.innerHTML = "";
  _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$searchresultsWindow.classList.add("d-none");
  _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerBtn.classList.remove("d-none");
  _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.remove("d-none");
  _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$geolocateBtn.classList.remove("d-none");
  switch (id) {
    case "informations":
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$layerManagerWindow.classList.remove("d-none");
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "layerManager"; // on revient sur le contrôle !
      _assertClassBrand(_MenuNavigation_brand, this, _midScroll).call(this);
      break;
    case "search":
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.remove("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.add("d-none");
      break;
    case "directionsResults":
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$directionsWindow.classList.remove("d-none");
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "directions"; // on revient sur le contrôle !
      _assertClassBrand(_MenuNavigation_brand, this, _midScroll).call(this);
      break;
    case "searchLandmark":
    case "selectOnMapLandmark":
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$landmarkWindow.classList.remove("d-none");
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "landmark"; // on revient sur le contrôle !
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
      this.updateScrollAnchors();
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$rech.value = "";
      break;
    case "searchIsochrone":
    case "selectOnMapIsochrone":
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$filterPoiBtn.classList.add("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$isochroneWindow.classList.remove("d-none");
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "isochrone"; // on revient sur le contrôle !
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
      this.updateScrollAnchors();
      break;
    case "searchDirections":
    case "selectOnMapDirections":
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$directionsWindow.classList.remove("d-none");
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "directions"; // on revient sur le contrôle !
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 2;
      this.updateScrollAnchors();
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$rech.value = "";
      break;
    case "searchDownload":
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$search.classList.add("d-none");
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$backTopLeftBtn.classList.remove("d-none");
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.backButtonState = "myaccount"; // on revient sur le contrôle !
      _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 0;
      this.updateScrollAnchors();
      _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$rech.value = "";
      break;
    default:
      break;
  }
}
function _midScroll() {
  _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex = 1;
  this.updateScrollAnchors();
}
/** ... */
function _scrollTo(value) {
  if (window.matchMedia("screen and (min-aspect-ratio: 1/1) and (min-width:400px)").matches && _globals__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.currentScrollIndex === 0) {
    return;
  }
  window.scroll({
    top: value,
    left: 0,
    behavior: "smooth"
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MenuNavigation);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1071:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _route_draw_save_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4702);
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2116);
/* harmony import */ var _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2472);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_1__]);
var __webpack_async_dependencies_result__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
_globals__WEBPACK_IMPORTED_MODULE_1__ = __webpack_async_dependencies_result__[0];
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */





/**
 * Interface d'enregistrement d'itinéraire tracé
 * @module RouteDrawSave
 */
var _RouteDrawSave_brand = /*#__PURE__*/new WeakSet();
class RouteDrawSave {
  /**
     * constructeur
     * @constructs
     * @param {*} map
     * @param {*} options
     */
  constructor(target, options) {
    /**
     * ajout d'ecouteurs pour la saisie interactive
     */
    _classPrivateMethodInitSpec(this, _RouteDrawSave_brand);
    this.options = options || {
      data: {},
      transport: null,
      name: null,
      id: null
    };

    // target
    this.target = target;
    this.id = this.options.id || -1;
    this.showedFrom = null;

    // rendu graphique
    this.render();
    this.bindedOnRouteSave = _assertClassBrand(_RouteDrawSave_brand, this, _onRouteSave).bind(this);
    return this;
  }
  /**
   * sauvegarde l'itinéraire dans le compte
   */
  saveToAccount() {
    let name = document.getElementById("routeDrawSaveNameInput").value;
    if (name === "") {
      name = `De ${this.options.data.points[0].properties.name} à ${this.options.data.points.slice(-1)[0].properties.name}`;
    }
    this.options.name = name;
    this.options.visible = true;
    _globals__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.myaccount.addRoute(JSON.parse(JSON.stringify(this.options)));
  }

  /**
     * creation de l'interface
     * @public
     */
  render() {
    var target = this.target || document.getElementById("routeDrawSaveWindow");
    if (!target) {
      console.warn();
      return;
    }
    var container = this.getContainer(this.options.data, this.options.transport, this.options.name);
    if (!container) {
      console.warn();
      return;
    }

    // ajout du container
    target.appendChild(container);
  }

  /**
     * affiche le menu des résultats du calcul
     * @public
     */
  show() {
    let showedFrom = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "routeDraw";
    this.showedFrom = showedFrom;
    _globals__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.menu.open(`${showedFrom}Save`, -1, _globals__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.backButtonState, "routeDrawSave");
    _assertClassBrand(_RouteDrawSave_brand, this, _listeners).call(this);
  }

  /**
     * ferme le menu des résultats du calcul
     * @public
     */
  hide() {
    _globals__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.menu.close(`${this.showedFrom}Save`);
    _assertClassBrand(_RouteDrawSave_brand, this, _removeListeners).call(this);
  }
}

// mixins
function _listeners() {
  document.getElementById("routeDrawSaveNameInputSubmit").addEventListener("click", this.bindedOnRouteSave);
}
function _removeListeners() {
  document.getElementById("routeDrawSaveNameInputSubmit").removeEventListener("click", this.bindedOnRouteSave);
}
/**
 * gestion du clic sur le bouton d'enregistrement
 */
function _onRouteSave() {
  this.saveToAccount();
  this.hide();
  if (this.showedFrom === "routeDraw") {
    _globals__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.routeDraw.hide();
  } else if (this.showedFrom === "directions") {
    _globals__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.directions.results.hide();
    _globals__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.menu.close("directions");
  }
  _capacitor_toast__WEBPACK_IMPORTED_MODULE_2__/* .Toast */ .y.show({
    text: "Itinéraire enregistré dans 'Enregistrés'",
    duration: "long",
    position: "top"
  });
}
Object.assign(RouteDrawSave.prototype, _route_draw_save_dom__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RouteDrawSave);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1083:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   p: () => (/* binding */ Device)
/* harmony export */ });
/* harmony import */ var _capacitor_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5036);

const Device = (0,_capacitor_core__WEBPACK_IMPORTED_MODULE_0__/* .registerPlugin */ .F3)('Device', {
  web: () => __webpack_require__.e(/* import() */ 65).then(__webpack_require__.bind(__webpack_require__, 4065)).then(m => new m.DeviceWeb())
});



/***/ }),

/***/ 1194:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */

/**
 * Action sheet custom pour suivre les besoins de  la maquette
 * @module ActionSheet
 */
class ActionSheet extends EventTarget {
  constructor() {
    super();
    _defineProperty(this, "_target", document.getElementsByTagName("action-sheet")[0]);
    _defineProperty(this, "_targetWrapper", document.getElementById("sheetContent"));
    _defineProperty(this, "_targetContent", document.getElementById("sheetOptions"));
    _defineProperty(this, "_closeElem", document.getElementById("sheetClose"));
    _defineProperty(this, "_shown", false);
    return this;
  }

  /**
   * Ajout des écouteurs d'évènement
   */
  _listeners() {
    this._closeElem.addEventListener("click", () => {
      /**
       * Evenement "closeSheet"
       * @event closeSheet
       * @type {*}
       */
      this.dispatchEvent(new CustomEvent("closeSheet", {
        bubbles: true
      }));
    });
  }
  _createHtml() {
    if (this._title !== "") {
      const actionTitle = document.createElement("p");
      actionTitle.classList.add("actionSheet-title");
      actionTitle.innerText = this._title;
      this._targetContent.appendChild(actionTitle);
    }
    if (this._options.length > 0 || this._style === "custom") {
      let optionsHtml;
      if (this._style === "list") {
        optionsHtml = this._createListHtml(this._options);
      } else if (this._style === "custom") {
        optionsHtml = this._content;
      } else {
        optionsHtml = this._createButtonsHtml(this._options);
      }
      this._targetContent.appendChild(optionsHtml);
    }
  }
  _clearHtml() {
    this._targetContent.innerHTML = "";
    this._content = "";
  }
  _createListHtml(options) {
    return this._createGenericOptionsHtml(options, "actionSheet-list", "actionSheet-list-option");
  }
  _createButtonsHtml(options) {
    return this._createGenericOptionsHtml(options, "actionSheet-buttons", "actionSheet-buttons-button");
  }
  _createGenericOptionsHtml(options, wrapperClass, elementClass) {
    const div = document.createElement("div");
    div.classList.add(wrapperClass);
    if (this._wrapperCustomClass) {
      div.classList.add(this._wrapperCustomClass);
    }
    for (let i = 0; i < options.length; i++) {
      const option = options[i];
      const elem = document.createElement("div");
      if (option.class) {
        option.class.split(" ").forEach(cssClass => {
          elem.classList.add(cssClass);
        });
      }
      elem.classList.add(elementClass);
      elem.innerText = option.text;
      let hasBeenClicked = false;
      elem.addEventListener("click", e => {
        if (elem.classList.contains("confirm-needed")) {
          if (!hasBeenClicked) {
            hasBeenClicked = true;
            if (option.confirmCallback) {
              option.confirmCallback();
            }
            return;
          }
        }
        if (wrapperClass === "actionSheet-buttons") {
          e.target.style.color = "white";
          e.target.style.backgroundColor = "var(--dark-green)";
        }
        if (wrapperClass === "actionSheet-list") {
          e.target.style.backgroundColor = "var(--light-grey)";
          setTimeout(() => {
            e.target.style.removeProperty("background-color");
          }, 400);
        }
        setTimeout(() => {
          /**
           * Evenement "optionSelect"
           * @event optionSelect
           * @type {*}
           * @property {*} value -
           */
          this.dispatchEvent(new CustomEvent("optionSelect", {
            bubbles: true,
            detail: {
              value: option.value
            }
          }));
        }, this._timeToHide);
      });
      div.appendChild(elem);
    }
    return div;
  }
  async show(settings) {
    // Si on demande l'ouverture de l'ActionSheet alors qu'elle est ouverte, on attend qu'elle se ferme.
    if (this._shown) {
      await new Promise(resolve => {
        this.addEventListener("hideSheet", () => {
          resolve(null);
        });
      });
    }
    this._shown = true;
    this.settings = settings || {
      style: "list",
      // can be "buttons", "list", "custom"
      wrapperCustomClass: "",
      // custom container class 
      options: [],
      // {class: "", text: "", value: "", confirmCallback: null}
      title: "",
      content: "",
      // dom element if "custom" style
      timeToHide: 600,
      // ms, time after option select to hide
      passive: false // if true, the sheet is not closed by selecting an option
    };
    this._title = this.settings.title || "";
    this._wrapperCustomClass = this.settings.wrapperCustomClass || "";
    this._options = this.settings.options || [];
    this._style = this.settings.style || "list";
    this._content = this.settings.content || "";
    this._timeToHide = this.settings.timeToHide || 600;
    if (this.settings.passive) {
      this._timeToHide = 0;
    }
    this._listeners();
    this._createHtml();
    this._target.classList.remove("d-none");
    setTimeout(() => {
      this._targetWrapper.style.transform = "unset";
    }, 10);
    const result = await new Promise(resolve => {
      this.addEventListener("optionSelect", e => {
        if (!this.settings.passive) {
          resolve(e.detail.value);
        }
      });
      this.addEventListener("closeSheet", () => {
        resolve(null);
      });
    });
    this.hide();
    return result;
  }
  hide() {
    this._targetWrapper.style.removeProperty("transform");
    setTimeout(() => {
      this._target.classList.add("d-none");
      this._clearHtml();
      this._shown = false;
      /**
       * Evenement "hideSheet"
       * @event hideSheet
       * @type {*}
       * @property {*} value -
       */
      this.dispatchEvent(new CustomEvent("hideSheet", {
        bubbles: true
      }));
    }, 500);
  }
}

// singleton
const actionSheet = new ActionSheet();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (actionSheet);

/***/ }),

/***/ 1272:
/***/ ((module) => {

"use strict";
module.exports = /*#__PURE__*/JSON.parse('[{"name":"Tous","settings":{"default":true,"generic":true},"layers":[]},{"name":"Administratif","layers":["LIMITES_ADMINISTRATIVES_EXPRESS.LATEST$WMTS"]},{"name":"Foncier","layers":["CADASTRALPARCELS.PARCELLAIRE_EXPRESS$WMTS"]},{"name":"Agriculture","layers":["LANDUSE.AGRICULTURE.LATEST$WMTS","Aire-Parcellaire$WMTS"]},{"name":"Forêt","layers":["FORETS.PUBLIQUES$WMTS","LANDCOVER.FORESTINVENTORY.V2$WMTS"]},{"name":"Hydrographie, mer et littoral","layers":["ELEVATION.LEVEL0$WMTS","HYDROGRAPHY.HYDROGRAPHY$WMTS"]},{"name":"Espaces protégés","layers":["Patrinat_SIC$WMTS","Patrinat_ZPS$WMTS"]},{"name":"Risques naturels","layers":["GEOGRAPHICALGRIDSYSTEMS.SLOPES.MOUNTAIN$WMTS"]},{"name":"Tourisme et loisirs","layers":["IGNF_SITES-UNESCO$WMS","POI.MONUMENTS_BDD_WLD_WM$WMS","CJP-PARCS-JARDINS_BDD-POI_WLD_WM$WMS","POI.MUSEUM$WMS","VILLAGESETAPE$WMS","TRANSPORTS.DRONES.RESTRICTIONS$WMTS"]},{"name":"Transports","layers":["TRANSPORTNETWORKS.RAILWAYS$WMTS","TRANSPORTNETWORKS.ROADS$WMTS"]}]');

/***/ }),

/***/ 1361:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var maplibre_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2461);
/* harmony import */ var maplibre_gl__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(maplibre_gl__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5608);
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2116);
/* harmony import */ var _search_recent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9684);
/* harmony import */ var _location__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3838);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_globals__WEBPACK_IMPORTED_MODULE_2__, _location__WEBPACK_IMPORTED_MODULE_4__]);
([_globals__WEBPACK_IMPORTED_MODULE_2__, _location__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */







/**
 * Interface pour les evenements
 * @example
 * target.dispatchEvent(new CustomEvent("myEvent", { detail : {} }));
 * target.addEventListener("myEvent", handler);
 */
const target = new EventTarget();

/**
 * supprime le marker de la recherche
 */
function clean() {
  if (_globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.searchResultMarker != null) {
    _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.searchResultMarker.remove();
    _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.searchResultMarker = null;
  }
}

/**
 * deplacement sur la carte
 * @param {*} coords
 * @param {*} zoom
 * @param {*} panTo
 */
function moveTo(coords) {
  let zoom = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.map.getZoom();
  let panTo = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  /**
   * Ajoute un marqueur de type adresse à la position définie par le coods, et déplace la carte au zoom demandé
   * si panTo est True
   */
  clean();
  _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.searchResultMarker = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_0___default().Marker)({
    element: _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.searchResultIcon,
    anchor: "bottom"
  }).setLngLat([coords.lon, coords.lat]).addTo(_globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.map);
  _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.searchResultIcon.addEventListener("click", clean);
  if (panTo) {
    if (_location__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.isTrackingActive()) {
      _location__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.disableTracking();
    }
    const moveAgain = () => {
      setTimeout(() => {
        _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.map.flyTo({
          center: [coords.lon, coords.lat],
          zoom: zoom
        });
      }, 100);
    };
    _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.map.flyTo({
      center: [coords.lon, coords.lat],
      zoom: zoom
    });
    // Gestion de la disparaition du clavier
    _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.map.once("resize", moveAgain);
    setTimeout(() => {
      _globals__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.map.off("resize", moveAgain);
    }, 1000);
  }
}

/**
 * recherche
 * @param {*} text
 * @param {*} coords
 * @returns
 * @fire search
 */
async function search(text, coords) {
  let save = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  /**
   * Recherche un texte et le géocode à l'aide de look4,
   * puis va à sa position en ajoutant un marqueur
   */
  if (text === "") {
    return;
  }
  if (save) {
    _search_recent__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.add({
      text: text,
      coordinates: {
        lat: coords.lat,
        lon: coords.lon
      }
    });
  }
  _dom__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.$rech.value = text;
  const geocode_result = {
    fulltext: text,
    y: coords.lat,
    x: coords.lon
  };

  // INFO: setTimeout pour comportement normal de directions (laisser le temps de faire le clean listeners)
  setTimeout(() => {
    target.dispatchEvent(new CustomEvent("search", {
      bubbles: true,
      detail: {
        text: geocode_result.fulltext,
        coordinates: {
          lat: geocode_result.y,
          lon: geocode_result.x
        }
      }
    }));
  }, 100);
  return {
    lat: geocode_result.y,
    lon: geocode_result.x
  };
}

/**
 * recherche et deplacement sur la carte
 * @param {*} text
 */
async function searchAndMoveTo(text) {
  let coord = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  let save = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  var coords = await search(text, coord, save);
  moveTo(coords, 14);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  target,
  moveTo,
  search,
  searchAndMoveTo
});
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1367:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ dist_esm_index_default)
});

// UNUSED EXPORTS: buffer

// EXTERNAL MODULE: ./node_modules/@turf/meta/dist/esm/index.js
var esm = __webpack_require__(3096);
;// ./node_modules/@turf/bbox/dist/esm/index.js
// index.ts

function bbox(geojson) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  if (geojson.bbox != null && true !== options.recompute) {
    return geojson.bbox;
  }
  const result = [Infinity, Infinity, -Infinity, -Infinity];
  (0,esm/* coordEach */.Fh)(geojson, coord => {
    if (result[0] > coord[0]) {
      result[0] = coord[0];
    }
    if (result[1] > coord[1]) {
      result[1] = coord[1];
    }
    if (result[2] < coord[0]) {
      result[2] = coord[0];
    }
    if (result[3] < coord[1]) {
      result[3] = coord[1];
    }
  });
  return result;
}
var index_default = (/* unused pure expression or super */ null && (bbox));

// EXTERNAL MODULE: ./node_modules/@turf/helpers/dist/esm/index.js
var dist_esm = __webpack_require__(2104);
;// ./node_modules/@turf/center/dist/esm/index.js
// index.ts


function center(geojson) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const ext = bbox(geojson);
  const x = (ext[0] + ext[2]) / 2;
  const y = (ext[1] + ext[3]) / 2;
  return (0,dist_esm/* point */.zx)([x, y], options.properties, options);
}
var esm_index_default = (/* unused pure expression or super */ null && (center));

// EXTERNAL MODULE: ./node_modules/@turf/jsts/dist/jsts.min.js
var jsts_min = __webpack_require__(6348);
;// ./node_modules/d3-geo/src/adder.js
// Adds floating point numbers with twice the normal precision.
// Reference: J. R. Shewchuk, Adaptive Precision Floating-Point Arithmetic and
// Fast Robust Geometric Predicates, Discrete & Computational Geometry 18(3)
// 305–363 (1997).
// Code adapted from GeographicLib by Charles F. F. Karney,
// http://geographiclib.sourceforge.net/

/* harmony default export */ function adder() {
  return new Adder();
}
function Adder() {
  this.reset();
}
Adder.prototype = {
  constructor: Adder,
  reset: function () {
    this.s =
    // rounded value
    this.t = 0; // exact error
  },
  add: function (y) {
    add(temp, y, this.t);
    add(this, temp.s, this.s);
    if (this.s) this.t += temp.t;else this.s = temp.t;
  },
  valueOf: function () {
    return this.s;
  }
};
var temp = new Adder();
function add(adder, a, b) {
  var x = adder.s = a + b,
    bv = x - a,
    av = x - bv;
  adder.t = a - av + (b - bv);
}
;// ./node_modules/d3-geo/src/math.js
var math_epsilon = 1e-6;
var math_epsilon2 = 1e-12;
var math_pi = Math.PI;
var math_halfPi = math_pi / 2;
var quarterPi = math_pi / 4;
var math_tau = math_pi * 2;
var math_degrees = 180 / math_pi;
var math_radians = math_pi / 180;
var math_abs = Math.abs;
var math_atan = Math.atan;
var math_atan2 = Math.atan2;
var math_cos = Math.cos;
var math_ceil = Math.ceil;
var exp = Math.exp;
var floor = Math.floor;
var math_log = Math.log;
var math_pow = Math.pow;
var math_sin = Math.sin;
var math_sign = Math.sign || function (x) {
  return x > 0 ? 1 : x < 0 ? -1 : 0;
};
var math_sqrt = Math.sqrt;
var math_tan = Math.tan;
function acos(x) {
  return x > 1 ? 0 : x < -1 ? math_pi : Math.acos(x);
}
function math_asin(x) {
  return x > 1 ? math_halfPi : x < -1 ? -math_halfPi : Math.asin(x);
}
function math_haversin(x) {
  return (x = math_sin(x / 2)) * x;
}
;// ./node_modules/d3-geo/src/noop.js
function noop() {}
;// ./node_modules/d3-geo/src/stream.js
function streamGeometry(geometry, stream) {
  if (geometry && streamGeometryType.hasOwnProperty(geometry.type)) {
    streamGeometryType[geometry.type](geometry, stream);
  }
}
var streamObjectType = {
  Feature: function (object, stream) {
    streamGeometry(object.geometry, stream);
  },
  FeatureCollection: function (object, stream) {
    var features = object.features,
      i = -1,
      n = features.length;
    while (++i < n) streamGeometry(features[i].geometry, stream);
  }
};
var streamGeometryType = {
  Sphere: function (object, stream) {
    stream.sphere();
  },
  Point: function (object, stream) {
    object = object.coordinates;
    stream.point(object[0], object[1], object[2]);
  },
  MultiPoint: function (object, stream) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) object = coordinates[i], stream.point(object[0], object[1], object[2]);
  },
  LineString: function (object, stream) {
    streamLine(object.coordinates, stream, 0);
  },
  MultiLineString: function (object, stream) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) streamLine(coordinates[i], stream, 0);
  },
  Polygon: function (object, stream) {
    streamPolygon(object.coordinates, stream);
  },
  MultiPolygon: function (object, stream) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) streamPolygon(coordinates[i], stream);
  },
  GeometryCollection: function (object, stream) {
    var geometries = object.geometries,
      i = -1,
      n = geometries.length;
    while (++i < n) streamGeometry(geometries[i], stream);
  }
};
function streamLine(coordinates, stream, closed) {
  var i = -1,
    n = coordinates.length - closed,
    coordinate;
  stream.lineStart();
  while (++i < n) coordinate = coordinates[i], stream.point(coordinate[0], coordinate[1], coordinate[2]);
  stream.lineEnd();
}
function streamPolygon(coordinates, stream) {
  var i = -1,
    n = coordinates.length;
  stream.polygonStart();
  while (++i < n) streamLine(coordinates[i], stream, 1);
  stream.polygonEnd();
}
/* harmony default export */ function src_stream(object, stream) {
  if (object && streamObjectType.hasOwnProperty(object.type)) {
    streamObjectType[object.type](object, stream);
  } else {
    streamGeometry(object, stream);
  }
}
;// ./node_modules/d3-geo/src/area.js




var areaRingSum = adder();
var areaSum = adder(),
  lambda00,
  phi00,
  lambda0,
  cosPhi0,
  sinPhi0;
var areaStream = {
  point: noop,
  lineStart: noop,
  lineEnd: noop,
  polygonStart: function () {
    areaRingSum.reset();
    areaStream.lineStart = areaRingStart;
    areaStream.lineEnd = areaRingEnd;
  },
  polygonEnd: function () {
    var areaRing = +areaRingSum;
    areaSum.add(areaRing < 0 ? math_tau + areaRing : areaRing);
    this.lineStart = this.lineEnd = this.point = noop;
  },
  sphere: function () {
    areaSum.add(math_tau);
  }
};
function areaRingStart() {
  areaStream.point = areaPointFirst;
}
function areaRingEnd() {
  areaPoint(lambda00, phi00);
}
function areaPointFirst(lambda, phi) {
  areaStream.point = areaPoint;
  lambda00 = lambda, phi00 = phi;
  lambda *= math_radians, phi *= math_radians;
  lambda0 = lambda, cosPhi0 = math_cos(phi = phi / 2 + quarterPi), sinPhi0 = math_sin(phi);
}
function areaPoint(lambda, phi) {
  lambda *= math_radians, phi *= math_radians;
  phi = phi / 2 + quarterPi; // half the angular distance from south pole

  // Spherical excess E for a spherical triangle with vertices: south pole,
  // previous point, current point.  Uses a formula derived from Cagnoli’s
  // theorem.  See Todhunter, Spherical Trig. (1871), Sec. 103, Eq. (2).
  var dLambda = lambda - lambda0,
    sdLambda = dLambda >= 0 ? 1 : -1,
    adLambda = sdLambda * dLambda,
    cosPhi = math_cos(phi),
    sinPhi = math_sin(phi),
    k = sinPhi0 * sinPhi,
    u = cosPhi0 * cosPhi + k * math_cos(adLambda),
    v = k * sdLambda * math_sin(adLambda);
  areaRingSum.add(math_atan2(v, u));

  // Advance the previous points.
  lambda0 = lambda, cosPhi0 = cosPhi, sinPhi0 = sinPhi;
}
/* harmony default export */ function src_area(object) {
  areaSum.reset();
  stream(object, areaStream);
  return areaSum * 2;
}
;// ./node_modules/d3-geo/src/cartesian.js

function spherical(cartesian) {
  return [math_atan2(cartesian[1], cartesian[0]), math_asin(cartesian[2])];
}
function cartesian(spherical) {
  var lambda = spherical[0],
    phi = spherical[1],
    cosPhi = math_cos(phi);
  return [cosPhi * math_cos(lambda), cosPhi * math_sin(lambda), math_sin(phi)];
}
function cartesianDot(a, b) {
  return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
}
function cartesianCross(a, b) {
  return [a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]];
}

// TODO return a
function cartesianAddInPlace(a, b) {
  a[0] += b[0], a[1] += b[1], a[2] += b[2];
}
function cartesianScale(vector, k) {
  return [vector[0] * k, vector[1] * k, vector[2] * k];
}

// TODO return d
function cartesianNormalizeInPlace(d) {
  var l = math_sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
  d[0] /= l, d[1] /= l, d[2] /= l;
}
;// ./node_modules/d3-geo/src/bounds.js





var bounds_lambda0,
  phi0,
  lambda1,
  phi1,
  // bounds
  lambda2,
  // previous lambda-coordinate
  bounds_lambda00,
  bounds_phi00,
  // first point
  p0,
  // previous 3D point
  deltaSum = adder(),
  ranges,
  bounds_range;
var boundsStream = {
  point: boundsPoint,
  lineStart: boundsLineStart,
  lineEnd: boundsLineEnd,
  polygonStart: function () {
    boundsStream.point = boundsRingPoint;
    boundsStream.lineStart = boundsRingStart;
    boundsStream.lineEnd = boundsRingEnd;
    deltaSum.reset();
    areaStream.polygonStart();
  },
  polygonEnd: function () {
    areaStream.polygonEnd();
    boundsStream.point = boundsPoint;
    boundsStream.lineStart = boundsLineStart;
    boundsStream.lineEnd = boundsLineEnd;
    if (areaRingSum < 0) bounds_lambda0 = -(lambda1 = 180), phi0 = -(phi1 = 90);else if (deltaSum > math_epsilon) phi1 = 90;else if (deltaSum < -math_epsilon) phi0 = -90;
    bounds_range[0] = bounds_lambda0, bounds_range[1] = lambda1;
  }
};
function boundsPoint(lambda, phi) {
  ranges.push(bounds_range = [bounds_lambda0 = lambda, lambda1 = lambda]);
  if (phi < phi0) phi0 = phi;
  if (phi > phi1) phi1 = phi;
}
function linePoint(lambda, phi) {
  var p = cartesian([lambda * math_radians, phi * math_radians]);
  if (p0) {
    var normal = cartesianCross(p0, p),
      equatorial = [normal[1], -normal[0], 0],
      inflection = cartesianCross(equatorial, normal);
    cartesianNormalizeInPlace(inflection);
    inflection = spherical(inflection);
    var delta = lambda - lambda2,
      sign = delta > 0 ? 1 : -1,
      lambdai = inflection[0] * math_degrees * sign,
      phii,
      antimeridian = math_abs(delta) > 180;
    if (antimeridian ^ (sign * lambda2 < lambdai && lambdai < sign * lambda)) {
      phii = inflection[1] * math_degrees;
      if (phii > phi1) phi1 = phii;
    } else if (lambdai = (lambdai + 360) % 360 - 180, antimeridian ^ (sign * lambda2 < lambdai && lambdai < sign * lambda)) {
      phii = -inflection[1] * math_degrees;
      if (phii < phi0) phi0 = phii;
    } else {
      if (phi < phi0) phi0 = phi;
      if (phi > phi1) phi1 = phi;
    }
    if (antimeridian) {
      if (lambda < lambda2) {
        if (angle(bounds_lambda0, lambda) > angle(bounds_lambda0, lambda1)) lambda1 = lambda;
      } else {
        if (angle(lambda, lambda1) > angle(bounds_lambda0, lambda1)) bounds_lambda0 = lambda;
      }
    } else {
      if (lambda1 >= bounds_lambda0) {
        if (lambda < bounds_lambda0) bounds_lambda0 = lambda;
        if (lambda > lambda1) lambda1 = lambda;
      } else {
        if (lambda > lambda2) {
          if (angle(bounds_lambda0, lambda) > angle(bounds_lambda0, lambda1)) lambda1 = lambda;
        } else {
          if (angle(lambda, lambda1) > angle(bounds_lambda0, lambda1)) bounds_lambda0 = lambda;
        }
      }
    }
  } else {
    ranges.push(bounds_range = [bounds_lambda0 = lambda, lambda1 = lambda]);
  }
  if (phi < phi0) phi0 = phi;
  if (phi > phi1) phi1 = phi;
  p0 = p, lambda2 = lambda;
}
function boundsLineStart() {
  boundsStream.point = linePoint;
}
function boundsLineEnd() {
  bounds_range[0] = bounds_lambda0, bounds_range[1] = lambda1;
  boundsStream.point = boundsPoint;
  p0 = null;
}
function boundsRingPoint(lambda, phi) {
  if (p0) {
    var delta = lambda - lambda2;
    deltaSum.add(math_abs(delta) > 180 ? delta + (delta > 0 ? 360 : -360) : delta);
  } else {
    bounds_lambda00 = lambda, bounds_phi00 = phi;
  }
  areaStream.point(lambda, phi);
  linePoint(lambda, phi);
}
function boundsRingStart() {
  areaStream.lineStart();
}
function boundsRingEnd() {
  boundsRingPoint(bounds_lambda00, bounds_phi00);
  areaStream.lineEnd();
  if (math_abs(deltaSum) > math_epsilon) bounds_lambda0 = -(lambda1 = 180);
  bounds_range[0] = bounds_lambda0, bounds_range[1] = lambda1;
  p0 = null;
}

// Finds the left-right distance between two longitudes.
// This is almost the same as (lambda1 - lambda0 + 360°) % 360°, except that we want
// the distance between ±180° to be 360°.
function angle(lambda0, lambda1) {
  return (lambda1 -= lambda0) < 0 ? lambda1 + 360 : lambda1;
}
function rangeCompare(a, b) {
  return a[0] - b[0];
}
function rangeContains(range, x) {
  return range[0] <= range[1] ? range[0] <= x && x <= range[1] : x < range[0] || range[1] < x;
}
/* harmony default export */ function bounds(feature) {
  var i, n, a, b, merged, deltaMax, delta;
  phi1 = lambda1 = -(bounds_lambda0 = phi0 = Infinity);
  ranges = [];
  stream(feature, boundsStream);

  // First, sort ranges by their minimum longitudes.
  if (n = ranges.length) {
    ranges.sort(rangeCompare);

    // Then, merge any ranges that overlap.
    for (i = 1, a = ranges[0], merged = [a]; i < n; ++i) {
      b = ranges[i];
      if (rangeContains(a, b[0]) || rangeContains(a, b[1])) {
        if (angle(a[0], b[1]) > angle(a[0], a[1])) a[1] = b[1];
        if (angle(b[0], a[1]) > angle(a[0], a[1])) a[0] = b[0];
      } else {
        merged.push(a = b);
      }
    }

    // Finally, find the largest gap between the merged ranges.
    // The final bounding box will be the inverse of this gap.
    for (deltaMax = -Infinity, n = merged.length - 1, i = 0, a = merged[n]; i <= n; a = b, ++i) {
      b = merged[i];
      if ((delta = angle(a[1], b[0])) > deltaMax) deltaMax = delta, bounds_lambda0 = b[0], lambda1 = a[1];
    }
  }
  ranges = bounds_range = null;
  return bounds_lambda0 === Infinity || phi0 === Infinity ? [[NaN, NaN], [NaN, NaN]] : [[bounds_lambda0, phi0], [lambda1, phi1]];
}
;// ./node_modules/d3-geo/src/centroid.js



var W0, W1, X0, Y0, Z0, X1, Y1, Z1, X2, Y2, Z2, centroid_lambda00, centroid_phi00,
  // first point
  x0, y0, z0; // previous point

var centroidStream = {
  sphere: noop,
  point: centroidPoint,
  lineStart: centroidLineStart,
  lineEnd: centroidLineEnd,
  polygonStart: function () {
    centroidStream.lineStart = centroidRingStart;
    centroidStream.lineEnd = centroidRingEnd;
  },
  polygonEnd: function () {
    centroidStream.lineStart = centroidLineStart;
    centroidStream.lineEnd = centroidLineEnd;
  }
};

// Arithmetic mean of Cartesian vectors.
function centroidPoint(lambda, phi) {
  lambda *= math_radians, phi *= math_radians;
  var cosPhi = math_cos(phi);
  centroidPointCartesian(cosPhi * math_cos(lambda), cosPhi * math_sin(lambda), math_sin(phi));
}
function centroidPointCartesian(x, y, z) {
  ++W0;
  X0 += (x - X0) / W0;
  Y0 += (y - Y0) / W0;
  Z0 += (z - Z0) / W0;
}
function centroidLineStart() {
  centroidStream.point = centroidLinePointFirst;
}
function centroidLinePointFirst(lambda, phi) {
  lambda *= math_radians, phi *= math_radians;
  var cosPhi = math_cos(phi);
  x0 = cosPhi * math_cos(lambda);
  y0 = cosPhi * math_sin(lambda);
  z0 = math_sin(phi);
  centroidStream.point = centroidLinePoint;
  centroidPointCartesian(x0, y0, z0);
}
function centroidLinePoint(lambda, phi) {
  lambda *= math_radians, phi *= math_radians;
  var cosPhi = math_cos(phi),
    x = cosPhi * math_cos(lambda),
    y = cosPhi * math_sin(lambda),
    z = math_sin(phi),
    w = math_atan2(math_sqrt((w = y0 * z - z0 * y) * w + (w = z0 * x - x0 * z) * w + (w = x0 * y - y0 * x) * w), x0 * x + y0 * y + z0 * z);
  W1 += w;
  X1 += w * (x0 + (x0 = x));
  Y1 += w * (y0 + (y0 = y));
  Z1 += w * (z0 + (z0 = z));
  centroidPointCartesian(x0, y0, z0);
}
function centroidLineEnd() {
  centroidStream.point = centroidPoint;
}

// See J. E. Brock, The Inertia Tensor for a Spherical Triangle,
// J. Applied Mechanics 42, 239 (1975).
function centroidRingStart() {
  centroidStream.point = centroidRingPointFirst;
}
function centroidRingEnd() {
  centroidRingPoint(centroid_lambda00, centroid_phi00);
  centroidStream.point = centroidPoint;
}
function centroidRingPointFirst(lambda, phi) {
  centroid_lambda00 = lambda, centroid_phi00 = phi;
  lambda *= math_radians, phi *= math_radians;
  centroidStream.point = centroidRingPoint;
  var cosPhi = math_cos(phi);
  x0 = cosPhi * math_cos(lambda);
  y0 = cosPhi * math_sin(lambda);
  z0 = math_sin(phi);
  centroidPointCartesian(x0, y0, z0);
}
function centroidRingPoint(lambda, phi) {
  lambda *= math_radians, phi *= math_radians;
  var cosPhi = math_cos(phi),
    x = cosPhi * math_cos(lambda),
    y = cosPhi * math_sin(lambda),
    z = math_sin(phi),
    cx = y0 * z - z0 * y,
    cy = z0 * x - x0 * z,
    cz = x0 * y - y0 * x,
    m = math_sqrt(cx * cx + cy * cy + cz * cz),
    w = math_asin(m),
    // line weight = angle
    v = m && -w / m; // area weight multiplier
  X2 += v * cx;
  Y2 += v * cy;
  Z2 += v * cz;
  W1 += w;
  X1 += w * (x0 + (x0 = x));
  Y1 += w * (y0 + (y0 = y));
  Z1 += w * (z0 + (z0 = z));
  centroidPointCartesian(x0, y0, z0);
}
/* harmony default export */ function centroid(object) {
  W0 = W1 = X0 = Y0 = Z0 = X1 = Y1 = Z1 = X2 = Y2 = Z2 = 0;
  stream(object, centroidStream);
  var x = X2,
    y = Y2,
    z = Z2,
    m = x * x + y * y + z * z;

  // If the area-weighted ccentroid is undefined, fall back to length-weighted ccentroid.
  if (m < epsilon2) {
    x = X1, y = Y1, z = Z1;
    // If the feature has zero length, fall back to arithmetic mean of point vectors.
    if (W1 < epsilon) x = X0, y = Y0, z = Z0;
    m = x * x + y * y + z * z;
    // If the feature still has an undefined ccentroid, then return.
    if (m < epsilon2) return [NaN, NaN];
  }
  return [atan2(y, x) * degrees, asin(z / sqrt(m)) * degrees];
}
;// ./node_modules/d3-geo/src/compose.js
/* harmony default export */ function compose(a, b) {
  function compose(x, y) {
    return x = a(x, y), b(x[0], x[1]);
  }
  if (a.invert && b.invert) compose.invert = function (x, y) {
    return x = b.invert(x, y), x && a.invert(x[0], x[1]);
  };
  return compose;
}
;// ./node_modules/d3-geo/src/rotation.js


function rotationIdentity(lambda, phi) {
  return [lambda > math_pi ? lambda - math_tau : lambda < -math_pi ? lambda + math_tau : lambda, phi];
}
rotationIdentity.invert = rotationIdentity;
function rotation_rotateRadians(deltaLambda, deltaPhi, deltaGamma) {
  return (deltaLambda %= math_tau) ? deltaPhi || deltaGamma ? compose(rotationLambda(deltaLambda), rotationPhiGamma(deltaPhi, deltaGamma)) : rotationLambda(deltaLambda) : deltaPhi || deltaGamma ? rotationPhiGamma(deltaPhi, deltaGamma) : rotationIdentity;
}
function forwardRotationLambda(deltaLambda) {
  return function (lambda, phi) {
    return lambda += deltaLambda, [lambda > math_pi ? lambda - math_tau : lambda < -math_pi ? lambda + math_tau : lambda, phi];
  };
}
function rotationLambda(deltaLambda) {
  var rotation = forwardRotationLambda(deltaLambda);
  rotation.invert = forwardRotationLambda(-deltaLambda);
  return rotation;
}
function rotationPhiGamma(deltaPhi, deltaGamma) {
  var cosDeltaPhi = math_cos(deltaPhi),
    sinDeltaPhi = math_sin(deltaPhi),
    cosDeltaGamma = math_cos(deltaGamma),
    sinDeltaGamma = math_sin(deltaGamma);
  function rotation(lambda, phi) {
    var cosPhi = math_cos(phi),
      x = math_cos(lambda) * cosPhi,
      y = math_sin(lambda) * cosPhi,
      z = math_sin(phi),
      k = z * cosDeltaPhi + x * sinDeltaPhi;
    return [math_atan2(y * cosDeltaGamma - k * sinDeltaGamma, x * cosDeltaPhi - z * sinDeltaPhi), math_asin(k * cosDeltaGamma + y * sinDeltaGamma)];
  }
  rotation.invert = function (lambda, phi) {
    var cosPhi = math_cos(phi),
      x = math_cos(lambda) * cosPhi,
      y = math_sin(lambda) * cosPhi,
      z = math_sin(phi),
      k = z * cosDeltaGamma - y * sinDeltaGamma;
    return [math_atan2(y * cosDeltaGamma + z * sinDeltaGamma, x * cosDeltaPhi + k * sinDeltaPhi), math_asin(k * cosDeltaPhi - x * sinDeltaPhi)];
  };
  return rotation;
}
/* harmony default export */ function src_rotation(rotate) {
  rotate = rotation_rotateRadians(rotate[0] * radians, rotate[1] * radians, rotate.length > 2 ? rotate[2] * radians : 0);
  function forward(coordinates) {
    coordinates = rotate(coordinates[0] * radians, coordinates[1] * radians);
    return coordinates[0] *= degrees, coordinates[1] *= degrees, coordinates;
  }
  forward.invert = function (coordinates) {
    coordinates = rotate.invert(coordinates[0] * radians, coordinates[1] * radians);
    return coordinates[0] *= degrees, coordinates[1] *= degrees, coordinates;
  };
  return forward;
}
;// ./node_modules/d3-geo/src/circle.js





// Generates a circle centered at [0°, 0°], with a given radius and precision.
function circleStream(stream, radius, delta, direction, t0, t1) {
  if (!delta) return;
  var cosRadius = math_cos(radius),
    sinRadius = math_sin(radius),
    step = direction * delta;
  if (t0 == null) {
    t0 = radius + direction * math_tau;
    t1 = radius - step / 2;
  } else {
    t0 = circleRadius(cosRadius, t0);
    t1 = circleRadius(cosRadius, t1);
    if (direction > 0 ? t0 < t1 : t0 > t1) t0 += direction * math_tau;
  }
  for (var point, t = t0; direction > 0 ? t > t1 : t < t1; t -= step) {
    point = spherical([cosRadius, -sinRadius * math_cos(t), -sinRadius * math_sin(t)]);
    stream.point(point[0], point[1]);
  }
}

// Returns the signed angle of a cartesian point relative to [cosRadius, 0, 0].
function circleRadius(cosRadius, point) {
  point = cartesian(point), point[0] -= cosRadius;
  cartesianNormalizeInPlace(point);
  var radius = acos(-point[1]);
  return ((-point[2] < 0 ? -radius : radius) + math_tau - math_epsilon) % math_tau;
}
/* harmony default export */ function circle() {
  var center = constant([0, 0]),
    radius = constant(90),
    precision = constant(6),
    ring,
    rotate,
    stream = {
      point: point
    };
  function point(x, y) {
    ring.push(x = rotate(x, y));
    x[0] *= degrees, x[1] *= degrees;
  }
  function circle() {
    var c = center.apply(this, arguments),
      r = radius.apply(this, arguments) * radians,
      p = precision.apply(this, arguments) * radians;
    ring = [];
    rotate = rotateRadians(-c[0] * radians, -c[1] * radians, 0).invert;
    circleStream(stream, r, p, 1);
    c = {
      type: "Polygon",
      coordinates: [ring]
    };
    ring = rotate = null;
    return c;
  }
  circle.center = function (_) {
    return arguments.length ? (center = typeof _ === "function" ? _ : constant([+_[0], +_[1]]), circle) : center;
  };
  circle.radius = function (_) {
    return arguments.length ? (radius = typeof _ === "function" ? _ : constant(+_), circle) : radius;
  };
  circle.precision = function (_) {
    return arguments.length ? (precision = typeof _ === "function" ? _ : constant(+_), circle) : precision;
  };
  return circle;
}
;// ./node_modules/d3-geo/src/clip/buffer.js

/* harmony default export */ function buffer() {
  var lines = [],
    line;
  return {
    point: function (x, y) {
      line.push([x, y]);
    },
    lineStart: function () {
      lines.push(line = []);
    },
    lineEnd: noop,
    rejoin: function () {
      if (lines.length > 1) lines.push(lines.pop().concat(lines.shift()));
    },
    result: function () {
      var result = lines;
      lines = [];
      line = null;
      return result;
    }
  };
}
;// ./node_modules/d3-geo/src/clip/line.js
/* harmony default export */ function line(a, b, x0, y0, x1, y1) {
  var ax = a[0],
    ay = a[1],
    bx = b[0],
    by = b[1],
    t0 = 0,
    t1 = 1,
    dx = bx - ax,
    dy = by - ay,
    r;
  r = x0 - ax;
  if (!dx && r > 0) return;
  r /= dx;
  if (dx < 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  } else if (dx > 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  }
  r = x1 - ax;
  if (!dx && r < 0) return;
  r /= dx;
  if (dx < 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  } else if (dx > 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  }
  r = y0 - ay;
  if (!dy && r > 0) return;
  r /= dy;
  if (dy < 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  } else if (dy > 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  }
  r = y1 - ay;
  if (!dy && r < 0) return;
  r /= dy;
  if (dy < 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  } else if (dy > 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  }
  if (t0 > 0) a[0] = ax + t0 * dx, a[1] = ay + t0 * dy;
  if (t1 < 1) b[0] = ax + t1 * dx, b[1] = ay + t1 * dy;
  return true;
}
;// ./node_modules/d3-geo/src/pointEqual.js

/* harmony default export */ function pointEqual(a, b) {
  return math_abs(a[0] - b[0]) < math_epsilon && math_abs(a[1] - b[1]) < math_epsilon;
}
;// ./node_modules/d3-geo/src/clip/polygon.js

function Intersection(point, points, other, entry) {
  this.x = point;
  this.z = points;
  this.o = other; // another intersection
  this.e = entry; // is an entry?
  this.v = false; // visited
  this.n = this.p = null; // next & previous
}

// A generalized polygon clipping algorithm: given a polygon that has been cut
// into its visible line segments, and rejoins the segments by interpolating
// along the clip edge.
/* harmony default export */ function clip_polygon(segments, compareIntersection, startInside, interpolate, stream) {
  var subject = [],
    clip = [],
    i,
    n;
  segments.forEach(function (segment) {
    if ((n = segment.length - 1) <= 0) return;
    var n,
      p0 = segment[0],
      p1 = segment[n],
      x;

    // If the first and last points of a segment are coincident, then treat as a
    // closed ring. TODO if all rings are closed, then the winding order of the
    // exterior ring should be checked.
    if (pointEqual(p0, p1)) {
      stream.lineStart();
      for (i = 0; i < n; ++i) stream.point((p0 = segment[i])[0], p0[1]);
      stream.lineEnd();
      return;
    }
    subject.push(x = new Intersection(p0, segment, null, true));
    clip.push(x.o = new Intersection(p0, null, x, false));
    subject.push(x = new Intersection(p1, segment, null, false));
    clip.push(x.o = new Intersection(p1, null, x, true));
  });
  if (!subject.length) return;
  clip.sort(compareIntersection);
  polygon_link(subject);
  polygon_link(clip);
  for (i = 0, n = clip.length; i < n; ++i) {
    clip[i].e = startInside = !startInside;
  }
  var start = subject[0],
    points,
    point;
  while (1) {
    // Find first unvisited intersection.
    var current = start,
      isSubject = true;
    while (current.v) if ((current = current.n) === start) return;
    points = current.z;
    stream.lineStart();
    do {
      current.v = current.o.v = true;
      if (current.e) {
        if (isSubject) {
          for (i = 0, n = points.length; i < n; ++i) stream.point((point = points[i])[0], point[1]);
        } else {
          interpolate(current.x, current.n.x, 1, stream);
        }
        current = current.n;
      } else {
        if (isSubject) {
          points = current.p.z;
          for (i = points.length - 1; i >= 0; --i) stream.point((point = points[i])[0], point[1]);
        } else {
          interpolate(current.x, current.p.x, -1, stream);
        }
        current = current.p;
      }
      current = current.o;
      points = current.z;
      isSubject = !isSubject;
    } while (!current.v);
    stream.lineEnd();
  }
}
function polygon_link(array) {
  if (!(n = array.length)) return;
  var n,
    i = 0,
    a = array[0],
    b;
  while (++i < n) {
    a.n = b = array[i];
    b.p = a;
    a = b;
  }
  a.n = b = array[0];
  b.p = a;
}
;// ./node_modules/d3-array/src/ascending.js
/* harmony default export */ function src_ascending(a, b) {
  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
}
;// ./node_modules/d3-array/src/bisector.js

/* harmony default export */ function bisector(compare) {
  if (compare.length === 1) compare = ascendingComparator(compare);
  return {
    left: function (a, x, lo, hi) {
      if (lo == null) lo = 0;
      if (hi == null) hi = a.length;
      while (lo < hi) {
        var mid = lo + hi >>> 1;
        if (compare(a[mid], x) < 0) lo = mid + 1;else hi = mid;
      }
      return lo;
    },
    right: function (a, x, lo, hi) {
      if (lo == null) lo = 0;
      if (hi == null) hi = a.length;
      while (lo < hi) {
        var mid = lo + hi >>> 1;
        if (compare(a[mid], x) > 0) hi = mid;else lo = mid + 1;
      }
      return lo;
    }
  };
}
function ascendingComparator(f) {
  return function (d, x) {
    return src_ascending(f(d), x);
  };
}
;// ./node_modules/d3-array/src/bisect.js


var ascendingBisect = bisector(src_ascending);
var bisectRight = ascendingBisect.right;
var bisectLeft = ascendingBisect.left;
/* harmony default export */ const src_bisect = ((/* unused pure expression or super */ null && (bisectRight)));
;// ./node_modules/d3-array/src/array.js
var array = Array.prototype;
var array_slice = array.slice;
var array_map = array.map;
;// ./node_modules/d3-array/src/ticks.js
var e10 = Math.sqrt(50),
  e5 = Math.sqrt(10),
  e2 = Math.sqrt(2);
/* harmony default export */ function ticks(start, stop, count) {
  var reverse,
    i = -1,
    n,
    ticks,
    step;
  stop = +stop, start = +start, count = +count;
  if (start === stop && count > 0) return [start];
  if (reverse = stop < start) n = start, start = stop, stop = n;
  if ((step = tickIncrement(start, stop, count)) === 0 || !isFinite(step)) return [];
  if (step > 0) {
    start = Math.ceil(start / step);
    stop = Math.floor(stop / step);
    ticks = new Array(n = Math.ceil(stop - start + 1));
    while (++i < n) ticks[i] = (start + i) * step;
  } else {
    start = Math.floor(start * step);
    stop = Math.ceil(stop * step);
    ticks = new Array(n = Math.ceil(start - stop + 1));
    while (++i < n) ticks[i] = (start - i) / step;
  }
  if (reverse) ticks.reverse();
  return ticks;
}
function tickIncrement(start, stop, count) {
  var step = (stop - start) / Math.max(0, count),
    power = Math.floor(Math.log(step) / Math.LN10),
    error = step / Math.pow(10, power);
  return power >= 0 ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power) : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);
}
function ticks_tickStep(start, stop, count) {
  var step0 = Math.abs(stop - start) / Math.max(0, count),
    step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
    error = step0 / step1;
  if (error >= e10) step1 *= 10;else if (error >= e5) step1 *= 5;else if (error >= e2) step1 *= 2;
  return stop < start ? -step1 : step1;
}
;// ./node_modules/d3-array/src/histogram.js








/* harmony default export */ function histogram() {
  var value = identity,
    domain = extent,
    threshold = sturges;
  function histogram(data) {
    var i,
      n = data.length,
      x,
      values = new Array(n);
    for (i = 0; i < n; ++i) {
      values[i] = value(data[i], i, data);
    }
    var xz = domain(values),
      x0 = xz[0],
      x1 = xz[1],
      tz = threshold(values, x0, x1);

    // Convert number of thresholds into uniform thresholds.
    if (!Array.isArray(tz)) {
      tz = tickStep(x0, x1, tz);
      tz = range(Math.ceil(x0 / tz) * tz, x1, tz); // exclusive
    }

    // Remove any thresholds outside the domain.
    var m = tz.length;
    while (tz[0] <= x0) tz.shift(), --m;
    while (tz[m - 1] > x1) tz.pop(), --m;
    var bins = new Array(m + 1),
      bin;

    // Initialize bins.
    for (i = 0; i <= m; ++i) {
      bin = bins[i] = [];
      bin.x0 = i > 0 ? tz[i - 1] : x0;
      bin.x1 = i < m ? tz[i] : x1;
    }

    // Assign data to bins by value, ignoring any outside the domain.
    for (i = 0; i < n; ++i) {
      x = values[i];
      if (x0 <= x && x <= x1) {
        bins[bisect(tz, x, 0, m)].push(data[i]);
      }
    }
    return bins;
  }
  histogram.value = function (_) {
    return arguments.length ? (value = typeof _ === "function" ? _ : constant(_), histogram) : value;
  };
  histogram.domain = function (_) {
    return arguments.length ? (domain = typeof _ === "function" ? _ : constant([_[0], _[1]]), histogram) : domain;
  };
  histogram.thresholds = function (_) {
    return arguments.length ? (threshold = typeof _ === "function" ? _ : Array.isArray(_) ? constant(slice.call(_)) : constant(_), histogram) : threshold;
  };
  return histogram;
}
;// ./node_modules/d3-array/src/threshold/freedmanDiaconis.js




/* harmony default export */ function freedmanDiaconis(values, min, max) {
  values = map.call(values, number).sort(ascending);
  return Math.ceil((max - min) / (2 * (quantile(values, 0.75) - quantile(values, 0.25)) * Math.pow(values.length, -1 / 3)));
}
;// ./node_modules/d3-array/src/merge.js
/* harmony default export */ function merge(arrays) {
  var n = arrays.length,
    m,
    i = -1,
    j = 0,
    merged,
    array;
  while (++i < n) j += arrays[i].length;
  merged = new Array(j);
  while (--n >= 0) {
    array = arrays[n];
    m = array.length;
    while (--m >= 0) {
      merged[--j] = array[m];
    }
  }
  return merged;
}
;// ./node_modules/d3-array/src/index.js



























;// ./node_modules/d3-geo/src/clip/extent.js





var clipMax = 1e9,
  clipMin = -clipMax;

// TODO Use d3-polygon’s polygonContains here for the ring check?
// TODO Eliminate duplicate buffering in clipBuffer and polygon.push?

function extent_clipExtent(x0, y0, x1, y1) {
  function visible(x, y) {
    return x0 <= x && x <= x1 && y0 <= y && y <= y1;
  }
  function interpolate(from, to, direction, stream) {
    var a = 0,
      a1 = 0;
    if (from == null || (a = corner(from, direction)) !== (a1 = corner(to, direction)) || comparePoint(from, to) < 0 ^ direction > 0) {
      do stream.point(a === 0 || a === 3 ? x0 : x1, a > 1 ? y1 : y0); while ((a = (a + direction + 4) % 4) !== a1);
    } else {
      stream.point(to[0], to[1]);
    }
  }
  function corner(p, direction) {
    return math_abs(p[0] - x0) < math_epsilon ? direction > 0 ? 0 : 3 : math_abs(p[0] - x1) < math_epsilon ? direction > 0 ? 2 : 1 : math_abs(p[1] - y0) < math_epsilon ? direction > 0 ? 1 : 0 : direction > 0 ? 3 : 2; // abs(p[1] - y1) < epsilon
  }
  function compareIntersection(a, b) {
    return comparePoint(a.x, b.x);
  }
  function comparePoint(a, b) {
    var ca = corner(a, 1),
      cb = corner(b, 1);
    return ca !== cb ? ca - cb : ca === 0 ? b[1] - a[1] : ca === 1 ? a[0] - b[0] : ca === 2 ? a[1] - b[1] : b[0] - a[0];
  }
  return function (stream) {
    var activeStream = stream,
      bufferStream = buffer(),
      segments,
      polygon,
      ring,
      x__,
      y__,
      v__,
      // first point
      x_,
      y_,
      v_,
      // previous point
      first,
      clean;
    var clipStream = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: polygonStart,
      polygonEnd: polygonEnd
    };
    function point(x, y) {
      if (visible(x, y)) activeStream.point(x, y);
    }
    function polygonInside() {
      var winding = 0;
      for (var i = 0, n = polygon.length; i < n; ++i) {
        for (var ring = polygon[i], j = 1, m = ring.length, point = ring[0], a0, a1, b0 = point[0], b1 = point[1]; j < m; ++j) {
          a0 = b0, a1 = b1, point = ring[j], b0 = point[0], b1 = point[1];
          if (a1 <= y1) {
            if (b1 > y1 && (b0 - a0) * (y1 - a1) > (b1 - a1) * (x0 - a0)) ++winding;
          } else {
            if (b1 <= y1 && (b0 - a0) * (y1 - a1) < (b1 - a1) * (x0 - a0)) --winding;
          }
        }
      }
      return winding;
    }

    // Buffer geometry within a polygon and then clip it en masse.
    function polygonStart() {
      activeStream = bufferStream, segments = [], polygon = [], clean = true;
    }
    function polygonEnd() {
      var startInside = polygonInside(),
        cleanInside = clean && startInside,
        visible = (segments = merge(segments)).length;
      if (cleanInside || visible) {
        stream.polygonStart();
        if (cleanInside) {
          stream.lineStart();
          interpolate(null, null, 1, stream);
          stream.lineEnd();
        }
        if (visible) {
          clip_polygon(segments, compareIntersection, startInside, interpolate, stream);
        }
        stream.polygonEnd();
      }
      activeStream = stream, segments = polygon = ring = null;
    }
    function lineStart() {
      clipStream.point = linePoint;
      if (polygon) polygon.push(ring = []);
      first = true;
      v_ = false;
      x_ = y_ = NaN;
    }

    // TODO rather than special-case polygons, simply handle them separately.
    // Ideally, coincident intersection points should be jittered to avoid
    // clipping issues.
    function lineEnd() {
      if (segments) {
        linePoint(x__, y__);
        if (v__ && v_) bufferStream.rejoin();
        segments.push(bufferStream.result());
      }
      clipStream.point = point;
      if (v_) activeStream.lineEnd();
    }
    function linePoint(x, y) {
      var v = visible(x, y);
      if (polygon) ring.push([x, y]);
      if (first) {
        x__ = x, y__ = y, v__ = v;
        first = false;
        if (v) {
          activeStream.lineStart();
          activeStream.point(x, y);
        }
      } else {
        if (v && v_) activeStream.point(x, y);else {
          var a = [x_ = Math.max(clipMin, Math.min(clipMax, x_)), y_ = Math.max(clipMin, Math.min(clipMax, y_))],
            b = [x = Math.max(clipMin, Math.min(clipMax, x)), y = Math.max(clipMin, Math.min(clipMax, y))];
          if (line(a, b, x0, y0, x1, y1)) {
            if (!v_) {
              activeStream.lineStart();
              activeStream.point(a[0], a[1]);
            }
            activeStream.point(b[0], b[1]);
            if (!v) activeStream.lineEnd();
            clean = false;
          } else if (v) {
            activeStream.lineStart();
            activeStream.point(x, y);
            clean = false;
          }
        }
      }
      x_ = x, y_ = y, v_ = v;
    }
    return clipStream;
  };
}
/* harmony default export */ function clip_extent() {
  var x0 = 0,
    y0 = 0,
    x1 = 960,
    y1 = 500,
    cache,
    cacheStream,
    clip;
  return clip = {
    stream: function (stream) {
      return cache && cacheStream === stream ? cache : cache = extent_clipExtent(x0, y0, x1, y1)(cacheStream = stream);
    },
    extent: function (_) {
      return arguments.length ? (x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1], cache = cacheStream = null, clip) : [[x0, y0], [x1, y1]];
    }
  };
}
;// ./node_modules/d3-geo/src/polygonContains.js



var sum = adder();
/* harmony default export */ function polygonContains(polygon, point) {
  var lambda = point[0],
    phi = point[1],
    normal = [math_sin(lambda), -math_cos(lambda), 0],
    angle = 0,
    winding = 0;
  sum.reset();
  for (var i = 0, n = polygon.length; i < n; ++i) {
    if (!(m = (ring = polygon[i]).length)) continue;
    var ring,
      m,
      point0 = ring[m - 1],
      lambda0 = point0[0],
      phi0 = point0[1] / 2 + quarterPi,
      sinPhi0 = math_sin(phi0),
      cosPhi0 = math_cos(phi0);
    for (var j = 0; j < m; ++j, lambda0 = lambda1, sinPhi0 = sinPhi1, cosPhi0 = cosPhi1, point0 = point1) {
      var point1 = ring[j],
        lambda1 = point1[0],
        phi1 = point1[1] / 2 + quarterPi,
        sinPhi1 = math_sin(phi1),
        cosPhi1 = math_cos(phi1),
        delta = lambda1 - lambda0,
        sign = delta >= 0 ? 1 : -1,
        absDelta = sign * delta,
        antimeridian = absDelta > math_pi,
        k = sinPhi0 * sinPhi1;
      sum.add(math_atan2(k * sign * math_sin(absDelta), cosPhi0 * cosPhi1 + k * math_cos(absDelta)));
      angle += antimeridian ? delta + sign * math_tau : delta;

      // Are the longitudes either side of the point’s meridian (lambda),
      // and are the latitudes smaller than the parallel (phi)?
      if (antimeridian ^ lambda0 >= lambda ^ lambda1 >= lambda) {
        var arc = cartesianCross(cartesian(point0), cartesian(point1));
        cartesianNormalizeInPlace(arc);
        var intersection = cartesianCross(normal, arc);
        cartesianNormalizeInPlace(intersection);
        var phiArc = (antimeridian ^ delta >= 0 ? -1 : 1) * math_asin(intersection[2]);
        if (phi > phiArc || phi === phiArc && (arc[0] || arc[1])) {
          winding += antimeridian ^ delta >= 0 ? 1 : -1;
        }
      }
    }
  }

  // First, determine whether the South pole is inside or outside:
  //
  // It is inside if:
  // * the polygon winds around it in a clockwise direction.
  // * the polygon does not (cumulatively) wind around it, but has a negative
  //   (counter-clockwise) area.
  //
  // Second, count the (signed) number of times a segment crosses a lambda
  // from the point to the South pole.  If it is zero, then the point is the
  // same side as the South pole.

  return (angle < -math_epsilon || angle < math_epsilon && sum < -math_epsilon) ^ winding & 1;
}
;// ./node_modules/d3-geo/src/length.js




var lengthSum = adder(),
  length_lambda0,
  length_sinPhi0,
  length_cosPhi0;
var lengthStream = {
  sphere: noop,
  point: noop,
  lineStart: lengthLineStart,
  lineEnd: noop,
  polygonStart: noop,
  polygonEnd: noop
};
function lengthLineStart() {
  lengthStream.point = lengthPointFirst;
  lengthStream.lineEnd = lengthLineEnd;
}
function lengthLineEnd() {
  lengthStream.point = lengthStream.lineEnd = noop;
}
function lengthPointFirst(lambda, phi) {
  lambda *= math_radians, phi *= math_radians;
  length_lambda0 = lambda, length_sinPhi0 = math_sin(phi), length_cosPhi0 = math_cos(phi);
  lengthStream.point = lengthPoint;
}
function lengthPoint(lambda, phi) {
  lambda *= math_radians, phi *= math_radians;
  var sinPhi = math_sin(phi),
    cosPhi = math_cos(phi),
    delta = math_abs(lambda - length_lambda0),
    cosDelta = math_cos(delta),
    sinDelta = math_sin(delta),
    x = cosPhi * sinDelta,
    y = length_cosPhi0 * sinPhi - length_sinPhi0 * cosPhi * cosDelta,
    z = length_sinPhi0 * sinPhi + length_cosPhi0 * cosPhi * cosDelta;
  lengthSum.add(math_atan2(math_sqrt(x * x + y * y), z));
  length_lambda0 = lambda, length_sinPhi0 = sinPhi, length_cosPhi0 = cosPhi;
}
/* harmony default export */ function src_length(object) {
  lengthSum.reset();
  src_stream(object, lengthStream);
  return +lengthSum;
}
;// ./node_modules/d3-geo/src/distance.js

var coordinates = [null, null],
  object = {
    type: "LineString",
    coordinates: coordinates
  };
/* harmony default export */ function distance(a, b) {
  coordinates[0] = a;
  coordinates[1] = b;
  return src_length(object);
}
;// ./node_modules/d3-geo/src/contains.js



var containsObjectType = {
  Feature: function (object, point) {
    return containsGeometry(object.geometry, point);
  },
  FeatureCollection: function (object, point) {
    var features = object.features,
      i = -1,
      n = features.length;
    while (++i < n) if (containsGeometry(features[i].geometry, point)) return true;
    return false;
  }
};
var containsGeometryType = {
  Sphere: function () {
    return true;
  },
  Point: function (object, point) {
    return containsPoint(object.coordinates, point);
  },
  MultiPoint: function (object, point) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) if (containsPoint(coordinates[i], point)) return true;
    return false;
  },
  LineString: function (object, point) {
    return containsLine(object.coordinates, point);
  },
  MultiLineString: function (object, point) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) if (containsLine(coordinates[i], point)) return true;
    return false;
  },
  Polygon: function (object, point) {
    return containsPolygon(object.coordinates, point);
  },
  MultiPolygon: function (object, point) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) if (containsPolygon(coordinates[i], point)) return true;
    return false;
  },
  GeometryCollection: function (object, point) {
    var geometries = object.geometries,
      i = -1,
      n = geometries.length;
    while (++i < n) if (containsGeometry(geometries[i], point)) return true;
    return false;
  }
};
function containsGeometry(geometry, point) {
  return geometry && containsGeometryType.hasOwnProperty(geometry.type) ? containsGeometryType[geometry.type](geometry, point) : false;
}
function containsPoint(coordinates, point) {
  return distance(coordinates, point) === 0;
}
function containsLine(coordinates, point) {
  var ab = distance(coordinates[0], coordinates[1]),
    ao = distance(coordinates[0], point),
    ob = distance(point, coordinates[1]);
  return ao + ob <= ab + math_epsilon;
}
function containsPolygon(coordinates, point) {
  return !!polygonContains(coordinates.map(ringRadians), pointRadians(point));
}
function ringRadians(ring) {
  return ring = ring.map(pointRadians), ring.pop(), ring;
}
function pointRadians(point) {
  return [point[0] * math_radians, point[1] * math_radians];
}
/* harmony default export */ function contains(object, point) {
  return (object && containsObjectType.hasOwnProperty(object.type) ? containsObjectType[object.type] : containsGeometry)(object, point);
}
;// ./node_modules/d3-geo/src/graticule.js


function graticuleX(y0, y1, dy) {
  var y = range(y0, y1 - epsilon, dy).concat(y1);
  return function (x) {
    return y.map(function (y) {
      return [x, y];
    });
  };
}
function graticuleY(x0, x1, dx) {
  var x = range(x0, x1 - epsilon, dx).concat(x1);
  return function (y) {
    return x.map(function (x) {
      return [x, y];
    });
  };
}
function graticule() {
  var x1,
    x0,
    X1,
    X0,
    y1,
    y0,
    Y1,
    Y0,
    dx = 10,
    dy = dx,
    DX = 90,
    DY = 360,
    x,
    y,
    X,
    Y,
    precision = 2.5;
  function graticule() {
    return {
      type: "MultiLineString",
      coordinates: lines()
    };
  }
  function lines() {
    return range(ceil(X0 / DX) * DX, X1, DX).map(X).concat(range(ceil(Y0 / DY) * DY, Y1, DY).map(Y)).concat(range(ceil(x0 / dx) * dx, x1, dx).filter(function (x) {
      return abs(x % DX) > epsilon;
    }).map(x)).concat(range(ceil(y0 / dy) * dy, y1, dy).filter(function (y) {
      return abs(y % DY) > epsilon;
    }).map(y));
  }
  graticule.lines = function () {
    return lines().map(function (coordinates) {
      return {
        type: "LineString",
        coordinates: coordinates
      };
    });
  };
  graticule.outline = function () {
    return {
      type: "Polygon",
      coordinates: [X(X0).concat(Y(Y1).slice(1), X(X1).reverse().slice(1), Y(Y0).reverse().slice(1))]
    };
  };
  graticule.extent = function (_) {
    if (!arguments.length) return graticule.extentMinor();
    return graticule.extentMajor(_).extentMinor(_);
  };
  graticule.extentMajor = function (_) {
    if (!arguments.length) return [[X0, Y0], [X1, Y1]];
    X0 = +_[0][0], X1 = +_[1][0];
    Y0 = +_[0][1], Y1 = +_[1][1];
    if (X0 > X1) _ = X0, X0 = X1, X1 = _;
    if (Y0 > Y1) _ = Y0, Y0 = Y1, Y1 = _;
    return graticule.precision(precision);
  };
  graticule.extentMinor = function (_) {
    if (!arguments.length) return [[x0, y0], [x1, y1]];
    x0 = +_[0][0], x1 = +_[1][0];
    y0 = +_[0][1], y1 = +_[1][1];
    if (x0 > x1) _ = x0, x0 = x1, x1 = _;
    if (y0 > y1) _ = y0, y0 = y1, y1 = _;
    return graticule.precision(precision);
  };
  graticule.step = function (_) {
    if (!arguments.length) return graticule.stepMinor();
    return graticule.stepMajor(_).stepMinor(_);
  };
  graticule.stepMajor = function (_) {
    if (!arguments.length) return [DX, DY];
    DX = +_[0], DY = +_[1];
    return graticule;
  };
  graticule.stepMinor = function (_) {
    if (!arguments.length) return [dx, dy];
    dx = +_[0], dy = +_[1];
    return graticule;
  };
  graticule.precision = function (_) {
    if (!arguments.length) return precision;
    precision = +_;
    x = graticuleX(y0, y1, 90);
    y = graticuleY(x0, x1, precision);
    X = graticuleX(Y0, Y1, 90);
    Y = graticuleY(X0, X1, precision);
    return graticule;
  };
  return graticule.extentMajor([[-180, -90 + epsilon], [180, 90 - epsilon]]).extentMinor([[-180, -80 - epsilon], [180, 80 + epsilon]]);
}
function graticule10() {
  return graticule()();
}
;// ./node_modules/d3-geo/src/interpolate.js

/* harmony default export */ function interpolate(a, b) {
  var x0 = a[0] * radians,
    y0 = a[1] * radians,
    x1 = b[0] * radians,
    y1 = b[1] * radians,
    cy0 = cos(y0),
    sy0 = sin(y0),
    cy1 = cos(y1),
    sy1 = sin(y1),
    kx0 = cy0 * cos(x0),
    ky0 = cy0 * sin(x0),
    kx1 = cy1 * cos(x1),
    ky1 = cy1 * sin(x1),
    d = 2 * asin(sqrt(haversin(y1 - y0) + cy0 * cy1 * haversin(x1 - x0))),
    k = sin(d);
  var interpolate = d ? function (t) {
    var B = sin(t *= d) / k,
      A = sin(d - t) / k,
      x = A * kx0 + B * kx1,
      y = A * ky0 + B * ky1,
      z = A * sy0 + B * sy1;
    return [atan2(y, x) * degrees, atan2(z, sqrt(x * x + y * y)) * degrees];
  } : function () {
    return [x0 * degrees, y0 * degrees];
  };
  interpolate.distance = d;
  return interpolate;
}
;// ./node_modules/d3-geo/src/path/area.js



var area_areaSum = adder(),
  area_areaRingSum = adder(),
  x00,
  y00,
  area_x0,
  area_y0;
var area_areaStream = {
  point: noop,
  lineStart: noop,
  lineEnd: noop,
  polygonStart: function () {
    area_areaStream.lineStart = area_areaRingStart;
    area_areaStream.lineEnd = area_areaRingEnd;
  },
  polygonEnd: function () {
    area_areaStream.lineStart = area_areaStream.lineEnd = area_areaStream.point = noop;
    area_areaSum.add(math_abs(area_areaRingSum));
    area_areaRingSum.reset();
  },
  result: function () {
    var area = area_areaSum / 2;
    area_areaSum.reset();
    return area;
  }
};
function area_areaRingStart() {
  area_areaStream.point = area_areaPointFirst;
}
function area_areaPointFirst(x, y) {
  area_areaStream.point = area_areaPoint;
  x00 = area_x0 = x, y00 = area_y0 = y;
}
function area_areaPoint(x, y) {
  area_areaRingSum.add(area_y0 * x - area_x0 * y);
  area_x0 = x, area_y0 = y;
}
function area_areaRingEnd() {
  area_areaPoint(x00, y00);
}
/* harmony default export */ const path_area = ((/* unused pure expression or super */ null && (area_areaStream)));
;// ./node_modules/d3-geo/src/path/bounds.js

var bounds_x0 = Infinity,
  bounds_y0 = bounds_x0,
  x1 = -bounds_x0,
  y1 = x1;
var bounds_boundsStream = {
  point: bounds_boundsPoint,
  lineStart: noop,
  lineEnd: noop,
  polygonStart: noop,
  polygonEnd: noop,
  result: function () {
    var bounds = [[bounds_x0, bounds_y0], [x1, y1]];
    x1 = y1 = -(bounds_y0 = bounds_x0 = Infinity);
    return bounds;
  }
};
function bounds_boundsPoint(x, y) {
  if (x < bounds_x0) bounds_x0 = x;
  if (x > x1) x1 = x;
  if (y < bounds_y0) bounds_y0 = y;
  if (y > y1) y1 = y;
}
/* harmony default export */ const path_bounds = (bounds_boundsStream);
;// ./node_modules/d3-geo/src/path/centroid.js


// TODO Enforce positive area for exterior, negative area for interior?

var centroid_X0 = 0,
  centroid_Y0 = 0,
  centroid_Z0 = 0,
  centroid_X1 = 0,
  centroid_Y1 = 0,
  centroid_Z1 = 0,
  centroid_X2 = 0,
  centroid_Y2 = 0,
  centroid_Z2 = 0,
  centroid_x00,
  centroid_y00,
  centroid_x0,
  centroid_y0;
var centroid_centroidStream = {
  point: centroid_centroidPoint,
  lineStart: centroid_centroidLineStart,
  lineEnd: centroid_centroidLineEnd,
  polygonStart: function () {
    centroid_centroidStream.lineStart = centroid_centroidRingStart;
    centroid_centroidStream.lineEnd = centroid_centroidRingEnd;
  },
  polygonEnd: function () {
    centroid_centroidStream.point = centroid_centroidPoint;
    centroid_centroidStream.lineStart = centroid_centroidLineStart;
    centroid_centroidStream.lineEnd = centroid_centroidLineEnd;
  },
  result: function () {
    var centroid = centroid_Z2 ? [centroid_X2 / centroid_Z2, centroid_Y2 / centroid_Z2] : centroid_Z1 ? [centroid_X1 / centroid_Z1, centroid_Y1 / centroid_Z1] : centroid_Z0 ? [centroid_X0 / centroid_Z0, centroid_Y0 / centroid_Z0] : [NaN, NaN];
    centroid_X0 = centroid_Y0 = centroid_Z0 = centroid_X1 = centroid_Y1 = centroid_Z1 = centroid_X2 = centroid_Y2 = centroid_Z2 = 0;
    return centroid;
  }
};
function centroid_centroidPoint(x, y) {
  centroid_X0 += x;
  centroid_Y0 += y;
  ++centroid_Z0;
}
function centroid_centroidLineStart() {
  centroid_centroidStream.point = centroidPointFirstLine;
}
function centroidPointFirstLine(x, y) {
  centroid_centroidStream.point = centroidPointLine;
  centroid_centroidPoint(centroid_x0 = x, centroid_y0 = y);
}
function centroidPointLine(x, y) {
  var dx = x - centroid_x0,
    dy = y - centroid_y0,
    z = math_sqrt(dx * dx + dy * dy);
  centroid_X1 += z * (centroid_x0 + x) / 2;
  centroid_Y1 += z * (centroid_y0 + y) / 2;
  centroid_Z1 += z;
  centroid_centroidPoint(centroid_x0 = x, centroid_y0 = y);
}
function centroid_centroidLineEnd() {
  centroid_centroidStream.point = centroid_centroidPoint;
}
function centroid_centroidRingStart() {
  centroid_centroidStream.point = centroidPointFirstRing;
}
function centroid_centroidRingEnd() {
  centroidPointRing(centroid_x00, centroid_y00);
}
function centroidPointFirstRing(x, y) {
  centroid_centroidStream.point = centroidPointRing;
  centroid_centroidPoint(centroid_x00 = centroid_x0 = x, centroid_y00 = centroid_y0 = y);
}
function centroidPointRing(x, y) {
  var dx = x - centroid_x0,
    dy = y - centroid_y0,
    z = math_sqrt(dx * dx + dy * dy);
  centroid_X1 += z * (centroid_x0 + x) / 2;
  centroid_Y1 += z * (centroid_y0 + y) / 2;
  centroid_Z1 += z;
  z = centroid_y0 * x - centroid_x0 * y;
  centroid_X2 += z * (centroid_x0 + x);
  centroid_Y2 += z * (centroid_y0 + y);
  centroid_Z2 += z * 3;
  centroid_centroidPoint(centroid_x0 = x, centroid_y0 = y);
}
/* harmony default export */ const path_centroid = ((/* unused pure expression or super */ null && (centroid_centroidStream)));
;// ./node_modules/d3-geo/src/path/context.js


function context_PathContext(context) {
  this._context = context;
}
context_PathContext.prototype = {
  _radius: 4.5,
  pointRadius: function (_) {
    return this._radius = _, this;
  },
  polygonStart: function () {
    this._line = 0;
  },
  polygonEnd: function () {
    this._line = NaN;
  },
  lineStart: function () {
    this._point = 0;
  },
  lineEnd: function () {
    if (this._line === 0) this._context.closePath();
    this._point = NaN;
  },
  point: function (x, y) {
    switch (this._point) {
      case 0:
        {
          this._context.moveTo(x, y);
          this._point = 1;
          break;
        }
      case 1:
        {
          this._context.lineTo(x, y);
          break;
        }
      default:
        {
          this._context.moveTo(x + this._radius, y);
          this._context.arc(x, y, this._radius, 0, math_tau);
          break;
        }
    }
  },
  result: noop
};
;// ./node_modules/d3-geo/src/path/measure.js



var measure_lengthSum = adder(),
  lengthRing,
  measure_x00,
  measure_y00,
  measure_x0,
  measure_y0;
var measure_lengthStream = {
  point: noop,
  lineStart: function () {
    measure_lengthStream.point = measure_lengthPointFirst;
  },
  lineEnd: function () {
    if (lengthRing) measure_lengthPoint(measure_x00, measure_y00);
    measure_lengthStream.point = noop;
  },
  polygonStart: function () {
    lengthRing = true;
  },
  polygonEnd: function () {
    lengthRing = null;
  },
  result: function () {
    var length = +measure_lengthSum;
    measure_lengthSum.reset();
    return length;
  }
};
function measure_lengthPointFirst(x, y) {
  measure_lengthStream.point = measure_lengthPoint;
  measure_x00 = measure_x0 = x, measure_y00 = measure_y0 = y;
}
function measure_lengthPoint(x, y) {
  measure_x0 -= x, measure_y0 -= y;
  measure_lengthSum.add(math_sqrt(measure_x0 * measure_x0 + measure_y0 * measure_y0));
  measure_x0 = x, measure_y0 = y;
}
/* harmony default export */ const measure = ((/* unused pure expression or super */ null && (measure_lengthStream)));
;// ./node_modules/d3-geo/src/path/string.js
function string_PathString() {
  this._string = [];
}
string_PathString.prototype = {
  _radius: 4.5,
  _circle: string_circle(4.5),
  pointRadius: function (_) {
    if ((_ = +_) !== this._radius) this._radius = _, this._circle = null;
    return this;
  },
  polygonStart: function () {
    this._line = 0;
  },
  polygonEnd: function () {
    this._line = NaN;
  },
  lineStart: function () {
    this._point = 0;
  },
  lineEnd: function () {
    if (this._line === 0) this._string.push("Z");
    this._point = NaN;
  },
  point: function (x, y) {
    switch (this._point) {
      case 0:
        {
          this._string.push("M", x, ",", y);
          this._point = 1;
          break;
        }
      case 1:
        {
          this._string.push("L", x, ",", y);
          break;
        }
      default:
        {
          if (this._circle == null) this._circle = string_circle(this._radius);
          this._string.push("M", x, ",", y, this._circle);
          break;
        }
    }
  },
  result: function () {
    if (this._string.length) {
      var result = this._string.join("");
      this._string = [];
      return result;
    } else {
      return null;
    }
  }
};
function string_circle(radius) {
  return "m0," + radius + "a" + radius + "," + radius + " 0 1,1 0," + -2 * radius + "a" + radius + "," + radius + " 0 1,1 0," + 2 * radius + "z";
}
;// ./node_modules/d3-geo/src/path/index.js








/* harmony default export */ function path(projection, context) {
  var pointRadius = 4.5,
    projectionStream,
    contextStream;
  function path(object) {
    if (object) {
      if (typeof pointRadius === "function") contextStream.pointRadius(+pointRadius.apply(this, arguments));
      stream(object, projectionStream(contextStream));
    }
    return contextStream.result();
  }
  path.area = function (object) {
    stream(object, projectionStream(pathArea));
    return pathArea.result();
  };
  path.measure = function (object) {
    stream(object, projectionStream(pathMeasure));
    return pathMeasure.result();
  };
  path.bounds = function (object) {
    stream(object, projectionStream(pathBounds));
    return pathBounds.result();
  };
  path.centroid = function (object) {
    stream(object, projectionStream(pathCentroid));
    return pathCentroid.result();
  };
  path.projection = function (_) {
    return arguments.length ? (projectionStream = _ == null ? (projection = null, identity) : (projection = _).stream, path) : projection;
  };
  path.context = function (_) {
    if (!arguments.length) return context;
    contextStream = _ == null ? (context = null, new PathString()) : new PathContext(context = _);
    if (typeof pointRadius !== "function") contextStream.pointRadius(pointRadius);
    return path;
  };
  path.pointRadius = function (_) {
    if (!arguments.length) return pointRadius;
    pointRadius = typeof _ === "function" ? _ : (contextStream.pointRadius(+_), +_);
    return path;
  };
  return path.projection(projection).context(context);
}
;// ./node_modules/d3-geo/src/clip/index.js





/* harmony default export */ function clip(pointVisible, clipLine, interpolate, start) {
  return function (rotate, sink) {
    var line = clipLine(sink),
      rotatedStart = rotate.invert(start[0], start[1]),
      ringBuffer = buffer(),
      ringSink = clipLine(ringBuffer),
      polygonStarted = false,
      polygon,
      segments,
      ring;
    var clip = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: function () {
        clip.point = pointRing;
        clip.lineStart = ringStart;
        clip.lineEnd = ringEnd;
        segments = [];
        polygon = [];
      },
      polygonEnd: function () {
        clip.point = point;
        clip.lineStart = lineStart;
        clip.lineEnd = lineEnd;
        segments = merge(segments);
        var startInside = polygonContains(polygon, rotatedStart);
        if (segments.length) {
          if (!polygonStarted) sink.polygonStart(), polygonStarted = true;
          clip_polygon(segments, compareIntersection, startInside, interpolate, sink);
        } else if (startInside) {
          if (!polygonStarted) sink.polygonStart(), polygonStarted = true;
          sink.lineStart();
          interpolate(null, null, 1, sink);
          sink.lineEnd();
        }
        if (polygonStarted) sink.polygonEnd(), polygonStarted = false;
        segments = polygon = null;
      },
      sphere: function () {
        sink.polygonStart();
        sink.lineStart();
        interpolate(null, null, 1, sink);
        sink.lineEnd();
        sink.polygonEnd();
      }
    };
    function point(lambda, phi) {
      var point = rotate(lambda, phi);
      if (pointVisible(lambda = point[0], phi = point[1])) sink.point(lambda, phi);
    }
    function pointLine(lambda, phi) {
      var point = rotate(lambda, phi);
      line.point(point[0], point[1]);
    }
    function lineStart() {
      clip.point = pointLine;
      line.lineStart();
    }
    function lineEnd() {
      clip.point = point;
      line.lineEnd();
    }
    function pointRing(lambda, phi) {
      ring.push([lambda, phi]);
      var point = rotate(lambda, phi);
      ringSink.point(point[0], point[1]);
    }
    function ringStart() {
      ringSink.lineStart();
      ring = [];
    }
    function ringEnd() {
      pointRing(ring[0][0], ring[0][1]);
      ringSink.lineEnd();
      var clean = ringSink.clean(),
        ringSegments = ringBuffer.result(),
        i,
        n = ringSegments.length,
        m,
        segment,
        point;
      ring.pop();
      polygon.push(ring);
      ring = null;
      if (!n) return;

      // No intersections.
      if (clean & 1) {
        segment = ringSegments[0];
        if ((m = segment.length - 1) > 0) {
          if (!polygonStarted) sink.polygonStart(), polygonStarted = true;
          sink.lineStart();
          for (i = 0; i < m; ++i) sink.point((point = segment[i])[0], point[1]);
          sink.lineEnd();
        }
        return;
      }

      // Rejoin connected segments.
      // TODO reuse ringBuffer.rejoin()?
      if (n > 1 && clean & 2) ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));
      segments.push(ringSegments.filter(validSegment));
    }
    return clip;
  };
}
function validSegment(segment) {
  return segment.length > 1;
}

// Intersections are sorted along the clip edge. For both antimeridian cutting
// and circle clipping, the same comparison is used.
function compareIntersection(a, b) {
  return ((a = a.x)[0] < 0 ? a[1] - math_halfPi - math_epsilon : math_halfPi - a[1]) - ((b = b.x)[0] < 0 ? b[1] - math_halfPi - math_epsilon : math_halfPi - b[1]);
}
;// ./node_modules/d3-geo/src/clip/antimeridian.js


/* harmony default export */ const antimeridian = (clip(function () {
  return true;
}, clipAntimeridianLine, clipAntimeridianInterpolate, [-math_pi, -math_halfPi]));

// Takes a line and cuts into visible segments. Return values: 0 - there were
// intersections or the line was empty; 1 - no intersections; 2 - there were
// intersections, and the first and last segments should be rejoined.
function clipAntimeridianLine(stream) {
  var lambda0 = NaN,
    phi0 = NaN,
    sign0 = NaN,
    clean; // no intersections

  return {
    lineStart: function () {
      stream.lineStart();
      clean = 1;
    },
    point: function (lambda1, phi1) {
      var sign1 = lambda1 > 0 ? math_pi : -math_pi,
        delta = math_abs(lambda1 - lambda0);
      if (math_abs(delta - math_pi) < math_epsilon) {
        // line crosses a pole
        stream.point(lambda0, phi0 = (phi0 + phi1) / 2 > 0 ? math_halfPi : -math_halfPi);
        stream.point(sign0, phi0);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi0);
        stream.point(lambda1, phi0);
        clean = 0;
      } else if (sign0 !== sign1 && delta >= math_pi) {
        // line crosses antimeridian
        if (math_abs(lambda0 - sign0) < math_epsilon) lambda0 -= sign0 * math_epsilon; // handle degeneracies
        if (math_abs(lambda1 - sign1) < math_epsilon) lambda1 -= sign1 * math_epsilon;
        phi0 = clipAntimeridianIntersect(lambda0, phi0, lambda1, phi1);
        stream.point(sign0, phi0);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi0);
        clean = 0;
      }
      stream.point(lambda0 = lambda1, phi0 = phi1);
      sign0 = sign1;
    },
    lineEnd: function () {
      stream.lineEnd();
      lambda0 = phi0 = NaN;
    },
    clean: function () {
      return 2 - clean; // if intersections, rejoin first and last segments
    }
  };
}
function clipAntimeridianIntersect(lambda0, phi0, lambda1, phi1) {
  var cosPhi0,
    cosPhi1,
    sinLambda0Lambda1 = math_sin(lambda0 - lambda1);
  return math_abs(sinLambda0Lambda1) > math_epsilon ? math_atan((math_sin(phi0) * (cosPhi1 = math_cos(phi1)) * math_sin(lambda1) - math_sin(phi1) * (cosPhi0 = math_cos(phi0)) * math_sin(lambda0)) / (cosPhi0 * cosPhi1 * sinLambda0Lambda1)) : (phi0 + phi1) / 2;
}
function clipAntimeridianInterpolate(from, to, direction, stream) {
  var phi;
  if (from == null) {
    phi = direction * math_halfPi;
    stream.point(-math_pi, phi);
    stream.point(0, phi);
    stream.point(math_pi, phi);
    stream.point(math_pi, 0);
    stream.point(math_pi, -phi);
    stream.point(0, -phi);
    stream.point(-math_pi, -phi);
    stream.point(-math_pi, 0);
    stream.point(-math_pi, phi);
  } else if (math_abs(from[0] - to[0]) > math_epsilon) {
    var lambda = from[0] < to[0] ? math_pi : -math_pi;
    phi = direction * lambda / 2;
    stream.point(-lambda, phi);
    stream.point(0, phi);
    stream.point(lambda, phi);
  } else {
    stream.point(to[0], to[1]);
  }
}
;// ./node_modules/d3-geo/src/clip/circle.js





/* harmony default export */ function clip_circle(radius, delta) {
  var cr = math_cos(radius),
    smallRadius = cr > 0,
    notHemisphere = math_abs(cr) > math_epsilon; // TODO optimise for this common case

  function interpolate(from, to, direction, stream) {
    circleStream(stream, radius, delta, direction, from, to);
  }
  function visible(lambda, phi) {
    return math_cos(lambda) * math_cos(phi) > cr;
  }

  // Takes a line and cuts into visible segments. Return values used for polygon
  // clipping: 0 - there were intersections or the line was empty; 1 - no
  // intersections 2 - there were intersections, and the first and last segments
  // should be rejoined.
  function clipLine(stream) {
    var point0,
      // previous point
      c0,
      // code for previous point
      v0,
      // visibility of previous point
      v00,
      // visibility of first point
      clean; // no intersections
    return {
      lineStart: function () {
        v00 = v0 = false;
        clean = 1;
      },
      point: function (lambda, phi) {
        var point1 = [lambda, phi],
          point2,
          v = visible(lambda, phi),
          c = smallRadius ? v ? 0 : code(lambda, phi) : v ? code(lambda + (lambda < 0 ? math_pi : -math_pi), phi) : 0;
        if (!point0 && (v00 = v0 = v)) stream.lineStart();
        // Handle degeneracies.
        // TODO ignore if not clipping polygons.
        if (v !== v0) {
          point2 = intersect(point0, point1);
          if (!point2 || pointEqual(point0, point2) || pointEqual(point1, point2)) {
            point1[0] += math_epsilon;
            point1[1] += math_epsilon;
            v = visible(point1[0], point1[1]);
          }
        }
        if (v !== v0) {
          clean = 0;
          if (v) {
            // outside going in
            stream.lineStart();
            point2 = intersect(point1, point0);
            stream.point(point2[0], point2[1]);
          } else {
            // inside going out
            point2 = intersect(point0, point1);
            stream.point(point2[0], point2[1]);
            stream.lineEnd();
          }
          point0 = point2;
        } else if (notHemisphere && point0 && smallRadius ^ v) {
          var t;
          // If the codes for two points are different, or are both zero,
          // and there this segment intersects with the small circle.
          if (!(c & c0) && (t = intersect(point1, point0, true))) {
            clean = 0;
            if (smallRadius) {
              stream.lineStart();
              stream.point(t[0][0], t[0][1]);
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
            } else {
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
              stream.lineStart();
              stream.point(t[0][0], t[0][1]);
            }
          }
        }
        if (v && (!point0 || !pointEqual(point0, point1))) {
          stream.point(point1[0], point1[1]);
        }
        point0 = point1, v0 = v, c0 = c;
      },
      lineEnd: function () {
        if (v0) stream.lineEnd();
        point0 = null;
      },
      // Rejoin first and last segments if there were intersections and the first
      // and last points were visible.
      clean: function () {
        return clean | (v00 && v0) << 1;
      }
    };
  }

  // Intersects the great circle between a and b with the clip circle.
  function intersect(a, b, two) {
    var pa = cartesian(a),
      pb = cartesian(b);

    // We have two planes, n1.p = d1 and n2.p = d2.
    // Find intersection line p(t) = c1 n1 + c2 n2 + t (n1 ⨯ n2).
    var n1 = [1, 0, 0],
      // normal
      n2 = cartesianCross(pa, pb),
      n2n2 = cartesianDot(n2, n2),
      n1n2 = n2[0],
      // cartesianDot(n1, n2),
      determinant = n2n2 - n1n2 * n1n2;

    // Two polar points.
    if (!determinant) return !two && a;
    var c1 = cr * n2n2 / determinant,
      c2 = -cr * n1n2 / determinant,
      n1xn2 = cartesianCross(n1, n2),
      A = cartesianScale(n1, c1),
      B = cartesianScale(n2, c2);
    cartesianAddInPlace(A, B);

    // Solve |p(t)|^2 = 1.
    var u = n1xn2,
      w = cartesianDot(A, u),
      uu = cartesianDot(u, u),
      t2 = w * w - uu * (cartesianDot(A, A) - 1);
    if (t2 < 0) return;
    var t = math_sqrt(t2),
      q = cartesianScale(u, (-w - t) / uu);
    cartesianAddInPlace(q, A);
    q = spherical(q);
    if (!two) return q;

    // Two intersection points.
    var lambda0 = a[0],
      lambda1 = b[0],
      phi0 = a[1],
      phi1 = b[1],
      z;
    if (lambda1 < lambda0) z = lambda0, lambda0 = lambda1, lambda1 = z;
    var delta = lambda1 - lambda0,
      polar = math_abs(delta - math_pi) < math_epsilon,
      meridian = polar || delta < math_epsilon;
    if (!polar && phi1 < phi0) z = phi0, phi0 = phi1, phi1 = z;

    // Check that the first point is between a and b.
    if (meridian ? polar ? phi0 + phi1 > 0 ^ q[1] < (math_abs(q[0] - lambda0) < math_epsilon ? phi0 : phi1) : phi0 <= q[1] && q[1] <= phi1 : delta > math_pi ^ (lambda0 <= q[0] && q[0] <= lambda1)) {
      var q1 = cartesianScale(u, (-w + t) / uu);
      cartesianAddInPlace(q1, A);
      return [q, spherical(q1)];
    }
  }

  // Generates a 4-bit vector representing the location of a point relative to
  // the small circle's bounding box.
  function code(lambda, phi) {
    var r = smallRadius ? radius : math_pi - radius,
      code = 0;
    if (lambda < -r) code |= 1; // left
    else if (lambda > r) code |= 2; // right
    if (phi < -r) code |= 4; // below
    else if (phi > r) code |= 8; // above
    return code;
  }
  return clip(visible, clipLine, interpolate, smallRadius ? [0, -radius] : [-math_pi, radius - math_pi]);
}
;// ./node_modules/d3-geo/src/identity.js
/* harmony default export */ function src_identity(x) {
  return x;
}
;// ./node_modules/d3-geo/src/transform.js
/* harmony default export */ function transform(methods) {
  return {
    stream: transform_transformer(methods)
  };
}
function transform_transformer(methods) {
  return function (stream) {
    var s = new TransformStream();
    for (var key in methods) s[key] = methods[key];
    s.stream = stream;
    return s;
  };
}
function TransformStream() {}
TransformStream.prototype = {
  constructor: TransformStream,
  point: function (x, y) {
    this.stream.point(x, y);
  },
  sphere: function () {
    this.stream.sphere();
  },
  lineStart: function () {
    this.stream.lineStart();
  },
  lineEnd: function () {
    this.stream.lineEnd();
  },
  polygonStart: function () {
    this.stream.polygonStart();
  },
  polygonEnd: function () {
    this.stream.polygonEnd();
  }
};
;// ./node_modules/d3-geo/src/projection/fit.js


function fit_fitExtent(projection, extent, object) {
  var w = extent[1][0] - extent[0][0],
    h = extent[1][1] - extent[0][1],
    clip = projection.clipExtent && projection.clipExtent();
  projection.scale(150).translate([0, 0]);
  if (clip != null) projection.clipExtent(null);
  src_stream(object, projection.stream(path_bounds));
  var b = path_bounds.result(),
    k = Math.min(w / (b[1][0] - b[0][0]), h / (b[1][1] - b[0][1])),
    x = +extent[0][0] + (w - k * (b[1][0] + b[0][0])) / 2,
    y = +extent[0][1] + (h - k * (b[1][1] + b[0][1])) / 2;
  if (clip != null) projection.clipExtent(clip);
  return projection.scale(k * 150).translate([x, y]);
}
function fit_fitSize(projection, size, object) {
  return fit_fitExtent(projection, [[0, 0], size], object);
}
;// ./node_modules/d3-geo/src/projection/resample.js



var maxDepth = 16,
  // maximum depth of subdivision
  cosMinDistance = math_cos(30 * math_radians); // cos(minimum angular distance)

/* harmony default export */ function resample(project, delta2) {
  return +delta2 ? resample_resample(project, delta2) : resampleNone(project);
}
function resampleNone(project) {
  return transform_transformer({
    point: function (x, y) {
      x = project(x, y);
      this.stream.point(x[0], x[1]);
    }
  });
}
function resample_resample(project, delta2) {
  function resampleLineTo(x0, y0, lambda0, a0, b0, c0, x1, y1, lambda1, a1, b1, c1, depth, stream) {
    var dx = x1 - x0,
      dy = y1 - y0,
      d2 = dx * dx + dy * dy;
    if (d2 > 4 * delta2 && depth--) {
      var a = a0 + a1,
        b = b0 + b1,
        c = c0 + c1,
        m = math_sqrt(a * a + b * b + c * c),
        phi2 = math_asin(c /= m),
        lambda2 = math_abs(math_abs(c) - 1) < math_epsilon || math_abs(lambda0 - lambda1) < math_epsilon ? (lambda0 + lambda1) / 2 : math_atan2(b, a),
        p = project(lambda2, phi2),
        x2 = p[0],
        y2 = p[1],
        dx2 = x2 - x0,
        dy2 = y2 - y0,
        dz = dy * dx2 - dx * dy2;
      if (dz * dz / d2 > delta2 // perpendicular projected distance
      || math_abs((dx * dx2 + dy * dy2) / d2 - 0.5) > 0.3 // midpoint close to an end
      || a0 * a1 + b0 * b1 + c0 * c1 < cosMinDistance) {
        // angular distance
        resampleLineTo(x0, y0, lambda0, a0, b0, c0, x2, y2, lambda2, a /= m, b /= m, c, depth, stream);
        stream.point(x2, y2);
        resampleLineTo(x2, y2, lambda2, a, b, c, x1, y1, lambda1, a1, b1, c1, depth, stream);
      }
    }
  }
  return function (stream) {
    var lambda00, x00, y00, a00, b00, c00,
      // first point
      lambda0, x0, y0, a0, b0, c0; // previous point

    var resampleStream = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: function () {
        stream.polygonStart();
        resampleStream.lineStart = ringStart;
      },
      polygonEnd: function () {
        stream.polygonEnd();
        resampleStream.lineStart = lineStart;
      }
    };
    function point(x, y) {
      x = project(x, y);
      stream.point(x[0], x[1]);
    }
    function lineStart() {
      x0 = NaN;
      resampleStream.point = linePoint;
      stream.lineStart();
    }
    function linePoint(lambda, phi) {
      var c = cartesian([lambda, phi]),
        p = project(lambda, phi);
      resampleLineTo(x0, y0, lambda0, a0, b0, c0, x0 = p[0], y0 = p[1], lambda0 = lambda, a0 = c[0], b0 = c[1], c0 = c[2], maxDepth, stream);
      stream.point(x0, y0);
    }
    function lineEnd() {
      resampleStream.point = point;
      stream.lineEnd();
    }
    function ringStart() {
      lineStart();
      resampleStream.point = ringPoint;
      resampleStream.lineEnd = ringEnd;
    }
    function ringPoint(lambda, phi) {
      linePoint(lambda00 = lambda, phi), x00 = x0, y00 = y0, a00 = a0, b00 = b0, c00 = c0;
      resampleStream.point = linePoint;
    }
    function ringEnd() {
      resampleLineTo(x0, y0, lambda0, a0, b0, c0, x00, y00, lambda00, a00, b00, c00, maxDepth, stream);
      resampleStream.lineEnd = lineEnd;
      lineEnd();
    }
    return resampleStream;
  };
}
;// ./node_modules/d3-geo/src/projection/index.js










var transformRadians = transform_transformer({
  point: function (x, y) {
    this.stream.point(x * math_radians, y * math_radians);
  }
});
function projection_projection(project) {
  return projection_projectionMutator(function () {
    return project;
  })();
}
function projection_projectionMutator(projectAt) {
  var project,
    k = 150,
    // scale
    x = 480,
    y = 250,
    // translate
    dx,
    dy,
    lambda = 0,
    phi = 0,
    // center
    deltaLambda = 0,
    deltaPhi = 0,
    deltaGamma = 0,
    rotate,
    projectRotate,
    // rotate
    theta = null,
    preclip = antimeridian,
    // clip angle
    x0 = null,
    y0,
    x1,
    y1,
    postclip = src_identity,
    // clip extent
    delta2 = 0.5,
    projectResample = resample(projectTransform, delta2),
    // precision
    cache,
    cacheStream;
  function projection(point) {
    point = projectRotate(point[0] * math_radians, point[1] * math_radians);
    return [point[0] * k + dx, dy - point[1] * k];
  }
  function invert(point) {
    point = projectRotate.invert((point[0] - dx) / k, (dy - point[1]) / k);
    return point && [point[0] * math_degrees, point[1] * math_degrees];
  }
  function projectTransform(x, y) {
    return x = project(x, y), [x[0] * k + dx, dy - x[1] * k];
  }
  projection.stream = function (stream) {
    return cache && cacheStream === stream ? cache : cache = transformRadians(preclip(rotate, projectResample(postclip(cacheStream = stream))));
  };
  projection.clipAngle = function (_) {
    return arguments.length ? (preclip = +_ ? clip_circle(theta = _ * math_radians, 6 * math_radians) : (theta = null, antimeridian), reset()) : theta * math_degrees;
  };
  projection.clipExtent = function (_) {
    return arguments.length ? (postclip = _ == null ? (x0 = y0 = x1 = y1 = null, src_identity) : extent_clipExtent(x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1]), reset()) : x0 == null ? null : [[x0, y0], [x1, y1]];
  };
  projection.scale = function (_) {
    return arguments.length ? (k = +_, recenter()) : k;
  };
  projection.translate = function (_) {
    return arguments.length ? (x = +_[0], y = +_[1], recenter()) : [x, y];
  };
  projection.center = function (_) {
    return arguments.length ? (lambda = _[0] % 360 * math_radians, phi = _[1] % 360 * math_radians, recenter()) : [lambda * math_degrees, phi * math_degrees];
  };
  projection.rotate = function (_) {
    return arguments.length ? (deltaLambda = _[0] % 360 * math_radians, deltaPhi = _[1] % 360 * math_radians, deltaGamma = _.length > 2 ? _[2] % 360 * math_radians : 0, recenter()) : [deltaLambda * math_degrees, deltaPhi * math_degrees, deltaGamma * math_degrees];
  };
  projection.precision = function (_) {
    return arguments.length ? (projectResample = resample(projectTransform, delta2 = _ * _), reset()) : math_sqrt(delta2);
  };
  projection.fitExtent = function (extent, object) {
    return fit_fitExtent(projection, extent, object);
  };
  projection.fitSize = function (size, object) {
    return fit_fitSize(projection, size, object);
  };
  function recenter() {
    projectRotate = compose(rotate = rotation_rotateRadians(deltaLambda, deltaPhi, deltaGamma), project);
    var center = project(lambda, phi);
    dx = x - center[0] * k;
    dy = y + center[1] * k;
    return reset();
  }
  function reset() {
    cache = cacheStream = null;
    return projection;
  }
  return function () {
    project = projectAt.apply(this, arguments);
    projection.invert = project.invert && invert;
    return recenter();
  };
}
;// ./node_modules/d3-geo/src/projection/conic.js


function conic_conicProjection(projectAt) {
  var phi0 = 0,
    phi1 = pi / 3,
    m = projectionMutator(projectAt),
    p = m(phi0, phi1);
  p.parallels = function (_) {
    return arguments.length ? m(phi0 = _[0] * radians, phi1 = _[1] * radians) : [phi0 * degrees, phi1 * degrees];
  };
  return p;
}
;// ./node_modules/d3-geo/src/projection/cylindricalEqualArea.js

function cylindricalEqualArea_cylindricalEqualAreaRaw(phi0) {
  var cosPhi0 = cos(phi0);
  function forward(lambda, phi) {
    return [lambda * cosPhi0, sin(phi) / cosPhi0];
  }
  forward.invert = function (x, y) {
    return [x / cosPhi0, asin(y * cosPhi0)];
  };
  return forward;
}
;// ./node_modules/d3-geo/src/projection/conicEqualArea.js



function conicEqualAreaRaw(y0, y1) {
  var sy0 = sin(y0),
    n = (sy0 + sin(y1)) / 2;

  // Are the parallels symmetrical around the Equator?
  if (abs(n) < epsilon) return cylindricalEqualAreaRaw(y0);
  var c = 1 + sy0 * (2 * n - sy0),
    r0 = sqrt(c) / n;
  function project(x, y) {
    var r = sqrt(c - 2 * n * sin(y)) / n;
    return [r * sin(x *= n), r0 - r * cos(x)];
  }
  project.invert = function (x, y) {
    var r0y = r0 - y;
    return [atan2(x, abs(r0y)) / n * sign(r0y), asin((c - (x * x + r0y * r0y) * n * n) / (2 * n))];
  };
  return project;
}
/* harmony default export */ function projection_conicEqualArea() {
  return conicProjection(conicEqualAreaRaw).scale(155.424).center([0, 33.6442]);
}
;// ./node_modules/d3-geo/src/projection/albers.js

/* harmony default export */ function projection_albers() {
  return conicEqualArea().parallels([29.5, 45.5]).scale(1070).translate([480, 250]).rotate([96, 0]).center([-0.6, 38.7]);
}
;// ./node_modules/d3-geo/src/projection/albersUsa.js





// The projections must have mutually exclusive clip regions on the sphere,
// as this will avoid emitting interleaving lines and polygons.
function multiplex(streams) {
  var n = streams.length;
  return {
    point: function (x, y) {
      var i = -1;
      while (++i < n) streams[i].point(x, y);
    },
    sphere: function () {
      var i = -1;
      while (++i < n) streams[i].sphere();
    },
    lineStart: function () {
      var i = -1;
      while (++i < n) streams[i].lineStart();
    },
    lineEnd: function () {
      var i = -1;
      while (++i < n) streams[i].lineEnd();
    },
    polygonStart: function () {
      var i = -1;
      while (++i < n) streams[i].polygonStart();
    },
    polygonEnd: function () {
      var i = -1;
      while (++i < n) streams[i].polygonEnd();
    }
  };
}

// A composite projection for the United States, configured by default for
// 960×500. The projection also works quite well at 960×600 if you change the
// scale to 1285 and adjust the translate accordingly. The set of standard
// parallels for each region comes from USGS, which is published here:
// http://egsc.usgs.gov/isb/pubs/MapProjections/projections.html#albers
/* harmony default export */ function albersUsa() {
  var cache,
    cacheStream,
    lower48 = albers(),
    lower48Point,
    alaska = conicEqualArea().rotate([154, 0]).center([-2, 58.5]).parallels([55, 65]),
    alaskaPoint,
    // EPSG:3338
    hawaii = conicEqualArea().rotate([157, 0]).center([-3, 19.9]).parallels([8, 18]),
    hawaiiPoint,
    // ESRI:102007
    point,
    pointStream = {
      point: function (x, y) {
        point = [x, y];
      }
    };
  function albersUsa(coordinates) {
    var x = coordinates[0],
      y = coordinates[1];
    return point = null, (lower48Point.point(x, y), point) || (alaskaPoint.point(x, y), point) || (hawaiiPoint.point(x, y), point);
  }
  albersUsa.invert = function (coordinates) {
    var k = lower48.scale(),
      t = lower48.translate(),
      x = (coordinates[0] - t[0]) / k,
      y = (coordinates[1] - t[1]) / k;
    return (y >= 0.120 && y < 0.234 && x >= -0.425 && x < -0.214 ? alaska : y >= 0.166 && y < 0.234 && x >= -0.214 && x < -0.115 ? hawaii : lower48).invert(coordinates);
  };
  albersUsa.stream = function (stream) {
    return cache && cacheStream === stream ? cache : cache = multiplex([lower48.stream(cacheStream = stream), alaska.stream(stream), hawaii.stream(stream)]);
  };
  albersUsa.precision = function (_) {
    if (!arguments.length) return lower48.precision();
    lower48.precision(_), alaska.precision(_), hawaii.precision(_);
    return reset();
  };
  albersUsa.scale = function (_) {
    if (!arguments.length) return lower48.scale();
    lower48.scale(_), alaska.scale(_ * 0.35), hawaii.scale(_);
    return albersUsa.translate(lower48.translate());
  };
  albersUsa.translate = function (_) {
    if (!arguments.length) return lower48.translate();
    var k = lower48.scale(),
      x = +_[0],
      y = +_[1];
    lower48Point = lower48.translate(_).clipExtent([[x - 0.455 * k, y - 0.238 * k], [x + 0.455 * k, y + 0.238 * k]]).stream(pointStream);
    alaskaPoint = alaska.translate([x - 0.307 * k, y + 0.201 * k]).clipExtent([[x - 0.425 * k + epsilon, y + 0.120 * k + epsilon], [x - 0.214 * k - epsilon, y + 0.234 * k - epsilon]]).stream(pointStream);
    hawaiiPoint = hawaii.translate([x - 0.205 * k, y + 0.212 * k]).clipExtent([[x - 0.214 * k + epsilon, y + 0.166 * k + epsilon], [x - 0.115 * k - epsilon, y + 0.234 * k - epsilon]]).stream(pointStream);
    return reset();
  };
  albersUsa.fitExtent = function (extent, object) {
    return fitExtent(albersUsa, extent, object);
  };
  albersUsa.fitSize = function (size, object) {
    return fitSize(albersUsa, size, object);
  };
  function reset() {
    cache = cacheStream = null;
    return albersUsa;
  }
  return albersUsa.scale(1070);
}
;// ./node_modules/d3-geo/src/projection/azimuthal.js

function azimuthalRaw(scale) {
  return function (x, y) {
    var cx = math_cos(x),
      cy = math_cos(y),
      k = scale(cx * cy);
    return [k * cy * math_sin(x), k * math_sin(y)];
  };
}
function azimuthalInvert(angle) {
  return function (x, y) {
    var z = math_sqrt(x * x + y * y),
      c = angle(z),
      sc = math_sin(c),
      cc = math_cos(c);
    return [math_atan2(x * sc, z * cc), math_asin(z && y * sc / z)];
  };
}
;// ./node_modules/d3-geo/src/projection/azimuthalEqualArea.js



var azimuthalEqualAreaRaw = azimuthalRaw(function (cxcy) {
  return math_sqrt(2 / (1 + cxcy));
});
azimuthalEqualAreaRaw.invert = azimuthalInvert(function (z) {
  return 2 * math_asin(z / 2);
});
/* harmony default export */ function azimuthalEqualArea() {
  return projection(azimuthalEqualAreaRaw).scale(124.75).clipAngle(180 - 1e-3);
}
;// ./node_modules/d3-geo/src/projection/azimuthalEquidistant.js



var azimuthalEquidistantRaw = azimuthalRaw(function (c) {
  return (c = acos(c)) && c / math_sin(c);
});
azimuthalEquidistantRaw.invert = azimuthalInvert(function (z) {
  return z;
});
/* harmony default export */ function azimuthalEquidistant() {
  return projection_projection(azimuthalEquidistantRaw).scale(79.4188).clipAngle(180 - 1e-3);
}
;// ./node_modules/d3-geo/src/projection/mercator.js



function mercator_mercatorRaw(lambda, phi) {
  return [lambda, math_log(math_tan((math_halfPi + phi) / 2))];
}
mercator_mercatorRaw.invert = function (x, y) {
  return [x, 2 * math_atan(exp(y)) - math_halfPi];
};
/* harmony default export */ function mercator() {
  return mercator_mercatorProjection(mercator_mercatorRaw).scale(961 / tau);
}
function mercator_mercatorProjection(project) {
  var m = projection(project),
    center = m.center,
    scale = m.scale,
    translate = m.translate,
    clipExtent = m.clipExtent,
    x0 = null,
    y0,
    x1,
    y1; // clip extent

  m.scale = function (_) {
    return arguments.length ? (scale(_), reclip()) : scale();
  };
  m.translate = function (_) {
    return arguments.length ? (translate(_), reclip()) : translate();
  };
  m.center = function (_) {
    return arguments.length ? (center(_), reclip()) : center();
  };
  m.clipExtent = function (_) {
    return arguments.length ? (_ == null ? x0 = y0 = x1 = y1 = null : (x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1]), reclip()) : x0 == null ? null : [[x0, y0], [x1, y1]];
  };
  function reclip() {
    var k = pi * scale(),
      t = m(rotation(m.rotate()).invert([0, 0]));
    return clipExtent(x0 == null ? [[t[0] - k, t[1] - k], [t[0] + k, t[1] + k]] : project === mercator_mercatorRaw ? [[Math.max(t[0] - k, x0), y0], [Math.min(t[0] + k, x1), y1]] : [[x0, Math.max(t[1] - k, y0)], [x1, Math.min(t[1] + k, y1)]]);
  }
  return reclip();
}
;// ./node_modules/d3-geo/src/projection/conicConformal.js



function tany(y) {
  return tan((halfPi + y) / 2);
}
function conicConformalRaw(y0, y1) {
  var cy0 = cos(y0),
    n = y0 === y1 ? sin(y0) : log(cy0 / cos(y1)) / log(tany(y1) / tany(y0)),
    f = cy0 * pow(tany(y0), n) / n;
  if (!n) return mercatorRaw;
  function project(x, y) {
    if (f > 0) {
      if (y < -halfPi + epsilon) y = -halfPi + epsilon;
    } else {
      if (y > halfPi - epsilon) y = halfPi - epsilon;
    }
    var r = f / pow(tany(y), n);
    return [r * sin(n * x), f - r * cos(n * x)];
  }
  project.invert = function (x, y) {
    var fy = f - y,
      r = sign(n) * sqrt(x * x + fy * fy);
    return [atan2(x, abs(fy)) / n * sign(fy), 2 * atan(pow(f / r, 1 / n)) - halfPi];
  };
  return project;
}
/* harmony default export */ function conicConformal() {
  return conicProjection(conicConformalRaw).scale(109.5).parallels([30, 30]);
}
;// ./node_modules/d3-geo/src/projection/equirectangular.js

function equirectangular_equirectangularRaw(lambda, phi) {
  return [lambda, phi];
}
equirectangular_equirectangularRaw.invert = equirectangular_equirectangularRaw;
/* harmony default export */ function equirectangular() {
  return projection(equirectangular_equirectangularRaw).scale(152.63);
}
;// ./node_modules/d3-geo/src/projection/conicEquidistant.js



function conicEquidistantRaw(y0, y1) {
  var cy0 = cos(y0),
    n = y0 === y1 ? sin(y0) : (cy0 - cos(y1)) / (y1 - y0),
    g = cy0 / n + y0;
  if (abs(n) < epsilon) return equirectangularRaw;
  function project(x, y) {
    var gy = g - y,
      nx = n * x;
    return [gy * sin(nx), g - gy * cos(nx)];
  }
  project.invert = function (x, y) {
    var gy = g - y;
    return [atan2(x, abs(gy)) / n * sign(gy), g - sign(n) * sqrt(x * x + gy * gy)];
  };
  return project;
}
/* harmony default export */ function conicEquidistant() {
  return conicProjection(conicEquidistantRaw).scale(131.154).center([0, 13.9389]);
}
;// ./node_modules/d3-geo/src/projection/gnomonic.js



function gnomonicRaw(x, y) {
  var cy = math_cos(y),
    k = math_cos(x) * cy;
  return [cy * math_sin(x) / k, math_sin(y) / k];
}
gnomonicRaw.invert = azimuthalInvert(math_atan);
/* harmony default export */ function gnomonic() {
  return projection(gnomonicRaw).scale(144.049).clipAngle(60);
}
;// ./node_modules/d3-geo/src/projection/identity.js




function scaleTranslate(kx, ky, tx, ty) {
  return kx === 1 && ky === 1 && tx === 0 && ty === 0 ? identity : transformer({
    point: function (x, y) {
      this.stream.point(x * kx + tx, y * ky + ty);
    }
  });
}
/* harmony default export */ function projection_identity() {
  var k = 1,
    tx = 0,
    ty = 0,
    sx = 1,
    sy = 1,
    transform = identity,
    // scale, translate and reflect
    x0 = null,
    y0,
    x1,
    y1,
    clip = identity,
    // clip extent
    cache,
    cacheStream,
    projection;
  function reset() {
    cache = cacheStream = null;
    return projection;
  }
  return projection = {
    stream: function (stream) {
      return cache && cacheStream === stream ? cache : cache = transform(clip(cacheStream = stream));
    },
    clipExtent: function (_) {
      return arguments.length ? (clip = _ == null ? (x0 = y0 = x1 = y1 = null, identity) : clipExtent(x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1]), reset()) : x0 == null ? null : [[x0, y0], [x1, y1]];
    },
    scale: function (_) {
      return arguments.length ? (transform = scaleTranslate((k = +_) * sx, k * sy, tx, ty), reset()) : k;
    },
    translate: function (_) {
      return arguments.length ? (transform = scaleTranslate(k * sx, k * sy, tx = +_[0], ty = +_[1]), reset()) : [tx, ty];
    },
    reflectX: function (_) {
      return arguments.length ? (transform = scaleTranslate(k * (sx = _ ? -1 : 1), k * sy, tx, ty), reset()) : sx < 0;
    },
    reflectY: function (_) {
      return arguments.length ? (transform = scaleTranslate(k * sx, k * (sy = _ ? -1 : 1), tx, ty), reset()) : sy < 0;
    },
    fitExtent: function (extent, object) {
      return fitExtent(projection, extent, object);
    },
    fitSize: function (size, object) {
      return fitSize(projection, size, object);
    }
  };
}
;// ./node_modules/d3-geo/src/projection/naturalEarth1.js


function naturalEarth1Raw(lambda, phi) {
  var phi2 = phi * phi,
    phi4 = phi2 * phi2;
  return [lambda * (0.8707 - 0.131979 * phi2 + phi4 * (-0.013791 + phi4 * (0.003971 * phi2 - 0.001529 * phi4))), phi * (1.007226 + phi2 * (0.015085 + phi4 * (-0.044475 + 0.028874 * phi2 - 0.005916 * phi4)))];
}
naturalEarth1Raw.invert = function (x, y) {
  var phi = y,
    i = 25,
    delta;
  do {
    var phi2 = phi * phi,
      phi4 = phi2 * phi2;
    phi -= delta = (phi * (1.007226 + phi2 * (0.015085 + phi4 * (-0.044475 + 0.028874 * phi2 - 0.005916 * phi4))) - y) / (1.007226 + phi2 * (0.015085 * 3 + phi4 * (-0.044475 * 7 + 0.028874 * 9 * phi2 - 0.005916 * 11 * phi4)));
  } while (math_abs(delta) > math_epsilon && --i > 0);
  return [x / (0.8707 + (phi2 = phi * phi) * (-0.131979 + phi2 * (-0.013791 + phi2 * phi2 * phi2 * (0.003971 - 0.001529 * phi2)))), phi];
};
/* harmony default export */ function naturalEarth1() {
  return projection(naturalEarth1Raw).scale(175.295);
}
;// ./node_modules/d3-geo/src/projection/orthographic.js



function orthographicRaw(x, y) {
  return [math_cos(y) * math_sin(x), math_sin(y)];
}
orthographicRaw.invert = azimuthalInvert(math_asin);
/* harmony default export */ function orthographic() {
  return projection(orthographicRaw).scale(249.5).clipAngle(90 + epsilon);
}
;// ./node_modules/d3-geo/src/projection/stereographic.js



function stereographicRaw(x, y) {
  var cy = math_cos(y),
    k = 1 + math_cos(x) * cy;
  return [cy * math_sin(x) / k, math_sin(y) / k];
}
stereographicRaw.invert = azimuthalInvert(function (z) {
  return 2 * math_atan(z);
});
/* harmony default export */ function stereographic() {
  return projection(stereographicRaw).scale(250).clipAngle(142);
}
;// ./node_modules/d3-geo/src/projection/transverseMercator.js


function transverseMercatorRaw(lambda, phi) {
  return [math_log(math_tan((math_halfPi + phi) / 2)), -lambda];
}
transverseMercatorRaw.invert = function (x, y) {
  return [-y, 2 * math_atan(exp(x)) - math_halfPi];
};
/* harmony default export */ function transverseMercator() {
  var m = mercatorProjection(transverseMercatorRaw),
    center = m.center,
    rotate = m.rotate;
  m.center = function (_) {
    return arguments.length ? center([-_[1], _[0]]) : (_ = center(), [_[1], -_[0]]);
  };
  m.rotate = function (_) {
    return arguments.length ? rotate([_[0], _[1], _.length > 2 ? _[2] + 90 : 90]) : (_ = rotate(), [_[0], _[1], _[2] - 90]);
  };
  return rotate([0, 0, 90]).scale(159.155);
}
;// ./node_modules/d3-geo/index.js




 // DEPRECATED! Use d3.geoIdentity().clipExtent(…).

























;// ./node_modules/@turf/buffer/dist/esm/index.js
// index.js





var {
  BufferOp,
  GeoJSONReader,
  GeoJSONWriter
} = jsts_min;
function esm_buffer(geojson, radius, options) {
  options = options || {};
  var units = options.units || "kilometers";
  var steps = options.steps || 8;
  if (!geojson) throw new Error("geojson is required");
  if (typeof options !== "object") throw new Error("options must be an object");
  if (typeof steps !== "number") throw new Error("steps must be an number");
  if (radius === void 0) throw new Error("radius is required");
  if (steps <= 0) throw new Error("steps must be greater than 0");
  var results = [];
  switch (geojson.type) {
    case "GeometryCollection":
      (0,esm/* geomEach */.kX)(geojson, function (geometry) {
        var buffered = bufferFeature(geometry, radius, units, steps);
        if (buffered) results.push(buffered);
      });
      return (0,dist_esm/* featureCollection */.Lr)(results);
    case "FeatureCollection":
      (0,esm/* featureEach */.us)(geojson, function (feature2) {
        var multiBuffered = bufferFeature(feature2, radius, units, steps);
        if (multiBuffered) {
          (0,esm/* featureEach */.us)(multiBuffered, function (buffered) {
            if (buffered) results.push(buffered);
          });
        }
      });
      return (0,dist_esm/* featureCollection */.Lr)(results);
  }
  return bufferFeature(geojson, radius, units, steps);
}
function bufferFeature(geojson, radius, units, steps) {
  var properties = geojson.properties || {};
  var geometry = geojson.type === "Feature" ? geojson.geometry : geojson;
  if (geometry.type === "GeometryCollection") {
    var results = [];
    (0,esm/* geomEach */.kX)(geojson, function (geometry2) {
      var buffered2 = bufferFeature(geometry2, radius, units, steps);
      if (buffered2) results.push(buffered2);
    });
    return (0,dist_esm/* featureCollection */.Lr)(results);
  }
  var projection = defineProjection(geometry);
  var projected = {
    type: geometry.type,
    coordinates: projectCoords(geometry.coordinates, projection)
  };
  var reader = new GeoJSONReader();
  var geom = reader.read(projected);
  var distance = (0,dist_esm/* radiansToLength */.cJ)((0,dist_esm/* lengthToRadians */.Gf)(radius, units), "meters");
  var buffered = BufferOp.bufferOp(geom, distance, steps);
  var writer = new GeoJSONWriter();
  buffered = writer.write(buffered);
  if (coordsIsNaN(buffered.coordinates)) return void 0;
  var result = {
    type: buffered.type,
    coordinates: unprojectCoords(buffered.coordinates, projection)
  };
  return (0,dist_esm/* feature */.N4)(result, properties);
}
function coordsIsNaN(coords) {
  if (Array.isArray(coords[0])) return coordsIsNaN(coords[0]);
  return isNaN(coords[0]);
}
function projectCoords(coords, proj) {
  if (typeof coords[0] !== "object") return proj(coords);
  return coords.map(function (coord) {
    return projectCoords(coord, proj);
  });
}
function unprojectCoords(coords, proj) {
  if (typeof coords[0] !== "object") return proj.invert(coords);
  return coords.map(function (coord) {
    return unprojectCoords(coord, proj);
  });
}
function defineProjection(geojson) {
  var coords = center(geojson).geometry.coordinates;
  var rotation = [-coords[0], -coords[1]];
  return azimuthalEquidistant().rotate(rotation).scale(dist_esm/* earthRadius */.zX);
}
var dist_esm_index_default = esm_buffer;


/***/ }),

/***/ 1507:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  s3: () => (/* binding */ Keyboard)
});

// UNUSED EXPORTS: KeyboardResize, KeyboardStyle

// EXTERNAL MODULE: ./node_modules/@capacitor/core/dist/index.js
var dist = __webpack_require__(5036);
;// ./node_modules/@capacitor/keyboard/dist/esm/definitions.js
/// <reference types="@capacitor/cli" />
var KeyboardStyle;
(function (KeyboardStyle) {
  /**
   * Dark keyboard.
   *
   * @since 1.0.0
   */
  KeyboardStyle["Dark"] = "DARK";
  /**
   * Light keyboard.
   *
   * @since 1.0.0
   */
  KeyboardStyle["Light"] = "LIGHT";
  /**
   * On iOS 13 and newer the keyboard style is based on the device appearance.
   * If the device is using Dark mode, the keyboard will be dark.
   * If the device is using Light mode, the keyboard will be light.
   * On iOS 12 the keyboard will be light.
   *
   * @since 1.0.0
   */
  KeyboardStyle["Default"] = "DEFAULT";
})(KeyboardStyle || (KeyboardStyle = {}));
var KeyboardResize;
(function (KeyboardResize) {
  /**
   * Only the `body` HTML element will be resized.
   * Relative units are not affected, because the viewport does not change.
   *
   * @since 1.0.0
   */
  KeyboardResize["Body"] = "body";
  /**
   * Only the `ion-app` HTML element will be resized.
   * Use it only for Ionic Framework apps.
   *
   * @since 1.0.0
   */
  KeyboardResize["Ionic"] = "ionic";
  /**
   * The whole native Web View will be resized when the keyboard shows/hides.
   * This affects the `vh` relative unit.
   *
   * @since 1.0.0
   */
  KeyboardResize["Native"] = "native";
  /**
   * Neither the app nor the Web View are resized.
   *
   * @since 1.0.0
   */
  KeyboardResize["None"] = "none";
})(KeyboardResize || (KeyboardResize = {}));
;// ./node_modules/@capacitor/keyboard/dist/esm/index.js

const Keyboard = (0,dist/* registerPlugin */.F3)('Keyboard');



/***/ }),

/***/ 1559:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (/* binding */ GeoJsonToGpx)
/* harmony export */ });
function GeoJsonToGpx(geoJson, options, implementation) {
  if (implementation === void 0) {
    implementation = document.implementation;
  }
  var doc = implementation.createDocument('http://www.topografix.com/GPX/1/1', '');
  var instruct = doc.createProcessingInstruction('xml', 'version="1.0" encoding="UTF-8"');
  doc.appendChild(instruct);
  var defaultPackageName = '@dwayneparton/geojson-to-gpx';
  var creator = (options === null || options === void 0 ? void 0 : options.creator) || defaultPackageName;
  var createElementWithNS = function (tagName) {
    return doc.createElementNS('http://www.topografix.com/GPX/1/1', tagName);
  };
  var gpx = createElementWithNS('gpx');
  gpx.setAttribute('version', '1.1');
  gpx.setAttribute('creator', creator);
  var wpts = [];
  var trks = [];
  function createTagInParentElement(parent, tagName, content) {
    if (content === undefined) {
      return;
    }
    var element = createElementWithNS(tagName);
    var contentEl = doc.createTextNode(String(content));
    element.appendChild(contentEl);
    parent.appendChild(element);
  }
  function addSupportedPropertiesFromObject(el, supports, properties) {
    if (properties && typeof properties === 'object') {
      supports.forEach(function (key) {
        var value = properties[key];
        if (value && typeof value === 'string' && supports.includes(key)) {
          createTagInParentElement(el, key, value);
        }
      });
    }
  }
  function createLinkInParentElement(parent, props) {
    var href = props.href;
    if (!href) {
      return;
    }
    var el = createElementWithNS('link');
    el.setAttribute('href', href);
    addSupportedPropertiesFromObject(el, ['text', 'type'], props);
    parent.appendChild(el);
  }
  function createTrk(properties) {
    var el = createElementWithNS('trk');
    var supports = ['name', 'desc', 'src', 'type'];
    addSupportedPropertiesFromObject(el, supports, properties);
    return el;
  }
  function createPt(type, position, properties) {
    var lon = position[0],
      lat = position[1],
      ele = position[2],
      time = position[3];
    var el = createElementWithNS(type);
    el.setAttribute('lat', String(lat));
    el.setAttribute('lon', String(lon));
    createTagInParentElement(el, 'ele', ele);
    createTagInParentElement(el, 'time', time);
    var supports = ['name', 'desc', 'src', 'type'];
    addSupportedPropertiesFromObject(el, supports, properties);
    return el;
  }
  function createTrkSeg(coordinates) {
    var el = createElementWithNS('trkseg');
    coordinates.forEach(function (point) {
      el.appendChild(createPt('trkpt', point));
    });
    return el;
  }
  function interpretFeature(feature) {
    var geometry = feature.geometry,
      properties = feature.properties;
    var type = geometry.type;
    switch (type) {
      case 'Polygon':
        break;
      case 'Point':
        {
          wpts.push(createPt('wpt', geometry.coordinates, properties));
          break;
        }
      case 'MultiPoint':
        {
          geometry.coordinates.forEach(function (coord) {
            wpts.push(createPt('wpt', coord, properties));
          });
          break;
        }
      case 'LineString':
        {
          var lineTrk = createTrk(properties);
          var trkseg = createTrkSeg(geometry.coordinates);
          lineTrk.appendChild(trkseg);
          trks.push(lineTrk);
          break;
        }
      case 'MultiLineString':
        {
          var trk_1 = createTrk(properties);
          geometry.coordinates.forEach(function (pos) {
            var trkseg = createTrkSeg(pos);
            trk_1.appendChild(trkseg);
          });
          trks.push(trk_1);
          break;
        }
      default:
        break;
    }
  }
  if (options && typeof options.metadata === 'object') {
    var meta = options.metadata;
    var metadata = createElementWithNS('metadata');
    createTagInParentElement(metadata, 'name', meta.name);
    createTagInParentElement(metadata, 'desc', meta.desc);
    if (meta.author && typeof meta.author === 'object') {
      var author = createElementWithNS('author');
      createTagInParentElement(author, 'name', meta.author.name);
      createTagInParentElement(author, 'email', meta.author.email);
      if (meta.author.link && typeof meta.author.link === 'object') {
        createLinkInParentElement(author, meta.author.link);
      }
      metadata.appendChild(author);
    }
    if (typeof meta.copyright === 'object') {
      var copyright = createElementWithNS('copyright');
      if (meta.copyright.author) {
        copyright.setAttribute('author', meta.copyright.author);
      }
      createTagInParentElement(copyright, 'year', meta.copyright.year);
      createTagInParentElement(copyright, 'license', meta.copyright.license);
      metadata.appendChild(copyright);
    }
    if (typeof meta.link === 'object') {
      createLinkInParentElement(metadata, meta.link);
    }
    createTagInParentElement(metadata, 'time', meta.time);
    createTagInParentElement(metadata, 'keywords', meta.keywords);
    gpx.appendChild(metadata);
  }
  var type = geoJson.type;
  switch (type) {
    case 'Feature':
      {
        interpretFeature(geoJson);
        break;
      }
    case 'FeatureCollection':
      {
        var features = geoJson.features;
        features.forEach(function (feature) {
          interpretFeature(feature);
        });
        break;
      }
    default:
      break;
  }
  wpts.forEach(function (wpt) {
    return gpx.appendChild(wpt);
  });
  trks.forEach(function (trk) {
    return gpx.appendChild(trk);
  });
  doc.appendChild(gpx);
  return doc;
}

/***/ }),

/***/ 1659:
/***/ ((module) => {

"use strict";
module.exports = /*#__PURE__*/JSON.parse('{"BTH":"blé","BTP":"blé","MID":"&#127805; maïs","MIE":"&#127805; maïs","MIS":"&#127805; maïs","ORH":"orge","ORP":"orge","AVH":"avoine","AVP":"avoine","BDH":"&#127806; blé","BDP":"&#127806; blé","BDT":"&#127806; blé","CAG":"&#127806; céréales","CAH":"&#127806; céréales","CGF":"&#127806; céréales","CGH":"&#127806; céréales","CGO":"&#127806; céréales","CGP":"&#127806; céréales","CGS":"&#127806; céréales","CHA":"&#127806; céréales","CHH":"&#127806; céréales","CHS":"&#127806; céréales","CHT":"&#127806; céréales","CPA":"&#127806; céréales","CPH":"&#127806; céréales","CPS":"&#127806; céréales","CPT":"&#127806; céréales","CPZ":"&#127806; céréales","EPE":"épeautre","MCR":"&#127806; céréales","MCS":"&#127806; céréales","MLT":"millet","SGH":"seigle","SGP":"seigle","SOG":"sorgho","SRS":"sarrasin","TTH":"triticale","TTP":"triticale","CZH":"colza","CZP":"colza","TRN":"&#127803; tournesol","ARA":"&#x1F95C; arachide","LIH":"lin","LIP":"lin","MOL":"oléagineux","NVE":"navette","NVH":"navette","OAG":"oléagineux","OEH":"oléagineux","OEI":"oeillette","OHN":"oléagineux","OHR":"oléagineux","OPN":"oléagineux","OPR":"oléagineux","SOJ":"soja","FEV":"fève","FVL":"féverole","FVP":"féverole","FVT":"féverole","LDH":"lupin","LDP":"lupin","LDT":"lupin","MPC":"protéagineux","MPP":"protéagineux","MPT":"protéagineux","PAG":"légumineuses","PHF":"&#129755; pois et haricots frais","PHI":"&#129755; pois protéagineux","PHS":"&#129755; pois et haricots secs","PPR":"&#129755; pois protéagineux","PPT":"&#129755; pois","CHV":"chanvre","CSE":"chanvre","LIF":"lin","RIZ":"riz","LEC":"lentilles","PCH":"pois chiches","AFG":"plantes fourragères","BVF":"betteraves","CAF":"&#x1F955; carottes","CHF":"&#x1F96C; chou","DTY":"dactyle","FAG":"plantes fourragères","FET":"fétuque","FF5":"féverole","FF6":"féverole","FF7":"féverole","FF8":"féverole","FFO":"féverole","FLO":"fléole","FSG":"plantes fourragères","GAI":"gaillet","GES":"plantes fourragères","GFP":"plantes fourragères","JO5":"jarosse","JO6":"jarosse","JO7":"jarosse","JO8":"jarosse","JOD":"jarosse","JOS":"jarosse","LEF":"lentilles","LFH":"lupin","LFP":"lupin","LH5":"lupin","LH6":"lupin","LH7":"lupin","LH8":"lupin","LO7":"lotier","LO8":"lotier","LOT":"lotier","LP5":"lupin","LP6":"lupin","LP7":"lupin","LP8":"lupin","LU5":"luzerne","LU6":"luzerne","LU7":"luzerne","LU8":"luzerne","LUD":"luzerne","LUZ":"luzerne","MC5":"légumineuses fourragères","MC6":"légumineuses fourragères","MC7":"légumineuses fourragères","MC8":"légumineuses fourragères","ME5":"mélilot","ME6":"mélilot","ME7":"mélilot","ME8":"mélilot","MED":"mélilot","MEL":"mélilot","MH5":"légumineuses fourragères","MH6":"légumineuses fourragères","MH7":"légumineuses fourragères","MI7":"minette","MI8":"minette","MIN":"minette","ML5":"légumineuses fourragères","ML6":"légumineuses fourragères","ML7":"légumineuses fourragères","ML8":"légumineuses fourragères","MLC":"légumineuses fourragères","MLD":"légumineuses fourragères","MLF":"légumineuses fourragères","MLG":"légumineuses fourragères","MOH":"moha","NVF":"navets","PAT":"pâturin","PFH":"&#129755; pois","PFP":"&#129755; pois","PH5":"&#129755; pois","PH6":"&#129755; pois","PH7":"&#129755; pois","PH8":"&#129755; pois","PP5":"&#129755; pois","PP6":"&#129755; pois","PP7":"&#129755; pois","PP8":"&#129755; pois","RDF":"radis","SA5":"sainfoin","SA6":"sainfoin","SA7":"sainfoin","SA8":"sainfoin","SAD":"sainfoin","SAI":"sainfoin","SE5":"serradelle","SE6":"serradelle","SE7":"serradelle","SE8":"serradelle","SED":"serradelle","SER":"serradelle","TR5":"&#9752;&#65039; trèfle","TR6":"&#9752;&#65039; trèfle","TR7":"&#9752;&#65039; trèfle","TR8":"&#9752;&#65039; trèfle","TRD":"&#9752;&#65039; trèfle","TRE":"&#9752;&#65039; trèfle","VE5":"vesce","VE6":"vesce","VE7":"vesce","VE8":"vesce","VED":"vesce","VES":"vesce","XFE":"x-felium","AGR":"&#127818; &#127819; agrumes","ANA":"&#127821; ananas","AVO":"&#x1F951; avocats","BCA":"&#127820; bananes","BCF":"&#127820; bananes","BCI":"&#127820; bananes","BCP":"&#127820; bananes","BCR":"&#127820; bananes","BEA":"&#127820; bananes","BEF":"&#127820; bananes","BEI":"&#127820; bananes","BEP":"&#127820; bananes","BER":"&#127820; bananes","CAC":"café et cacao","CBT":"&#127826; cerises","PFR":"&#x1FAD0; fruits à baie","PRU":"prunes","PVT":"&#127825; pêches","PWT":"&#127824; poires","VRC":"&#127815; vignes","VRN":"&#127815; vignes","VRT":"&#127815; vignes","CAB":"caroube","CTG":"&#127792; châtaignes ","NOS":"noisettes","NOX":"noix","PIS":"pistaches","OLI":"&#x1FAD2; olives","ANE":"aneth","ANG":"angélique","ANI":"anis","AAR":"&#127807; plantes aromatiques ","ARP":"&#127807; plantes aromatiques ","BAR":"bardane","BAS":"&#127793; basilic ","BRH":"bourrache","BTN":"betteraves","CAV":"carvi","CHR":"chardon marie","CIB":"ciboulette","CML":"cameline","CMM":"camomille","CRD":"coriandre","CRF":"cerfeuil","CUM":"cumin","CUR":"curcuma","EST":"estragon","FNO":"fenouil","FNU":"fenugrec","HBL":"houblon","LAV":"lavande et lavandin","MAV":"mauve","MLI":"mélisse","MLP":"millepertuis","MOT":"moutarde","MRJ":"marjolaine / origan","MTH":"menthe","ORT":"ortie","OSE":"oseille","PAR":"&#127807; plantes aromatiques","PMD":"&#127807; plantes médicinales","PME":"plantes à parfum","PPA":"plantes à parfum","PPF":"plantes à parfum","PPP":"plantes médicinales","PRF":"plantes à parfum","PSL":"persil","PSN":"psyllium noir","PSY":"plantain psyllium","ROM":"romarin","SGE":"sauge","SRI":"sarriette","TAB":"tabac","THY":"thym","TOT":"&#127813; tomates","VAL":"valériane","VNB":"vanille sous bois","VNL":"vanille","VNV":"vanille","YLA":"ylang-ylang","AIL":"&#x1F9C4; aïl","ART":"artichauts","AUB":"&#127814; aubergines","BLT":"bleuets","BUR":"bugle rampante","CAR":"&#x1F955; carottes","CCN":"&#x1F952; concombres, cornichons, courgettes","CCT":"courgettes, &#x1F383; citrouilles","CEL":"céleris","CES":"chicorées, endives, scaroles","CHU":"&#x1F96C; choux","CMB":"courges musquées, butternuts","CRA":"cresson","CRN":"cornille","CRS":"cresson","DOL":"dolique","EPI":"épinards, oseille et bettes","FRA":"&#127827; fraises","GER":"géranium","HAR":"&#x1FAD8; haricots, flageolets","HPC":"&#x1F337; horticulture ornementale","HSA":"&#x1F337; horticulture ornementale","LBF":"salades","MAC":"mâche","MLO":"&#127816; melons, &#127817; pastèques","MRG":"marguerites","NVT":"légumes racines","OIG":"oignons, échalottes","PAN":"panais","PAQ":"pâquerettes","PAS":"pastèques","PMV":"primevères","POR":"poireaux","POT":"courges","PPO":"&#129755; petits pois","PSE":"pensées","PTC":"&#127840; pommes de terre","PTF":"&#127840; pommes de terre","PVP":"&#x1FAD1; poivrons,&#127798; piments,&#127814; aubergines","RDI":"&#x1FADC; radis","ROQ":"&#x1F96C; roquette","RUT":"&#x1FADC; rutabagas","SFI":"salsifis","TOM":"&#127813; tomates","TOP":"&#x1FADC; topinambours","VER":"véronique","CSA":"cannes à sucre","CSF":"cannes à sucre","CSI":"cannes à sucre","CSP":"cannes à sucre","CSR":"cannes à sucre","MCT":"miscanthus","NYG":"nyger","PCL":"phacélie","ROS":"rosalière","SAG":"rosalière","TBT":"tubercules tropicales","VET":"vétivier","MLS":"mélange de légumineuses"}');

/***/ }),

/***/ 1666:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "css/assets/3df987e6545e462f0207.png";

/***/ }),

/***/ 1711:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   H: () => (/* binding */ Host),
/* harmony export */   b: () => (/* binding */ bootstrapLazy),
/* harmony export */   c: () => (/* binding */ createEvent),
/* harmony export */   f: () => (/* binding */ forceUpdate),
/* harmony export */   g: () => (/* binding */ getElement),
/* harmony export */   h: () => (/* binding */ h),
/* harmony export */   p: () => (/* binding */ promiseResolve),
/* harmony export */   r: () => (/* binding */ registerInstance),
/* harmony export */   s: () => (/* binding */ setNonce)
/* harmony export */ });
var __extends = undefined && undefined.__extends || function () {
  var e = function (t, n) {
    e = Object.setPrototypeOf || {
      __proto__: []
    } instanceof Array && function (e, t) {
      e.__proto__ = t;
    } || function (e, t) {
      for (var n in t) if (Object.prototype.hasOwnProperty.call(t, n)) e[n] = t[n];
    };
    return e(t, n);
  };
  return function (t, n) {
    if (typeof n !== "function" && n !== null) throw new TypeError("Class extends value " + String(n) + " is not a constructor or null");
    e(t, n);
    function r() {
      this.constructor = t;
    }
    t.prototype = n === null ? Object.create(n) : (r.prototype = n.prototype, new r());
  };
}();
var __awaiter = undefined && undefined.__awaiter || function (e, t, n, r) {
  function a(e) {
    return e instanceof n ? e : new n(function (t) {
      t(e);
    });
  }
  return new (n || (n = Promise))(function (n, o) {
    function s(e) {
      try {
        l(r.next(e));
      } catch (e) {
        o(e);
      }
    }
    function i(e) {
      try {
        l(r["throw"](e));
      } catch (e) {
        o(e);
      }
    }
    function l(e) {
      e.done ? n(e.value) : a(e.value).then(s, i);
    }
    l((r = r.apply(e, t || [])).next());
  });
};
var __generator = undefined && undefined.__generator || function (e, t) {
  var n = {
      label: 0,
      sent: function () {
        if (o[0] & 1) throw o[1];
        return o[1];
      },
      trys: [],
      ops: []
    },
    r,
    a,
    o,
    s;
  return s = {
    next: i(0),
    throw: i(1),
    return: i(2)
  }, typeof Symbol === "function" && (s[Symbol.iterator] = function () {
    return this;
  }), s;
  function i(e) {
    return function (t) {
      return l([e, t]);
    };
  }
  function l(i) {
    if (r) throw new TypeError("Generator is already executing.");
    while (s && (s = 0, i[0] && (n = 0)), n) try {
      if (r = 1, a && (o = i[0] & 2 ? a["return"] : i[0] ? a["throw"] || ((o = a["return"]) && o.call(a), 0) : a.next) && !(o = o.call(a, i[1])).done) return o;
      if (a = 0, o) i = [i[0] & 2, o.value];
      switch (i[0]) {
        case 0:
        case 1:
          o = i;
          break;
        case 4:
          n.label++;
          return {
            value: i[1],
            done: false
          };
        case 5:
          n.label++;
          a = i[1];
          i = [0];
          continue;
        case 7:
          i = n.ops.pop();
          n.trys.pop();
          continue;
        default:
          if (!(o = n.trys, o = o.length > 0 && o[o.length - 1]) && (i[0] === 6 || i[0] === 2)) {
            n = 0;
            continue;
          }
          if (i[0] === 3 && (!o || i[1] > o[0] && i[1] < o[3])) {
            n.label = i[1];
            break;
          }
          if (i[0] === 6 && n.label < o[1]) {
            n.label = o[1];
            o = i;
            break;
          }
          if (o && n.label < o[2]) {
            n.label = o[2];
            n.ops.push(i);
            break;
          }
          if (o[2]) n.ops.pop();
          n.trys.pop();
          continue;
      }
      i = t.call(e, n);
    } catch (e) {
      i = [6, e];
      a = 0;
    } finally {
      r = o = 0;
    }
    if (i[0] & 5) throw i[1];
    return {
      value: i[0] ? i[1] : void 0,
      done: true
    };
  }
};
var __spreadArray = undefined && undefined.__spreadArray || function (e, t, n) {
  if (n || arguments.length === 2) for (var r = 0, a = t.length, o; r < a; r++) {
    if (o || !(r in t)) {
      if (!o) o = Array.prototype.slice.call(t, 0, r);
      o[r] = t[r];
    }
  }
  return e.concat(o || Array.prototype.slice.call(t));
};
var NAMESPACE = "ionicpwaelements";
var scopeId;
var hostTagName;
var isSvgMode = false;
var queuePending = false;
var createTime = function (e, t) {
  if (t === void 0) {
    t = "";
  }
  {
    return function () {
      return;
    };
  }
};
var uniqueTime = function (e, t) {
  {
    return function () {
      return;
    };
  }
};
var HYDRATED_CSS = "{visibility:hidden}.hydrated{visibility:inherit}";
var EMPTY_OBJ = {};
var SVG_NS = "http://www.w3.org/2000/svg";
var HTML_NS = "http://www.w3.org/1999/xhtml";
var isDef = function (e) {
  return e != null;
};
var isComplexType = function (e) {
  e = typeof e;
  return e === "object" || e === "function";
};
function queryNonceMetaTagContent(e) {
  var t, n, r;
  return (r = (n = (t = e.head) === null || t === void 0 ? void 0 : t.querySelector('meta[name="csp-nonce"]')) === null || n === void 0 ? void 0 : n.getAttribute("content")) !== null && r !== void 0 ? r : undefined;
}
var h = function (e, t) {
  var n = [];
  for (var r = 2; r < arguments.length; r++) {
    n[r - 2] = arguments[r];
  }
  var a = null;
  var o = false;
  var s = false;
  var i = [];
  var l = function (t) {
    for (var n = 0; n < t.length; n++) {
      a = t[n];
      if (Array.isArray(a)) {
        l(a);
      } else if (a != null && typeof a !== "boolean") {
        if (o = typeof e !== "function" && !isComplexType(a)) {
          a = String(a);
        }
        if (o && s) {
          i[i.length - 1].$text$ += a;
        } else {
          i.push(o ? newVNode(null, a) : a);
        }
        s = o;
      }
    }
  };
  l(n);
  if (t) {
    {
      var u = t.className || t.class;
      if (u) {
        t.class = typeof u !== "object" ? u : Object.keys(u).filter(function (e) {
          return u[e];
        }).join(" ");
      }
    }
  }
  var c = newVNode(e, null);
  c.$attrs$ = t;
  if (i.length > 0) {
    c.$children$ = i;
  }
  return c;
};
var newVNode = function (e, t) {
  var n = {
    $flags$: 0,
    $tag$: e,
    $text$: t,
    $elm$: null,
    $children$: null
  };
  {
    n.$attrs$ = null;
  }
  return n;
};
var Host = {};
var isHost = function (e) {
  return e && e.$tag$ === Host;
};
var parsePropertyValue = function (e, t) {
  if (e != null && !isComplexType(e)) {
    if (t & 4) {
      return e === "false" ? false : e === "" || !!e;
    }
    if (t & 2) {
      return parseFloat(e);
    }
    if (t & 1) {
      return String(e);
    }
    return e;
  }
  return e;
};
var getElement = function (e) {
  return getHostRef(e).$hostElement$;
};
var createEvent = function (e, t, n) {
  var r = getElement(e);
  return {
    emit: function (e) {
      return emitEvent(r, t, {
        bubbles: !!(n & 4),
        composed: !!(n & 2),
        cancelable: !!(n & 1),
        detail: e
      });
    }
  };
};
var emitEvent = function (e, t, n) {
  var r = plt.ce(t, n);
  e.dispatchEvent(r);
  return r;
};
var rootAppliedStyles = new WeakMap();
var registerStyle = function (e, t, n) {
  var r = styles.get(e);
  if (supportsConstructableStylesheets && n) {
    r = r || new CSSStyleSheet();
    if (typeof r === "string") {
      r = t;
    } else {
      r.replaceSync(t);
    }
  } else {
    r = t;
  }
  styles.set(e, r);
};
var addStyle = function (e, t, n, r) {
  var a;
  var o = getScopeId(t);
  var s = styles.get(o);
  e = e.nodeType === 11 ? e : doc;
  if (s) {
    if (typeof s === "string") {
      e = e.head || e;
      var i = rootAppliedStyles.get(e);
      var l = void 0;
      if (!i) {
        rootAppliedStyles.set(e, i = new Set());
      }
      if (!i.has(o)) {
        {
          {
            l = doc.createElement("style");
            l.innerHTML = s;
          }
          var u = (a = plt.$nonce$) !== null && a !== void 0 ? a : queryNonceMetaTagContent(doc);
          if (u != null) {
            l.setAttribute("nonce", u);
          }
          e.insertBefore(l, e.querySelector("link"));
        }
        if (i) {
          i.add(o);
        }
      }
    } else if (!e.adoptedStyleSheets.includes(s)) {
      e.adoptedStyleSheets = __spreadArray(__spreadArray([], e.adoptedStyleSheets, true), [s], false);
    }
  }
  return o;
};
var attachStyles = function (e) {
  var t = e.$cmpMeta$;
  var n = e.$hostElement$;
  var r = t.$flags$;
  var a = createTime("attachStyles", t.$tagName$);
  var o = addStyle(n.shadowRoot ? n.shadowRoot : n.getRootNode(), t);
  if (r & 10) {
    n["s-sc"] = o;
    n.classList.add(o + "-h");
  }
  a();
};
var getScopeId = function (e, t) {
  return "sc-" + e.$tagName$;
};
var setAccessor = function (e, t, n, r, a, o) {
  if (n !== r) {
    var s = isMemberInElement(e, t);
    var i = t.toLowerCase();
    if (t === "class") {
      var l = e.classList;
      var u = parseClassList(n);
      var c = parseClassList(r);
      l.remove.apply(l, u.filter(function (e) {
        return e && !c.includes(e);
      }));
      l.add.apply(l, c.filter(function (e) {
        return e && !u.includes(e);
      }));
    } else if (t === "style") {
      {
        for (var f in n) {
          if (!r || r[f] == null) {
            if (f.includes("-")) {
              e.style.removeProperty(f);
            } else {
              e.style[f] = "";
            }
          }
        }
      }
      for (var f in r) {
        if (!n || r[f] !== n[f]) {
          if (f.includes("-")) {
            e.style.setProperty(f, r[f]);
          } else {
            e.style[f] = r[f];
          }
        }
      }
    } else if (t === "ref") {
      if (r) {
        r(e);
      }
    } else if (!s && t[0] === "o" && t[1] === "n") {
      if (t[2] === "-") {
        t = t.slice(3);
      } else if (isMemberInElement(win, i)) {
        t = i.slice(2);
      } else {
        t = i[2] + t.slice(3);
      }
      if (n) {
        plt.rel(e, t, n, false);
      }
      if (r) {
        plt.ael(e, t, r, false);
      }
    } else {
      var $ = isComplexType(r);
      if ((s || $ && r !== null) && !a) {
        try {
          if (!e.tagName.includes("-")) {
            var d = r == null ? "" : r;
            if (t === "list") {
              s = false;
            } else if (n == null || e[t] != d) {
              e[t] = d;
            }
          } else {
            e[t] = r;
          }
        } catch (e) {}
      }
      if (r == null || r === false) {
        if (r !== false || e.getAttribute(t) === "") {
          {
            e.removeAttribute(t);
          }
        }
      } else if ((!s || o & 4 || a) && !$) {
        r = r === true ? "" : r;
        {
          e.setAttribute(t, r);
        }
      }
    }
  }
};
var parseClassListRegex = /\s/;
var parseClassList = function (e) {
  return !e ? [] : e.split(parseClassListRegex);
};
var updateElement = function (e, t, n, r) {
  var a = t.$elm$.nodeType === 11 && t.$elm$.host ? t.$elm$.host : t.$elm$;
  var o = e && e.$attrs$ || EMPTY_OBJ;
  var s = t.$attrs$ || EMPTY_OBJ;
  {
    for (r in o) {
      if (!(r in s)) {
        setAccessor(a, r, o[r], undefined, n, t.$flags$);
      }
    }
  }
  for (r in s) {
    setAccessor(a, r, o[r], s[r], n, t.$flags$);
  }
};
var createElm = function (e, t, n, r) {
  var a = t.$children$[n];
  var o = 0;
  var s;
  var i;
  if (a.$text$ !== null) {
    s = a.$elm$ = doc.createTextNode(a.$text$);
  } else {
    if (!isSvgMode) {
      isSvgMode = a.$tag$ === "svg";
    }
    s = a.$elm$ = doc.createElementNS(isSvgMode ? SVG_NS : HTML_NS, a.$tag$);
    if (isSvgMode && a.$tag$ === "foreignObject") {
      isSvgMode = false;
    }
    {
      updateElement(null, a, isSvgMode);
    }
    if (isDef(scopeId) && s["s-si"] !== scopeId) {
      s.classList.add(s["s-si"] = scopeId);
    }
    if (a.$children$) {
      for (o = 0; o < a.$children$.length; ++o) {
        i = createElm(e, a, o);
        if (i) {
          s.appendChild(i);
        }
      }
    }
    {
      if (a.$tag$ === "svg") {
        isSvgMode = false;
      } else if (s.tagName === "foreignObject") {
        isSvgMode = true;
      }
    }
  }
  return s;
};
var addVnodes = function (e, t, n, r, a, o) {
  var s = e;
  var i;
  if (s.shadowRoot && s.tagName === hostTagName) {
    s = s.shadowRoot;
  }
  for (; a <= o; ++a) {
    if (r[a]) {
      i = createElm(null, n, a);
      if (i) {
        r[a].$elm$ = i;
        s.insertBefore(i, t);
      }
    }
  }
};
var removeVnodes = function (e, t, n) {
  for (var r = t; r <= n; ++r) {
    var a = e[r];
    if (a) {
      var o = a.$elm$;
      nullifyVNodeRefs(a);
      if (o) {
        o.remove();
      }
    }
  }
};
var updateChildren = function (e, t, n, r) {
  var a = 0;
  var o = 0;
  var s = t.length - 1;
  var i = t[0];
  var l = t[s];
  var u = r.length - 1;
  var c = r[0];
  var f = r[u];
  var $;
  while (a <= s && o <= u) {
    if (i == null) {
      i = t[++a];
    } else if (l == null) {
      l = t[--s];
    } else if (c == null) {
      c = r[++o];
    } else if (f == null) {
      f = r[--u];
    } else if (isSameVnode(i, c)) {
      patch(i, c);
      i = t[++a];
      c = r[++o];
    } else if (isSameVnode(l, f)) {
      patch(l, f);
      l = t[--s];
      f = r[--u];
    } else if (isSameVnode(i, f)) {
      patch(i, f);
      e.insertBefore(i.$elm$, l.$elm$.nextSibling);
      i = t[++a];
      f = r[--u];
    } else if (isSameVnode(l, c)) {
      patch(l, c);
      e.insertBefore(l.$elm$, i.$elm$);
      l = t[--s];
      c = r[++o];
    } else {
      {
        $ = createElm(t && t[o], n, o);
        c = r[++o];
      }
      if ($) {
        {
          i.$elm$.parentNode.insertBefore($, i.$elm$);
        }
      }
    }
  }
  if (a > s) {
    addVnodes(e, r[u + 1] == null ? null : r[u + 1].$elm$, n, r, o, u);
  } else if (o > u) {
    removeVnodes(t, a, s);
  }
};
var isSameVnode = function (e, t) {
  if (e.$tag$ === t.$tag$) {
    return true;
  }
  return false;
};
var patch = function (e, t) {
  var n = t.$elm$ = e.$elm$;
  var r = e.$children$;
  var a = t.$children$;
  var o = t.$tag$;
  var s = t.$text$;
  if (s === null) {
    {
      isSvgMode = o === "svg" ? true : o === "foreignObject" ? false : isSvgMode;
    }
    {
      {
        updateElement(e, t, isSvgMode);
      }
    }
    if (r !== null && a !== null) {
      updateChildren(n, r, t, a);
    } else if (a !== null) {
      if (e.$text$ !== null) {
        n.textContent = "";
      }
      addVnodes(n, null, t, a, 0, a.length - 1);
    } else if (r !== null) {
      removeVnodes(r, 0, r.length - 1);
    }
    if (isSvgMode && o === "svg") {
      isSvgMode = false;
    }
  } else if (e.$text$ !== s) {
    n.data = s;
  }
};
var nullifyVNodeRefs = function (e) {
  {
    e.$attrs$ && e.$attrs$.ref && e.$attrs$.ref(null);
    e.$children$ && e.$children$.map(nullifyVNodeRefs);
  }
};
var renderVdom = function (e, t) {
  var n = e.$hostElement$;
  var r = e.$vnode$ || newVNode(null, null);
  var a = isHost(t) ? t : h(null, null, t);
  hostTagName = n.tagName;
  a.$tag$ = null;
  a.$flags$ |= 4;
  e.$vnode$ = a;
  a.$elm$ = r.$elm$ = n.shadowRoot || n;
  {
    scopeId = n["s-sc"];
  }
  patch(r, a);
};
var attachToAncestor = function (e, t) {
  if (t && !e.$onRenderResolve$ && t["s-p"]) {
    t["s-p"].push(new Promise(function (t) {
      return e.$onRenderResolve$ = t;
    }));
  }
};
var scheduleUpdate = function (e, t) {
  {
    e.$flags$ |= 16;
  }
  if (e.$flags$ & 4) {
    e.$flags$ |= 512;
    return;
  }
  attachToAncestor(e, e.$ancestorComponent$);
  var n = function () {
    return dispatchHooks(e, t);
  };
  return writeTask(n);
};
var dispatchHooks = function (e, t) {
  var n = createTime("scheduleUpdate", e.$cmpMeta$.$tagName$);
  var r = e.$lazyInstance$;
  var a;
  if (t) {
    {
      e.$flags$ |= 256;
      if (e.$queuedListeners$) {
        e.$queuedListeners$.map(function (e) {
          var t = e[0],
            n = e[1];
          return safeCall(r, t, n);
        });
        e.$queuedListeners$ = undefined;
      }
    }
  }
  n();
  return enqueue(a, function () {
    return updateComponent(e, r, t);
  });
};
var enqueue = function (e, t) {
  return isPromisey(e) ? e.then(t) : t();
};
var isPromisey = function (e) {
  return e instanceof Promise || e && e.then && typeof e.then === "function";
};
var updateComponent = function (e, t, n) {
  return __awaiter(void 0, void 0, void 0, function () {
    var r, a, o, s, i, l, u;
    return __generator(this, function (c) {
      a = e.$hostElement$;
      o = createTime("update", e.$cmpMeta$.$tagName$);
      s = a["s-rc"];
      if (n) {
        attachStyles(e);
      }
      i = createTime("render", e.$cmpMeta$.$tagName$);
      {
        callRender(e, t);
      }
      if (s) {
        s.map(function (e) {
          return e();
        });
        a["s-rc"] = undefined;
      }
      i();
      o();
      {
        l = (r = a["s-p"]) !== null && r !== void 0 ? r : [];
        u = function () {
          return postUpdateComponent(e);
        };
        if (l.length === 0) {
          u();
        } else {
          Promise.all(l).then(u);
          e.$flags$ |= 4;
          l.length = 0;
        }
      }
      return [2];
    });
  });
};
var callRender = function (e, t, n) {
  try {
    t = t.render();
    {
      e.$flags$ &= ~16;
    }
    {
      e.$flags$ |= 2;
    }
    {
      {
        {
          renderVdom(e, t);
        }
      }
    }
  } catch (t) {
    consoleError(t, e.$hostElement$);
  }
  return null;
};
var postUpdateComponent = function (e) {
  var t = e.$cmpMeta$.$tagName$;
  var n = e.$hostElement$;
  var r = createTime("postUpdate", t);
  var a = e.$lazyInstance$;
  var o = e.$ancestorComponent$;
  if (!(e.$flags$ & 64)) {
    e.$flags$ |= 64;
    {
      addHydratedFlag(n);
    }
    {
      safeCall(a, "componentDidLoad");
    }
    r();
    {
      e.$onReadyResolve$(n);
      if (!o) {
        appDidLoad();
      }
    }
  } else {
    r();
  }
  {
    e.$onInstanceResolve$(n);
  }
  {
    if (e.$onRenderResolve$) {
      e.$onRenderResolve$();
      e.$onRenderResolve$ = undefined;
    }
    if (e.$flags$ & 512) {
      nextTick(function () {
        return scheduleUpdate(e, false);
      });
    }
    e.$flags$ &= ~(4 | 512);
  }
};
var forceUpdate = function (e) {
  {
    var t = getHostRef(e);
    var n = t.$hostElement$.isConnected;
    if (n && (t.$flags$ & (2 | 16)) === 2) {
      scheduleUpdate(t, false);
    }
    return n;
  }
};
var appDidLoad = function (e) {
  {
    addHydratedFlag(doc.documentElement);
  }
  nextTick(function () {
    return emitEvent(win, "appload", {
      detail: {
        namespace: NAMESPACE
      }
    });
  });
};
var safeCall = function (e, t, n) {
  if (e && e[t]) {
    try {
      return e[t](n);
    } catch (e) {
      consoleError(e);
    }
  }
  return undefined;
};
var addHydratedFlag = function (e) {
  return e.classList.add("hydrated");
};
var getValue = function (e, t) {
  return getHostRef(e).$instanceValues$.get(t);
};
var setValue = function (e, t, n, r) {
  var a = getHostRef(e);
  var o = a.$instanceValues$.get(t);
  var s = a.$flags$;
  var i = a.$lazyInstance$;
  n = parsePropertyValue(n, r.$members$[t][0]);
  var l = Number.isNaN(o) && Number.isNaN(n);
  var u = n !== o && !l;
  if ((!(s & 8) || o === undefined) && u) {
    a.$instanceValues$.set(t, n);
    if (i) {
      if ((s & (2 | 16)) === 2) {
        scheduleUpdate(a, false);
      }
    }
  }
};
var proxyComponent = function (e, t, n) {
  if (t.$members$) {
    var r = Object.entries(t.$members$);
    var a = e.prototype;
    r.map(function (e) {
      var r = e[0],
        o = e[1][0];
      if (o & 31 || n & 2 && o & 32) {
        Object.defineProperty(a, r, {
          get: function () {
            return getValue(this, r);
          },
          set: function (e) {
            setValue(this, r, e, t);
          },
          configurable: true,
          enumerable: true
        });
      } else if (n & 1 && o & 64) {
        Object.defineProperty(a, r, {
          value: function () {
            var e = [];
            for (var t = 0; t < arguments.length; t++) {
              e[t] = arguments[t];
            }
            var n = getHostRef(this);
            return n.$onInstancePromise$.then(function () {
              var t;
              return (t = n.$lazyInstance$)[r].apply(t, e);
            });
          }
        });
      }
    });
    if (n & 1) {
      var o = new Map();
      a.attributeChangedCallback = function (e, t, n) {
        var r = this;
        plt.jmp(function () {
          var t = o.get(e);
          if (r.hasOwnProperty(t)) {
            n = r[t];
            delete r[t];
          } else if (a.hasOwnProperty(t) && typeof r[t] === "number" && r[t] == n) {
            return;
          }
          r[t] = n === null && typeof r[t] === "boolean" ? false : n;
        });
      };
      e.observedAttributes = r.filter(function (e) {
        var t = e[0],
          n = e[1];
        return n[0] & 15;
      }).map(function (e) {
        var t = e[0],
          n = e[1];
        var r = n[1] || t;
        o.set(r, t);
        return r;
      });
    }
  }
  return e;
};
var initializeComponent = function (e, t, n, r, a) {
  return __awaiter(void 0, void 0, void 0, function () {
    var e, r, o, s, i, l, u;
    return __generator(this, function (c) {
      switch (c.label) {
        case 0:
          if (!((t.$flags$ & 32) === 0)) return [3, 3];
          t.$flags$ |= 32;
          a = loadModule(n);
          if (!a.then) return [3, 2];
          e = uniqueTime();
          return [4, a];
        case 1:
          a = c.sent();
          e();
          c.label = 2;
        case 2:
          if (!a.isProxied) {
            proxyComponent(a, n, 2);
            a.isProxied = true;
          }
          r = createTime("createInstance", n.$tagName$);
          {
            t.$flags$ |= 8;
          }
          try {
            new a(t);
          } catch (e) {
            consoleError(e);
          }
          {
            t.$flags$ &= ~8;
          }
          r();
          if (a.style) {
            o = a.style;
            s = getScopeId(n);
            if (!styles.has(s)) {
              i = createTime("registerStyles", n.$tagName$);
              registerStyle(s, o, !!(n.$flags$ & 1));
              i();
            }
          }
          c.label = 3;
        case 3:
          l = t.$ancestorComponent$;
          u = function () {
            return scheduleUpdate(t, true);
          };
          if (l && l["s-rc"]) {
            l["s-rc"].push(u);
          } else {
            u();
          }
          return [2];
      }
    });
  });
};
var connectedCallback = function (e) {
  if ((plt.$flags$ & 1) === 0) {
    var t = getHostRef(e);
    var n = t.$cmpMeta$;
    var r = createTime("connectedCallback", n.$tagName$);
    if (!(t.$flags$ & 1)) {
      t.$flags$ |= 1;
      {
        var a = e;
        while (a = a.parentNode || a.host) {
          if (a["s-p"]) {
            attachToAncestor(t, t.$ancestorComponent$ = a);
            break;
          }
        }
      }
      if (n.$members$) {
        Object.entries(n.$members$).map(function (t) {
          var n = t[0],
            r = t[1][0];
          if (r & 31 && e.hasOwnProperty(n)) {
            var a = e[n];
            delete e[n];
            e[n] = a;
          }
        });
      }
      {
        initializeComponent(e, t, n);
      }
    } else {
      addHostEventListeners(e, t, n.$listeners$);
    }
    r();
  }
};
var disconnectedCallback = function (e) {
  if ((plt.$flags$ & 1) === 0) {
    var t = getHostRef(e);
    var n = t.$lazyInstance$;
    {
      if (t.$rmListeners$) {
        t.$rmListeners$.map(function (e) {
          return e();
        });
        t.$rmListeners$ = undefined;
      }
    }
    {
      safeCall(n, "disconnectedCallback");
    }
  }
};
var bootstrapLazy = function (e, t) {
  if (t === void 0) {
    t = {};
  }
  var n;
  var r = createTime();
  var a = [];
  var o = t.exclude || [];
  var s = win.customElements;
  var i = doc.head;
  var l = i.querySelector("meta[charset]");
  var u = doc.createElement("style");
  var c = [];
  var f;
  var $ = true;
  Object.assign(plt, t);
  plt.$resourcesUrl$ = new URL(t.resourcesUrl || "./", doc.baseURI).href;
  e.map(function (e) {
    e[1].map(function (t) {
      var n = {
        $flags$: t[0],
        $tagName$: t[1],
        $members$: t[2],
        $listeners$: t[3]
      };
      {
        n.$members$ = t[2];
      }
      {
        n.$listeners$ = t[3];
      }
      var r = n.$tagName$;
      var i = function (e) {
        __extends(t, e);
        function t(t) {
          var r = e.call(this, t) || this;
          t = r;
          registerHost(t, n);
          if (n.$flags$ & 1) {
            {
              {
                t.attachShadow({
                  mode: "open"
                });
              }
            }
          }
          return r;
        }
        t.prototype.connectedCallback = function () {
          var e = this;
          if (f) {
            clearTimeout(f);
            f = null;
          }
          if ($) {
            c.push(this);
          } else {
            plt.jmp(function () {
              return connectedCallback(e);
            });
          }
        };
        t.prototype.disconnectedCallback = function () {
          var e = this;
          plt.jmp(function () {
            return disconnectedCallback(e);
          });
        };
        t.prototype.componentOnReady = function () {
          return getHostRef(this).$onReadyPromise$;
        };
        return t;
      }(HTMLElement);
      n.$lazyBundleId$ = e[0];
      if (!o.includes(r) && !s.get(r)) {
        a.push(r);
        s.define(r, proxyComponent(i, n, 1));
      }
    });
  });
  {
    u.innerHTML = a + HYDRATED_CSS;
    u.setAttribute("data-styles", "");
    var d = (n = plt.$nonce$) !== null && n !== void 0 ? n : queryNonceMetaTagContent(doc);
    if (d != null) {
      u.setAttribute("nonce", d);
    }
    i.insertBefore(u, l ? l.nextSibling : i.firstChild);
  }
  $ = false;
  if (c.length) {
    c.map(function (e) {
      return e.connectedCallback();
    });
  } else {
    {
      plt.jmp(function () {
        return f = setTimeout(appDidLoad, 30);
      });
    }
  }
  r();
};
var addHostEventListeners = function (e, t, n, r) {
  if (n) {
    n.map(function (n) {
      var r = n[0],
        a = n[1],
        o = n[2];
      var s = getHostListenerTarget(e, r);
      var i = hostListenerProxy(t, o);
      var l = hostListenerOpts(r);
      plt.ael(s, a, i, l);
      (t.$rmListeners$ = t.$rmListeners$ || []).push(function () {
        return plt.rel(s, a, i, l);
      });
    });
  }
};
var hostListenerProxy = function (e, t) {
  return function (n) {
    try {
      {
        if (e.$flags$ & 256) {
          e.$lazyInstance$[t](n);
        } else {
          (e.$queuedListeners$ = e.$queuedListeners$ || []).push([t, n]);
        }
      }
    } catch (e) {
      consoleError(e);
    }
  };
};
var getHostListenerTarget = function (e, t) {
  if (t & 16) return doc.body;
  return e;
};
var hostListenerOpts = function (e) {
  return (e & 2) !== 0;
};
var setNonce = function (e) {
  return plt.$nonce$ = e;
};
var hostRefs = new WeakMap();
var getHostRef = function (e) {
  return hostRefs.get(e);
};
var registerInstance = function (e, t) {
  return hostRefs.set(t.$lazyInstance$ = e, t);
};
var registerHost = function (e, t) {
  var n = {
    $flags$: 0,
    $hostElement$: e,
    $cmpMeta$: t,
    $instanceValues$: new Map()
  };
  {
    n.$onInstancePromise$ = new Promise(function (e) {
      return n.$onInstanceResolve$ = e;
    });
  }
  {
    n.$onReadyPromise$ = new Promise(function (e) {
      return n.$onReadyResolve$ = e;
    });
    e["s-p"] = [];
    e["s-rc"] = [];
  }
  addHostEventListeners(e, n, t.$listeners$);
  return hostRefs.set(e, n);
};
var isMemberInElement = function (e, t) {
  return t in e;
};
var consoleError = function (e, t) {
  return (0, console.error)(e, t);
};
var cmpModules = new Map();
var loadModule = function (e, t, n) {
  var r = e.$tagName$.replace(/-/g, "_");
  var a = e.$lazyBundleId$;
  var o = cmpModules.get(a);
  if (o) {
    return o[r];
  }
  if (!n || !BUILD.hotModuleReplacement) {
    var s = function (e) {
      cmpModules.set(a, e);
      return e[r];
    };
    switch (a) {
      case "pwa-action-sheet":
        return __webpack_require__.e(/* import() */ 626).then(__webpack_require__.bind(__webpack_require__, 5626)).then(s, consoleError);
      case "pwa-camera-modal":
        return __webpack_require__.e(/* import() */ 821).then(__webpack_require__.bind(__webpack_require__, 1821)).then(s, consoleError);
      case "pwa-toast":
        return __webpack_require__.e(/* import() */ 251).then(__webpack_require__.bind(__webpack_require__, 5251)).then(s, consoleError);
      case "pwa-camera-modal-instance":
        return __webpack_require__.e(/* import() */ 353).then(__webpack_require__.bind(__webpack_require__, 1353)).then(s, consoleError);
      case "pwa-camera":
        return __webpack_require__.e(/* import() */ 677).then(__webpack_require__.bind(__webpack_require__, 4677)).then(s, consoleError);
    }
  }
  return __webpack_require__(6233)("./".concat(a, ".entry.js").concat("")).then(function (e) {
    {
      cmpModules.set(a, e);
    }
    return e[r];
  }, consoleError);
};
var styles = new Map();
var win = typeof window !== "undefined" ? window : {};
var doc = win.document || {
  head: {}
};
var plt = {
  $flags$: 0,
  $resourcesUrl$: "",
  jmp: function (e) {
    return e();
  },
  raf: function (e) {
    return requestAnimationFrame(e);
  },
  ael: function (e, t, n, r) {
    return e.addEventListener(t, n, r);
  },
  rel: function (e, t, n, r) {
    return e.removeEventListener(t, n, r);
  },
  ce: function (e, t) {
    return new CustomEvent(e, t);
  }
};
var promiseResolve = function (e) {
  return Promise.resolve(e);
};
var supportsConstructableStylesheets = function () {
  try {
    new CSSStyleSheet();
    return typeof new CSSStyleSheet().replaceSync === "function";
  } catch (e) {}
  return false;
}();
var queueDomReads = [];
var queueDomWrites = [];
var queueTask = function (e, t) {
  return function (n) {
    e.push(n);
    if (!queuePending) {
      queuePending = true;
      if (t && plt.$flags$ & 4) {
        nextTick(flush);
      } else {
        plt.raf(flush);
      }
    }
  };
};
var consume = function (e) {
  for (var t = 0; t < e.length; t++) {
    try {
      e[t](performance.now());
    } catch (e) {
      consoleError(e);
    }
  }
  e.length = 0;
};
var flush = function () {
  consume(queueDomReads);
  {
    consume(queueDomWrites);
    if (queuePending = queueDomReads.length > 0) {
      plt.raf(flush);
    }
  }
};
var nextTick = function (e) {
  return promiseResolve().then(e);
};
var writeTask = queueTask(queueDomWrites, true);


/***/ }),

/***/ 1734:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _placemarkio_polyline__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7803);
/* harmony import */ var _turf_line_slice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(240);
/* harmony import */ var _turf_clean_coords__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3983);
/* harmony import */ var _directions_results_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4961);
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5608);
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2116);
/* harmony import */ var _route_draw_route_draw_save__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1071);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_directions_results_dom__WEBPACK_IMPORTED_MODULE_3__, _globals__WEBPACK_IMPORTED_MODULE_5__, _route_draw_route_draw_save__WEBPACK_IMPORTED_MODULE_6__]);
([_directions_results_dom__WEBPACK_IMPORTED_MODULE_3__, _globals__WEBPACK_IMPORTED_MODULE_5__, _route_draw_route_draw_save__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */









/**
 * Interface sur les resultats du calcul d'itineraire
 * @module DirectionsResults
 */
var _DirectionsResults_brand = /*#__PURE__*/new WeakSet();
class DirectionsResults {
  /**
     * constructeur
     * @constructs
     * @param {*} map
     * @param {*} options
     */
  constructor(map, target, _options) {
    /**
     * écouteur du bouton Enregistrer
      */
    _classPrivateMethodInitSpec(this, _DirectionsResults_brand);
    this.options = _options || {
      duration: "",
      distance: "",
      transport: "",
      computation: "",
      geometry: null,
      // encoded polyline
      waypoints: [],
      // [ { name, hint, location } ]
      instructions: [],
      // [ routes[0].legs ] : [distance, duration, [steps], summary]
      elevation: null
    };

    // target
    this.target = target;

    // carte
    this.map = map;

    // rendu graphique
    this.render();
    this.handleRouteSave = _assertClassBrand(_DirectionsResults_brand, this, _onRouteSave).bind(this);
    _dom__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.$directionsSaveBtn.addEventListener("click", this.handleRouteSave);
    return this;
  }

  /**
   * creation de l'interface
   * @public
   */
  render() {
    var target = this.target || document.getElementById("directionsResultsWindow");
    if (!target) {
      console.warn();
      return;
    }
    var container = this.getContainer(this.options);
    if (!container) {
      console.warn();
      return;
    }

    // ajout du container
    target.appendChild(container);
  }

  /**
   * affiche le menu des résultats du calcul
   * @public
   */
  show() {
    _globals__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.menu.open("directionsResults");
  }

  /**
   * ferme le menu des résultats du calcul
   * @public
   */
  hide() {
    _globals__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A.menu.close("directionsResults");
  }
  updateDuration(newDuration) {
    const oldDuration = this.options.duration;
    this.options.duration = newDuration;
    const ratio = newDuration / oldDuration;
    this.options.instructions.forEach(instruction => {
      instruction.steps.forEach(step => {
        step.duration *= ratio;
      });
    });
    this.__updateDurationDom();
  }
}

// mixins
function _onRouteSave() {
  let transport;
  switch (this.options.transport) {
    case "Pieton":
      transport = "pedestrian";
      break;
    case "Voiture":
      transport = "car";
  }
  this.routeDrawSave = new _route_draw_route_draw_save__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A(null, {
    data: JSON.parse(JSON.stringify(_assertClassBrand(_DirectionsResults_brand, this, _directionsDataToRouteDrawData).call(this, this.options))),
    transport: transport,
    name: "",
    id: -1
  });
  this.routeDrawSave.show("directions");
}
/**
 * Convertit les données d'itinéraire en données de tracé
 * @param {Object} options - Options d'itinéraire
 * @returns {Object} Données formatées pour le tracé
 */
function _directionsDataToRouteDrawData(options) {
  let elevationData = {
    elevationData: [{
      x: 0,
      y: 0
    }],
    coordinates: [],
    dplus: 0,
    dminus: 0,
    unit: "m"
  };
  if (options.elevation.elevationData) {
    elevationData = {
      elevationData: options.elevation.elevationData,
      coordinates: options.elevation.profileLngLats,
      dplus: options.elevation.dplus,
      dminus: options.elevation.dminus,
      unit: options.elevation.unit
    };
  }
  let nextPointId = -1;
  const points = options.waypoints.map(pt => {
    let order = "";
    nextPointId++;
    if (nextPointId === 0) {
      order = "departure";
    }
    return {
      type: "Feature",
      geometry: {
        type: "Point",
        coordinates: pt.location
      },
      properties: {
        name: pt.name,
        id: nextPointId,
        order: order
      }
    };
  });
  points[points.length - 1].properties.order = "destination";
  let globalGeometry = {
    type: "LineString",
    coordinates: (0,_placemarkio_polyline__WEBPACK_IMPORTED_MODULE_0__/* .decode */ .D4)(options.geometry)
  };
  globalGeometry = (0,_turf_clean_coords__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)(globalGeometry);
  const steps = [];
  let nextStepId = 0;
  for (let i = 1; i < points.length; i++) {
    let step = {
      type: "Feature",
      geometry: {
        type: "LineString",
        coordinates: (0,_turf_line_slice__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)(points[i - 1], points[i], globalGeometry).geometry.coordinates
      },
      properties: {
        start_name: points[0].properties.name,
        end_name: points[i].properties.name,
        duration: options.instructions[i - 1].duration,
        distance: options.instructions[i - 1].distance,
        id: nextStepId,
        mode: 1
      }
    };
    nextStepId++;
    steps.push(step);
  }
  const data = {
    duration: options.duration,
    distance: options.distance,
    points: points,
    steps: steps,
    elevationData: elevationData
  };
  return data;
}
Object.assign(DirectionsResults.prototype, _directions_results_dom__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DirectionsResults);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1820:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var maplibre_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2461);
/* harmony import */ var maplibre_gl__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(maplibre_gl__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */



// Mode offline
let popup = {
  popup: null
};
let editoPopup = {
  popup: null
};
function showPopup(content, map, className, closeMethodName, object) {
  // on supprime la popup
  if (object.popup) {
    object.popup.remove();
    object.popup = null;
  }
  window[closeMethodName] = () => {
    object.popup.remove();
  };

  // centre de la carte
  var center = map.getCenter();
  // position de la popup
  var popupOffsets = {
    "bottom": [0, 100]
  };
  // ouverture d'une popup
  object.popup = new (maplibre_gl__WEBPACK_IMPORTED_MODULE_0___default().Popup)({
    offset: popupOffsets,
    className: className,
    closeOnClick: true,
    closeOnMove: false,
    closeButton: false
  }).setLngLat(center).setHTML(content).setMaxWidth("300px").addTo(map);
  // HACK: déplacement de la popup à la racine du body pour qu'elle puisse d'afficher au dessus de tout
  var popupEl = document.querySelectorAll(`.${className}`)[0];
  document.body.appendChild(popupEl);
  document.documentElement.style.setProperty("--popup-transform", "translate(-50%, -50%) translate(50vw, 50vh)");
}
function showOnlinePopup(content, map) {
  showPopup(content, map, "onlinePopup", "onCloseonlinePopup", popup);
}
function showEditoPopup(content, map) {
  showPopup(content, map, "editoPopup", "onCloseeditoPopup", editoPopup);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  showOnlinePopup,
  showEditoPopup,
  showPopup
});

/***/ }),

/***/ 1838:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "css/assets/8e50dba2b329af5cb920.svg";

/***/ }),

/***/ 1861:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _services_reverse__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2583);
/* harmony import */ var _services_elevation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3966);
/* harmony import */ var _services_location__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3838);
/* harmony import */ var _globals__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2116);
/* harmony import */ var _utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8554);
/* harmony import */ var _capacitor_share__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7252);
/* harmony import */ var _capacitor_toast__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2472);
/* harmony import */ var _capacitor_clipboard__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(3006);
/* harmony import */ var _action_sheet__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(1194);
/* harmony import */ var _utils_popup_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(1820);
/* harmony import */ var _css_assets_loading_darkgrey_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(1838);
/* harmony import */ var _immersive_position__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(835);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_services_location__WEBPACK_IMPORTED_MODULE_2__, _globals__WEBPACK_IMPORTED_MODULE_3__, _immersive_position__WEBPACK_IMPORTED_MODULE_11__]);
([_services_location__WEBPACK_IMPORTED_MODULE_2__, _globals__WEBPACK_IMPORTED_MODULE_3__, _immersive_position__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */

// TODO utiliser l'ecouteur sur l'event "target"














/**
 * Permet d'afficher ma position sur la carte
 * avec quelques informations utiles (adresse, lat/lon, elevation, ...)
 *
 * Fonctionnalité utilisée par "Où suis-je ?"
 *
 */
var _Position_brand = /*#__PURE__*/new WeakSet();
class Position {
  /**
   * constructeur
   * @param {*} map
   * @param {*} options
   * @returns
   */
  constructor(map, options) {
    /**
     * rendu du menu
     * @param {string} type type de position default, myposition ou landmark
     * @param {boolean} isEvent si c'est un événement (pour le style)
     * @private
     */
    _classPrivateMethodInitSpec(this, _Position_brand);
    this.options = options || {
      target: null,
      // callback
      openPositionCbk: null,
      closePositionCbk: null,
      openIsochroneCbk: null,
      openDirectionsCbk: null,
      openSignalCbk: null,
      openSignalOSMCbk: null,
      openLandmarkCbk: null
    };

    // carte
    this.map = map;

    // target
    this.target = this.options.target;

    // share
    this.shareContent = null;

    // les données utiles du service
    this.coordinates = null;
    this.address = null;
    this.elevation = null;
    this.name = null; // nom résumé

    // Titre de l'onglet (ex. "Ma Position", "Repère Placé"...)
    this.header = "";

    // HTML additionnel (pour le GFI)
    this.additionalHtml = {
      beforeButtons: "",
      afterButtons: ""
    };

    // dom de l'interface
    this.container = null;

    // open/close interface
    this.opened = false;

    // fonction à exécuter à la fermeture du volet
    this.hideCallback = null;
    this.addressInfoPopup = {
      popup: null
    };
    this.immersivePosition = null;
    return this;
  }
  /**
   * calcul la position avec les méta informations
   * @param {Object} options options de la position
   * @param {Object} options.lngLat position en paramètre (propriétés lng et lat), false si "Ma Position"
   * @param {string} options.text texte d'en-tête de la position
   * @param {string} options.html html situé avant les boutons d'action
   * @param {string} options.html2 html situé après les boutons d'action
   * @param {Function} options.hideCallback fonction de callback pour la fermeture de la position (pour les animations)
   * @param {string} options.type type de position : default, context, myposition ou landmark
   * @public
   */
  async compute() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    const lngLat = options.lngLat || false;
    const text = options.text || "Repère placé";
    let html = options.html || "";
    const html2 = options.html2 || "";
    const hideCallback = options.hideCallback || null;
    const type = options.type || "default";
    const isEvent = options.isEvent || false;
    this.clear();
    if (this.hideCallback) {
      this.hideCallback();
      this.hideCallback = null;
    }
    let position;
    if (lngLat === false) {
      position = await _services_location__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.getLocation();
    } else {
      position = {
        coordinates: {
          lat: Math.round(lngLat.lat * 1e6) / 1e6,
          lon: Math.round(lngLat.lng * 1e6) / 1e6
        },
        text: text
      };
    }
    this.coordinates = position.coordinates;
    if (type === "myposition" || type === "context") {
      this.immersivePosition = new _immersive_position__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A({
        lat: this.coordinates.lat,
        lng: this.coordinates.lon
      });
      html = `<div id="immersivePostionHtmlBefore">${this.immersivePosition.computeHtml()}</div>`;
    }
    this.header = position.text;
    try {
      await _services_reverse__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.compute({
        lat: position.coordinates.lat,
        lon: position.coordinates.lon
      });
    } catch (err) {
      if (err.name === "AbortError") {
        return;
      }
      console.warn(`Error when fetching reverse: ${err}`);
    }
    this.additionalHtml.beforeButtons = html;
    this.additionalHtml.afterButtons = html2;
    this.address = _services_reverse__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.getAddress() || {
      number: "",
      street: "",
      postcode: "",
      city: ""
    };
    _assertClassBrand(_Position_brand, this, _render).call(this, type, isEvent);
    if (hideCallback) {
      this.hideCallback = hideCallback;
    }
    if (type === "myposition") {
      this.map.flyTo({
        center: [this.coordinates.lon, this.coordinates.lat]
      });
    }
    _services_elevation__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.compute(position.coordinates).then(() => {
      this.elevation = _services_elevation__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A.getElevation();
      _assertClassBrand(_Position_brand, this, _setShareContent).call(this, this.coordinates.lat, this.coordinates.lon, this.elevation.toLocaleString(), type);
      document.getElementById("positionAltitudeSpan").innerText = this.elevation.toLocaleString();
    }).catch(err => {
      if (err.name === "AbortError") {
        return;
      }
      if (!this.coordinates) {
        return;
      }
      console.warn(`Error when fetching elevation: ${err}`);
      this.elevation = "?";
      _assertClassBrand(_Position_brand, this, _setShareContent).call(this, this.coordinates.lat, this.coordinates.lon, this.elevation, type);
      if (document.getElementById("positionAltitudeSpan")) {
        document.getElementById("positionAltitudeSpan").innerText = this.elevation;
      }
    });
    if (type === "myposition" || type === "context") {
      this.immersivePosition.addEventListener("dataLoaded", () => {
        if (document.getElementById("immersivePostionHtmlBefore")) {
          document.getElementById("immersivePostionHtmlBefore").innerHTML = this.immersivePosition.computeHtml();
        }
      });
      this.immersivePosition.computeAll();
    }
  }
  /**
   * affiche le menu
   * @public
   */
  show() {
    if (this.options.openPositionCbk) {
      this.options.openPositionCbk();
      this.opened = true;
    }
  }

  /**
   * ferme le menu
   * @public
   */
  hide() {
    if (this.options.closePositionCbk) {
      this.options.closePositionCbk();
      this.opened = false;
      if (_globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.searchResultMarker != null) {
        _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.searchResultMarker.remove();
        _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.searchResultMarker = null;
      }
    }
    if (this.hideCallback) {
      this.hideCallback();
      this.hideCallback = null;
    }
  }

  /**
   * clean des resultats
   * @public
   */
  clear() {
    this.coordinates = null;
    this.address = null;
    this.elevation = null;
    this.opened = false;
    this.shareContent = null;
    this.immersivePosition = null;

    // nettoyage du DOM
    if (this.container) {
      this.container.remove();
    }
    if (!_globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.backButtonState.includes("isochrone") && _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.searchResultMarker != null) {
      _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.searchResultMarker.remove();
      _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.searchResultMarker = null;
    }
    this.additionalHtml = {
      beforeButtons: "",
      afterButtons: ""
    };
  }
}
function _render(type) {
  let isEvent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var target = this.target || document.getElementById("positionWindow");
  if (!target) {
    console.warn();
    return;
  }
  var id = {
    main: "positionContainer"
  };
  var address = this.address;
  var latitude = this.coordinates.lat;
  var longitude = this.coordinates.lon;
  var altitudeHtml = `<img src="${_css_assets_loading_darkgrey_svg__WEBPACK_IMPORTED_MODULE_10__}" height="8px" title="Chargement de l'altitude en cours...">`;
  var templateAddress;
  var eventClass = "";
  if (isEvent) {
    eventClass = " event";
  }

  // adresse disponible
  if (address.city && address.street) {
    templateAddress = `
        <span class="lblPositionAddress">${address.number} ${address.street}</span><br />
        <span class="lblPositionCity">${address.postcode} ${address.city}</span>
        `;
    this.name = `${address.number} ${address.street}, ${address.postcode} ${address.city}`;
  } else if (address.city && !address.street) {
    templateAddress = `
        <span class="lblPositionAddress">${address.city}</span>
        <span class="lblPositionCity">${address.postcode}</span>
        `;
    this.name = `${address.city} ${address.postcode}`;
  } else {
    templateAddress = `
        <span class="lblPositionAddress">${latitude}, ${longitude}</span>
        `;
    this.name = `${latitude}, ${longitude}`;
  }
  _assertClassBrand(_Position_brand, this, _setShareContent).call(this, latitude, longitude, "", type);
  // template litteral
  var htmlButtons = `
      <button id="positionRoute" class="btnPositionButtons${eventClass}"><label class="lblPositionImg lblPositionRouteImg"></label>S'y rendre</button>
      <button id="positionNear" class="btnPositionButtons secondary${eventClass}"><label class="lblPositionImg lblPositionNearImg"></label>À proximité</button>
      <button id="positionShare" class="btnPositionButtons secondary${eventClass}"><label class="lblPositionImg lblPositionShareImg"></label>Partager</button>
      <button id="positionLandmark" class="btnPositionButtons secondary${eventClass}"><label class="lblPositionImg lblPositionLandmarkImg"></label>Enregistrer</button>
      <button id="positionSignal" class="btnPositionButtons secondary${eventClass}"><label class="lblPositionImg lblPositionSignalImg"></label>Signaler</button>
      `;
  if (type === "myposition") {
    htmlButtons = `
        <button id="positionShare" class="btnPositionButtons"><label class="lblPositionImg lblPositionShareImg"></label>Partager</button>
        <button id="positionNear" class="btnPositionButtons secondary"><label class="lblPositionImg lblPositionNearImg"></label>À proximité</button>
        <button id="positionRoute" class="btnPositionButtons secondary"><label class="lblPositionImg lblPositionRouteImg"></label>S'y rendre</button>
        <button id="positionLandmark" class="btnPositionButtons secondary"><label class="lblPositionImg lblPositionLandmarkImg"></label>Point de repère</button>
      `;
  }
  var htmlAdvanced = "";
  // Si c'est un landmark
  if (type === "landmark") {
    htmlButtons = `
        <button id="positionRoute" class="btnPositionButtons"><label class="lblPositionImg lblPositionRouteImg"></label>S'y rendre</button>
        <button id="positionNear" class="btnPositionButtons secondary"><label class="lblPositionImg lblPositionNearImg"></label>À proximité</button>
        <button id="positionShare" class="btnPositionButtons secondary"><label class="lblPositionImg lblPositionShareImg"></label>Partager</button>
        <button id="positionSignal" class="btnPositionButtons secondary"><label class="lblPositionImg lblPositionSignalImg"></label>Signaler</button>
      `;
    htmlAdvanced = `
        <label id="position-landmark-show-advanced-tools" title="Plus d'outils" class="tools-layer-advanced" role="button" tabindex="0"></label>
      `;
  }

  // template litteral
  var strContainer = `
      <div id="${id.main}">
          <div class="divPositionTitleWrapper"><div class="divPositionTitle">${this.header}</div>${htmlAdvanced}</div>
          <div class="divPositionAdressOriginInfo${eventClass}">Adresse la plus proche du point sélectionné</div>
          <div class="divPositionAddress">
              <label class="lblPositionImgAddress${eventClass}"></label>
              <div class="divPositionSectionAddress fontLight">
                ${templateAddress}
                <div class="divPositionCoord fontLight">
                  <span id="positionCoordsSpan">(${latitude}, ${longitude})</span><span> - Alt : <span id="positionAltitudeSpan">${altitudeHtml}</span> m</span>
                </div>
              </div>
          </div>
          ${this.additionalHtml.beforeButtons}
          <div class="divPositionButtons">
            ${htmlButtons}
            <div id="divPositionButtonsAfter" title="Faire défiler le menu" tabindex="0"><div></div></div>
          </div>
          ${this.additionalHtml.afterButtons}
      </div>
    `;

  // transformation du container : String -> DOM
  var container = _utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.stringToHTML(strContainer.trim());
  if (!container) {
    console.warn();
    return;
  }

  // ajout du shadow DOM
  const shadowContainer = container.attachShadow({
    mode: "open"
  });
  shadowContainer.innerHTML = strContainer.trim();
  if (!shadowContainer) {
    console.warn();
    return;
  }

  // ajout des listeners principaux :
  shadowContainer.getElementById("positionShare").addEventListener("click", () => {
    _capacitor_share__WEBPACK_IMPORTED_MODULE_5__/* .Share */ .S.share({
      title: `Partager ${_assertClassBrand(_Position_brand, this, _getTrueHeader).call(this)}}`,
      text: this.shareContent,
      dialogTitle: "Partager la position"
    });
  });
  shadowContainer.getElementById("positionNear").addEventListener("click", async () => {
    let coordinates = this.coordinates;
    if (type === "myposition") {
      let position = await _services_location__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.getLocation();
      coordinates = position.coordinates;
    }
    // fermeture du panneau actuel
    if (this.options.closePositionCbk) {
      if (this.hideCallback) {
        this.hideCallback();
        this.hideCallback = null;
      }
      _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.isochrone.clear();
      this.options.closePositionCbk();
      this.opened = false;
    }
    // ouverture du panneau Isochrone
    if (this.options.openIsochroneCbk) {
      this.options.openIsochroneCbk();
      let target = _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.isochrone.dom.location;
      target.dataset.coordinates = "[" + coordinates.lon + "," + coordinates.lat + "]";
      target.value = this.name;
    }
  });
  shadowContainer.getElementById("positionRoute").addEventListener("click", async () => {
    let coordinates = this.coordinates;
    if (type === "myposition") {
      let position = await _services_location__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.getLocation();
      coordinates = position.coordinates;
    }
    // fermeture du panneau actuel
    if (this.options.closePositionCbk) {
      if (this.hideCallback) {
        this.hideCallback();
        this.hideCallback = null;
      }
      _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.isochrone.clear();
      this.options.closePositionCbk();
      this.opened = false;
    }
    // ouverture du panneau Itinéraire
    if (this.options.openDirectionsCbk) {
      this.options.openDirectionsCbk();
      let target = _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.directions.dom.inputArrival;
      if (type === "myposition") {
        target = _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.directions.dom.inputDeparture;
      }
      target.dataset.coordinates = "[" + coordinates.lon + "," + coordinates.lat + "]";
      target.value = this.name;
      if (_globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.directions.dom.inputArrival.value && _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.directions.dom.inputDeparture.value) {
        _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.directions.dom.buttonCompute.classList.remove("disabled");
      }
    }
  });
  if (type !== "landmark") {
    shadowContainer.getElementById("positionLandmark").addEventListener("click", async () => {
      let coordinates = this.coordinates;
      if (type === "myposition") {
        let position = await _services_location__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.getLocation();
        coordinates = position.coordinates;
      }
      // fermeture du panneau actuel
      if (this.options.closePositionCbk) {
        if (this.hideCallback) {
          this.hideCallback();
          this.hideCallback = null;
        }
        _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.isochrone.clear();
        this.options.closePositionCbk();
        this.opened = false;
      }
      // ouverture du panneau Point de repère
      if (this.options.openLandmarkCbk) {
        this.options.openLandmarkCbk();
        let target = document.getElementById("landmarkLocation");
        target.dataset.coordinates = "[" + coordinates.lon + "," + coordinates.lat + "]";
        target.value = this.name;
        if (type !== "myposition" && _assertClassBrand(_Position_brand, this, _getTrueHeader).call(this) !== "Repère placé") {
          let landmarkTitle = document.getElementById("landmark-title");
          landmarkTitle.value = _assertClassBrand(_Position_brand, this, _getTrueHeader).call(this).split("\n")[0];
          if (this.additionalHtml.beforeButtons) {
            let landmarkDesc = document.getElementById("landmark-description");
            let tempDomElem = _utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.stringToHTML(this.additionalHtml.beforeButtons);
            document.body.appendChild(tempDomElem);
            landmarkDesc.value = tempDomElem.innerText;
            document.body.removeChild(tempDomElem);
          }
          document.getElementById("landmarkWindow").querySelector(".landmark-submit").classList.remove("disabled");
        }
      }
    });
  }
  if (type !== "myposition") {
    shadowContainer.getElementById("positionSignal").addEventListener("click", () => {
      const coordinates = this.coordinates;
      _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.isochrone.clear();
      // ouverture du panneau Signalement
      if (this.options.openSignalCbk) {
        if (type === "osm") {
          _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.signalementOSM.data.poiName = _assertClassBrand(_Position_brand, this, _getTrueHeader).call(this).split("\n")[0];
          _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.signalementOSM.data.location = coordinates;
          this.options.openSignalOSMCbk();
        } else {
          this.options.openSignalCbk();
          _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.signalement.data.location = coordinates;
        }
      }
    });
  }
  if (type === "landmark") {
    // fermeture du panneau actuel
    const closeSelf = () => {
      if (this.options.closePositionCbk) {
        if (this.hideCallback) {
          this.hideCallback();
          this.hideCallback = null;
        }
        _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.isochrone.clear();
        this.options.closePositionCbk();
        this.opened = false;
      }
    };
    // Récupération de l'id du landmark
    let landmarkId = -1;
    [...shadowContainer.getElementById("landmarkPositionTitle").classList].forEach(cl => {
      if (cl.split("-")[0] === "landmarkPosition") {
        landmarkId = parseInt(cl.split("-")[1]);
      }
    });
    shadowContainer.getElementById("position-landmark-show-advanced-tools").addEventListener("click", () => {
      _action_sheet__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A.show({
        options: [{
          class: "tools-layer-share",
          text: "Partager",
          value: "share"
        }, {
          class: "tools-layer-edit",
          text: "Modifier",
          value: "edit"
        }, {
          class: "tools-layer-export",
          text: "Exporter",
          value: "export"
        }, {
          class: "tools-layer-remove confirm-needed",
          text: "Supprimer",
          value: "delete",
          confirmCallback: () => {
            _capacitor_toast__WEBPACK_IMPORTED_MODULE_6__/* .Toast */ .y.show({
              text: "Confirmez la suppression du point de repère",
              duration: "short",
              position: "bottom"
            });
          }
        }],
        timeToHide: 50
      }).then(value => {
        if (value === "share") {
          _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.myaccount.shareLandmarkFromID(landmarkId);
        }
        if (value === "edit") {
          closeSelf();
          _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.myaccount.editLandmarkFromID(landmarkId);
        }
        if (value === "export") {
          _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.myaccount.exportLandmarkFromID(landmarkId);
        }
        if (value === "delete") {
          closeSelf();
          _globals__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.myaccount.deleteLandmark(landmarkId);
        }
      });
    });
  }
  shadowContainer.querySelector(".divPositionAdressOriginInfo").addEventListener("click", _assertClassBrand(_Position_brand, this, _showAdressInfoPopup).bind(this));
  shadowContainer.getElementById("divPositionButtonsAfter").addEventListener("click", _utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.horizontalParentScroll);
  shadowContainer.getElementById("divPositionButtonsAfter").parentElement.addEventListener("scroll", _utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.horizontalParentScrollend);
  shadowContainer.getElementById("positionCoordsSpan").addEventListener("click", () => {
    let coordinates = this.coordinates;
    _capacitor_clipboard__WEBPACK_IMPORTED_MODULE_7__/* .Clipboard */ .B.write({
      string: `${coordinates.lat}, ${coordinates.lon}`
    }).then(() => {
      _capacitor_toast__WEBPACK_IMPORTED_MODULE_6__/* .Toast */ .y.show({
        text: "Coordonnées copiées dans le presse-papier",
        duration: "short",
        position: "bottom"
      });
    });
  });
  // ajout du container shadow
  target.appendChild(shadowContainer);

  // enregistrement du dom
  if (this.container) {
    this.container.remove();
  }
  this.container = document.getElementById(id.main);

  // mise à jour du statut de la fenêtre
  this.opened = true;
}
function _setShareContent(latitude, longitude) {
  let altitude = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "";
  let type = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "";
  const trueHeader = _assertClassBrand(_Position_brand, this, _getTrueHeader).call(this);
  var altitudeText = "";
  if (altitude !== "") {
    altitudeText = `
Altitude : ${altitude} m`;
  }
  const zoom = Math.round(this.map.getZoom() * 100) / 100;
  this.shareContent = `${trueHeader ? trueHeader : this.header}
${this.name}
Latitude : ${latitude}
Longitude : ${longitude}${altitudeText}
https://cartes-ign.ign.fr?lng=${longitude}&lat=${latitude}&z=${zoom}`;
  if (type === "landmark") {
    this.shareContent = `${trueHeader ? trueHeader : this.header}
${this.name}
Latitude : ${latitude}
Longitude : ${longitude}${altitudeText}
${_utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.stringToHTML(this.additionalHtml.beforeButtons).innerText}
https://cartes-ign.ign.fr?lng=${longitude}&lat=${latitude}&z=15&titre=${encodeURI(trueHeader ? trueHeader : this.header)}&description=${encodeURI(_utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.stringToHTML(this.additionalHtml.beforeButtons).innerText)}`;
  }
}
/* Transforme le HTML du header de la position en texte pour le partage */
function _getTrueHeader() {
  let trueHeader = this.header;
  if (this.header.includes("landmarkSummaryIcon")) {
    trueHeader = _utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.stringToHTML(this.header.trim()).innerText.trim();
  } else if (this.header.includes("divLegendDescription")) {
    trueHeader = _utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.stringToHTML(this.header.trim()).querySelector(".divLegendDescription").innerHTML.trim().replace("<br>", "\n");
  } else if (this.header.includes("positionTitle")) {
    const headerDiv = _utils_dom_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A.stringToHTML("<div>" + this.header + "</div>");
    trueHeader = "";
    for (const paragraph of headerDiv.querySelectorAll("p")) {
      trueHeader += paragraph.innerText + "\n";
    }
  }
  if (trueHeader.includes("positionSubTitle")) {
    trueHeader = trueHeader.trim().replace("<p class=\"positionSubTitle\">", "\n").replace("</p>", "\n");
  }
  return trueHeader;
}
function _showAdressInfoPopup() {
  _utils_popup_utils__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A.showPopup(`
      <div id="addressInfoPopup">
          <div class="divPositionTitle">Adresse la plus proche du point sélectionné</div>
          <div class="divPopupClose" onclick="onCloseaddressInfoPopup(event)"></div>
          <div class="divPopupContent">
              L'adresse affichée est obtenue grâce au service de géocodage inverse. Ce service retourne, à partir d'un point sur la carte, l'adresse de la Base Adresse Nationale (BAN) la plus proche. Selon ce principe, une adresse affichée peut différer de l'adresse connue d'un lieu.
          </div>
      </div>
      `, this.map, "addressInfoPopup", "onCloseaddressInfoPopup", this.addressInfoPopup);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Position);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1906:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: () => (/* binding */ distance)
/* harmony export */ });
/* unused harmony export default */
/* harmony import */ var _turf_invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2319);
/* harmony import */ var _turf_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2104);
// index.ts


function distance(from, to) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var coordinates1 = (0,_turf_invariant__WEBPACK_IMPORTED_MODULE_0__/* .getCoord */ .uG)(from);
  var coordinates2 = (0,_turf_invariant__WEBPACK_IMPORTED_MODULE_0__/* .getCoord */ .uG)(to);
  var dLat = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_1__/* .degreesToRadians */ .tR)(coordinates2[1] - coordinates1[1]);
  var dLon = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_1__/* .degreesToRadians */ .tR)(coordinates2[0] - coordinates1[0]);
  var lat1 = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_1__/* .degreesToRadians */ .tR)(coordinates1[1]);
  var lat2 = (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_1__/* .degreesToRadians */ .tR)(coordinates2[1]);
  var a = Math.pow(Math.sin(dLat / 2), 2) + Math.pow(Math.sin(dLon / 2), 2) * Math.cos(lat1) * Math.cos(lat2);
  return (0,_turf_helpers__WEBPACK_IMPORTED_MODULE_1__/* .radiansToLength */ .cJ)(2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a)), options.units);
}
var index_default = (/* unused pure expression or super */ null && (distance));


/***/ }),

/***/ 2059:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: () => (/* binding */ SplashScreen)
/* harmony export */ });
/* harmony import */ var _capacitor_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5036);

const SplashScreen = (0,_capacitor_core__WEBPACK_IMPORTED_MODULE_0__/* .registerPlugin */ .F3)('SplashScreen', {
  web: () => __webpack_require__.e(/* import() */ 305).then(__webpack_require__.bind(__webpack_require__, 8305)).then(m => new m.SplashScreenWeb())
});



/***/ }),

/***/ 2067:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */

const poiLegendRules = [{
  "subclass": "aerodrome",
  "libelle": "Aérodrome"
}, {
  "subclass": "arts_centre",
  "libelle": "Centre culturel"
}, {
  "subclass": "atm",
  "libelle": "Distributeur automatique de billets"
}, {
  "subclass": "bar",
  "libelle": "Bar, bistrot"
}, {
  "subclass": "bicycle_rental",
  "libelle": "Location de vélos, y compris Velib'"
}, {
  "subclass": "cafe",
  "libelle": "Café"
}, {
  "subclass": "casino",
  "libelle": "Casino"
}, {
  "subclass": "charging_station",
  "libelle": "Borne de recharge pour véhicules électriques"
}, {
  "subclass": "cinema",
  "libelle": "Cinéma"
}, {
  "subclass": "college",
  "libelle": "Enseignement supérieur"
}, {
  "subclass": "conference_centre",
  "libelle": "Centre de conférence"
}, {
  "subclass": "courthouse",
  "libelle": "Palais de justice"
}, {
  "subclass": "drinking_water",
  "libelle": "Source d'eau potable"
}, {
  "subclass": "events_venue",
  "libelle": "Lieu de réception"
}, {
  "subclass": "fast_food",
  "libelle": "Restauration rapide"
}, {
  "subclass": "ferry_terminal",
  "libelle": "Terminal de ferry"
}, {
  "subclass": "fire_station",
  "libelle": "Caserne de pompier"
}, {
  "subclass": "fuel",
  "libelle": "Station-service"
}, {
  "subclass": "grave_yard",
  "libelle": "Cimetière"
}, {
  "subclass": "cemetery",
  "libelle": "Cimetière"
}, {
  "subclass": "hospital",
  "libelle": "Hôpital"
}, {
  "subclass": "library",
  "libelle": "Bibliothèque publique"
}, {
  "subclass": "marketplace",
  "libelle": "Place de marché"
}, {
  "class": "amenity",
  "subclass": "monastery",
  "libelle": "Monastère"
}, {
  "subclass": "parking",
  "libelle": "Parking"
}, {
  "subclass": "pharmacy",
  "libelle": "Pharmacie"
}, {
  "subclass": "police",
  "libelle": "Poste de police, Gendarmerie"
}, {
  "subclass": "post_office",
  "libelle": "Bureau de poste"
}, {
  "subclass": "prison",
  "libelle": "Etablissement pénitencier"
}, {
  "subclass": "pub",
  "libelle": "Pub"
}, {
  "subclass": "recycling",
  "libelle": "Point de collecte pour le recyclage"
}, {
  "subclass": "restaurant",
  "libelle": "Restaurant"
}, {
  "subclass": "school",
  "libelle": "Ecole, collège ou lycée"
}, {
  "subclass": "toilets",
  "libelle": "Toilettes"
}, {
  "subclass": "townhall",
  "libelle": "Mairie"
}, {
  "subclass": "university",
  "libelle": "Université"
}, {
  "subclass": "place_of_worship",
  "libelle": "Edifice religieux"
}, {
  "subclass": "bus_stop",
  "libelle": "Arrêt de bus"
}, {
  "subclass": "rest_area",
  "libelle": "Aire de repos"
}, {
  "subclass": "services",
  "libelle": "Aire de services"
}, {
  "subclass": "aqueduct",
  "libelle": "Aqueduc"
}, {
  "subclass": "archaeological_site",
  "libelle": "Site archéologique"
}, {
  "subclass": "battlefield",
  "libelle": "Champ de bataille"
}, {
  "subclass": "building",
  "libelle": "Bâtiment historique"
}, {
  "subclass": "castle",
  "libelle": "Château"
}, {
  "subclass": "church",
  "libelle": "Bâtiment religieux"
}, {
  "subclass": "fort",
  "libelle": "Fort militaire"
}, {
  "class": "historic",
  "subclass": "monastery",
  "libelle": "Monastère"
}, {
  "subclass": "monument",
  "libelle": "Monument"
}, {
  "subclass": "ruins",
  "libelle": "Ruines"
}, {
  "class": "historic",
  "subclass": "tower",
  "libelle": "Tour historique"
}, {
  "subclass": "golf_course",
  "libelle": "Terrain de golf"
}, {
  "subclass": "marina",
  "libelle": "Port de plaisance, marina"
}, {
  "subclass": "pitch",
  "libelle": "Terrain de sport"
}, {
  "subclass": "picnic_table",
  "libelle": "Table de pique-nique"
}, {
  "subclass": "sports_centre",
  "libelle": "Centre sportif"
}, {
  "subclass": "sports_hall",
  "libelle": "Salle de sport"
}, {
  "subclass": "stadium",
  "libelle": "Stade"
}, {
  "subclass": "swimming_pool",
  "libelle": "Piscine"
}, {
  "subclass": "communications_tower",
  "libelle": "Tour de télécommunications"
}, {
  "subclass": "lighthouse",
  "libelle": "Phare"
}, {
  "subclass": "observatory",
  "libelle": "Observatoire"
}, {
  "subclass": "telescope",
  "libelle": "Télescope"
}, {
  "subclass": "cave_entrance",
  "libelle": "Entrée de grotte"
}, {
  "subclass": "peak",
  "libelle": "Sommet"
}, {
  "subclass": "saddle",
  "libelle": "Col de montagne"
}, {
  "subclass": "government",
  "libelle": "Administration"
}, {
  "class": "public_transport",
  "subclass": "station",
  "libelle": "Station, Gare"
}, {
  "class": "railway",
  "subclass": "station",
  "libelle": "Gare ferroviaire"
}, {
  "subclass": "aquarium",
  "libelle": "Aquarium"
}, {
  "subclass": "alpine_hut",
  "libelle": "Refuge de montagne"
}, {
  "subclass": "camp_site",
  "libelle": "Camping"
}, {
  "subclass": "hostel",
  "libelle": "Auberge de jeunesse"
}, {
  "subclass": "hotel",
  "libelle": "Hôtel"
}, {
  "subclass": "information",
  "libelle": "Office de tourisme, Point d'information"
}, {
  "subclass": "motel",
  "libelle": "Motel"
}, {
  "subclass": "museum",
  "libelle": "Musée"
}, {
  "subclass": "picnic_site",
  "libelle": "Aire de pique-nique"
}, {
  "subclass": "theme_park",
  "libelle": "Parc d'attraction"
}, {
  "subclass": "viewpoint",
  "libelle": "Point de vue"
}, {
  "subclass": "wilderness_hut",
  "libelle": "Refuge non gardé"
}, {
  "subclass": "zoo",
  "libelle": "Parc zoologique"
}, {
  "subclass": "dam",
  "libelle": "Barrage"
}, {
  "subclass": "waterfall",
  "libelle": "Chute d'eau, Cascade"
}, {
  "subclass": "bakery",
  "libelle": "Boulangerie"
}, {
  "subclass": "supermarket",
  "libelle": "Supermarché, Hypermarché"
}, {
  "subclass": "convenience",
  "libelle": "Alimentation générale"
}, {
  "subclass": "greengrocer",
  "libelle": "Primeur"
}, {
  "subclass": "pastry",
  "libelle": "Pâtisserie"
}, {
  "subclass": "mall",
  "libelle": "Centre commercial, galerie marchande"
}, {
  "subclass": "department_store",
  "libelle": "Grand magasin"
}, {
  "subclass": "frozen_food",
  "libelle": "Produits surgelés"
}, {
  "subclass": "theatre",
  "libelle": "Théâtre"
}, {
  "subclass": "bank",
  "libelle": "Banque"
}, {
  "subclass": "clothes",
  "libelle": "Boutique de vêtements"
}, {
  "subclass": "hairdresser",
  "libelle": "Coiffeur"
}, {
  "subclass": "horse_riding",
  "libelle": "Centre équestre"
}, {
  "subclass": "horse_racing",
  "libelle": "Hippodrome"
}, {
  "subclass": "christian",
  "libelle": "Edifice chrétien"
}, {
  "subclass": "jewish",
  "libelle": "Edifice judaïque"
}, {
  "subclass": "muslim",
  "libelle": "Edifice musulman"
}, {
  "subclass": "car_repair",
  "libelle": "Garage automobile"
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (poiLegendRules);

/***/ }),

/***/ 2104:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Gf: () => (/* binding */ lengthToRadians),
/* harmony export */   I3: () => (/* binding */ convertLength),
/* harmony export */   Lr: () => (/* binding */ featureCollection),
/* harmony export */   N4: () => (/* binding */ feature),
/* harmony export */   cJ: () => (/* binding */ radiansToLength),
/* harmony export */   g5: () => (/* binding */ multiPolygon),
/* harmony export */   kB: () => (/* binding */ multiPoint),
/* harmony export */   n1: () => (/* binding */ polygon),
/* harmony export */   nv: () => (/* binding */ radiansToDegrees),
/* harmony export */   tR: () => (/* binding */ degreesToRadians),
/* harmony export */   wi: () => (/* binding */ lineString),
/* harmony export */   zX: () => (/* binding */ earthRadius),
/* harmony export */   zx: () => (/* binding */ point)
/* harmony export */ });
/* unused harmony exports areaFactors, azimuthToBearing, bearingToAzimuth, convertArea, factors, geometry, geometryCollection, isNumber, isObject, lengthToDegrees, lineStrings, multiLineString, points, polygons, round, validateBBox, validateId */
// index.ts
var earthRadius = 63710088e-1;
var factors = {
  centimeters: earthRadius * 100,
  centimetres: earthRadius * 100,
  degrees: 360 / (2 * Math.PI),
  feet: earthRadius * 3.28084,
  inches: earthRadius * 39.37,
  kilometers: earthRadius / 1e3,
  kilometres: earthRadius / 1e3,
  meters: earthRadius,
  metres: earthRadius,
  miles: earthRadius / 1609.344,
  millimeters: earthRadius * 1e3,
  millimetres: earthRadius * 1e3,
  nauticalmiles: earthRadius / 1852,
  radians: 1,
  yards: earthRadius * 1.0936
};
var areaFactors = {
  acres: 247105e-9,
  centimeters: 1e4,
  centimetres: 1e4,
  feet: 10.763910417,
  hectares: 1e-4,
  inches: 1550.003100006,
  kilometers: 1e-6,
  kilometres: 1e-6,
  meters: 1,
  metres: 1,
  miles: 386e-9,
  nauticalmiles: 29155334959812285e-23,
  millimeters: 1e6,
  millimetres: 1e6,
  yards: 1.195990046
};
function feature(geom, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const feat = {
    type: "Feature"
  };
  if (options.id === 0 || options.id) {
    feat.id = options.id;
  }
  if (options.bbox) {
    feat.bbox = options.bbox;
  }
  feat.properties = properties || {};
  feat.geometry = geom;
  return feat;
}
function geometry(type, coordinates) {
  let _options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  switch (type) {
    case "Point":
      return point(coordinates).geometry;
    case "LineString":
      return lineString(coordinates).geometry;
    case "Polygon":
      return polygon(coordinates).geometry;
    case "MultiPoint":
      return multiPoint(coordinates).geometry;
    case "MultiLineString":
      return multiLineString(coordinates).geometry;
    case "MultiPolygon":
      return multiPolygon(coordinates).geometry;
    default:
      throw new Error(type + " is invalid");
  }
}
function point(coordinates, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (!coordinates) {
    throw new Error("coordinates is required");
  }
  if (!Array.isArray(coordinates)) {
    throw new Error("coordinates must be an Array");
  }
  if (coordinates.length < 2) {
    throw new Error("coordinates must be at least 2 numbers long");
  }
  if (!isNumber(coordinates[0]) || !isNumber(coordinates[1])) {
    throw new Error("coordinates must contain numbers");
  }
  const geom = {
    type: "Point",
    coordinates
  };
  return feature(geom, properties, options);
}
function points(coordinates, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  return featureCollection(coordinates.map(coords => {
    return point(coords, properties);
  }), options);
}
function polygon(coordinates, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  for (const ring of coordinates) {
    if (ring.length < 4) {
      throw new Error("Each LinearRing of a Polygon must have 4 or more Positions.");
    }
    if (ring[ring.length - 1].length !== ring[0].length) {
      throw new Error("First and last Position are not equivalent.");
    }
    for (let j = 0; j < ring[ring.length - 1].length; j++) {
      if (ring[ring.length - 1][j] !== ring[0][j]) {
        throw new Error("First and last Position are not equivalent.");
      }
    }
  }
  const geom = {
    type: "Polygon",
    coordinates
  };
  return feature(geom, properties, options);
}
function polygons(coordinates, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  return featureCollection(coordinates.map(coords => {
    return polygon(coords, properties);
  }), options);
}
function lineString(coordinates, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (coordinates.length < 2) {
    throw new Error("coordinates must be an array of two or more positions");
  }
  const geom = {
    type: "LineString",
    coordinates
  };
  return feature(geom, properties, options);
}
function lineStrings(coordinates, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  return featureCollection(coordinates.map(coords => {
    return lineString(coords, properties);
  }), options);
}
function featureCollection(features) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const fc = {
    type: "FeatureCollection"
  };
  if (options.id) {
    fc.id = options.id;
  }
  if (options.bbox) {
    fc.bbox = options.bbox;
  }
  fc.features = features;
  return fc;
}
function multiLineString(coordinates, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const geom = {
    type: "MultiLineString",
    coordinates
  };
  return feature(geom, properties, options);
}
function multiPoint(coordinates, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const geom = {
    type: "MultiPoint",
    coordinates
  };
  return feature(geom, properties, options);
}
function multiPolygon(coordinates, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const geom = {
    type: "MultiPolygon",
    coordinates
  };
  return feature(geom, properties, options);
}
function geometryCollection(geometries, properties) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const geom = {
    type: "GeometryCollection",
    geometries
  };
  return feature(geom, properties, options);
}
function round(num) {
  let precision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  if (precision && !(precision >= 0)) {
    throw new Error("precision must be a positive number");
  }
  const multiplier = Math.pow(10, precision || 0);
  return Math.round(num * multiplier) / multiplier;
}
function radiansToLength(radians) {
  let units = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "kilometers";
  const factor = factors[units];
  if (!factor) {
    throw new Error(units + " units is invalid");
  }
  return radians * factor;
}
function lengthToRadians(distance) {
  let units = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "kilometers";
  const factor = factors[units];
  if (!factor) {
    throw new Error(units + " units is invalid");
  }
  return distance / factor;
}
function lengthToDegrees(distance, units) {
  return radiansToDegrees(lengthToRadians(distance, units));
}
function bearingToAzimuth(bearing) {
  let angle = bearing % 360;
  if (angle < 0) {
    angle += 360;
  }
  return angle;
}
function azimuthToBearing(angle) {
  angle = angle % 360;
  if (angle > 180) {
    return angle - 360;
  } else if (angle < -180) {
    return angle + 360;
  }
  return angle;
}
function radiansToDegrees(radians) {
  const normalisedRadians = radians % (2 * Math.PI);
  return normalisedRadians * 180 / Math.PI;
}
function degreesToRadians(degrees) {
  const normalisedDegrees = degrees % 360;
  return normalisedDegrees * Math.PI / 180;
}
function convertLength(length) {
  let originalUnit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "kilometers";
  let finalUnit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "kilometers";
  if (!(length >= 0)) {
    throw new Error("length must be a positive number");
  }
  return radiansToLength(lengthToRadians(length, originalUnit), finalUnit);
}
function convertArea(area) {
  let originalUnit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "meters";
  let finalUnit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "kilometers";
  if (!(area >= 0)) {
    throw new Error("area must be a positive number");
  }
  const startFactor = areaFactors[originalUnit];
  if (!startFactor) {
    throw new Error("invalid original units");
  }
  const finalFactor = areaFactors[finalUnit];
  if (!finalFactor) {
    throw new Error("invalid final units");
  }
  return area / startFactor * finalFactor;
}
function isNumber(num) {
  return !isNaN(num) && num !== null && !Array.isArray(num);
}
function isObject(input) {
  return input !== null && typeof input === "object" && !Array.isArray(input);
}
function validateBBox(bbox) {
  if (!bbox) {
    throw new Error("bbox is required");
  }
  if (!Array.isArray(bbox)) {
    throw new Error("bbox must be an Array");
  }
  if (bbox.length !== 4 && bbox.length !== 6) {
    throw new Error("bbox must be an Array of 4 or 6 numbers");
  }
  bbox.forEach(num => {
    if (!isNumber(num)) {
      throw new Error("bbox must only contain numbers");
    }
  });
}
function validateId(id) {
  if (!id) {
    throw new Error("id is required");
  }
  if (["string", "number"].indexOf(typeof id) === -1) {
    throw new Error("id must be a number or a string");
  }
}


/***/ }),

/***/ 2116:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _capacitor_network__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8663);
/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */



/** global: map */
let map = null;
let mapRLT1 = null;
let mapRLT2 = null;

/**
 * global: layer display state
 */
let layersDisplayed;
if (!localStorage.getItem("lastLayersDisplayed")) {
  layersDisplayed = [{
    id: "PLAN.IGN.INTERACTIF$TMS",
    opacity: 100,
    visible: true,
    gray: false
  }];
} else {
  layersDisplayed = JSON.parse(localStorage.getItem("lastLayersDisplayed"));
}

/**
 * global: back button state
 * is one of: 'default' 'search' 'params' 'legal' 'privacy' 'infos' 'layerManagerWindow' 'route' ...
 */
let backButtonState = "default";

/** global: last text in search bar */
let lastTextInSearch = "";
let myPositionMarker = null;
let searchResultMarker = null;
let myPositionIcon;
let myPositionIconGrey;
let searchResultIcon;

// Pour l'annulation de fetch
let searchAbortController = new AbortController();
let searchAbortSignal = searchAbortController.signal;

// Global Search plugin
let search = null;

// Global Route plugin
let directions = null;

// Global Isochrone plugin
let isochrone = null;

// Global Position plugin
let position = null;

// Global Compare Plugin
let compare = null;
let comparedLayers = ["ORTHOIMAGERY.ORTHOPHOTOS.1950-1965$WMTS", "ORTHOIMAGERY.ORTHOPHOTOS$WMTS"];

// Global Menu navigation
let menu = null;

// Global Layer Manager
let manager = null;

// Global POI filters
let poi = null;

// Global route draw
let routeDraw = null;

// Global interactivity
let interactivityIndicator = null;

// Global control mapInteractivity
let mapInteractivity = null;

// Global control my account
let myaccount = null;

// Global control compare Poi
let comparePoi = null;

// Global control osm poi accessibility
let osmPoiAccessibility = null;

// Global control signalement
let signalement = null;
let signalementOSM = null;

// Global control landmark and RTL landmark
let landmark = null;
let compareLandmark = null;

// Global control offline maps
let offlineMaps = null;

// Global control track record
let trackRecord = null;

// Global control immersive notifications
let immersiveNotifications = null;

// Global control 3d
let threeD = null;

// Global flag: is the device connected to the internet?
let online = (await _capacitor_network__WEBPACK_IMPORTED_MODULE_0__/* .Network */ .l.getStatus()).connected;
if (!online) {
  let hasPlanIGN = false;
  for (let i = 0; i < layersDisplayed.length; i++) {
    const layer = layersDisplayed[i];
    if (layer.id === "PLAN.IGN.INTERACTIF$TMS") {
      hasPlanIGN = true;
      break;
    }
  }
  if (!hasPlanIGN) {
    layersDisplayed.push({
      id: "PLAN.IGN.INTERACTIF$TMS",
      opacity: 100,
      visible: true,
      gray: false
    });
  }
}

// Scroll
let maxScroll = document.scrollingElement.scrollHeight - document.scrollingElement.clientHeight;
let anchors = [0, maxScroll / 2.5, maxScroll];
let currentScrollIndex = 0;
let mapLoaded = false;

// Walking speed for time calculation
let walkingSpeed;
if (!localStorage.getItem("walkingSpeed")) {
  walkingSpeed = 4 / 3.6;
} else {
  walkingSpeed = parseFloat(localStorage.getItem("walkingSpeed")) / 3.6;
}

// Are new place notifications enabled?
let newPlaceNotifEnabled;
if (!localStorage.getItem("newPlaceNotifEnabled")) {
  newPlaceNotifEnabled = 0;
} else {
  newPlaceNotifEnabled = parseFloat(localStorage.getItem("newPlaceNotifEnabled"));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  map,
  mapRLT1,
  mapRLT2,
  layersDisplayed,
  backButtonState,
  lastTextInSearch,
  myPositionMarker,
  searchResultMarker,
  myPositionIcon,
  myPositionIconGrey,
  searchResultIcon,
  searchAbortController,
  searchAbortSignal,
  currentScrollIndex,
  maxScroll,
  anchors,
  directions,
  isochrone,
  position,
  search,
  compare,
  comparedLayers,
  menu,
  manager,
  poi,
  routeDraw,
  interactivityIndicator,
  mapInteractivity,
  myaccount,
  comparePoi,
  signalement,
  signalementOSM,
  online,
  mapLoaded,
  walkingSpeed,
  osmPoiAccessibility,
  landmark,
  compareLandmark,
  offlineMaps,
  immersiveNotifications,
  newPlaceNotifEnabled,
  threeD,
  trackRecord
});
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } }, 1);

/***/ }),

/***/ 2319:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $R: () => (/* binding */ getCoords),
/* harmony export */   Pw: () => (/* binding */ getType),
/* harmony export */   bg: () => (/* binding */ getGeom),
/* harmony export */   mo: () => (/* binding */ featureOf),
/* harmony export */   uG: () => (/* binding */ getCoord)
/* harmony export */ });
/* unused harmony exports collectionOf, containsNumber, geojsonType */
// index.ts

function getCoord(coord) {
  if (!coord) {
    throw new Error("coord is required");
  }
  if (!Array.isArray(coord)) {
    if (coord.type === "Feature" && coord.geometry !== null && coord.geometry.type === "Point") {
      return [...coord.geometry.coordinates];
    }
    if (coord.type === "Point") {
      return [...coord.coordinates];
    }
  }
  if (Array.isArray(coord) && coord.length >= 2 && !Array.isArray(coord[0]) && !Array.isArray(coord[1])) {
    return [...coord];
  }
  throw new Error("coord must be GeoJSON Point or an Array of numbers");
}
function getCoords(coords) {
  if (Array.isArray(coords)) {
    return coords;
  }
  if (coords.type === "Feature") {
    if (coords.geometry !== null) {
      return coords.geometry.coordinates;
    }
  } else {
    if (coords.coordinates) {
      return coords.coordinates;
    }
  }
  throw new Error("coords must be GeoJSON Feature, Geometry Object or an Array");
}
function containsNumber(coordinates) {
  if (coordinates.length > 1 && isNumber(coordinates[0]) && isNumber(coordinates[1])) {
    return true;
  }
  if (Array.isArray(coordinates[0]) && coordinates[0].length) {
    return containsNumber(coordinates[0]);
  }
  throw new Error("coordinates must only contain numbers");
}
function geojsonType(value, type, name) {
  if (!type || !name) {
    throw new Error("type and name required");
  }
  if (!value || value.type !== type) {
    throw new Error("Invalid input to " + name + ": must be a " + type + ", given " + value.type);
  }
}
function featureOf(feature, type, name) {
  if (!feature) {
    throw new Error("No feature passed");
  }
  if (!name) {
    throw new Error(".featureOf() requires a name");
  }
  if (!feature || feature.type !== "Feature" || !feature.geometry) {
    throw new Error("Invalid input to " + name + ", Feature with geometry required");
  }
  if (!feature.geometry || feature.geometry.type !== type) {
    throw new Error("Invalid input to " + name + ": must be a " + type + ", given " + feature.geometry.type);
  }
}
function collectionOf(featureCollection, type, name) {
  if (!featureCollection) {
    throw new Error("No featureCollection passed");
  }
  if (!name) {
    throw new Error(".collectionOf() requires a name");
  }
  if (!featureCollection || featureCollection.type !== "FeatureCollection") {
    throw new Error("Invalid input to " + name + ", FeatureCollection required");
  }
  for (const feature of featureCollection.features) {
    if (!feature || feature.type !== "Feature" || !feature.geometry) {
      throw new Error("Invalid input to " + name + ", Feature with geometry required");
    }
    if (!feature.geometry || feature.geometry.type !== type) {
      throw new Error("Invalid input to " + name + ": must be a " + type + ", given " + feature.geometry.type);
    }
  }
}
function getGeom(geojson) {
  if (geojson.type === "Feature") {
    return geojson.geometry;
  }
  return geojson;
}
function getType(geojson, _name) {
  if (geojson.type === "FeatureCollection") {
    return "FeatureCollection";
  }
  if (geojson.type === "GeometryCollection") {
    return "GeometryCollection";
  }
  if (geojson.type === "Feature" && geojson.geometry !== null) {
    return geojson.geometry.type;
  }
  return geojson.type;
}


/***/ }),

/***/ 2345:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "css/assets/8095a3b342c31bef6740.jpg";

/***/ }),

/***/ 2461:
/***/ (function(module) {

/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.11.0/LICENSE.txt
 */(function(global,factory){ true?module.exports=factory():0;})(this,function(){'use strict';/* eslint-disable */var maplibregl={};var modules={};function define(moduleName,_dependencies,moduleFactory){modules[moduleName]=moduleFactory;// to get the list of modules see generated dist/maplibre-gl-dev.js file (look for `define(` calls)
if(moduleName!=='index'){return;}// we assume that when an index module is initializing then other modules are loaded already
var workerBundleString='var sharedModule = {}; ('+modules.shared+')(sharedModule); ('+modules.worker+')(sharedModule);';var sharedModule={};// the order of arguments of a module factory depends on rollup (it decides who is whose dependency)
// to check the correct order, see dist/maplibre-gl-dev.js file (look for `define(` calls)
// we assume that for our 3 chunks it will generate 3 modules and their order is predefined like the following
modules.shared(sharedModule);modules.index(maplibregl,sharedModule);if(typeof window!=='undefined'){maplibregl.setWorkerUrl(window.URL.createObjectURL(new Blob([workerBundleString],{type:'text/javascript'})));}return maplibregl;};define("shared",["exports"],function(t){"use strict";function e(t,e,r,n){return new(r||(r=Promise))(function(i,s){function a(t){try{l(n.next(t));}catch(t){s(t);}}function o(t){try{l(n.throw(t));}catch(t){s(t);}}function l(t){var e;t.done?i(t.value):(e=t.value,e instanceof r?e:new r(function(t){t(e);})).then(a,o);}l((n=n.apply(t,e||[])).next());});}function r(t,e){this.x=t,this.y=e;}function n(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t;}var i,s;"function"==typeof SuppressedError&&SuppressedError,r.prototype={clone(){return new r(this.x,this.y);},add(t){return this.clone()._add(t);},sub(t){return this.clone()._sub(t);},multByPoint(t){return this.clone()._multByPoint(t);},divByPoint(t){return this.clone()._divByPoint(t);},mult(t){return this.clone()._mult(t);},div(t){return this.clone()._div(t);},rotate(t){return this.clone()._rotate(t);},rotateAround(t,e){return this.clone()._rotateAround(t,e);},matMult(t){return this.clone()._matMult(t);},unit(){return this.clone()._unit();},perp(){return this.clone()._perp();},round(){return this.clone()._round();},mag(){return Math.sqrt(this.x*this.x+this.y*this.y);},equals(t){return this.x===t.x&&this.y===t.y;},dist(t){return Math.sqrt(this.distSqr(t));},distSqr(t){const e=t.x-this.x,r=t.y-this.y;return e*e+r*r;},angle(){return Math.atan2(this.y,this.x);},angleTo(t){return Math.atan2(this.y-t.y,this.x-t.x);},angleWith(t){return this.angleWithSep(t.x,t.y);},angleWithSep(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e);},_matMult(t){const e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this;},_add(t){return this.x+=t.x,this.y+=t.y,this;},_sub(t){return this.x-=t.x,this.y-=t.y,this;},_mult(t){return this.x*=t,this.y*=t,this;},_div(t){return this.x/=t,this.y/=t,this;},_multByPoint(t){return this.x*=t.x,this.y*=t.y,this;},_divByPoint(t){return this.x/=t.x,this.y/=t.y,this;},_unit(){return this._div(this.mag()),this;},_perp(){const t=this.y;return this.y=this.x,this.x=-t,this;},_rotate(t){const e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this;},_rotateAround(t,e){const r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this;},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this;},constructor:r},r.convert=function(t){if(t instanceof r)return t;if(Array.isArray(t))return new r(+t[0],+t[1]);if(void 0!==t.x&&void 0!==t.y)return new r(+t.x,+t.y);throw new Error("Expected [x, y] or {x, y} point format");};var a=function(){if(s)return i;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return s=1,i=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t;},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t;},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx;},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r;},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e));}},i;}(),o=n(a);let l,u;function c(){return null==l&&(l="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),l;}function h(){if(null==u&&(u=!1,c())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let r=0;r<t*t;r++){const n=4*r;e.fillStyle=`rgb(${n},${n+1},${n+2})`,e.fillRect(r%t,Math.floor(r/t),1,1);}const r=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&r[e]!==e){u=!0;break;}}}return u||!1;}var p=1e-6,f="undefined"!=typeof Float32Array?Float32Array:Array;function d(){var t=new f(9);return f!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t;}function y(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t;}function m(){var t=new f(3);return f!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t;}function g(t){var e=t[0],r=t[1],n=t[2];return Math.sqrt(e*e+r*r+n*n);}function x(t,e,r){var n=new f(3);return n[0]=t,n[1]=e,n[2]=r,n;}function v(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t;}function b(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t;}function w(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=i*l-s*o,t[1]=s*a-n*l,t[2]=n*o-i*a,t;}var _,S=g;function A(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t;}function k(){var t=new f(4);return f!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t;}function M(t,e,r,n){var i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"zyx",s=Math.PI/360;e*=s,n*=s,r*=s;var a=Math.sin(e),o=Math.cos(e),l=Math.sin(r),u=Math.cos(r),c=Math.sin(n),h=Math.cos(n);switch(i){case"xyz":t[0]=a*u*h+o*l*c,t[1]=o*l*h-a*u*c,t[2]=o*u*c+a*l*h,t[3]=o*u*h-a*l*c;break;case"xzy":t[0]=a*u*h-o*l*c,t[1]=o*l*h-a*u*c,t[2]=o*u*c+a*l*h,t[3]=o*u*h+a*l*c;break;case"yxz":t[0]=a*u*h+o*l*c,t[1]=o*l*h-a*u*c,t[2]=o*u*c-a*l*h,t[3]=o*u*h+a*l*c;break;case"yzx":t[0]=a*u*h+o*l*c,t[1]=o*l*h+a*u*c,t[2]=o*u*c-a*l*h,t[3]=o*u*h-a*l*c;break;case"zxy":t[0]=a*u*h-o*l*c,t[1]=o*l*h+a*u*c,t[2]=o*u*c+a*l*h,t[3]=o*u*h-a*l*c;break;case"zyx":t[0]=a*u*h-o*l*c,t[1]=o*l*h+a*u*c,t[2]=o*u*c-a*l*h,t[3]=o*u*h+a*l*c;break;default:throw new Error("Unknown angle order "+i);}return t;}function I(){var t=new f(2);return f!=Float32Array&&(t[0]=0,t[1]=0),t;}function z(t,e){var r=new f(2);return r[0]=t,r[1]=e,r;}m(),_=new f(4),f!=Float32Array&&(_[0]=0,_[1]=0,_[2]=0,_[3]=0),m(),x(1,0,0),x(0,1,0),k(),k(),d(),I();const P=8192;function C(t,e,r){return e*(P/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)));}function E(t,e){return(t%e+e)%e;}function T(t,e,r){return t*(1-r)+e*r;}function B(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75);}function V(t,e,r,n){const i=new o(t,e,r,n);return t=>i.solve(t);}const F=V(.25,.1,.25,1);function D(t,e,r){return Math.min(r,Math.max(e,t));}function $(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i;}function L(t){for(var _len=arguments.length,e=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){e[_key-1]=arguments[_key];}for(const r of e)for(const e in r)t[e]=r[e];return t;}let O=1;function R(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n;}function U(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n;}function j(t){return Array.isArray(t)?t.map(j):"object"==typeof t&&t?R(t,j):t;}const N={};function q(t){N[t]||("undefined"!=typeof console&&console.warn(t),N[t]=!0);}function G(t,e,r){return(r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x);}function X(t){return"undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope;}let Z=null;function Y(t){if(null==Z){const e=t.navigator?t.navigator.userAgent:null;Z=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return Z;}function H(t){return"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap;}const K="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function J(t,r,n,i,s){return e(this,void 0,void 0,function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const a=null==e?void 0:e.format;if(!a||!a.startsWith("BGR")&&!a.startsWith("RGB"))throw new Error(`Unrecognized format ${a}`);const o=a.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield e.copyTo(l,function(t,e,r,n,i){const s=4*Math.max(-e,0),a=(Math.max(0,r)-r)*n*4+s,o=4*n,l=Math.max(0,e),u=Math.max(0,r);return{rect:{x:l,y:u,width:Math.min(t.width,e+n)-l,height:Math.min(t.height,r+i)-u},layout:[{offset:a,stride:o}]};}(t,r,n,i,s)),o)for(let t=0;t<l.length;t+=4){const e=l[t];l[t]=l[t+2],l[t+2]=e;}return l;}finally{e.close();}});}let W,Q;function tt(t,e,r,n){return t.addEventListener(e,r,n),{unsubscribe:()=>{t.removeEventListener(e,r,n);}};}function et(t){return t*Math.PI/180;}function rt(t){return t/Math.PI*180;}const nt={touchstart:!0,touchmove:!0,touchmoveWindow:!0,touchend:!0,touchcancel:!0},it={dblclick:!0,click:!0,mouseover:!0,mouseout:!0,mousedown:!0,mousemove:!0,mousemoveWindow:!0,mouseup:!0,mouseupWindow:!0,contextmenu:!0,wheel:!0},st="AbortError";function at(){return new Error(st);}const ot={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function lt(t){return ot.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))];}const ut="global-dispatcher";class ct extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`),this.status=t,this.statusText=e,this.url=r,this.body=n;}}const ht=()=>X(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,pt=function(t,r){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const e=lt(t.url);if(e)return e(t,r);if(X(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:ut},r);}if(!(/^file:/.test(n=t.url)||/^file:/.test(ht())&&!/^\w+:/.test(n))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,r){return e(this,void 0,void 0,function*(){const e=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:ht(),signal:r.signal});let n,i;"json"!==t.type||e.headers.has("Accept")||e.headers.set("Accept","application/json");try{n=yield fetch(e);}catch(e){throw new ct(0,e.message,t.url,new Blob());}if(!n.ok){const e=yield n.blob();throw new ct(n.status,n.statusText,t.url,e);}i="arrayBuffer"===t.type||"image"===t.type?n.arrayBuffer():"json"===t.type?n.json():n.text();const s=yield i;if(r.signal.aborted)throw at();return{data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")};});}(t,r);if(X(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:ut},r);}var n;return function(t,e){return new Promise((r,n)=>{var i;const s=new XMLHttpRequest();s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(i=t.headers)||void 0===i?void 0:i.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{n(new Error(s.statusText));},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response);}catch(t){return void n(t);}r({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")});}else{const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});n(new ct(s.status,s.statusText,t.url,e));}},e.signal.addEventListener("abort",()=>{s.abort(),n(at());}),s.send(t.body);});}(t,r);};function ft(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return!0;const e=new URL(t),r=window.location;return e.protocol===r.protocol&&e.host===r.host;}function dt(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function yt(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class mt{constructor(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};L(this,e),this.type=t;}}class gt extends mt{constructor(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};super("error",L({error:t},e));}}class xt{on(t,e){return this._listeners=this._listeners||{},dt(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e);}};}off(t,e){return yt(t,e,this._listeners),yt(t,e,this._oneTimeListeners),this;}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},dt(t,e,this._oneTimeListeners),this):new Promise(e=>this.once(t,e));}fire(t,e){"string"==typeof t&&(t=new mt(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)yt(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(L(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof gt&&console.error(t.error);return this;}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t);}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this;}}var vt={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},"font-faces":{type:"array",value:"fontFaces"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},encoding:{type:"enum",values:{mvt:{},mlt:{}},default:"mvt"},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const bt=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function wt(t,e){const r={};for(const e in t)"ref"!==e&&(r[e]=t[e]);return bt.forEach(t=>{t in e&&(r[t]=e[t]);}),r;}function _t(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let r=0;r<t.length;r++)if(!_t(t[r],e[r]))return!1;return!0;}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const r in t)if(!_t(t[r],e[r]))return!1;return!0;}return t===e;}function St(t,e){t.push(e);}function At(t,e,r){St(r,{command:"addSource",args:[t,e[t]]});}function kt(t,e,r){St(e,{command:"removeSource",args:[t]}),r[t]=!0;}function Mt(t,e,r,n){kt(t,r,n),At(t,e,r);}function It(t,e,r){let n;for(n in t[r])if(Object.prototype.hasOwnProperty.call(t[r],n)&&"data"!==n&&!_t(t[r][n],e[r][n]))return!1;for(n in e[r])if(Object.prototype.hasOwnProperty.call(e[r],n)&&"data"!==n&&!_t(t[r][n],e[r][n]))return!1;return!0;}function zt(t,e,r,n,i,s){t=t||{},e=e||{};for(const a in t)Object.prototype.hasOwnProperty.call(t,a)&&(_t(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));for(const a in e)Object.prototype.hasOwnProperty.call(e,a)&&!Object.prototype.hasOwnProperty.call(t,a)&&(_t(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));}function Pt(t){return t.id;}function Ct(t,e){return t[e.id]=e,t;}class Et{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function Tt(t){for(var _len2=arguments.length,e=new Array(_len2>1?_len2-1:0),_key2=1;_key2<_len2;_key2++){e[_key2-1]=arguments[_key2];}for(const r of e)for(const e in r)t[e]=r[e];return t;}class Bt extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Vt{constructor(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:[];this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Vt(this,t);}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`);}has(t){return!!this.bindings[t]||!!this.parent&&this.parent.has(t);}}const Ft={kind:"null"},Dt={kind:"number"},$t={kind:"string"},Lt={kind:"boolean"},Ot={kind:"color"},Rt={kind:"projectionDefinition"},Ut={kind:"object"},jt={kind:"value"},Nt={kind:"collator"},qt={kind:"formatted"},Gt={kind:"padding"},Xt={kind:"colorArray"},Zt={kind:"numberArray"},Yt={kind:"resolvedImage"},Ht={kind:"variableAnchorOffsetCollection"};function Kt(t,e){return{kind:"array",itemType:t,N:e};}function Jt(t){if("array"===t.kind){const e=Jt(t.itemType);return"number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`;}return t.kind;}const Wt=[Ft,Dt,$t,Lt,Ot,Rt,qt,Ut,Kt(jt),Gt,Zt,Xt,Yt,Ht];function Qt(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!Qt(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null;}else{if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Wt)if(!Qt(t,e))return null;}return`Expected ${Jt(t)} but found ${Jt(e)} instead.`;}function te(t,e){return e.some(e=>e.kind===t.kind);}function ee(t,e){return e.some(e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t);}function re(t,e){return"array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind;}const ne=.96422,ie=.82521,se=4/29,ae=6/29,oe=3*ae*ae,le=ae*ae*ae,ue=Math.PI/180,ce=180/Math.PI;function he(t){return(t%=360)<0&&(t+=360),t;}function pe(_ref){let[t,e,r,n]=_ref;let i,s;const a=de((.2225045*(t=fe(t))+.7168786*(e=fe(e))+.0606169*(r=fe(r)))/1);t===e&&e===r?i=s=a:(i=de((.4360747*t+.3850649*e+.1430804*r)/ne),s=de((.0139322*t+.0971045*e+.7141733*r)/ie));const o=116*a-16;return[o<0?0:o,500*(i-a),200*(a-s),n];}function fe(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4);}function de(t){return t>le?Math.pow(t,1/3):t/oe+se;}function ye(_ref2){let[t,e,r,n]=_ref2;let i=(t+16)/116,s=isNaN(e)?i:i+e/500,a=isNaN(r)?i:i-r/200;return i=1*ge(i),s=ne*ge(s),a=ie*ge(a),[me(3.1338561*s-1.6168667*i-.4906146*a),me(-.9787684*s+1.9161415*i+.033454*a),me(.0719453*s-.2289914*i+1.4052427*a),n];}function me(t){return(t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t;}function ge(t){return t>ae?t*t*t:oe*(t-se);}const xe=Object.hasOwn||function(t,e){return Object.prototype.hasOwnProperty.call(t,e);};function ve(t,e){return xe(t,e)?t[e]:void 0;}function be(t){return parseInt(t.padEnd(2,t),16)/255;}function we(t,e){return _e(e?t/100:t,0,1);}function _e(t,e,r){return Math.min(Math.max(e,t),r);}function Se(t){return!t.some(Number.isNaN);}const Ae={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function ke(t,e,r){return t+r*(e-t);}function Me(t,e,r){return t.map((t,n)=>ke(t,e[n],r));}class Ie{constructor(t,e,r){let n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:1;let i=arguments.length>4&&arguments[4]!==undefined?arguments[4]:!0;this.r=t,this.g=e,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[t,e,r,n]));}static parse(t){if(t instanceof Ie)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];const e=ve(Ae,t);if(e){const[t,r,n]=e;return[t/255,r/255,n/255,1];}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let r=1;return[be(t.slice(r,r+=e)),be(t.slice(r,r+=e)),be(t.slice(r,r+=e)),be(t.slice(r,r+e)||"ff")];}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,r,n,i,s,a,o,l,u,c,h,p]=e,f=[i||" ",o||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const t=[n,a,u].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[_e(+r/e,0,1),_e(+s/e,0,1),_e(+l/e,0,1),h?we(+h,p):1];if(Se(t))return t;}}return;}}const r=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[t,e,n,i,s,a,o,l,u]=r,c=[n||" ",s||" ",o].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const t=[+e,_e(+i,0,100),_e(+a,0,100),l?we(+l,u):1];if(Se(t))return function(_ref3){let[t,e,r,n]=_ref3;function i(n){const i=(n+t/30)%12,s=e*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1));}return t=he(t),e/=100,r/=100,[i(0),i(8),i(4),n];}(t);}}}(t);return e?new Ie(...e,!1):void 0;}get rgb(){const{r:t,g:e,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[t/i,e/i,r/i,n]);}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,r,n,i]=pe(t),s=Math.sqrt(r*r+n*n);return[Math.round(1e4*s)?he(Math.atan2(n,r)*ce):NaN,s,e,i];}(this.rgb));}get lab(){return this.overwriteGetter("lab",pe(this.rgb));}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e;}toString(){const[t,e,r,n]=this.rgb;return`rgba(${[t,e,r].map(t=>Math.round(255*t)).join(",")},${n})`;}static interpolate(t,e,r){let n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:"rgb";switch(n){case"rgb":{const[n,i,s,a]=Me(t.rgb,e.rgb,r);return new Ie(n,i,s,a,!1);}case"hcl":{const[n,i,s,a]=t.hcl,[o,l,u,c]=e.hcl;let h,p;if(isNaN(n)||isNaN(o))isNaN(n)?isNaN(o)?h=NaN:(h=o,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else{let t=o-n;o>n&&t>180?t-=360:o<n&&n-o>180&&(t+=360),h=n+r*t;}const[f,d,y,m]=function(_ref4){let[t,e,r,n]=_ref4;return t=isNaN(t)?0:t*ue,ye([r,Math.cos(t)*e,Math.sin(t)*e,n]);}([h,null!=p?p:ke(i,l,r),ke(s,u,r),ke(a,c,r)]);return new Ie(f,d,y,m,!1);}case"lab":{const[n,i,s,a]=ye(Me(t.lab,e.lab,r));return new Ie(n,i,s,a,!1);}}}}Ie.black=new Ie(0,0,0,1),Ie.white=new Ie(1,1,1,1),Ie.transparent=new Ie(0,0,0,0),Ie.red=new Ie(1,0,0,1);class ze{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e);}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale;}}const Pe=["bottom","center","top"];class Ce{constructor(t,e,r,n,i,s){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i,this.verticalAlign=s;}}class Ee{constructor(t){this.sections=t;}static fromString(t){return new Ee([new Ce(t,null,null,null,null,null)]);}isEmpty(){return 0===this.sections.length||!this.sections.some(t=>0!==t.text.length||t.image&&0!==t.image.name.length);}static factory(t){return t instanceof Ee?t:Ee.fromString(t);}toString(){return 0===this.sections.length?"":this.sections.map(t=>t.text).join("");}}class Te{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Te)return t;if("number"==typeof t)return new Te([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]];}return new Te(t);}}toString(){return JSON.stringify(this.values);}static interpolate(t,e,r){return new Te(Me(t.values,e.values,r));}}class Be{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Be)return t;if("number"==typeof t)return new Be([t]);if(Array.isArray(t)){for(const e of t)if("number"!=typeof e)return;return new Be(t);}}toString(){return JSON.stringify(this.values);}static interpolate(t,e,r){return new Be(Me(t.values,e.values,r));}}class Ve{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Ve)return t;if("string"==typeof t){const e=Ie.parse(t);if(!e)return;return new Ve([e]);}if(!Array.isArray(t))return;const e=[];for(const r of t){if("string"!=typeof r)return;const t=Ie.parse(r);if(!t)return;e.push(t);}return new Ve(e);}toString(){return JSON.stringify(this.values);}static interpolate(t,e,r){let n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:"rgb";const i=[];if(t.values.length!=e.values.length)throw new Error(`colorArray: Arrays have mismatched length (${t.values.length} vs. ${e.values.length}), cannot interpolate.`);for(let s=0;s<t.values.length;s++)i.push(Ie.interpolate(t.values[s],e.values[s],r,n));return new Ve(i);}}class Fe extends Error{constructor(t){super(t),this.name="RuntimeError";}toJSON(){return this.message;}}const De=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class $e{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof $e)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];if("string"!=typeof r||!De.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return;}return new $e(t);}}toString(){return JSON.stringify(this.values);}static interpolate(t,e,r){const n=t.values,i=e.values;if(n.length!==i.length)throw new Fe(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<n.length;t+=2){if(n[t]!==i[t])throw new Fe(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${n[t]}, to[${t}]: ${i[t]}`);s.push(n[t]);const[e,a]=n[t+1],[o,l]=i[t+1];s.push([ke(e,o,r),ke(a,l,r)]);}return new $e(s);}}class Le{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name;}static fromString(t){return t?new Le({name:t,available:!1}):null;}}class Oe{constructor(t,e,r){this.from=t,this.to=e,this.transition=r;}static interpolate(t,e,r){return new Oe(t,e,r);}static parse(t){return t instanceof Oe?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new Oe(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new Oe(t.from,t.to,t.transition):"string"==typeof t?new Oe(t,t,1):void 0;}}function Re(t,e,r,n){return"number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`;}function Ue(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof Oe||t instanceof Ie||t instanceof ze||t instanceof Ee||t instanceof Te||t instanceof Be||t instanceof Ve||t instanceof $e||t instanceof Le)return!0;if(Array.isArray(t)){for(const e of t)if(!Ue(e))return!1;return!0;}if("object"==typeof t){for(const e in t)if(!Ue(t[e]))return!1;return!0;}return!1;}function je(t){if(null===t)return Ft;if("string"==typeof t)return $t;if("boolean"==typeof t)return Lt;if("number"==typeof t)return Dt;if(t instanceof Ie)return Ot;if(t instanceof Oe)return Rt;if(t instanceof ze)return Nt;if(t instanceof Ee)return qt;if(t instanceof Te)return Gt;if(t instanceof Be)return Zt;if(t instanceof Ve)return Xt;if(t instanceof $e)return Ht;if(t instanceof Le)return Yt;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=je(e);if(r){if(r===t)continue;r=jt;break;}r=t;}return Kt(r||jt,e);}return Ut;}function Ne(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Ie||t instanceof Oe||t instanceof Ee||t instanceof Te||t instanceof Be||t instanceof Ve||t instanceof $e||t instanceof Le?t.toString():JSON.stringify(t);}class qe{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Ue(t[1]))return e.error("invalid value");const r=t[1];let n=je(r);const i=e.expectedType;return"array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new qe(n,r);}evaluate(){return this.value;}eachChild(){}outputDefined(){return!0;}}const Ge={string:$t,number:Dt,boolean:Lt,object:Ut};class Xe{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in Ge)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=Ge[r],n++;}else i=jt;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=Kt(i,s);}else{if(!Ge[i])throw new Error(`Types doesn't contain name = ${i}`);r=Ge[i];}const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,jt);if(!r)return null;s.push(r);}return new Xe(r,s);}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!Qt(this.type,je(r)))return r;if(e===this.args.length-1)throw new Fe(`Expected value to be of type ${Jt(this.type)}, but found ${Jt(je(r))} instead.`);}throw new Error();}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every(t=>t.outputDefined());}}const Ze={"to-boolean":Lt,"to-color":Ot,"to-number":Dt,"to-string":$t};class Ye{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!Ze[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=Ze[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,jt);if(!n)return null;i.push(n);}return new Ye(n,i);}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof Ie)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r;}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Re(e[0],e[1],e[2],e[3]),!r))return new Ie(e[0]/255,e[1]/255,e[2]/255,e[3]);}throw new Fe(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`);}case"padding":{let e;for(const r of this.args){e=r.evaluate(t);const n=Te.parse(e);if(n)return n;}throw new Fe(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`);}case"numberArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Be.parse(e);if(n)return n;}throw new Fe(`Could not parse numberArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`);}case"colorArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Ve.parse(e);if(n)return n;}throw new Fe(`Could not parse colorArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`);}case"variableAnchorOffsetCollection":{let e;for(const r of this.args){e=r.evaluate(t);const n=$e.parse(e);if(n)return n;}throw new Fe(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`);}case"number":{let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n;}throw new Fe(`Could not convert ${JSON.stringify(e)} to number.`);}case"formatted":return Ee.fromString(Ne(this.args[0].evaluate(t)));case"resolvedImage":return Le.fromString(Ne(this.args[0].evaluate(t)));case"projectionDefinition":return this.args[0].evaluate(t);default:return Ne(this.args[0].evaluate(t));}}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every(t=>t.outputDefined());}}const He=["Unknown","Point","LineString","Polygon"];class Ke{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map(),this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null;}geometryType(){return this.feature?"number"==typeof this.feature.type?He[this.feature.type]:this.feature.type:null;}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null;}canonicalID(){return this.canonical;}properties(){return this.feature&&this.feature.properties||{};}parseColor(t){let e=this._parseColorCache.get(t);return e||(e=Ie.parse(t),this._parseColorCache.set(t,e)),e;}}class Je{constructor(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:[];let n=arguments.length>3?arguments[3]:undefined;let i=arguments.length>4&&arguments[4]!==undefined?arguments[4]:new Vt();let s=arguments.length>5&&arguments[5]!==undefined?arguments[5]:[];this.registry=t,this.path=r,this.key=r.map(t=>`[${t}]`).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=e;}parse(t,e,r,n){let i=arguments.length>4&&arguments[4]!==undefined?arguments[4]:{};return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i);}_parse(t,e){function r(t,e,r){return"assert"===r?new Xe(e,[t]):"coerce"===r?new Ye(e,[t]):t;}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind){if("projectionDefinition"===t.kind&&["string","array"].includes(i.kind)||["color","formatted","resolvedImage"].includes(t.kind)&&["value","string"].includes(i.kind)||["padding","numberArray"].includes(t.kind)&&["value","number","array"].includes(i.kind)||"colorArray"===t.kind&&["value","string","array"].includes(i.kind)||"variableAnchorOffsetCollection"===t.kind&&["value","array"].includes(i.kind))n=r(n,t,e.typeAnnotation||"coerce");else if(this.checkSubtype(t,i))return null;}else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof qe)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const t=new Ke();try{n=new qe(n.type,n.evaluate(t));}catch(t){return this.error(t.message),null;}}return n;}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0);}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`);}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new Je(this.registry,this._isConstant,n,e||null,i,this.errors);}error(t){for(var _len3=arguments.length,e=new Array(_len3>1?_len3-1:0),_key3=1;_key3<_len3;_key3++){e[_key3-1]=arguments[_key3];}const r=`${this.key}${e.map(t=>`[${t}]`).join("")}`;this.errors.push(new Bt(r,t));}checkSubtype(t,e){const r=Qt(t,e);return r&&this.error(r),r;}}class We{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t);}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new We(r,n):null;}outputDefined(){return this.result.outputDefined();}}class Qe{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Qe(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1);}evaluate(t){return this.boundExpression.evaluate(t);}eachChild(){}outputDefined(){return!1;}}class tr{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Dt),n=e.parse(t[2],2,Kt(e.expectedType||jt));return r&&n?new tr(n.type.itemType,r,n):null;}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Fe(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new Fe(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new Fe(`Array index must be an integer, but found ${e} instead.`);return r[e];}eachChild(t){t(this.index),t(this.input);}outputDefined(){return!1;}}class er{constructor(t,e){this.type=Lt,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,jt),n=e.parse(t[2],2,jt);return r&&n?te(r.type,[Lt,$t,Dt,Ft,jt])?new er(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Jt(r.type)} instead`):null;}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return!1;if(!ee(e,["boolean","string","number","null"]))throw new Fe(`Expected first argument to be of type boolean, string, number or null, but found ${Jt(je(e))} instead.`);if(!ee(r,["string","array"]))throw new Fe(`Expected second argument to be of type array or string, but found ${Jt(je(r))} instead.`);return r.indexOf(e)>=0;}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return!0;}}class rr{constructor(t,e,r){this.type=Dt,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,jt),n=e.parse(t[2],2,jt);if(!r||!n)return null;if(!te(r.type,[Lt,$t,Dt,Ft,jt]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Jt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Dt);return i?new rr(r,n,i):null;}return new rr(r,n);}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!ee(e,["boolean","string","number","null"]))throw new Fe(`Expected first argument to be of type boolean, string, number or null, but found ${Jt(je(e))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(t)),ee(r,["string"])){const t=r.indexOf(e,n);return-1===t?-1:[...r.slice(0,t)].length;}if(ee(r,["array"]))return r.indexOf(e,n);throw new Fe(`Expected second argument to be of type array or string, but found ${Jt(je(r))} instead.`);}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return!1;}}class nr{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,je(t)))return null;}else r=je(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,jt);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new nr(r,n,a,i,s,o):null;}evaluate(t){const e=this.input.evaluate(t);return(je(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t);}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every(t=>t.outputDefined())&&this.otherwise.outputDefined();}}class ir{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,Lt);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new ir(r,n,i);}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t);}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every(_ref5=>{let[t,e]=_ref5;return e.outputDefined();})&&this.otherwise.outputDefined();}}class sr{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,jt),n=e.parse(t[2],2,Dt);if(!r||!n)return null;if(!te(r.type,[Kt(jt),$t,jt]))return e.error(`Expected first argument to be of type array or string, but found ${Jt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Dt);return i?new sr(r.type,r,n,i):null;}return new sr(r.type,r,n);}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);let n;if(this.endIndex&&(n=this.endIndex.evaluate(t)),ee(e,["string"]))return[...e].slice(r,n).join("");if(ee(e,["array"]))return e.slice(r,n);throw new Fe(`Expected first argument to be of type array or string, but found ${Jt(je(e))} instead.`);}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return!1;}}function ar(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else{if(!(n>e))throw new Fe("Input is not a number.");a=o-1;}return 0;}class or{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,Dt);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new or(i,r,n);}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[ar(e,n)].evaluate(t);}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every(t=>t.outputDefined());}}function lr(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t;}var ur,cr,hr=function(){if(cr)return ur;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return cr=1,ur=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t;},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t;},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx;},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r;},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e));}},ur;}(),pr=lr(hr);class fr{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=dr(e,t.base,r,n);else if("linear"===t.name)i=dr(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new pr(s[0],s[1],s[2],s[3]).solve(dr(e,1,r,n));}return i;}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else{if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some(t=>"number"!=typeof t||t<0||t>1))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,Dt),!i)return null;const a=[];let o=null;"interpolate-hcl"!==r&&"interpolate-lab"!==r||e.expectedType==Xt?e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType):o=Ot;for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return re(o,Dt)||re(o,Rt)||re(o,Ot)||re(o,Gt)||re(o,Zt)||re(o,Xt)||re(o,Ht)||re(o,Kt(Dt))?new fr(o,r,n,i,a):e.error(`Type ${Jt(o)} is not interpolatable.`);}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=ar(e,n),a=fr.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return ke(o,l,a);case"color":return Ie.interpolate(o,l,a);case"padding":return Te.interpolate(o,l,a);case"colorArray":return Ve.interpolate(o,l,a);case"numberArray":return Be.interpolate(o,l,a);case"variableAnchorOffsetCollection":return $e.interpolate(o,l,a);case"array":return Me(o,l,a);case"projectionDefinition":return Oe.interpolate(o,l,a);}case"interpolate-hcl":switch(this.type.kind){case"color":return Ie.interpolate(o,l,a,"hcl");case"colorArray":return Ve.interpolate(o,l,a,"hcl");}case"interpolate-lab":switch(this.type.kind){case"color":return Ie.interpolate(o,l,a,"lab");case"colorArray":return Ve.interpolate(o,l,a,"lab");}}}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every(t=>t.outputDefined());}}function dr(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1);}const yr={color:Ie.interpolate,number:ke,padding:Te.interpolate,numberArray:Be.interpolate,colorArray:Ve.interpolate,variableAnchorOffsetCollection:$e.interpolate,array:Me};class mr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}if(!r)throw new Error("No output type");const s=n&&i.some(t=>Qt(n,t.type));return new mr(s?jt:r,i);}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(t),r&&r instanceof Le&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r;}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every(t=>t.outputDefined());}}function gr(t,e){return"=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind;}function xr(t,e,r,n){return 0===n.compare(e,r);}function vr(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=Lt,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,jt);if(!s)return null;if(!gr(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${Jt(s.type)}'.`);let a=e.parse(t[2],2,jt);if(!a)return null;if(!gr(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${Jt(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${Jt(s.type)}' and '${Jt(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new Xe(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new Xe(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,Nt),!o)return null;}return new i(s,a,o);}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=je(s),r=je(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new Fe(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`);}if(this.collator&&!n&&this.hasUntypedArgument){const t=je(s),r=je(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a);}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a);}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return!0;}};}const br=vr("==",function(t,e,r){return e===r;},xr),wr=vr("!=",function(t,e,r){return e!==r;},function(t,e,r,n){return!xr(0,e,r,n);}),_r=vr("<",function(t,e,r){return e<r;},function(t,e,r,n){return n.compare(e,r)<0;}),Sr=vr(">",function(t,e,r){return e>r;},function(t,e,r,n){return n.compare(e,r)>0;}),Ar=vr("<=",function(t,e,r){return e<=r;},function(t,e,r,n){return n.compare(e,r)<=0;}),kr=vr(">=",function(t,e,r){return e>=r;},function(t,e,r,n){return n.compare(e,r)>=0;});class Mr{constructor(t,e,r){this.type=Nt,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,Lt);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,Lt);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,$t),!s)?null:new Mr(n,i,s);}evaluate(t){return new ze(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null);}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return!1;}}class Ir{constructor(t,e,r,n,i){this.type=$t,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Dt);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,$t),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,$t),!s))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parse(n["min-fraction-digits"],1,Dt),!a))return null;let o=null;return n["max-fraction-digits"]&&(o=e.parse(n["max-fraction-digits"],1,Dt),!o)?null:new Ir(r,i,s,a,o);}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t));}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return!1;}}class zr{constructor(t){this.type=qt,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Dt),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,Kt($t)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,Ot),!a))return null;let o=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!Pe.includes(s["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(o=e.parse(s["vertical-align"],1,$t),!o)return null;}const l=n[n.length-1];l.scale=t,l.font=r,l.textColor=a,l.verticalAlign=o;}else{const s=e.parse(t[r],1,jt);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null});}}return new zr(n);}evaluate(t){return new Ee(this.sections.map(e=>{const r=e.content.evaluate(t);return je(r)===Yt?new Ce("",r,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new Ce(Ne(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null);}));}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign);}outputDefined(){return!1;}}class Pr{constructor(t){this.type=Yt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,$t);return r?new Pr(r):e.error("No image name provided.");}evaluate(t){const e=this.input.evaluate(t),r=Le.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r;}eachChild(t){t(this.input);}outputDefined(){return!1;}}class Cr{constructor(t){this.type=Dt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${Jt(r.type)} instead.`):new Cr(r):null;}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return[...e].length;if(Array.isArray(e))return e.length;throw new Fe(`Expected value to be of type string or array, but found ${Jt(je(e))} instead.`);}eachChild(t){t(this.input);}outputDefined(){return!1;}}const Er=8192;function Tr(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return[Math.round(r*i*Er),Math.round(n*i*Er)];}function Br(t,e){const r=Math.pow(2,e.z);return[(i=(t[0]/Er+e.x)/r,360*i-180),(n=(t[1]/Er+e.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];// removed by dead control flow
 var n, i; }function Vr(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function Fr(t,e){return!(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3]);}function Dr(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0;}function $r(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!Nr(t,e,r,n)||!Nr(r,n,t,e));// removed by dead control flow
 var i, s; }function Lr(t,e,r){for(const n of r)for(let r=0;r<n.length-1;++r)if($r(t,e,n[r],n[r+1]))return!0;return!1;}function Or(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:!1;let n=!1;for(const o of e)for(let e=0;e<o.length-1;e++){if(Dr(t,o[e],o[e+1]))return r;(s=o[e])[1]>(i=t)[1]!=(a=o[e+1])[1]>i[1]&&i[0]<(a[0]-s[0])*(i[1]-s[1])/(a[1]-s[1])+s[0]&&(n=!n);}var i,s,a;return n;}function Rr(t,e){for(const r of e)if(Or(t,r))return!0;return!1;}function Ur(t,e){for(const r of t)if(!Or(r,e))return!1;for(let r=0;r<t.length-1;++r)if(Lr(t[r],t[r+1],e))return!1;return!0;}function jr(t,e){for(const r of e)if(Ur(t,r))return!0;return!1;}function Nr(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0;}function qr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=Tr(t[i][n],r);Vr(e,a),s.push(a);}n.push(s);}return n;}function Gr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=qr(t[i],e,r);n.push(s);}return n;}function Xr(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}Vr(e,t);}function Zr(t,e,r,n){const i=Math.pow(2,n.z)*Er,s=[n.x*Er,n.y*Er],a=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Xr(n,e,r,i),a.push(n);}return a;}function Yr(t,e,r,n){const i=Math.pow(2,n.z)*Er,s=[n.x*Er,n.y*Er],a=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Vr(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)Xr(n,e,r,i);}var o;return a;}class Hr{constructor(t,e){this.type=Lt,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Ue(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const r of e.features){const{type:e,coordinates:n}=r.geometry;"Polygon"===e&&t.push(n),"MultiPolygon"===e&&t.push(...n);}if(t.length)return new Hr(e,{type:"MultiPolygon",coordinates:t});}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Hr(e,e.geometry);}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Hr(e,e);}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.");}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=qr(e.coordinates,n,i),a=Zr(t.geometry(),r,n,i);if(!Fr(r,n))return!1;for(const t of a)if(!Or(t,s))return!1;}if("MultiPolygon"===e.type){const s=Gr(e.coordinates,n,i),a=Zr(t.geometry(),r,n,i);if(!Fr(r,n))return!1;for(const t of a)if(!Rr(t,s))return!1;}return!0;}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=qr(e.coordinates,n,i),a=Yr(t.geometry(),r,n,i);if(!Fr(r,n))return!1;for(const t of a)if(!Ur(t,s))return!1;}if("MultiPolygon"===e.type){const s=Gr(e.coordinates,n,i),a=Yr(t.geometry(),r,n,i);if(!Fr(r,n))return!1;for(const t of a)if(!jr(t,s))return!1;}return!0;}(t,this.geometries);}return!1;}eachChild(){}outputDefined(){return!0;}}let Kr=class{constructor(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:(t,e)=>t<e?-1:t>e?1:0;if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t;}peek(){return this.data[0];}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}};function Jr(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:0;let n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:t.length-1;let i=arguments.length>4&&arguments[4]!==undefined?arguments[4]:Qr;for(;n>r;){if(n-r>600){const s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);Jr(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}const s=t[e];let a=r,o=n;for(Wr(t,r,e),i(t[n],s)>0&&Wr(t,r,n);a<o;){for(Wr(t,a,o),a++,o--;i(t[a],s)<0;)a++;for(;i(t[o],s)>0;)o--;}0===i(t[r],s)?Wr(t,r,o):(o++,Wr(t,o,n)),o<=e&&(r=o+1),e<=o&&(n=o-1);}}function Wr(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Qr(t,e){return t<e?-1:t>e?1:0;}function tn(t,e){if(t.length<=1)return[t];const r=[];let n,i;for(const e of t){const t=rn(e);0!==t&&(e.area=Math.abs(t),void 0===i&&(i=t<0),i===t<0?(n&&r.push(n),n=[e]):n.push(e));}if(n&&r.push(n),e>1)for(let t=0;t<r.length;t++)r[t].length<=e||(Jr(r[t],e,1,r[t].length-1,en),r[t]=r[t].slice(0,e));return r;}function en(t,e){return e.area-t.area;}function rn(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e;}const nn=1/298.257223563,sn=nn*(2-nn),an=Math.PI/180;class on{constructor(t){const e=6378.137*an*1e3,r=Math.cos(t*an),n=1/(1-sn*(1-r*r)),i=Math.sqrt(n);this.kx=e*i*r,this.ky=e*i*n*(1-sn);}distance(t,e){const r=this.wrap(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n);}pointOnLine(t,e){let r,n,i,s,a=1/0;for(let o=0;o<t.length-1;o++){let l=t[o][0],u=t[o][1],c=this.wrap(t[o+1][0]-l)*this.kx,h=(t[o+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(this.wrap(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[o+1][0],u=t[o+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=this.wrap(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<a&&(a=f,r=l,n=u,i=o,s=p);}return{point:[r,n],index:i,t:Math.max(0,Math.min(1,s))};}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t;}}function ln(t,e){return e[0]-t[0];}function un(t){return t[1]-t[0]+1;}function cn(t,e){return t[1]>=t[0]&&t[1]<e;}function hn(t,e){if(t[0]>t[1])return[null,null];const r=un(t);if(e){if(2===r)return[t,null];const e=Math.floor(r/2);return[[t[0],t[0]+e],[t[0]+e,t[1]]];}if(1===r)return[t,null];const n=Math.floor(r/2)-1;return[[t[0],t[0]+n],[t[0]+n+1,t[1]]];}function pn(t,e){if(!cn(e,t.length))return[1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=e[0];n<=e[1];++n)Vr(r,t[n]);return r;}function fn(t){const e=[1/0,1/0,-1/0,-1/0];for(const r of t)for(const t of r)Vr(e,t);return e;}function dn(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0;}function yn(t,e,r){if(!dn(t)||!dn(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i]);}function mn(t,e,r){const n=r.pointOnLine(e,t);return r.distance(t,n.point);}function gn(t,e,r,n,i){const s=Math.min(mn(t,[r,n],i),mn(e,[r,n],i)),a=Math.min(mn(r,[t,e],i),mn(n,[t,e],i));return Math.min(s,a);}function xn(t,e,r,n,i){if(!cn(e,t.length)||!cn(n,r.length))return 1/0;let s=1/0;for(let a=e[0];a<e[1];++a){const e=t[a],o=t[a+1];for(let t=n[0];t<n[1];++t){const n=r[t],a=r[t+1];if($r(e,o,n,a))return 0;s=Math.min(s,gn(e,o,n,a,i));}}return s;}function vn(t,e,r,n,i){if(!cn(e,t.length)||!cn(n,r.length))return NaN;let s=1/0;for(let a=e[0];a<=e[1];++a)for(let e=n[0];e<=n[1];++e)if(s=Math.min(s,i.distance(t[a],r[e])),0===s)return s;return s;}function bn(t,e,r){if(Or(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i[0],s=i[i.length-1];if(e!==s&&(n=Math.min(n,mn(t,[s,e],r)),0===n))return n;const a=r.pointOnLine(i,t);if(n=Math.min(n,r.distance(t,a.point)),0===n)return n;}return n;}function wn(t,e,r,n){if(!cn(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(Or(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],a=t[s+1];for(const t of r)for(let r=0,s=t.length,o=s-1;r<s;o=r++){const s=t[o],l=t[r];if($r(e,a,s,l))return 0;i=Math.min(i,gn(e,a,s,l,n));}}return i;}function _n(t,e){for(const r of t)for(const t of r)if(Or(t,e,!0))return!0;return!1;}function Sn(t,e,r){let n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:1/0;const i=fn(t),s=fn(e);if(n!==1/0&&yn(i,s,r)>=n)return n;if(Fr(i,s)){if(_n(t,e))return 0;}else if(_n(e,t))return 0;let a=1/0;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++){const i=n[s],o=n[t];for(const t of e)for(let e=0,n=t.length,s=n-1;e<n;s=e++){const n=t[s],l=t[e];if($r(i,o,n,l))return 0;a=Math.min(a,gn(i,o,n,l,r));}}return a;}function An(t,e,r,n,i,s){if(!s)return;const a=yn(pn(n,s),i,r);a<e&&t.push([a,s,[0,0]]);}function kn(t,e,r,n,i,s,a){if(!s||!a)return;const o=yn(pn(n,s),pn(i,a),r);o<e&&t.push([o,s,a]);}function Mn(t,e,r,n){let i=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1/0;let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const a=new Kr([[0,[0,t.length-1],[0,0]]],ln),o=fn(r);for(;a.length>0;){const i=a.pop();if(i[0]>=s)continue;const l=i[1],u=e?50:100;if(un(l)<=u){if(!cn(l,t.length))return NaN;if(e){const e=wn(t,l,r,n);if(isNaN(e)||0===e)return e;s=Math.min(s,e);}else for(let e=l[0];e<=l[1];++e){const i=bn(t[e],r,n);if(s=Math.min(s,i),0===s)return 0;}}else{const r=hn(l,e);An(a,s,n,t,o,r[0]),An(a,s,n,t,o,r[1]);}}return s;}function In(t,e,r,n,i){let s=arguments.length>5&&arguments[5]!==undefined?arguments[5]:1/0;let a=Math.min(s,i.distance(t[0],r[0]));if(0===a)return a;const o=new Kr([[0,[0,t.length-1],[0,r.length-1]]],ln);for(;o.length>0;){const s=o.pop();if(s[0]>=a)continue;const l=s[1],u=s[2],c=e?50:100,h=n?50:100;if(un(l)<=c&&un(u)<=h){if(!cn(l,t.length)&&cn(u,r.length))return NaN;let s;if(e&&n)s=xn(t,l,r,u,i),a=Math.min(a,s);else if(e&&!n){const e=t.slice(l[0],l[1]+1);for(let t=u[0];t<=u[1];++t)if(s=mn(r[t],e,i),a=Math.min(a,s),0===a)return a;}else if(!e&&n){const e=r.slice(u[0],u[1]+1);for(let r=l[0];r<=l[1];++r)if(s=mn(t[r],e,i),a=Math.min(a,s),0===a)return a;}else s=vn(t,l,r,u,i),a=Math.min(a,s);}else{const s=hn(l,e),c=hn(u,n);kn(o,a,i,t,r,s[0],c[0]),kn(o,a,i,t,r,s[0],c[1]),kn(o,a,i,t,r,s[1],c[0]),kn(o,a,i,t,r,s[1],c[1]);}}return a;}function zn(t){return"MultiPolygon"===t.type?t.coordinates.map(t=>({type:"Polygon",coordinates:t})):"MultiLineString"===t.type?t.coordinates.map(t=>({type:"LineString",coordinates:t})):"MultiPoint"===t.type?t.coordinates.map(t=>({type:"Point",coordinates:t})):[t];}class Pn{constructor(t,e){this.type=Dt,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Ue(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new Pn(e,e.features.map(t=>zn(t.geometry)).flat());if("Feature"===e.type)return new Pn(e,zn(e.geometry));if("type"in e&&"coordinates"in e)return new Pn(e,zn(e));}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.");}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map(e=>Br([e.x,e.y],t.canonical));if(0===r.length)return NaN;const i=new on(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,In(n,!1,[t.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,In(n,!1,t.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,Mn(n,!1,t.coordinates,i,s));}if(0===s)return s;}return s;}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map(e=>Br([e.x,e.y],t.canonical));if(0===r.length)return NaN;const i=new on(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,In(n,!0,[t.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,In(n,!0,t.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,Mn(n,!0,t.coordinates,i,s));}if(0===s)return s;}return s;}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const r=t.geometry();if(0===r.length||0===r[0].length)return NaN;const n=tn(r,0).map(e=>e.map(e=>e.map(e=>Br([e.x,e.y],t.canonical)))),i=new on(n[0][0][0][1]);let s=1/0;for(const t of e)for(const e of n){switch(t.type){case"Point":s=Math.min(s,Mn([t.coordinates],!1,e,i,s));break;case"LineString":s=Math.min(s,Mn(t.coordinates,!0,e,i,s));break;case"Polygon":s=Math.min(s,Sn(e,t.coordinates,i,s));}if(0===s)return s;}return s;}(t,this.geometries);}return NaN;}eachChild(){}outputDefined(){return!0;}}class Cn{constructor(t){this.type=jt,this.key=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=t[1];return null==r?e.error("Global state property must be defined."):"string"!=typeof r?e.error(`Global state property must be string, but found ${typeof t[1]} instead.`):new Cn(r);}evaluate(t){var e;const r=null===(e=t.globals)||void 0===e?void 0:e.globalState;return r&&0!==Object.keys(r).length?ve(r,this.key):null;}eachChild(){}outputDefined(){return!1;}}const En={"==":br,"!=":wr,">":Sr,"<":_r,">=":kr,"<=":Ar,array:Xe,at:tr,boolean:Xe,case:ir,coalesce:mr,collator:Mr,format:zr,image:Pr,in:er,"index-of":rr,interpolate:fr,"interpolate-hcl":fr,"interpolate-lab":fr,length:Cr,let:We,literal:qe,match:nr,number:Xe,"number-format":Ir,object:Xe,slice:sr,step:or,string:Xe,"to-boolean":Ye,"to-color":Ye,"to-number":Ye,"to-string":Ye,var:Qe,within:Hr,distance:Pn,"global-state":Cn};class Tn{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n;}evaluate(t){return this._evaluate(t,this.args);}eachChild(t){this.args.forEach(t);}outputDefined(){return!1;}static parse(t,e){const r=t[0],n=Tn.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=s.filter(_ref6=>{let[e]=_ref6;return!Array.isArray(e)||e.length===t.length-1;});let o=null;for(const[n,s]of a){o=new Je(e.registry,$n,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){l=!0;break;}a.push(s);}if(!l)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else{for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new Tn(r,i,s,a);}}if(1===a.length)e.errors.push(...o.errors);else{const r=(a.length?a:s).map(_ref7=>{let[t]=_ref7;return e=t,Array.isArray(e)?`(${e.map(Jt).join(", ")})`:`(${Jt(e.type)}...)`;// removed by dead control flow
 var e; }).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(Jt(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null;}static register(t,e){Tn.definitions=e;for(const r in e)t[r]=Tn;}}function Bn(t,_ref8){let[e,r,n,i]=_ref8;e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=Re(e,r,n,s);if(a)throw new Fe(a);return new Ie(e/255,r/255,n/255,s,!1);}function Vn(t,e){return t in e;}function Fn(t,e){const r=e[t];return void 0===r?null:r;}function Dn(t){return{type:t};}function $n(t){if(t instanceof Qe)return $n(t.boundExpression);if(t instanceof Tn&&"error"===t.name)return!1;if(t instanceof Mr)return!1;if(t instanceof Hr)return!1;if(t instanceof Pn)return!1;if(t instanceof Cn)return!1;const e=t instanceof Ye||t instanceof Xe;let r=!0;return t.eachChild(t=>{r=e?r&&$n(t):r&&t instanceof qe;}),!!r&&Ln(t)&&Rn(t,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"]);}function Ln(t){if(t instanceof Tn){if("get"===t.name&&1===t.args.length)return!1;if("feature-state"===t.name)return!1;if("has"===t.name&&1===t.args.length)return!1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return!1;if(/^filter-/.test(t.name))return!1;}if(t instanceof Hr)return!1;if(t instanceof Pn)return!1;let e=!0;return t.eachChild(t=>{e&&!Ln(t)&&(e=!1);}),e;}function On(t){if(t instanceof Tn&&"feature-state"===t.name)return!1;let e=!0;return t.eachChild(t=>{e&&!On(t)&&(e=!1);}),e;}function Rn(t,e){if(t instanceof Tn&&e.indexOf(t.name)>=0)return!1;let r=!0;return t.eachChild(t=>{r&&!Rn(t,e)&&(r=!1);}),r;}function Un(t){return{result:"success",value:t};}function jn(t){return{result:"error",value:t};}function Nn(t){return"data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"];}function qn(t){return!!t.expression&&t.expression.parameters.indexOf("zoom")>-1;}function Gn(t){return!!t.expression&&t.expression.interpolated;}function Xn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t;}function Zn(t){return"object"==typeof t&&null!==t&&!Array.isArray(t)&&je(t)===Ut;}function Yn(t){return t;}function Hn(t,e){const r=t.stops&&"object"==typeof t.stops[0][0],n=r||!(r||void 0!==t.property),i=t.type||(Gn(e)?"exponential":"interval"),s=function(t){switch(t.type){case"color":return Ie.parse;case"padding":return Te.parse;case"numberArray":return Be.parse;case"colorArray":return Ve.parse;default:return null;}}(e);if(s&&((t=Tt({},t)).stops&&(t.stops=t.stops.map(t=>[t[0],s(t[1])])),t.default=s(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==(a=t.colorSpace)&&"hcl"!==a&&"lab"!==a)throw new Error(`Unknown color space: "${t.colorSpace}"`);var a;const o=function(t){switch(t){case"exponential":return Qn;case"interval":return Wn;case"categorical":return Jn;case"identity":return ti;default:throw new Error(`Unknown function type "${t}"`);}}(i);let l,u;if("categorical"===i){l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];u=typeof t.stops[0][0];}if(r){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Hn(r[t],e)]);const s={name:"linear"};return{kind:"composite",interpolationType:s,interpolationFactor:fr.interpolationFactor.bind(void 0,s),zoomStops:i.map(t=>t[0]),evaluate:(_ref9,n)=>{let{zoom:r}=_ref9;return Qn({stops:i,base:t.base},e,r).evaluate(r,n);}};}if(n){const r="exponential"===i?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return{kind:"camera",interpolationType:r,interpolationFactor:fr.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map(t=>t[0]),evaluate:_ref0=>{let{zoom:r}=_ref0;return o(t,e,r,l,u);}};}return{kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Kn(t.default,e.default):o(t,e,i,l,u);}};}function Kn(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0;}function Jn(t,e,r,n,i){return Kn(typeof r===i?n[r]:void 0,t.default,e.default);}function Wn(t,e,r){if("number"!==Xn(r))return Kn(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=ar(t.stops.map(t=>t[0]),r);return t.stops[i][1];}function Qn(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Xn(r))return Kn(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=ar(t.stops.map(t=>t[0]),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1);}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1],u=yr[e.type]||Yn;return"function"==typeof o.evaluate?{evaluate(){for(var _len4=arguments.length,e=new Array(_len4),_key4=0;_key4<_len4;_key4++){e[_key4]=arguments[_key4];}const r=o.evaluate.apply(void 0,e),n=l.evaluate.apply(void 0,e);if(void 0!==r&&void 0!==n)return u(r,n,a,t.colorSpace);}}:u(o,l,a,t.colorSpace);}function ti(t,e,r){switch(e.type){case"color":r=Ie.parse(r);break;case"formatted":r=Ee.fromString(r.toString());break;case"resolvedImage":r=Le.fromString(r.toString());break;case"padding":r=Te.parse(r);break;case"colorArray":r=Ve.parse(r);break;case"numberArray":r=Be.parse(r);break;default:Xn(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0);}return Kn(r,t.default,e.default);}Tn.register(En,{error:[{kind:"error"},[$t],(t,_ref1)=>{let[e]=_ref1;throw new Fe(e.evaluate(t));}],typeof:[$t,[jt],(t,_ref10)=>{let[e]=_ref10;return Jt(je(e.evaluate(t)));}],"to-rgba":[Kt(Dt,4),[Ot],(t,_ref11)=>{let[e]=_ref11;const[r,n,i,s]=e.evaluate(t).rgb;return[255*r,255*n,255*i,s];}],rgb:[Ot,[Dt,Dt,Dt],Bn],rgba:[Ot,[Dt,Dt,Dt,Dt],Bn],has:{type:Lt,overloads:[[[$t],(t,_ref12)=>{let[e]=_ref12;return Vn(e.evaluate(t),t.properties());}],[[$t,Ut],(t,_ref13)=>{let[e,r]=_ref13;return Vn(e.evaluate(t),r.evaluate(t));}]]},get:{type:jt,overloads:[[[$t],(t,_ref14)=>{let[e]=_ref14;return Fn(e.evaluate(t),t.properties());}],[[$t,Ut],(t,_ref15)=>{let[e,r]=_ref15;return Fn(e.evaluate(t),r.evaluate(t));}]]},"feature-state":[jt,[$t],(t,_ref16)=>{let[e]=_ref16;return Fn(e.evaluate(t),t.featureState||{});}],properties:[Ut,[],t=>t.properties()],"geometry-type":[$t,[],t=>t.geometryType()],id:[jt,[],t=>t.id()],zoom:[Dt,[],t=>t.globals.zoom],"heatmap-density":[Dt,[],t=>t.globals.heatmapDensity||0],elevation:[Dt,[],t=>t.globals.elevation||0],"line-progress":[Dt,[],t=>t.globals.lineProgress||0],accumulated:[jt,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Dt,Dn(Dt),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r;}],"*":[Dt,Dn(Dt),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r;}],"-":{type:Dt,overloads:[[[Dt,Dt],(t,_ref17)=>{let[e,r]=_ref17;return e.evaluate(t)-r.evaluate(t);}],[[Dt],(t,_ref18)=>{let[e]=_ref18;return-e.evaluate(t);}]]},"/":[Dt,[Dt,Dt],(t,_ref19)=>{let[e,r]=_ref19;return e.evaluate(t)/r.evaluate(t);}],"%":[Dt,[Dt,Dt],(t,_ref20)=>{let[e,r]=_ref20;return e.evaluate(t)%r.evaluate(t);}],ln2:[Dt,[],()=>Math.LN2],pi:[Dt,[],()=>Math.PI],e:[Dt,[],()=>Math.E],"^":[Dt,[Dt,Dt],(t,_ref21)=>{let[e,r]=_ref21;return Math.pow(e.evaluate(t),r.evaluate(t));}],sqrt:[Dt,[Dt],(t,_ref22)=>{let[e]=_ref22;return Math.sqrt(e.evaluate(t));}],log10:[Dt,[Dt],(t,_ref23)=>{let[e]=_ref23;return Math.log(e.evaluate(t))/Math.LN10;}],ln:[Dt,[Dt],(t,_ref24)=>{let[e]=_ref24;return Math.log(e.evaluate(t));}],log2:[Dt,[Dt],(t,_ref25)=>{let[e]=_ref25;return Math.log(e.evaluate(t))/Math.LN2;}],sin:[Dt,[Dt],(t,_ref26)=>{let[e]=_ref26;return Math.sin(e.evaluate(t));}],cos:[Dt,[Dt],(t,_ref27)=>{let[e]=_ref27;return Math.cos(e.evaluate(t));}],tan:[Dt,[Dt],(t,_ref28)=>{let[e]=_ref28;return Math.tan(e.evaluate(t));}],asin:[Dt,[Dt],(t,_ref29)=>{let[e]=_ref29;return Math.asin(e.evaluate(t));}],acos:[Dt,[Dt],(t,_ref30)=>{let[e]=_ref30;return Math.acos(e.evaluate(t));}],atan:[Dt,[Dt],(t,_ref31)=>{let[e]=_ref31;return Math.atan(e.evaluate(t));}],min:[Dt,Dn(Dt),(t,e)=>Math.min(...e.map(e=>e.evaluate(t)))],max:[Dt,Dn(Dt),(t,e)=>Math.max(...e.map(e=>e.evaluate(t)))],abs:[Dt,[Dt],(t,_ref32)=>{let[e]=_ref32;return Math.abs(e.evaluate(t));}],round:[Dt,[Dt],(t,_ref33)=>{let[e]=_ref33;const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r);}],floor:[Dt,[Dt],(t,_ref34)=>{let[e]=_ref34;return Math.floor(e.evaluate(t));}],ceil:[Dt,[Dt],(t,_ref35)=>{let[e]=_ref35;return Math.ceil(e.evaluate(t));}],"filter-==":[Lt,[$t,jt],(t,_ref36)=>{let[e,r]=_ref36;return t.properties()[e.value]===r.value;}],"filter-id-==":[Lt,[jt],(t,_ref37)=>{let[e]=_ref37;return t.id()===e.value;}],"filter-type-==":[Lt,[$t],(t,_ref38)=>{let[e]=_ref38;return t.geometryType()===e.value;}],"filter-<":[Lt,[$t,jt],(t,_ref39)=>{let[e,r]=_ref39;const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i;}],"filter-id-<":[Lt,[jt],(t,_ref40)=>{let[e]=_ref40;const r=t.id(),n=e.value;return typeof r==typeof n&&r<n;}],"filter->":[Lt,[$t,jt],(t,_ref41)=>{let[e,r]=_ref41;const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i;}],"filter-id->":[Lt,[jt],(t,_ref42)=>{let[e]=_ref42;const r=t.id(),n=e.value;return typeof r==typeof n&&r>n;}],"filter-<=":[Lt,[$t,jt],(t,_ref43)=>{let[e,r]=_ref43;const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i;}],"filter-id-<=":[Lt,[jt],(t,_ref44)=>{let[e]=_ref44;const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n;}],"filter->=":[Lt,[$t,jt],(t,_ref45)=>{let[e,r]=_ref45;const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i;}],"filter-id->=":[Lt,[jt],(t,_ref46)=>{let[e]=_ref46;const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n;}],"filter-has":[Lt,[jt],(t,_ref47)=>{let[e]=_ref47;return e.value in t.properties();}],"filter-has-id":[Lt,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Lt,[Kt($t)],(t,_ref48)=>{let[e]=_ref48;return e.value.indexOf(t.geometryType())>=0;}],"filter-id-in":[Lt,[Kt(jt)],(t,_ref49)=>{let[e]=_ref49;return e.value.indexOf(t.id())>=0;}],"filter-in-small":[Lt,[$t,Kt(jt)],(t,_ref50)=>{let[e,r]=_ref50;return r.value.indexOf(t.properties()[e.value])>=0;}],"filter-in-large":[Lt,[$t,Kt(jt)],(t,_ref51)=>{let[e,r]=_ref51;return function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return!0;e[i]>t?n=i-1:r=i+1;}return!1;}(t.properties()[e.value],r.value,0,r.value.length-1);}],all:{type:Lt,overloads:[[[Lt,Lt],(t,_ref52)=>{let[e,r]=_ref52;return e.evaluate(t)&&r.evaluate(t);}],[Dn(Lt),(t,e)=>{for(const r of e)if(!r.evaluate(t))return!1;return!0;}]]},any:{type:Lt,overloads:[[[Lt,Lt],(t,_ref53)=>{let[e,r]=_ref53;return e.evaluate(t)||r.evaluate(t);}],[Dn(Lt),(t,e)=>{for(const r of e)if(r.evaluate(t))return!0;return!1;}]]},"!":[Lt,[Lt],(t,_ref54)=>{let[e]=_ref54;return!e.evaluate(t);}],"is-supported-script":[Lt,[$t],(t,_ref55)=>{let[e]=_ref55;const r=t.globals&&t.globals.isSupportedScript;return!r||r(e.evaluate(t));}],upcase:[$t,[$t],(t,_ref56)=>{let[e]=_ref56;return e.evaluate(t).toUpperCase();}],downcase:[$t,[$t],(t,_ref57)=>{let[e]=_ref57;return e.evaluate(t).toLowerCase();}],concat:[$t,Dn(jt),(t,e)=>e.map(e=>Ne(e.evaluate(t))).join("")],"resolved-locale":[$t,[Nt],(t,_ref58)=>{let[e]=_ref58;return e.evaluate(t).resolvedLocale();}]});class ei{constructor(t,e,r){this.expression=t,this._warningHistory={},this._evaluator=new Ke(),this._defaultValue=e?function(t){if("color"===t.type&&Zn(t.default))return new Ie(0,0,0,0);switch(t.type){case"color":return Ie.parse(t.default)||null;case"padding":return Te.parse(t.default)||null;case"numberArray":return Be.parse(t.default)||null;case"colorArray":return Ve.parse(t.default)||null;case"variableAnchorOffsetCollection":return $e.parse(t.default)||null;case"projectionDefinition":return Oe.parse(t.default)||null;default:return void 0===t.default?null:t.default;}}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null,this._globalState=r;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator);}evaluate(t,e,r,n,i,s){this._globalState&&(t=ci(t,this._globalState)),this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Fe(`Expected value to be one of ${Object.keys(this._enumValues).map(t=>JSON.stringify(t)).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t;}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue;}}}function ri(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in En;}function ni(t,e,r){const n=new Je(En,$n,[],e?function(t){const e={color:Ot,string:$t,number:Dt,enum:$t,boolean:Lt,formatted:qt,padding:Gt,numberArray:Zt,colorArray:Xt,projectionDefinition:Rt,resolvedImage:Yt,variableAnchorOffsetCollection:Ht};return"array"===t.type?Kt(e[t.value]||jt,t.length):e[t.type];}(e):void 0),i=n.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return i?Un(new ei(i,e,r)):jn(n.errors);}class ii{constructor(t,e,r){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!On(e.expression),this.globalStateRefs=ui(e.expression),this._globalState=r;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s);}evaluate(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._styleExpression.evaluate(t,e,r,n,i,s);}}class si{constructor(t,e,r,n,i){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!On(e.expression),this.globalStateRefs=ui(e.expression),this.interpolationType=n,this._globalState=i;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s);}evaluate(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._styleExpression.evaluate(t,e,r,n,i,s);}interpolationFactor(t,e,r){return this.interpolationType?fr.interpolationFactor(this.interpolationType,t,e,r):0;}}function ai(t,e,r){const n=ni(t,e,r);if("error"===n.result)return n;const i=n.value.expression,s=Ln(i);if(!s&&!Nn(e))return jn([new Bt("","data expressions not supported")]);const a=Rn(i,["zoom"]);if(!a&&!qn(e))return jn([new Bt("","zoom expressions not supported")]);const o=li(i);return o||a?o instanceof Bt?jn([o]):o instanceof fr&&!Gn(e)?jn([new Bt("",'"interpolate" expressions cannot be used with this property')]):Un(o?new si(s?"camera":"composite",n.value,o.labels,o instanceof fr?o.interpolation:void 0,r):new ii(s?"constant":"source",n.value,r)):jn([new Bt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')]);}class oi{constructor(t,e){this._parameters=t,this._specification=e,Tt(this,Hn(this._parameters,this._specification));}static deserialize(t){return new oi(t._parameters,t._specification);}static serialize(t){return{_parameters:t._parameters,_specification:t._specification};}}function li(t){let e=null;if(t instanceof We)e=li(t.result);else if(t instanceof mr){for(const r of t.args)if(e=li(r),e)break;}else(t instanceof or||t instanceof fr)&&t.input instanceof Tn&&"zoom"===t.input.name&&(e=t);return e instanceof Bt||t.eachChild(t=>{const r=li(t);r instanceof Bt?e=r:!e&&r?e=new Bt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new Bt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));}),e;}function ui(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:new Set();return t instanceof Cn&&e.add(t.key),t.eachChild(t=>{ui(t,e);}),e;}function ci(t,e){const{zoom:r,heatmapDensity:n,elevation:i,lineProgress:s,isSupportedScript:a,accumulated:o}=null!=t?t:{};return{zoom:r,heatmapDensity:n,elevation:i,lineProgress:s,isSupportedScript:a,accumulated:o,globalState:e};}function hi(t){if(!0===t||!1===t)return!0;if(!Array.isArray(t)||0===t.length)return!1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!hi(e)&&"boolean"!=typeof e)return!1;return!0;default:return!0;}}const pi={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function fi(t,e){if(null==t)return{filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set()};hi(t)||(t=mi(t));const r=ni(t,pi,e);if("error"===r.result)throw new Error(r.value.map(t=>`${t.key}: ${t.message}`).join(", "));return{filter:(t,e,n)=>r.value.evaluate(t,e,{},n),needGeometry:yi(t),getGlobalStateRefs:()=>ui(r.value.expression)};}function di(t,e){return t<e?-1:t>e?1:0;}function yi(t){if(!Array.isArray(t))return!1;if("within"===t[0]||"distance"===t[0])return!0;for(let e=1;e<t.length;e++)if(yi(t[e]))return!0;return!1;}function mi(t){if(!t)return!0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?gi(t[1],t[2],"=="):"!="===e?bi(gi(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?gi(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(mi))):"all"===e?["all"].concat(t.slice(1).map(mi)):"none"===e?["all"].concat(t.slice(1).map(mi).map(bi)):"in"===e?xi(t[1],t.slice(2)):"!in"===e?bi(xi(t[1],t.slice(2))):"has"===e?vi(t[1]):"!has"!==e||bi(vi(t[1]));// removed by dead control flow
 var r; }function gi(t,e,r){switch(t){case"$type":return[`filter-type-${r}`,e];case"$id":return[`filter-id-${r}`,e];default:return[`filter-${r}`,t,e];}}function xi(t,e){if(0===e.length)return!1;switch(t){case"$type":return["filter-type-in",["literal",e]];case"$id":return["filter-id-in",["literal",e]];default:return e.length>200&&!e.some(t=>typeof t!=typeof e[0])?["filter-in-large",t,["literal",e.sort(di)]]:["filter-in-small",t,["literal",e]];}}function vi(t){switch(t){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",t];}}function bi(t){return["!",t];}function wi(t){const e=typeof t;if("number"===e||"boolean"===e||"string"===e||null==t)return JSON.stringify(t);if(Array.isArray(t)){let e="[";for(const r of t)e+=`${wi(r)},`;return`${e}]`;}const r=Object.keys(t).sort();let n="{";for(let e=0;e<r.length;e++)n+=`${JSON.stringify(r[e])}:${wi(t[r[e]])},`;return`${n}}`;}function _i(t){let e="";for(const r of bt)e+=`/${wi(t[r])}`;return e;}function Si(t){const e=t.value;return e?[new Et(t.key,e,"constants have been deprecated as of v8")]:[];}function Ai(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t;}function ki(t){if(Array.isArray(t))return t.map(ki);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=ki(t[r]);return e;}return Ai(t);}function Mi(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,a=t.styleSpec,o=t.validateSpec;let l=[];const u=Xn(r);if("object"!==u)return[new Et(e,r,`object expected, ${u} found`)];for(const t in r){const u=t.split(".")[0],c=ve(n,u)||n["*"];let h;if(ve(i,u))h=i[u];else if(ve(n,u))h=o;else if(i["*"])h=i["*"];else{if(!n["*"]){l.push(new Et(e,r[t],`unknown property "${t}"`));continue;}h=o;}l=l.concat(h({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:c,style:s,styleSpec:a,object:r,objectKey:t,validateSpec:o},r));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&l.push(new Et(e,r,`missing required property "${t}"`));return l;}function Ii(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,a=t.arrayElementValidator||t.validateSpec;if("array"!==Xn(e))return[new Et(s,e,`array expected, ${Xn(e)} found`)];if(r.length&&e.length!==r.length)return[new Et(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return[new Et(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values};i.$version<7&&(o.function=r.function),"object"===Xn(r.value)&&(o=r.value);let l=[];for(let r=0;r<e.length;r++)l=l.concat(a({array:e,arrayIndex:r,value:e[r],valueSpec:o,validateSpec:t.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l;}function zi(t){const e=t.key,r=t.value,n=t.valueSpec;let i=Xn(r);return"number"===i&&r!=r&&(i="NaN"),"number"!==i?[new Et(e,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new Et(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new Et(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[];}function Pi(t){const e=t.valueSpec,r=Ai(t.value.type);let n,i,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===Xn(t.value.stops)&&"array"===Xn(t.value.stops[0])&&"object"===Xn(t.value.stops[0][0]),c=Mi({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return[new Et(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(Ii({key:t.key,value:n,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===Xn(n)&&0===n.length&&e.push(new Et(t.key,n,"array must have at least one stop")),e;},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec});}}});return"identity"===r&&o&&c.push(new Et(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new Et(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!Gn(t.valueSpec)&&c.push(new Et(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Nn(t.valueSpec)?c.push(new Et(t.key,t.value,"property functions not supported")):o&&!qn(t.valueSpec)&&c.push(new Et(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new Et(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==Xn(n))return[new Et(o,n,`array expected, ${Xn(n)} found`)];if(2!==n.length)return[new Et(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Xn(n[0]))return[new Et(o,n,`object expected, ${Xn(n[0])} found`)];if(void 0===n[0].zoom)return[new Et(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return[new Et(o,n,"object stop key must have value")];if(s&&s>Ai(n[0].zoom))return[new Et(o,n[0].zoom,"stop zoom values must appear in ascending order")];Ai(n[0].zoom)!==s&&(s=Ai(n[0].zoom),i=void 0,a={}),r=r.concat(Mi({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:zi,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},n));return ri(ki(n[1]))?r.concat([new Et(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(t.validateSpec({key:`${o}[1]`,value:n[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}));}function p(t,s){const o=Xn(t.value),l=Ai(t.value),u=null!==t.value?t.value:s;if(n){if(o!==n)return[new Et(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)];}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return[new Et(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return Nn(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Et(t.key,u,n)];}return"categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==i&&l<i?[new Et(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in a?[new Et(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new Et(t.key,u,`integer expected, found ${l}`)];}}function Ci(t){const e=("property"===t.expressionContext?ai:ni)(ki(t.value),t.valueSpec);if("error"===e.result)return e.value.map(e=>new Et(`${t.key}${e.key}`,t.value,e.message));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return[new Et(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!On(r))return[new Et(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!On(r))return[new Et(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Rn(r,["zoom","feature-state"]))return[new Et(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!Ln(r))return[new Et(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")];}return[];}function Ei(t){const e=t.key,r=t.value,n=Xn(r);return"string"!==n?[new Et(e,r,`color expected, ${n} found`)]:Ie.parse(String(r))?[]:[new Et(e,r,`color expected, "${r}" found`)];}function Ti(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(Ai(r))&&i.push(new Et(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(Ai(r))&&i.push(new Et(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i;}function Bi(t){return hi(ki(t.value))?Ci(Tt({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):Vi(t);}function Vi(t){const e=t.value,r=t.key;if("array"!==Xn(e))return[new Et(r,e,`array expected, ${Xn(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return[new Et(r,e,"filter array must have at least 1 element")];switch(s=s.concat(Ti({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),Ai(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===Ai(e[1])&&s.push(new Et(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new Et(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(i=Xn(e[1]),"string"!==i&&s.push(new Et(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let a=2;a<e.length;a++)i=Xn(e[a]),"$type"===Ai(e[1])?s=s.concat(Ti({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new Et(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)s=s.concat(Vi({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":i=Xn(e[1]),2!==e.length?s.push(new Et(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new Et(`${r}[1]`,e[1],`string expected, ${i} found`));}return s;}function Fi(t,e){const r=t.key,n=t.validateSpec,i=t.style,s=t.styleSpec,a=t.value,o=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return[];const u=o.match(/^(.*)-transition$/);if("paint"===e&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:a,valueSpec:s.transition,style:i,styleSpec:s});const c=t.valueSpec||l[o];if(!c)return[new Et(r,a,`unknown property "${o}"`)];let h;if("string"===Xn(a)&&Nn(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(a)))return[new Et(r,a,`"${o}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return"symbol"===t.layerType&&"text-font"===o&&Zn(ki(a))&&"identity"===Ai(a.type)&&p.push(new Et(r,a,'"text-font" does not support identity functions')),p.concat(n({key:t.key,value:a,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:o}));}function Di(t){return Fi(t,"paint");}function $i(t){return Fi(t,"layout");}function Li(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;if("object"!==Xn(r))return[new Et(n,r,`object expected, ${Xn(r)} found`)];r.type||r.ref||e.push(new Et(n,r,'either "type" or "ref" is required'));let a=Ai(r.type);const o=Ai(r.ref);if(r.id){const s=Ai(r.id);for(let a=0;a<t.arrayIndex;a++){const t=i.layers[a];Ai(t.id)===s&&e.push(new Et(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach(t=>{t in r&&e.push(new Et(n,r[t],`"${t}" is prohibited for ref layers`));}),i.layers.forEach(e=>{Ai(e.id)===o&&(t=e);}),t?t.ref?e.push(new Et(n,r.ref,"ref cannot reference another ref layer")):a=Ai(t.type):e.push(new Et(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==a)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&Ai(t.type);t?"vector"===s&&"raster"===a?e.push(new Et(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===a||"raster-dem"!==s&&"color-relief"===a?e.push(new Et(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==a?e.push(new Et(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a&&"color-relief"!==a?e.push(new Et(n,r.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new Et(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Et(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new Et(n,r.source,`source "${r.source}" not found`));}else e.push(new Et(n,r,'missing required property "source"'));return e=e.concat(Mi({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:r,objectKey:"type"}),filter:Bi,layout:t=>Mi({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>$i(Tt({layerType:a},t))}}),paint:t=>Mi({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Di(Tt({layerType:a},t))}})}})),e;}function Oi(t){const e=t.value,r=t.key,n=Xn(e);return"string"!==n?[new Et(r,e,`string expected, ${n} found`)]:[];}const Ri={promoteId:function(_ref59){let{key:t,value:e}=_ref59;if("string"===Xn(e))return Oi({key:t,value:e});{const r=[];for(const n in e)r.push(...Oi({key:`${t}.${n}`,value:e[n]}));return r;}}};function Ui(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style,s=t.validateSpec;if(!e.type)return[new Et(r,e,'"type" is required')];const a=Ai(e.type);let o;switch(a){case"vector":case"raster":return o=Mi({key:r,value:e,valueSpec:n[`source_${a.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:Ri,validateSpec:s}),o;case"raster-dem":return o=function(t){var e;const r=null!==(e=t.sourceName)&&void 0!==e?e:"",n=t.value,i=t.styleSpec,s=i.source_raster_dem,a=t.style;let o=[];const l=Xn(n);if(void 0===n)return o;if("object"!==l)return o.push(new Et("source_raster_dem",n,`object expected, ${l} found`)),o;const u="custom"===Ai(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in n)!u&&c.includes(e)?o.push(new Et(e,n[e],`In "${r}": "${e}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[e]?o=o.concat(t.validateSpec({key:e,value:n[e],valueSpec:s[e],validateSpec:t.validateSpec,style:a,styleSpec:i})):o.push(new Et(e,n[e],`unknown property "${e}"`));return o;}({sourceName:r,value:e,style:t.style,styleSpec:n,validateSpec:s}),o;case"geojson":if(o=Mi({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:Ri}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],s="string"==typeof n?[n,["accumulated"],["get",t]]:n;o.push(...Ci({key:`${r}.${t}.map`,value:i,expressionContext:"cluster-map"})),o.push(...Ci({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return o;case"video":return Mi({key:r,value:e,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case"image":return Mi({key:r,value:e,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case"canvas":return[new Et(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Ti({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}});}}function ji(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const a=Xn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Et("light",e,`object expected, ${a} found`)]),s;for(const a in e){const o=a.match(/^(.*)-transition$/);s=s.concat(o&&n[o[1]]&&n[o[1]].transition?t.validateSpec({key:a,value:e[a],valueSpec:r.transition,validateSpec:t.validateSpec,style:i,styleSpec:r}):n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new Et(a,e[a],`unknown property "${a}"`)]);}return s;}function Ni(t){const e=t.value,r=t.styleSpec,n=r.sky,i=t.style,s=Xn(e);if(void 0===e)return[];if("object"!==s)return[new Et("sky",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new Et(s,e[s],`unknown property "${s}"`)]);return a;}function qi(t){const e=t.value,r=t.styleSpec,n=r.terrain,i=t.style;let s=[];const a=Xn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Et("terrain",e,`object expected, ${a} found`)]),s;for(const a in e)s=s.concat(n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new Et(a,e[a],`unknown property "${a}"`)]);return s;}function Gi(t){let e=[];const r=t.value,n=t.key;if(Array.isArray(r)){const i=[],s=[];for(const a in r)r[a].id&&i.includes(r[a].id)&&e.push(new Et(n,r,`all the sprites' ids must be unique, but ${r[a].id} is duplicated`)),i.push(r[a].id),r[a].url&&s.includes(r[a].url)&&e.push(new Et(n,r,`all the sprites' URLs must be unique, but ${r[a].url} is duplicated`)),s.push(r[a].url),e=e.concat(Mi({key:`${n}[${a}]`,value:r[a],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e;}return Oi({key:n,value:r});}function Xi(t){return e=t.value,Boolean(e)&&e.constructor===Object?[]:[new Et(t.key,t.value,`object expected, ${Xn(t.value)} found`)];// removed by dead control flow
 var e; }const Zi={"*":()=>[],array:Ii,boolean:function(t){const e=t.value,r=t.key,n=Xn(e);return"boolean"!==n?[new Et(r,e,`boolean expected, ${n} found`)]:[];},number:zi,color:Ei,constants:Si,enum:Ti,filter:Bi,function:Pi,layer:Li,object:Mi,source:Ui,light:ji,sky:Ni,terrain:qi,projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,i=t.style,s=Xn(e);if(void 0===e)return[];if("object"!==s)return[new Et("projection",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new Et(s,e[s],`unknown property "${s}"`)]);return a;},projectionDefinition:function(t){const e=t.key;let r=t.value;r=r instanceof String?r.valueOf():r;const n=Xn(r);return"array"!==n||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2];}(r)||function(t){return!!["interpolate","step","literal"].includes(t[0]);}(r)?["array","string"].includes(n)?[]:[new Et(e,r,`projection expected, invalid type "${n}" found`)]:[new Et(e,r,`projection expected, invalid array ${JSON.stringify(r)} found`)];},string:Oi,formatted:function(t){return 0===Oi(t).length?[]:Ci(t);},resolvedImage:function(t){return 0===Oi(t).length?[]:Ci(t);},padding:function(t){const e=t.key,r=t.value;if("array"===Xn(r)){if(r.length<1||r.length>4)return[new Et(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i;}return zi({key:e,value:r,valueSpec:{}});},numberArray:function(t){const e=t.key,r=t.value;if("array"===Xn(r)){const n={type:"number"};if(r.length<1)return[new Et(e,r,"array length at least 1 expected, length 0 found")];let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i;}return zi({key:e,value:r,valueSpec:{}});},colorArray:function(t){const e=t.key,r=t.value;if("array"===Xn(r)){if(r.length<1)return[new Et(e,r,"array length at least 1 expected, length 0 found")];let t=[];for(let n=0;n<r.length;n++)t=t.concat(Ei({key:`${e}[${n}]`,value:r[n]}));return t;}return Ei({key:e,value:r});},variableAnchorOffsetCollection:function(t){const e=t.key,r=t.value,n=Xn(r),i=t.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return[new Et(e,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(Ti({key:`${e}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(Ii({key:`${e}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:i}));return s;},sprite:Gi,state:Xi};function Yi(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return t.validateSpec=Yi,r.expression&&Zn(Ai(e))?Pi(t):r.expression&&ri(ki(e))?Ci(t):r.type&&Zi[r.type]?Zi[r.type](t):Mi(Tt({},t,{valueSpec:r.type?n[r.type]:r}));}function Hi(t){const e=t.value,r=t.key,n=Oi(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new Et(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new Et(r,e,'"glyphs" url must include a "{range}" token'))),n;}function Ki(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:vt;let r=[];return r=r.concat(Yi({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Yi,objectElementValidators:{glyphs:Hi,"*":()=>[]}})),t.constants&&(r=r.concat(Si({key:"constants",value:t.constants}))),Wi(r);}function Ji(t){return function(e){return t(Object.assign({},e,{validateSpec:Yi}));};}function Wi(t){return[].concat(t).sort((t,e)=>t.line-e.line);}function Qi(t){return function(){for(var _len5=arguments.length,e=new Array(_len5),_key5=0;_key5<_len5;_key5++){e[_key5]=arguments[_key5];}return Wi(t.apply(this,e));};}Ki.source=Qi(Ji(Ui)),Ki.sprite=Qi(Ji(Gi)),Ki.glyphs=Qi(Ji(Hi)),Ki.light=Qi(Ji(ji)),Ki.sky=Qi(Ji(Ni)),Ki.terrain=Qi(Ji(qi)),Ki.state=Qi(Ji(Xi)),Ki.layer=Qi(Ji(Li)),Ki.filter=Qi(Ji(Bi)),Ki.paintProperty=Qi(Ji(Di)),Ki.layoutProperty=Qi(Ji($i));const ts=vt,es=Ki,rs=es.light,ns=es.sky,is=es.paintProperty,ss=es.layoutProperty;function as(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new gt(new Error(n.message))),r=!0;return r;}class os{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(let t=0;t<this.d*this.d;t++){const e=i[3+t],r=i[3+t+1];n.push(e===r?null:i.subarray(e,r));}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly;}else{this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;const i=r/e*t;this.min=-i,this.max=t+i;}insert(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.");}_insertCell(t,e,r,n,i,s){this.cells[i].push(s);}query(t,e,r,n,i){const s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,r,n,this._queryCell,s,{},i),s;}}_queryCell(t,e,r,n,i,s,a,o){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===a[h]){const l=4*h;(o?o(u[l+0],u[l+1],u[l+2],u[l+3]):t<=u[l+2]&&e<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(a[h]=!0,s.push(i[h])):a[h]=!1;}}}}_forEachCell(t,e,r,n,i,s,a,o){const l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,t,e,r,n,u,s,a,o))return;}}_convertFromCellCoord(t){return(t-this.padding)/this.scale;}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding));}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=i,n.set(r,i),i+=r.length;}return n[3+t.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+t.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer;}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r};}static deserialize(t){return new os(t.buffer);}}const ls={};function us(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};if(ls[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),ls[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}us("Object",Object),us("Set",Set),us("TransferableGridIndex",os),us("Color",Ie),us("Error",Error),us("AJAXError",ct),us("ResolvedImage",Le),us("StylePropertyFunction",oi),us("StyleExpression",ei,{omit:["_evaluator"]}),us("ZoomDependentExpression",si),us("ZoomConstantExpression",ii),us("CompoundExpression",Tn,{omit:["_evaluate"]});for(const t in En)En[t]._classRegistryKey||us(`Expression_${t}`,En[t]);function cs(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name);}function hs(t){return t.$name||t.constructor._classRegistryKey;}function ps(t){return!function(t){if(null===t||"object"!=typeof t)return!1;const e=hs(t);return!(!e||"Object"===e);}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||cs(t)||H(t)||ArrayBuffer.isView(t)||t instanceof ImageData);}function fs(t,e){if(ps(t))return(cs(t)||H(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(fs(n,e));return r;}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const r=hs(t);if(!r)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!ls[r])throw new Error(`${r} is not registered.`);const{klass:n}=ls[r],i=n.serialize?n.serialize(t,e):{};if(n.serialize){if(e&&i===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property");}else{for(const n in t){if(!t.hasOwnProperty(n))continue;if(ls[r].omit.indexOf(n)>=0)continue;const s=t[n];i[n]=ls[r].shallow.indexOf(n)>=0?s:fs(s,e);}t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==r&&(i.$name=r),i;}function ds(t){if(ps(t))return t;if(Array.isArray(t))return t.map(ds);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=hs(t)||"Object";if(!ls[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=ls[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=ls[e].shallow.indexOf(r)>=0?i:ds(i);}return n;}class ys{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0));}}const ms={"Latin-1 Supplement":t=>t>=128&&t<=255,"Hangul Jamo":t=>t>=4352&&t<=4607,Khmer:t=>t>=6016&&t<=6143,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Kanbun:t=>t>=12688&&t<=12703,"CJK Strokes":t=>t>=12736&&t<=12783,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Hangul Syllables":t=>t>=44032&&t<=55215,"Private Use Area":t=>t>=57344&&t<=63743,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519};function gs(t){for(const e of t)if(Ss(e.charCodeAt(0)))return!0;return!1;}function xs(t){for(const e of t)if(!ws(e.charCodeAt(0)))return!1;return!0;}function vs(t){const e=t.map(t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source;}catch(t){return null;}}).filter(t=>t);return new RegExp(e.join("|"),"u");}const bs=vs(["Arab","Dupl","Mong","Ougr","Syrc"]);function ws(t){return!bs.test(String.fromCodePoint(t));}const _s=vs(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function Ss(t){return!(746!==t&&747!==t&&(t<4352||!(ms["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||ms["CJK Compatibility"](t)||ms["CJK Strokes"](t)||!(!ms["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||ms["Enclosed CJK Letters and Months"](t)||ms["Ideographic Description Characters"](t)||ms.Kanbun(t)||ms.Katakana(t)&&12540!==t||!(!ms["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!ms["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||ms["Vertical Forms"](t)||ms["Yijing Hexagram Symbols"](t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||_s.test(String.fromCodePoint(t)))));}function As(t){return!(Ss(t)||function(t){return!!(ms["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||ms["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||ms["Letterlike Symbols"](t)||ms["Number Forms"](t)||ms["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||ms["Control Pictures"](t)&&9251!==t||ms["Optical Character Recognition"](t)||ms["Enclosed Alphanumerics"](t)||ms["Geometric Shapes"](t)||ms["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||ms["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||ms["CJK Symbols and Punctuation"](t)||ms.Katakana(t)||ms["Private Use Area"](t)||ms["CJK Compatibility Forms"](t)||ms["Small Form Variants"](t)||ms["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t);}(t));}const ks=vs(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Ms(t){return ks.test(String.fromCodePoint(t));}function Is(t,e){return!(!e&&Ms(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||ms.Khmer(t));}function zs(t){for(const e of t)if(Ms(e.charCodeAt(0)))return!0;return!1;}const Ps=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{};}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL;}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL};}setMethods(t){if(Ps.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve();}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText;}getRTLTextPluginStatus(){return this.pluginStatus;}syncState(t,r){return e(this,void 0,void 0,function*(){if(this.isParsed())return this.getState();if("loading"!==t.pluginStatus)return this.setState(t),t;const e=t.pluginURL,n=new Promise(t=>{this.loadScriptResolve=t;});r(e);const i=new Promise(t=>setTimeout(()=>t(),this.TIMEOUT));if(yield Promise.race([n,i]),this.isParsed()){const t={pluginStatus:"loaded",pluginURL:e};return this.setState(t),t;}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${e}`);});}}();class Cs{constructor(t,e){this.isSupportedScript=Es,this.zoom=t,e?(this.now=e.now||0,this.fadeDuration=e.fadeDuration||0,this.zoomHistory=e.zoomHistory||new ys(),this.transition=e.transition||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new ys(),this.transition={});}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1);}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e};}}function Es(t){return function(t,e){for(const r of t)if(!Is(r.charCodeAt(0),e))return!1;return!0;}(t,"loaded"===Ps.getRTLTextPluginStatus());}class Ts{constructor(t,e,r){this.property=t,this.value=e,this.expression=function(t,e,r){if(Zn(t))return new oi(t,e);if(ri(t)){const n=ai(t,e,r);if("error"===n.result)throw new Error(n.value.map(t=>`${t.key}: ${t.message}`).join(", "));return n.value;}{let r=t;return"color"===e.type&&"string"==typeof t?r=Ie.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"numberArray"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"colorArray"!==e.type||"string"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?r=$e.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(r=Oe.parse(t)):r=Ve.parse(t):r=Be.parse(t):r=Te.parse(t),{globalStateRefs:new Set(),_globalState:null,kind:"constant",evaluate:()=>r};}}(void 0===e?t.specification.default:e,t.specification,r);}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind;}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set();}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r);}}class Bs{constructor(t,e){this.property=t,this.value=new Ts(t,void 0,e);}transitioned(t,e){return new Fs(this.property,this.value,e,L({},t.transition,this.transition),t.now);}untransitioned(){return new Fs(this.property,this.value,null,{},0);}}class Vs{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._globalState=e;}getValue(t){return j(this._values[t].value.value);}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Bs(this._values[t].property,this._globalState)),this._values[t].value=new Ts(this._values[t].property,null===e?void 0:j(e),this._globalState);}getTransition(t){return j(this._values[t].transition);}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Bs(this._values[t].property,this._globalState)),this._values[t].transition=j(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t;}transitioned(t,e){const r=new Ds(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r;}untransitioned(){const t=new Ds(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t;}}class Fs{constructor(t,e,r,n,i){this.property=t,this.value=e,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,B(a));}}return i;}}class Ds{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new Os(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n;}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return!0;return!1;}}class $s{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._globalState=e;}hasValue(t){return void 0!==this._values[t].value;}getValue(t){return j(this._values[t].value);}setValue(t,e){this._values[t]=new Ts(this._values[t].property,null===e?void 0:j(e),this._globalState);}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t;}possiblyEvaluate(t,e,r){const n=new Os(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n;}}class Ls{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return"constant"===this.value.kind;}constantOr(t){return"constant"===this.value.kind?this.value.value:t;}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n);}}class Os{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t];}}class Rs{constructor(t){this.specification=t;}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e);}interpolate(t,e,r){const n=yr[this.specification.type];return n?n(t,e,r):t;}}class Us{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new Ls(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e);}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Ls(this,{kind:"constant",value:void 0},t.parameters);const n=yr[this.specification.type];if(n){const i=n(t.value.value,e.value.value,r);return new Ls(this,{kind:"constant",value:i},t.parameters);}return t;}evaluate(t,e,r,n,i,s){return"constant"===t.kind?t.value:t.evaluate(e,r,n,i,s);}}class js extends Us{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new Ls(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,a=this._calculate(s,s,s,e);return new Ls(this,{kind:"constant",value:a},e);}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new Ls(this,{kind:"constant",value:r},e);}return new Ls(this,t.expression,e);}evaluate(t,e,r,n,i,s){if("source"===t.kind){const a=t.evaluate(e,r,n,i,s);return this._calculate(a,a,a,e);}return"composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value;}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e};}interpolate(t){return t;}}class Ns{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e);}return this._calculate(t.expression.evaluate(new Cs(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Cs(Math.floor(e.zoom),e)),t.expression.evaluate(new Cs(Math.floor(e.zoom+1),e)),e);}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e};}interpolate(t){return t;}}class qs{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return!!t.expression.evaluate(e,null,{},r,n);}interpolate(){return!1;}}class Gs{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new Ts(r,void 0,void 0),i=this.defaultTransitionablePropertyValues[e]=new Bs(r,void 0);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({});}}}us("DataDrivenProperty",Us),us("DataConstantProperty",Rs),us("CrossFadedDataDrivenProperty",js),us("CrossFadedProperty",Ns),us("ColorRampProperty",qs);const Xs="-transition";class Zs extends xt{constructor(t,e,r){if(super(),this.id=t.id,this.type=t.type,this._globalState=r,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set()},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter,this._featureFilter=fi(t.filter,r)),e.layout&&(this._unevaluatedLayout=new $s(e.layout,r)),e.paint)){this._transitionablePaint=new Vs(e.paint,r);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Os(e.paint);}}setFilter(t){this.filter=t,this._featureFilter=fi(t,this._globalState);}getCrossfadeParameters(){return this._crossfadeParameters;}getLayoutProperty(t){return"visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t);}getLayoutAffectingGlobalStateRefs(){const t=new Set();if(this._unevaluatedLayout)for(const e in this._unevaluatedLayout._values){const r=this._unevaluatedLayout._values[e];for(const e of r.getGlobalStateRefs())t.add(e);}for(const e of this._featureFilter.getGlobalStateRefs())t.add(e);return t;}getPaintAffectingGlobalStateRefs(){var t;const e=new globalThis.Map();if(this._transitionablePaint)for(const r in this._transitionablePaint._values){const n=this._transitionablePaint._values[r].value;for(const i of n.getGlobalStateRefs()){const s=null!==(t=e.get(i))&&void 0!==t?t:[];s.push({name:r,value:n.value}),e.set(i,s);}}return e;}setLayoutProperty(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};null!=e&&this._validate(ss,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return t.endsWith(Xs)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t);}setPaintProperty(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};if(null!=e&&this._validate(is,`layers.${this.id}.paint.${t}`,t,e,r))return!1;if(t.endsWith(Xs))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,a);}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return!1;}isHidden(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:!1;return!!(this.minzoom&&t<(e?Math.floor(this.minzoom):this.minzoom))||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility;}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition();}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),U(t,(t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length));}_validate(t,e,r,n){let i=arguments.length>4&&arguments[4]!==undefined?arguments[4]:{};return(!i||!1!==i.validate)&&as(this,t.call(es,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:vt,style:{glyphs:!0,sprite:!0}}));}is3D(){return!1;}isTileClipped(){return!1;}hasOffscreenPass(){return!1;}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Ls&&Nn(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return!0;}return!1;}}let Ys;var Hs={get paint(){return Ys=Ys||new Gs({"raster-opacity":new Rs(vt.paint_raster["raster-opacity"]),"raster-hue-rotate":new Rs(vt.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Rs(vt.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Rs(vt.paint_raster["raster-brightness-max"]),"raster-saturation":new Rs(vt.paint_raster["raster-saturation"]),"raster-contrast":new Rs(vt.paint_raster["raster-contrast"]),"raster-resampling":new Rs(vt.paint_raster["raster-resampling"]),"raster-fade-duration":new Rs(vt.paint_raster["raster-fade-duration"])});}};class Ks extends Zs{constructor(t,e){super(t,Hs,e);}}const Js={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Ws{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class Qs{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer};}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e;}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout");}}function ta(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:1;let r=0,n=0;return{members:t.map(t=>{const i=Js[t.type].BYTES_PER_ELEMENT,s=r=ea(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s};}),size:ea(r,Math.max(n,e)),alignment:e};}function ea(t,e){return Math.ceil(t/e)*e;}class ra extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e);}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t;}}ra.prototype.bytesPerElement=4,us("StructArrayLayout2i4",ra);class na extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r);}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t;}}na.prototype.bytesPerElement=6,us("StructArrayLayout3i6",na);class ia extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n);}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t;}}ia.prototype.bytesPerElement=8,us("StructArrayLayout4i8",ia);class sa extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s);}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t;}}sa.prototype.bytesPerElement=12,us("StructArrayLayout2i4i12",sa);class aa extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s);}emplace(t,e,r,n,i,s,a){const o=4*t,l=8*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=a,t;}}aa.prototype.bytesPerElement=8,us("StructArrayLayout2i4ub8",aa);class oa extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e);}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t;}}oa.prototype.bytesPerElement=8,us("StructArrayLayout2f8",oa);class la extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,a,o,l,u);}emplace(t,e,r,n,i,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t;}}la.prototype.bytesPerElement=20,us("StructArrayLayout10ui20",la);class ua extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o){const l=this.length;return this.resize(l+1),this.emplace(l,t,e,r,n,i,s,a,o);}emplace(t,e,r,n,i,s,a,o,l){const u=8*t;return this.uint16[u+0]=e,this.uint16[u+1]=r,this.uint16[u+2]=n,this.uint16[u+3]=i,this.uint16[u+4]=s,this.uint16[u+5]=a,this.uint16[u+6]=o,this.uint16[u+7]=l,t;}}ua.prototype.bytesPerElement=16,us("StructArrayLayout8ui16",ua);class ca extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h);}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=a,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t;}}ca.prototype.bytesPerElement=24,us("StructArrayLayout4i4ui4i24",ca);class ha extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r);}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t;}}ha.prototype.bytesPerElement=12,us("StructArrayLayout3f12",ha);class pa extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t);}emplace(t,e){return this.uint32[1*t+0]=e,t;}}pa.prototype.bytesPerElement=4,us("StructArrayLayout1ul4",pa);class fa extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,a,o,l);}emplace(t,e,r,n,i,s,a,o,l,u){const c=10*t,h=5*t;return this.int16[c+0]=e,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=a,this.uint32[h+3]=o,this.uint16[c+8]=l,this.uint16[c+9]=u,t;}}fa.prototype.bytesPerElement=20,us("StructArrayLayout6i1ul2ui20",fa);class da extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s);}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t;}}da.prototype.bytesPerElement=12,us("StructArrayLayout2i2i2i12",da);class ya extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i);}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t;}}ya.prototype.bytesPerElement=16,us("StructArrayLayout2f1f2i16",ya);class ma extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s);}emplace(t,e,r,n,i,s,a){const o=16*t,l=4*t,u=8*t;return this.uint8[o+0]=e,this.uint8[o+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.int16[u+6]=s,this.int16[u+7]=a,t;}}ma.prototype.bytesPerElement=16,us("StructArrayLayout2ub2f2i16",ma);class ga extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r);}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t;}}ga.prototype.bytesPerElement=6,us("StructArrayLayout3ui6",ga);class xa extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m);}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=a,this.uint32[v+4]=o,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t;}}xa.prototype.bytesPerElement=48,us("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",xa);class va extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,M,I){const z=this.length;return this.resize(z+1),this.emplace(z,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,M,I);}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,M,I,z){const P=32*t,C=16*t;return this.int16[P+0]=e,this.int16[P+1]=r,this.int16[P+2]=n,this.int16[P+3]=i,this.int16[P+4]=s,this.int16[P+5]=a,this.int16[P+6]=o,this.int16[P+7]=l,this.uint16[P+8]=u,this.uint16[P+9]=c,this.uint16[P+10]=h,this.uint16[P+11]=p,this.uint16[P+12]=f,this.uint16[P+13]=d,this.uint16[P+14]=y,this.uint16[P+15]=m,this.uint16[P+16]=g,this.uint16[P+17]=x,this.uint16[P+18]=v,this.uint16[P+19]=b,this.uint16[P+20]=w,this.uint16[P+21]=_,this.uint16[P+22]=S,this.uint32[C+12]=A,this.float32[C+13]=k,this.float32[C+14]=M,this.uint16[P+30]=I,this.uint16[P+31]=z,t;}}va.prototype.bytesPerElement=64,us("StructArrayLayout8i15ui1ul2f2ui64",va);class ba extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t);}emplace(t,e){return this.float32[1*t+0]=e,t;}}ba.prototype.bytesPerElement=4,us("StructArrayLayout1f4",ba);class wa extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r);}emplace(t,e,r,n){const i=3*t;return this.uint16[6*t+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t;}}wa.prototype.bytesPerElement=12,us("StructArrayLayout1ui2f12",wa);class _a extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r);}emplace(t,e,r,n){const i=4*t;return this.uint32[2*t+0]=e,this.uint16[i+2]=r,this.uint16[i+3]=n,t;}}_a.prototype.bytesPerElement=8,us("StructArrayLayout1ul2ui8",_a);class Sa extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e);}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t;}}Sa.prototype.bytesPerElement=4,us("StructArrayLayout2ui4",Sa);class Aa extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t);}emplace(t,e){return this.uint16[1*t+0]=e,t;}}Aa.prototype.bytesPerElement=2,us("StructArrayLayout1ui2",Aa);class ka extends Qs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n);}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t;}}ka.prototype.bytesPerElement=16,us("StructArrayLayout4f16",ka);class Ma extends Ws{get anchorPointX(){return this._structArray.int16[this._pos2+0];}get anchorPointY(){return this._structArray.int16[this._pos2+1];}get x1(){return this._structArray.int16[this._pos2+2];}get y1(){return this._structArray.int16[this._pos2+3];}get x2(){return this._structArray.int16[this._pos2+4];}get y2(){return this._structArray.int16[this._pos2+5];}get featureIndex(){return this._structArray.uint32[this._pos4+3];}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8];}get bucketIndex(){return this._structArray.uint16[this._pos2+9];}get anchorPoint(){return new r(this.anchorPointX,this.anchorPointY);}}Ma.prototype.size=20;class Ia extends fa{get(t){return new Ma(this,t);}}us("CollisionBoxArray",Ia);class za extends Ws{get anchorX(){return this._structArray.int16[this._pos2+0];}get anchorY(){return this._structArray.int16[this._pos2+1];}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2];}get numGlyphs(){return this._structArray.uint16[this._pos2+3];}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2];}get lineStartIndex(){return this._structArray.uint32[this._pos4+3];}get lineLength(){return this._structArray.uint32[this._pos4+4];}get segment(){return this._structArray.uint16[this._pos2+10];}get lowerSize(){return this._structArray.uint16[this._pos2+11];}get upperSize(){return this._structArray.uint16[this._pos2+12];}get lineOffsetX(){return this._structArray.float32[this._pos4+7];}get lineOffsetY(){return this._structArray.float32[this._pos4+8];}get writingMode(){return this._structArray.uint8[this._pos1+36];}get placedOrientation(){return this._structArray.uint8[this._pos1+37];}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38];}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10];}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22];}}za.prototype.size=48;class Pa extends xa{get(t){return new za(this,t);}}us("PlacedSymbolArray",Pa);class Ca extends Ws{get anchorX(){return this._structArray.int16[this._pos2+0];}get anchorY(){return this._structArray.int16[this._pos2+1];}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2];}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3];}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4];}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5];}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6];}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7];}get key(){return this._structArray.uint16[this._pos2+8];}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9];}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10];}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11];}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12];}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13];}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14];}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15];}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16];}get featureIndex(){return this._structArray.uint16[this._pos2+17];}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18];}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19];}get numIconVertices(){return this._structArray.uint16[this._pos2+20];}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21];}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22];}get crossTileID(){return this._structArray.uint32[this._pos4+12];}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13];}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14];}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30];}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31];}}Ca.prototype.size=64;class Ea extends va{get(t){return new Ca(this,t);}}us("SymbolInstanceArray",Ea);class Ta extends ba{getoffsetX(t){return this.float32[1*t+0];}}us("GlyphOffsetArray",Ta);class Ba extends na{getx(t){return this.int16[3*t+0];}gety(t){return this.int16[3*t+1];}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2];}}us("SymbolLineVertexArray",Ba);class Va extends Ws{get textAnchor(){return this._structArray.uint16[this._pos2+0];}get textOffset0(){return this._structArray.float32[this._pos4+1];}get textOffset1(){return this._structArray.float32[this._pos4+2];}}Va.prototype.size=12;class Fa extends wa{get(t){return new Va(this,t);}}us("TextAnchorOffsetArray",Fa);class Da extends Ws{get featureIndex(){return this._structArray.uint32[this._pos4+0];}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2];}get bucketIndex(){return this._structArray.uint16[this._pos2+3];}}Da.prototype.size=8;class $a extends _a{get(t){return new Da(this,t);}}us("FeatureIndexArray",$a);class La extends ra{}class Oa extends ra{}class Ra extends ra{}class Ua extends sa{}class ja extends aa{}class Na extends oa{}class qa extends la{}class Ga extends ua{}class Xa extends ca{}class Za extends ha{}class Ya extends pa{}class Ha extends da{}class Ka extends ma{}class Ja extends ga{}class Wa extends Sa{}const Qa=ta([{name:"a_pos",components:2,type:"Int16"}],4),{members:to}=Qa;class eo{constructor(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];this._forceNewSegmentOnNextPrepare=!1,this.segments=t;}prepareSegment(t,e,r,n){const i=this.segments[this.segments.length-1];return t>eo.MAX_VERTEX_ARRAY_LENGTH&&q(`Max vertices per segment is ${eo.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${eo.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!i||i.vertexLength+t>eo.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n?this.createNewSegment(e,r,n):i;}createNewSegment(t,e,r){const n={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==r&&(n.sortKey=r),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(n),n;}getOrCreateLatestSegment(t,e,r){return this.prepareSegment(0,t,e,r);}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0;}get(){return this.segments;}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new eo([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}]);}}function ro(t,e){return 256*(t=D(Math.floor(t),0,255))+D(Math.floor(e),0,255);}eo.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,us("SegmentVector",eo);const no=ta([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]),io=ta([{name:"a_dasharray_from",components:4,type:"Uint16"},{name:"a_dasharray_to",components:4,type:"Uint16"}]);var so,ao,oo,lo={exports:{}},uo={exports:{}},co={exports:{}},ho=function(){if(oo)return lo.exports;oo=1;var t=(so||(so=1,uo.exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0;}),uo.exports),e=(ao||(ao=1,co.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0;}),co.exports);return lo.exports=t,lo.exports.murmur3=t,lo.exports.murmur2=e,lo.exports;}(),po=n(ho);class fo{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(yo(t)),this.positions.push(e,r,n);}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=yo(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i;}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return mo(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n};}static deserialize(t){const e=new fo();return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e;}}function yo(t){const e=+t;return!isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:po(String(t));}function mo(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;go(t,s,a),go(e,3*s,3*a),go(e,3*s+1,3*a+1),go(e,3*s+2,3*a+2);}a-r<n-a?(mo(t,e,r,a),r=a+1):(mo(t,e,a+1,n),n=a);}}function go(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}us("FeaturePositionMap",fo);class xo{constructor(t,e){this.gl=t.gl,this.location=e;}}class vo extends xo{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class bo extends xo{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class wo extends xo{constructor(t,e){super(t,e),this.current=Ie.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const _o=new Float32Array(16);function So(t){return[ro(255*t.r,255*t.g),ro(255*t.b,255*t.a)];}class Ao{constructor(t,e,r){this.value=t,this.uniformNames=e.map(t=>`u_${t}`),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return"color"===this.type?new wo(t,e):new vo(t,e);}}class ko{constructor(t,e){this.uniformNames=e.map(t=>`u_${t}`),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr;}setConstantDashPositions(t,e){this.dashTo=[0,t.y,t.height,t.width],this.dashFrom=[0,e.y,e.height,e.width];}setUniform(t,e,r,n){let i=null;"u_pattern_to"===n?i=this.patternTo:"u_pattern_from"===n?i=this.patternFrom:"u_dasharray_to"===n?i=this.dashTo:"u_dasharray_from"===n?i=this.dashFrom:"u_pixel_ratio_to"===n?i=this.pixelRatioTo:"u_pixel_ratio_from"===n&&(i=this.pixelRatioFrom),null!==i&&t.set(i);}getBinding(t,e,r){return"u_pattern"===r.substr(0,9)||"u_dasharray_"===r.substr(0,12)?new bo(t,e):new vo(t,e);}}class Mo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map(t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0})),this.paintVertexArray=new n();}populatePaintArray(t,e,r){const n=this.paintVertexArray.length,i=this.expression.evaluate(new Cs(0,r),e,{},r.canonical,[],r.formattedSection);this.paintVertexArray.resize(t),this._setPaintValue(n,t,i);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Cs(0,i),r,n);this._setPaintValue(t,e,s);}_setPaintValue(t,e,r){if("color"===this.type){const n=So(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else{for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Io{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map(t=>`u_${t}_t`),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map(t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0})),this.paintVertexArray=new s();}populatePaintArray(t,e,r){const n=this.expression.evaluate(new Cs(this.zoom,r),e,{},r.canonical,[],r.formattedSection),i=this.expression.evaluate(new Cs(this.zoom+1,r),e,{},r.canonical,[],r.formattedSection),s=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(s,t,n,i);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Cs(this.zoom,i),r,n),a=this.expression.evaluate(new Cs(this.zoom+1,i),r,n);this._setPaintValue(t,e,s,a);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=So(r),s=So(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else{for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=D(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n);}getBinding(t,e,r){return new vo(t,e);}}class zo{constructor(t,e,r,n,i,s){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i(),this.zoomOutPaintVertexArray=new i();}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,this.getPositionIds(e),r);}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,this.getPositionIds(r),i);}_setPaintValues(t,e,r,n){const i=this.getPositions(n);if(!i||!r)return;const s=i[r.min],a=i[r.mid],o=i[r.max];if(s&&a&&o)for(let r=t;r<e;r++)this.emplace(this.zoomInPaintVertexArray,r,a,s),this.emplace(this.zoomOutPaintVertexArray,r,a,o);}upload(t){if(this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer){const e=this.getVertexAttributes();this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,e,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,e,this.expression.isStateDependent);}}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class Po extends zo{getPositions(t){return t.imagePositions;}getPositionIds(t){return t.patterns&&t.patterns[this.layerId];}getVertexAttributes(){return no.members;}emplace(t,e,r,n){t.emplace(e,r.tlbr[0],r.tlbr[1],r.tlbr[2],r.tlbr[3],n.tlbr[0],n.tlbr[1],n.tlbr[2],n.tlbr[3],r.pixelRatio,n.pixelRatio);}}class Co extends zo{getPositions(t){return t.dashPositions;}getPositionIds(t){return t.dashes&&t.dashes[this.layerId];}getVertexAttributes(){return io.members;}emplace(t,e,r,n){t.emplace(e,0,r.y,r.height,r.width,0,n.y,n.height,n.width);}}class Eo{constructor(t,e,r){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof Ls&&Nn(s.property.specification)))continue;const a=Bo(i,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[i]=h?new ko(o.value,a):new Ao(o.value,a,l),n.push(`/u_${i}`);else if("source"===o.kind||h){const r=Vo(i,l,"source");this.binders[i]=h?"line-dasharray"===i?new Co(o,l,u,e,r,t.id):new Po(o,l,u,e,r,t.id):new Mo(o,a,l,r),n.push(`/a_${i}`);}else{const t=Vo(i,l,"composite");this.binders[i]=new Io(o,a,l,u,e,t),n.push(`/z_${i}`);}}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Mo||e instanceof Io?e.maxValue:0;}populatePaintArrays(t,e,r){for(const n in this.binders){const i=this.binders[n];(i instanceof Mo||i instanceof Io||i instanceof zo)&&i.populatePaintArray(t,e,r);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof ko&&n.setConstantPatternPositions(t,e);}}setConstantDashPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof ko&&n.setConstantDashPositions(t,e);}}updatePaintArrays(t,e,r,n,i){let s=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Mo||l instanceof Io||l instanceof zo)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,o,t[a],i),s=!0;}}}}return s;}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Ao||r instanceof ko)&&t.push(...r.uniformNames.map(t=>`#define HAS_UNIFORM_${t}`));}return t;}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Mo||r instanceof Io)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof zo){const e=r.getVertexAttributes();for(const r of e)t.push(r.name);}}return t;}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Ao||r instanceof ko||r instanceof Io)for(const e of r.uniformNames)t.push(e);}return t;}getPaintVertexBuffers(){return this._buffers;}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof Ao||i instanceof ko||i instanceof Io)for(const s of i.uniformNames)if(e[s]){const a=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:a});}}return r;}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof zo){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else(r instanceof Mo||r instanceof Io)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Mo||r instanceof Io||r instanceof zo)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Mo||e instanceof Io||e instanceof zo)&&e.destroy();}}}class To{constructor(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:()=>!0;this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new Eo(n,e,r);this.needsUpload=!1,this._featureMap=new fo(),this._bufferOffset=0;}populatePaintArrays(t,e,r,n){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload;}get(t){return this.programConfigurations[t];}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function Bo(t,e){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-dasharray":["dasharray_to","dasharray_from"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")];}function Vo(t,e,r){const n={color:{source:oa,composite:ka},number:{source:ba,composite:oa}},i=function(t){return{"line-pattern":{source:qa,composite:qa},"fill-pattern":{source:qa,composite:qa},"fill-extrusion-pattern":{source:qa,composite:qa},"line-dasharray":{source:Ga,composite:Ga}}[t];}(t);return i&&i[r]||n[e][r];}us("ConstantBinder",Ao),us("CrossFadedConstantBinder",ko),us("SourceExpressionBinder",Mo),us("CrossFadedPatternBinder",Po),us("CrossFadedDasharrayBinder",Co),us("CompositeExpressionBinder",Io),us("ProgramConfiguration",Eo,{omit:["_buffers"]}),us("ProgramConfigurationSet",To);const Fo=Math.pow(2,14)-1,Do=-Fo-1;function $o(t){const e=P/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=D(i,Do,Fo),r.y=D(s,Do,Fo),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&q("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r;}function Lo(t,e){return{type:t.type,id:t.id,properties:t.properties,geometry:e?$o(t):[]};}const Oo=-32768;function Ro(t,e,r,n,i){t.emplaceBack(Oo+8*e+n,Oo+8*r+i);}class Uo{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasDependencies=!1,this.layoutVertexArray=new Oa(),this.indexArray=new Ja(),this.segments=new eo(),this.programConfigurations=new To(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){const n=this.layers[0],i=[];let s=null,a=!1,o="heatmap"===n.type;if("circle"===n.type){const t=n;s=t.layout.get("circle-sort-key"),a=!s.isConstant(),o=o||"map"===t.paint.get("circle-pitch-alignment");}const l=o?e.subdivisionGranularity.circle:1;for(const{feature:e,id:n,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Lo(e,t);if(!this.layers[0]._featureFilter.filter(new Cs(this.zoom),u,r))continue;const c=a?s.evaluate(u,{},r):void 0,h={id:n,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:$o(e),patterns:{},sortKey:c};i.push(h);}a&&i.sort((t,e)=>t.sortKey-e.sortKey);for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n,o=t[s].feature;this.addFeature(n,i,s,r,l),e.featureIndex.insert(o,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r});}isEmpty(){return 0===this.layoutVertexArray.length;}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload;}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,to),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n){let i=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;let s;switch(i){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${i}; valid values are 1, 3, 5, 7.`);}const a=s.length;for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=P||n<0||n>=P)continue;const i=this.segments.prepareSegment(a*a,this.layoutVertexArray,this.indexArray,t.sortKey),o=i.vertexLength;for(let t=0;t<a;t++)for(let e=0;e<a;e++)Ro(this.layoutVertexArray,r,n,s[e],s[t]);for(let t=0;t<a-1;t++)for(let e=0;e<a-1;e++){const r=o+t*a+e,n=o+(t+1)*a+e;this.indexArray.emplaceBack(r,n+1,r+1),this.indexArray.emplaceBack(r,n,n+1);}i.vertexLength+=a*a,i.primitiveLength+=(a-1)*(a-1)*2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:{},canonical:n});}}function jo(t,e){for(let r=0;r<t.length;r++)if(Jo(e,t[r]))return!0;for(let r=0;r<e.length;r++)if(Jo(t,e[r]))return!0;return!!Xo(t,e);}function No(t,e,r){return!!Jo(t,e)||!!Yo(e,t,r);}function qo(t,e){if(1===t.length)return Ko(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(Jo(t,n[e]))return!0;}for(let r=0;r<t.length;r++)if(Ko(e,t[r]))return!0;for(let r=0;r<e.length;r++)if(Xo(t,e[r]))return!0;return!1;}function Go(t,e,r){if(t.length>1){if(Xo(t,e))return!0;for(let n=0;n<e.length;n++)if(Yo(e[n],t,r))return!0;}for(let n=0;n<t.length;n++)if(Yo(t[n],e,r))return!0;return!1;}function Xo(t,e){if(0===t.length||0===e.length)return!1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(Zo(n,i,e[t],e[t+1]))return!0;}return!1;}function Zo(t,e,r,n){return G(t,r,n)!==G(e,r,n)&&G(t,e,r)!==G(t,e,n);}function Yo(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(Ho(t,e[r-1],e[r])<n)return!0;return!1;}function Ho(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e));}function Ko(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s;}function Jo(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r;}function Wo(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return!1;const s=G(t,e,r[0]);return s!==G(t,e,r[1])||s!==G(t,e,r[2])||s!==G(t,e,r[3]);}function Qo(t,e,r){const n=e.paint.get(t).value;return"constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t);}function tl(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1]);}function el(t,e,n,i,s){if(!e[0]&&!e[1])return t;const a=r.convert(e)._mult(s);"viewport"===n&&a._rotate(-i);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(a));return o;}function rl(_ref60,r){let{queryGeometry:t,size:e}=_ref60;return No(t,r,e);}function nl(_ref61,s){let{queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i}=_ref61;return No(t,s,e*(r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera/r.cameraToCenterDistance));}function il(_ref62,s){let{queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i}=_ref62;const a=r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera,o=e*(r.cameraToCenterDistance/a);return No(t,ol(s,r,n,i),o);}function sl(_ref63,s){let{queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i}=_ref63;return No(t,ol(s,r,n,i),e);}function al(_ref64,o){let{queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i,pitchAlignment:s="map",pitchScale:a="map"}=_ref64;const l="map"===s?"map"===a?rl:nl:"map"===a?il:sl,u={queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i};for(const t of o)for(const e of t)if(l(u,e))return!0;return!1;}function ol(t,e,n,i){const s=e.projectTileCoordinates(t.x,t.y,n,i).point;return new r((.5*s.x+.5)*e.width,(.5*-s.y+.5)*e.height);}let ll,ul;us("CircleBucket",Uo,{omit:["layers"]});var cl={get paint(){return ul=ul||new Gs({"circle-radius":new Us(vt.paint_circle["circle-radius"]),"circle-color":new Us(vt.paint_circle["circle-color"]),"circle-blur":new Us(vt.paint_circle["circle-blur"]),"circle-opacity":new Us(vt.paint_circle["circle-opacity"]),"circle-translate":new Rs(vt.paint_circle["circle-translate"]),"circle-translate-anchor":new Rs(vt.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Rs(vt.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Rs(vt.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Us(vt.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Us(vt.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Us(vt.paint_circle["circle-stroke-opacity"])});},get layout(){return ll=ll||new Gs({"circle-sort-key":new Us(vt.layout_circle["circle-sort-key"])});}};class hl extends Zs{constructor(t,e){super(t,cl,e);}createBucket(t){return new Uo(t);}queryRadius(t){const e=t;return Qo("circle-radius",this,e)+Qo("circle-stroke-width",this,e)+tl(this.paint.get("circle-translate"));}queryIntersectsFeature(_ref65){let{queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:a,getElevation:o}=_ref65;const l=el(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-i.bearingInRadians,s),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),c=this.paint.get("circle-pitch-scale"),h=this.paint.get("circle-pitch-alignment");let p,f;return"map"===h?(p=l,f=u*s):(p=function(t,e,r,n){return t.map(t=>ol(t,e,r,n));}(l,i,a,o),f=u),al({queryGeometry:p,size:f,transform:i,unwrappedTileID:a,getElevation:o,pitchAlignment:h,pitchScale:c},n);}}class pl extends Uo{}let fl;us("HeatmapBucket",pl,{omit:["layers"]});var dl={get paint(){return fl=fl||new Gs({"heatmap-radius":new Us(vt.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Us(vt.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Rs(vt.paint_heatmap["heatmap-intensity"]),"heatmap-color":new qs(vt.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Rs(vt.paint_heatmap["heatmap-opacity"])});}};function yl(t,_ref66,n,i){let{width:e,height:r}=_ref66;if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${e*r*n}`);}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t;}function ml(t,_ref67,n){let{width:e,height:r}=_ref67;if(e===t.width&&r===t.height)return;const i=yl({},{width:e,height:r},n);gl(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data;}function gl(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;if(a===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)o[c+t]=a[u+t];}return e;}class xl{constructor(t,e){yl(this,t,1,e);}resize(t){ml(this,t,1);}clone(){return new xl({width:this.width,height:this.height},new Uint8Array(this.data));}static copy(t,e,r,n,i){gl(t,e,r,n,i,1);}}class vl{constructor(t,e){yl(this,t,4,e);}resize(t){ml(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new vl({width:this.width,height:this.height},new Uint8Array(this.data));}static copy(t,e,r,n,i){gl(t,e,r,n,i,4);}setPixel(t,e,r){const n=4*(t*this.width+e);this.data[n+0]=Math.round(255*r.r/r.a),this.data[n+1]=Math.round(255*r.g/r.a),this.data[n+2]=Math.round(255*r.b/r.a),this.data[n+3]=Math.round(255*r.a);}}function bl(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new vl({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(n,s,a)=>{e[t.evaluationKey]=a;const o=t.expression.evaluate(e);i.setPixel(n/4/r,s/4,o);};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i;}us("AlphaImage",xl),us("RGBAImage",vl);const wl="big-fb";class _l extends Zs{createBucket(t){return new pl(t);}constructor(t,e){super(t,dl,e),this.heatmapFbos=new Map(),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=bl({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbos.has(wl)&&this.heatmapFbos.delete(wl);}queryRadius(t){return Qo("heatmap-radius",this,t);}queryIntersectsFeature(_ref68){let{queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:a,getElevation:o}=_ref68;return al({queryGeometry:t,size:this.paint.get("heatmap-radius").evaluate(e,r)*s,transform:i,unwrappedTileID:a,getElevation:o},n);}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility;}}let Sl;var Al={get paint(){return Sl=Sl||new Gs({"hillshade-illumination-direction":new Rs(vt.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new Rs(vt.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new Rs(vt.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Rs(vt.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Rs(vt.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Rs(vt.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Rs(vt.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new Rs(vt.paint_hillshade["hillshade-method"])});}};class kl extends Zs{constructor(t,e){super(t,Al,e),this.recalculate({zoom:0,zoomHistory:{}},void 0);}getIlluminationProperties(){let t=this.paint.get("hillshade-illumination-direction").values,e=this.paint.get("hillshade-illumination-altitude").values,r=this.paint.get("hillshade-highlight-color").values,n=this.paint.get("hillshade-shadow-color").values;const i=Math.max(t.length,e.length,r.length,n.length);t=t.concat(Array(i-t.length).fill(t.at(-1))),e=e.concat(Array(i-e.length).fill(e.at(-1))),r=r.concat(Array(i-r.length).fill(r.at(-1))),n=n.concat(Array(i-n.length).fill(n.at(-1)));const s=e.map(et);return{directionRadians:t.map(et),altitudeRadians:s,shadowColor:n,highlightColor:r};}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility;}}let Ml;var Il={get paint(){return Ml=Ml||new Gs({"color-relief-opacity":new Rs(vt["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new qs(vt["paint_color-relief"]["color-relief-color"])});}};class zl{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n);}update(t,e,r){const{width:n,height:i}=t,s=!(this.size&&this.size[0]===n&&this.size[1]===i||r),{context:a}=this,{gl:o}=a;if(this.useMipmap=Boolean(e&&e.useMipmap),o.bindTexture(o.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[n,i],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||H(t)?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,t):o.texImage2D(o.TEXTURE_2D,0,this.format,n,i,0,this.format,o.UNSIGNED_BYTE,t.data);else{const{x:e,y:s}=r||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||H(t)?o.texSubImage2D(o.TEXTURE_2D,0,e,s,o.RGBA,o.UNSIGNED_BYTE,t):o.texSubImage2D(o.TEXTURE_2D,0,e,s,n,i,o.RGBA,o.UNSIGNED_BYTE,t.data);}this.useMipmap&&this.isSizePowerOfTwo()&&o.generateMipmap(o.TEXTURE_2D),a.pixelStoreUnpackFlipY.setDefault(),a.pixelStoreUnpack.setDefault(),a.pixelStoreUnpackPremultiplyAlpha.setDefault();}bind(t,e,r){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),r!==i.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=i.LINEAR),t!==this.filter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,r||t),this.filter=t),e!==this.wrap&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0;}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class Pl{constructor(t,e,r){let n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:1;let i=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;let s=arguments.length>5&&arguments[5]!==undefined?arguments[5]:1;let a=arguments.length>6&&arguments[6]!==undefined?arguments[6]:0;if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void q(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const o=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),r){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=a;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4;}for(let t=0;t<o;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(o,t)]=this.data[this._idx(o-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,o)]=this.data[this._idx(t,o-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(o,-1)]=this.data[this._idx(o-1,0)],this.data[this._idx(-1,o)]=this.data[this._idx(0,o-1)],this.data[this._idx(o,o)]=this.data[this._idx(o-1,o-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<o;t++)for(let e=0;e<o;e++){const r=this.get(t,e);r>this.max&&(this.max=r),r<this.min&&(this.min=r);}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return this.unpack(r[n],r[n+1],r[n+2]);}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift];}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(e+1)*this.stride+(t+1);}unpack(t,e,r){return t*this.redFactor+e*this.greenFactor+r*this.blueFactor-this.baseShift;}pack(t){return Cl(t,this.getUnpackVector());}getPixels(){return new vl({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer));}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}}function Cl(t,e){const r=e[0],n=e[1],i=e[2],s=e[3],a=Math.min(r,n,i),o=Math.round((t+s)/a);return{r:Math.floor(o*a/r)%256,g:Math.floor(o*a/n)%256,b:Math.floor(o*a/i)%256};}us("DEMData",Pl);class El extends Zs{constructor(t,e){super(t,Il,e);}_createColorRamp(t){const e={elevationStops:[],colorStops:[]},r=this._transitionablePaint._values["color-relief-color"].value.expression;if(r instanceof ii&&r._styleExpression.expression instanceof fr){this.colorRampExpression=r;const t=r._styleExpression.expression;e.elevationStops=t.labels,e.colorStops=[];for(const r of e.elevationStops)e.colorStops.push(t.evaluate({globals:{elevation:r}}));}if(e.elevationStops.length<1&&(e.elevationStops=[0],e.colorStops=[Ie.transparent]),e.elevationStops.length<2&&(e.elevationStops.push(e.elevationStops[0]+1),e.colorStops.push(e.colorStops[0])),e.elevationStops.length<=t)return e;const n={elevationStops:[],colorStops:[]},i=(e.elevationStops.length-1)/(t-1);for(let t=0;t<e.elevationStops.length-.5;t+=i)n.elevationStops.push(e.elevationStops[Math.round(t)]),n.colorStops.push(e.colorStops[Math.round(t)]);return q(`Too many colors in specification of ${this.id} color-relief layer, may not render properly. Max possible colors: ${t}, provided: ${e.elevationStops.length}`),n;}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression;}getColorRampTextures(t,e,r){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const n=this._createColorRamp(e),i=new vl({width:n.colorStops.length,height:1}),s=new vl({width:n.colorStops.length,height:1});for(let t=0;t<n.elevationStops.length;t++){const e=Cl(n.elevationStops[t],r);s.setPixel(0,t,new Ie(e.r/255,e.g/255,e.b/255,1)),i.setPixel(0,t,n.colorStops[t]);}return this.colorRampTextures={elevationTexture:new zl(t,s,t.gl.RGBA),colorTexture:new zl(t,i,t.gl.RGBA)},this.colorRampTextures;}hasOffscreenPass(){return"none"!==this.visibility&&!!this.colorRampTextures;}}const Tl=ta([{name:"a_pos",components:2,type:"Int16"}],4),{members:Bl}=Tl;function Vl(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0);}return i;}function Fl(t,e,r,n,i){const{zoom:s}=n,a=i.patternDependencies;for(const n of e){const e=n.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:s-1},r,{},i.availableImages),o=e.evaluate({zoom:s},r,{},i.availableImages),l=e.evaluate({zoom:s+1},r,{},i.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,a[t]=!0,a[o]=!0,a[l]=!0,r.patterns[n.id]={min:t,mid:o,max:l};}}return r;}function Dl(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i;}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=iu(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=iu(i/n|0,t[i],t[i+1],s);return s&&Wl(s,s.next)&&(su(s),s=s.next),s;}function $l(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!Wl(n,n.next)&&0!==Jl(n.prev,n,n.next))n=n.next;else{if(su(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e;}function Ll(t,e,r,n,i,s,a){if(!t)return;!a&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=Xl(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let a=i,o=0;for(let t=0;t<r&&(o++,a=a.nextZ,a);t++);let l=r;for(;o>0||l>0&&a;)0!==o&&(0===l||!a||i.z<=a.z)?(n=i,i=i.nextZ,o--):(n=a,a=a.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=a;}s.nextZ=null,r*=2;}while(e>1);}(i);}(t,n,i,s);let o=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?Rl(t,n,i,s):Ol(t))e.push(l.i,t.i,u.i),su(t),t=u.next,o=u.next;else if((t=u)===o){a?1===a?Ll(t=Ul($l(t),e),e,r,n,i,s,2):2===a&&jl(t,e,r,n,i,s):Ll($l(t),e,r,n,i,s,1);break;}}}function Ol(t){const e=t.prev,r=t,n=t.next;if(Jl(e,r,n)>=0)return!1;const i=e.x,s=r.x,a=n.x,o=e.y,l=r.y,u=n.y,c=Math.min(i,s,a),h=Math.min(o,l,u),p=Math.max(i,s,a),f=Math.max(o,l,u);let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&Hl(i,o,s,l,a,u,d.x,d.y)&&Jl(d.prev,d,d.next)>=0)return!1;d=d.next;}return!0;}function Rl(t,e,r,n){const i=t.prev,s=t,a=t.next;if(Jl(i,s,a)>=0)return!1;const o=i.x,l=s.x,u=a.x,c=i.y,h=s.y,p=a.y,f=Math.min(o,l,u),d=Math.min(c,h,p),y=Math.max(o,l,u),m=Math.max(c,h,p),g=Xl(f,d,e,r,n),x=Xl(y,m,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&Hl(o,c,l,h,u,p,v.x,v.y)&&Jl(v.prev,v,v.next)>=0)return!1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&Hl(o,c,l,h,u,p,b.x,b.y)&&Jl(b.prev,b,b.next)>=0)return!1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&Hl(o,c,l,h,u,p,v.x,v.y)&&Jl(v.prev,v,v.next)>=0)return!1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&Hl(o,c,l,h,u,p,b.x,b.y)&&Jl(b.prev,b,b.next)>=0)return!1;b=b.nextZ;}return!0;}function Ul(t,e){let r=t;do{const n=r.prev,i=r.next.next;!Wl(n,i)&&Ql(n,r,r.next,i)&&ru(n,i)&&ru(i,n)&&(e.push(n.i,r.i,i.i),su(r),su(r.next),r=t=i),r=r.next;}while(r!==t);return $l(r);}function jl(t,e,r,n,i,s){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&Kl(a,t)){let o=nu(a,t);return a=$l(a,a.next),o=$l(o,o.next),Ll(a,e,r,n,i,s,0),void Ll(o,e,r,n,i,s,0);}t=t.next;}a=a.next;}while(a!==t);}function Nl(t,e){let r=t.x-e.x;return 0===r&&(r=t.y-e.y,0===r)&&(r=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),r;}function ql(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,a=-1/0;if(Wl(t,r))return r;do{if(Wl(t,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>a&&(a=t,s=r.x<r.next.x?r:r.next,t===n))return s;}r=r.next;}while(r!==e);if(!s)return null;const o=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&Yl(i<u?n:a,i,l,u,i<u?a:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);ru(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&Gl(s,r)))&&(s=r,c=e);}r=r.next;}while(r!==o);return s;}(t,e);if(!r)return e;const n=nu(r,t);return $l(n,n.next),$l(r,r.next);}function Gl(t,e){return Jl(t.prev,t,e.prev)<0&&Jl(e.next,t,t.next)<0;}function Xl(t,e,r,n,i){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1;}function Zl(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r;}function Yl(t,e,r,n,i,s,a,o){return(i-a)*(e-o)>=(t-a)*(s-o)&&(t-a)*(n-o)>=(r-a)*(e-o)&&(r-a)*(s-o)>=(i-a)*(n-o);}function Hl(t,e,r,n,i,s,a,o){return!(t===a&&e===o)&&Yl(t,e,r,n,i,s,a,o);}function Kl(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Ql(r,r.next,t,e))return!0;r=r.next;}while(r!==t);return!1;}(t,e)&&(ru(t,e)&&ru(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n;}(t,e)&&(Jl(t.prev,t,e.prev)||Jl(t,e.prev,e))||Wl(t,e)&&Jl(t.prev,t,t.next)>0&&Jl(e.prev,e,e.next)>0);}function Jl(t,e,r){return(e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y);}function Wl(t,e){return t.x===e.x&&t.y===e.y;}function Ql(t,e,r,n){const i=eu(Jl(t,e,r)),s=eu(Jl(t,e,n)),a=eu(Jl(r,n,t)),o=eu(Jl(r,n,e));return i!==s&&a!==o||!(0!==i||!tu(t,r,e))||!(0!==s||!tu(t,n,e))||!(0!==a||!tu(r,t,n))||!(0!==o||!tu(r,e,n));}function tu(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y);}function eu(t){return t>0?1:t<0?-1:0;}function ru(t,e){return Jl(t.prev,t,t.next)<0?Jl(t,e,t.next)>=0&&Jl(t,t.prev,e)>=0:Jl(t,e,t.prev)<0||Jl(t,t.next,e)<0;}function nu(t,e){const r=au(t.i,t.x,t.y),n=au(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n;}function iu(t,e,r,n){const i=au(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i;}function su(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function au(t,e,r){return{i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1};}class ou{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e;}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1);}}class lu{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle;}}lu.noSubdivision=new lu({fill:new ou(0,0),line:new ou(0,0),tile:new ou(0,0),stencil:new ou(0,0),circle:1}),us("SubdivisionGranularityExpression",ou),us("SubdivisionGranularitySetting",lu);const uu=-32768,cu=32767;class hu{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map(),this._used=!1,this._granularity=t,this._granularityCellSize=P/t,this._canonical=e;}_getKey(t,e){return(t+=32768)<<16|e+32768;}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const r=0|Math.round(t),n=0|Math.round(e),i=this._getKey(r,n);if(this._vertexDictionary.has(i))return this._vertexDictionary.get(i);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(i,s),this._vertexBuffer.push(r,n),s;}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const r=[];for(let n=0;n<e.length;n+=3){const i=e[n],s=e[n+1],a=e[n+2],o=t[2*i],l=t[2*i+1];(t[2*s]-o)*(t[2*a+1]-l)-(t[2*s+1]-l)*(t[2*a]-o)>0?(r.push(i),r.push(a),r.push(s)):(r.push(i),r.push(s),r.push(a));}return r;}(this._vertexBuffer,t);const e=[],r=t.length;for(let n=0;n<r;n+=3){const r=[t[n+0],t[n+1],t[n+2]],i=[this._vertexBuffer[2*t[n+0]+0],this._vertexBuffer[2*t[n+0]+1],this._vertexBuffer[2*t[n+1]+0],this._vertexBuffer[2*t[n+1]+1],this._vertexBuffer[2*t[n+2]+0],this._vertexBuffer[2*t[n+2]+1]];let s=1/0,a=1/0,o=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=i[2*t],r=i[2*t+1];s=Math.min(s,e),o=Math.max(o,e),a=Math.min(a,r),l=Math.max(l,r);}if(s===o||a===l)continue;const u=Math.floor(s/this._granularityCellSize),c=Math.ceil(o/this._granularityCellSize),h=Math.floor(a/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(u!==c||h!==p)for(let t=h;t<p;t++){const n=this._scanlineGenerateVertexRingForCellRow(t,i,r);du(this._vertexBuffer,n,e);}else e.push(...r);}return e;}_scanlineGenerateVertexRingForCellRow(t,e,r){const n=t*this._granularityCellSize,i=n+this._granularityCellSize,s=[];for(let t=0;t<3;t++){const a=e[2*t],o=e[2*t+1],l=e[2*(t+1)%6],u=e[(2*(t+1)+1)%6],c=e[2*(t+2)%6],h=e[(2*(t+2)+1)%6],p=l-a,f=u-o,d=0===p,y=0===f,m=(n-o)/f,g=(i-o)/f,x=Math.min(m,g),v=Math.max(m,g);if(!y&&(x>=1||v<=0)||y&&(o<n||o>i)){u>=n&&u<=i&&s.push(r[(t+1)%3]);continue;}!y&&x>0&&s.push(this._vertexToIndex(a+p*x,o+f*x));const b=a+p*Math.max(x,0),w=a+p*Math.min(v,1);d||this._generateIntraEdgeVertices(s,a,o,l,u,b,w),!y&&v<1&&s.push(this._vertexToIndex(a+p*v,o+f*v)),(y||u>=n&&u<=i)&&s.push(r[(t+1)%3]),!y&&(u<=n||u>=i)&&this._generateInterEdgeVertices(s,a,o,l,u,c,h,w,n,i);}return s;}_generateIntraEdgeVertices(t,e,r,n,i,s,a){const o=n-e,l=i-r,u=0===l,c=u?Math.min(e,n):Math.min(s,a),h=u?Math.max(e,n):Math.max(s,a),p=Math.floor(c/this._granularityCellSize)+1,f=Math.ceil(h/this._granularityCellSize)-1;if(u?e<n:s<a)for(let n=p;n<=f;n++){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/o));}else for(let n=f;n>=p;n--){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/o));}}_generateInterEdgeVertices(t,e,r,n,i,s,a,o,l,u){const c=i-r,h=s-n,p=a-i,f=(l-i)/p,d=(u-i)/p,y=Math.min(f,d),m=Math.max(f,d),g=n+h*y;let x=Math.floor(Math.min(g,o)/this._granularityCellSize)+1,v=Math.ceil(Math.max(g,o)/this._granularityCellSize)-1,b=o<g;const w=0===p;if(w&&(a===l||a===u))return;if(w||y>=1||m<=0){const t=r-a,n=s+(e-s)*Math.min((l-a)/t,(u-a)/t);x=Math.floor(Math.min(n,o)/this._granularityCellSize)+1,v=Math.ceil(Math.max(n,o)/this._granularityCellSize)-1,b=o<n;}const _=c>0?u:l;if(b)for(let e=x;e<=v;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,_));else for(let e=v;e>=x;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,_));}_generateOutline(t){const e=[];for(const r of t){const t=fu(r,this._granularity,!0),n=this._pointArrayToIndices(t),i=[];for(let t=1;t<n.length;t++)i.push(n[t-1]),i.push(n[t]);e.push(i);}return e;}_handlePoles(t){let e=!1,r=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(r=!0)),(e||r)&&this._fillPoles(t,e,r);}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const r=t[e+1];r===uu&&(t[e+1]=-32767),r===cu&&(t[e+1]=32766);}}_generatePoleQuad(t,e,r,n,i,s){n>i!=(s===uu)?(t.push(e),t.push(r),t.push(this._vertexToIndex(n,s)),t.push(r),t.push(this._vertexToIndex(i,s)),t.push(this._vertexToIndex(n,s))):(t.push(r),t.push(e),t.push(this._vertexToIndex(n,s)),t.push(this._vertexToIndex(i,s)),t.push(r),t.push(this._vertexToIndex(n,s)));}_fillPoles(t,e,r){const n=this._vertexBuffer,i=P,s=t.length;for(let a=2;a<s;a+=3){const s=t[a-2],o=t[a-1],l=t[a],u=n[2*s],c=n[2*s+1],h=n[2*o],p=n[2*o+1],f=n[2*l],d=n[2*l+1];e&&(0===c&&0===p&&this._generatePoleQuad(t,s,o,u,h,uu),0===p&&0===d&&this._generatePoleQuad(t,o,l,h,f,uu),0===d&&0===c&&this._generatePoleQuad(t,l,s,f,u,uu)),r&&(c===i&&p===i&&this._generatePoleQuad(t,s,o,u,h,cu),p===i&&d===i&&this._generatePoleQuad(t,o,l,h,f,cu),d===i&&c===i&&this._generatePoleQuad(t,l,s,f,u,cu));}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1]);}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:r,holeIndices:n}=function(t){const e=[],r=[];for(const n of t)if(0!==n.length){n!==t[0]&&e.push(r.length/2);for(let t=0;t<n.length;t++)r.push(n[t].x),r.push(n[t].y);}return{flattened:r,holeIndices:e};}(t);let i;this._initializeVertices(r);try{const t=function(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:2;const n=e&&e.length,i=n?e[0]*r:t.length;let s=Dl(t,0,i,r,!0);const a=[];if(!s||s.next===s.prev)return a;let o,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const a=Dl(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);a===a.next&&(a.steiner=!0),i.push(Zl(a));}i.sort(Nl);for(let t=0;t<i.length;t++)r=ql(i[t],r);return r;}(t,e,s,r)),t.length>80*r){o=t[0],l=t[1];let e=o,n=l;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<o&&(o=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-o,n-l),u=0!==u?32767/u:0;}return Ll(s,a,r,o,l,u,0),a;}(r,n),e=this._convertIndices(r,t);i=this._subdivideTrianglesScanline(e);}catch(t){console.error(t);}let s=[];return e&&(s=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(i),{verticesFlattened:this._vertexBuffer,indicesTriangles:i,indicesLineList:s};}_convertIndices(t,e){const r=[];for(let n=0;n<e.length;n++)r.push(this._vertexToIndex(t[2*e[n]],t[2*e[n]+1]));return r;}_pointArrayToIndices(t){const e=[];for(let r=0;r<t.length;r++){const n=t[r];e.push(this._vertexToIndex(n.x,n.y));}return e;}}function pu(t,e,r){let n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:!0;return new hu(r,e).subdividePolygonInternal(t,n);}function fu(t,e){let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:!1;if(!t||t.length<1)return[];if(t.length<2)return[];const i=t[0],s=t[t.length-1],a=n&&(i.x!==s.x||i.y!==s.y);if(e<2)return a?[...t,t[0]]:[...t];const o=Math.floor(P/e),l=[];l.push(new r(t[0].x,t[0].y));const u=t.length,c=a?u:u-1;for(let e=0;e<c;e++){const n=t[e],i=e<u-1?t[e+1]:t[0],s=n.x,a=n.y,c=i.x,h=i.y,p=s!==c,f=a!==h;if(!p&&!f)continue;const d=c-s,y=h-a,m=Math.abs(d),g=Math.abs(y);let x=s,v=a;for(;;){const t=d>0?(Math.floor(x/o)+1)*o:(Math.ceil(x/o)-1)*o,e=y>0?(Math.floor(v/o)+1)*o:(Math.ceil(v/o)-1)*o,n=Math.abs(x-t),i=Math.abs(v-e),s=Math.abs(x-c),a=Math.abs(v-h),u=p?n/m:Number.POSITIVE_INFINITY,b=f?i/g:Number.POSITIVE_INFINITY;if((s<=n||!p)&&(a<=i||!f))break;if(u<b&&p||!f){x=t,v+=y*u;const e=new r(x,Math.round(v));l[l.length-1].x===e.x&&l[l.length-1].y===e.y||l.push(e);}else{x+=d*b,v=e;const t=new r(Math.round(x),v);l[l.length-1].x===t.x&&l[l.length-1].y===t.y||l.push(t);}}const b=new r(c,h);l[l.length-1].x===b.x&&l[l.length-1].y===b.y||l.push(b);}return l;}function du(t,e,r){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let n=0,i=t[2*e[0]];for(let r=1;r<e.length;r++){const s=t[2*e[r]];s<i&&(i=s,n=r);}const s=e.length;let a=n,o=(a+1)%s;for(;;){const n=a-1>=0?a-1:s-1,i=(o+1)%s,l=t[2*e[n]],u=t[2*e[i]],c=t[2*e[a]],h=t[2*e[a]+1],p=t[2*e[o]+1];let f=!1;if(l<u)f=!0;else if(l>u)f=!1;else{const r=p-h,s=-(t[2*e[o]]-c),a=h<p?1:-1;((l-c)*r+(t[2*e[n]+1]-h)*s)*a>((u-c)*r+(t[2*e[i]+1]-h)*s)*a&&(f=!0);}if(f){const t=e[n],i=e[a],l=e[o];t!==i&&t!==l&&i!==l&&r.push(l,i,t),a--,a<0&&(a=s-1);}else{const t=e[i],n=e[a],l=e[o];t!==n&&t!==l&&n!==l&&r.push(l,n,t),o++,o>=s&&(o=0);}if(n===i)break;}}function yu(t,e,r,n,i,s,a,o,l){const u=i.length/2,c=a&&o&&l;if(u<eo.MAX_VERTEX_ARRAY_LENGTH){const h=e.prepareSegment(u,r,n),p=h.vertexLength;for(let t=0;t<s.length;t+=3)n.emplaceBack(p+s[t],p+s[t+1],p+s[t+2]);let f,d;h.vertexLength+=u,h.primitiveLength+=s.length/3,c&&(d=a.prepareSegment(u,r,o),f=d.vertexLength,d.vertexLength+=u);for(let e=0;e<i.length;e+=2)t(i[e],i[e+1]);if(c)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)o.emplaceBack(f+e[t-1],f+e[t]);d.primitiveLength+=e.length/2;}}else!function(t,e,r,n,i,s){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const o={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=2;h<i.length;h+=3){const p=i[h-2],f=i[h-1],d=i[h];let y=a[p]<l,m=a[f]<l,g=a[d]<l;u.vertexLength+((y?1:0)+(m?1:0)+(g?1:0))>eo.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=o.count,y=!0,m=!0,g=!0,c=0);const x=mu(a,n,s,o,p,y,u),v=mu(a,n,s,o,f,m,u),b=mu(a,n,s,o,d,g,u);r.emplaceBack(c+x-l,c+v-l,c+b-l),u.primitiveLength++;}}(e,r,n,i,s,t),c&&function(t,e,r,n,i,s){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const o={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=0;h<i.length;h++){const p=i[h];for(let f=1;f<i[h].length;f+=2){const i=p[f-1],h=p[f];let d=a[i]<l,y=a[h]<l;u.vertexLength+((d?1:0)+(y?1:0))>eo.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=o.count,d=!0,y=!0,c=0);const m=mu(a,n,s,o,i,d,u),g=mu(a,n,s,o,h,y,u);r.emplaceBack(c+m-l,c+g-l),u.primitiveLength++;}}}(a,r,o,i,l,t),e.forceNewSegmentOnNextPrepare(),null==a||a.forceNewSegmentOnNextPrepare();}function mu(t,e,r,n,i,s,a){if(s){const s=n.count;return r(e[2*i],e[2*i+1]),t[i]=n.count,n.count++,a.vertexLength++,s;}return t[i];}class gu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasDependencies=!1,this.patternFeatures=[],this.layoutVertexArray=new Ra(),this.indexArray=new Ja(),this.indexArray2=new Wa(),this.programConfigurations=new To(t.layers,t.zoom),this.segments=new eo(),this.segments2=new eo(),this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){this.hasDependencies=Vl("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Lo(a,t);if(!this.layers[0]._featureFilter.filter(new Cs(this.zoom),c,r))continue;const h=i?n.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:$o(a),patterns:{},sortKey:h};s.push(p);}i&&s.sort((t,e)=>t.sortKey-e.sortKey);for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasDependencies){const t=Fl("fill",this.layers,n,{zoom:this.zoom},e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r});}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length;}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload;}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Bl),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i,s){for(const t of tn(e,500)){const e=pu(t,n,s.fill.getGranularityForZoomLevel(n.z)),r=this.layoutVertexArray;yu((t,e)=>{r.emplaceBack(t,e);},this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n});}}let xu,vu;us("FillBucket",gu,{omit:["layers","patternFeatures"]});var bu={get paint(){return vu=vu||new Gs({"fill-antialias":new Rs(vt.paint_fill["fill-antialias"]),"fill-opacity":new Us(vt.paint_fill["fill-opacity"]),"fill-color":new Us(vt.paint_fill["fill-color"]),"fill-outline-color":new Us(vt.paint_fill["fill-outline-color"]),"fill-translate":new Rs(vt.paint_fill["fill-translate"]),"fill-translate-anchor":new Rs(vt.paint_fill["fill-translate-anchor"]),"fill-pattern":new js(vt.paint_fill["fill-pattern"])});},get layout(){return xu=xu||new Gs({"fill-sort-key":new Us(vt.layout_fill["fill-sort-key"])});}};class wu extends Zs{constructor(t,e){super(t,bu,e);}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new gu(t);}queryRadius(){return tl(this.paint.get("fill-translate"));}queryIntersectsFeature(_ref69){let{queryGeometry:t,geometry:e,transform:r,pixelsToTileUnits:n}=_ref69;return qo(el(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-r.bearingInRadians,n),e);}isTileClipped(){return!0;}}const _u=ta([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),Su=ta([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Au}=_u;class ku{constructor(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this.id=void 0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(Mu,this,e);}loadGeometry(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos,n=[];let i,s=1,a=0,o=0,l=0;for(;t.pos<e;){if(a<=0){const e=t.readVarint();s=7&e,a=e>>3;}if(a--,1===s||2===s)o+=t.readSVarint(),l+=t.readSVarint(),1===s&&(i&&n.push(i),i=[]),i&&i.push(new r(o,l));else{if(7!==s)throw new Error(`unknown command ${s}`);i&&i.push(i[0].clone());}}return i&&n.push(i),n;}bbox(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos;let r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;for(;t.pos<e;){if(n<=0){const e=t.readVarint();r=7&e,n=e>>3;}if(n--,1===r||2===r)i+=t.readSVarint(),s+=t.readSVarint(),i<a&&(a=i),i>o&&(o=i),s<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error(`unknown command ${r}`);}return[a,l,o,u];}toGeoJSON(t,e,r){const n=this.extent*Math.pow(2,r),i=this.extent*t,s=this.extent*e,a=this.loadGeometry();function o(t){return[360*(t.x+i)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(t.y+s)/n)*Math.PI))-90];}function l(t){return t.map(o);}let u;if(1===this.type){const t=[];for(const e of a)t.push(e[0]);const e=l(t);u=1===t.length?{type:"Point",coordinates:e[0]}:{type:"MultiPoint",coordinates:e};}else if(2===this.type){const t=a.map(l);u=1===t.length?{type:"LineString",coordinates:t[0]}:{type:"MultiLineString",coordinates:t};}else{if(3!==this.type)throw new Error("unknown feature type");{const t=function(t){const e=t.length;if(e<=1)return[t];const r=[];let n,i;for(let s=0;s<e;s++){const e=Iu(t[s]);0!==e&&(void 0===i&&(i=e<0),i===e<0?(n&&r.push(n),n=[t[s]]):n&&n.push(t[s]));}return n&&r.push(n),r;}(a),e=[];for(const r of t)e.push(r.map(l));u=1===e.length?{type:"Polygon",coordinates:e[0]}:{type:"MultiPolygon",coordinates:e};}}const c={type:"Feature",geometry:u,properties:this.properties};return null!=this.id&&(c.id=this.id),c;}}function Mu(t,e,r){1===t?e.id=r.readVarint():2===t?function(t,e){const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=e._keys[t.readVarint()],n=e._values[t.readVarint()];e.properties[r]=n;}}(r,e):3===t?e.type=r.readVarint():4===t&&(e._geometry=r.pos);}function Iu(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e;}ku.types=["Unknown","Point","LineString","Polygon"];class zu{constructor(t,e){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Pu,this,e),this.length=this._features.length;}feature(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];const e=this._pbf.readVarint()+this._pbf.pos;return new ku(this._pbf,e,this.extent,this._keys,this._values);}}function Pu(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){let e=null;const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=t.readVarint()>>3;e=1===r?t.readString():2===r?t.readFloat():3===r?t.readDouble():4===r?t.readVarint64():5===r?t.readVarint():6===r?t.readSVarint():7===r?t.readBoolean():null;}if(null==e)throw new Error("unknown feature value");return e;}(r));}class Cu{constructor(t,e){this.layers=t.readFields(Eu,{},e);}}function Eu(t,e,r){if(3===t){const t=new zu(r,r.readVarint()+r.pos);t.length&&(e[t.name]=t);}}const Tu=Math.pow(2,13);function Bu(t,e,r,n,i,s,a,o){t.emplaceBack(e,r,2*Math.floor(n*Tu)+a,i*Tu*2,s*Tu*2,Math.round(o));}class Vu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasDependencies=!1,this.layoutVertexArray=new Ua(),this.centroidVertexArray=new La(),this.indexArray=new Ja(),this.programConfigurations=new To(t.layers,t.zoom),this.segments=new eo(),this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){this.features=[],this.hasDependencies=Vl("fill-extrusion",this.layers,e);for(const{feature:n,id:i,index:s,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=Lo(n,t);if(!this.layers[0]._featureFilter.filter(new Cs(this.zoom),o,r))continue;const l={id:i,sourceLayerIndex:a,index:s,geometry:t?o.geometry:$o(n),properties:n.properties,type:n.type,patterns:{}};this.hasDependencies?this.features.push(Fl("fill-extrusion",this.layers,l,{zoom:this.zoom},e)):this.addFeature(l,l.geometry,s,r,{},e.subdivisionGranularity),e.featureIndex.insert(n,l.geometry,s,a,this.index,!0);}}addFeatures(t,e,r){for(const n of this.features){const{geometry:i}=n;this.addFeature(n,i,n.index,e,r,t.subdivisionGranularity);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r});}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length;}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload;}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Au),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Su.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy());}addFeature(t,e,r,n,i,s){for(const r of tn(e,500)){const e={x:0,y:0,sampleCount:0},i=this.layoutVertexArray.length;this.processPolygon(e,n,t,r,s);const a=this.layoutVertexArray.length-i,o=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<a;t++)this.centroidVertexArray.emplaceBack(o,l);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n});}processPolygon(t,e,r,n,i){if(n.length<1)return;if($u(n[0]))return;for(const e of n)0!==e.length&&Fu(t,e);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},a=i.fill.getGranularityForZoomLevel(e.z),o="Polygon"===ku.types[r.type];for(const t of n){if(0===t.length)continue;if($u(t))continue;const e=fu(t,a,o);this._generateSideFaces(e,s);}if(!o)return;const l=pu(n,e,a,!1),u=this.layoutVertexArray;yu((t,e)=>{Bu(u,t,e,0,0,1,1,0);},this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles);}_generateSideFaces(t,e){let r=0;for(let n=1;n<t.length;n++){const i=t[n],s=t[n-1];if(Du(i,s))continue;e.segment.vertexLength+4>eo.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const a=i.sub(s)._perp()._unit(),o=s.dist(i);r+o>32768&&(r=0),Bu(this.layoutVertexArray,i.x,i.y,a.x,a.y,0,0,r),Bu(this.layoutVertexArray,i.x,i.y,a.x,a.y,0,1,r),r+=o,Bu(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,0,r),Bu(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,1,r);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2;}}}function Fu(t,e){for(let r=0;r<e.length;r++){const n=e[r];r===e.length-1&&e[0].x===n.x&&e[0].y===n.y||(t.x+=n.x,t.y+=n.y,t.sampleCount++);}}function Du(t,e){return t.x===e.x&&(t.x<0||t.x>P)||t.y===e.y&&(t.y<0||t.y>P);}function $u(t){return t.every(t=>t.x<0)||t.every(t=>t.x>P)||t.every(t=>t.y<0)||t.every(t=>t.y>P);}let Lu;us("FillExtrusionBucket",Vu,{omit:["layers","features"]});var Ou={get paint(){return Lu=Lu||new Gs({"fill-extrusion-opacity":new Rs(vt["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Us(vt["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Rs(vt["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Rs(vt["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new js(vt["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Us(vt["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Us(vt["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new Rs(vt["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])});}};class Ru extends Zs{constructor(t,e){super(t,Ou,e);}createBucket(t){return new Vu(t);}queryRadius(){return tl(this.paint.get("fill-extrusion-translate"));}is3D(){return!0;}queryIntersectsFeature(_ref70){let{queryGeometry:t,feature:e,featureState:n,geometry:i,transform:s,pixelsToTileUnits:a,pixelPosMatrix:o}=_ref70;const l=el(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-s.bearingInRadians,a),u=this.paint.get("fill-extrusion-height").evaluate(e,n),c=this.paint.get("fill-extrusion-base").evaluate(e,n),h=function(t,e){const n=[];for(const i of t){const t=[i.x,i.y,0,1];A(t,t,e),n.push(new r(t[0]/t[3],t[1]/t[3]));}return n;}(l,o),p=function(t,e,n,i){const s=[],a=[],o=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*n,p=i[9]*n,f=i[10]*n,d=i[11]*n;for(const e of t){const t=[],n=[];for(const s of e){const e=s.x,a=s.y,y=i[0]*e+i[4]*a+i[12],m=i[1]*e+i[5]*a+i[13],g=i[2]*e+i[6]*a+i[14],x=i[3]*e+i[7]*a+i[15],v=g+u,b=x+c,w=y+h,_=m+p,S=g+f,A=x+d,k=new r((y+o)/b,(m+l)/b);k.z=v/b,t.push(k);const M=new r(w/A,_/A);M.z=S/A,n.push(M);}s.push(t),a.push(n);}return[s,a];}(i,c,u,o);return function(t,e,r){let n=1/0;qo(r,e)&&(n=ju(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];jo(r,i)&&(n=Math.min(n,ju(r,i)));}}return n!==1/0&&n;}(p[0],p[1],h);}}function Uu(t,e){return t.x*e.x+t.y*e.y;}function ju(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=Uu(o,o),h=Uu(o,l),p=Uu(l,l),f=Uu(u,o),d=Uu(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x;}return 1/0;}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t;}}const Nu=ta([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:qu}=Nu,Gu=ta([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Xu}=Gu,Zu=Math.cos(Math.PI/180*37.5),Yu=Math.pow(2,14)/.5;class Hu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasDependencies=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach(t=>{this.gradients[t.id]={};}),this.layoutVertexArray=new ja(),this.layoutVertexArray2=new Na(),this.indexArray=new Ja(),this.programConfigurations=new To(t.layers,t.zoom),this.segments=new eo(),this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){this.hasDependencies=Vl("line",this.layers,e)||this.hasLineDasharray(this.layers);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:e,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Lo(e,t);if(!this.layers[0]._featureFilter.filter(new Cs(this.zoom),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:a,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:$o(e),patterns:{},dashes:{},sortKey:c};s.push(h);}i&&s.sort((t,e)=>t.sortKey-e.sortKey);for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;this.hasDependencies?(Vl("line",this.layers,e)?Fl("line",this.layers,n,{zoom:this.zoom},e):this.hasLineDasharray(this.layers)&&this.addLineDashDependencies(this.layers,n,this.zoom,e),this.patternFeatures.push(n)):this.addFeature(n,i,s,r,{},{},e.subdivisionGranularity),e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r,dashPositions:n});}addFeatures(t,e,r,n){for(const i of this.patternFeatures)this.addFeature(i,i.geometry,i.index,e,r,n,t.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length;}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload;}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Xu)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,qu),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return{start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end};}addFeature(t,e,r,n,i,s,a){const o=this.layers[0].layout,l=o.get("line-join").evaluate(t,{}),u=o.get("line-cap"),c=o.get("line-miter-limit"),h=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,l,u,c,h,n,a);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,dashPositions:s,canonical:n});}addLine(t,e,r,n,i,s,a,o){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=fu(t,a?o.line.getGranularityForZoomLevel(a.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const l="Polygon"===ku.types[e.type];let u=t.length;for(;u>=2&&t[u-1].equals(t[u-2]);)u--;let c=0;for(;c<u-1&&t[c].equals(t[c+1]);)c++;if(u<(l?3:2))return;"bevel"===r&&(i=1.05);const h=this.overscaling<=16?122880/(512*this.overscaling):0,p=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let f,d,y,m,g;this.e1=this.e2=-1,l&&(f=t[u-2],g=t[c].sub(f)._unit()._perp());for(let e=c;e<u;e++){if(y=e===u-1?l?t[c+1]:void 0:t[e+1],y&&t[e].equals(y))continue;g&&(m=g),f&&(d=f),f=t[e],g=y?y.sub(f)._unit()._perp():m,m=m||g;let a=m.add(g);0===a.x&&0===a.y||a._unit();const o=m.x*g.x+m.y*g.y,x=a.x*g.x+a.y*g.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<Zu&&d&&y,_=m.x*g.y-m.y*g.x>0;if(w&&e>c){const t=f.dist(d);if(t>2*h){const e=f.sub(f.sub(d)._mult(h/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,m,0,0,p),d=e;}}const S=d&&y;let A=S?r:l?"butt":n;if(S&&"round"===A&&(v<s?A="miter":v<=2&&(A="fakeround")),"miter"===A&&v>i&&(A="bevel"),"bevel"===A&&(v>2&&(A="flipbevel"),v<i&&(A="miter")),d&&this.updateDistance(d,f),"miter"===A)a._mult(v),this.addCurrentVertex(f,a,0,0,p);else if("flipbevel"===A){if(v>100)a=g.mult(-1);else{const t=v*m.add(g).mag()/m.sub(g).mag();a._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(f,a,0,0,p),this.addCurrentVertex(f,a.mult(-1),0,0,p);}else if("bevel"===A||"fakeround"===A){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(d&&this.addCurrentVertex(f,m,e,r,p),"fakeround"===A){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+o*(o*(3.55645-1.43519*o)-3.2452))*t*t+(.848013+o*(.215638*o-1.06021)));}const n=g.sub(m)._mult(r)._add(m)._unit()._mult(_?-1:1);this.addHalfVertex(f,n.x,n.y,!1,_,0,p);}}y&&this.addCurrentVertex(f,g,-e,-r,p);}else if("butt"===A)this.addCurrentVertex(f,a,0,0,p);else if("square"===A){const t=d?1:-1;this.addCurrentVertex(f,a,t,t,p);}else"round"===A&&(d&&(this.addCurrentVertex(f,m,0,0,p),this.addCurrentVertex(f,m,1,1,p,!0)),y&&(this.addCurrentVertex(f,g,-1,-1,p,!0),this.addCurrentVertex(f,g,0,0,p)));if(w&&e<u-1){const t=f.dist(y);if(t>2*h){const e=f.add(y.sub(f)._mult(h/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,g,0,0,p),f=e;}}}}addCurrentVertex(t,e,r,n,i){let s=arguments.length>5&&arguments[5]!==undefined?arguments[5]:!1;const a=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,a,o,s,!0,-n,i),this.distance>Yu/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,r,n,i,s));}addHalfVertex(_ref71,r,n,i,s,a,o){let{x:t,y:e}=_ref71;const l=.5*(this.lineClips?this.scaledDistance*(Yu-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,u,this.e2),o.primitiveLength++),s?this.e2=u:this.e1=u;}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}hasLineDasharray(t){for(const e of t){const t=e.paint.get("line-dasharray");if(t&&!t.isConstant())return!0;}return!1;}addLineDashDependencies(t,e,r,n){for(const i of t){const t=i.paint.get("line-dasharray");if(!t||"constant"===t.value.kind)continue;const s="round"===i.layout.get("line-cap"),a={dasharray:t.value.evaluate({zoom:r-1},e,{}),round:s},o={dasharray:t.value.evaluate({zoom:r},e,{}),round:s},l={dasharray:t.value.evaluate({zoom:r+1},e,{}),round:s},u=`${a.dasharray.join(",")},${a.round}`,c=`${o.dasharray.join(",")},${o.round}`,h=`${l.dasharray.join(",")},${l.round}`;n.dashDependencies[u]=a,n.dashDependencies[c]=o,n.dashDependencies[h]=l,e.dashes[i.id]={min:u,mid:c,max:h};}}}let Ku,Ju;us("LineBucket",Hu,{omit:["layers","patternFeatures"]});var Wu={get paint(){return Ju=Ju||new Gs({"line-opacity":new Us(vt.paint_line["line-opacity"]),"line-color":new Us(vt.paint_line["line-color"]),"line-translate":new Rs(vt.paint_line["line-translate"]),"line-translate-anchor":new Rs(vt.paint_line["line-translate-anchor"]),"line-width":new Us(vt.paint_line["line-width"]),"line-gap-width":new Us(vt.paint_line["line-gap-width"]),"line-offset":new Us(vt.paint_line["line-offset"]),"line-blur":new Us(vt.paint_line["line-blur"]),"line-dasharray":new js(vt.paint_line["line-dasharray"]),"line-pattern":new js(vt.paint_line["line-pattern"]),"line-gradient":new qs(vt.paint_line["line-gradient"])});},get layout(){return Ku=Ku||new Gs({"line-cap":new Rs(vt.layout_line["line-cap"]),"line-join":new Us(vt.layout_line["line-join"]),"line-miter-limit":new Rs(vt.layout_line["line-miter-limit"]),"line-round-limit":new Rs(vt.layout_line["line-round-limit"]),"line-sort-key":new Us(vt.layout_line["line-sort-key"])});}};class Qu extends Us{possiblyEvaluate(t,e){return e=new Cs(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e);}evaluate(t,e,r,n){return e=L({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n);}}let tc;class ec extends Zs{constructor(t,e){super(t,Wu,e),this.gradientVersion=0,tc||(tc=new Qu(Wu.paint.properties["line-width"].specification),tc.useIntegerZoom=!0);}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression;}(t)&&t._styleExpression.expression instanceof or,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression;}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=tc.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new Hu(t);}queryRadius(t){const e=t,r=rc(Qo("line-width",this,e),Qo("line-gap-width",this,e)),n=Qo("line-offset",this,e);return r/2+Math.abs(n)+tl(this.paint.get("line-translate"));}queryIntersectsFeature(_ref72){let{queryGeometry:t,feature:e,featureState:n,geometry:i,transform:s,pixelsToTileUnits:a}=_ref72;const o=el(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-s.bearingInRadians,a),l=a/2*rc(this.paint.get("line-width").evaluate(e,n),this.paint.get("line-gap-width").evaluate(e,n)),u=this.paint.get("line-offset").evaluate(e,n);return u&&(i=function(t,e){const n=[];for(let i=0;i<t.length;i++){const s=t[i],a=[];for(let t=0;t<s.length;t++){const n=s[t-1],i=s[t],o=s[t+1],l=0===t?new r(0,0):i.sub(n)._unit()._perp(),u=t===s.length-1?new r(0,0):o.sub(i)._unit()._perp(),c=l._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),a.push(c._mult(e)._add(i));}n.push(a);}return n;}(i,u*a)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(Jo(t,i[e]))return!0;if(Go(t,i,r))return!0;}return!1;}(o,i,l);}isTileClipped(){return!0;}}function rc(t,e){return e>0?e+2*t:t;}const nc=ta([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),ic=ta([{name:"a_projected_pos",components:3,type:"Float32"}],4);ta([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const sc=ta([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);ta([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const ac=ta([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),oc=ta([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function lc(t,e,r){return t.sections.forEach(t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return"uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Ps.applyArabicShaping&&(t=Ps.applyArabicShaping(t)),t;}(t.text,e,r);}),t;}ta([{name:"triangle",components:3,type:"Uint16"}]),ta([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),ta([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),ta([{type:"Float32",name:"offsetX"}]),ta([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),ta([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const uc={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var cc=24;const hc=4294967296,pc=1/hc,fc="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");class dc{constructor(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:new Uint8Array(16);this.buf=ArrayBuffer.isView(t)?t:new Uint8Array(t),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length;}readFields(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:this.length;for(;this.pos<r;){const r=this.readVarint(),n=r>>3,i=this.pos;this.type=7&r,t(n,e,this),this.pos===i&&this.skip(r);}return e;}readMessage(t,e){return this.readFields(t,e,this.readVarint()+this.pos);}readFixed32(){const t=this.dataView.getUint32(this.pos,!0);return this.pos+=4,t;}readSFixed32(){const t=this.dataView.getInt32(this.pos,!0);return this.pos+=4,t;}readFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*hc;return this.pos+=8,t;}readSFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*hc;return this.pos+=8,t;}readFloat(){const t=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,t;}readDouble(){const t=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,t;}readVarint(t){const e=this.buf;let r,n;return n=e[this.pos++],r=127&n,n<128?r:(n=e[this.pos++],r|=(127&n)<<7,n<128?r:(n=e[this.pos++],r|=(127&n)<<14,n<128?r:(n=e[this.pos++],r|=(127&n)<<21,n<128?r:(n=e[this.pos],r|=(15&n)<<28,function(t,e,r){const n=r.buf;let i,s;if(s=n[r.pos++],i=(112&s)>>4,s<128)return yc(t,i,e);if(s=n[r.pos++],i|=(127&s)<<3,s<128)return yc(t,i,e);if(s=n[r.pos++],i|=(127&s)<<10,s<128)return yc(t,i,e);if(s=n[r.pos++],i|=(127&s)<<17,s<128)return yc(t,i,e);if(s=n[r.pos++],i|=(127&s)<<24,s<128)return yc(t,i,e);if(s=n[r.pos++],i|=(1&s)<<31,s<128)return yc(t,i,e);throw new Error("Expected varint not more than 10 bytes");}(r,t,this)))));}readVarint64(){return this.readVarint(!0);}readSVarint(){const t=this.readVarint();return t%2==1?(t+1)/-2:t/2;}readBoolean(){return Boolean(this.readVarint());}readString(){const t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&fc?fc.decode(this.buf.subarray(e,t)):function(t,e,r){let n="",i=e;for(;i<r;){const e=t[i];let s,a,o,l=null,u=e>239?4:e>223?3:e>191?2:1;if(i+u>r)break;1===u?e<128&&(l=e):2===u?(s=t[i+1],128==(192&s)&&(l=(31&e)<<6|63&s,l<=127&&(l=null))):3===u?(s=t[i+1],a=t[i+2],128==(192&s)&&128==(192&a)&&(l=(15&e)<<12|(63&s)<<6|63&a,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=t[i+1],a=t[i+2],o=t[i+3],128==(192&s)&&128==(192&a)&&128==(192&o)&&(l=(15&e)<<18|(63&s)<<12|(63&a)<<6|63&o,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u;}return n;}(this.buf,e,t);}readBytes(){const t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e;}readPackedVarint(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];let e=arguments.length>1?arguments[1]:undefined;const r=this.readPackedEnd();for(;this.pos<r;)t.push(this.readVarint(e));return t;}readPackedSVarint(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSVarint());return t;}readPackedBoolean(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readBoolean());return t;}readPackedFloat(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFloat());return t;}readPackedDouble(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readDouble());return t;}readPackedFixed32(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed32());return t;}readPackedSFixed32(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed32());return t;}readPackedFixed64(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed64());return t;}readPackedSFixed64(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed64());return t;}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1;}skip(t){const e=7&t;if(0===e)for(;this.buf[this.pos++]>127;);else if(2===e)this.pos=this.readVarint()+this.pos;else if(5===e)this.pos+=4;else{if(1!==e)throw new Error(`Unimplemented type: ${e}`);this.pos+=8;}}writeTag(t,e){this.writeVarint(t<<3|e);}realloc(t){let e=this.length||16;for(;e<this.pos+t;)e*=2;if(e!==this.length){const t=new Uint8Array(e);t.set(this.buf),this.buf=t,this.dataView=new DataView(t.buffer),this.length=e;}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length);}writeFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4;}writeSFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4;}writeFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*pc),!0),this.pos+=8;}writeSFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*pc),!0),this.pos+=8;}writeVarint(t){(t=+t||0)>268435455||t<0?function(t,e){let r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(r=~(-t%4294967296),n=~(-t/4294967296),4294967295^r?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){const r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));}writeSVarint(t){this.writeVarint(t<0?2*-t-1:2*t);}writeBoolean(t){this.writeVarint(+t);}writeString(t){t=String(t),this.realloc(4*t.length),this.pos++;const e=this.pos;this.pos=function(t,e,r){for(let n,i,s=0;s<e.length;s++){if(n=e.charCodeAt(s),n>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue;}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue;}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r;}(this.buf,t,this.pos);const r=this.pos-e;r>=128&&mc(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;}writeFloat(t){this.realloc(4),this.dataView.setFloat32(this.pos,t,!0),this.pos+=4;}writeDouble(t){this.realloc(8),this.dataView.setFloat64(this.pos,t,!0),this.pos+=8;}writeBytes(t){const e=t.length;this.writeVarint(e),this.realloc(e);for(let r=0;r<e;r++)this.buf[this.pos++]=t[r];}writeRawMessage(t,e){this.pos++;const r=this.pos;t(e,this);const n=this.pos-r;n>=128&&mc(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;}writeMessage(t,e,r){this.writeTag(t,2),this.writeRawMessage(e,r);}writePackedVarint(t,e){e.length&&this.writeMessage(t,gc,e);}writePackedSVarint(t,e){e.length&&this.writeMessage(t,xc,e);}writePackedBoolean(t,e){e.length&&this.writeMessage(t,wc,e);}writePackedFloat(t,e){e.length&&this.writeMessage(t,vc,e);}writePackedDouble(t,e){e.length&&this.writeMessage(t,bc,e);}writePackedFixed32(t,e){e.length&&this.writeMessage(t,_c,e);}writePackedSFixed32(t,e){e.length&&this.writeMessage(t,Sc,e);}writePackedFixed64(t,e){e.length&&this.writeMessage(t,Ac,e);}writePackedSFixed64(t,e){e.length&&this.writeMessage(t,kc,e);}writeBytesField(t,e){this.writeTag(t,2),this.writeBytes(e);}writeFixed32Field(t,e){this.writeTag(t,5),this.writeFixed32(e);}writeSFixed32Field(t,e){this.writeTag(t,5),this.writeSFixed32(e);}writeFixed64Field(t,e){this.writeTag(t,1),this.writeFixed64(e);}writeSFixed64Field(t,e){this.writeTag(t,1),this.writeSFixed64(e);}writeVarintField(t,e){this.writeTag(t,0),this.writeVarint(e);}writeSVarintField(t,e){this.writeTag(t,0),this.writeSVarint(e);}writeStringField(t,e){this.writeTag(t,2),this.writeString(e);}writeFloatField(t,e){this.writeTag(t,5),this.writeFloat(e);}writeDoubleField(t,e){this.writeTag(t,1),this.writeDouble(e);}writeBooleanField(t,e){this.writeVarintField(t,+e);}}function yc(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0);}function mc(t,e,r){const n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(let e=r.pos-1;e>=t;e--)r.buf[e+n]=r.buf[e];}function gc(t,e){for(let r=0;r<t.length;r++)e.writeVarint(t[r]);}function xc(t,e){for(let r=0;r<t.length;r++)e.writeSVarint(t[r]);}function vc(t,e){for(let r=0;r<t.length;r++)e.writeFloat(t[r]);}function bc(t,e){for(let r=0;r<t.length;r++)e.writeDouble(t[r]);}function wc(t,e){for(let r=0;r<t.length;r++)e.writeBoolean(t[r]);}function _c(t,e){for(let r=0;r<t.length;r++)e.writeFixed32(t[r]);}function Sc(t,e){for(let r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function Ac(t,e){for(let r=0;r<t.length;r++)e.writeFixed64(t[r]);}function kc(t,e){for(let r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Mc(t,e,r){1===t&&r.readMessage(Ic,e);}function Ic(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(zc,{});e.push({id:t,bitmap:new xl({width:i+6,height:s+6},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}}function zc(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}function Pc(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort((t,e)=>e.h-t.h);const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();e&&t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break;}}return{w:i,h:s,fill:e/(i*s)||0};}class Cc{constructor(t,_ref73){let{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s,textFitWidth:a,textFitHeight:o}=_ref73;this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r,this.textFitWidth=a,this.textFitHeight=o;}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1];}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1];}get tlbr(){return this.tl.concat(this.br);}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio];}}class Ec{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:a}=Pc(i),o=new vl({width:s||1,height:a||1});for(const e in t){const n=t[e],i=r[e].paddedRect;vl.copy(n.data,o,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+1,a=i.y+1,l=r.data.width,u=r.data.height;vl.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),vl.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),vl.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),vl.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),vl.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),e[n]=new Cc(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}var Tc;us("ImagePosition",Cc),us("ImageAtlas",Ec),t.as=void 0,(Tc=t.as||(t.as={}))[Tc.none=0]="none",Tc[Tc.horizontal=1]="horizontal",Tc[Tc.vertical=2]="vertical",Tc[Tc.horizontalOnly=3]="horizontalOnly";class Bc{constructor(){this.scale=1,this.fontStack="",this.imageName=null,this.verticalAlign="bottom";}static forText(t,e,r){const n=new Bc();return n.scale=t||1,n.fontStack=e,n.verticalAlign=r||"bottom",n;}static forImage(t,e){const r=new Bc();return r.imageName=t,r.verticalAlign=e||"bottom",r;}}class Vc{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new Vc();for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r;}length(){return this.text.length;}getSection(t){return this.sections[this.sectionIndex[t]];}getSectionIndex(t){return this.sectionIndex[t];}getCharCode(t){return this.text.charCodeAt(t);}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,i=t.charCodeAt(r-1)||null;e+=n&&As(n)&&!uc[t[r+1]]||i&&As(i)&&!uc[t[r-1]]||!uc[t[r]]?t[r]:uc[t[r]];}return e;}(this.text);}trim(){let t=0;for(let e=0;e<this.text.length&&Dc[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Dc[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new Vc();return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r;}toString(){return this.text;}getMaxScale(){return this.sectionIndex.reduce((t,e)=>Math.max(t,this.sections[e].scale),0);}getMaxImageSize(t){let e=0,r=0;for(let n=0;n<this.length();n++){const i=this.getSection(n);if(i.imageName){const n=t[i.imageName];if(!n)continue;const s=n.displaySize;e=Math.max(e,s[0]),r=Math.max(r,s[1]);}}return{maxImageWidth:e,maxImageHeight:r};}addTextSection(t,e){this.text+=t.text,this.sections.push(Bc.forText(t.scale,t.fontStack||e,t.verticalAlign));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void q("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(Bc.forImage(e,t.verticalAlign)),this.sectionIndex.push(this.sections.length-1)):q("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID);}}function Fc(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y){const m=Vc.fromFeature(e,s);let g;p===t.as.vertical&&m.verticalizePunctuation();const{processBidirectionalText:x,processStyledBidirectionalText:v}=Ps;if(x&&1===m.sections.length){g=[];const t=x(m.toString(),qc(m,c,a,r,i,d));for(const e of t){const t=new Vc();t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(v){g=[];const t=v(m.text,m.sectionIndex,qc(m,c,a,r,i,d));for(const e of t){const t=new Vc();t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,g.push(t);}}else g=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r;}(m,qc(m,c,a,r,i,d));const b=[],w={positionedLines:b,text:m.toString(),top:h[1],bottom:h[1],left:h[0],right:h[0],writingMode:p,iconsInText:!1,verticalizable:!1};return function(t,e,r,n,i,s,a,o,l,u,c,h){let p=0,f=0,d=0,y=0;const m="right"===o?1:"left"===o?0:.5,g=cc/h;let x=0;for(const a of i){a.trim();const i=a.getMaxScale(),o={positionedGlyphs:[],lineOffset:0};t.positionedLines[x]=o;const h=o.positionedGlyphs;let v=0;if(!a.length()){f+=s,++x;continue;}const b=Xc(n,a,g);for(let s=0;s<a.length();s++){const o=a.getSection(s),d=a.getSectionIndex(s),y=a.getCharCode(s),m=Yc(l,c,y);let x;if(o.imageName){if(t.iconsInText=!0,o.scale=o.scale*g,x=Kc(o,m,i,b,n),!x)continue;v=Math.max(v,x.imageOffset);}else if(x=Hc(o,y,m,b,e,r),!x)continue;const{rect:w,metrics:_,baselineOffset:S}=x;h.push({glyph:y,imageName:o.imageName,x:p,y:f+S+-17,vertical:m,scale:o.scale,fontStack:o.fontStack,sectionIndex:d,metrics:_,rect:w}),m?(t.verticalizable=!0,p+=(o.imageName?_.advance:cc)*o.scale+u):p+=_.advance*o.scale+u;}0!==h.length&&(d=Math.max(p-u,d),Jc(h,0,h.length-1,m)),p=0,o.lineOffset=Math.max(v,(i-1)*cc);const w=s*i+v;f+=w,y=Math.max(w,y),++x;}const{horizontalAlign:v,verticalAlign:b}=Gc(a);(function(t,e,r,n,i,s,a,o,l){const u=(e-r)*i;let c=0;c=s!==a?-o*n- -17:-n*l*a+.5*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c;})(t.positionedLines,m,v,b,d,y,s,f,i.length),t.top+=-b*f,t.bottom=t.top+f,t.left+=-v*d,t.right=t.left+d;}(w,r,n,i,g,o,l,u,p,c,f,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return!1;return!0;}(b)&&w;}const Dc={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},$c={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},Lc={40:!0};function Oc(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*cc/s+i:0;}{const n=r[e.fontStack],s=n&&n[t];return s?s.metrics.advance*e.scale+i:0;}}function Rc(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r;}function Uc(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n;}function jc(t,e,r,n,i,s){let a=null,o=Rc(e,r,i,s);for(const t of n){const n=Rc(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return{index:t,x:e,priorBreak:a,badness:o};}function Nc(t){return t?Nc(t.priorBreak).concat(t.index):[];}function qc(t,e,r,n,i,s){if(!t)return[];const a=[],o=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=Oc(t.getCharCode(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r));}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCharCode(r);if(Dc[p]||(u+=Oc(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904)&&(!!ms["CJK Compatibility Forms"](c)||!!ms["CJK Compatibility"](c)||!!ms["CJK Strokes"](c)||!!ms["CJK Symbols and Punctuation"](c)||!!ms["Enclosed CJK Letters and Months"](c)||!!ms["Halfwidth and Fullwidth Forms"](c)||!!ms["Ideographic Description Characters"](c)||!!ms["Vertical Forms"](c)||_s.test(String.fromCodePoint(c)));($c[p]||e||h.imageName||r!==t.length()-2&&Lc[t.getCharCode(r+1)])&&a.push(jc(r+1,u,o,a,Uc(p,t.getCharCode(r+1),e&&l),!1));}}var c;return Nc(jc(t.length(),u,o,a,0,!0));}function Gc(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return{horizontalAlign:e,verticalAlign:r};}function Xc(t,e,r){const n=e.getMaxScale()*cc,{maxImageWidth:i,maxImageHeight:s}=e.getMaxImageSize(t),a=Math.max(n,s*r);return{verticalLineContentWidth:Math.max(n,i*r),horizontalLineContentHeight:a};}function Zc(t){switch(t){case"top":return 0;case"center":return .5;default:return 1;}}function Yc(e,r,n){return!(e===t.as.horizontal||!r&&!Ss(n)||r&&(Dc[n]||(i=n,/\p{sc=Arab}/u.test(String.fromCodePoint(i)))));// removed by dead control flow
 var i; }function Hc(t,e,r,n,i,s){const a=s[t.fontStack],o=function(t,e,r,n){if(t&&t.rect)return t;const i=e[r.fontStack],s=i&&i[n];return s?{rect:null,metrics:s.metrics}:null;}(a&&a[e],i,t,e);if(null===o)return null;let l;if(r)l=n.verticalLineContentWidth-t.scale*cc;else{const e=Zc(t.verticalAlign);l=(n.horizontalLineContentHeight-t.scale*cc)*e;}return{rect:o.rect,metrics:o.metrics,baselineOffset:l};}function Kc(t,e,r,n,i){const s=i[t.imageName];if(!s)return null;const a=s.paddedRect,o=s.displaySize,l={width:o[0],height:o[1],left:1,top:-3,advance:e?o[1]:o[0]};let u;if(e)u=n.verticalLineContentWidth-o[1]*t.scale;else{const e=Zc(t.verticalAlign);u=(n.horizontalLineContentHeight-o[1]*t.scale)*e;}return{rect:a,metrics:l,baselineOffset:u,imageOffset:(e?o[0]:o[1])*t.scale-cc*r};}function Jc(t,e,r,n){if(0===n)return;const i=t[r],s=(t[r].x+i.metrics.advance*i.scale)*n;for(let n=e;n<=r;n++)t[n].x-=s;}function Wc(t,e,r){const{horizontalAlign:n,verticalAlign:i}=Gc(r),s=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*i;return{image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]};}function Qc(t){var e,r;let n=t.left,i=t.top,s=t.right-n,a=t.bottom-i;const o=null!==(e=t.image.textFitWidth)&&void 0!==e?e:"stretchOrShrink",l=null!==(r=t.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",u=(t.image.content[2]-t.image.content[0])/(t.image.content[3]-t.image.content[1]);if("proportional"===l){if("stretchOnly"===o&&s/a<u||"proportional"===o){const t=Math.ceil(a*u);n*=t/s,s=t;}}else if("proportional"===o&&"stretchOnly"===l&&0!==u&&s/a>u){const t=Math.ceil(s/u);i*=t/a,a=t;}return{x1:n,y1:i,x2:n+s,y2:i+a};}function th(t,e,r,n,i,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-a.displaySize[0])/2,h=f+a.displaySize[0]);const d=e.top*s,y=e.bottom*s;return"height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:f,collisionPadding:o};}const eh=128,rh=32640;function nh(t,e){const{expression:r}=e;if("constant"===r.kind)return{kind:"constant",layoutSize:r.evaluate(new Cs(t+1))};if("source"===r.kind)return{kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return"composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new Cs(a)),maxSize:r.evaluate(new Cs(o)),interpolationType:n};}}function ih(t,e,r){let n="never";const i=t.get(e);return i?n=i:t.get(r)&&(n="always"),n;}const sh=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function ah(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=o?Math.min(rh,Math.round(o[0])):0,d=o?Math.min(rh,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function oh(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function lh(t){for(const e of t.sections)if(zs(e.text))return!0;return!1;}class uh{constructor(t){this.layoutVertexArray=new Xa(),this.indexArray=new Ja(),this.programConfigurations=t,this.segments=new eo(),this.dynamicLayoutVertexArray=new Za(),this.opacityVertexArray=new Ya(),this.hasVisibleVertices=!1,this.placedSymbolArray=new Pa();}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length;}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,nc.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,ic.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,sh,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}us("SymbolBuffers",uh);class ch{constructor(t,e,r){this.layoutVertexArray=new t(),this.layoutAttributes=e,this.indexArray=new r(),this.segments=new eo(),this.collisionVertexArray=new Ka();}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,sc.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy());}}us("CollisionBuffers",ch);class hh{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=Y(globalThis)?Math.min(e.overscaling,128):e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map(t=>t.id),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasDependencies=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=nh(this.zoom,r["text-size"]),this.iconSizeData=nh(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),s=n.get("symbol-z-order");this.canOverlap="never"!==ih(n,"text-overlap","text-allow-overlap")||"never"!==ih(n,"icon-overlap","icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&!i.isConstant(),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===n.get("symbol-placement")&&(this.writingModes=n.get("text-writing-mode").map(e=>t.as[e])),this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id),this.sourceID=e.sourceID;}createArrays(){this.text=new uh(new To(this.layers,this.zoom,t=>/^text/.test(t))),this.icon=new uh(new To(this.layers,this.zoom,t=>/^icon/.test(t))),this.glyphOffsetArray=new Ta(),this.lineVertexArray=new Ba(),this.symbolInstances=new Ea(),this.textAnchorOffsets=new Fa();}calculateGlyphDependencies(t,e,r,n,i){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||n)&&i){const r=uc[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0);}}populate(e,r,n){const i=this.layers[0],s=i.layout,a=s.get("text-font"),o=s.get("text-field"),l=s.get("icon-image"),u=("constant"!==o.value.kind||o.value.value instanceof Ee&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!u&&!c)return;const p=r.iconDependencies,f=r.glyphDependencies,d=r.availableImages,y=new Cs(this.zoom);for(const{feature:r,id:o,index:l,sourceLayerIndex:m}of e){const e=i._featureFilter.needGeometry,g=Lo(r,e);if(!i._featureFilter.filter(y,g,n))continue;let x,v;if(e||(g.geometry=$o(r)),u){const t=i.getValueAndResolveTokens("text-field",g,n,d),e=Ee.factory(t),r=this.hasRTLText=this.hasRTLText||lh(e);(!r||"unavailable"===Ps.getRTLTextPluginStatus()||r&&Ps.isParsed())&&(x=lc(e,i,g));}if(c){const t=i.getValueAndResolveTokens("icon-image",g,n,d);v=t instanceof Le?t:Le.fromString(t);}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},n):void 0;if(this.features.push({id:o,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:r.properties,type:ku.types[r.type],sortKey:b}),v&&(p[v.name]=!0),x){const e=a.evaluate(g,{},n).join(","),r="viewport"!==s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(t.as.vertical)>=0;for(const t of x.sections)if(t.image)p[t.image.name]=!0;else{const n=gs(x.toString()),i=t.fontStack||e,s=f[i]=f[i]||{};this.calculateGlyphDependencies(t.text,s,r,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s;}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s;}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return`${t}:${n.x}:${n.y}`;}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue;}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=a(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?a(f,d,h):d in e?o(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter(t=>t.geometry);}(this.features)),this.sortFeaturesByKey&&this.features.sort((t,e)=>t.sortKey-e.sortKey);}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:r}),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:r}));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText;}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload;}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return{lineStartIndex:r,lineLength:this.lineVertexArray.length-r};}addSymbols(e,r,n,i,s,a,o,l,u,c,h,p){const f=e.indexArray,d=e.layoutVertexArray,y=e.segments.prepareSegment(4*r.length,d,f,this.canOverlap?a.sortKey:void 0),m=this.glyphOffsetArray.length,g=y.vertexLength,x=this.allowVerticalPlacement&&o===t.as.vertical?Math.PI/2:0,v=a.text&&a.text.sections;for(let t=0;t<r.length;t++){const{tl:i,tr:s,bl:o,br:u,tex:c,pixelOffsetTL:h,pixelOffsetBR:m,minFontScaleX:g,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:S}=r[t],A=y.vertexLength,k=w[1];ah(d,l.x,l.y,i.x,k+i.y,c.x,c.y,n,_,h.x,h.y,g,b),ah(d,l.x,l.y,s.x,k+s.y,c.x+c.w,c.y,n,_,m.x,h.y,g,b),ah(d,l.x,l.y,o.x,k+o.y,c.x,c.y+c.h,n,_,h.x,m.y,g,b),ah(d,l.x,l.y,u.x,k+u.y,c.x+c.w,c.y+c.h,n,_,m.x,m.y,g,b),oh(e.dynamicLayoutVertexArray,l,x),f.emplaceBack(A,A+2,A+1),f.emplaceBack(A+1,A+2,A+3),y.vertexLength+=4,y.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),t!==r.length-1&&S===r[t+1].sectionIndex||e.programConfigurations.populatePaintArrays(d.length,a,a.index,{imagePositions:{},canonical:p,formattedSection:v&&v[S]});}e.placedSymbolArray.emplaceBack(l.x,l.y,m,this.glyphOffsetArray.length-m,g,u,c,l.segment,n?n[0]:0,n?n[1]:0,i[0],i[1],o,0,!1,0,h);}_addCollisionDebugVertex(t,e,r,n,i,s){return e.emplaceBack(0,0),t.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y));}addCollisionDebugVertices(t,e,n,i,s,a,o){const l=s.segments.prepareSegment(4,s.layoutVertexArray,s.indexArray),u=l.vertexLength,c=s.layoutVertexArray,h=s.collisionVertexArray,p=o.anchorX,f=o.anchorY;this._addCollisionDebugVertex(c,h,a,p,f,new r(t,e)),this._addCollisionDebugVertex(c,h,a,p,f,new r(n,e)),this._addCollisionDebugVertex(c,h,a,p,f,new r(n,i)),this._addCollisionDebugVertex(c,h,a,p,f,new r(t,i)),l.vertexLength+=4;const d=s.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),l.primitiveLength+=4;}addDebugCollisionBoxes(t,e,r,n){for(let i=t;i<e;i++){const t=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r);}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new ch(Ha,ac.members,Wa),this.iconCollisionBox=new ch(Ha,ac.members,Wa);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1);}}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break;}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break;}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break;}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break;}return u;}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0;}hasIconData(){return this.icon.segments.get().length>0;}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox;}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0;}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0;}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.anchorX+r*a.anchorY)),i.push(a.featureIndex);}return s.sort((t,e)=>n[t]-n[e]||i[e]-i[t]),s;}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);}),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let ph,fh;us("SymbolBucket",hh,{omit:["layers","collisionBoxArray","features","compareText"]}),hh.MAX_GLYPHS=65535,hh.addDynamicAttributes=oh;var dh={get paint(){return fh=fh||new Gs({"icon-opacity":new Us(vt.paint_symbol["icon-opacity"]),"icon-color":new Us(vt.paint_symbol["icon-color"]),"icon-halo-color":new Us(vt.paint_symbol["icon-halo-color"]),"icon-halo-width":new Us(vt.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Us(vt.paint_symbol["icon-halo-blur"]),"icon-translate":new Rs(vt.paint_symbol["icon-translate"]),"icon-translate-anchor":new Rs(vt.paint_symbol["icon-translate-anchor"]),"text-opacity":new Us(vt.paint_symbol["text-opacity"]),"text-color":new Us(vt.paint_symbol["text-color"],{runtimeType:Ot,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Us(vt.paint_symbol["text-halo-color"]),"text-halo-width":new Us(vt.paint_symbol["text-halo-width"]),"text-halo-blur":new Us(vt.paint_symbol["text-halo-blur"]),"text-translate":new Rs(vt.paint_symbol["text-translate"]),"text-translate-anchor":new Rs(vt.paint_symbol["text-translate-anchor"])});},get layout(){return ph=ph||new Gs({"symbol-placement":new Rs(vt.layout_symbol["symbol-placement"]),"symbol-spacing":new Rs(vt.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Rs(vt.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Us(vt.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Rs(vt.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new Rs(vt.layout_symbol["icon-allow-overlap"]),"icon-overlap":new Rs(vt.layout_symbol["icon-overlap"]),"icon-ignore-placement":new Rs(vt.layout_symbol["icon-ignore-placement"]),"icon-optional":new Rs(vt.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Rs(vt.layout_symbol["icon-rotation-alignment"]),"icon-size":new Us(vt.layout_symbol["icon-size"]),"icon-text-fit":new Rs(vt.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Rs(vt.layout_symbol["icon-text-fit-padding"]),"icon-image":new Us(vt.layout_symbol["icon-image"]),"icon-rotate":new Us(vt.layout_symbol["icon-rotate"]),"icon-padding":new Us(vt.layout_symbol["icon-padding"]),"icon-keep-upright":new Rs(vt.layout_symbol["icon-keep-upright"]),"icon-offset":new Us(vt.layout_symbol["icon-offset"]),"icon-anchor":new Us(vt.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Rs(vt.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Rs(vt.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Rs(vt.layout_symbol["text-rotation-alignment"]),"text-field":new Us(vt.layout_symbol["text-field"]),"text-font":new Us(vt.layout_symbol["text-font"]),"text-size":new Us(vt.layout_symbol["text-size"]),"text-max-width":new Us(vt.layout_symbol["text-max-width"]),"text-line-height":new Rs(vt.layout_symbol["text-line-height"]),"text-letter-spacing":new Us(vt.layout_symbol["text-letter-spacing"]),"text-justify":new Us(vt.layout_symbol["text-justify"]),"text-radial-offset":new Us(vt.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Rs(vt.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new Us(vt.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new Us(vt.layout_symbol["text-anchor"]),"text-max-angle":new Rs(vt.layout_symbol["text-max-angle"]),"text-writing-mode":new Rs(vt.layout_symbol["text-writing-mode"]),"text-rotate":new Us(vt.layout_symbol["text-rotate"]),"text-padding":new Rs(vt.layout_symbol["text-padding"]),"text-keep-upright":new Rs(vt.layout_symbol["text-keep-upright"]),"text-transform":new Us(vt.layout_symbol["text-transform"]),"text-offset":new Us(vt.layout_symbol["text-offset"]),"text-allow-overlap":new Rs(vt.layout_symbol["text-allow-overlap"]),"text-overlap":new Rs(vt.layout_symbol["text-overlap"]),"text-ignore-placement":new Rs(vt.layout_symbol["text-ignore-placement"]),"text-optional":new Rs(vt.layout_symbol["text-optional"])});}};class yh{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:Ft,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection);}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default;}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return!1;}serialize(){return null;}}us("FormatSectionOverride",yh,{omit:["defaultValue"]});class mh extends Zs{constructor(t,e){super(t,dh,e);}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||ri(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,(e,r)=>t&&r in t?String(t[r]):"");}(e.properties,i);}createBucket(t){return new hh(t);}queryRadius(){return 0;}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex");}_setPaintOverrides(){for(const t of dh.paint.overridableProperties){if(!mh.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new yh(e),n=new ei(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new ii("source",n):new si("composite",n,e.value.zoomStops),this.paint._values[t]=new Ls(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return!(!this.layout||e.isDataDriven()||r.isDataDriven())&&mh.hasPaintOverride(this.layout,t);}static hasPaintOverride(t,e){const r=t.get("text-field"),n=dh.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0);};if("constant"===r.value.kind&&r.value.value instanceof Ee)s(r.value.value.sections);else if("source"===r.value.kind||"composite"===r.value.kind){const t=e=>{i||(e instanceof qe&&je(e.value)===qt?s(e.value.sections):e instanceof zr?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i;}}let gh;var xh={get paint(){return gh=gh||new Gs({"background-color":new Rs(vt.paint_background["background-color"]),"background-pattern":new Ns(vt.paint_background["background-pattern"]),"background-opacity":new Rs(vt.paint_background["background-opacity"])});}};class vh extends Zs{constructor(t,e){super(t,xh,e);}}class bh extends Zs{constructor(t,e){super(t,{},e),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);},this.implementation=t;}is3D(){return"3d"===this.implementation.renderingMode;}hasOffscreenPass(){return void 0!==this.implementation.prerender;}recalculate(){}updateTransitions(){}hasTransition(){return!1;}serialize(){throw new Error("Custom layers cannot be serialized");}}class wh{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel(),this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout(()=>{this._triggered=!1,this._methodToThrottle();},0));}remove(){delete this._channel,this._methodToThrottle=()=>{};}}const _h={once:!0},Sh=6371008.8;class Ah{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90");}wrap(){return new Ah($(this.lng,-180,180),this.lat);}toArray(){return[this.lng,this.lat];}toString(){return`LngLat(${this.lng}, ${this.lat})`;}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return Sh*Math.acos(Math.min(i,1));}static convert(t){if(t instanceof Ah)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Ah(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Ah(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]");}}const kh=2*Math.PI*Sh;function Mh(t){return kh*Math.cos(t*Math.PI/180);}function Ih(t){return(180+t)/360;}function zh(t){return(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360;}function Ph(t,e){return t/Mh(e);}function Ch(t){return 360*t-180;}function Eh(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90;}function Th(t,e){return t*Mh(Eh(e));}class Bh{constructor(t,e){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:0;this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;const r=Ah.convert(t);return new Bh(Ih(r.lng),zh(r.lat),Ph(e,r.lat));}toLngLat(){return new Ah(Ch(this.x),Eh(this.y));}toAltitude(){return Th(this.z,this.y);}meterInMercatorCoordinateUnits(){return 1/kh*(t=Eh(this.y),1/Math.cos(t*Math.PI/180));// removed by dead control flow
 var t; }}function Vh(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return[t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2];}class Fh{constructor(t,e,r){if(!function(t,e,r){return!(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t));}(t,e,r))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=r,this.key=Lh(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y;}url(t,e,r){const n=(s=this.y,a=this.z,o=Vh(256*(i=this.x),256*(s=Math.pow(2,a)-s-1),a),l=Vh(256*(i+1),256*(s+1),a),o[0]+","+o[1]+","+l[0]+","+l[1]);var i,s,a,o,l;const u=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i;}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,u).replace(/{bbox-epsg-3857}/g,n);}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e;}getTilePoint(t){const e=Math.pow(2,this.z);return new r((t.x*e-this.x)*P,(t.y*e-this.y)*P);}toString(){return`${this.z}/${this.x}/${this.y}`;}}class Dh{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Lh(t,e.z,e.z,e.x,e.y);}}class $h{constructor(t,e,r,n,i){if(this.terrainRttPosMatrix32f=null,t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t,this.wrap=e,this.canonical=new Fh(r,+n,+i),this.key=Lh(e,t,r,n,i);}clone(){return new $h(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical);}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new $h(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new $h(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e);}isOverscaled(){return this.overscaledZ>this.canonical.z;}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?Lh(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):Lh(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r);}isChildOf(t){if(t.wrap!==this.wrap)return!1;if(this.overscaledZ-t.overscaledZ<=0)return!1;if(0===t.overscaledZ)return this.overscaledZ>0;const e=this.canonical.z-t.canonical.z;return!(e<0)&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e;}children(t){if(this.overscaledZ>=t)return[new $h(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return[new $h(e,this.wrap,e,r,n),new $h(e,this.wrap,e,r+1,n),new $h(e,this.wrap,e,r,n+1),new $h(e,this.wrap,e,r+1,n+1)];}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y));}wrapped(){return new $h(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y);}unwrapTo(t){return new $h(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y);}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z);}toUnwrapped(){return new Dh(this.wrap,this.canonical);}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`;}getTilePoint(t){return this.canonical.getTilePoint(new Bh(t.x-this.wrap,t.y));}}function Lh(t,e,r,n,i){(t*=2)<0&&(t=-1*t-1);const s=1<<r;return(s*s*t+s*i+n).toString(36)+r.toString(36)+e.toString(36);}function Oh(t,e){return e?t.properties[e]:t.id;}us("CanonicalTileID",Fh),us("OverscaledTileID",$h,{omit:["terrainRttPosMatrix32f"]});class Rh{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0;}extend(t){return this.minX=Math.min(this.minX,t.x),this.minY=Math.min(this.minY,t.y),this.maxX=Math.max(this.maxX,t.x),this.maxY=Math.max(this.maxY,t.y),this;}expandBy(t){return this.minX-=t,this.minY-=t,this.maxX+=t,this.maxY+=t,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this;}shrinkBy(t){return this.expandBy(-t);}map(t){const e=new Rh();return e.extend(t(new r(this.minX,this.minY))),e.extend(t(new r(this.maxX,this.minY))),e.extend(t(new r(this.minX,this.maxY))),e.extend(t(new r(this.maxX,this.maxY))),e;}static fromPoints(t){const e=new Rh();for(const r of t)e.extend(r);return e;}contains(t){return t.x>=this.minX&&t.x<=this.maxX&&t.y>=this.minY&&t.y<=this.maxY;}empty(){return this.minX>this.maxX;}width(){return this.maxX-this.minX;}height(){return this.maxY-this.minY;}covers(t){return!this.empty()&&!t.empty()&&t.minX>=this.minX&&t.maxX<=this.maxX&&t.minY>=this.minY&&t.maxY<=this.maxY;}intersects(t){return!this.empty()&&!t.empty()&&t.minX<=this.maxX&&t.maxX>=this.minX&&t.minY<=this.maxY&&t.maxY>=this.minY;}}class Uh{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t];}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t];}}class jh{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry;}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t;}}class Nh{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new os(P,16,0),this.grid3D=new os(P,16,0),this.featureIndexArray=new $a(),this.promoteId=e;}insert(t,e,r,n,i,s){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const o=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}n[0]<P&&n[1]<P&&n[2]>=0&&n[3]>=0&&o.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Cu(new dc(this.rawTileData)).layers,this.sourceLayerCoder=new Uh(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers;}query(t,e,n,i){this.loadVTLayers();const s=t.params,a=P/t.tileSize/t.scale,o=fi(s.filter,s.globalState),l=t.queryGeometry,u=t.queryPadding*a,c=Rh.fromPoints(l),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),p=Rh.fromPoints(t.cameraQueryGeometry).expandBy(u),f=this.grid3D.query(p.minX,p.minY,p.maxX,p.maxY,(e,n,i,s)=>function(t,e,n,i,s){for(const r of t)if(e<=r.x&&n<=r.y&&i>=r.x&&s>=r.y)return!0;const a=[new r(e,n),new r(e,s),new r(i,s),new r(i,n)];if(t.length>2)for(const e of a)if(Jo(t,e))return!0;for(let e=0;e<t.length-1;e++)if(Wo(t[e],t[e+1],a))return!0;return!1;}(t.cameraQueryGeometry,e-u,n-u,i+u,s+u));for(const t of f)h.push(t);h.sort(Gh);const d={};let y;for(let r=0;r<h.length;r++){const u=h[r];if(u===y)continue;y=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(d,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,o,s.layers,s.availableImages,e,n,i,(e,r,n)=>(p||(p=$o(e)),r.queryIntersectsFeature({queryGeometry:l,feature:e,featureState:n,geometry:p,zoom:this.z,transform:t.transform,pixelsToTileUnits:a,pixelPosMatrix:t.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:t.getElevation})));}return d;}loadMatchingFeature(t,e,r,n,i,s,a,o,l,u,c){const h=this.bucketLayerIDs[e];if(s&&!h.some(t=>s.has(t)))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const t=Lo(f,!0);if(!i.filter(new Cs(this.tileID.overscaledZ),t,this.tileID.canonical))return;}else if(!i.filter(new Cs(this.tileID.overscaledZ),f))return;const d=this.getId(f,p);for(let e=0;e<h.length;e++){const r=h[e];if(s&&!s.has(r))continue;const i=o[r];if(!i)continue;let p={};d&&u&&(p=u.getState(i.sourceLayer||"_geojsonTileLayer",d));const y=L({},l[r]);y.paint=qh(y.paint,i.paint,f,p,a),y.layout=qh(y.layout,i.layout,f,p,a);const m=!c||c(f,i,p);if(!m)continue;const g=new jh(f,this.z,this.x,this.y,d);g.layer=y;let x=t[r];void 0===x&&(x=t[r]=[]),x.push({featureIndex:n,feature:g,intersectionZ:m});}}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=fi(i.filterSpec,i.globalState);for(const i of t)this.loadMatchingFeature(l,r,n,i,u,s,a,o,e);return l;}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return!0;return!1;}getId(t,e){var r;let n=t.id;return this.promoteId&&(n=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof n&&(n=Number(n)),void 0===n&&(null===(r=t.properties)||void 0===r?void 0:r.cluster)&&this.promoteId&&(n=Number(t.properties.cluster_id))),n;}}function qh(t,e,r,n,i){return R(t,(t,s)=>{const a=e instanceof Os?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a;});}function Gh(t,e){return e-t;}function Xh(t,e,n,i,s){const a=[];for(let o=0;o<t.length;o++){const l=t[o];let u;for(let t=0;t<l.length-1;t++){let o=l[t],c=l[t+1];o.x<e&&c.x<e||(o.x<e?o=new r(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x<e&&(c=new r(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y<n&&c.y<n||(o.y<n?o=new r(o.x+(n-o.y)/(c.y-o.y)*(c.x-o.x),n)._round():c.y<n&&(c=new r(o.x+(n-o.y)/(c.y-o.y)*(c.x-o.x),n)._round()),o.x>=i&&c.x>=i||(o.x>=i?o=new r(i,o.y+(i-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x>=i&&(c=new r(i,o.y+(i-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y>=s&&c.y>=s||(o.y>=s?o=new r(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round():c.y>=s&&(c=new r(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round()),u&&o.equals(u[u.length-1])||(u=[o],a.push(u)),u.push(c)))));}}return a;}us("FeatureIndex",Nh,{omit:["rawTileData","sourceLayerCoder"]});class Zh extends r{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n);}clone(){return new Zh(this.x,this.y,this.angle,this.segment);}}function Yh(t,e,r,n,i){if(void 0===e.segment||0===r)return!0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return!1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return!1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return!1;a++,o+=e.dist(r);}return!0;}function Hh(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e;}function Kh(t,e,r){return t?.6*e*r:0;}function Jh(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0);}function Wh(t,e,r,n,i,s){const a=Kh(r,i,s),o=Jh(r,n)*s;let l=0;const u=Hh(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=yr.number(n.x,i.x,c),p=yr.number(n.y,i.y,c),f=new Zh(h,p,i.angleTo(n),r);return f._round(),!a||Yh(t,f,o,a,e)?f:void 0;}l+=s;}}function Qh(t,e,r,n,i,s,a,o,l){const u=Kh(n,s,a),c=Jh(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),tp(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l);}function tp(t,e,r,n,i,s,a,o,l){const u=s/2,c=Hh(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],d=a.dist(o),y=o.angleTo(a);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=yr.number(a.x,o.x,m),x=yr.number(a.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Zh(g,x,y,e);r._round(),n&&!Yh(t,r,s,n,i)||f.push(r);}}h+=d;}return o||f.length||a||(f=tp(t,h/2,r,n,i,s,a,!0,l)),f;}function ep(t,e,n,i){const s=[],a=t.image,o=a.pixelRatio,l=a.paddedRect.w-2,u=a.paddedRect.h-2;let c={x1:t.left,y1:t.top,x2:t.right,y2:t.bottom};const h=a.stretchX||[[0,l]],p=a.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),y=p.reduce(f,0),m=l-d,g=u-y;let x=0,v=d,b=0,w=y,_=0,S=m,A=0,k=g;if(a.content&&i){const e=a.content,r=e[2]-e[0],n=e[3]-e[1];(a.textFitWidth||a.textFitHeight)&&(c=Qc(t)),x=rp(h,0,e[0]),b=rp(p,0,e[1]),v=rp(h,e[0],e[2]),w=rp(p,e[1],e[3]),_=e[0]-x,A=e[1]-b,S=r-v,k=n-w;}const M=c.x1,I=c.y1,z=c.x2-M,P=c.y2-I,C=(t,i,s,l)=>{const u=ip(t.stretch-x,v,z,M),c=sp(t.fixed-_,S,t.stretch,d),h=ip(i.stretch-b,w,P,I),p=sp(i.fixed-A,k,i.stretch,y),f=ip(s.stretch-x,v,z,M),m=sp(s.fixed-_,S,s.stretch,d),g=ip(l.stretch-b,w,P,I),C=sp(l.fixed-A,k,l.stretch,y),E=new r(u,h),T=new r(f,h),B=new r(f,g),V=new r(u,g),F=new r(c/o,p/o),D=new r(m/o,C/o),$=e*Math.PI/180;if($){const t=Math.sin($),e=Math.cos($),r=[e,-t,t,e];E._matMult(r),T._matMult(r),V._matMult(r),B._matMult(r);}const L=t.stretch+t.fixed,O=i.stretch+i.fixed;return{tl:E,tr:T,bl:V,br:B,tex:{x:a.paddedRect.x+1+L,y:a.paddedRect.y+1+O,w:s.stretch+s.fixed-L,h:l.stretch+l.fixed-O},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:F,pixelOffsetBR:D,minFontScaleX:S/o/z,minFontScaleY:k/o/P,isSDF:n};};if(i&&(a.stretchX||a.stretchY)){const t=np(h,m,d),e=np(p,g,y);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)s.push(C(n,e[t],i,e[t+1]));}}else s.push(C({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s;}function rp(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n;}function np(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+1,stretch:r}),n;}function ip(t,e,r,n){return t/e*r+n;}function sp(t,e,r,n){return t-e*r/n;}us("Anchor",Zh);class ap{constructor(t,e,n,i,s,a,o,l,u,c){var h;if(this.boxStartIndex=t.length,u){let t=a.top,e=a.bottom;const r=a.collisionPadding;r&&(t-=r[1],e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n),this.circleDiameter=n);}else{const u=(null===(h=a.image)||void 0===h?void 0:h.content)&&(a.image.textFitWidth||a.image.textFitHeight)?Qc(a):{x1:a.left,y1:a.top,x2:a.right,y2:a.bottom};u.y1=u.y1*o-l[0],u.y2=u.y2*o+l[2],u.x1=u.x1*o-l[3],u.x2=u.x2*o+l[1];const p=a.collisionPadding;if(p&&(u.x1-=p[0]*o,u.y1-=p[1]*o,u.x2+=p[2]*o,u.y2+=p[3]*o),c){const t=new r(u.x1,u.y1),e=new r(u.x2,u.y1),n=new r(u.x1,u.y2),i=new r(u.x2,u.y2),s=c*Math.PI/180;t._rotate(s),e._rotate(s),n._rotate(s),i._rotate(s),u.x1=Math.min(t.x,e.x,n.x,i.x),u.x2=Math.max(t.x,e.x,n.x,i.x),u.y1=Math.min(t.y,e.y,n.y,i.y),u.y2=Math.max(t.y,e.y,n.y,i.y);}t.emplaceBack(e.x,e.y,u.x1,u.y1,u.x2,u.y2,n,i,s);}this.boxEndIndex=t.length;}}class op{constructor(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:(t,e)=>t<e?-1:t>e?1:0;if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t;}peek(){return this.data[0];}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}function lp(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:1;let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:!1;const i=Rh.fromPoints(t[0]),s=Math.min(i.width(),i.height());let a=s/2;const o=new op([],up),{minX:l,minY:u,maxX:c,maxY:h}=i;if(0===s)return new r(l,u);for(let e=l;e<c;e+=s)for(let r=u;r<h;r+=s)o.push(new cp(e+a,r+a,a,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new cp(r/e,n/e,0,t);}(t),f=o.length;for(;o.length;){const r=o.pop();(r.d>p.d||!p.d)&&(p=r,n&&console.log("found best %d after %d probes",Math.round(1e4*r.d)/1e4,f)),r.max-p.d<=e||(a=r.h/2,o.push(new cp(r.p.x-a,r.p.y-a,a,t)),o.push(new cp(r.p.x+a,r.p.y-a,a,t)),o.push(new cp(r.p.x-a,r.p.y+a,a,t)),o.push(new cp(r.p.x+a,r.p.y+a,a,t)),f+=4);}return n&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p;}function up(t,e){return e.max-t.max;}function cp(t,e,n,i){this.p=new r(t,e),this.h=n,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,Ho(t,i,o));}}return(r?1:-1)*Math.sqrt(n);}(this.p,i),this.max=this.d+this.h*Math.SQRT2;}var hp;t.aI=void 0,(hp=t.aI||(t.aI={}))[hp.center=1]="center",hp[hp.left=2]="left",hp[hp.right=3]="right",hp[hp.top=4]="top",hp[hp.bottom=5]="bottom",hp[hp["top-left"]=6]="top-left",hp[hp["top-right"]=7]="top-right",hp[hp["bottom-left"]=8]="bottom-left",hp[hp["bottom-right"]=9]="bottom-right";const pp=Number.POSITIVE_INFINITY;function fp(t,e){return e[1]!==pp?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}return[n,i];}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.SQRT2;switch(t){case"top-right":case"top-left":n=i-7;break;case"bottom-right":case"bottom-left":n=7-i;break;case"bottom":n=7-e;break;case"top":n=e-7;}switch(t){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=e;break;case"right":r=-e;}return[r,n];}(t,e[0]);}function dp(t,e,r){var n;const i=t.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(e,{},r);if(s){const t=s.values,e=[];for(let r=0;r<t.length;r+=2){const n=e[r]=t[r],i=t[r+1].map(t=>t*cc);n.startsWith("top")?i[1]-=7:n.startsWith("bottom")&&(i[1]+=7),e[r+1]=i;}return new $e(e);}const a=i.get("text-variable-anchor");if(a){let n;n=void 0!==t._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(e,{},r)*cc,pp]:i.get("text-offset").evaluate(e,{},r).map(t=>t*cc);const s=[];for(const t of a)s.push(t,fp(t,n));return new $e(s);}return null;}function yp(t){switch(t){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left";}return"center";}function mp(e,r,n,i,s,a,o,l,u,c,h,p){let f=a.textMaxSize.evaluate(r,{});void 0===f&&(f=o);const d=e.layers[0].layout,y=d.get("icon-offset").evaluate(r,{},h),m=xp(n.horizontal),g=o/24,x=e.tilePixelRatio*g,v=e.tilePixelRatio*f/24,b=e.tilePixelRatio*l,w=e.tilePixelRatio*d.get("symbol-spacing"),_=d.get("text-padding")*e.tilePixelRatio,S=function(t,e,r){let n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:1;const i=t.get("icon-padding").evaluate(e,{},r),s=i&&i.values;return[s[0]*n,s[1]*n,s[2]*n,s[3]*n];}(d,r,h,e.tilePixelRatio),A=d.get("text-max-angle")/180*Math.PI,k="viewport"!==d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),M="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),I=d.get("symbol-placement"),z=w/2,C=d.get("icon-text-fit");let E;i&&"none"!==C&&(e.allowVerticalPlacement&&n.vertical&&(E=th(i,n.vertical,C,d.get("icon-text-fit-padding"),y,g)),m&&(i=th(i,m,C,d.get("icon-text-fit-padding"),y,g)));const T=h?p.line.getGranularityForZoomLevel(h.z):1,B=(l,p)=>{p.x<0||p.x>=P||p.y<0||p.y>=P||function(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k){const M=e.addToLineVertexArray(r,n);let I,z,P,C,E=0,T=0,B=0,V=0,F=-1,D=-1;const $={};let L=po("");if(e.allowVerticalPlacement&&i.vertical){const t=l.layout.get("text-rotate").evaluate(w,{},A)+90;P=new ap(u,r,c,h,p,i.vertical,f,d,y,t),o&&(C=new ap(u,r,c,h,p,o,g,x,y,t));}if(s){const n=l.layout.get("icon-rotate").evaluate(w,{}),i="none"!==l.layout.get("icon-text-fit"),a=ep(s,n,S,i),f=o?ep(o,n,S,i):void 0;z=new ap(u,r,c,h,p,s,g,x,!1,n),E=4*a.length;const d=e.iconSizeData;let y=null;"source"===d.kind?(y=[eh*l.layout.get("icon-size").evaluate(w,{})],y[0]>rh&&q(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===d.kind&&(y=[eh*_.compositeIconSizes[0].evaluate(w,{},A),eh*_.compositeIconSizes[1].evaluate(w,{},A)],(y[0]>rh||y[1]>rh)&&q(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),e.addSymbols(e.icon,a,y,b,v,w,t.as.none,r,M.lineStartIndex,M.lineLength,-1,A),F=e.icon.placedSymbolArray.length-1,f&&(T=4*f.length,e.addSymbols(e.icon,f,y,b,v,w,t.as.vertical,r,M.lineStartIndex,M.lineLength,-1,A),D=e.icon.placedSymbolArray.length-1);}const O=Object.keys(i.horizontal);for(const n of O){const s=i.horizontal[n];if(!I){L=po(s.text);const t=l.layout.get("text-rotate").evaluate(w,{},A);I=new ap(u,r,c,h,p,s,f,d,y,t);}const o=1===s.positionedLines.length;if(B+=gp(e,r,s,a,l,y,w,m,M,i.vertical?t.as.horizontal:t.as.horizontalOnly,o?O:[n],$,F,_,A),o)break;}i.vertical&&(V+=gp(e,r,i.vertical,a,l,y,w,m,M,t.as.vertical,["vertical"],$,D,_,A));const R=I?I.boxStartIndex:e.collisionBoxArray.length,U=I?I.boxEndIndex:e.collisionBoxArray.length,j=P?P.boxStartIndex:e.collisionBoxArray.length,N=P?P.boxEndIndex:e.collisionBoxArray.length,G=z?z.boxStartIndex:e.collisionBoxArray.length,X=z?z.boxEndIndex:e.collisionBoxArray.length,Z=C?C.boxStartIndex:e.collisionBoxArray.length,Y=C?C.boxEndIndex:e.collisionBoxArray.length;let H=-1;const K=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;H=K(I,H),H=K(P,H),H=K(z,H),H=K(C,H);const J=H>-1?1:0;J&&(H*=k/cc),e.glyphOffsetArray.length>=hh.MAX_GLYPHS&&q("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&e.addToSortKeyRanges(e.symbolInstances.length,w.sortKey);const W=dp(l,w,A),[Q,tt]=function(e,r){const n=e.length,i=null==r?void 0:r.values;if((null==i?void 0:i.length)>0)for(let r=0;r<i.length;r+=2){const n=i[r+1];e.emplaceBack(t.aI[i[r]],n[0],n[1]);}return[n,e.length];}(e.textAnchorOffsets,W);e.symbolInstances.emplaceBack(r.x,r.y,$.right>=0?$.right:-1,$.center>=0?$.center:-1,$.left>=0?$.left:-1,$.vertical||-1,F,D,L,R,U,j,N,G,X,Z,Y,c,B,V,E,T,J,0,f,H,Q,tt);}(e,p,l,n,i,s,E,e.layers[0],e.collisionBoxArray,r.index,r.sourceLayerIndex,e.index,x,[_,_,_,_],k,u,b,S,M,y,r,a,c,h,o);};if("line"===I)for(const t of Xh(r.geometry,0,0,P,P)){const r=fu(t,T),s=Qh(r,w,A,n.vertical||m,i,24,v,e.overscaling,P);for(const t of s)m&&vp(e,m.text,z,t)||B(r,t);}else if("line-center"===I){for(const t of r.geometry)if(t.length>1){const e=fu(t,T),r=Wh(e,A,n.vertical||m,i,24,v);r&&B(e,r);}}else if("Polygon"===r.type)for(const t of tn(r.geometry,0)){const e=lp(t,16);B(fu(t[0],T,!0),new Zh(e.x,e.y,0));}else if("LineString"===r.type)for(const t of r.geometry){const e=fu(t,T);B(e,new Zh(e[0].x,e[0].y,0));}else if("Point"===r.type)for(const t of r.geometry)for(const e of t)B([e],new Zh(e.x,e.y,0));}function gp(t,e,n,i,s,a,o,l,u,c,h,p,f,d,y){const m=function(t,e,n,i,s,a,o,l){const u=i.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const i of t.positionedGlyphs){if(!i.rect)continue;const a=i.rect||{};let h=4,p=!0,f=1,d=0;const y=(s||l)&&i.vertical,m=i.metrics.advance*i.scale/2;if(l&&e.verticalizable&&(d=t.lineOffset/2-(i.imageName?-(cc-i.metrics.width*i.scale)/2:(i.scale-1)*cc)),i.imageName){const t=o[i.imageName];p=t.sdf,f=t.pixelRatio,h=1/f;}const g=s?[i.x+m,i.y]:[0,0];let x=s?[0,0]:[i.x+m+n[0],i.y+n[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=i.metrics.isDoubleResolution?2:1,w=(i.metrics.left-h)*i.scale-m+x[0],_=(-i.metrics.top-h)*i.scale+x[1],S=w+a.w/b*i.scale/f,A=_+a.h/b*i.scale/f,k=new r(w,_),M=new r(S,_),I=new r(w,A),z=new r(S,A);if(y){const t=new r(-m,m- -17),e=-Math.PI/2,n=12-m,s=new r(22-n,-(i.imageName?n:0)),a=new r(...v);k._rotateAround(e,t)._add(s)._add(a),M._rotateAround(e,t)._add(s)._add(a),I._rotateAround(e,t)._add(s)._add(a),z._rotateAround(e,t)._add(s)._add(a);}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];k._matMult(r),M._matMult(r),I._matMult(r),z._matMult(r);}const P=new r(0,0),C=new r(0,0);c.push({tl:k,tr:M,bl:I,br:z,tex:a,writingMode:e.writingMode,glyphOffset:g,sectionIndex:i.sectionIndex,isSDF:p,pixelOffsetTL:P,pixelOffsetBR:C,minFontScaleX:0,minFontScaleY:0});}return c;}(0,n,l,s,a,o,i,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[eh*s.layout.get("text-size").evaluate(o,{})],x[0]>rh&&q(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(x=[eh*d.compositeTextSizes[0].evaluate(o,{},y),eh*d.compositeTextSizes[1].evaluate(o,{},y)],(x[0]>rh||x[1]>rh)&&q(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,l,a,o,c,e,u.lineStartIndex,u.lineLength,f,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length;}function xp(t){for(const e in t)return t[e];return null;}function vp(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return!0;}else i[e]=[];return i[e].push(n),!1;}const bp=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class wp{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=bp[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new wp(a,s,i,t);}constructor(t){let e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:64;let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:Float64Array;let n=arguments.length>3?arguments[3]:undefined;if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=bp.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+a+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r;}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return _p(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this;}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:a}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=a){for(let a=h;a<=c;a++){const o=s[2*a],u=s[2*a+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[a]);}continue;}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l;}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,a=[0,n.length-1,0],o=[],l=r*r;for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)Mp(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue;}const p=h+c>>1,f=i[2*p],d=i[2*p+1];Mp(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return o;}}function _p(t,e,r,n,i,s){if(i-n<=r)return;const a=n+i>>1;Sp(t,e,a,n,i,s),_p(t,e,r,n,a-1,1-s),_p(t,e,r,a+1,i,1-s);}function Sp(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const a=i-n+1,o=r-n+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);Sp(t,e,r,Math.max(n,Math.floor(r-o*u/a+c)),Math.min(i,Math.floor(r+(a-o)*u/a+c)),s);}const a=e[2*r+s];let o=n,l=i;for(Ap(t,e,n,r),e[2*i+s]>a&&Ap(t,e,n,i);o<l;){for(Ap(t,e,o,l),o++,l--;e[2*o+s]<a;)o++;for(;e[2*l+s]>a;)l--;}e[2*n+s]===a?Ap(t,e,n,l):(l++,Ap(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function Ap(t,e,r,n){kp(t,r,n),kp(e,2*r,2*n),kp(e,2*r+1,2*n+1);}function kp(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Mp(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s;}var Ip;t.cA=void 0,(Ip=t.cA||(t.cA={})).create="create",Ip.load="load",Ip.fullLoad="fullLoad";let zp=null,Pp=[];const Cp=1e3/60,Ep="loadTime",Tp="fullLoadTime",Bp={mark(t){performance.mark(t);},frame(t){const e=t;null!=zp&&Pp.push(e-zp),zp=e;},clearMetrics(){zp=null,Pp=[],performance.clearMeasures(Ep),performance.clearMeasures(Tp);for(const e in t.cA)performance.clearMarks(t.cA[e]);},getPerformanceMetrics(){performance.measure(Ep,t.cA.create,t.cA.load),performance.measure(Tp,t.cA.create,t.cA.fullLoad);const e=performance.getEntriesByName(Ep)[0].duration,r=performance.getEntriesByName(Tp)[0].duration,n=Pp.length,i=1/(Pp.reduce((t,e)=>t+e,0)/n/1e3),s=Pp.filter(t=>t>Cp).reduce((t,e)=>t+(e-Cp)/Cp,0);return{loadTime:e,fullLoadTime:r,fps:i,percentDroppedFrames:s/(n+s)*100,totalFrames:n};}};t.$=J,t.A=f,t.B=es,t.C=function(_ref74){let[t,e,r]=_ref74;return e+=90,e*=Math.PI/180,r*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(r),y:t*Math.sin(e)*Math.sin(r),z:t*Math.cos(r)};},t.D=Rs,t.E=xt,t.F=yr,t.G=Cs,t.H=ns,t.I=Cc,t.J=Y,t.K=class{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new wh(()=>this.process()),this.subscription=tt(this.target,"message",t=>this.receive(t),!1),this.globalScope=X(self)?t:window;}registerMessageHandler(t,e){this.messageHandlers[t]=e;}sendAsync(t,e){return new Promise((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=e?tt(e.signal,"abort",()=>{null==s||s.unsubscribe(),delete this.resolveRejects[i];const e={id:i,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e);},_h):null;this.resolveRejects[i]={resolve:t=>{null==s||s.unsubscribe(),r(t);},reject:t=>{null==s||s.unsubscribe(),n(t);}};const a=[],o=Object.assign(Object.assign({},t),{id:i,sourceMapId:this.mapId,origin:location.origin,data:fs(t.data,a)});this.target.postMessage(o,{transfer:a});});}receive(t){const e=t.data,r=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[r];const t=this.abortControllers[r];return delete this.abortControllers[r],void(t&&t.abort());}if(X(self)||e.mustQueue)return this.tasks[r]=e,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,e);}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e);}processTask(t,r){return e(this,void 0,void 0,function*(){if("<response>"===r.type){const e=this.resolveRejects[t];if(delete this.resolveRejects[t],!e)return;return void(r.error?e.reject(ds(r.error)):e.resolve(ds(r.data)));}if(!this.messageHandlers[r.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const e=ds(r.data),n=new AbortController();this.abortControllers[t]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,e,n);this.completeTask(t,null,i);}catch(e){this.completeTask(t,e);}});}completeTask(t,e,r){const n=[];delete this.abortControllers[t];const i={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?fs(e):null,data:fs(r,n)};this.target.postMessage(i,{transfer:n});}remove(){this.invoker.remove(),this.subscription.unsubscribe();}},t.L=ut,t.M=function(){var t=new f(16);return f!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t;},t.N=function(t,e,r){var n,i,s,a,o,l,u,c,h,p,f,d,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*y+o*m+h*g+e[12],t[13]=i*y+l*m+p*g+e[13],t[14]=s*y+u*m+f*g+e[14],t[15]=a*y+c*m+d*g+e[15]),t;},t.O=function(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t;},t.P=r,t.Q=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y,t[1]=v*i+b*l+w*p+_*m,t[2]=v*s+b*u+w*f+_*g,t[3]=v*a+b*c+w*d+_*x,t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*i+b*l+w*p+_*m,t[6]=v*s+b*u+w*f+_*g,t[7]=v*a+b*c+w*d+_*x,t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*i+b*l+w*p+_*m,t[10]=v*s+b*u+w*f+_*g,t[11]=v*a+b*c+w*d+_*x,t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*i+b*l+w*p+_*m,t[14]=v*s+b*u+w*f+_*g,t[15]=v*a+b*c+w*d+_*x,t;},t.R=vl,t.S=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r;},t.T=zl,t.U=Ah,t.V=$,t.W=zh,t.X=Ih,t.Y=c,t.Z=h,t._=e,t.a=ot,t.a$=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t;},t.a0=$h,t.a1=Ch,t.a2=Eh,t.a3=P,t.a4=function(t,e){var r,n,i,s,a;if(!t)return null!=e?e:{};if(!e)return t;let o=Object.assign({},t);if(e.removeAll&&(o={removeAll:!0}),e.remove){const n=new Set(e.remove);o.add&&(o.add=o.add.filter(t=>!n.has(t.id))),o.update&&(o.update=o.update.filter(t=>!n.has(t.id)));const i=new Set((null!==(r=t.add)&&void 0!==r?r:[]).map(t=>t.id));e.remove=e.remove.filter(t=>!i.has(t));}if(e.remove){const t=new Set(o.remove?o.remove.concat(e.remove):e.remove);o.remove=Array.from(t.values());}if(e.add){const t=o.add?o.add.concat(e.add):e.add,r=new Map(t.map(t=>[t.id,t]));o.add=Array.from(r.values());}if(e.update){const t=new Map(null===(n=o.update)||void 0===n?void 0:n.map(t=>[t.id,t]));for(const r of e.update){const e=null!==(i=t.get(r.id))&&void 0!==i?i:{id:r.id};r.newGeometry&&(e.newGeometry=r.newGeometry),r.addOrUpdateProperties&&(e.addOrUpdateProperties=(null!==(s=e.addOrUpdateProperties)&&void 0!==s?s:[]).concat(r.addOrUpdateProperties)),r.removeProperties&&(e.removeProperties=(null!==(a=e.removeProperties)&&void 0!==a?a:[]).concat(r.removeProperties)),r.removeAllProperties&&(e.removeAllProperties=!0),t.set(r.id,e);}o.update=Array.from(t.values());}return o.remove&&o.add&&(o.remove=o.remove.filter(t=>-1===o.add.findIndex(e=>e.id===t))),o;},t.a5=Bh,t.a6=Rh,t.a7=25,t.a8=Fh,t.a9=t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise(r=>{e.onloadstart=()=>{r(e);};for(const r of t){const t=window.document.createElement("source");ft(r)||(e.crossOrigin="Anonymous"),t.src=r,e.appendChild(t);}});},t.aA=A,t.aB=function(t,e,n,i){const s=e.y-t.y,a=e.x-t.x,o=i.y-n.y,l=i.x-n.x,u=o*a-l*s;if(0===u)return null;const c=(l*(t.y-n.y)-o*(t.x-n.x))/u;return new r(t.x+c*a,t.y+c*s);},t.aC=Xh,t.aD=jo,t.aE=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return[e,r,n,i];},t.aF=cc,t.aG=C,t.aH=function(t,e,r,n){let i=arguments.length>4&&arguments[4]!==undefined?arguments[4]:!1;if(!r[0]&&!r[1])return[0,0];const s=i?"map"===n?-t.bearingInRadians:0:"viewport"===n?t.bearingInRadians:0;if(s){const t=Math.sin(s),e=Math.cos(s);r=[r[0]*e-r[1]*t,r[0]*t+r[1]*e];}return[i?r[0]:C(e,r[0],t.zoom),i?r[1]:C(e,r[1],t.zoom)];},t.aJ=ih,t.aK=yp,t.aL=Gc,t.aM=wp,t.aN=ta,t.aO=lu,t.aP=La,t.aQ=eo,t.aR=Ja,t.aS=rt,t.aT=Th,t.aU=b,t.aV=v,t.aW=function(t){var e=new f(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e;},t.aX=function(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t;},t.aY=function(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t;},t.aZ=w,t.a_=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2];},t.aa=Et,t.ab=function(){return O++;},t.ac=Ia,t.ad=hh,t.ae=fi,t.af=Lo,t.ag=jh,t.ah=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,(t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),"";}),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e;},t.ai=D,t.aj=85.051129,t.ak=et,t.al=function(t){return Math.pow(2,t);},t.am=y,t.an=Ph,t.ao=function(t){return Math.log(t)/Math.LN2;},t.ap=function(t){var e=t[0],r=t[1];return e*e+r*r;},t.aq=function(t){if(!t.length)return new Set();const e=Math.max(...t.map(t=>t.canonical.z));let r=1/0,n=-1/0,i=1/0,s=-1/0;const a=[];for(const o of t){const{x:t,y:l,z:u}=o.canonical,c=Math.pow(2,e-u),h=t*c,p=l*c;a.push({id:o,x:h,y:p}),h<r&&(r=h),h>n&&(n=h),p<i&&(i=p),p>s&&(s=p);}const o=new Set();for(const t of a)t.x!==r&&t.x!==n&&t.y!==i&&t.y!==s||o.add(t.id);return o;},t.ar=function(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?D(fr.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=yr.number(t.minSize,t.maxSize,o):r=o;}return{uSizeT:r,uSize:n};},t.at=function(t,_ref75,_ref76){let{uSize:e,uSizeT:r}=_ref75;let{lowerSize:n,upperSize:i}=_ref76;return"source"===t.kind?n/eh:"composite"===t.kind?yr.number(n/eh,i/eh,r):e;},t.au=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,w=n*l-i*o,_=n*u-s*o,S=i*u-s*l,A=c*y-h*d,k=c*m-p*d,M=c*g-f*d,I=h*m-p*y,z=h*g-f*y,P=p*g-f*m,C=x*P-v*z+b*I+w*M-_*k+S*A;return C?(t[0]=(o*P-l*z+u*I)*(C=1/C),t[1]=(i*z-n*P-s*I)*C,t[2]=(y*S-m*_+g*w)*C,t[3]=(p*_-h*S-f*w)*C,t[4]=(l*M-a*P-u*k)*C,t[5]=(r*P-i*M+s*k)*C,t[6]=(m*b-d*S-g*v)*C,t[7]=(c*S-p*b+f*v)*C,t[8]=(a*z-o*M+u*A)*C,t[9]=(n*M-r*z-s*A)*C,t[10]=(d*_-y*b+g*x)*C,t[11]=(h*b-c*_-f*x)*C,t[12]=(o*k-a*I-l*A)*C,t[13]=(r*I-n*k+i*A)*C,t[14]=(y*v-d*w-m*x)*C,t[15]=(c*w-h*v+p*x)*C,t):null;},t.av=I,t.aw=function(t){var e=t[0],r=t[1];return Math.sqrt(e*e+r*r);},t.ax=function(t){return t[0]=0,t[1]=0,t;},t.ay=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t;},t.az=oh,t.b=H,t.b$=function(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t;},t.b0=g,t.b1=function(t,e,r){const n=e[0]*r[0]+e[1]*r[1]+e[2]*r[2];return 0===n?null:(-(t[0]*r[0]+t[1]*r[1]+t[2]*r[2])-r[3])/n;},t.b2=S,t.b3=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t;},t.b4=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3];},t.b5=Dh,t.b6=Lh,t.b7=function(t,e,r,n,i){var s=1/Math.tan(e/2);if(t[0]=s/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0){var a=1/(n-i);t[10]=(i+n)*a,t[14]=2*i*n*a;}else t[10]=-1,t[14]=-2*n;return t;},t.b8=function(t){var e=new f(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e;},t.b9=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t;},t.bA=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0],s[1]=i[1]*Math.cos(n)-i[2]*Math.sin(n),s[2]=i[1]*Math.sin(n)+i[2]*Math.cos(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t;},t.bB=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[2]*Math.sin(n)+i[0]*Math.cos(n),s[1]=i[1],s[2]=i[2]*Math.cos(n)-i[0]*Math.sin(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t;},t.bC=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=a*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=a*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t;},t.bD=function(t,e){const r=E(t,360),n=E(e,360),i=n-r,s=n>r?i-360:i+360;return Math.abs(i)<Math.abs(s)?i:s;},t.bE=function(t){return t[0]=0,t[1]=0,t[2]=0,t;},t.bF=function(t,e,r,n){const i=Math.sqrt(t*t+e*e),s=Math.sqrt(r*r+n*n);t/=i,e/=i,r/=s,n/=s;const a=Math.acos(t*r+e*n);return-e*r+t*n>0?a:-a;},t.bG=function(t,e){const r=E(t,2*Math.PI),n=E(e,2*Math.PI);return Math.min(Math.abs(r-n),Math.abs(r-n+2*Math.PI),Math.abs(r-n-2*Math.PI));},t.bH=function(){const t={},e=vt.$version;for(const r in vt.$root){const n=vt.$root[r];if(n.required){let i=null;i="version"===r?e:"array"===n.type?[]:{},null!=i&&(t[r]=i);}}return t;},t.bI=ys,t.bJ=ht,t.bK=function t(e,r){if(Array.isArray(e)){if(!Array.isArray(r)||e.length!==r.length)return!1;for(let n=0;n<e.length;n++)if(!t(e[n],r[n]))return!1;return!0;}if("object"==typeof e&&null!==e&&null!==r){if("object"!=typeof r)return!1;if(Object.keys(e).length!==Object.keys(r).length)return!1;for(const n in e)if(!t(e[n],r[n]))return!1;return!0;}return e===r;},t.bL=function(t){t=t.slice();const e=Object.create(null);for(let r=0;r<t.length;r++)e[t[r].id]=t[r];for(let r=0;r<t.length;r++)"ref"in t[r]&&(t[r]=wt(t[r],e[t[r].ref]));return t;},t.bM=function(t,e){if("custom"===t.type)return new bh(t,e);switch(t.type){case"background":return new vh(t,e);case"circle":return new hl(t,e);case"color-relief":return new El(t,e);case"fill":return new wu(t,e);case"fill-extrusion":return new Ru(t,e);case"heatmap":return new _l(t,e);case"hillshade":return new kl(t,e);case"line":return new ec(t,e);case"raster":return new Ks(t,e);case"symbol":return new mh(t,e);}},t.bN=t=>"raster"===t.type,t.bO=j,t.bP=function(t,e){if(!t)return[{command:"setStyle",args:[e]}];let r=[];try{if(!_t(t.version,e.version))return[{command:"setStyle",args:[e]}];_t(t.center,e.center)||r.push({command:"setCenter",args:[e.center]}),_t(t.state,e.state)||r.push({command:"setGlobalState",args:[e.state]}),_t(t.centerAltitude,e.centerAltitude)||r.push({command:"setCenterAltitude",args:[e.centerAltitude]}),_t(t.zoom,e.zoom)||r.push({command:"setZoom",args:[e.zoom]}),_t(t.bearing,e.bearing)||r.push({command:"setBearing",args:[e.bearing]}),_t(t.pitch,e.pitch)||r.push({command:"setPitch",args:[e.pitch]}),_t(t.roll,e.roll)||r.push({command:"setRoll",args:[e.roll]}),_t(t.sprite,e.sprite)||r.push({command:"setSprite",args:[e.sprite]}),_t(t.glyphs,e.glyphs)||r.push({command:"setGlyphs",args:[e.glyphs]}),_t(t.transition,e.transition)||r.push({command:"setTransition",args:[e.transition]}),_t(t.light,e.light)||r.push({command:"setLight",args:[e.light]}),_t(t.terrain,e.terrain)||r.push({command:"setTerrain",args:[e.terrain]}),_t(t.sky,e.sky)||r.push({command:"setSky",args:[e.sky]}),_t(t.projection,e.projection)||r.push({command:"setProjection",args:[e.projection]});const n={},i=[];!function(t,e,r,n){let i;for(i in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,i)&&(Object.prototype.hasOwnProperty.call(e,i)||kt(i,r,n));for(i in e)Object.prototype.hasOwnProperty.call(e,i)&&(Object.prototype.hasOwnProperty.call(t,i)?_t(t[i],e[i])||("geojson"===t[i].type&&"geojson"===e[i].type&&It(t,e,i)?St(r,{command:"setGeoJSONSourceData",args:[i,e[i].data]}):Mt(i,e,r,n)):At(i,e,r));}(t.sources,e.sources,i,n);const s=[];t.layers&&t.layers.forEach(t=>{"source"in t&&n[t.source]?r.push({command:"removeLayer",args:[t.id]}):s.push(t);}),r=r.concat(i),function(t,e,r){e=e||[];const n=(t=t||[]).map(Pt),i=e.map(Pt),s=t.reduce(Ct,{}),a=e.reduce(Ct,{}),o=n.slice(),l=Object.create(null);let u,c,h,p,f;for(let t=0,e=0;t<n.length;t++)u=n[t],Object.prototype.hasOwnProperty.call(a,u)?e++:(St(r,{command:"removeLayer",args:[u]}),o.splice(o.indexOf(u,e),1));for(let t=0,e=0;t<i.length;t++)u=i[i.length-1-t],o[o.length-1-t]!==u&&(Object.prototype.hasOwnProperty.call(s,u)?(St(r,{command:"removeLayer",args:[u]}),o.splice(o.lastIndexOf(u,o.length-e),1)):e++,p=o[o.length-t],St(r,{command:"addLayer",args:[a[u],p]}),o.splice(o.length-t,0,u),l[u]=!0);for(let t=0;t<i.length;t++)if(u=i[t],c=s[u],h=a[u],!l[u]&&!_t(c,h))if(_t(c.source,h.source)&&_t(c["source-layer"],h["source-layer"])&&_t(c.type,h.type)){for(f in zt(c.layout,h.layout,r,u,null,"setLayoutProperty"),zt(c.paint,h.paint,r,u,null,"setPaintProperty"),_t(c.filter,h.filter)||St(r,{command:"setFilter",args:[u,h.filter]}),_t(c.minzoom,h.minzoom)&&_t(c.maxzoom,h.maxzoom)||St(r,{command:"setLayerZoomRange",args:[u,h.minzoom,h.maxzoom]}),c)Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?zt(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):_t(c[f],h[f])||St(r,{command:"setLayerProperty",args:[u,f,h[f]]}));for(f in h)Object.prototype.hasOwnProperty.call(h,f)&&!Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?zt(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):_t(c[f],h[f])||St(r,{command:"setLayerProperty",args:[u,f,h[f]]}));}else St(r,{command:"removeLayer",args:[u]}),p=o[o.lastIndexOf(u)+1],St(r,{command:"addLayer",args:[h,p]});}(s,e.layers,r);}catch(t){console.warn("Unable to compute style diff:",t),r=[{command:"setStyle",args:[e]}];}return r;},t.bQ=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e;},t.bR=R,t.bS=U,t.bT=class extends xo{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.bU=wo,t.bV=class extends xo{constructor(t,e){super(t,e),this.current=_o;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break;}}},t.bW=bo,t.bX=class extends xo{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.bY=class extends xo{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.bZ=d,t.b_=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t;},t.ba=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t;},t.bb=function(){const t=new Float32Array(16);return y(t),t;},t.bc=function(){const t=new Float64Array(16);return y(t),t;},t.bd=function(){return new Float64Array(16);},t.be=function(t,e,r){const n=new Float64Array(4);return M(n,t,e-90,r),n;},t.bf=function(t,e,r,n){var i,s,a,o,l,u=e[0],c=e[1],h=e[2],f=e[3],d=r[0],y=r[1],m=r[2],g=r[3];return(s=u*d+c*y+h*m+f*g)<0&&(s=-s,d=-d,y=-y,m=-m,g=-g),1-s>p?(i=Math.acos(s),a=Math.sin(i),o=Math.sin((1-n)*i)/a,l=Math.sin(n*i)/a):(o=1-n,l=n),t[0]=o*u+l*d,t[1]=o*c+l*y,t[2]=o*h+l*m,t[3]=o*f+l*g,t;},t.bg=function(t){const e=new Float64Array(9);var r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v;h=(i=(n=t)[0])*(l=i+i),p=(s=n[1])*l,d=(a=n[2])*l,y=a*(u=s+s),g=(o=n[3])*l,x=o*u,v=o*(c=a+a),(r=e)[0]=1-(f=s*u)-(m=a*c),r[3]=p-v,r[6]=d+x,r[1]=p+v,r[4]=1-h-m,r[7]=y-g,r[2]=d-x,r[5]=y+g,r[8]=1-h-f;const b=rt(-Math.asin(D(e[2],-1,1)));let w,_;return Math.hypot(e[5],e[8])<.001?(w=0,_=-rt(Math.atan2(e[3],e[4]))):(w=rt(0===e[5]&&0===e[8]?0:Math.atan2(e[5],e[8])),_=rt(0===e[1]&&0===e[0]?0:Math.atan2(e[1],e[0]))),{roll:w,pitch:b+90,bearing:_};},t.bh=function(t,e){return t.roll==e.roll&&t.pitch==e.pitch&&t.bearing==e.bearing;},t.bi=Ie,t.bj=vo,t.bk=uu,t.bl=cu,t.bm=ou,t.bn=T,t.bo=B,t.bp=Oe,t.bq=function(t,e,r,n,i){return T(n,i,D((t-e)/(r-e),0,1));},t.br=E,t.bs=function(){return new Float64Array(3);},t.bt=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t;},t.bu=M,t.bv=function(t,e,r){var n=r[0],i=r[1],s=r[2],a=r[3],o=e[0],l=e[1],u=e[2],c=i*u-s*l,h=s*o-n*u,p=n*l-i*o;return t[0]=o+a*(c+=c)+i*(p+=p)-s*(h+=h),t[1]=l+a*h+s*c-n*p,t[2]=u+a*p+n*h-i*c,t;},t.bw=function(t,e,r){const n=(i=[t[0],t[1],t[2],e[0],e[1],e[2],r[0],r[1],r[2]])[0]*((c=i[8])*(a=i[4])-(o=i[5])*(u=i[7]))+i[1]*(-c*(s=i[3])+o*(l=i[6]))+i[2]*(u*s-a*l);var i,s,a,o,l,u,c;if(0===n)return null;const h=w([],[e[0],e[1],e[2]],[r[0],r[1],r[2]]),p=w([],[r[0],r[1],r[2]],[t[0],t[1],t[2]]),f=w([],[t[0],t[1],t[2]],[e[0],e[1],e[2]]),d=b([],h,-t[3]);return v(d,d,b([],p,-e[3])),v(d,d,b([],f,-r[3])),b(d,d,1/n),d;},t.bx=Sh,t.by=function(){return new Float64Array(4);},t.bz=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0]*Math.cos(n)-i[1]*Math.sin(n),s[1]=i[0]*Math.sin(n)+i[1]*Math.cos(n),s[2]=i[2],t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t;},t.c=at,t.c0=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t;},t.c1=class extends xo{constructor(t,e){super(t,e),this.current=new Array();}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(4*t.length);for(let r=0;r<t.length;r++)e[4*r]=t[r].r,e[4*r+1]=t[r].g,e[4*r+2]=t[r].b,e[4*r+3]=t[r].a;this.gl.uniform4fv(this.location,e);}}},t.c2=class extends xo{constructor(t,e){super(t,e),this.current=new Array();}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(t);this.gl.uniform1fv(this.location,e);}}},t.c3=class extends ya{},t.c4=oc,t.c5=class extends ga{},t.c6=wl,t.c7=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2));},t.c8=bl,t.c9=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(a=a||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/a,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/a,t;},t.cB=function(t){return t.message===st;},t.cC=ct,t.cD=function(t,e){ot.REGISTERED_PROTOCOLS[t]=e;},t.cE=function(t){delete ot.REGISTERED_PROTOCOLS[t];},t.cF=function(t,e){const r={};for(let n=0;n<t.length;n++){const i=e&&e[t[n].id]||_i(t[n]);e&&(e[t[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(t[n]);}const n=[];for(const t in r)n.push(r[t]);return n;},t.cG=us,t.cH=Uh,t.cI=Nh,t.cJ=Ec,t.cK=function(e){e.bucket.createArrays(),e.bucket.tilePixelRatio=P/(512*e.bucket.overscaling),e.bucket.compareText={},e.bucket.iconsNeedLinear=!1;const r=e.bucket.layers[0],n=r.layout,i=r._unevaluatedLayout._values,s={layoutIconSize:i["icon-size"].possiblyEvaluate(new Cs(e.bucket.zoom+1),e.canonical),layoutTextSize:i["text-size"].possiblyEvaluate(new Cs(e.bucket.zoom+1),e.canonical),textMaxSize:i["text-size"].possiblyEvaluate(new Cs(18))};if("composite"===e.bucket.textSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.textSizeData;s.compositeTextSizes=[i["text-size"].possiblyEvaluate(new Cs(t),e.canonical),i["text-size"].possiblyEvaluate(new Cs(r),e.canonical)];}if("composite"===e.bucket.iconSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.iconSizeData;s.compositeIconSizes=[i["icon-size"].possiblyEvaluate(new Cs(t),e.canonical),i["icon-size"].possiblyEvaluate(new Cs(r),e.canonical)];}const a=n.get("text-line-height")*cc,o="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement"),l=n.get("text-keep-upright"),u=n.get("text-size");for(const i of e.bucket.features){const c=n.get("text-font").evaluate(i,{},e.canonical).join(","),h=u.evaluate(i,{},e.canonical),p=s.layoutTextSize.evaluate(i,{},e.canonical),f=s.layoutIconSize.evaluate(i,{},e.canonical),d={horizontal:{},vertical:void 0},y=i.text;let m,g=[0,0];if(y){const s=y.toString(),u=n.get("text-letter-spacing").evaluate(i,{},e.canonical)*cc,f=xs(s)?u:0,m=n.get("text-anchor").evaluate(i,{},e.canonical),x=dp(r,i,e.canonical);if(!x){const t=n.get("text-radial-offset").evaluate(i,{},e.canonical);g=t?fp(m,[t*cc,pp]):n.get("text-offset").evaluate(i,{},e.canonical).map(t=>t*cc);}let v=o?"center":n.get("text-justify").evaluate(i,{},e.canonical);const b="point"===n.get("symbol-placement")?n.get("text-max-width").evaluate(i,{},e.canonical)*cc:1/0,w=()=>{e.bucket.allowVerticalPlacement&&gs(s)&&(d.vertical=Fc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,"left",f,g,t.as.vertical,!0,p,h));};if(!o&&x){const r=new Set();if("auto"===v)for(let t=0;t<x.values.length;t+=2)r.add(yp(x.values[t]));else r.add(v);let n=!1;for(const i of r)if(!d.horizontal[i])if(n)d.horizontal[i]=d.horizontal[0];else{const r=Fc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,"center",i,f,g,t.as.horizontal,!1,p,h);r&&(d.horizontal[i]=r,n=1===r.positionedLines.length);}w();}else{"auto"===v&&(v=yp(m));const r=Fc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.as.horizontal,!1,p,h);r&&(d.horizontal[v]=r),w(),gs(s)&&o&&l&&(d.vertical=Fc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.as.vertical,!1,p,h));}}let x=!1;if(i.icon&&i.icon.name){const t=e.imageMap[i.icon.name];t&&(m=Wc(e.imagePositions[i.icon.name],n.get("icon-offset").evaluate(i,{},e.canonical),n.get("icon-anchor").evaluate(i,{},e.canonical)),x=!!t.sdf,void 0===e.bucket.sdfIcons?e.bucket.sdfIcons=x:e.bucket.sdfIcons!==x&&q("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(t.pixelRatio!==e.bucket.pixelRatio||0!==n.get("icon-rotate").constantOr(1))&&(e.bucket.iconsNeedLinear=!0));}const v=xp(d.horizontal)||d.vertical;e.bucket.iconsInText=!!v&&v.iconsInText,(v||m)&&mp(e.bucket,i,d,m,e.imageMap,s,p,f,g,x,e.canonical,e.subdivisionGranularity);}e.showCollisionBoxes&&e.bucket.generateCollisionDebugBuffers();},t.cL=gu,t.cM=Vu,t.cN=Hu,t.cO=Cu,t.cP=dc,t.cQ=class{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},performance.mark(this._marks.start);}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),t=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),t;}},t.cR=function(t,r,n,i,s){return e(this,void 0,void 0,function*(){if(h())try{return yield J(t,r,n,i,s);}catch(t){}return function(t,e,r,n,i){const s=t.width,a=t.height;W&&Q||(W=new OffscreenCanvas(s,a),Q=W.getContext("2d",{willReadFrequently:!0})),W.width=s,W.height=a,Q.drawImage(t,0,0,s,a);const o=Q.getImageData(e,r,n,i);return Q.clearRect(0,0,s,a),o.data;}(t,r,n,i,s);});},t.cS=Pl,t.cT=n,t.cU=zu,t.cV=ku,t.cW=ni,t.cX=function(t,e){const r=new Map();if(null==t);else if("Feature"===t.type)r.set(Oh(t,e),t);else for(const n of t.features)r.set(Oh(n,e),n);return r;},t.cY=function(t,e){if(null==t)return!0;if("Feature"===t.type)return null!=Oh(t,e);if("FeatureCollection"===t.type){const r=new Set();for(const n of t.features){const t=Oh(n,e);if(null==t)return!1;if(r.has(t))return!1;r.add(t);}return!0;}return!1;},t.cZ=function(t,e,r){var n,i,s,a;if(e.removeAll&&t.clear(),e.remove)for(const r of e.remove)t.delete(r);if(e.add)for(const n of e.add){const e=Oh(n,r);null!=e&&t.set(e,n);}if(e.update)for(const r of e.update){let e=t.get(r.id);if(null==e)continue;const o=!r.removeAllProperties&&((null===(n=r.removeProperties)||void 0===n?void 0:n.length)>0||(null===(i=r.addOrUpdateProperties)||void 0===i?void 0:i.length)>0);if((r.newGeometry||r.removeAllProperties||o)&&(e=Object.assign({},e),t.set(r.id,e),o&&(e.properties=Object.assign({},e.properties))),r.newGeometry&&(e.geometry=r.newGeometry),r.removeAllProperties)e.properties={};else if((null===(s=r.removeProperties)||void 0===s?void 0:s.length)>0)for(const t of r.removeProperties)Object.prototype.hasOwnProperty.call(e.properties,t)&&delete e.properties[t];if((null===(a=r.addOrUpdateProperties)||void 0===a?void 0:a.length)>0)for(const{key:t,value:n}of r.addOrUpdateProperties)e.properties[t]=n;}},t.c_=Ps,t.ca=class extends ia{},t.cb=class extends Aa{},t.cc=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15];},t.cd=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=t[9],f=t[10],d=t[11],y=t[12],m=t[13],g=t[14],x=t[15],v=e[0],b=e[1],w=e[2],_=e[3],S=e[4],A=e[5],k=e[6],M=e[7],I=e[8],z=e[9],P=e[10],C=e[11],E=e[12],T=e[13],B=e[14],V=e[15];return Math.abs(r-v)<=p*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=p*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(i-w)<=p*Math.max(1,Math.abs(i),Math.abs(w))&&Math.abs(s-_)<=p*Math.max(1,Math.abs(s),Math.abs(_))&&Math.abs(a-S)<=p*Math.max(1,Math.abs(a),Math.abs(S))&&Math.abs(o-A)<=p*Math.max(1,Math.abs(o),Math.abs(A))&&Math.abs(l-k)<=p*Math.max(1,Math.abs(l),Math.abs(k))&&Math.abs(u-M)<=p*Math.max(1,Math.abs(u),Math.abs(M))&&Math.abs(c-I)<=p*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-z)<=p*Math.max(1,Math.abs(h),Math.abs(z))&&Math.abs(f-P)<=p*Math.max(1,Math.abs(f),Math.abs(P))&&Math.abs(d-C)<=p*Math.max(1,Math.abs(d),Math.abs(C))&&Math.abs(y-E)<=p*Math.max(1,Math.abs(y),Math.abs(E))&&Math.abs(m-T)<=p*Math.max(1,Math.abs(m),Math.abs(T))&&Math.abs(g-B)<=p*Math.max(1,Math.abs(g),Math.abs(B))&&Math.abs(x-V)<=p*Math.max(1,Math.abs(x),Math.abs(V));},t.ce=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t;},t.cf=t=>"symbol"===t.type,t.cg=t=>"circle"===t.type,t.ch=t=>"heatmap"===t.type,t.ci=t=>"line"===t.type,t.cj=t=>"fill"===t.type,t.ck=t=>"fill-extrusion"===t.type,t.cl=t=>"hillshade"===t.type,t.cm=t=>"color-relief"===t.type,t.cn=t=>"background"===t.type,t.co=t=>"custom"===t.type,t.cp=V,t.cq=function(t,e,r){const n=z(e.x-r.x,e.y-r.y),i=z(t.x-r.x,t.y-r.y);var s,a;return rt(Math.atan2(n[0]*i[1]-n[1]*i[0],(s=n)[0]*(a=i)[0]+s[1]*a[1]));},t.cr=F,t.cs=function(t,e){return it[e]&&(t instanceof MouseEvent||t instanceof WheelEvent);},t.ct=function(t,e){return nt[e]&&"touches"in t;},t.cu=function(t){return nt[t]||it[t];},t.cv=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[4]*i+r[12],t[1]=r[1]*n+r[5]*i+r[13],t;},t.cw=function(t,e){const{x:r,y:n}=Bh.fromLngLat(e);return!(t<0||t>25||n<0||n>=1||r<0||r>=1);},t.cx=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t;},t.cy=class extends na{},t.cz=Bp,t.d=ft,t.e=L,t.f=t=>e(void 0,void 0,void 0,function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e);}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`);}}),t.g=lt,t.h=t=>new Promise((e,r)=>{const n=new Image();n.onload=()=>{e(n),URL.revokeObjectURL(n.src),n.onload=null,window.requestAnimationFrame(()=>{n.src=K;});},n.onerror=()=>r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const i=new Blob([new Uint8Array(t)],{type:"image/png"});n.src=t.byteLength?URL.createObjectURL(i):K;}),t.i=X,t.j=(t,e)=>pt(L(t,{type:"json"}),e),t.k=gt,t.l=mt,t.m=pt,t.n=(t,e)=>pt(L(t,{type:"arrayBuffer"}),e),t.o=function(t){return new dc(t).readFields(Mc,[]);},t.p=Pc,t.q=xl,t.r=Gs,t.s=tt,t.t=vt,t.u=ms,t.v=ts,t.w=q,t.x=Vs,t.y=rs,t.z=as;});define("worker",["./shared"],function(e){"use strict";class t{constructor(e,t){this.keyCache={},e&&this.replace(e,t);}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t);}update(t,i,o){for(const i of t){this._layerConfigs[i.id]=i;const t=this._layers[i.id]=e.bM(i,o);t._featureFilter=e.ae(t.filter,o),this.keyCache[i.id]&&delete this.keyCache[i.id];}for(const e of i)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const s=e.cF(Object.values(this._layerConfigs),this.keyCache);for(const e of s){const t=e.map(e=>this._layers[e.id]),i=t[0];if("none"===i.visibility)continue;const o=i.source||"";let s=this.familiesBySource[o];s||(s=this.familiesBySource[o]={});const n=i.sourceLayer||"_geojsonTileLayer";let r=s[n];r||(r=s[n]=[]),r.push(t);}}}class i{constructor(t){const i={},o=[];for(const e in t){const s=t[e],n=i[e]={};for(const e in s){const t=s[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const i={x:0,y:0,w:t.bitmap.width+2,h:t.bitmap.height+2};o.push(i),n[e]={rect:i,metrics:t.metrics};}}const{w:s,h:n}=e.p(o),r=new e.q({width:s||1,height:n||1});for(const o in t){const s=t[o];for(const t in s){const n=s[+t];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const a=i[o][t].rect;e.q.copy(n.bitmap,r,{x:0,y:0},{x:a.x+1,y:a.y+1},n.bitmap);}}this.image=r,this.positions=i;}}e.cG("GlyphAtlas",i);class o{constructor(t){this.tileID=new e.a0(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[];}parse(t,o,n,r,a){return e._(this,void 0,void 0,function*(){this.status="parsing",this.data=t,this.collisionBoxArray=new e.ac();const l=new e.cH(Object.keys(t.layers).sort()),c=new e.cI(this.tileID,this.promoteId);c.bucketLayerIDs=[];const h={},u={featureIndex:c,iconDependencies:{},patternDependencies:{},glyphDependencies:{},dashDependencies:{},availableImages:n,subdivisionGranularity:a},d=o.familiesBySource[this.source];for(const i in d){const o=t.layers[i];if(!o)continue;1===o.version&&e.w(`Vector tile source "${this.source}" layer "${i}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const r=l.encode(i),a=[];for(let e=0;e<o.length;e++){const t=o.feature(e),s=c.getId(t,i);a.push({feature:t,id:s,index:e,sourceLayerIndex:r});}for(const t of d[i]){const i=t[0];i.source!==this.source&&e.w(`layer.source = ${i.source} does not equal this.source = ${this.source}`),i.isHidden(this.zoom,!0)||(s(t,this.zoom,n),(h[i.id]=i.createBucket({index:c.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:r,sourceID:this.source})).populate(a,u,this.tileID.canonical),c.bucketLayerIDs.push(t.map(e=>e.id)));}}const f=e.bR(u.glyphDependencies,e=>Object.keys(e).map(Number));this.inFlightDependencies.forEach(e=>null==e?void 0:e.abort()),this.inFlightDependencies=[];let g=Promise.resolve({});if(Object.keys(f).length){const e=new AbortController();this.inFlightDependencies.push(e),g=r.sendAsync({type:"GG",data:{stacks:f,source:this.source,tileID:this.tileID,type:"glyphs"}},e);}const p=Object.keys(u.iconDependencies);let m=Promise.resolve({});if(p.length){const e=new AbortController();this.inFlightDependencies.push(e),m=r.sendAsync({type:"GI",data:{icons:p,source:this.source,tileID:this.tileID,type:"icons"}},e);}const y=Object.keys(u.patternDependencies);let v=Promise.resolve({});if(y.length){const e=new AbortController();this.inFlightDependencies.push(e),v=r.sendAsync({type:"GI",data:{icons:y,source:this.source,tileID:this.tileID,type:"patterns"}},e);}const w=u.dashDependencies;let x=Promise.resolve({});if(Object.keys(w).length){const e=new AbortController();this.inFlightDependencies.push(e),x=r.sendAsync({type:"GDA",data:{dashes:w}},e);}const[_,b,S,M]=yield Promise.all([g,m,v,x]),I=new i(_),P=new e.cJ(b,S);for(const t in h){const i=h[t];i instanceof e.ad?(s(i.layers,this.zoom,n),e.cK({bucket:i,glyphMap:_,glyphPositions:I.positions,imageMap:b,imagePositions:P.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical,subdivisionGranularity:u.subdivisionGranularity})):i.hasDependencies&&(i instanceof e.cL||i instanceof e.cM||i instanceof e.cN)&&(s(i.layers,this.zoom,n),i.addFeatures(u,this.tileID.canonical,P.patternPositions,M));}return this.status="done",{buckets:Object.values(h).filter(e=>!e.isEmpty()),featureIndex:c,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:I.image,imageAtlas:P,dashPositions:M,glyphMap:this.returnDependencies?_:null,iconMap:this.returnDependencies?b:null,glyphPositions:this.returnDependencies?I.positions:null};});}}function s(t,i,o){const s=new e.G(i);for(const e of t)e.recalculate(s,o);}class n{constructor(e,t,i){this.actor=e,this.layerIndex=t,this.availableImages=i,this.fetching={},this.loading={},this.loaded={};}loadVectorTile(t,i){return e._(this,void 0,void 0,function*(){const o=yield e.n(t.request,i);try{return{vectorTile:new e.cO(new e.cP(o.data)),rawData:o.data,cacheControl:o.cacheControl,expires:o.expires};}catch(e){const i=new Uint8Array(o.data);let s=`Unable to parse the tile at ${t.request.url}, `;throw s+=31===i[0]&&139===i[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${e.message}`,new Error(s);}});}loadTile(t){return e._(this,void 0,void 0,function*(){const i=t.uid,s=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.cQ(t.request),n=new o(t);this.loading[i]=n;const r=new AbortController();n.abort=r;try{const o=yield this.loadVectorTile(t,r);if(delete this.loading[i],!o)return null;const a=o.rawData,l={};o.expires&&(l.expires=o.expires),o.cacheControl&&(l.cacheControl=o.cacheControl);const c={};if(s){const e=s.finish();e&&(c.resourceTiming=JSON.parse(JSON.stringify(e)));}n.vectorTile=o.vectorTile;const h=n.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);this.loaded[i]=n,this.fetching[i]={rawTileData:a,cacheControl:l,resourceTiming:c};try{const t=yield h;return e.e({rawTileData:a.slice(0)},t,l,c);}finally{delete this.fetching[i];}}catch(e){throw delete this.loading[i],n.status="done",this.loaded[i]=n,e;}});}reloadTile(t){return e._(this,void 0,void 0,function*(){const i=t.uid;if(!this.loaded||!this.loaded[i])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const o=this.loaded[i];if(o.showCollisionBoxes=t.showCollisionBoxes,"parsing"===o.status){const s=yield o.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);let n;if(this.fetching[i]){const{rawTileData:t,cacheControl:o,resourceTiming:r}=this.fetching[i];delete this.fetching[i],n=e.e({rawTileData:t.slice(0)},s,o,r);}else n=s;return n;}if("done"===o.status&&o.vectorTile)return o.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);});}abortTile(t){return e._(this,void 0,void 0,function*(){const e=this.loading,i=t.uid;e&&e[i]&&e[i].abort&&(e[i].abort.abort(),delete e[i]);});}removeTile(t){return e._(this,void 0,void 0,function*(){this.loaded&&this.loaded[t.uid]&&delete this.loaded[t.uid];});}}class r{constructor(){this.loaded={};}loadTile(t){return e._(this,void 0,void 0,function*(){const{uid:i,encoding:o,rawImageData:s,redFactor:n,greenFactor:r,blueFactor:a,baseShift:l}=t,c=s.width+2,h=s.height+2,u=e.b(s)?new e.R({width:c,height:h},yield e.cR(s,-1,-1,c,h)):s,d=new e.cS(i,u,o,n,r,a,l);return this.loaded=this.loaded||{},this.loaded[i]=d,d;});}removeTile(e){const t=this.loaded,i=e.uid;t&&t[i]&&delete t[i];}}var a,l,c=function(){if(l)return a;function e(e,i){if(0!==e.length){t(e[0],i);for(var o=1;o<e.length;o++)t(e[o],!i);}}function t(e,t){for(var i=0,o=0,s=0,n=e.length,r=n-1;s<n;r=s++){var a=(e[s][0]-e[r][0])*(e[r][1]+e[s][1]),l=i+a;o+=Math.abs(i)>=Math.abs(a)?i-l+a:a-l+i,i=l;}i+o>=0!=!!t&&e.reverse();}return l=1,a=function t(i,o){var s,n=i&&i.type;if("FeatureCollection"===n)for(s=0;s<i.features.length;s++)t(i.features[s],o);else if("GeometryCollection"===n)for(s=0;s<i.geometries.length;s++)t(i.geometries[s],o);else if("Feature"===n)t(i.geometry,o);else if("Polygon"===n)e(i.coordinates,o);else if("MultiPolygon"===n)for(s=0;s<i.coordinates.length;s++)e(i.coordinates[s],o);return i;};}(),h=e.cT(c);class u extends e.cV{constructor(t,i){super(new e.cP(),0,i,[],[]),this.feature=t,this.type=t.type,this.properties=t.tags?t.tags:{},"id"in t&&("string"==typeof t.id?this.id=parseInt(t.id,10):"number"!=typeof t.id||isNaN(t.id)||(this.id=t.id));}loadGeometry(){const t=[],i=1===this.feature.type?[this.feature.geometry]:this.feature.geometry;for(const o of i){const i=[];for(const t of o)i.push(new e.P(t[0],t[1]));t.push(i);}return t;}}class d extends e.cU{constructor(t,i){super(new e.cP()),this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.version=i?i.version:1,this.extent=i?i.extent:4096,this.length=t.length,this.features=t;}feature(e){return new u(this.features[e],this.extent);}}function f(e,t){t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);const i={keys:[],values:[],keycache:{},valuecache:{}};for(let o=0;o<e.length;o++)i.feature=e.feature(o),t.writeMessage(2,g,i);const o=i.keys;for(const e of o)t.writeStringField(3,e);const s=i.values;for(const e of s)t.writeMessage(4,w,e);}function g(e,t){if(!e.feature)return;const i=e.feature;void 0!==i.id&&t.writeVarintField(1,i.id),t.writeMessage(2,p,e),t.writeVarintField(3,i.type),t.writeMessage(4,v,i);}function p(e,t){for(const i in(_e$feature=e.feature)===null||_e$feature===void 0?void 0:_e$feature.properties){var _e$feature;let o=e.feature.properties[i],s=e.keycache[i];if(null===o)continue;void 0===s&&(e.keys.push(i),s=e.keys.length-1,e.keycache[i]=s),t.writeVarint(s),"string"!=typeof o&&"boolean"!=typeof o&&"number"!=typeof o&&(o=JSON.stringify(o));const n=typeof o+":"+o;let r=e.valuecache[n];void 0===r&&(e.values.push(o),r=e.values.length-1,e.valuecache[n]=r),t.writeVarint(r);}}function m(e,t){return(t<<3)+(7&e);}function y(e){return e<<1^e>>31;}function v(e,t){const i=e.loadGeometry(),o=e.type;let s=0,n=0;for(const r of i){let i=1;1===o&&(i=r.length),t.writeVarint(m(1,i));const a=3===o?r.length-1:r.length;for(let e=0;e<a;e++){1===e&&1!==o&&t.writeVarint(m(2,a-1));const i=r[e].x-s,l=r[e].y-n;t.writeVarint(y(i)),t.writeVarint(y(l)),s+=i,n+=l;}3===e.type&&t.writeVarint(m(7,1));}}function w(e,t){const i=typeof e;"string"===i?t.writeStringField(1,e):"boolean"===i?t.writeBooleanField(7,e):"number"===i&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}const x={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},_=Math.fround||(b=new Float32Array(1),e=>(b[0]=+e,b[0]));var b;class S{constructor(e){this.options=Object.assign(Object.create(x),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:i,maxZoom:o}=this.options;t&&console.time("total time");const s=`prepare ${e.length} points`;t&&console.time(s),this.points=e;const n=[];for(let t=0;t<e.length;t++){const i=e[t];if(!i.geometry)continue;const[o,s]=i.geometry.coordinates,r=_(P(o)),a=_(k(s));n.push(r,a,1/0,t,-1,1),this.options.reduce&&n.push(0);}let r=this.trees[o+1]=this._createTree(n);t&&console.timeEnd(s);for(let e=o;e>=i;e--){const i=+Date.now();r=this.trees[e]=this._createTree(this._cluster(r,e)),t&&console.log("z%d: %d clusters in %dms",e,r.numItems,+Date.now()-i);}return t&&console.timeEnd("total time"),this;}getClusters(e,t){let i=((e[0]+180)%360+360)%360-180;const o=Math.max(-90,Math.min(90,e[1]));let s=180===e[2]?180:((e[2]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)i=-180,s=180;else if(i>s){const e=this.getClusters([i,o,180,n],t),r=this.getClusters([-180,o,s,n],t);return e.concat(r);}const r=this.trees[this._limitZoom(t)],a=r.range(P(i),k(n),P(s),k(o)),l=r.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+5]>1?M(l,t,this.clusterProps):this.points[l[t+3]]);}return c;}getChildren(e){const t=this._getOriginId(e),i=this._getOriginZoom(e),o="No cluster with the specified id.",s=this.trees[i];if(!s)throw new Error(o);const n=s.data;if(t*this.stride>=n.length)throw new Error(o);const r=this.options.radius/(this.options.extent*Math.pow(2,i-1)),a=s.within(n[t*this.stride],n[t*this.stride+1],r),l=[];for(const t of a){const i=t*this.stride;n[i+4]===e&&l.push(n[i+5]>1?M(n,i,this.clusterProps):this.points[n[i+3]]);}if(0===l.length)throw new Error(o);return l;}getLeaves(e,t,i){const o=[];return this._appendLeaves(o,e,t=t||10,i=i||0,0),o;}getTile(e,t,i){const o=this.trees[this._limitZoom(e)],s=Math.pow(2,e),{extent:n,radius:r}=this.options,a=r/n,l=(i-a)/s,c=(i+1+a)/s,h={features:[]};return this._addTileFeatures(o.range((t-a)/s,l,(t+1+a)/s,c),o.data,t,i,s,h),0===t&&this._addTileFeatures(o.range(1-a/s,l,1,c),o.data,s,i,s,h),t===s-1&&this._addTileFeatures(o.range(0,l,a/s,c),o.data,-1,i,s,h),h.features.length?h:null;}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const i=this.getChildren(e);if(t++,1!==i.length)break;e=i[0].properties.cluster_id;}return t;}_appendLeaves(e,t,i,o,s){const n=this.getChildren(t);for(const t of n){const n=t.properties;if(n&&n.cluster?s+n.point_count<=o?s+=n.point_count:s=this._appendLeaves(e,n.cluster_id,i,o,s):s<o?s++:e.push(t),e.length===i)break;}return s;}_createTree(t){const i=new e.aM(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)i.add(t[e],t[e+1]);return i.finish(),i.data=t,i;}_addTileFeatures(e,t,i,o,s,n){for(const r of e){const e=r*this.stride,a=t[e+5]>1;let l,c,h;if(a)l=I(t,e,this.clusterProps),c=t[e],h=t[e+1];else{const i=this.points[t[e+3]];l=i.properties;const[o,s]=i.geometry.coordinates;c=P(o),h=k(s);}const u={type:1,geometry:[[Math.round(this.options.extent*(c*s-i)),Math.round(this.options.extent*(h*s-o))]],tags:l};let d;d=a||this.options.generateId?t[e+3]:this.points[t[e+3]].id,void 0!==d&&(u.id=d),n.features.push(u);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1));}_cluster(e,t){const{radius:i,extent:o,reduce:s,minPoints:n}=this.options,r=i/(o*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let i=0;i<a.length;i+=c){if(a[i+2]<=t)continue;a[i+2]=t;const o=a[i],h=a[i+1],u=e.within(a[i],a[i+1],r),d=a[i+5];let f=d;for(const e of u){const i=e*c;a[i+2]>t&&(f+=a[i+5]);}if(f>d&&f>=n){let e,n=o*d,r=h*d,g=-1;const p=(i/c<<5)+(t+1)+this.points.length;for(const o of u){const l=o*c;if(a[l+2]<=t)continue;a[l+2]=t;const h=a[l+5];n+=a[l]*h,r+=a[l+1]*h,a[l+4]=p,s&&(e||(e=this._map(a,i,!0),g=this.clusterProps.length,this.clusterProps.push(e)),s(e,this._map(a,l)));}a[i+4]=p,l.push(n/f,r/f,1/0,p,-1,f),s&&l.push(g);}else{for(let e=0;e<c;e++)l.push(a[i+e]);if(f>1)for(const e of u){const i=e*c;if(!(a[i+2]<=t)){a[i+2]=t;for(let e=0;e<c;e++)l.push(a[i+e]);}}}}return l;}_getOriginId(e){return e-this.points.length>>5;}_getOriginZoom(e){return(e-this.points.length)%32;}_map(e,t,i){if(e[t+5]>1){const o=this.clusterProps[e[t+6]];return i?Object.assign({},o):o;}const o=this.points[e[t+3]].properties,s=this.options.map(o);return i&&s===o?Object.assign({},s):s;}}function M(e,t,i){return{type:"Feature",id:e[t+3],properties:I(e,t,i),geometry:{type:"Point",coordinates:[(o=e[t],360*(o-.5)),D(e[t+1])]}};// removed by dead control flow
 var o; }function I(e,t,i){const o=e[t+5],s=o>=1e4?`${Math.round(o/1e3)}k`:o>=1e3?Math.round(o/100)/10+"k":o,n=e[t+6],r=-1===n?{}:Object.assign({},i[n]);return Object.assign(r,{cluster:!0,cluster_id:e[t+3],point_count:o,point_count_abbreviated:s});}function P(e){return e/360+.5;}function k(e){const t=Math.sin(e*Math.PI/180),i=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return i<0?0:i>1?1:i;}function D(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90;}function T(e,t,i,o){let s=o;const n=t+(i-t>>1);let r,a=i-t;const l=e[t],c=e[t+1],h=e[i],u=e[i+1];for(let o=t+3;o<i;o+=3){const t=C(e[o],e[o+1],l,c,h,u);if(t>s)r=o,s=t;else if(t===s){const e=Math.abs(o-n);e<a&&(r=o,a=e);}}s>o&&(r-t>3&&T(e,t,r,o),e[r+2]=s,i-r>3&&T(e,r,i,o));}function C(e,t,i,o,s,n){let r=s-i,a=n-o;if(0!==r||0!==a){const l=((e-i)*r+(t-o)*a)/(r*r+a*a);l>1?(i=s,o=n):l>0&&(i+=r*l,o+=a*l);}return r=e-i,a=t-o,r*r+a*a;}function L(e,t,i,o){const s={id:null==e?null:e,type:t,geometry:i,tags:o,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)O(s,i);else if("Polygon"===t)O(s,i[0]);else if("MultiLineString"===t)for(const e of i)O(s,e);else if("MultiPolygon"===t)for(const e of i)O(s,e[0]);return s;}function O(e,t){for(let i=0;i<t.length;i+=3)e.minX=Math.min(e.minX,t[i]),e.minY=Math.min(e.minY,t[i+1]),e.maxX=Math.max(e.maxX,t[i]),e.maxY=Math.max(e.maxY,t[i+1]);}function F(e,t,i,o){if(!t.geometry)return;const s=t.geometry.coordinates;if(s&&0===s.length)return;const n=t.geometry.type,r=Math.pow(i.tolerance/((1<<i.maxZoom)*i.extent),2);let a=[],l=t.id;if(i.promoteId?l=t.properties[i.promoteId]:i.generateId&&(l=o||0),"Point"===n)G(s,a);else if("MultiPoint"===n)for(const e of s)G(e,a);else if("LineString"===n)z(s,a,r,!1);else if("MultiLineString"===n){if(i.lineMetrics){for(const i of s)a=[],z(i,a,r,!1),e.push(L(l,"LineString",a,t.properties));return;}A(s,a,r,!1);}else if("Polygon"===n)A(s,a,r,!0);else{if("MultiPolygon"!==n){if("GeometryCollection"===n){for(const s of t.geometry.geometries)F(e,{id:l,geometry:s,properties:t.properties},i,o);return;}throw new Error("Input data is not a valid GeoJSON object.");}for(const e of s){const t=[];A(e,t,r,!0),a.push(t);}}e.push(L(l,n,a,t.properties));}function G(e,t){t.push(E(e[0]),Z(e[1]),0);}function z(e,t,i,o){let s,n,r=0;for(let i=0;i<e.length;i++){const a=E(e[i][0]),l=Z(e[i][1]);t.push(a,l,0),i>0&&(r+=o?(s*l-a*n)/2:Math.sqrt(Math.pow(a-s,2)+Math.pow(l-n,2))),s=a,n=l;}const a=t.length-3;t[2]=1,T(t,0,a,i),t[a+2]=1,t.size=Math.abs(r),t.start=0,t.end=t.size;}function A(e,t,i,o){for(let s=0;s<e.length;s++){const n=[];z(e[s],n,i,o),t.push(n);}}function E(e){return e/360+.5;}function Z(e){const t=Math.sin(e*Math.PI/180),i=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return i<0?0:i>1?1:i;}function j(e,t,i,o,s,n,r,a){if(o/=t,n>=(i/=t)&&r<o)return e;if(r<i||n>=o)return null;const l=[];for(const t of e){const e=t.geometry;let n=t.type;const r=0===s?t.minX:t.minY,c=0===s?t.maxX:t.maxY;if(r>=i&&c<o){l.push(t);continue;}if(c<i||r>=o)continue;let h=[];if("Point"===n||"MultiPoint"===n)W(e,h,i,o,s);else if("LineString"===n)N(e,h,i,o,s,!1,a.lineMetrics);else if("MultiLineString"===n)Y(e,h,i,o,s,!1);else if("Polygon"===n)Y(e,h,i,o,s,!0);else if("MultiPolygon"===n)for(const t of e){const e=[];Y(t,e,i,o,s,!0),e.length&&h.push(e);}if(h.length){if(a.lineMetrics&&"LineString"===n){for(const e of h)l.push(L(t.id,n,e,t.tags));continue;}"LineString"!==n&&"MultiLineString"!==n||(1===h.length?(n="LineString",h=h[0]):n="MultiLineString"),"Point"!==n&&"MultiPoint"!==n||(n=3===h.length?"Point":"MultiPoint"),l.push(L(t.id,n,h,t.tags));}}return l.length?l:null;}function W(e,t,i,o,s){for(let n=0;n<e.length;n+=3){const r=e[n+s];r>=i&&r<=o&&J(t,e[n],e[n+1],e[n+2]);}}function N(e,t,i,o,s,n,r){let a=R(e);const l=0===s?q:H;let c,h,u=e.start;for(let d=0;d<e.length-3;d+=3){const f=e[d],g=e[d+1],p=e[d+2],m=e[d+3],y=e[d+4],v=0===s?f:g,w=0===s?m:y;let x=!1;r&&(c=Math.sqrt(Math.pow(f-m,2)+Math.pow(g-y,2))),v<i?w>i&&(h=l(a,f,g,m,y,i),r&&(a.start=u+c*h)):v>o?w<o&&(h=l(a,f,g,m,y,o),r&&(a.start=u+c*h)):J(a,f,g,p),w<i&&v>=i&&(h=l(a,f,g,m,y,i),x=!0),w>o&&v<=o&&(h=l(a,f,g,m,y,o),x=!0),!n&&x&&(r&&(a.end=u+c*h),t.push(a),a=R(e)),r&&(u+=c);}let d=e.length-3;const f=e[d],g=e[d+1],p=0===s?f:g;p>=i&&p<=o&&J(a,f,g,e[d+2]),d=a.length-3,n&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&J(a,a[0],a[1],a[2]),a.length&&t.push(a);}function R(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t;}function Y(e,t,i,o,s,n){for(const r of e)N(r,t,i,o,s,n,!1);}function J(e,t,i,o){e.push(t,i,o);}function q(e,t,i,o,s,n){const r=(n-t)/(o-t);return J(e,n,i+(s-i)*r,1),r;}function H(e,t,i,o,s,n){const r=(n-i)/(s-i);return J(e,t+(o-t)*r,n,1),r;}function X(e,t){const i=[];for(let o=0;o<e.length;o++){const s=e[o],n=s.type;let r;if("Point"===n||"MultiPoint"===n||"LineString"===n)r=V(s.geometry,t);else if("MultiLineString"===n||"Polygon"===n){r=[];for(const e of s.geometry)r.push(V(e,t));}else if("MultiPolygon"===n){r=[];for(const e of s.geometry){const i=[];for(const o of e)i.push(V(o,t));r.push(i);}}i.push(L(s.id,n,r,s.tags));}return i;}function V(e,t){const i=[];i.size=e.size,void 0!==e.start&&(i.start=e.start,i.end=e.end);for(let o=0;o<e.length;o+=3)i.push(e[o]+t,e[o+1],e[o+2]);return i;}function B(e,t){if(e.transformed)return e;const i=1<<e.z,o=e.x,s=e.y;for(const n of e.features){const e=n.geometry,r=n.type;if(n.geometry=[],1===r)for(let r=0;r<e.length;r+=2)n.geometry.push($(e[r],e[r+1],t,i,o,s));else for(let r=0;r<e.length;r++){const a=[];for(let n=0;n<e[r].length;n+=2)a.push($(e[r][n],e[r][n+1],t,i,o,s));n.geometry.push(a);}}return e.transformed=!0,e;}function $(e,t,i,o,s,n){return[Math.round(i*(e*o-s)),Math.round(i*(t*o-n))];}function U(e,t,i,o,s){const n=t===s.maxZoom?0:s.tolerance/((1<<t)*s.extent),r={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:i,y:o,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)K(r,t,n,s);return r;}function K(e,t,i,o){const s=t.geometry,n=t.type,r=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===n||"MultiPoint"===n)for(let t=0;t<s.length;t+=3)r.push(s[t],s[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===n)Q(r,s,e,i,!1,!1);else if("MultiLineString"===n||"Polygon"===n)for(let t=0;t<s.length;t++)Q(r,s[t],e,i,"Polygon"===n,0===t);else if("MultiPolygon"===n)for(let t=0;t<s.length;t++){const o=s[t];for(let t=0;t<o.length;t++)Q(r,o[t],e,i,!0,0===t);}if(r.length){let i=t.tags||null;if("LineString"===n&&o.lineMetrics){i={};for(const e in t.tags)i[e]=t.tags[e];i.mapbox_clip_start=s.start/s.size,i.mapbox_clip_end=s.end/s.size;}const a={geometry:r,type:"Polygon"===n||"MultiPolygon"===n?3:"LineString"===n||"MultiLineString"===n?2:1,tags:i};null!==t.id&&(a.id=t.id),e.features.push(a);}}function Q(e,t,i,o,s,n){const r=o*o;if(o>0&&t.size<(s?r:o))return void(i.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===o||t[e+2]>r)&&(i.numSimplified++,a.push(t[e],t[e+1])),i.numPoints++;s&&function(e,t){let i=0;for(let t=0,o=e.length,s=o-2;t<o;s=t,t+=2)i+=(e[t]-e[s])*(e[t+1]+e[s+1]);if(i>0===t)for(let t=0,i=e.length;t<i/2;t+=2){const o=e[t],s=e[t+1];e[t]=e[i-2-t],e[t+1]=e[i-1-t],e[i-2-t]=o,e[i-1-t]=s;}}(a,n),e.push(a);}const ee={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class te{constructor(e,t){const i=(t=this.options=function(e,t){for(const i in t)e[i]=t[i];return e;}(Object.create(ee),t)).debug;if(i&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let o=function(e,t){const i=[];if("FeatureCollection"===e.type)for(let o=0;o<e.features.length;o++)F(i,e.features[o],t,o);else F(i,"Feature"===e.type?e:{geometry:e},t);return i;}(e,t);this.tiles={},this.tileCoords=[],i&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),o=function(e,t){const i=t.buffer/t.extent;let o=e;const s=j(e,1,-1-i,i,0,-1,2,t),n=j(e,1,1-i,2+i,0,-1,2,t);return(s||n)&&(o=j(e,1,-i,1+i,0,-1,2,t)||[],s&&(o=X(s,1).concat(o)),n&&(o=o.concat(X(n,-1)))),o;}(o,t),o.length&&this.splitTile(o,0,0,0),i&&(o.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,i,o,s,n,r){const a=[e,t,i,o],l=this.options,c=l.debug;for(;a.length;){o=a.pop(),i=a.pop(),t=a.pop(),e=a.pop();const h=1<<t,u=ie(t,i,o);let d=this.tiles[u];if(!d&&(c>1&&console.time("creation"),d=this.tiles[u]=U(e,t,i,o,l),this.tileCoords.push({z:t,x:i,y:o}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,i,o,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==s){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue;}else{if(t===l.maxZoom||t===s)continue;if(null!=s){const e=s-t;if(i!==n>>e||o!==r>>e)continue;}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const f=.5*l.buffer/l.extent,g=.5-f,p=.5+f,m=1+f;let y=null,v=null,w=null,x=null,_=j(e,h,i-f,i+p,0,d.minX,d.maxX,l),b=j(e,h,i+g,i+m,0,d.minX,d.maxX,l);e=null,_&&(y=j(_,h,o-f,o+p,1,d.minY,d.maxY,l),v=j(_,h,o+g,o+m,1,d.minY,d.maxY,l),_=null),b&&(w=j(b,h,o-f,o+p,1,d.minY,d.maxY,l),x=j(b,h,o+g,o+m,1,d.minY,d.maxY,l),b=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*i,2*o),a.push(v||[],t+1,2*i,2*o+1),a.push(w||[],t+1,2*i+1,2*o),a.push(x||[],t+1,2*i+1,2*o+1);}}getTile(e,t,i){e=+e,t=+t,i=+i;const o=this.options,{extent:s,debug:n}=o;if(e<0||e>24)return null;const r=1<<e,a=ie(e,t=t+r&r-1,i);if(this.tiles[a])return B(this.tiles[a],s);n>1&&console.log("drilling down to z%d-%d-%d",e,t,i);let l,c=e,h=t,u=i;for(;!l&&c>0;)c--,h>>=1,u>>=1,l=this.tiles[ie(c,h,u)];return l&&l.source?(n>1&&(console.log("found parent tile z%d-%d-%d",c,h,u),console.time("drilling down")),this.splitTile(l.source,c,h,u,e,t,i),n>1&&console.timeEnd("drilling down"),this.tiles[a]?B(this.tiles[a],s):null):null;}}function ie(e,t,i){return 32*((1<<e)*i+t)+e;}class oe extends n{constructor(e,t,i){let o=arguments.length>3&&arguments[3]!==undefined?arguments[3]:se;super(e,t,i),this._dataUpdateable=new Map(),this._createGeoJSONIndex=o;}loadVectorTile(t,i){return e._(this,void 0,void 0,function*(){const i=t.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const o=this._geoJSONIndex.getTile(i.z,i.x,i.y);if(!o)return null;const s=new d(o.features,{version:2,extent:e.a3});let n=function(t){const i=new e.cP();return function(e,t){for(const i in e.layers)t.writeMessage(3,f,e.layers[i]);}(t,i),i.finish();}(s);return 0===n.byteOffset&&n.byteLength===n.buffer.byteLength||(n=new Uint8Array(n)),{vectorTile:s,rawData:n.buffer};});}loadData(t){return e._(this,void 0,void 0,function*(){var i;null===(i=this._pendingRequest)||void 0===i||i.abort();const o=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.cQ(t.request);this._pendingRequest=new AbortController();try{(!this._pendingData||t.request||t.data||t.dataDiff)&&(this._pendingData=this.loadAndProcessGeoJSON(t,this._pendingRequest));const e=yield this._pendingData;this._geoJSONIndex=this._createGeoJSONIndex(e,t),this.loaded={};const i={data:e};if(o){const e=o.finish();e&&(i.resourceTiming={},i.resourceTiming[t.source]=JSON.parse(JSON.stringify(e)));}return i;}catch(t){if(delete this._pendingRequest,e.cB(t))return{abandoned:!0};throw t;}});}getData(){return e._(this,void 0,void 0,function*(){return this._pendingData;});}reloadTile(e){const t=this.loaded;return t&&t[e.uid]?super.reloadTile(e):this.loadTile(e);}loadAndProcessGeoJSON(t,i){return e._(this,void 0,void 0,function*(){let o=yield this.loadGeoJSON(t,i);if(delete this._pendingRequest,"object"!=typeof o)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(h(o,!0),t.filter){const i=e.cW(t.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===i.result)throw new Error(i.value.map(e=>`${e.key}: ${e.message}`).join(", "));const s=o.features.filter(e=>i.value.evaluate({zoom:0},e));o={type:"FeatureCollection",features:s};}return o;});}loadGeoJSON(t,i){return e._(this,void 0,void 0,function*(){const{promoteId:o}=t;if(t.request){const s=yield e.j(t.request,i);return this._dataUpdateable=e.cY(s.data,o)?e.cX(s.data,o):void 0,s.data;}if("string"==typeof t.data)try{const i=JSON.parse(t.data);return this._dataUpdateable=e.cY(i,o)?e.cX(i,o):void 0,i;}catch(e){throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);}if(!t.dataDiff)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${t.source}`);return e.cZ(this._dataUpdateable,t.dataDiff,o),{type:"FeatureCollection",features:Array.from(this._dataUpdateable.values())};});}removeSource(t){return e._(this,void 0,void 0,function*(){this._pendingRequest&&this._pendingRequest.abort();});}getClusterExpansionZoom(e){return this._geoJSONIndex.getClusterExpansionZoom(e.clusterId);}getClusterChildren(e){return this._geoJSONIndex.getChildren(e.clusterId);}getClusterLeaves(e){return this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset);}}function se(t,i){return i.cluster?new S(function(_ref77){let{superclusterOptions:t,clusterProperties:i}=_ref77;if(!i||!t)return t;const o={},s={},n={accumulated:null,zoom:0},r={properties:null},a=Object.keys(i);for(const t of a){const[n,r]=i[t],a=e.cW(r),l=e.cW("string"==typeof n?[n,["accumulated"],["get",t]]:n);o[t]=a.value,s[t]=l.value;}return t.map=e=>{r.properties=e;const t={};for(const e of a)t[e]=o[e].evaluate(n,r);return t;},t.reduce=(e,t)=>{r.properties=t;for(const t of a)n.accumulated=e[t],e[t]=s[t].evaluate(n,r);},t;}(i)).load(t.features):function(e,t){return new te(e,t);}(t,i.geojsonVtOptions);}class ne{constructor(t){this.self=t,this.actor=new e.K(t),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.globalStates=new Map(),this.self.registerWorkerSource=(e,t)=>{if(this.externalWorkerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.externalWorkerSourceTypes[e]=t;},this.self.addProtocol=e.cD,this.self.removeProtocol=e.cE,this.self.registerRTLTextPlugin=t=>{e.c_.setMethods(t);},this.actor.registerMessageHandler("LDT",(e,t)=>this._getDEMWorkerSource(e,t.source).loadTile(t)),this.actor.registerMessageHandler("RDT",(t,i)=>e._(this,void 0,void 0,function*(){this._getDEMWorkerSource(t,i.source).removeTile(i);})),this.actor.registerMessageHandler("GCEZ",(t,i)=>e._(this,void 0,void 0,function*(){return this._getWorkerSource(t,i.type,i.source).getClusterExpansionZoom(i);})),this.actor.registerMessageHandler("GCC",(t,i)=>e._(this,void 0,void 0,function*(){return this._getWorkerSource(t,i.type,i.source).getClusterChildren(i);})),this.actor.registerMessageHandler("GCL",(t,i)=>e._(this,void 0,void 0,function*(){return this._getWorkerSource(t,i.type,i.source).getClusterLeaves(i);})),this.actor.registerMessageHandler("LD",(e,t)=>this._getWorkerSource(e,t.type,t.source).loadData(t)),this.actor.registerMessageHandler("GD",(e,t)=>this._getWorkerSource(e,t.type,t.source).getData()),this.actor.registerMessageHandler("LT",(e,t)=>this._getWorkerSource(e,t.type,t.source).loadTile(t)),this.actor.registerMessageHandler("RT",(e,t)=>this._getWorkerSource(e,t.type,t.source).reloadTile(t)),this.actor.registerMessageHandler("AT",(e,t)=>this._getWorkerSource(e,t.type,t.source).abortTile(t)),this.actor.registerMessageHandler("RMT",(e,t)=>this._getWorkerSource(e,t.type,t.source).removeTile(t)),this.actor.registerMessageHandler("RS",(t,i)=>e._(this,void 0,void 0,function*(){if(!this.workerSources[t]||!this.workerSources[t][i.type]||!this.workerSources[t][i.type][i.source])return;const e=this.workerSources[t][i.type][i.source];delete this.workerSources[t][i.type][i.source],void 0!==e.removeSource&&e.removeSource(i);})),this.actor.registerMessageHandler("RM",t=>e._(this,void 0,void 0,function*(){delete this.layerIndexes[t],delete this.availableImages[t],delete this.workerSources[t],delete this.demWorkerSources[t],this.globalStates.delete(t);})),this.actor.registerMessageHandler("SR",(t,i)=>e._(this,void 0,void 0,function*(){this.referrer=i;})),this.actor.registerMessageHandler("SRPS",(e,t)=>this._syncRTLPluginState(e,t)),this.actor.registerMessageHandler("IS",(t,i)=>e._(this,void 0,void 0,function*(){this.self.importScripts(i);})),this.actor.registerMessageHandler("SI",(e,t)=>this._setImages(e,t)),this.actor.registerMessageHandler("UL",(t,i)=>e._(this,void 0,void 0,function*(){this._getLayerIndex(t).update(i.layers,i.removedIds,this._getGlobalState(t));})),this.actor.registerMessageHandler("UGS",(t,i)=>e._(this,void 0,void 0,function*(){const e=this._getGlobalState(t);for(const t in i)e[t]=i[t];})),this.actor.registerMessageHandler("SL",(t,i)=>e._(this,void 0,void 0,function*(){this._getLayerIndex(t).replace(i,this._getGlobalState(t));}));}_getGlobalState(e){let t=this.globalStates.get(e);return t||(t={},this.globalStates.set(e,t)),t;}_setImages(t,i){return e._(this,void 0,void 0,function*(){this.availableImages[t]=i;for(const e in this.workerSources[t]){const o=this.workerSources[t][e];for(const e in o)o[e].availableImages=i;}});}_syncRTLPluginState(t,i){return e._(this,void 0,void 0,function*(){return yield e.c_.syncState(i,this.self.importScripts);});}_getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t;}_getLayerIndex(e){let i=this.layerIndexes[e];return i||(i=this.layerIndexes[e]=new t()),i;}_getWorkerSource(e,t,i){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),!this.workerSources[e][t][i]){const o={sendAsync:(t,i)=>(t.targetMapId=e,this.actor.sendAsync(t,i))};switch(t){case"vector":this.workerSources[e][t][i]=new n(o,this._getLayerIndex(e),this._getAvailableImages(e));break;case"geojson":this.workerSources[e][t][i]=new oe(o,this._getLayerIndex(e),this._getAvailableImages(e));break;default:this.workerSources[e][t][i]=new this.externalWorkerSourceTypes[t](o,this._getLayerIndex(e),this._getAvailableImages(e));}}return this.workerSources[e][t][i];}_getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new r()),this.demWorkerSources[e][t];}}return e.i(self)&&(self.worker=new ne(self)),ne;});define("index",["exports","./shared"],function(e,t){"use strict";var i="5.11.0";function a(){var e=new t.A(4);return t.A!=Float32Array&&(e[1]=0,e[2]=0),e[0]=1,e[3]=1,e;}let r,o;const s={frame(e,i,a){const r=requestAnimationFrame(e=>{o(),i(e);}),{unsubscribe:o}=t.s(e.signal,"abort",()=>{o(),cancelAnimationFrame(r),a(t.c());},!1);},frameAsync(e){return new Promise((t,i)=>{this.frame(e,t,i);});},getImageData(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;return this.getImageCanvasContext(e).getImageData(-t,-t,e.width+2*t,e.height+2*t);},getImageCanvasContext(e){const t=window.document.createElement("canvas"),i=t.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return t.width=e.width,t.height=e.height,i.drawImage(e,0,0,e.width,e.height),i;},resolveURL:e=>(r||(r=document.createElement("a")),r.href=e,r.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return!!matchMedia&&(null==o&&(o=matchMedia("(prefers-reduced-motion: reduce)")),o.matches);}},n=new class{constructor(){this._realTime="undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),this._frozenAt=null;}getCurrentTime(){return null!==this._frozenAt?this._frozenAt:this._realTime();}setNow(e){this._frozenAt=e;}restoreNow(){this._frozenAt=null;}isFrozen(){return null!==this._frozenAt;}}();function l(){return n.getCurrentTime();}class c{static testProp(e){if(!c.docStyle)return e[0];for(let t=0;t<e.length;t++)if(e[t]in c.docStyle)return e[t];return e[0];}static create(e,t,i){const a=window.document.createElement(e);return void 0!==t&&(a.className=t),i&&i.appendChild(a),a;}static createNS(e,t){return window.document.createElementNS(e,t);}static disableDrag(){c.docStyle&&c.selectProp&&(c.userSelect=c.docStyle[c.selectProp],c.docStyle[c.selectProp]="none");}static enableDrag(){c.docStyle&&c.selectProp&&(c.docStyle[c.selectProp]=c.userSelect);}static setTransform(e,t){e.style[c.transformProp]=t;}static addEventListener(e,t,i){let a=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};e.addEventListener(t,i,"passive"in a?a:a.capture);}static removeEventListener(e,t,i){let a=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};e.removeEventListener(t,i,"passive"in a?a:a.capture);}static suppressClickInternal(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",c.suppressClickInternal,!0);}static suppressClick(){window.addEventListener("click",c.suppressClickInternal,!0),window.setTimeout(()=>{window.removeEventListener("click",c.suppressClickInternal,!0);},0);}static getScale(e){const t=e.getBoundingClientRect();return{x:t.width/e.offsetWidth||1,y:t.height/e.offsetHeight||1,boundingClientRect:t};}static getPoint(e,i,a){const r=i.boundingClientRect;return new t.P((a.clientX-r.left)/i.x-e.clientLeft,(a.clientY-r.top)/i.y-e.clientTop);}static mousePos(e,t){const i=c.getScale(e);return c.getPoint(e,i,t);}static touchPos(e,t){const i=[],a=c.getScale(e);for(let r=0;r<t.length;r++)i.push(c.getPoint(e,a,t[r]));return i;}static mouseButton(e){return e.button;}static remove(e){e.parentNode&&e.parentNode.removeChild(e);}static sanitize(e){const t=new DOMParser().parseFromString(e,"text/html").body||document.createElement("body"),i=t.querySelectorAll("script");for(const e of i)e.remove();return c.clean(t),t.innerHTML;}static isPossiblyDangerous(e,t){const i=t.replace(/\s+/g,"").toLowerCase();return!(!["src","href","xlink:href"].includes(e)||!i.includes("javascript:")&&!i.includes("data:"))||!!e.startsWith("on")||void 0;}static clean(e){const t=e.children;for(const e of t)c.removeAttributes(e),c.clean(e);}static removeAttributes(e){for(const{name:t,value:i}of e.attributes)c.isPossiblyDangerous(t,i)&&e.removeAttribute(t);}}c.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,c.selectProp=c.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),c.transformProp=c.testProp(["transform","WebkitTransform"]);const h={supported:!1,testSupport:function(e){!_&&d&&(p?m(e):u=e);}};let u,d,_=!1,p=!1;function m(e){const t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);try{if(e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,d),e.isContextLost())return;h.supported=!0;}catch(e){}e.deleteTexture(t),_=!0;}var f;"undefined"!=typeof document&&(d=document.createElement("img"),d.onload=()=>{u&&m(u),u=null,p=!0;},d.onerror=()=>{_=!0,u=null;},d.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(e){let i,a,r,o;e.resetRequestQueue=()=>{i=[],a=0,r=0,o={};},e.addThrottleControl=e=>{const t=r++;return o[t]=e,t;},e.removeThrottleControl=e=>{delete o[e],n();},e.getImage=function(e,a){let r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:!0;return new Promise((o,s)=>{h.supported&&(e.headers||(e.headers={}),e.headers.accept="image/webp,*/*"),t.e(e,{type:"image"}),i.push({abortController:a,requestParameters:e,supportImageRefresh:r,state:"queued",onError:e=>{s(e);},onSuccess:e=>{o(e);}}),n();});};const s=e=>t._(this,void 0,void 0,function*(){e.state="running";const{requestParameters:i,supportImageRefresh:r,onError:o,onSuccess:s,abortController:c}=e,h=!1===r&&!t.i(self)&&!t.g(i.url)&&(!i.headers||Object.keys(i.headers).reduce((e,t)=>e&&"accept"===t,!0));a++;const u=h?l(i,c):t.m(i,c);try{const i=yield u;delete e.abortController,e.state="completed",i.data instanceof HTMLImageElement||t.b(i.data)?s(i):i.data&&s({data:yield(d=i.data,"function"==typeof createImageBitmap?t.f(d):t.h(d)),cacheControl:i.cacheControl,expires:i.expires});}catch(t){delete e.abortController,o(t);}finally{a--,n();}var d;}),n=()=>{const e=(()=>{for(const e of Object.keys(o))if(o[e]())return!0;return!1;})()?t.a.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:t.a.MAX_PARALLEL_IMAGE_REQUESTS;for(let t=a;t<e&&i.length>0;t++){const e=i.shift();e.abortController.signal.aborted?t--:s(e);}},l=(e,i)=>new Promise((a,r)=>{const o=new Image(),s=e.url,n=e.credentials;n&&"include"===n?o.crossOrigin="use-credentials":(n&&"same-origin"===n||!t.d(s))&&(o.crossOrigin="anonymous"),i.signal.addEventListener("abort",()=>{o.src="",r(t.c());}),o.fetchPriority="high",o.onload=()=>{o.onerror=o.onload=null,a({data:o});},o.onerror=()=>{o.onerror=o.onload=null,i.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));},o.src=s;});}(f||(f={})),f.resetRequestQueue();class g{constructor(e){this._transformRequestFn=null!=e?e:null;}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e};}setTransformRequest(e){this._transformRequestFn=e;}}function v(e){const t=[];if("string"==typeof e)t.push({id:"default",url:e});else if(e&&e.length>0){const i=[];for(const{id:a,url:r}of e){const e=`${a}${r}`;-1===i.indexOf(e)&&(i.push(e),t.push({id:a,url:r}));}}return t;}function x(e,t,i){try{const a=new URL(e);return a.pathname+=`${t}${i}`,a.toString();}catch(t){throw new Error(`Invalid sprite URL "${e}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`);}}function b(e){const{userImage:t}=e;return!!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0);}class y extends t.E{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new t.R({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded;}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,promiseResolve:t}of this.requestors)t(this._getImagesForIds(e));this.requestors=[];}}getImage(e){const i=this.images[e];if(i&&!i.data&&i.spriteData){const e=i.spriteData;i.data=new t.R({width:e.width,height:e.height},e.context.getImageData(e.x,e.y,e.width,e.height).data),i.spriteData=null;}return i;}addImage(e,t){if(this.images[e])throw new Error(`Image id ${e} already exist, use updateImage instead`);this._validate(e,t)&&(this.images[e]=t);}_validate(e,i){let a=!0;const r=i.data||i.spriteData;return this._validateStretch(i.stretchX,r&&r.width)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "stretchX" value`))),a=!1),this._validateStretch(i.stretchY,r&&r.height)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "stretchY" value`))),a=!1),this._validateContent(i.content,i)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "content" value`))),a=!1),a;}_validateStretch(e,t){if(!e)return!0;let i=0;for(const a of e){if(a[0]<i||a[1]<a[0]||t<a[1])return!1;i=a[1];}return!0;}_validateContent(e,t){if(!e)return!0;if(4!==e.length)return!1;const i=t.spriteData,a=i&&i.width||t.data.width,r=i&&i.height||t.data.height;return!(e[0]<0||a<e[0]||e[1]<0||r<e[1]||e[2]<0||a<e[2]||e[3]<0||r<e[3]||e[2]<e[0]||e[3]<e[1]);}updateImage(e,t){let i=arguments.length>2&&arguments[2]!==undefined?arguments[2]:!0;const a=this.getImage(e);if(i&&(a.data.width!==t.data.width||a.data.height!==t.data.height))throw new Error(`size mismatch between old image (${a.data.width}x${a.data.height}) and new image (${t.data.width}x${t.data.height}).`);t.version=a.version+1,this.images[e]=t,this.updatedImages[e]=!0;}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove();}listImages(){return Object.keys(this.images);}getImages(e){return new Promise((t,i)=>{let a=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(a=!1);this.isLoaded()||a?t(this._getImagesForIds(e)):this.requestors.push({ids:e,promiseResolve:t});});}_getImagesForIds(e){const i={};for(const a of e){let e=this.getImage(a);e||(this.fire(new t.l("styleimagemissing",{id:a})),e=this.getImage(a)),e?i[a]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,textFitWidth:e.textFitWidth,textFitHeight:e.textFitHeight,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:t.w(`Image "${a}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}return i;}getPixelSize(){const{width:e,height:t}=this.atlasImage;return{width:e,height:t};}getPattern(e){const i=this.patterns[e],a=this.getImage(e);if(!a)return null;if(i&&i.position.version===a.version)return i.position;if(i)i.position.version=a.version;else{const i={w:a.data.width+2,h:a.data.height+2,x:0,y:0},r=new t.I(i,a);this.patterns[e]={bin:i,position:r};}return this._updatePatternAtlas(),this.patterns[e].position;}bind(e){const i=e.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new t.T(e,this.atlasImage,i.RGBA),this.atlasTexture.bind(i.LINEAR,i.CLAMP_TO_EDGE);}_updatePatternAtlas(){const e=[];for(const t in this.patterns)e.push(this.patterns[t].bin);const{w:i,h:a}=t.p(e),r=this.atlasImage;r.resize({width:i||1,height:a||1});for(const e in this.patterns){const{bin:i}=this.patterns[e],a=i.x+1,o=i.y+1,s=this.getImage(e).data,n=s.width,l=s.height;t.R.copy(s,r,{x:0,y:0},{x:a,y:o},{width:n,height:l}),t.R.copy(s,r,{x:0,y:l-1},{x:a,y:o-1},{width:n,height:1}),t.R.copy(s,r,{x:0,y:0},{x:a,y:o+l},{width:n,height:1}),t.R.copy(s,r,{x:n-1,y:0},{x:a-1,y:o},{width:1,height:l}),t.R.copy(s,r,{x:0,y:0},{x:a+n,y:o},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(e){for(const i of e){if(this.callbackDispatchedThisFrame[i])continue;this.callbackDispatchedThisFrame[i]=!0;const e=this.getImage(i);e||t.w(`Image with ID: "${i}" was not found`),b(e)&&this.updateImage(i,e);}}}const w=1e20;function T(e,t,i,a,r,o,s,n,l){for(let c=t;c<t+a;c++)P(e,i*o+c,o,r,s,n,l);for(let c=i;c<i+r;c++)P(e,c*o+t,1,a,s,n,l);}function P(e,t,i,a,r,o,s){o[0]=0,s[0]=-w,s[1]=w,r[0]=e[t];for(let n=1,l=0,c=0;n<a;n++){r[n]=e[t+n*i];const a=n*n;do{const e=o[l];c=(r[n]-r[e]+a-e*e)/(n-e)/2;}while(c<=s[l]&&--l>-1);l++,o[l]=n,s[l]=c,s[l+1]=w;}for(let n=0,l=0;n<a;n++){for(;s[l+1]<n;)l++;const a=o[l],c=n-a;e[t+n*i]=r[a]+c*c;}}const M=t.v.layout_symbol["text-font"].default.join(",");class C{constructor(e,t,i){this.requestManager=e,this.localIdeographFontFamily=t,this.entries={},this.lang=i;}setURL(e){this.url=e;}getGlyphs(e){return t._(this,void 0,void 0,function*(){const t=[];for(const i in e)for(const a of e[i])t.push(this._getAndCacheGlyphsPromise(i,a));const i=yield Promise.all(t),a={};for(const{stack:e,id:t,glyph:r}of i)a[e]||(a[e]={}),a[e][t]=r&&{id:r.id,bitmap:r.bitmap.clone(),metrics:r.metrics};return a;});}_getAndCacheGlyphsPromise(e,i){return t._(this,void 0,void 0,function*(){let t=this.entries[e];t||(t=this.entries[e]={glyphs:{},requests:{},ranges:{}});let a=t.glyphs[i];return void 0!==a?{stack:e,id:i,glyph:a}:!this.url||this._charUsesLocalIdeographFontFamily(i)?(a=t.glyphs[i]=this._drawGlyph(t,e,i),{stack:e,id:i,glyph:a}):yield this._downloadAndCacheRangePromise(e,i);});}_downloadAndCacheRangePromise(e,i){return t._(this,void 0,void 0,function*(){const t=Math.floor(i/256);if(256*t>65535)throw new Error("glyphs > 65535 not supported");const a=this.entries[e];if(a.ranges[t])return{stack:e,id:i,glyph:null};if(!a.requests[t]){const i=C.loadGlyphRange(e,t,this.url,this.requestManager);a.requests[t]=i;}try{const r=yield a.requests[t];for(const e in r)a.glyphs[+e]=r[+e];return a.ranges[t]=!0,{stack:e,id:i,glyph:r[i]||null};}catch(r){const o=a.glyphs[i]=this._drawGlyph(a,e,i);return this._warnOnMissingGlyphRange(o,t,i,r),{stack:e,id:i,glyph:o};}});}_warnOnMissingGlyphRange(e,i,a,r){const o=256*i,s=o+255,n=a.toString(16).padStart(4,"0").toUpperCase();t.w(`Unable to load glyph range ${i}, ${o}-${s}. Rendering codepoint U+${n} locally instead. ${r}`);}_charUsesLocalIdeographFontFamily(e){return!!this.localIdeographFontFamily&&(/\p{Ideo}|\p{sc=Hang}|\p{sc=Hira}|\p{sc=Kana}/u.test(String.fromCodePoint(e))||t.u["CJK Unified Ideographs"](e)||t.u["Hangul Syllables"](e)||t.u.Hiragana(e)||t.u.Katakana(e)||t.u["CJK Symbols and Punctuation"](e)||t.u["Halfwidth and Fullwidth Forms"](e));}_drawGlyph(e,i,a){const r=i===M&&""!==this.localIdeographFontFamily&&this._charUsesLocalIdeographFontFamily(a),o=r?"ideographTinySDF":"tinySDF";e[o]||(e[o]=this._createTinySDF(r?this.localIdeographFontFamily:i));const s=e[o].draw(String.fromCharCode(a));return{id:a,bitmap:new t.q({width:s.width||60,height:s.height||60},s.data),metrics:{width:s.glyphWidth/2||24,height:s.glyphHeight/2||24,left:s.glyphLeft/2+.5||0,top:s.glyphTop/2-27.5||-8,advance:s.glyphAdvance/2||24,isDoubleResolution:!0}};}_createTinySDF(e){const t=e?e.split(","):[];t.push("sans-serif");const i=t.map(e=>/[-\w]+/.test(e)?e:`'${CSS.escape(e)}'`).join(",");return new C.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:i,fontWeight:this._fontWeight(t[0]),fontStyle:this._fontStyle(t[0]),lang:this.lang});}_fontStyle(e){return /italic/i.test(e)?"italic":/oblique/i.test(e)?"oblique":"normal";}_fontWeight(e){const t={thin:100,hairline:100,"extra light":200,"ultra light":200,light:300,normal:400,regular:400,medium:500,semibold:600,demibold:600,bold:700,"extra bold":800,"ultra bold":800,black:900,heavy:900,"extra black":950,"ultra black":950};let i;for(const[a,r]of Object.entries(t))new RegExp(`\\b${a}\\b`,"i").test(e)&&(i=`${r}`);return i;}}C.loadGlyphRange=function(e,i,a,r){return t._(this,void 0,void 0,function*(){const o=256*i,s=o+255,n=r.transformRequest(a.replace("{fontstack}",e).replace("{range}",`${o}-${s}`),"Glyphs"),l=yield t.n(n,new AbortController());if(!l||!l.data)throw new Error(`Could not load glyph range. range: ${i}, ${o}-${s}`);const c={};for(const e of t.o(l.data))c[e.id]=e;return c;});},C.TinySDF=class{constructor(){let{fontSize:e=24,buffer:t=3,radius:i=8,cutoff:a=.25,fontFamily:r="sans-serif",fontWeight:o="normal",fontStyle:s="normal",lang:n=null}=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this.buffer=t,this.cutoff=a,this.radius=i,this.lang=n;const l=this.size=e+4*t,c=this._createCanvas(l),h=this.ctx=c.getContext("2d",{willReadFrequently:!0});h.font=`${s} ${o} ${e}px ${r}`,h.textBaseline="alphabetic",h.textAlign="left",h.fillStyle="black",this.gridOuter=new Float64Array(l*l),this.gridInner=new Float64Array(l*l),this.f=new Float64Array(l),this.z=new Float64Array(l+1),this.v=new Uint16Array(l);}_createCanvas(e){const t=document.createElement("canvas");return t.width=t.height=e,t;}draw(e){const{width:t,actualBoundingBoxAscent:i,actualBoundingBoxDescent:a,actualBoundingBoxLeft:r,actualBoundingBoxRight:o}=this.ctx.measureText(e),s=Math.ceil(i),n=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(o-r))),l=Math.min(this.size-this.buffer,s+Math.ceil(a)),c=n+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),d=new Uint8ClampedArray(u),_={data:d,width:c,height:h,glyphWidth:n,glyphHeight:l,glyphTop:s,glyphLeft:0,glyphAdvance:t};if(0===n||0===l)return _;const{ctx:p,buffer:m,gridInner:f,gridOuter:g}=this;this.lang&&(p.lang=this.lang),p.clearRect(m,m,n,l),p.fillText(e,m,m+s);const v=p.getImageData(m,m,n,l);g.fill(w,0,u),f.fill(0,0,u);for(let e=0;e<l;e++)for(let t=0;t<n;t++){const i=v.data[4*(e*n+t)+3]/255;if(0===i)continue;const a=(e+m)*c+t+m;if(1===i)g[a]=0,f[a]=w;else{const e=.5-i;g[a]=e>0?e*e:0,f[a]=e<0?e*e:0;}}T(g,0,0,c,h,c,this.f,this.v,this.z),T(f,m,m,n,l,c,this.f,this.v,this.z);for(let e=0;e<u;e++){const t=Math.sqrt(g[e])-Math.sqrt(f[e]);d[e]=Math.round(255-255*(t/this.radius+this.cutoff));}return _;}};class I{constructor(){this.specification=t.t.light.position;}possiblyEvaluate(e,i){return t.C(e.expression.evaluate(i));}interpolate(e,i,a){return{x:t.F.number(e.x,i.x,a),y:t.F.number(e.y,i.y,a),z:t.F.number(e.z,i.z,a)};}}let E;class S extends t.E{constructor(e){super(),E=E||new t.r({anchor:new t.D(t.t.light.anchor),position:new I(),color:new t.D(t.t.light.color),intensity:new t.D(t.t.light.intensity)}),this._transitionable=new t.x(E,void 0),this.setLight(e),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize();}setLight(e){let i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(!this._validate(t.y,e,i))for(const t in e){const i=e[t];t.endsWith("-transition")?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition();}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i,a){return(!a||!1!==a.validate)&&t.z(this,e.call(t.B,{value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.t}));}}const R=new t.r({"sky-color":new t.D(t.t.sky["sky-color"]),"horizon-color":new t.D(t.t.sky["horizon-color"]),"fog-color":new t.D(t.t.sky["fog-color"]),"fog-ground-blend":new t.D(t.t.sky["fog-ground-blend"]),"horizon-fog-blend":new t.D(t.t.sky["horizon-fog-blend"]),"sky-horizon-blend":new t.D(t.t.sky["sky-horizon-blend"]),"atmosphere-blend":new t.D(t.t.sky["atmosphere-blend"])});class D extends t.E{constructor(e){super(),this._transitionable=new t.x(R,void 0),this.setSky(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new t.G(0));}setSky(e){let i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(!this._validate(t.H,e,i)){e||(e={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const t in e){const i=e[t];t.endsWith("-transition")?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i);}}}getSky(){return this._transitionable.serialize();}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition();}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i){let a=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};return!1!==(null==a?void 0:a.validate)&&t.z(this,e.call(t.B,t.e({value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.t})));}calculateFogBlendOpacity(e){return e<60?0:e<70?(e-60)/10:1;}}class z{constructor(e,t){this.width=e,this.height=t,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(e,t){const i=e.join(",")+String(t);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(e,t)),this.dashEntry[i];}getDashRanges(e,t,i){const a=[];let r=e.length%2==1?-e[e.length-1]*i:0,o=e[0]*i,s=!0;a.push({left:r,right:o,isDash:s,zeroLength:0===e[0]});let n=e[0];for(let t=1;t<e.length;t++){s=!s;const l=e[t];r=n*i,n+=l,o=n*i,a.push({left:r,right:o,isDash:s,zeroLength:0===l});}return a;}addRoundDash(e,t,i){const a=t/2;for(let t=-i;t<=i;t++){const r=this.width*(this.nextRow+i+t);let o=0,s=e[o];for(let n=0;n<this.width;n++){n/s.right>1&&(s=e[++o]);const l=Math.abs(n-s.left),c=Math.abs(n-s.right),h=Math.min(l,c);let u;const d=t/i*(a+1);if(s.isDash){const e=a-Math.abs(d);u=Math.sqrt(h*h+e*e);}else u=a-Math.sqrt(h*h+d*d);this.data[r+n]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(e){for(let t=e.length-1;t>=0;--t){const i=e[t],a=e[t+1];i.zeroLength?e.splice(t,1):a&&a.isDash===i.isDash&&(a.left=i.left,e.splice(t,1));}const t=e[0],i=e[e.length-1];t.isDash===i.isDash&&(t.left=i.left-this.width,i.right=t.right+this.width);const a=this.width*this.nextRow;let r=0,o=e[r];for(let t=0;t<this.width;t++){t/o.right>1&&(o=e[++r]);const i=Math.abs(t-o.left),s=Math.abs(t-o.right),n=Math.min(i,s);this.data[a+t]=Math.max(0,Math.min(255,(o.isDash?n:-n)+128));}}addDash(e,i){const a=i?7:0,r=2*a+1;if(this.nextRow+r>this.height)return t.w("LineAtlas out of space"),null;let o=0;for(let t=0;t<e.length;t++)o+=e[t];if(0!==o){const t=this.width/o,r=this.getDashRanges(e,this.width,t);i?this.addRoundDash(r,t,a):this.addRegularDash(r);}const s={y:this.nextRow+a,height:2*a,width:o};return this.nextRow+=r,this.dirty=!0,s;}bind(e){const t=e.gl;this.texture?(t.bindTexture(t.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,t.texSubImage2D(t.TEXTURE_2D,0,0,0,this.width,this.height,t.ALPHA,t.UNSIGNED_BYTE,this.data))):(this.texture=t.createTexture(),t.bindTexture(t.TEXTURE_2D,this.texture),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texImage2D(t.TEXTURE_2D,0,t.ALPHA,this.width,this.height,0,t.ALPHA,t.UNSIGNED_BYTE,this.data));}}const A="maplibre_preloaded_worker_pool";class L{constructor(){this.active={};}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<L.workerCount;)this.workers.push(new Worker(t.a.WORKER_URL));return this.active[e]=!0,this.workers.slice();}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach(e=>{e.terminate();}),this.workers=null);}isPreloaded(){return!!this.active[A];}numActive(){return Object.keys(this.active).length;}}const k=Math.floor(s.hardwareConcurrency/2);let F,B;function j(){return F||(F=new L()),F;}L.workerCount=t.J(globalThis)?Math.max(Math.min(k,3),1):1;class O{constructor(e,i){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=i;const a=this.workerPool.acquire(i);for(let e=0;e<a.length;e++){const r=new t.K(a[e],i);r.name=`Worker ${e}`,this.actors.push(r);}if(!this.actors.length)throw new Error("No actors found");}broadcast(e,t){const i=[];for(const a of this.actors)i.push(a.sendAsync({type:e,data:t}));return Promise.all(i);}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor];}remove(){let e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:!0;this.actors.forEach(e=>{e.remove();}),this.actors=[],e&&this.workerPool.release(this.id);}registerMessageHandler(e,t){for(const i of this.actors)i.registerMessageHandler(e,t);}}function N(){return B||(B=new O(j(),t.L),B.registerMessageHandler("GR",(e,i,a)=>t.m(i,a))),B;}function U(e,i){const a=t.M();return t.N(a,a,[1,1,0]),t.O(a,a,[.5*e.width,.5*e.height,1]),e.calculatePosMatrix?t.Q(a,a,e.calculatePosMatrix(i.toUnwrapped())):a;}function Z(e,t,i,a,r,o,s){var n;const l=function(e,t,i){if(e)for(const a of e){const e=t[a];if(e&&e.source===i&&"fill-extrusion"===e.type)return!0;}else for(const e in t){const a=t[e];if(a.source===i&&"fill-extrusion"===a.type)return!0;}return!1;}(null!==(n=null==r?void 0:r.layers)&&void 0!==n?n:null,t,e.id),c=o.maxPitchScaleFactor(),h=e.tilesIn(a,c,l);h.sort(G);const u=[];for(const a of h)u.push({wrappedTileID:a.tileID.wrapped().key,queryResults:a.tile.queryRenderedFeatures(t,i,e.getState(),a.queryGeometry,a.cameraQueryGeometry,a.scale,r,o,c,U(o,a.tileID),s?(e,t)=>s(a.tileID,e,t):void 0)});return function(e,t){for(const i in e)for(const a of e[i])V(a,t);return e;}(function(e){const t={},i={};for(const a of e){const e=a.queryResults,r=a.wrappedTileID,o=i[r]=i[r]||{};for(const i in e){const a=e[i],r=o[i]=o[i]||{},s=t[i]=t[i]||[];for(const e of a)r[e.featureIndex]||(r[e.featureIndex]=!0,s.push(e));}}return t;}(u),e);}function G(e,t){const i=e.tileID,a=t.tileID;return i.overscaledZ-a.overscaledZ||i.canonical.y-a.canonical.y||i.wrap-a.wrap||i.canonical.x-a.canonical.x;}function V(e,t){const i=e.feature,a=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=a;}function W(e,i,a){return t._(this,void 0,void 0,function*(){let r=e;if(e.url?r=(yield t.j(i.transformRequest(e.url,"Source"),a)).data:yield s.frameAsync(a),!r)return null;const o=t.S(t.e(r,e),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return"vector_layers"in r&&r.vector_layers&&(o.vectorLayerIds=r.vector_layers.map(e=>e.id)),o;});}class q{constructor(e,t){e&&(t?this.setSouthWest(e).setNorthEast(t):Array.isArray(e)&&(4===e.length?this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]):this.setSouthWest(e[0]).setNorthEast(e[1])));}setNorthEast(e){return this._ne=e instanceof t.U?new t.U(e.lng,e.lat):t.U.convert(e),this;}setSouthWest(e){return this._sw=e instanceof t.U?new t.U(e.lng,e.lat):t.U.convert(e),this;}extend(e){const i=this._sw,a=this._ne;let r,o;if(e instanceof t.U)r=e,o=e;else{if(!(e instanceof q))return Array.isArray(e)?4===e.length||e.every(Array.isArray)?this.extend(q.convert(e)):this.extend(t.U.convert(e)):e&&("lng"in e||"lon"in e)&&"lat"in e?this.extend(t.U.convert(e)):this;if(r=e._sw,o=e._ne,!r||!o)return this;}return i||a?(i.lng=Math.min(r.lng,i.lng),i.lat=Math.min(r.lat,i.lat),a.lng=Math.max(o.lng,a.lng),a.lat=Math.max(o.lat,a.lat)):(this._sw=new t.U(r.lng,r.lat),this._ne=new t.U(o.lng,o.lat)),this;}getCenter(){return new t.U((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2);}getSouthWest(){return this._sw;}getNorthEast(){return this._ne;}getNorthWest(){return new t.U(this.getWest(),this.getNorth());}getSouthEast(){return new t.U(this.getEast(),this.getSouth());}getWest(){return this._sw.lng;}getSouth(){return this._sw.lat;}getEast(){return this._ne.lng;}getNorth(){return this._ne.lat;}toArray(){return[this._sw.toArray(),this._ne.toArray()];}toString(){return`LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`;}isEmpty(){return!(this._sw&&this._ne);}contains(e){const{lng:i,lat:a}=t.U.convert(e);let r=this._sw.lng<=i&&i<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=i&&i>=this._ne.lng),this._sw.lat<=a&&a<=this._ne.lat&&r;}intersects(e){if((e=q.convert(e)).getNorth()<this.getSouth()||e.getSouth()>this.getNorth())return!1;const i=t.V(this.getWest(),-180,180),a=t.V(this.getEast(),-180,180),r=t.V(e.getWest(),-180,180),o=t.V(e.getEast(),-180,180),s=i>a,n=r>o;return!(!s||!n)||(s?o>=i||r<=a:n?a>=r||i<=o:!(r>a||o<i));}static convert(e){return e instanceof q?e:e?new q(e):e;}static fromLngLat(e){let i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;const a=360*i/40075017,r=a/Math.cos(Math.PI/180*e.lat);return new q(new t.U(e.lng-r,e.lat-a),new t.U(e.lng+r,e.lat+a));}adjustAntiMeridian(){const e=new t.U(this._sw.lng,this._sw.lat),i=new t.U(this._ne.lng,this._ne.lat);return new q(e,e.lng>i.lng?new t.U(i.lng+360,i.lat):i);}}class ${constructor(e,t,i){this.bounds=q.convert(this.validateBounds(e)),this.minzoom=t||0,this.maxzoom=i||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90];}contains(e){const i=Math.pow(2,e.z),a=Math.floor(t.X(this.bounds.getWest())*i),r=Math.floor(t.W(this.bounds.getNorth())*i),o=Math.ceil(t.X(this.bounds.getEast())*i),s=Math.ceil(t.W(this.bounds.getSouth())*i);return e.x>=a&&e.x<o&&e.y>=r&&e.y<s;}}class H extends t.E{constructor(e,i,a,r){if(super(),this.id=e,this.dispatcher=a,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,t.e(this,t.S(i,["url","scheme","tileSize","promoteId"])),this._options=t.e({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r);}load(){return t._(this,void 0,void 0,function*(){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController();try{const e=yield W(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.tileManagers[this.id].clearTiles(),e&&(t.e(this,e),e.bounds&&(this.tileBounds=new $(e.bounds,this.minzoom,this.maxzoom)),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.l("data",{dataType:"source",sourceDataType:"content"})));}catch(e){this._tileJSONRequest=null,this._loaded=!0,this.fire(new t.k(e));}});}loaded(){return this._loaded;}hasTile(e){return!this.tileBounds||this.tileBounds.contains(e.canonical);}onAdd(e){this.map=e,this.load();}setSourceProperty(e){this._tileJSONRequest&&this._tileJSONRequest.abort(),e(),this.load();}setTiles(e){return this.setSourceProperty(()=>{this._options.tiles=e;}),this;}setUrl(e){return this.setSourceProperty(()=>{this.url=e,this._options.url=e;}),this;}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}serialize(){return t.e({},this._options);}loadTile(e){return t._(this,void 0,void 0,function*(){const t=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(t,"Tile"),uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};i.request.collectResourceTiming=this._collectResourceTiming;let a="RT";if(e.actor&&"expired"!==e.state){if("loading"===e.state)return new Promise((t,i)=>{e.reloadPromise={resolve:t,reject:i};});}else e.actor=this.dispatcher.getActor(),a="LT";e.abortController=new AbortController();try{const t=yield e.actor.sendAsync({type:a,data:i},e.abortController);if(delete e.abortController,e.aborted)return;this._afterTileLoadWorkerResponse(e,t);}catch(t){if(delete e.abortController,e.aborted)return;if(t&&404!==t.status)throw t;this._afterTileLoadWorkerResponse(e,null);}});}_afterTileLoadWorkerResponse(e,t){if(t&&t.resourceTiming&&(e.resourceTiming=t.resourceTiming),t&&this.map._refreshExpiredTiles&&e.setExpiryData(t),e.loadVectorData(t,this.map.painter),e.reloadPromise){const t=e.reloadPromise;e.reloadPromise=null,this.loadTile(e).then(t.resolve).catch(t.reject);}}abortTile(e){return t._(this,void 0,void 0,function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.actor&&(yield e.actor.sendAsync({type:"AT",data:{uid:e.uid,type:this.type,source:this.id}}));});}unloadTile(e){return t._(this,void 0,void 0,function*(){e.unloadVectorData(),e.actor&&(yield e.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}}));});}hasTransition(){return!1;}}class X extends t.E{constructor(e,i,a,r){super(),this.id=e,this.dispatcher=a,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=t.e({type:"raster"},i),t.e(this,t.S(i,["url","scheme","tileSize"]));}load(){return t._(this,arguments,void 0,function(){var _this=this;let e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:!1;return function*(){_this._loaded=!1,_this.fire(new t.l("dataloading",{dataType:"source"})),_this._tileJSONRequest=new AbortController();try{const i=yield W(_this._options,_this.map._requestManager,_this._tileJSONRequest);_this._tileJSONRequest=null,_this._loaded=!0,i&&(t.e(_this,i),i.bounds&&(_this.tileBounds=new $(i.bounds,_this.minzoom,_this.maxzoom)),_this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})),_this.fire(new t.l("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:e})));}catch(e){_this._tileJSONRequest=null,_this._loaded=!0,_this.fire(new t.k(e));}}();});}loaded(){return this._loaded;}onAdd(e){this.map=e,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}setSourceProperty(e){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),e(),this.load(!0);}setTiles(e){return this.setSourceProperty(()=>{this._options.tiles=e;}),this;}setUrl(e){return this.setSourceProperty(()=>{this.url=e,this._options.url=e;}),this;}serialize(){return t.e({},this._options);}hasTile(e){return!this.tileBounds||this.tileBounds.contains(e.canonical);}loadTile(e){return t._(this,void 0,void 0,function*(){const i=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);e.abortController=new AbortController();try{const a=yield f.getImage(this.map._requestManager.transformRequest(i,"Tile"),e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(a&&a.data){this.map._refreshExpiredTiles&&(a.cacheControl||a.expires)&&e.setExpiryData({cacheControl:a.cacheControl,expires:a.expires});const i=this.map.painter.context,r=i.gl,o=a.data;e.texture=this.map.painter.getTileTexture(o.width),e.texture?e.texture.update(o,{useMipmap:!0}):(e.texture=new t.T(i,o,r.RGBA,{useMipmap:!0}),e.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),e.state="loaded";}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t;}});}abortTile(e){return t._(this,void 0,void 0,function*(){e.abortController&&(e.abortController.abort(),delete e.abortController);});}unloadTile(e){return t._(this,void 0,void 0,function*(){e.texture&&this.map.painter.saveTileTexture(e.texture);});}hasTransition(){return!1;}}class Y extends X{constructor(e,i,a,r){super(e,i,a,r),this.type="raster-dem",this.maxzoom=22,this._options=t.e({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox",this.redFactor=i.redFactor,this.greenFactor=i.greenFactor,this.blueFactor=i.blueFactor,this.baseShift=i.baseShift;}loadTile(e){return t._(this,void 0,void 0,function*(){const i=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),a=this.map._requestManager.transformRequest(i,"Tile");e.neighboringTiles=this._getNeighboringTiles(e.tileID),e.abortController=new AbortController();try{const i=yield f.getImage(a,e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(i&&i.data){const a=i.data;this.map._refreshExpiredTiles&&(i.cacheControl||i.expires)&&e.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const r=t.b(a)&&t.Y()?a:yield this.readImageNow(a),o={type:this.type,uid:e.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!e.actor||"expired"===e.state){e.actor=this.dispatcher.getActor();const t=yield e.actor.sendAsync({type:"LDT",data:o});e.dem=t,e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0,e.state="loaded";}}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t;}});}readImageNow(e){return t._(this,void 0,void 0,function*(){if("undefined"!=typeof VideoFrame&&t.Z()){const i=e.width+2,a=e.height+2;try{return new t.R({width:i,height:a},yield t.$(e,-1,-1,i,a));}catch(e){}}return s.getImageData(e,1);});}_getNeighboringTiles(e){const i=e.canonical,a=Math.pow(2,i.z),r=(i.x-1+a)%a,o=0===i.x?e.wrap-1:e.wrap,s=(i.x+1+a)%a,n=i.x+1===a?e.wrap+1:e.wrap,l={};return l[new t.a0(e.overscaledZ,o,i.z,r,i.y).key]={backfilled:!1},l[new t.a0(e.overscaledZ,n,i.z,s,i.y).key]={backfilled:!1},i.y>0&&(l[new t.a0(e.overscaledZ,o,i.z,r,i.y-1).key]={backfilled:!1},l[new t.a0(e.overscaledZ,e.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new t.a0(e.overscaledZ,n,i.z,s,i.y-1).key]={backfilled:!1}),i.y+1<a&&(l[new t.a0(e.overscaledZ,o,i.z,r,i.y+1).key]={backfilled:!1},l[new t.a0(e.overscaledZ,e.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new t.a0(e.overscaledZ,n,i.z,s,i.y+1).key]={backfilled:!1}),l;}unloadTile(e){return t._(this,void 0,void 0,function*(){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded",e.actor&&(yield e.actor.sendAsync({type:"RDT",data:{type:this.type,uid:e.uid,source:this.id}}));});}}function K(e){return"GeometryCollection"===e.type?e.geometries.map(e=>e.coordinates).flat(1/0):e.coordinates.flat(1/0);}function Q(e){const t=new q();let i;switch(e.type){case"FeatureCollection":i=e.features.map(e=>K(e.geometry)).flat(1/0);break;case"Feature":i=K(e.geometry);break;default:i=K(e);}if(0==i.length)return t;for(let e=0;e<i.length-1;e+=2)t.extend([i[e],i[e+1]]);return t;}class J extends t.E{constructor(e,i,a,r){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._isUpdatingWorker=!1,this._pendingWorkerUpdate={data:i.data},this.actor=a.getActor(),this.setEventedParent(r),this._data=i.data,this._options=t.e({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId,void 0!==i.clusterMaxZoom&&this.maxzoom<=i.clusterMaxZoom&&t.w(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${i.clusterMaxZoom}".`),this.workerOptions=t.e({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==i.buffer?i.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==i.tolerance?i.tolerance:.375),extent:t.a3,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:this._getClusterMaxZoom(i.clusterMaxZoom),minPoints:Math.max(2,i.clusterMinPoints||2),extent:t.a3,radius:this._pixelsToTileUnits(i.clusterRadius||50),log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId);}_hasPendingWorkerUpdate(){return void 0!==this._pendingWorkerUpdate.data||void 0!==this._pendingWorkerUpdate.diff||this._pendingWorkerUpdate.optionsChanged;}_pixelsToTileUnits(e){return e*(t.a3/this.tileSize);}_getClusterMaxZoom(e){const i=e?Math.round(e):this.maxzoom-1;return Number.isInteger(e)||void 0===e||t.w(`Integer expected for option 'clusterMaxZoom': provided value "${e}" rounded to "${i}"`),i;}load(){return t._(this,void 0,void 0,function*(){yield this._updateWorkerData();});}onAdd(e){this.map=e,this.load();}setData(e){return this._data=e,this._pendingWorkerUpdate={data:e},this._updateWorkerData(),this;}updateData(e){return this._pendingWorkerUpdate.diff=t.a4(this._pendingWorkerUpdate.diff,e),this._updateWorkerData(),this;}getData(){return t._(this,void 0,void 0,function*(){const e=t.e({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:e});});}getBounds(){return t._(this,void 0,void 0,function*(){return Q(yield this.getData());});}setClusterOptions(e){return this.workerOptions.cluster=e.cluster,void 0!==e.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(e.clusterRadius)),void 0!==e.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=this._getClusterMaxZoom(e.clusterMaxZoom)),this._pendingWorkerUpdate.optionsChanged=!0,this._updateWorkerData(),this;}getClusterExpansionZoom(e){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:e,source:this.id}});}getClusterChildren(e){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:e,source:this.id}});}getClusterLeaves(e,t,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:e,limit:t,offset:i}});}_updateWorkerData(){return t._(this,void 0,void 0,function*(){if(this._isUpdatingWorker)return;if(!this._hasPendingWorkerUpdate())return void t.w(`No pending worker updates for GeoJSONSource ${this.id}.`);const{data:e,diff:i}=this._pendingWorkerUpdate,a=t.e({type:this.type},this.workerOptions);e?("string"==typeof e?(a.request=this.map._requestManager.transformRequest(s.resolveURL(e),"Source"),a.request.collectResourceTiming=this._collectResourceTiming):a.data=JSON.stringify(e),this._pendingWorkerUpdate.data=void 0):i&&(a.dataDiff=i,this._pendingWorkerUpdate.diff=void 0),this._pendingWorkerUpdate.optionsChanged=void 0,this._isUpdatingWorker=!0,this.fire(new t.l("dataloading",{dataType:"source"}));try{const e=yield this.actor.sendAsync({type:"LD",data:a});if(this._isUpdatingWorker=!1,this._removed||e.abandoned)return void this.fire(new t.l("dataabort",{dataType:"source"}));this._data=e.data;let r=null;e.resourceTiming&&e.resourceTiming[this.id]&&(r=e.resourceTiming[this.id].slice(0));const o={dataType:"source"};this._collectResourceTiming&&r&&r.length>0&&t.e(o,{resourceTiming:r}),this.fire(new t.l("data",Object.assign(Object.assign({},o),{sourceDataType:"metadata"}))),this.fire(new t.l("data",Object.assign(Object.assign({},o),{sourceDataType:"content",shouldReloadTileOptions:this._getShouldReloadTileOptions(i)})));}catch(e){if(this._isUpdatingWorker=!1,this._removed)return void this.fire(new t.l("dataabort",{dataType:"source"}));this.fire(new t.k(e));}finally{this._hasPendingWorkerUpdate()&&this._updateWorkerData();}});}_getShouldReloadTileOptions(e){if(!e||e.removeAll)return;const{add:t=[],update:i=[],remove:a=[]}=e||{},r=new Set([...i.map(e=>e.id),...a]);return{nextBounds:[...i.map(e=>e.newGeometry),...t.map(e=>e.geometry)].map(e=>Q(e)),prevIds:r};}shouldReloadTile(e,_ref78){let{nextBounds:i,prevIds:a}=_ref78;const r=e.latestFeatureIndex.loadVTLayers();for(let t=0;t<e.latestFeatureIndex.featureIndexArray.length;t++){const i=e.latestFeatureIndex.featureIndexArray.get(t),o=r._geojsonTileLayer.feature(i.featureIndex);if(a.has(o.id))return!0;}const{buffer:o,extent:s}=this.workerOptions.geojsonVtOptions,n=function(_ref79){let{x:e,y:i,z:a}=_ref79;let r=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;const o=t.a1((e-r)/Math.pow(2,a)),s=t.a2((i+1+r)/Math.pow(2,a)),n=t.a1((e+1+r)/Math.pow(2,a)),l=t.a2((i-r)/Math.pow(2,a));return new q([o,s],[n,l]);}(e.tileID.canonical,o/s);for(const e of i)if(n.intersects(e))return!0;return!1;}loaded(){return!this._isUpdatingWorker&&!this._hasPendingWorkerUpdate();}loadTile(e){return t._(this,void 0,void 0,function*(){const t=e.actor?"RT":"LT";e.actor=this.actor;const i={type:this.type,uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};e.abortController=new AbortController();const a=yield this.actor.sendAsync({type:t,data:i},e.abortController);delete e.abortController,e.unloadVectorData(),e.aborted||e.loadVectorData(a,this.map.painter,"RT"===t);});}abortTile(e){return t._(this,void 0,void 0,function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.aborted=!0;});}unloadTile(e){return t._(this,void 0,void 0,function*(){e.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}});});}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}});}serialize(){return t.e({},this._options,{type:this.type,data:this._data});}hasTransition(){return!1;}}class ee extends t.E{constructor(e,t,i,a){super(),this.flippedWindingOrder=!1,this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(a),this.options=t;}load(e){return t._(this,void 0,void 0,function*(){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController();try{const t=yield f.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,t&&t.data&&(this.image=t.data,e&&(this.coordinates=e),this._finishLoading());}catch(e){this._request=null,this._loaded=!0,this.fire(new t.k(e));}});}loaded(){return this._loaded;}updateImage(e){return e.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=e.url,this.load(e.coordinates).finally(()=>{this.texture=null;}),this):this;}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(e){this.map=e,this.load();}onRemove(){this._request&&(this._request.abort(),this._request=null);}setCoordinates(e){this.coordinates=e;const i=e.map(t.a5.fromLngLat);var a;return this.tileID=function(e){const i=t.a6.fromPoints(e),a=i.width(),r=i.height(),o=Math.max(a,r),s=Math.max(0,Math.floor(-Math.log(o)/Math.LN2)),n=Math.pow(2,s);return new t.a8(s,Math.floor((i.minX+i.maxX)/2*n),Math.floor((i.minY+i.maxY)/2*n));}(i),this.terrainTileRanges=this._getOverlappingTileRanges(i),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=i.map(e=>this.tileID.getTilePoint(e)._round()),this.flippedWindingOrder=((a=this.tileCoords)[1].x-a[0].x)*(a[2].y-a[0].y)-(a[1].y-a[0].y)*(a[2].x-a[0].x)<0,this.fire(new t.l("data",{dataType:"source",sourceDataType:"content"})),this;}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const e=this.map.painter.context,i=e.gl;this.texture||(this.texture=new t.T(e,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let a=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,a=!0);}a&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}loadTile(e){return t._(this,void 0,void 0,function*(){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={}):e.state="errored";});}serialize(){return{type:"image",url:this.options.url,coordinates:this.coordinates};}hasTransition(){return!1;}_getOverlappingTileRanges(e){const{minX:i,minY:a,maxX:r,maxY:o}=t.a6.fromPoints(e),s={};for(let e=0;e<=t.a7;e++){const t=Math.pow(2,e),n=Math.floor(i*t),l=Math.floor(a*t),c=Math.floor(r*t),h=Math.floor(o*t);s[e]={minTileX:n,minTileY:l,maxTileX:c,maxTileY:h};}return s;}}class te extends ee{constructor(e,t,i,a){super(e,t,i,a),this.roundZoom=!0,this.type="video",this.options=t;}load(){return t._(this,void 0,void 0,function*(){this._loaded=!1;const e=this.options;this.urls=[];for(const t of e.urls)this.urls.push(this.map._requestManager.transformRequest(t,"Source").url);try{const e=yield t.a9(this.urls);if(this._loaded=!0,!e)return;this.video=e,this.video.loop=!0,this.video.addEventListener("playing",()=>{this.map.triggerRepaint();}),this.map&&this.video.play(),this._finishLoading();}catch(e){this.fire(new t.k(e));}});}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(e){if(this.video){const i=this.video.seekable;e<i.start(0)||e>i.end(0)?this.fire(new t.k(new t.aa(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=e;}}getVideo(){return this.video;}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,i=e.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new t.T(e,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let a=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,a=!0);}a&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return{type:"video",urls:this.urls,coordinates:this.coordinates};}hasTransition(){return this.video&&!this.video.paused;}}class ie extends ee{constructor(e,i,a,r){super(e,i,a,r),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some(e=>!Array.isArray(e)||2!==e.length||e.some(e=>"number"!=typeof e))||this.fire(new t.k(new t.aa(`sources.${e}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new t.k(new t.aa(`sources.${e}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new t.k(new t.aa(`sources.${e}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new t.k(new t.aa(`sources.${e}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new t.k(new t.aa(`sources.${e}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){return t._(this,void 0,void 0,function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new t.k(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());});}getCanvas(){return this.canvas;}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,a=i.gl;this.texture?(e||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new t.T(i,this.canvas,a.RGBA,{premultiply:!0});let r=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,r=!0);}r&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return{type:"canvas",coordinates:this.coordinates};}hasTransition(){return this._playing;}_hasInvalidDimensions(){for(const e of[this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return!0;return!1;}}const ae={},re=e=>{switch(e){case"geojson":return J;case"image":return ee;case"raster":return X;case"raster-dem":return Y;case"vector":return H;case"video":return te;case"canvas":return ie;}return ae[e];},oe="RTLPluginLoaded";class se extends t.E{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=N();}_syncState(e){return this.status=e,this.dispatcher.broadcast("SRPS",{pluginStatus:e,pluginURL:this.url}).catch(e=>{throw this.status="error",e;});}getRTLTextPluginStatus(){return this.status;}clearRTLTextPlugin(){this.status="unavailable",this.url=null;}setRTLTextPlugin(e){return t._(this,arguments,void 0,function(e){var _this2=this;let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:!1;return function*(){if(_this2.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(_this2.url=s.resolveURL(e),!_this2.url)throw new Error(`requested url ${e} is invalid`);if("unavailable"===_this2.status){if(!t)return _this2._requestImport();_this2.status="deferred",_this2._syncState(_this2.status);}else if("requested"===_this2.status)return _this2._requestImport();}();});}_requestImport(){return t._(this,void 0,void 0,function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new t.l(oe));});}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport();}}let ne=null;function le(){return ne||(ne=new se()),ne;}var ce,he;!function(e){e[e.Base=0]="Base",e[e.Parent=1]="Parent";}(ce||(ce={})),function(e){e[e.Departing=0]="Departing",e[e.Incoming=1]="Incoming";}(he||(he={}));class ue{constructor(e,i){this.timeAdded=0,this.fadeEndTime=0,this.fadeOpacity=1,this.tileID=e,this.uid=t.ab(),this.uses=0,this.tileSize=i,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading";}isRenderable(e){return this.hasData()&&(!this.fadeEndTime||this.fadeOpacity>0)&&(e||!this.holdingForSymbolFade());}setCrossFadeLogic(_ref80){let{fadingRole:e,fadingDirection:t,fadingParentID:i,fadeEndTime:a}=_ref80;this.resetFadeLogic(),this.fadingRole=e,this.fadingDirection=t,this.fadingParentID=i,this.fadeEndTime=a;}setSelfFadeLogic(e){this.resetFadeLogic(),this.selfFading=!0,this.fadeEndTime=e;}resetFadeLogic(){this.fadingRole=null,this.fadingDirection=null,this.fadingParentID=null,this.selfFading=!1,this.timeAdded=l(),this.fadeEndTime=0,this.fadeOpacity=1;}wasRequested(){return"errored"===this.state||"loaded"===this.state||"reloading"===this.state;}clearTextures(e){this.demTexture&&e.saveTileTexture(this.demTexture),this.demTexture=null;}loadVectorData(e,i,a){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",e){e.featureIndex&&(this.latestFeatureIndex=e.featureIndex,e.rawTileData?(this.latestRawTileData=e.rawTileData,this.latestFeatureIndex.rawTileData=e.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=e.collisionBoxArray,this.buckets=function(e,t){const i={};if(!t)return i;for(const a of e){const e=a.layerIds.map(e=>t.getLayer(e)).filter(Boolean);if(0!==e.length){a.layers=e,a.stateDependentLayerIds&&(a.stateDependentLayers=a.stateDependentLayerIds.map(t=>e.filter(e=>e.id===t)[0]));for(const t of e)i[t.id]=a;}}return i;}(e.buckets,null==i?void 0:i.style),this.hasSymbolBuckets=!1;for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.ad){if(this.hasSymbolBuckets=!0,!a)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.ad&&i.hasRTLText){this.hasRTLText=!0,le().lazyLoad();break;}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e];this.queryPadding=Math.max(this.queryPadding,i.style.getLayer(e).queryRadius(t));}e.imageAtlas&&(this.imageAtlas=e.imageAtlas),e.glyphAtlasImage&&(this.glyphAtlasImage=e.glyphAtlasImage),this.dashPositions=e.dashPositions;}else this.collisionBoxArray=new t.ac();}unloadVectorData(){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.dashPositions&&(this.dashPositions=null),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(e){return this.buckets[e.id];}upload(e){for(const t in this.buckets){const i=this.buckets[t];i.uploadPending()&&i.upload(e);}const i=e.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new t.T(e,this.imageAtlas.image,i.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new t.T(e,this.glyphAtlasImage,i.ALPHA),this.glyphAtlasImage=null);}prepare(e){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture);}queryRenderedFeatures(e,t,i,a,r,o,s,n,l,c,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:a,cameraQueryGeometry:r,scale:o,tileSize:this.tileSize,pixelPosMatrix:c,transform:n,params:s,queryPadding:this.queryPadding*l,getElevation:h},e,t,i):{};}querySourceFeatures(e,i){const a=this.latestFeatureIndex;if(!a||!a.rawTileData)return;const r=a.loadVTLayers(),o=i&&i.sourceLayer?i.sourceLayer:"",s=r._geojsonTileLayer||r[o];if(!s)return;const n=t.ae(null==i?void 0:i.filter,null==i?void 0:i.globalState),{z:l,x:c,y:h}=this.tileID.canonical,u={z:l,x:c,y:h};for(let i=0;i<s.length;i++){const r=s.feature(i);if(n.needGeometry){const e=t.af(r,!0);if(!n.filter(new t.G(this.tileID.overscaledZ),e,this.tileID.canonical))continue;}else if(!n.filter(new t.G(this.tileID.overscaledZ),r))continue;const d=a.getId(r,o),_=new t.ag(r,l,c,h,d);_.tile=u,e.push(_);}}hasData(){return"loaded"===this.state||"reloading"===this.state||"expired"===this.state;}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length;}setExpiryData(e){const i=this.expirationTime;if(e.cacheControl){const i=t.ah(e.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else e.expires&&(this.expirationTime=new Date(e.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i){if(this.expirationTime<i)t=!0;else{const a=this.expirationTime-i;a?this.expirationTime=e+Math.max(a,3e4):t=!0;}}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-new Date().getTime(),Math.pow(2,31)-1);}setFeatureState(e,t){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(e).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const a in this.buckets){if(!t.style.hasLayer(a))continue;const r=this.buckets[a],o=r.layers[0].sourceLayer||"_geojsonTileLayer",s=i[o],n=e[o];if(!s||!n||0===Object.keys(n).length)continue;r.update(n,s,this.imageAtlas&&this.imageAtlas.patternPositions||{},this.dashPositions||{});const l=t&&t.style&&t.style.getLayer(a);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(r)));}}holdingForSymbolFade(){return void 0!==this.symbolFadeHoldUntil;}symbolFadeFinished(){return!this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<l();}clearSymbolFadeHold(){this.symbolFadeHoldUntil=void 0;}setSymbolHoldDuration(e){this.symbolFadeHoldUntil=l()+e;}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return!0;}return!1;}}class de{constructor(e,t){this.max=e,this.onRemove=t,this.reset();}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this;}add(e,t,i){const a=e.wrapped().key;void 0===this.data[a]&&(this.data[a]=[]);const r={value:t,timeout:void 0};if(void 0!==i&&(r.timeout=setTimeout(()=>{this.remove(e,r);},i)),this.data[a].push(r),this.order.push(a),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this;}has(e){return e.wrapped().key in this.data;}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null;}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value;}getByKey(e){const t=this.data[e];return t?t[0].value:null;}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null;}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,a=void 0===t?0:this.data[i].indexOf(t),r=this.data[i][a];return this.data[i].splice(a,1),r.timeout&&clearTimeout(r.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(r.value),this.order.splice(this.order.indexOf(i),1),this;}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this;}filter(e){const t=[];for(const i in this.data)for(const a of this.data[i])e(a.value)||t.push(a);for(const e of t)this.remove(e.value.tileID,e);}}class _e{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(e,i,a){const r=String(i);if(this.stateChanges[e]=this.stateChanges[e]||{},this.stateChanges[e][r]=this.stateChanges[e][r]||{},t.e(this.stateChanges[e][r],a),null===this.deletedStates[e]){this.deletedStates[e]={};for(const t in this.state[e])t!==r&&(this.deletedStates[e][t]=null);}else if(this.deletedStates[e]&&null===this.deletedStates[e][r]){this.deletedStates[e][r]={};for(const t in this.state[e][r])a[t]||(this.deletedStates[e][r][t]=null);}else for(const t in a)this.deletedStates[e]&&this.deletedStates[e][r]&&null===this.deletedStates[e][r][t]&&delete this.deletedStates[e][r][t];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const a=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][a]&&(this.deletedStates[e][a]=this.deletedStates[e][a]||{},this.deletedStates[e][a][i]=null);else if(void 0!==t){if(this.stateChanges[e]&&this.stateChanges[e][a])for(i in this.deletedStates[e][a]={},this.stateChanges[e][a])this.deletedStates[e][a][i]=null;else this.deletedStates[e][a]=null;}else this.deletedStates[e]=null;}getState(e,i){const a=String(i),r=t.e({},(this.state[e]||{})[a],(this.stateChanges[e]||{})[a]);if(null===this.deletedStates[e])return{};if(this.deletedStates[e]){const t=this.deletedStates[e][i];if(null===t)return{};for(const e in t)delete r[e];}return r;}initializeTileState(e,t){e.setFeatureState(this.state,t);}coalesceChanges(e,i){const a={};for(const e in this.stateChanges){this.state[e]=this.state[e]||{};const i={};for(const a in this.stateChanges[e])this.state[e][a]||(this.state[e][a]={}),t.e(this.state[e][a],this.stateChanges[e][a]),i[a]=this.state[e][a];a[e]=i;}for(const e in this.deletedStates){this.state[e]=this.state[e]||{};const i={};if(null===this.deletedStates[e])for(const t in this.state[e])i[t]={},this.state[e][t]={};else for(const t in this.deletedStates[e]){if(null===this.deletedStates[e][t])this.state[e][t]={};else for(const i of Object.keys(this.deletedStates[e][t]))delete this.state[e][t][i];i[t]=this.state[e][t];}a[e]=a[e]||{},t.e(a[e],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(a).length)for(const t in e)e[t].setFeatureState(a,i);}}const pe=89.25;function me(e,i){const a=t.ai(i.lat,-t.aj,t.aj);return new t.P(t.X(i.lng)*e,t.W(a)*e);}function fe(e,i){return new t.a5(i.x/e,i.y/e).toLngLat();}function ge(e){return e.cameraToCenterDistance*Math.min(.85*Math.tan(t.ak(90-e.pitch)),Math.tan(t.ak(pe-e.pitch)));}function ve(e,i){const a=e.canonical,r=i/t.al(a.z),o=a.x+Math.pow(2,a.z)*e.wrap,s=t.am(new Float64Array(16));return t.N(s,s,[o*r,a.y*r,0]),t.O(s,s,[r/t.a3,r/t.a3,1]),s;}function xe(e,i,a,r,o){const s=t.a5.fromLngLat(e,i),n=o*t.an(1,e.lat),l=n*Math.cos(t.ak(a)),c=Math.sqrt(n*n-l*l),h=c*Math.sin(t.ak(-r)),u=c*Math.cos(t.ak(-r));return new t.a5(s.x+h,s.y+u,s.z+l);}function be(e,t,i){const a=t.intersectsFrustum(e);if(!i||0===a)return a;const r=t.intersectsPlane(i);return 0===r?0:2===a&&2===r?2:1;}function ye(e,t,i){let a=0;const r=(i-t)/10;for(let o=0;o<10;o++)a+=r*Math.pow(Math.cos(t+(o+.5)/10*(i-t)),e);return a;}function we(e,i){return function(a,r,o,s,n){const l=2*((e-1)/t.ao(Math.cos(t.ak(pe-n))/Math.cos(t.ak(pe)))-1),c=Math.acos(o/s),h=2*ye(l-1,0,t.ak(n/2)),u=Math.min(t.ak(pe),c+t.ak(n/2)),d=ye(l-1,Math.min(u,c-t.ak(n/2)),u),_=Math.atan(r/o),p=Math.hypot(r,o);let m=a;return m+=t.ao(s/p/Math.max(.5,Math.cos(t.ak(n/2)))),m+=l*t.ao(Math.cos(_))/2,m-=t.ao(Math.max(1,d/h/i))/2,m;};}const Te=we(9.314,3);function Pe(e,i){const a=(i.roundZoom?Math.round:Math.floor)(e.zoom+t.ao(e.tileSize/i.tileSize));return Math.max(0,a);}function Me(e,i){const a=e.getCameraFrustum(),r=e.getClippingPlane(),o=e.screenPointToMercatorCoordinate(e.getCameraPoint()),s=t.a5.fromLngLat(e.center,e.elevation);o.z=s.z+Math.cos(e.pitchInRadians)*e.cameraToCenterDistance/e.worldSize;const n=e.getCoveringTilesDetailsProvider(),l=n.allowVariableZoom(e,i),c=Pe(e,i),h=i.minzoom||0,u=void 0!==i.maxzoom?i.maxzoom:e.maxZoom,d=Math.min(Math.max(0,c),u),_=Math.pow(2,d),p=[_*o.x,_*o.y,0],m=[_*s.x,_*s.y,0],f=Math.hypot(s.x-o.x,s.y-o.y),g=M