# Foehnix Paraglider Widget for Android

Foehnix features
- Assessment of Foehn conditions for pilots.
- Intended for paraglider and for hangglider pilots.
- Displays pressure differences + relevant wind gusts.
- Updates every 15 minutes or on request.
- Data sourced from MeteoSwiss.
- Permission is granted to distribute and / or sell Foehnix in app stores such as google apps.

![foehniximage](http://ecx.images-amazon.com/images/I/91dttZ4w07L._SY300_.png)

The Foehnix weather widget for Android aims at helping pilots with weather conditions. Turbulence during flying due to Foehn conditions is known to be a serious issue for paraglider and for hangglider pilots flying in the Alps. Foehnix comes as a widget and displays pressure differences across the Alps between Lugano and Kloten. Pressure differences are updated every 15 minutes or upon request. An excessive negative pressure difference is likely to result in Foehn conditions on the South side of the Alps. Likewise, an excessive positive pressure difference is likely to result in Foehn conditions on the North side of the Alps. 

The widget also displays maximum wind speeds in some valleys that are most likely to be affected by Foehn. Those measurements of current maximum wind in conjunction with the aforementioend pressure diferences allow for a more precise assessment of Foehn conditions. Should the pressure difference be positive in combination with strong Southerly winds in Altdorf, then those winds are probably caused by Foehn on the North side. By contrast, a negative pressure difference combined with strong Northerly winds in Locarno probably points to Foehn on the South side. These hints should, nonetheless, not be considered in isolation. Instead, they need to be matched to observations of local weather, to the geography and to the particulars of any particular flying site, to typical cloud shapes etc. 

As from version 2.2, Foehnix also provides functionality to share weather conditions via text message, email etc.

Foehnix does not and is not meant to replace your judgement as a pilot! The author acknowledges MeteoSwiss for providing raw weather data. Always happy landing!

[<img src="https://f-droid.org/badge/get-it-on.png"
      alt="Get it on F-Droid"
      height="80">](https://f-droid.org/packages/foehnix.widget/)
      
[<img src="https://images-na.ssl-images-amazon.com/images/G/01/pn-mlp/images/appstores/amazon_3x.png"
      alt="Get it on Amazon"
      height="80">](https://www.amazon.com/Foehnix-Paragliding-App-for-Android/dp/B00ZPPLKJA)
