/*
  ==============================================================================

   This file is part of the JUCE library.
   Copyright (c) 2022 - Raw Material Software Limited

   JUCE is an open source library subject to commercial or open-source
   licensing.

   By using JUCE, you agree to the terms of both the JUCE 7 End-User License
   Agreement and JUCE Privacy Policy.

   End User License Agreement: www.juce.com/juce-7-licence
   Privacy Policy: www.juce.com/juce-privacy-policy

   Or: You may also use this code under the terms of the GPL v3 (see
   www.gnu.org/licenses).

   JUCE IS PROVIDED "AS IS" WITHOUT ANY WARRANTY, AND ALL WARRANTIES, WHETHER
   EXPRESSED OR IMPLIED, INCLUDING MERCHANTABILITY AND FITNESS FOR PURPOSE, ARE
   DISCLAIMED.

  ==============================================================================
*/

namespace juce
{
// This byte-code is generated from native/java/com/rmsl/juce/ComponentPeerView.java with min sdk version 16
// See juce_core/native/java/README.txt on how to generate this byte-code.
static const uint8 javaComponentPeerView[] =
{ 31,139,8,8,177,100,96,101,0,3,74,97,118,97,68,101,120,66,121,116,101,67,111,100,101,46,100,101,120,0,157,155,9,92,220,213,181,199,207,253,255,255,51,3,195,54,12,4,8,129,48,33,49,33,11,48,132,172,5,205,142,129,144,197,64,18,3,110,3,252,129,73,134,255,
  76,102,6,2,106,159,209,230,153,180,62,151,106,220,227,210,62,245,85,171,85,219,216,218,214,218,190,167,62,109,245,249,209,186,214,215,218,216,106,77,107,125,198,180,46,181,46,239,119,238,189,3,67,22,237,123,228,243,157,115,254,231,238,247,158,123,238,
  253,79,160,199,30,246,6,235,231,211,237,110,207,189,37,221,45,75,118,15,5,6,227,147,91,126,52,205,244,223,119,195,139,203,239,125,189,158,40,70,68,195,155,231,249,73,255,4,96,11,8,101,95,8,14,91,68,43,32,159,114,17,149,240,115,6,209,46,200,251,50,137,
  44,150,57,68,7,78,34,10,230,18,61,93,70,244,12,120,14,188,8,94,5,191,3,31,129,79,128,40,39,114,131,76,144,3,242,65,33,40,1,11,193,6,208,6,182,128,78,112,54,232,1,97,224,128,139,193,67,224,37,112,132,235,152,76,84,13,214,130,97,112,37,248,54,248,25,120,
  17,188,3,178,42,136,22,128,53,192,6,55,129,135,193,187,224,164,0,209,153,224,82,112,0,28,4,121,83,208,15,112,29,120,14,188,15,74,43,137,190,4,206,4,231,131,107,192,157,224,191,192,95,64,198,84,162,217,96,9,56,11,196,193,55,192,79,192,243,224,13,240,1,
  248,4,100,77,35,202,5,126,48,17,148,131,147,192,108,48,23,44,2,39,131,101,160,9,172,1,27,192,102,208,1,186,128,13,182,129,24,24,4,231,131,139,192,197,224,18,112,21,184,1,220,12,190,11,30,7,207,129,223,130,183,192,7,192,196,154,229,129,73,96,6,168,7,75,
  193,122,96,131,1,112,46,216,13,110,1,119,129,123,192,207,192,19,224,25,240,50,120,13,28,2,239,1,99,58,198,5,166,128,89,160,14,172,3,237,96,11,56,11,236,2,151,128,43,193,173,224,30,240,11,112,8,252,5,88,51,208,39,48,11,204,3,75,193,58,176,21,56,224,124,
  176,7,92,7,238,0,247,130,7,193,99,224,37,240,38,248,24,100,85,161,30,176,24,44,1,171,192,106,208,5,18,224,159,193,181,224,14,240,61,240,115,240,10,120,11,124,4,60,51,137,202,192,116,176,4,52,131,245,96,35,56,11,116,131,36,248,10,216,7,110,1,247,128,31,
  128,159,130,39,193,11,224,48,248,59,176,102,97,173,193,28,80,15,150,131,213,96,3,56,29,156,5,250,192,14,112,1,216,3,46,7,87,131,27,193,119,192,35,224,5,112,8,184,102,99,223,128,217,96,37,104,5,157,96,59,24,1,187,193,85,96,63,184,3,60,0,30,1,79,130,231,
  193,171,224,13,240,46,160,57,240,73,80,13,130,96,49,56,19,156,7,46,2,123,192,181,224,118,240,48,120,26,252,26,188,15,114,170,177,86,96,33,104,2,27,65,23,136,129,11,192,229,224,102,240,32,120,24,60,10,158,2,207,131,87,192,111,193,27,224,29,112,4,252,13,
  24,53,216,83,96,34,152,6,22,128,85,224,52,208,14,182,128,78,112,54,232,6,125,96,59,112,99,40,8,75,148,13,138,73,197,171,137,160,20,76,2,8,65,132,176,65,8,11,84,193,177,14,96,123,19,182,48,97,107,18,182,5,193,141,9,110,72,112,33,130,27,16,150,142,48,221,
  164,167,137,208,61,66,83,84,11,130,160,14,204,5,8,155,52,15,204,7,11,116,236,92,4,22,131,47,129,6,208,8,78,6,167,128,37,96,41,88,6,150,147,138,177,43,65,19,104,6,91,65,55,232,1,54,169,177,165,126,60,90,86,97,80,25,90,15,78,82,99,23,250,57,75,235,156,
  135,231,195,208,246,28,173,47,130,221,151,86,111,1,169,186,150,106,123,174,182,179,238,79,211,39,104,61,95,207,49,215,95,168,245,213,186,108,73,90,157,60,239,27,38,41,157,231,251,116,157,103,122,90,61,51,117,61,126,173,159,51,73,181,195,122,63,244,34,
  61,255,49,93,15,235,195,186,158,106,93,79,145,94,147,93,186,63,188,46,123,39,169,185,156,171,243,180,104,157,219,90,163,245,43,160,183,106,157,219,93,171,245,253,208,215,105,253,110,232,235,181,254,32,244,13,90,127,20,250,105,90,127,6,250,70,173,191,
  12,189,93,235,7,211,236,135,210,244,195,208,55,107,253,195,52,187,85,54,166,103,167,233,133,101,99,117,150,165,217,167,65,223,164,245,57,105,246,146,180,58,121,206,219,180,222,159,214,183,121,105,249,121,62,183,104,189,17,246,211,181,190,50,45,79,123,
  153,242,203,122,61,159,29,90,63,3,246,78,173,247,164,233,49,232,103,104,253,124,232,103,106,125,55,244,179,180,126,5,244,115,180,190,31,250,217,90,191,45,205,206,126,21,210,250,221,176,119,105,253,161,180,252,79,148,177,159,11,26,33,37,179,5,239,251,
  147,40,65,74,126,95,74,65,63,212,242,199,90,62,164,229,79,180,124,88,231,255,57,113,172,8,80,166,80,210,47,56,110,212,211,19,196,178,130,188,130,99,136,74,175,208,233,21,72,153,32,216,207,139,104,7,177,52,232,7,82,86,208,227,82,150,211,179,82,214,211,
  33,41,179,232,45,233,231,211,233,84,72,23,218,61,66,188,39,61,244,117,41,139,232,22,226,125,93,74,166,148,243,233,61,72,47,74,240,115,150,182,103,97,231,190,47,199,173,158,243,240,121,185,148,197,116,165,126,190,78,203,91,137,247,141,74,103,121,133,148,
  46,186,90,63,223,32,165,69,55,146,218,95,251,181,188,73,203,219,165,20,90,226,108,209,207,44,253,40,127,141,148,179,232,54,226,189,58,93,246,167,0,17,240,119,82,46,166,223,75,89,70,127,32,222,227,53,52,168,229,95,136,247,240,2,122,148,56,150,228,208,
  47,165,44,165,119,217,151,245,184,38,98,183,179,44,67,20,125,64,202,217,244,55,41,151,144,41,215,169,78,166,151,99,38,118,75,57,145,246,234,231,175,74,185,136,222,150,235,87,43,243,77,70,189,7,137,215,77,149,171,128,189,87,203,62,41,125,212,47,101,41,
  89,66,73,151,92,223,25,50,127,0,43,20,150,50,72,219,164,92,70,219,165,44,164,136,150,3,82,46,37,71,202,82,26,214,242,203,82,46,164,11,165,172,164,75,164,44,160,75,165,204,165,203,164,244,208,62,41,213,188,114,250,181,218,175,246,107,121,147,148,94,186,
  89,251,211,55,116,254,111,74,153,73,255,42,165,90,143,0,70,252,45,237,135,119,106,121,151,150,223,150,50,64,119,107,127,189,71,219,191,163,203,221,171,229,125,90,222,47,229,20,250,174,148,13,244,61,41,23,208,35,90,62,38,229,52,122,81,202,169,244,146,
  150,47,107,249,43,157,254,138,126,254,111,45,127,45,101,30,253,70,202,42,122,85,202,106,250,173,148,167,208,107,82,42,127,10,104,127,226,231,215,165,156,71,111,72,169,252,139,243,191,41,101,35,189,163,247,221,7,90,126,40,229,28,250,187,148,147,232,19,
  41,231,210,167,250,249,51,157,143,132,146,66,168,116,67,168,121,41,16,124,134,149,208,245,196,114,57,253,135,220,199,38,253,76,74,63,229,11,62,167,148,223,206,198,41,119,21,241,89,101,209,63,73,105,210,83,196,231,213,4,250,119,226,123,68,169,246,219,
  241,231,39,94,185,232,25,92,94,126,85,167,158,39,107,59,159,127,28,223,57,253,16,210,63,212,233,21,186,252,236,180,242,31,34,61,75,31,128,1,82,231,173,60,139,117,249,12,200,122,157,206,247,130,221,168,235,146,58,117,119,184,186,78,217,238,130,188,31,
  152,58,253,199,224,49,157,231,105,105,55,165,238,212,168,59,68,167,240,82,204,199,55,170,78,35,11,190,156,129,90,184,173,145,26,117,167,242,139,246,46,47,237,240,45,128,61,203,40,194,107,100,157,97,88,139,13,139,60,190,124,106,239,202,162,29,129,41,20,
  199,174,229,124,237,221,42,175,73,89,214,142,13,139,104,249,160,215,88,108,188,253,153,227,227,123,155,199,87,245,166,165,219,191,92,223,1,43,49,163,49,223,5,114,180,220,54,247,251,250,26,117,55,59,81,219,38,86,204,239,175,159,49,241,216,54,131,139,105,
  185,43,27,177,227,48,218,228,253,235,21,78,96,38,162,85,182,168,250,195,177,185,191,36,115,87,253,145,227,178,37,251,115,95,141,90,187,246,152,202,199,41,69,134,188,163,24,139,145,199,15,127,111,223,225,77,79,55,196,110,113,181,231,142,157,238,6,140,
  204,75,85,135,77,244,151,199,248,80,141,186,231,117,250,115,48,198,115,97,243,211,25,190,108,121,95,203,192,19,143,245,177,26,117,54,23,184,11,169,210,200,70,62,158,133,246,68,14,181,215,231,146,227,59,21,185,178,197,98,209,56,102,11,172,193,222,27,203,
  177,2,57,188,230,70,92,136,55,158,36,232,254,246,175,147,105,205,63,167,148,54,37,48,15,102,17,249,205,51,160,165,242,183,39,115,208,239,185,24,73,182,197,253,183,228,60,44,164,21,46,206,191,216,244,208,194,115,92,228,47,224,50,220,214,68,196,13,199,
  87,194,35,59,170,141,170,167,121,45,217,231,14,215,240,121,197,227,204,213,227,172,196,28,198,2,213,240,240,78,31,40,200,147,99,22,242,159,220,76,242,251,136,152,143,111,3,185,163,246,140,81,251,60,105,55,244,13,217,87,171,252,185,221,151,39,247,4,123,
  16,183,91,82,171,238,203,237,129,60,244,113,53,241,83,251,20,31,122,61,25,45,231,142,230,171,56,97,190,10,153,47,23,30,207,35,153,142,124,188,215,253,30,127,81,44,80,138,184,91,105,101,161,55,110,244,170,115,95,17,158,42,40,22,172,165,125,153,157,251,
  10,240,84,142,167,42,249,84,136,122,151,99,173,179,173,82,87,12,245,98,5,161,87,88,69,40,151,79,101,150,11,182,157,136,235,94,107,145,117,38,85,120,249,25,239,253,212,177,223,15,45,129,155,208,25,55,78,128,22,193,25,229,4,6,228,167,131,120,85,137,58,
  99,62,121,46,91,133,52,117,217,60,154,46,248,134,231,4,44,244,188,157,251,228,194,254,13,184,136,107,244,160,85,191,233,248,206,211,61,249,8,111,248,83,123,231,99,60,93,25,197,180,54,195,237,241,23,151,101,100,73,205,9,14,81,187,59,219,92,100,22,146,
  223,240,79,155,186,114,1,249,93,59,124,35,152,135,108,247,90,183,229,242,79,240,75,233,4,255,137,174,178,216,211,216,187,121,84,170,247,251,168,234,27,57,86,213,95,193,17,112,24,188,2,248,208,48,45,121,175,31,251,217,181,132,254,79,207,71,255,168,116,
  190,63,22,97,63,158,75,234,30,99,152,85,215,139,25,215,138,154,171,133,49,231,38,49,235,70,65,58,186,160,119,218,103,218,2,126,25,103,45,25,249,240,126,158,242,177,224,70,154,98,230,98,207,187,100,188,187,173,86,197,216,216,166,237,52,101,133,87,250,
  115,170,204,253,169,180,224,74,148,201,150,62,152,74,251,209,104,218,210,209,52,15,106,229,88,242,136,78,27,114,111,145,145,129,235,116,97,126,217,39,127,89,171,206,14,199,199,55,49,68,41,95,33,75,227,223,72,24,142,207,39,109,243,11,51,48,211,19,240,
  190,233,21,255,41,242,132,95,84,125,154,42,255,250,104,249,2,93,190,232,4,229,139,143,42,175,226,206,251,181,106,207,182,45,245,167,197,55,19,123,129,45,177,224,122,220,162,170,62,26,155,207,79,245,88,248,221,173,3,115,154,171,231,128,127,172,160,58,
  123,252,216,159,169,61,155,27,76,237,217,66,57,39,41,123,161,182,111,242,77,144,237,27,122,239,151,6,249,174,204,227,105,150,115,37,99,45,234,243,83,213,167,166,110,39,16,84,231,88,174,44,167,222,146,171,210,108,110,125,126,212,6,63,127,108,107,245,216,
  82,249,23,125,65,254,117,163,115,161,250,177,236,56,253,104,62,142,109,67,154,205,210,109,109,9,170,239,49,252,130,191,233,232,12,26,164,164,73,91,235,16,119,15,111,13,122,104,107,208,173,173,153,216,71,240,36,223,214,160,133,244,12,196,131,137,232,207,
  52,10,136,124,61,94,94,147,222,160,186,43,28,191,255,237,203,139,40,182,113,51,89,167,85,125,200,190,105,74,255,119,78,88,166,126,213,103,159,201,113,47,93,66,86,136,203,120,209,14,223,21,206,11,170,239,95,218,119,229,99,157,2,196,41,139,208,211,182,
  11,17,197,124,185,136,58,94,147,253,25,210,98,191,132,116,57,88,195,76,202,114,123,118,13,101,180,106,31,225,53,245,162,45,222,35,123,131,234,59,24,191,175,45,142,158,240,25,47,112,198,11,117,210,206,201,224,123,22,167,56,56,55,85,125,89,44,221,158,29,
  98,247,144,123,3,230,183,234,237,104,112,18,237,201,196,201,123,200,241,53,98,132,85,124,193,52,212,56,83,223,43,177,44,208,100,235,179,254,142,160,122,31,245,83,219,69,104,219,45,219,118,47,22,38,90,94,156,153,137,54,209,115,236,29,127,229,220,41,30,
  138,46,45,163,235,126,132,86,142,56,62,47,236,217,98,145,224,155,141,210,157,192,249,236,183,46,174,137,251,152,197,125,188,80,236,83,125,244,251,170,94,82,115,207,235,245,104,80,125,103,50,126,238,213,136,217,198,99,117,99,47,199,54,158,134,85,67,217,
  247,72,71,20,196,141,52,159,202,212,177,235,160,94,203,232,233,229,212,62,148,94,235,34,180,169,124,120,16,62,204,101,114,244,90,190,139,50,151,201,177,251,75,219,190,155,62,243,60,122,199,151,131,89,242,102,240,234,101,99,245,94,184,240,51,154,45,248,
  61,171,234,72,219,253,124,102,229,115,186,92,237,108,189,218,144,46,207,125,67,25,252,237,133,184,181,234,213,47,202,183,73,229,251,133,63,147,227,21,172,52,63,179,152,82,165,246,163,212,142,192,42,150,214,142,64,19,75,89,138,191,15,121,57,51,19,183,
  57,148,189,27,167,12,46,255,15,236,122,45,147,50,190,168,164,110,239,74,192,47,210,66,125,51,151,242,145,57,90,242,30,229,239,241,90,228,252,26,242,94,48,183,78,125,143,232,23,124,182,122,40,219,40,53,63,38,127,225,212,149,56,91,93,93,110,156,173,242,
  156,28,162,185,22,223,213,60,88,157,28,248,56,248,216,239,159,90,137,147,213,228,147,53,3,167,231,90,203,48,249,68,221,97,84,253,79,142,81,245,103,240,39,112,136,215,52,31,43,59,73,250,39,118,182,49,167,104,86,137,89,85,53,99,78,205,172,180,152,114,86,
  221,216,250,155,218,218,91,167,238,153,139,12,15,241,28,236,64,142,92,242,47,173,250,187,58,111,120,76,209,58,229,235,124,79,225,27,101,169,241,83,121,79,153,130,214,42,240,14,182,8,163,119,124,95,198,124,120,197,201,162,128,252,249,78,112,6,5,49,226,
  22,153,223,9,78,39,159,213,94,87,128,219,99,80,214,159,74,241,27,78,240,36,242,25,42,173,142,119,228,17,245,127,76,252,147,250,142,147,199,208,8,219,202,212,151,149,250,103,195,81,207,231,28,245,204,229,11,73,157,47,249,232,157,208,54,126,246,233,179,
  35,160,109,25,218,238,79,157,41,218,94,145,86,198,32,245,46,206,114,54,34,15,219,171,181,189,26,111,29,74,10,233,23,66,255,115,209,216,249,101,104,31,73,157,91,214,168,46,180,221,35,191,207,85,109,213,203,60,230,104,185,156,209,50,44,221,58,205,141,124,
  134,182,121,180,76,125,63,156,250,62,56,87,246,138,244,89,202,99,172,215,99,9,72,59,175,173,75,202,84,175,85,249,121,58,127,170,127,44,115,116,187,172,231,141,166,231,165,141,37,103,116,140,197,163,237,171,58,125,186,157,192,104,78,53,158,128,206,45,
  72,189,211,138,42,194,59,139,187,49,236,132,147,167,144,113,74,3,21,173,136,14,196,162,142,237,36,55,216,118,124,115,216,222,89,179,45,52,20,34,209,68,70,83,51,153,77,173,56,249,155,201,104,158,9,160,182,144,209,210,74,229,45,131,221,246,178,238,110,
  59,145,8,119,133,35,225,228,200,186,104,143,189,33,30,29,10,247,216,113,42,94,99,143,116,69,67,241,158,149,225,196,64,56,145,104,13,39,146,182,131,4,209,74,6,42,52,90,81,77,107,43,153,173,120,192,71,11,127,180,82,81,107,200,233,137,71,195,61,181,161,
  88,172,118,89,119,50,60,132,154,27,104,222,120,123,44,22,9,119,135,146,225,168,51,45,149,167,53,220,107,119,143,116,71,236,21,161,72,164,43,212,189,61,209,64,19,79,84,42,61,169,59,234,160,103,201,218,21,44,135,147,233,73,125,241,80,172,63,220,157,168,
  93,17,114,134,66,168,112,242,113,146,162,145,104,188,41,28,73,218,241,19,167,175,13,37,227,225,225,6,154,249,185,233,227,170,42,57,54,235,134,80,216,65,255,138,143,77,217,104,119,35,161,96,52,33,154,168,93,62,232,244,68,236,6,42,76,55,54,47,15,59,61,
  92,251,88,29,67,88,239,90,44,214,170,33,155,43,47,29,159,176,54,202,211,165,211,102,142,79,99,79,153,182,222,105,138,118,15,38,86,244,135,156,62,59,181,200,233,93,25,205,154,62,164,81,227,169,241,232,96,172,129,22,28,155,210,30,183,237,245,93,9,59,62,
  100,199,209,202,169,145,104,87,40,210,26,26,137,14,38,199,154,169,248,252,114,13,84,55,62,67,40,221,95,107,199,121,239,218,144,19,234,227,34,115,255,225,34,236,240,205,78,111,244,152,254,127,65,153,212,38,105,160,154,241,229,194,78,108,48,57,96,39,251,
  163,61,181,203,67,9,84,142,103,248,165,131,229,149,94,123,210,137,243,175,234,9,39,163,113,213,157,89,39,206,118,76,149,213,95,144,119,173,212,71,103,103,73,107,119,116,160,54,62,144,136,212,110,67,0,168,61,38,118,76,251,220,184,208,64,77,95,88,193,9,
  34,199,180,241,43,187,248,255,91,79,3,77,249,162,162,13,84,217,218,19,138,12,133,183,215,134,28,39,154,148,49,163,118,149,211,29,137,38,194,78,223,138,72,40,33,131,193,177,121,154,49,177,113,157,62,229,56,233,107,237,129,46,157,193,70,150,242,227,100,
  105,11,247,57,161,228,96,220,230,13,195,129,184,54,130,189,85,139,29,22,111,179,119,12,218,78,55,82,242,211,83,84,115,149,105,166,230,72,196,238,11,69,212,50,172,26,238,182,99,106,177,167,29,39,79,188,111,112,0,99,79,203,85,144,158,11,65,177,79,77,218,
  152,113,93,180,109,176,187,95,121,70,90,57,127,90,150,245,93,219,100,76,42,79,179,181,217,221,131,113,56,196,9,138,180,33,6,58,125,236,145,99,182,184,221,27,65,61,232,198,80,84,133,238,246,80,188,207,78,239,109,233,113,178,171,174,53,208,4,149,54,152,
  12,71,106,151,197,227,161,17,118,130,6,202,75,51,179,133,124,71,25,26,200,106,223,186,97,21,101,167,251,28,137,205,100,108,110,38,215,230,102,252,64,109,33,247,230,150,230,166,166,22,178,32,57,161,133,19,240,192,7,219,230,150,14,228,97,133,15,183,205,
  210,212,218,129,212,214,14,28,125,155,59,80,184,67,86,36,58,200,236,224,114,248,104,101,181,149,92,29,45,172,91,16,56,46,59,216,138,99,210,221,209,42,205,46,150,176,119,54,145,191,243,88,71,40,232,60,206,58,120,85,76,154,22,12,6,71,245,186,52,125,110,
  154,94,159,166,207,75,211,231,167,233,11,210,244,133,105,250,34,232,89,74,111,138,132,250,18,148,51,46,24,82,97,232,56,65,151,220,33,25,141,184,36,203,214,80,151,29,161,140,144,62,218,105,98,168,167,231,248,71,0,101,134,180,255,38,72,116,81,62,31,252,
  203,7,147,201,168,179,33,142,102,236,30,114,119,69,241,56,0,41,15,68,114,119,203,179,156,60,221,242,200,234,33,23,238,12,161,56,101,117,115,152,138,226,132,93,150,228,135,209,83,153,114,229,67,123,60,228,36,122,163,241,1,202,225,27,3,142,226,132,204,
  141,138,212,197,1,21,69,7,241,60,169,59,110,135,146,199,134,64,14,205,100,245,132,123,123,73,216,228,178,249,76,165,64,47,14,228,227,102,77,44,31,105,231,90,51,57,135,60,99,201,213,43,69,118,239,216,137,219,67,89,242,137,163,86,115,15,77,194,214,24,87,
  91,83,90,98,217,209,137,227,46,108,153,50,85,174,66,222,168,186,54,148,216,142,54,38,176,97,236,246,164,111,74,148,3,51,135,37,172,147,29,79,80,6,63,178,11,146,151,53,157,41,155,119,43,143,181,61,60,96,203,86,86,219,225,190,254,36,21,64,149,39,76,122,
  31,57,55,54,111,168,13,193,80,229,86,91,89,246,73,206,55,162,167,156,230,236,49,3,202,121,240,180,49,180,243,244,148,178,149,178,88,137,70,147,92,49,249,240,208,54,2,151,25,104,195,86,14,119,219,148,11,203,38,39,204,139,206,67,144,189,57,250,250,32,7,
  184,57,60,234,187,92,102,11,86,35,186,179,61,186,221,118,228,132,170,103,153,41,98,227,164,137,69,66,35,77,241,16,134,106,33,245,116,249,185,149,68,63,149,96,189,224,127,227,22,96,117,148,91,201,211,41,177,216,134,208,32,187,172,111,212,176,209,78,192,
  185,71,45,203,71,189,155,114,148,5,103,220,202,232,78,108,156,209,199,77,49,42,28,125,144,231,223,234,112,79,15,122,171,155,89,27,69,27,178,204,56,67,60,212,151,170,83,26,80,141,174,83,222,58,169,64,63,216,113,222,3,218,81,50,250,67,9,229,154,197,253,
  112,162,182,104,175,94,209,120,116,64,77,12,178,160,180,116,100,171,63,138,72,43,194,228,133,35,172,151,193,59,65,102,120,96,128,242,248,93,36,28,138,172,8,197,18,107,177,32,148,163,13,109,118,100,149,211,51,154,142,71,248,69,28,123,66,222,82,218,71,
  98,54,101,75,245,108,117,99,161,12,52,182,57,20,25,196,54,15,227,196,216,110,163,177,68,179,147,72,134,112,106,34,53,177,62,22,194,17,74,19,195,137,246,40,142,176,85,195,49,108,109,233,212,171,156,16,86,176,7,117,39,244,106,146,103,187,61,178,130,251,
  83,188,253,4,47,51,57,169,132,182,126,158,81,87,68,6,174,28,248,128,29,231,238,173,195,181,130,172,136,221,155,36,119,196,118,250,146,253,228,214,93,181,28,118,18,143,99,239,92,199,74,134,147,10,17,217,78,250,182,116,71,187,56,214,64,246,246,38,108,204,
  98,52,210,211,47,63,119,82,126,212,73,189,253,172,144,49,167,135,10,198,76,43,237,68,50,30,29,97,239,25,51,106,15,75,43,153,114,177,73,99,166,182,208,144,157,154,52,181,17,211,242,203,21,24,95,69,91,50,26,139,193,84,140,208,32,251,113,212,37,19,157,119,
  224,96,59,41,39,154,254,182,64,185,209,113,49,157,178,163,142,220,17,50,92,80,102,212,73,121,119,142,84,215,14,70,146,225,24,175,139,124,132,135,102,240,81,33,139,34,71,91,248,92,59,21,20,81,147,90,95,89,147,59,170,86,221,163,228,217,40,55,136,40,159,
  68,204,114,197,164,119,123,99,161,56,114,202,88,145,19,27,231,227,217,49,29,100,240,226,52,76,229,177,104,108,48,114,194,240,46,226,228,137,171,215,80,170,140,219,125,236,39,241,19,191,161,82,89,220,30,192,136,213,44,172,119,142,58,219,92,113,25,40,77,
  94,247,220,4,135,212,209,247,67,202,198,179,156,75,246,90,42,78,127,106,86,99,151,59,137,139,165,93,227,101,177,214,148,119,82,9,158,142,251,2,71,19,18,169,128,185,41,156,22,1,39,29,215,204,247,231,16,14,205,132,10,161,210,159,115,18,227,66,167,55,245,
  24,81,125,218,18,142,68,214,69,147,210,43,178,19,216,60,169,96,133,130,120,26,141,36,200,204,254,166,250,133,219,33,146,225,108,99,143,37,9,213,155,230,177,182,244,72,45,121,250,88,201,254,112,130,220,252,57,45,168,101,29,172,124,22,153,168,9,42,79,68,
  198,96,178,119,145,60,7,196,16,185,134,100,4,241,72,177,190,151,44,126,49,162,60,254,76,247,177,76,54,180,71,55,37,108,242,13,29,115,114,12,133,227,201,193,80,68,31,107,222,161,177,169,16,59,73,12,147,49,28,4,117,96,46,168,7,243,72,140,208,205,150,65,
  87,27,158,220,142,106,186,221,18,215,26,158,114,35,235,89,99,184,124,155,73,207,138,146,223,173,161,239,91,198,94,3,246,92,122,200,18,151,8,79,249,147,198,185,229,71,76,186,84,204,170,254,186,139,214,208,147,150,121,173,145,216,233,201,125,164,130,126,
  109,8,66,93,141,244,123,131,60,115,58,77,227,93,145,243,85,83,188,45,10,106,134,63,48,233,98,97,108,107,20,249,249,225,70,35,81,238,162,70,145,229,38,122,210,80,61,48,22,108,53,214,236,172,166,39,12,113,35,55,119,180,124,22,85,230,30,160,23,149,104,52,
  191,34,254,36,30,20,158,57,198,179,212,96,124,32,118,26,207,136,157,195,198,31,207,59,184,87,24,46,239,178,234,198,154,198,198,83,58,77,218,37,188,231,155,226,66,49,191,241,142,41,166,249,180,8,138,226,9,193,201,166,241,164,48,68,126,177,203,48,78,67,
  87,92,194,101,186,189,198,236,219,92,94,55,185,133,219,112,155,179,102,25,67,115,92,198,44,35,49,135,22,170,46,44,52,110,52,246,75,197,98,229,38,227,230,241,214,81,197,149,74,190,133,31,175,21,198,94,241,142,240,228,222,110,210,243,66,132,59,233,214,
  99,44,187,121,88,95,43,163,33,136,53,244,27,211,184,193,184,149,203,190,98,193,64,123,121,90,233,57,147,63,191,98,25,131,231,65,126,98,138,65,136,55,165,64,201,203,44,86,46,41,163,15,76,149,225,171,210,64,239,170,124,95,51,197,91,88,189,53,107,170,59,
  214,116,212,208,5,226,124,89,234,78,211,184,194,120,0,61,185,100,82,53,29,20,98,47,212,189,162,40,47,64,151,26,198,227,252,88,190,199,152,80,110,12,148,27,121,13,53,107,108,99,176,229,12,99,164,133,190,103,152,143,139,221,50,221,200,191,216,136,151,95,
  211,185,109,175,233,186,220,48,106,237,37,116,167,46,155,187,39,80,118,13,125,211,116,125,249,41,113,169,241,158,56,23,29,185,222,180,174,55,190,37,94,20,47,32,253,228,61,29,116,151,108,117,142,17,188,216,104,43,95,99,102,36,140,86,211,253,47,134,185,
  93,20,228,77,145,8,51,243,135,194,8,11,127,206,218,74,87,102,216,157,9,171,16,174,76,35,187,220,56,179,156,30,52,197,117,152,171,128,41,246,24,65,225,47,50,178,231,160,191,21,38,237,17,213,147,93,36,149,217,83,93,244,90,112,22,29,48,197,51,104,151,94,
  54,197,176,39,55,92,70,239,10,113,25,10,63,106,210,143,69,121,205,182,53,195,231,76,220,67,198,20,113,133,81,18,48,42,141,168,229,127,90,20,231,26,211,96,40,243,20,139,226,101,197,222,226,85,197,70,241,236,98,75,229,170,144,185,12,228,90,61,154,63,207,
  152,202,249,69,201,100,165,24,37,229,37,21,100,8,203,123,69,64,248,171,46,220,101,29,42,155,41,246,150,11,113,8,236,158,44,196,46,78,22,217,134,184,34,80,189,107,151,245,84,69,141,56,92,65,166,155,114,185,132,240,215,162,204,129,41,98,111,224,117,254,
  248,152,63,246,85,10,227,110,240,124,37,185,75,39,229,251,225,207,126,245,111,62,50,127,92,137,44,79,76,199,199,65,254,248,144,63,246,205,192,199,125,252,241,212,12,235,34,131,4,144,50,243,208,12,145,249,173,42,183,182,253,163,20,2,47,104,20,135,170,
  132,184,110,166,16,7,102,154,226,137,153,197,226,32,244,15,193,254,89,66,220,7,30,5,127,5,183,205,22,226,65,240,20,56,8,14,204,193,20,128,253,213,66,28,6,127,174,17,226,245,90,97,221,26,20,214,129,32,210,130,46,177,175,94,136,91,231,25,226,0,120,121,
  158,252,222,57,253,255,19,228,247,254,66,253,237,11,127,63,157,250,251,23,254,222,58,245,55,48,169,255,219,225,191,131,225,239,172,119,145,250,91,24,55,141,253,61,140,233,83,105,252,255,21,34,160,126,23,185,31,186,59,160,242,240,239,116,9,159,250,125,
  101,254,61,46,35,160,218,229,191,159,49,117,126,254,93,42,43,160,254,255,129,127,231,138,116,89,249,187,96,62,221,215,122,162,255,5,139,0,30,118,228,51,0,0,0,0 };

//==============================================================================
#if JUCE_PUSH_NOTIFICATIONS && JUCE_MODULE_AVAILABLE_juce_gui_extra
 bool juce_handleNotificationIntent (void*);
 void juce_firebaseDeviceNotificationsTokenRefreshed (void*);
 void juce_firebaseRemoteNotificationReceived (void*);
 void juce_firebaseRemoteMessagesDeleted();
 void juce_firebaseRemoteMessageSent(void*);
 void juce_firebaseRemoteMessageSendError (void*, void*);
#endif

#if JUCE_IN_APP_PURCHASES && JUCE_MODULE_AVAILABLE_juce_product_unlocking
 void juce_handleOnResume();
#else
 static void juce_handleOnResume() {}
#endif

//==============================================================================
#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (create, "<init>", "(II)V")

DECLARE_JNI_CLASS (AndroidLayoutParams, "android/view/ViewGroup$LayoutParams")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (addView,          "addView",             "(Landroid/view/View;Landroid/view/ViewGroup$LayoutParams;)V") \
 METHOD (removeView,       "removeView",          "(Landroid/view/View;)V") \
 METHOD (updateViewLayout, "updateViewLayout",    "(Landroid/view/View;Landroid/view/ViewGroup$LayoutParams;)V")

DECLARE_JNI_CLASS (AndroidViewManager, "android/view/ViewManager")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (create,           "<init>",             "(IIIIIII)V") \
 FIELD  (gravity,          "gravity",            "I") \
 FIELD  (windowAnimations, "windowAnimations",   "I")

DECLARE_JNI_CLASS (AndroidWindowManagerLayoutParams, "android/view/WindowManager$LayoutParams")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 FIELD  (layoutInDisplayCutoutMode, "layoutInDisplayCutoutMode", "I")

DECLARE_JNI_CLASS_WITH_MIN_SDK (AndroidWindowManagerLayoutParams28, "android/view/WindowManager$LayoutParams", 28)
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (getDisplayCutout, "getDisplayCutout", "()Landroid/view/DisplayCutout;") \
 METHOD (consumeDisplayCutout, "consumeDisplayCutout", "()Landroid/view/WindowInsets;")

 DECLARE_JNI_CLASS_WITH_MIN_SDK (AndroidWindowInsets28, "android/view/WindowInsets", 28)
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (getInsets, "getInsets", "(I)Landroid/graphics/Insets;") \
 STATICFIELD (CONSUMED, "CONSUMED", "Landroid/view/WindowInsets;")

 DECLARE_JNI_CLASS_WITH_MIN_SDK (AndroidWindowInsets30, "android/view/WindowInsets", 30)
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (getSafeInsetBottom, "getSafeInsetBottom", "()I") \
 METHOD (getSafeInsetLeft,   "getSafeInsetLeft",   "()I") \
 METHOD (getSafeInsetRight,  "getSafeInsetRight",  "()I") \
 METHOD (getSafeInsetTop,    "getSafeInsetTop",    "()I")

 DECLARE_JNI_CLASS_WITH_MIN_SDK (AndroidDisplayCutout, "android/view/DisplayCutout", 28)
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 FIELD (bottom, "bottom", "I") \
 FIELD (left, "left", "I") \
 FIELD (right, "right", "I") \
 FIELD (top, "top", "I")

 DECLARE_JNI_CLASS_WITH_MIN_SDK (AndroidGraphicsInsets, "android/graphics/Insets", 29)
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 STATICMETHOD (ime, "ime", "()I") \
 STATICMETHOD (displayCutout, "displayCutout", "()I")

 DECLARE_JNI_CLASS_WITH_MIN_SDK (AndroidWindowInsetsType, "android/view/WindowInsets$Type", 30)
#undef JNI_CLASS_MEMBERS

//==============================================================================
namespace
{
    enum
    {
        SYSTEM_UI_FLAG_VISIBLE = 0,
        SYSTEM_UI_FLAG_LOW_PROFILE = 1,
        SYSTEM_UI_FLAG_HIDE_NAVIGATION = 2,
        SYSTEM_UI_FLAG_FULLSCREEN = 4,
        SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION = 512,
        SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN = 1024,
        SYSTEM_UI_FLAG_IMMERSIVE = 2048,
        SYSTEM_UI_FLAG_IMMERSIVE_STICKY = 4096
    };

    constexpr int fullScreenFlags = SYSTEM_UI_FLAG_HIDE_NAVIGATION | SYSTEM_UI_FLAG_FULLSCREEN | SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
    constexpr int FLAG_NOT_FOCUSABLE = 0x8;
}

//==============================================================================
static bool supportsDisplayCutout()
{
    return getAndroidSDKVersion() >= 28;
}

static BorderSize<int> androidDisplayCutoutToBorderSize (LocalRef<jobject> displayCutout, double displayScale)
{
    if (displayCutout == nullptr)
        return {};

    auto* env = getEnv();

    const auto getInset = [&] (jmethodID methodID)
    {
        return roundToInt (env->CallIntMethod (displayCutout, methodID) / displayScale);
    };

    return { getInset (AndroidDisplayCutout.getSafeInsetTop),
             getInset (AndroidDisplayCutout.getSafeInsetLeft),
             getInset (AndroidDisplayCutout.getSafeInsetBottom),
             getInset (AndroidDisplayCutout.getSafeInsetRight) };
}

static BorderSize<int> androidInsetsToBorderSize (LocalRef<jobject> insets, double displayScale)
{
    if (insets == nullptr)
        return {};

    auto* env = getEnv();

    const auto getInset = [&] (jfieldID fieldID)
    {
        return roundToInt (env->GetIntField (insets, fieldID) / displayScale);
    };

    return { getInset (AndroidGraphicsInsets.top),
             getInset (AndroidGraphicsInsets.left),
             getInset (AndroidGraphicsInsets.bottom),
             getInset (AndroidGraphicsInsets.right) };
}

class JuceInsets
{
    template <typename Display>
    static auto tieDisplay (Display& d) { return std::tie (d.safeAreaInsets, d.keyboardInsets); }

public:
    BorderSize<int> displayCutout, keyboard;

    static auto tie (      Displays::Display& d) { return tieDisplay (d); }
    static auto tie (const Displays::Display& d) { return tieDisplay (d); }

    auto tie() const { return std::tie (displayCutout, keyboard); }
};

static JuceInsets getInsetsFromAndroidWindowInsets (LocalRef<jobject> windowInsets, double scale)
{
    auto* env = getEnv();

    if (windowInsets == nullptr)
        return {};

    const auto displayCutout = [&]() -> BorderSize<int>
    {
        if (AndroidWindowInsets28.getDisplayCutout == nullptr)
            return {};

        const LocalRef<jobject> insets { env->CallObjectMethod (windowInsets, AndroidWindowInsets28.getDisplayCutout) };
        return androidDisplayCutoutToBorderSize (insets, scale);
    }();

    const auto keyboard = [&]() -> BorderSize<int>
    {
        if (AndroidWindowInsetsType.ime == nullptr || AndroidWindowInsets30.getInsets == nullptr)
            return {};

        const auto mask = env->CallStaticIntMethod (AndroidWindowInsetsType, AndroidWindowInsetsType.ime);
        const LocalRef<jobject> insets { env->CallObjectMethod (windowInsets, AndroidWindowInsets30.getInsets, mask) };
        return androidInsetsToBorderSize (insets, scale);
    }();

    return { displayCutout, keyboard };
}

/* The usage of the KeyPress class relies on its keyCode member having the standard ASCII values
   represent ASCII keycodes. However in the native Android keycodes the values for special keys
   e.g. RETURN, F1-F12 overlap with the ASCII range. Hence we need to translate them.
*/
static constexpr int translateAndroidKeyCode (int keyCode) noexcept
{
    switch (keyCode)
    {
        case 7:   return '0';
        case 8:   return '1';
        case 9:   return '2';
        case 10:  return '3';
        case 11:  return '4';
        case 12:  return '5';
        case 13:  return '6';
        case 14:  return '7';
        case 15:  return '8';
        case 16:  return '9';
        case 17:  return '*';
        case 18:  return '#';
        case 19:  return KeyPress::upKey;             // KEYCODE_DPAD_UP
        case 20:  return KeyPress::downKey;           // KEYCODE_DPAD_DOWN
        case 21:  return KeyPress::leftKey;           // KEYCODE_DPAD_LEFT
        case 22:  return KeyPress::rightKey;          // KEYCODE_DPAD_RIGHT
        case 29:  return 'A';
        case 30:  return 'B';
        case 31:  return 'C';
        case 32:  return 'D';
        case 33:  return 'E';
        case 34:  return 'F';
        case 35:  return 'G';
        case 36:  return 'H';
        case 37:  return 'I';
        case 38:  return 'J';
        case 39:  return 'K';
        case 40:  return 'L';
        case 41:  return 'M';
        case 42:  return 'N';
        case 43:  return 'O';
        case 44:  return 'P';
        case 45:  return 'Q';
        case 46:  return 'R';
        case 47:  return 'S';
        case 48:  return 'T';
        case 49:  return 'U';
        case 50:  return 'V';
        case 51:  return 'W';
        case 52:  return 'X';
        case 53:  return 'Y';
        case 54:  return 'Z';
        case 55:  return ',';
        case 56:  return '.';
        case 61:  return KeyPress::tabKey;            // KEYCODE_TAB
        case 62:  return KeyPress::spaceKey;          // KEYCODE_SPACE
        case 66:  return KeyPress::returnKey;         // KEYCODE_ENTER
        case 67:  return KeyPress::backspaceKey;      // KEYCODE_DEL
        case 68:  return '`';
        case 69:  return '-';
        case 70:  return '=';
        case 71:  return '[';
        case 72:  return ']';
        case 73:  return '\\';
        case 74:  return ';';
        case 75:  return '\'';
        case 76:  return '/';
        case 77:  return '@';
        case 81:  return '+';
        case 85:  return KeyPress::playKey;           // KEYCODE_MEDIA_PLAY_PAUSE
        case 86:  return KeyPress::stopKey;           // KEYCODE_MEDIA_STOP
        case 87:  return KeyPress::fastForwardKey;    // KEYCODE_MEDIA_NEXT
        case 88:  return KeyPress::rewindKey;         // KEYCODE_MEDIA_PREVIOUS
        case 92:  return KeyPress::pageUpKey;         // KEYCODE_PAGE_UP
        case 93:  return KeyPress::pageDownKey;       // KEYCODE_PAGE_DOWN
        case 111: return KeyPress::escapeKey;         // KEYCODE_ESCAPE
        case 112: return KeyPress::deleteKey;         // KEYCODE_FORWARD_DEL
        case 122: return KeyPress::homeKey;           // KEYCODE_MOVE_HOME
        case 123: return KeyPress::endKey;            // KEYCODE_MOVE_END
        case 124: return KeyPress::insertKey;         // KEYCODE_INSERT
        case 131: return KeyPress::F1Key;             // KEYCODE_F1
        case 132: return KeyPress::F2Key;             // KEYCODE_F2
        case 133: return KeyPress::F3Key;             // KEYCODE_F3
        case 134: return KeyPress::F4Key;             // KEYCODE_F4
        case 135: return KeyPress::F5Key;             // KEYCODE_F5
        case 136: return KeyPress::F6Key;             // KEYCODE_F6
        case 137: return KeyPress::F7Key;             // KEYCODE_F7
        case 138: return KeyPress::F8Key;             // KEYCODE_F8
        case 139: return KeyPress::F9Key;             // KEYCODE_F9
        case 140: return KeyPress::F10Key;            // KEYCODE_F10
        case 141: return KeyPress::F11Key;            // KEYCODE_F11
        case 142: return KeyPress::F12Key;            // KEYCODE_F12
        case 144: return '0';
        case 145: return '1';
        case 146: return '2';
        case 147: return '3';
        case 148: return '4';
        case 149: return '5';
        case 150: return '6';
        case 151: return '7';
        case 152: return '8';
        case 153: return '9';
        case 154: return '/';
        case 155: return '*';
        case 156: return '-';
        case 157: return '+';
        case 158: return '.';
        case 159: return ',';
        case 161: return '=';
        case 162: return '(';
        case 163: return ')';

        default:  return 0;
    }
}

static constexpr int translateAndroidKeyboardFlags (int javaFlags) noexcept
{
    constexpr int metaShiftOn = 0x1;
    constexpr int metaAltOn   = 0x02;
    constexpr int metaCtrlOn  = 0x1000;

    int flags = 0;

    if ((javaFlags & metaShiftOn) != 0) flags |= ModifierKeys::shiftModifier;
    if ((javaFlags & metaAltOn) != 0)   flags |= ModifierKeys::altModifier;
    if ((javaFlags & metaCtrlOn) != 0)  flags |= ModifierKeys::ctrlModifier;

    return flags;
}

//==============================================================================
class AndroidComponentPeer  : public ComponentPeer,
                              private Timer
{
public:
    AndroidComponentPeer (Component& comp, int windowStyleFlags, void* nativeViewHandle)
        : ComponentPeer (comp, windowStyleFlags)
    {
        auto* env = getEnv();

        // NB: must not put this in the initialiser list, as it invokes a callback,
        // which will fail if the peer is only half-constructed.
        view = GlobalRef (LocalRef<jobject> (env->NewObject (ComponentPeerView, ComponentPeerView.create,
                                                             getAppContext().get(), (jboolean) component.isOpaque(),
                                                             (jlong) this)));

        if (nativeViewHandle != nullptr)
        {
            viewGroupIsWindow = false;

            // we don't know if the user is holding on to a local ref to this, so
            // explicitly create a new one
            auto nativeView = LocalRef<jobject> (env->NewLocalRef (static_cast<jobject> (nativeViewHandle)));

            if (env->IsInstanceOf (nativeView.get(), AndroidActivity))
            {
                viewGroup = GlobalRef (nativeView);
                env->CallVoidMethod (viewGroup.get(), AndroidActivity.setContentView, view.get());
            }
            else if (env->IsInstanceOf (nativeView.get(), AndroidViewGroup))
            {
                viewGroup = GlobalRef (nativeView);
                LocalRef<jobject> layoutParams (env->NewObject (AndroidLayoutParams, AndroidLayoutParams.create, -2, -2));

                env->CallVoidMethod (view.get(), AndroidView.setLayoutParams, layoutParams.get());
                env->CallVoidMethod ((jobject) viewGroup.get(), AndroidViewGroup.addView, view.get());
            }
            else
            {
                // the native handle you passed as a second argument to Component::addToDesktop must
                // either be an Activity or a ViewGroup
                jassertfalse;
            }
        }
        else
        {
            viewGroupIsWindow = true;

            LocalRef<jobject> viewLayoutParams (env->NewObject (AndroidLayoutParams, AndroidLayoutParams.create, -2, -2));
            env->CallVoidMethod (view.get(), AndroidView.setLayoutParams, viewLayoutParams.get());

            auto physicalBounds = (comp.getBoundsInParent().toFloat() * scale).toNearestInt();

            view.callVoidMethod (AndroidView.layout,
                                 physicalBounds.getX(), physicalBounds.getY(), physicalBounds.getRight(), physicalBounds.getBottom());

            LocalRef<jobject> windowLayoutParams (env->NewObject (AndroidWindowManagerLayoutParams, AndroidWindowManagerLayoutParams.create,
                                                                  physicalBounds.getWidth(), physicalBounds.getHeight(),
                                                                  physicalBounds.getX(), physicalBounds.getY(),
                                                                  TYPE_APPLICATION, FLAG_NOT_TOUCH_MODAL | FLAG_LAYOUT_IN_SCREEN | FLAG_LAYOUT_NO_LIMITS | FLAG_NOT_FOCUSABLE,
                                                                  component.isOpaque() ? PIXEL_FORMAT_OPAQUE : PIXEL_FORMAT_TRANSPARENT));

            env->SetIntField (windowLayoutParams.get(), AndroidWindowManagerLayoutParams.gravity, GRAVITY_LEFT | GRAVITY_TOP);
            env->SetIntField (windowLayoutParams.get(), AndroidWindowManagerLayoutParams.windowAnimations, 0x01030000 /* android.R.style.Animation */);

            if (supportsDisplayCutout())
            {
                if (const auto fieldID = AndroidWindowManagerLayoutParams28.layoutInDisplayCutoutMode)
                    env->SetIntField (windowLayoutParams, fieldID, LAYOUT_IN_DISPLAY_CUTOUT_MODE_ALWAYS);
            }

            if (Desktop::getInstance().getKioskModeComponent() != nullptr)
                setNavBarsHidden (true);

            LocalRef<jobject> activity (getCurrentActivity());

            if (activity == nullptr)
                activity = getMainActivity();

            viewGroup = GlobalRef (LocalRef<jobject> (env->CallObjectMethod (activity.get(), AndroidContext.getSystemService, javaString ("window").get())));
            env->CallVoidMethod (viewGroup.get(), AndroidViewManager.addView, view.get(), windowLayoutParams.get());
        }

        if (supportsDisplayCutout())
        {
            if (const auto methodID = AndroidView23.setOnApplyWindowInsetsListener)
            {
                env->CallVoidMethod (view,
                                     methodID,
                                     CreateJavaInterface (new ViewWindowInsetsListener,
                                                          "android/view/View$OnApplyWindowInsetsListener").get());
            }
        }

        if (isFocused())
            handleFocusGain();
    }

    ~AndroidComponentPeer() override
    {
        stopTimer();

        auto* env = getEnv();

        env->CallVoidMethod (view, ComponentPeerView.clear);
        frontWindow = nullptr;

        GlobalRef localView (view);
        GlobalRef localViewGroup (viewGroup);

        callOnMessageThread ([env, localView, localViewGroup]
        {
            if (env->IsInstanceOf (localViewGroup.get(), AndroidActivity))
                env->CallVoidMethod (localViewGroup.get(), AndroidActivity.setContentView, nullptr);
            else
                env->CallVoidMethod (localViewGroup.get(), AndroidViewManager.removeView, localView.get());
        });
    }

    void* getNativeHandle() const override
    {
        return (void*) view.get();
    }

    void setVisible (bool shouldBeVisible) override
    {
        GlobalRef localView (view);

        callOnMessageThread ([localView, shouldBeVisible]
        {
            localView.callVoidMethod (ComponentPeerView.setVisible, shouldBeVisible);
        });
    }

    void setTitle (const String& title) override
    {
        view.callVoidMethod (ComponentPeerView.setViewName, javaString (title).get());
    }

    void setBounds (const Rectangle<int>& userRect, bool isNowFullScreen) override
    {
        auto bounds = (userRect.toFloat() * scale).toNearestInt();

        if (MessageManager::getInstance()->isThisTheMessageThread())
        {
            fullScreen = isNowFullScreen;

            view.callVoidMethod (AndroidView.layout,
                                 bounds.getX(), bounds.getY(), bounds.getRight(), bounds.getBottom());

            if (viewGroup != nullptr && viewGroupIsWindow)
            {
                auto* env = getEnv();

                LocalRef<jobject> windowLayoutParams (env->NewObject (AndroidWindowManagerLayoutParams, AndroidWindowManagerLayoutParams.create,
                                                                      bounds.getWidth(), bounds.getHeight(), bounds.getX(), bounds.getY(),
                                                                      TYPE_APPLICATION, FLAG_NOT_TOUCH_MODAL | FLAG_LAYOUT_IN_SCREEN | FLAG_LAYOUT_NO_LIMITS,
                                                                      component.isOpaque() ? PIXEL_FORMAT_OPAQUE : PIXEL_FORMAT_TRANSPARENT));

                env->SetIntField (windowLayoutParams.get(), AndroidWindowManagerLayoutParams.gravity, GRAVITY_LEFT | GRAVITY_TOP);
                env->CallVoidMethod (viewGroup.get(), AndroidViewManager.updateViewLayout, view.get(), windowLayoutParams.get());
            }
        }
        else
        {
            GlobalRef localView (view);

            MessageManager::callAsync ([localView, bounds]
            {
                localView.callVoidMethod (AndroidView.layout,
                                          bounds.getX(), bounds.getY(), bounds.getRight(), bounds.getBottom());
            });
        }
    }

    Rectangle<int> getBounds() const override
    {
        Rectangle<int> bounds (view.callIntMethod (AndroidView.getLeft),
                               view.callIntMethod (AndroidView.getTop),
                               view.callIntMethod (AndroidView.getWidth),
                               view.callIntMethod (AndroidView.getHeight));

        return (bounds.toFloat() / scale).toNearestInt();
    }

    void handleScreenSizeChange() override
    {
        ComponentPeer::handleScreenSizeChange();

        if (isFullScreen())
            setFullScreen (true);
    }

    Point<int> getScreenPosition() const
    {
        auto* env = getEnv();

        LocalRef<jintArray> position (env->NewIntArray (2));
        env->CallVoidMethod (view.get(), AndroidView.getLocationOnScreen, position.get());

        jint* const screenPosition = env->GetIntArrayElements (position.get(), nullptr);
        Point<int> pos (screenPosition[0], screenPosition[1]);
        env->ReleaseIntArrayElements (position.get(), screenPosition, 0);

        return pos;
    }

    Point<float> localToGlobal (Point<float> relativePosition) override
    {
        return relativePosition + (getScreenPosition().toFloat() / scale);
    }

    using ComponentPeer::localToGlobal;

    Point<float> globalToLocal (Point<float> screenPosition) override
    {
        return screenPosition - (getScreenPosition().toFloat() / scale);
    }

    using ComponentPeer::globalToLocal;

    void setMinimised (bool /*shouldBeMinimised*/) override
    {
        // n/a
    }

    bool isMinimised() const override
    {
        return false;
    }

    void setFullScreen (bool shouldBeFullScreen) override
    {
        if (shouldNavBarsBeHidden (shouldBeFullScreen))
        {
            if (isTimerRunning())
                return;

            startTimer (100);
        }
        else
        {
            setNavBarsHidden (false);
        }

        auto newBounds = [&]
        {
            if (navBarsHidden || shouldBeFullScreen)
                if (auto* display = Desktop::getInstance().getDisplays().getPrimaryDisplay())
                    return shouldNavBarsBeHidden (shouldBeFullScreen) ?
                        display->totalArea : display->userArea;

            return lastNonFullscreenBounds.isEmpty() ? getBounds() : lastNonFullscreenBounds;
        }();

        if (! newBounds.isEmpty())
            setBounds (newBounds, shouldBeFullScreen);

        component.repaint();
    }

    bool isFullScreen() const override
    {
        return fullScreen;
    }

    void setIcon (const Image& /*newIcon*/) override
    {
        // n/a
    }

    bool contains (Point<int> localPos, bool trueIfInAChildWindow) const override
    {
        return isPositiveAndBelow (localPos.x, component.getWidth())
            && isPositiveAndBelow (localPos.y, component.getHeight())
            && ((! trueIfInAChildWindow) || view.callBooleanMethod (ComponentPeerView.containsPoint,
                                                                    (float) localPos.x * scale,
                                                                    (float) localPos.y * scale));
    }

    OptionalBorderSize getFrameSizeIfPresent() const override
    {
        // TODO
        return {};
    }

    BorderSize<int> getFrameSize() const override
    {
        // TODO
        return {};
    }

    bool setAlwaysOnTop (bool /*alwaysOnTop*/) override
    {
        // TODO
        return false;
    }

    void toFront (bool makeActive) override
    {
        // Avoid calling bringToFront excessively: it's very slow
        if (frontWindow != this)
        {
            view.callVoidMethod (AndroidView.bringToFront);
            frontWindow = this;
        }

        if (makeActive)
            grabFocus();

        handleBroughtToFront();
    }

    void toBehind (ComponentPeer*) override
    {
        // TODO
    }

    //==============================================================================
    void handleMouseDownCallback (int index, Point<float> sysPos, int64 time)
    {
        lastMousePos = sysPos / scale;
        auto pos = globalToLocal (lastMousePos);

        // this forces a mouse-enter/up event, in case for some reason we didn't get a mouse-up before.
        handleMouseEvent (MouseInputSource::InputSourceType::touch,
                          pos,
                          ModifierKeys::currentModifiers.withoutMouseButtons(),
                          MouseInputSource::defaultPressure,
                          MouseInputSource::defaultOrientation,
                          time,
                          {},
                          index);

        if (isValidPeer (this))
            handleMouseDragCallback (index, sysPos, time);
    }

    void handleMouseDragCallback (int index, Point<float> sysPos, int64 time)
    {
        lastMousePos = sysPos / scale;
        auto pos = globalToLocal (lastMousePos);

        jassert (index < 64);
        touchesDown = (touchesDown | (1 << (index & 63)));

        ModifierKeys::currentModifiers = ModifierKeys::currentModifiers.withoutMouseButtons().withFlags (ModifierKeys::leftButtonModifier);

        handleMouseEvent (MouseInputSource::InputSourceType::touch,
                          pos,
                          ModifierKeys::currentModifiers.withoutMouseButtons().withFlags (ModifierKeys::leftButtonModifier),
                          MouseInputSource::defaultPressure,
                          MouseInputSource::defaultOrientation,
                          time,
                          {},
                          index);
    }

    void handleMouseUpCallback (int index, Point<float> sysPos, int64 time)
    {
        lastMousePos = sysPos / scale;
        auto pos = globalToLocal (lastMousePos);

        jassert (index < 64);
        touchesDown = (touchesDown & ~(1 << (index & 63)));

        if (touchesDown == 0)
            ModifierKeys::currentModifiers = ModifierKeys::currentModifiers.withoutMouseButtons();

        handleMouseEvent (MouseInputSource::InputSourceType::touch,
                          pos,
                          ModifierKeys::currentModifiers.withoutMouseButtons(),
                          MouseInputSource::defaultPressure,
                          MouseInputSource::defaultOrientation,
                          time,
                          {},
                          index);
    }

    void handleAccessibilityHoverCallback (int command, Point<float> sysPos, int64)
    {
        enum
        {
            TYPE_VIEW_HOVER_ENTER = 0x00000080,
            TYPE_VIEW_HOVER_EXIT  = 0x00000100,

            ACTION_HOVER_ENTER    = 0x00000009,
            ACTION_HOVER_MOVE     = 0x00000007,
            ACTION_HOVER_EXIT     = 0x0000000a
        };

        if (auto* topHandler = component.getAccessibilityHandler())
        {
            if (auto* virtualHandler = topHandler->getChildAt ((sysPos / scale).roundToInt()))
            {
                switch (command)
                {
                    case ACTION_HOVER_ENTER:
                    case ACTION_HOVER_MOVE:
                        AccessibilityNativeHandle::sendAccessibilityEventImpl (*virtualHandler, TYPE_VIEW_HOVER_ENTER, 0);
                        break;

                    case ACTION_HOVER_EXIT:
                        AccessibilityNativeHandle::sendAccessibilityEventImpl (*virtualHandler, TYPE_VIEW_HOVER_EXIT, 0);
                        break;
                }
            }
        }
    }

    void handleKeyDownCallback (int k, int kc, int kbFlags)
    {
        ModifierKeys::currentModifiers = ModifierKeys::currentModifiers.withOnlyMouseButtons()
                                                                       .withFlags (translateAndroidKeyboardFlags (kbFlags));
        handleKeyPress (translateAndroidKeyCode (k), static_cast<juce_wchar> (kc));
    }

    void handleKeyUpCallback (int /*k*/, int /*kc*/)
    {
    }

    void handleBackButtonCallback()
    {
        bool handled = false;

        if (auto* app = JUCEApplicationBase::getInstance())
            handled = app->backButtonPressed();

        if (isKioskModeComponent())
            setNavBarsHidden (navBarsHidden);

        if (! handled)
        {
            auto* env = getEnv();
            LocalRef<jobject> activity (getCurrentActivity());

            if (activity != nullptr)
            {
                if (const auto finishMethod = AndroidActivity.finish)
                    env->CallVoidMethod (activity.get(), finishMethod);
            }
        }
    }

    void handleKeyboardHiddenCallback()
    {
        Component::unfocusAllComponents();
    }

    void handleAppPausedCallback() {}

    void handleAppResumedCallback()
    {
        if (isKioskModeComponent())
            setNavBarsHidden (navBarsHidden);
    }

    //==============================================================================
    AccessibilityNativeHandle* getNativeHandleForViewId (jint virtualViewId) const
    {
        if (auto* handler = (virtualViewId == HOST_VIEW_ID
                                 ? component.getAccessibilityHandler()
                                 : AccessibilityNativeHandle::getAccessibilityHandlerForVirtualViewId (virtualViewId)))
        {
            return handler->getNativeImplementation();
        }

        return nullptr;
    }

    jboolean populateAccessibilityNodeInfoCallback (jint virtualViewId, jobject info) const
    {
        if (auto* handle = getNativeHandleForViewId (virtualViewId))
        {
            handle->populateNodeInfo (info);
            return true;
        }

        return false;
    }

    jboolean handlePerformActionCallback (jint virtualViewId, jint action, jobject arguments) const
    {
        if (auto* handle = getNativeHandleForViewId (virtualViewId))
            return handle->performAction (action, arguments);

        return false;
    }

    static jobject getFocusViewIdForHandler (const AccessibilityHandler* handler)
    {
        if (handler != nullptr)
            return getEnv()->NewObject (JavaInteger,
                                        JavaInteger.constructor,
                                        handler->getNativeImplementation()->getVirtualViewId());

        return nullptr;
    }

    jobject getInputFocusViewIdCallback()
    {
        if (auto* comp = dynamic_cast<Component*> (findCurrentTextInputTarget()))
            return getFocusViewIdForHandler (comp->getAccessibilityHandler());

        return nullptr;
    }

    jobject getAccessibilityFocusViewIdCallback() const
    {
        if (auto* handler = component.getAccessibilityHandler())
        {
            if (auto* modal = Component::getCurrentlyModalComponent())
            {
                if (! component.isParentOf (modal)
                     && component.isCurrentlyBlockedByAnotherModalComponent())
                {
                    if (auto* modalHandler = modal->getAccessibilityHandler())
                    {
                        if (auto* focusChild = modalHandler->getChildFocus())
                            return getFocusViewIdForHandler (focusChild);

                        return getFocusViewIdForHandler (modalHandler);
                    }
                }
            }

            if (auto* focusChild = handler->getChildFocus())
                return getFocusViewIdForHandler (focusChild);
        }

        return nullptr;
    }

    //==============================================================================
    bool isFocused() const override
    {
        if (view != nullptr)
            return view.callBooleanMethod (AndroidView.hasFocus);

        return false;
    }

    void grabFocus() override
    {
        if (view != nullptr)
            view.callBooleanMethod (AndroidView.requestFocus);
    }

    void handleFocusChangeCallback (bool hasFocus)
    {
        if (isFullScreen())
            setFullScreen (true);

        if (hasFocus)
            handleFocusGain();
        else
            handleFocusLoss();
    }

    static const char* getVirtualKeyboardType (TextInputTarget::VirtualKeyboardType type) noexcept
    {
        switch (type)
        {
            case TextInputTarget::textKeyboard:          return "text";
            case TextInputTarget::numericKeyboard:       return "number";
            case TextInputTarget::decimalKeyboard:       return "numberDecimal";
            case TextInputTarget::urlKeyboard:           return "textUri";
            case TextInputTarget::emailAddressKeyboard:  return "textEmailAddress";
            case TextInputTarget::phoneNumberKeyboard:   return "phone";
            default:                                     jassertfalse; break;
        }

        return "text";
    }

    void textInputRequired (Point<int>, TextInputTarget& target) override
    {
        view.callVoidMethod (ComponentPeerView.showKeyboard,
                             javaString (getVirtualKeyboardType (target.getKeyboardType())).get());
    }

    void dismissPendingTextInput() override
    {
        closeInputMethodContext();

        view.callVoidMethod (ComponentPeerView.showKeyboard, javaString ("").get());

        if (! isTimerRunning())
            startTimer (500);
    }

    //==============================================================================
    void handlePaintCallback (jobject canvas, jobject paint)
    {
        auto* env = getEnv();

        jobject rect = env->CallObjectMethod (canvas, AndroidCanvas.getClipBounds);
        auto left   = env->GetIntField (rect, AndroidRect.left);
        auto top    = env->GetIntField (rect, AndroidRect.top);
        auto right  = env->GetIntField (rect, AndroidRect.right);
        auto bottom = env->GetIntField (rect, AndroidRect.bottom);
        env->DeleteLocalRef (rect);

        auto clip = Rectangle<int>::leftTopRightBottom (left, top, right, bottom);

        if (clip.isEmpty())
            return;

        auto sizeNeeded = clip.getWidth() * clip.getHeight();

        if (sizeAllocated < sizeNeeded)
        {
            buffer.clear();
            sizeAllocated = sizeNeeded;
            buffer = GlobalRef (LocalRef<jobject> ((jobject) env->NewIntArray (sizeNeeded)));
        }

        if (jint* dest = env->GetIntArrayElements ((jintArray) buffer.get(), nullptr))
        {
            {
                Image temp (new PreallocatedImage (clip.getWidth(), clip.getHeight(),
                                                   dest, ! component.isOpaque()));

                {
                    LowLevelGraphicsSoftwareRenderer g (temp);
                    g.setOrigin (-clip.getPosition());
                    g.addTransform (AffineTransform::scale (scale));
                    handlePaint (g);
                }
            }

            env->ReleaseIntArrayElements ((jintArray) buffer.get(), dest, 0);

            env->CallVoidMethod (canvas, AndroidCanvas.drawBitmap, (jintArray) buffer.get(), 0, clip.getWidth(),
                                 (jfloat) clip.getX(), (jfloat) clip.getY(),
                                 clip.getWidth(), clip.getHeight(), true, paint);
        }
    }

    void repaint (const Rectangle<int>& userArea) override
    {
        auto area = (userArea.toFloat() * scale).toNearestInt();

        GlobalRef localView (view);

        callOnMessageThread ([area, localView]
        {
            localView.callVoidMethod (AndroidView.invalidate,
                                      area.getX(), area.getY(), area.getRight(), area.getBottom());
        });
    }

    void performAnyPendingRepaintsNow() override
    {
        // TODO
    }

    void setAlpha (float /*newAlpha*/) override
    {
        // TODO
    }

    StringArray getAvailableRenderingEngines() override
    {
        return StringArray ("Software Renderer");
    }

    //==============================================================================
    static Point<float> lastMousePos;
    static int64 touchesDown;

    //==============================================================================
    struct StartupActivityCallbackListener  : public ActivityLifecycleCallbacks
    {
        void onActivityStarted (jobject /*activity*/) override
        {
            auto* env = getEnv();
            LocalRef<jobject> appContext (getAppContext());

            if (appContext.get() != nullptr)
            {
                env->CallVoidMethod (appContext.get(),
                                     AndroidApplication.unregisterActivityLifecycleCallbacks,
                                     activityCallbackListener.get());
                clear();
                activityCallbackListener.clear();

                forceDisplayUpdate();
            }
        }
    };

private:
    //==============================================================================
    #define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
     METHOD   (create,                           "<init>",                        "(Landroid/content/Context;ZJ)V") \
     METHOD   (clear,                            "clear",                         "()V") \
     METHOD   (setViewName,                      "setViewName",                   "(Ljava/lang/String;)V") \
     METHOD   (setVisible,                       "setVisible",                    "(Z)V") \
     METHOD   (isVisible,                        "isVisible",                     "()Z") \
     METHOD   (containsPoint,                    "containsPoint",                 "(II)Z") \
     METHOD   (showKeyboard,                     "showKeyboard",                  "(Ljava/lang/String;)V") \
     METHOD   (setSystemUiVisibilityCompat,      "setSystemUiVisibilityCompat",   "(I)V") \
     CALLBACK (handlePaintJni,                   "handlePaint",                   "(JLandroid/graphics/Canvas;Landroid/graphics/Paint;)V") \
     CALLBACK (handleMouseDownJni,               "handleMouseDown",               "(JIFFJ)V") \
     CALLBACK (handleMouseDragJni,               "handleMouseDrag",               "(JIFFJ)V") \
     CALLBACK (handleMouseUpJni,                 "handleMouseUp",                 "(JIFFJ)V") \
     CALLBACK (handleAccessibleHoverJni,         "handleAccessibilityHover",      "(JIFFJ)V") \
     CALLBACK (handleKeyDownJni,                 "handleKeyDown",                 "(JIII)V") \
     CALLBACK (handleKeyUpJni,                   "handleKeyUp",                   "(JII)V") \
     CALLBACK (handleBackButtonJni,              "handleBackButton",              "(J)V") \
     CALLBACK (handleKeyboardHiddenJni,          "handleKeyboardHidden",          "(J)V") \
     CALLBACK (viewSizeChangedJni,               "viewSizeChanged",               "(J)V") \
     CALLBACK (focusChangedJni,                  "focusChanged",                  "(JZ)V") \
     CALLBACK (handleAppPausedJni,               "handleAppPaused",               "(J)V") \
     CALLBACK (handleAppResumedJni,              "handleAppResumed",              "(J)V") \
     CALLBACK (populateAccessibilityNodeInfoJni, "populateAccessibilityNodeInfo", "(JILandroid/view/accessibility/AccessibilityNodeInfo;)Z") \
     CALLBACK (handlePerformActionJni,           "handlePerformAction",           "(JIILandroid/os/Bundle;)Z") \
     CALLBACK (getInputFocusViewIdJni,           "getInputFocusViewId",           "(J)Ljava/lang/Integer;") \
     CALLBACK (getAccessibilityFocusViewIdJni,   "getAccessibilityFocusViewId",   "(J)Ljava/lang/Integer;") \

    DECLARE_JNI_CLASS_WITH_BYTECODE (ComponentPeerView, "com/rmsl/juce/ComponentPeerView", 16, javaComponentPeerView, sizeof (javaComponentPeerView))
    #undef JNI_CLASS_MEMBERS

    static void JNICALL handlePaintJni          (JNIEnv*, jobject /*view*/, jlong host, jobject canvas, jobject paint)           { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handlePaintCallback (canvas, paint); }
    static void JNICALL handleMouseDownJni      (JNIEnv*, jobject /*view*/, jlong host, jint i, jfloat x, jfloat y, jlong time)  { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleMouseDownCallback (i, Point<float> ((float) x, (float) y), (int64) time); }
    static void JNICALL handleMouseDragJni      (JNIEnv*, jobject /*view*/, jlong host, jint i, jfloat x, jfloat y, jlong time)  { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleMouseDragCallback (i, Point<float> ((float) x, (float) y), (int64) time); }
    static void JNICALL handleMouseUpJni        (JNIEnv*, jobject /*view*/, jlong host, jint i, jfloat x, jfloat y, jlong time)  { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleMouseUpCallback   (i, Point<float> ((float) x, (float) y), (int64) time); }
    static void JNICALL handleAccessibleHoverJni(JNIEnv*, jobject /*view*/, jlong host, jint c, jfloat x, jfloat y, jlong time)  { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleAccessibilityHoverCallback ((int) c, Point<float> ((float) x, (float) y), (int64) time); }
    static void JNICALL viewSizeChangedJni      (JNIEnv*, jobject /*view*/, jlong host)                                          { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleMovedOrResized(); }
    static void JNICALL focusChangedJni         (JNIEnv*, jobject /*view*/, jlong host, jboolean hasFocus)                       { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleFocusChangeCallback (hasFocus); }
    static void JNICALL handleKeyDownJni        (JNIEnv*, jobject /*view*/, jlong host, jint k, jint kc, jint kbFlags)           { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleKeyDownCallback ((int) k, (int) kc, (int) kbFlags); }
    static void JNICALL handleKeyUpJni          (JNIEnv*, jobject /*view*/, jlong host, jint k, jint kc)                         { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleKeyUpCallback ((int) k, (int) kc); }
    static void JNICALL handleBackButtonJni     (JNIEnv*, jobject /*view*/, jlong host)                                          { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleBackButtonCallback(); }
    static void JNICALL handleKeyboardHiddenJni (JNIEnv*, jobject /*view*/, jlong host)                                          { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleKeyboardHiddenCallback(); }
    static void JNICALL handleAppPausedJni      (JNIEnv*, jobject /*view*/, jlong host)                                          { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleAppPausedCallback(); }
    static void JNICALL handleAppResumedJni     (JNIEnv*, jobject /*view*/, jlong host)                                          { if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host)) myself->handleAppResumedCallback(); }

    static jboolean JNICALL populateAccessibilityNodeInfoJni (JNIEnv*, jobject /*view*/, jlong host, jint virtualViewId, jobject info)
    {
        if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host))
            return myself->populateAccessibilityNodeInfoCallback (virtualViewId, info);

        return false;
    }

    static jboolean JNICALL handlePerformActionJni (JNIEnv*, jobject /*view*/, jlong host, jint virtualViewId, jint action, jobject arguments)
    {
        if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host))
            return myself->handlePerformActionCallback (virtualViewId, action, arguments);

        return false;
    }

    static jobject JNICALL getInputFocusViewIdJni (JNIEnv*, jobject /*view*/, jlong host)
    {
        if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host))
            return myself->getInputFocusViewIdCallback();

        return nullptr;
    }

    static jobject JNICALL getAccessibilityFocusViewIdJni (JNIEnv*, jobject /*view*/, jlong host)
    {
        if (auto* myself = reinterpret_cast<AndroidComponentPeer*> (host))
            return myself->getAccessibilityFocusViewIdCallback();

        return nullptr;
    }

    //==============================================================================
    class ViewWindowInsetsListener  : public juce::AndroidInterfaceImplementer
    {
    public:
        jobject onApplyWindowInsets (LocalRef<jobject>, LocalRef<jobject> insets)
        {
            auto* env = getEnv();

            const auto& mainDisplay = *Desktop::getInstance().getDisplays().getPrimaryDisplay();
            const auto newInsets = getInsetsFromAndroidWindowInsets (insets, mainDisplay.scale);

            if (newInsets.tie() != JuceInsets::tie (mainDisplay))
                forceDisplayUpdate();

            if (const auto fieldId = AndroidWindowInsets30.CONSUMED)
                return env->GetStaticObjectField (AndroidWindowInsets30, fieldId);

            return env->CallObjectMethod (insets, AndroidWindowInsets28.consumeDisplayCutout);
        }

    private:
        jobject invoke (jobject proxy, jobject method, jobjectArray args) override
        {
            auto* env = getEnv();
            auto methodName = juce::juceString ((jstring) env->CallObjectMethod (method, JavaMethod.getName));

            if (methodName == "onApplyWindowInsets")
            {
                jassert (env->GetArrayLength (args) == 2);

                LocalRef<jobject> windowView (env->GetObjectArrayElement (args, 0));
                LocalRef<jobject> insets     (env->GetObjectArrayElement (args, 1));

                return onApplyWindowInsets (std::move (windowView), std::move (insets));
            }

            // invoke base class
            return AndroidInterfaceImplementer::invoke (proxy, method, args);
        }
    };

    //==============================================================================
    struct PreallocatedImage  : public ImagePixelData
    {
        PreallocatedImage (int width_, int height_, jint* data_, bool hasAlpha_)
            : ImagePixelData (Image::ARGB, width_, height_), data (data_), hasAlpha (hasAlpha_)
        {
            if (hasAlpha_)
                zeromem (data_, static_cast<size_t> (width * height) * sizeof (jint));
        }

        ~PreallocatedImage() override
        {
            if (hasAlpha)
            {
                auto pix = (PixelARGB*) data;

                for (int i = width * height; --i >= 0;)
                {
                    pix->unpremultiply();
                    ++pix;
                }
            }
        }

        std::unique_ptr<ImageType> createType() const override
        {
            return std::make_unique<SoftwareImageType>();
        }

        std::unique_ptr<LowLevelGraphicsContext> createLowLevelContext() override
        {
            return std::make_unique<LowLevelGraphicsSoftwareRenderer> (Image (this));
        }

        void initialiseBitmapData (Image::BitmapData& bm, int x, int y, Image::BitmapData::ReadWriteMode /*mode*/) override
        {
            bm.lineStride = width * static_cast<int> (sizeof (jint));
            bm.pixelStride = static_cast<int> (sizeof (jint));
            bm.pixelFormat = Image::ARGB;
            const auto offset = (size_t) x + (size_t) y * (size_t) width;
            bm.data = (uint8*) (data + offset);
            bm.size = sizeof (jint) * (((size_t) height * (size_t) width) - offset);
        }

        ImagePixelData::Ptr clone() override
        {
            auto s = new PreallocatedImage (width, height, nullptr, hasAlpha);
            s->allocatedData.malloc (sizeof (jint) * static_cast<size_t> (width * height));
            s->data = s->allocatedData;
            memcpy (s->data, data, sizeof (jint) * static_cast<size_t> (width * height));
            return s;
        }

    private:
        jint* data;
        HeapBlock<jint> allocatedData;
        bool hasAlpha;

        JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (PreallocatedImage)
    };

    //==============================================================================
    void timerCallback() override
    {
        setNavBarsHidden (shouldNavBarsBeHidden (fullScreen));
        setFullScreen (fullScreen);
        stopTimer();
    }

    bool isKioskModeComponent() const
    {
        if (auto* kiosk = Desktop::getInstance().getKioskModeComponent())
            return kiosk->getPeer() == this;

        return false;
    }

    bool shouldNavBarsBeHidden (bool shouldBeFullScreen) const
    {
        return (shouldBeFullScreen && isKioskModeComponent());
    }

    void setNavBarsHidden (bool hidden)
    {
        if (navBarsHidden != hidden)
        {
            navBarsHidden = hidden;

            view.callVoidMethod (ComponentPeerView.setSystemUiVisibilityCompat,
                                 (navBarsHidden ? (jint) (fullScreenFlags) : (jint) (SYSTEM_UI_FLAG_VISIBLE)));
        }
    }

    template <typename Callback>
    static void callOnMessageThread (Callback&& callback)
    {
        if (MessageManager::getInstance()->isThisTheMessageThread())
            callback();
        else
            MessageManager::callAsync (std::forward<Callback> (callback));
    }

    //==============================================================================
    friend class Displays;
    static AndroidComponentPeer* frontWindow;
    static GlobalRef activityCallbackListener;

    static constexpr int GRAVITY_LEFT = 0x3, GRAVITY_TOP = 0x30;
    static constexpr int TYPE_APPLICATION = 0x2;
    static constexpr int FLAG_NOT_TOUCH_MODAL = 0x20, FLAG_LAYOUT_IN_SCREEN = 0x100, FLAG_LAYOUT_NO_LIMITS = 0x200;
    static constexpr int PIXEL_FORMAT_OPAQUE = -1, PIXEL_FORMAT_TRANSPARENT = -2;
    static constexpr int LAYOUT_IN_DISPLAY_CUTOUT_MODE_ALWAYS = 0x3;

    GlobalRef view, viewGroup, buffer;
    bool viewGroupIsWindow = false, fullScreen = false, navBarsHidden = false;
    int sizeAllocated = 0;
    float scale = (float) Desktop::getInstance().getDisplays().getPrimaryDisplay()->scale;

    //==============================================================================
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (AndroidComponentPeer)
};

Point<float> AndroidComponentPeer::lastMousePos;
int64 AndroidComponentPeer::touchesDown = 0;
AndroidComponentPeer* AndroidComponentPeer::frontWindow = nullptr;
GlobalRef AndroidComponentPeer::activityCallbackListener;
AndroidComponentPeer::ComponentPeerView_Class AndroidComponentPeer::ComponentPeerView;

//==============================================================================
ComponentPeer* Component::createNewPeer (int styleFlags, void* nativeWindow)
{
    return new AndroidComponentPeer (*this, styleFlags, nativeWindow);
}

//==============================================================================
bool Desktop::canUseSemiTransparentWindows() noexcept
{
    return true;
}

class Desktop::NativeDarkModeChangeDetectorImpl  : public ActivityLifecycleCallbacks
{
public:
    NativeDarkModeChangeDetectorImpl()
    {
        LocalRef<jobject> appContext (getAppContext());

        if (appContext != nullptr)
        {
            auto* env = getEnv();

            myself = GlobalRef (CreateJavaInterface (this, "android/app/Application$ActivityLifecycleCallbacks"));
            env->CallVoidMethod (appContext.get(), AndroidApplication.registerActivityLifecycleCallbacks, myself.get());
        }
    }

    ~NativeDarkModeChangeDetectorImpl() override
    {
        LocalRef<jobject> appContext (getAppContext());

        if (appContext != nullptr && myself != nullptr)
        {
            auto* env = getEnv();

            env->CallVoidMethod (appContext.get(),
                                 AndroidApplication.unregisterActivityLifecycleCallbacks,
                                 myself.get());
            clear();
            myself.clear();
        }
    }

    bool isDarkModeEnabled() const noexcept  { return darkModeEnabled; }

    void onActivityStarted (jobject /*activity*/) override
    {
        const auto isEnabled = getDarkModeSetting();

        if (darkModeEnabled != isEnabled)
        {
            darkModeEnabled = isEnabled;
            Desktop::getInstance().darkModeChanged();
        }
    }

private:
    static bool getDarkModeSetting()
    {
        auto* env = getEnv();

        const LocalRef<jobject> resources (env->CallObjectMethod (getAppContext().get(), AndroidContext.getResources));
        const LocalRef<jobject> configuration (env->CallObjectMethod (resources, AndroidResources.getConfiguration));

        const auto uiMode = env->GetIntField (configuration, AndroidConfiguration.uiMode);

        return ((uiMode & UI_MODE_NIGHT_MASK) == UI_MODE_NIGHT_YES);
    }

    static constexpr int UI_MODE_NIGHT_MASK      = 0x00000030,
                         UI_MODE_NIGHT_NO        = 0x00000010,
                         UI_MODE_NIGHT_UNDEFINED = 0x00000000,
                         UI_MODE_NIGHT_YES       = 0x00000020;

    GlobalRef myself;
    bool darkModeEnabled = getDarkModeSetting();

    //==============================================================================
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (NativeDarkModeChangeDetectorImpl)
};

std::unique_ptr<Desktop::NativeDarkModeChangeDetectorImpl> Desktop::createNativeDarkModeChangeDetectorImpl()
{
    return std::make_unique<NativeDarkModeChangeDetectorImpl>();
}

bool Desktop::isDarkModeActive() const
{
    return nativeDarkModeChangeDetectorImpl->isDarkModeEnabled();
}

double Desktop::getDefaultMasterScale()
{
    return 1.0;
}

Desktop::DisplayOrientation Desktop::getCurrentOrientation() const
{
    enum
    {
        ROTATION_0   = 0,
        ROTATION_90  = 1,
        ROTATION_180 = 2,
        ROTATION_270 = 3
    };

    JNIEnv* env = getEnv();
    LocalRef<jstring> windowServiceString (javaString ("window"));


    LocalRef<jobject> windowManager = LocalRef<jobject> (env->CallObjectMethod (getAppContext().get(), AndroidContext.getSystemService, windowServiceString.get()));

    if (windowManager.get() != nullptr)
    {
        LocalRef<jobject> display = LocalRef<jobject> (env->CallObjectMethod (windowManager, AndroidWindowManager.getDefaultDisplay));

        if (display.get() != nullptr)
        {
            int rotation = env->CallIntMethod (display, AndroidDisplay.getRotation);

            switch (rotation)
            {
                case ROTATION_0:   return upright;
                case ROTATION_90:  return rotatedAntiClockwise;
                case ROTATION_180: return upsideDown;
                case ROTATION_270: return rotatedClockwise;
            }
        }
    }

    jassertfalse;
    return upright;
}

bool MouseInputSource::SourceList::addSource()
{
    addSource (sources.size(), MouseInputSource::InputSourceType::touch);
    return true;
}

bool MouseInputSource::SourceList::canUseTouch()
{
    return true;
}

Point<float> MouseInputSource::getCurrentRawMousePosition()
{
    return AndroidComponentPeer::lastMousePos;
}

void MouseInputSource::setRawMousePosition (Point<float>)
{
    // not needed
}

//==============================================================================
bool KeyPress::isKeyCurrentlyDown (int /*keyCode*/)
{
    // TODO
    return false;
}

JUCE_API void JUCE_CALLTYPE Process::hide()
{
    auto* env = getEnv();
    LocalRef<jobject> currentActivity (getCurrentActivity().get());

    if (env->CallBooleanMethod (currentActivity.get(), AndroidActivity.moveTaskToBack, true) == 0)
    {
        GlobalRef intent (LocalRef<jobject> (env->NewObject (AndroidIntent, AndroidIntent.constructor)));
        env->CallObjectMethod (intent, AndroidIntent.setAction,   javaString ("android.intent.action.MAIN")  .get());
        env->CallObjectMethod (intent, AndroidIntent.addCategory, javaString ("android.intent.category.HOME").get());

        env->CallVoidMethod (currentActivity.get(), AndroidContext.startActivity, intent.get());
    }
}

//==============================================================================
// TODO
JUCE_API bool JUCE_CALLTYPE Process::isForegroundProcess() { return true; }
JUCE_API void JUCE_CALLTYPE Process::makeForegroundProcess() {}

//==============================================================================
#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (show,                   "show",                 "()V") \
 METHOD (getWindow,              "getWindow",            "()Landroid/view/Window;")

DECLARE_JNI_CLASS (AndroidDialog, "android/app/Dialog")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (construct,                   "<init>",                 "(Landroid/content/Context;)V") \
 METHOD (create,                      "create",                 "()Landroid/app/AlertDialog;") \
 METHOD (setTitle,                    "setTitle",               "(Ljava/lang/CharSequence;)Landroid/app/AlertDialog$Builder;") \
 METHOD (setMessage,                  "setMessage",             "(Ljava/lang/CharSequence;)Landroid/app/AlertDialog$Builder;") \
 METHOD (setCancelable,               "setCancelable",          "(Z)Landroid/app/AlertDialog$Builder;") \
 METHOD (setOnCancelListener,         "setOnCancelListener",    "(Landroid/content/DialogInterface$OnCancelListener;)Landroid/app/AlertDialog$Builder;") \
 METHOD (setPositiveButton,           "setPositiveButton",      "(Ljava/lang/CharSequence;Landroid/content/DialogInterface$OnClickListener;)Landroid/app/AlertDialog$Builder;") \
 METHOD (setNegativeButton,           "setNegativeButton",      "(Ljava/lang/CharSequence;Landroid/content/DialogInterface$OnClickListener;)Landroid/app/AlertDialog$Builder;") \
 METHOD (setNeutralButton,            "setNeutralButton",       "(Ljava/lang/CharSequence;Landroid/content/DialogInterface$OnClickListener;)Landroid/app/AlertDialog$Builder;")

DECLARE_JNI_CLASS (AndroidAlertDialogBuilder, "android/app/AlertDialog$Builder")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (dismiss,    "dismiss",  "()V")

DECLARE_JNI_CLASS (AndroidDialogInterface, "android/content/DialogInterface")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \

DECLARE_JNI_CLASS (AndroidDialogOnClickListener, "android/content/DialogInterface$OnClickListener")
#undef JNI_CLASS_MEMBERS

//==============================================================================
class DialogListener  : public juce::AndroidInterfaceImplementer
{
public:
    DialogListener (std::shared_ptr<ModalComponentManager::Callback> callbackToUse, int resultToUse)
        : callback (std::move (callbackToUse)), result (resultToUse)
    {}

    void onResult (jobject dialog)
    {
        auto* env = getEnv();
        env->CallVoidMethod (dialog, AndroidDialogInterface.dismiss);

        if (callback != nullptr)
            callback->modalStateFinished (result);

        callback = nullptr;
    }

private:
    jobject invoke (jobject proxy, jobject method, jobjectArray args) override
    {
        auto* env = getEnv();
        auto methodName = juce::juceString ((jstring) env->CallObjectMethod (method, JavaMethod.getName));

        if (methodName == "onCancel" || methodName == "onClick")
        {
            onResult (env->GetObjectArrayElement (args, 0));
            return nullptr;
        }

        // invoke base class
        return AndroidInterfaceImplementer::invoke (proxy, method, args);
    }

    std::shared_ptr<ModalComponentManager::Callback> callback;
    int result;
};

//==============================================================================
static void createAndroidDialog (const MessageBoxOptions& opts,
                                 ModalComponentManager::Callback* callbackIn,
                                 AlertWindowMappings::MapFn mapFn)
{
    auto* env = getEnv();

    LocalRef<jobject> builder (env->NewObject (AndroidAlertDialogBuilder, AndroidAlertDialogBuilder.construct, getMainActivity().get()));

    builder = LocalRef<jobject> (env->CallObjectMethod (builder.get(), AndroidAlertDialogBuilder.setTitle,   javaString (opts.getTitle()).get()));
    builder = LocalRef<jobject> (env->CallObjectMethod (builder.get(), AndroidAlertDialogBuilder.setMessage, javaString (opts.getMessage()).get()));
    builder = LocalRef<jobject> (env->CallObjectMethod (builder.get(), AndroidAlertDialogBuilder.setCancelable, true));

    std::shared_ptr<ModalComponentManager::Callback> sharedCallback (AlertWindowMappings::getWrappedCallback (callbackIn, mapFn));

    builder = LocalRef<jobject> (env->CallObjectMethod (builder.get(), AndroidAlertDialogBuilder.setOnCancelListener,
                                                        CreateJavaInterface (new DialogListener (sharedCallback, 0),
                                                                             "android/content/DialogInterface$OnCancelListener").get()));

    builder = LocalRef<jobject> (env->CallObjectMethod (builder.get(), AndroidAlertDialogBuilder.setPositiveButton,
                                                        javaString (opts.getButtonText (0)).get(),
                                                        CreateJavaInterface (new DialogListener (sharedCallback, 0),
                                                                             "android/content/DialogInterface$OnClickListener").get()));

    if (opts.getButtonText (1).isNotEmpty())
        builder = LocalRef<jobject> (env->CallObjectMethod (builder.get(), AndroidAlertDialogBuilder.setNegativeButton,
                                                            javaString (opts.getButtonText (1)).get(),
                                                            CreateJavaInterface (new DialogListener (sharedCallback, 1),
                                                                                 "android/content/DialogInterface$OnClickListener").get()));

    if (opts.getButtonText (2).isNotEmpty())
        builder = LocalRef<jobject> (env->CallObjectMethod (builder.get(), AndroidAlertDialogBuilder.setNeutralButton,
                                                            javaString (opts.getButtonText (2)).get(),
                                                            CreateJavaInterface (new DialogListener (sharedCallback, 2),
                                                                                 "android/content/DialogInterface$OnClickListener").get()));

    LocalRef<jobject> dialog (env->CallObjectMethod (builder.get(), AndroidAlertDialogBuilder.create));

    LocalRef<jobject> window (env->CallObjectMethod (dialog.get(), AndroidDialog.getWindow));

    if (Desktop::getInstance().getKioskModeComponent() != nullptr)
    {
        env->CallVoidMethod (window.get(), AndroidWindow.setFlags, FLAG_NOT_FOCUSABLE, FLAG_NOT_FOCUSABLE);
        LocalRef<jobject> decorView (env->CallObjectMethod (window.get(), AndroidWindow.getDecorView));
        env->CallVoidMethod (decorView.get(), AndroidView.setSystemUiVisibility, fullScreenFlags);
    }

    env->CallVoidMethod (dialog.get(), AndroidDialog.show);

    if (Desktop::getInstance().getKioskModeComponent() != nullptr)
        env->CallVoidMethod (window.get(), AndroidWindow.clearFlags, FLAG_NOT_FOCUSABLE);
}

void JUCE_CALLTYPE NativeMessageBox::showMessageBoxAsync (MessageBoxIconType /*iconType*/,
                                                          const String& title, const String& message,
                                                          Component* /*associatedComponent*/,
                                                          ModalComponentManager::Callback* callback)
{
    createAndroidDialog (MessageBoxOptions()
                           .withTitle (title)
                           .withMessage (message)
                           .withButton (TRANS("OK")),
                         callback, AlertWindowMappings::messageBox);
}

bool JUCE_CALLTYPE NativeMessageBox::showOkCancelBox (MessageBoxIconType /*iconType*/,
                                                      const String& title, const String& message,
                                                      Component* /*associatedComponent*/,
                                                      ModalComponentManager::Callback* callback)
{
    createAndroidDialog (MessageBoxOptions()
                           .withTitle (title)
                           .withMessage (message)
                           .withButton (TRANS("OK"))
                           .withButton (TRANS("Cancel")),
                         callback, AlertWindowMappings::okCancel);

    return false;
}

int JUCE_CALLTYPE NativeMessageBox::showYesNoCancelBox (MessageBoxIconType /*iconType*/,
                                                        const String& title, const String& message,
                                                        Component* /*associatedComponent*/,
                                                        ModalComponentManager::Callback* callback)
{
    createAndroidDialog (MessageBoxOptions()
                           .withTitle (title)
                           .withMessage (message)
                           .withButton (TRANS("Yes"))
                           .withButton (TRANS("No"))
                           .withButton (TRANS("Cancel")),
                         callback, AlertWindowMappings::yesNoCancel);

    return 0;
}

int JUCE_CALLTYPE NativeMessageBox::showYesNoBox (MessageBoxIconType /*iconType*/,
                                                  const String& title, const String& message,
                                                  Component* /*associatedComponent*/,
                                                  ModalComponentManager::Callback* callback)
{
    createAndroidDialog (MessageBoxOptions()
                           .withTitle (title)
                           .withMessage (message)
                           .withButton (TRANS("Yes"))
                           .withButton (TRANS("No")),
                         callback, AlertWindowMappings::okCancel);

    return 0;
}

void JUCE_CALLTYPE NativeMessageBox::showAsync (const MessageBoxOptions& options,
                                                ModalComponentManager::Callback* callback)
{
    createAndroidDialog (options, callback, AlertWindowMappings::noMapping);
}

void JUCE_CALLTYPE NativeMessageBox::showAsync (const MessageBoxOptions& options,
                                                std::function<void (int)> callback)
{
    showAsync (options, ModalCallbackFunction::create (callback));
}

//==============================================================================
static bool androidScreenSaverEnabled = true;

void Desktop::setScreenSaverEnabled (bool shouldEnable)
{
    constexpr auto FLAG_KEEP_SCREEN_ON = 0x80;

    if (shouldEnable != androidScreenSaverEnabled)
    {
        LocalRef<jobject> activity (getMainActivity());

        if (activity != nullptr)
        {
            auto* env = getEnv();

            LocalRef<jobject> mainWindow (env->CallObjectMethod (activity.get(), AndroidActivity.getWindow));
            env->CallVoidMethod (mainWindow.get(), AndroidWindow.setFlags, shouldEnable ? 0 : FLAG_KEEP_SCREEN_ON, FLAG_KEEP_SCREEN_ON);
        }

        androidScreenSaverEnabled = shouldEnable;
    }
}

bool Desktop::isScreenSaverEnabled()
{
    return androidScreenSaverEnabled;
}

//==============================================================================
void Desktop::setKioskComponent (Component* kioskComp, bool enableOrDisable, bool allowMenusAndBars)
{
    ignoreUnused (allowMenusAndBars);

    if (AndroidComponentPeer* peer = dynamic_cast<AndroidComponentPeer*> (kioskComp->getPeer()))
        peer->setFullScreen (enableOrDisable);
    else
        jassertfalse; // (this should have been checked by the caller)
}

//==============================================================================
static jint getAndroidOrientationFlag (int orientations) noexcept
{
    enum
    {
        SCREEN_ORIENTATION_LANDSCAPE          = 0,
        SCREEN_ORIENTATION_PORTRAIT           = 1,
        SCREEN_ORIENTATION_USER               = 2,
        SCREEN_ORIENTATION_REVERSE_LANDSCAPE  = 8,
        SCREEN_ORIENTATION_REVERSE_PORTRAIT   = 9,
        SCREEN_ORIENTATION_USER_LANDSCAPE     = 11,
        SCREEN_ORIENTATION_USER_PORTRAIT      = 12,
    };

    switch (orientations)
    {
        case Desktop::upright:                                          return (jint) SCREEN_ORIENTATION_PORTRAIT;
        case Desktop::upsideDown:                                       return (jint) SCREEN_ORIENTATION_REVERSE_PORTRAIT;
        case Desktop::upright + Desktop::upsideDown:                    return (jint) SCREEN_ORIENTATION_USER_PORTRAIT;
        case Desktop::rotatedAntiClockwise:                             return (jint) SCREEN_ORIENTATION_LANDSCAPE;
        case Desktop::rotatedClockwise:                                 return (jint) SCREEN_ORIENTATION_REVERSE_LANDSCAPE;
        case Desktop::rotatedClockwise + Desktop::rotatedAntiClockwise: return (jint) SCREEN_ORIENTATION_USER_LANDSCAPE;
        default:                                                        return (jint) SCREEN_ORIENTATION_USER;
    }
}

void Desktop::allowedOrientationsChanged()
{
    LocalRef<jobject> activity (getMainActivity());

    if (activity != nullptr)
        getEnv()->CallVoidMethod (activity.get(), AndroidActivity.setRequestedOrientation, getAndroidOrientationFlag (allowedOrientations));
}

//==============================================================================
bool juce_areThereAnyAlwaysOnTopWindows()
{
    return false;
}

//==============================================================================
#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (create,          "<init>",         "()V") \
 FIELD  (density,         "density",        "F") \
 FIELD  (widthPixels,     "widthPixels",    "I") \
 FIELD  (heightPixels,    "heightPixels",   "I")

DECLARE_JNI_CLASS (AndroidDisplayMetrics, "android/util/DisplayMetrics")
#undef JNI_CLASS_MEMBERS

//==============================================================================
class LayoutChangeListener  : public juce::AndroidInterfaceImplementer
{
public:
    virtual void onLayoutChange (LocalRef<jobject> view, int left, int top, int right, int bottom,
                                 int oldLeft, int oldTop, int oldRight, int oldBottom) = 0;

private:
    jobject invoke (jobject proxy, jobject method, jobjectArray args) override
    {
        auto* env = getEnv();
        auto methodName = juce::juceString ((jstring) env->CallObjectMethod (method, JavaMethod.getName));

        if (methodName == "onLayoutChange")
        {
            jassert (env->GetArrayLength (args) == 9);

            LocalRef<jobject> view (env->GetObjectArrayElement (args, 0));
            int dims[8];

            for (int i = 1; i < 9; ++i)
            {
                LocalRef<jobject> integer (env->GetObjectArrayElement (args, i));
                dims[i - 1] = env->CallIntMethod (integer.get(), JavaInteger.intValue);
            }

            onLayoutChange (std::move (view), dims[0], dims[1], dims[2], dims[3],
                            dims[4], dims[5], dims[6], dims[7]);

            return nullptr;
        }

        // invoke base class
        return AndroidInterfaceImplementer::invoke (proxy, method, args);
    }

    std::unique_ptr<ModalComponentManager::Callback> callback;
};

//==============================================================================
struct MainActivityWindowLayoutListener   : public LayoutChangeListener
{
    MainActivityWindowLayoutListener (std::function<void()>&& updateDisplaysCb)
        : forceDisplayUpdate (std::move (updateDisplaysCb))
    {
    }

    void onLayoutChange (LocalRef<jobject> /*view*/, int left, int top, int right, int bottom,
                         int oldLeft, int oldTop, int oldRight, int oldBottom) override
    {
        auto newBounds = Rectangle<int>::leftTopRightBottom (left, top, right, bottom);
        auto oldBounds = Rectangle<int>::leftTopRightBottom (oldLeft, oldTop, oldRight, oldBottom);

        if (newBounds != oldBounds)
        {
            const auto& mainDisplay = *Desktop::getInstance().getDisplays().getPrimaryDisplay();
            auto userArea = (newBounds.toFloat() / mainDisplay.scale).toNearestInt();

            if (userArea != mainDisplay.userArea)
                forceDisplayUpdate();
        }
    }

    std::function<void()> forceDisplayUpdate;
};

//==============================================================================
void Displays::findDisplays (float masterScale)
{
    auto* env = getEnv();

    LocalRef<jobject> usableSize (env->NewObject (AndroidPoint, AndroidPoint.create, 0, 0));
    LocalRef<jstring> windowServiceString (javaString ("window"));
    LocalRef<jobject> displayMetrics (env->NewObject (AndroidDisplayMetrics, AndroidDisplayMetrics.create));
    LocalRef<jobject> windowManager (env->CallObjectMethod (getAppContext().get(), AndroidContext.getSystemService, windowServiceString.get()));
    LocalRef<jobject> display (env->CallObjectMethod (windowManager, AndroidWindowManager.getDefaultDisplay));

    if (const auto getRealMetricsMethod = AndroidDisplay17.getRealMetrics)
        env->CallVoidMethod (display, getRealMetricsMethod, displayMetrics.get());
    else
        env->CallVoidMethod (display, AndroidDisplay.getMetrics, displayMetrics.get());

    env->CallVoidMethod (display, AndroidDisplay.getSize, usableSize.get());

    Display d;

    d.isMain = true;
    d.scale = env->GetFloatField (displayMetrics.get(), AndroidDisplayMetrics.density);
    d.dpi = (d.scale * 160.f);
    d.scale *= masterScale;

    d.totalArea = Rectangle<int> (env->GetIntField (displayMetrics.get(), AndroidDisplayMetrics.widthPixels),
                                  env->GetIntField (displayMetrics.get(), AndroidDisplayMetrics.heightPixels)) / d.scale;

    d.userArea = Rectangle<int> (env->GetIntField (usableSize.get(), AndroidPoint.x),
                                 env->GetIntField (usableSize.get(), AndroidPoint.y)) / d.scale;

    // unfortunately usableSize still contains the nav bar
    // the best workaround is to try to get the size of the top-level view of
    // the main activity
    LocalRef<jobject> activity (getMainActivity());

    if (activity != nullptr)
    {
        LocalRef<jobject> mainWindow (env->CallObjectMethod (activity.get(), AndroidActivity.getWindow));
        LocalRef<jobject> decorView (env->CallObjectMethod (mainWindow.get(), AndroidWindow.getDecorView));
        LocalRef<jobject> contentView (env->CallObjectMethod (decorView.get(), AndroidView.findViewById, 0x01020002 /* android.R.id.content */));

        if (contentView != nullptr)
        {
            Rectangle<int> activityArea (env->CallIntMethod (contentView.get(), AndroidView.getLeft),
                                         env->CallIntMethod (contentView.get(), AndroidView.getTop),
                                         env->CallIntMethod (contentView.get(), AndroidView.getWidth),
                                         env->CallIntMethod (contentView.get(), AndroidView.getHeight));

            if (! activityArea.isEmpty())
                d.userArea = activityArea / d.scale;

            if (const auto getRootWindowInsetsMethodId = AndroidView23.getRootWindowInsets)
            {
                LocalRef<jobject> insets (env->CallObjectMethod (contentView.get(), getRootWindowInsetsMethodId));
                JuceInsets::tie (d) = getInsetsFromAndroidWindowInsets (insets, d.scale).tie();
            }

            static bool hasAddedMainActivityListener = false;

            if (! hasAddedMainActivityListener)
            {
                hasAddedMainActivityListener = true;

                env->CallVoidMethod (contentView.get(), AndroidView.addOnLayoutChangeListener,
                                     CreateJavaInterface (new MainActivityWindowLayoutListener ([this] { refresh(); }),
                                                          "android/view/View$OnLayoutChangeListener").get());
            }
        }
    }
    else
    {
        // the main activity may have not started yet so add an activity listener
        if (AndroidComponentPeer::activityCallbackListener == nullptr)
        {
            LocalRef<jobject> appContext (getAppContext());

            if (appContext.get() != nullptr)
            {
                AndroidComponentPeer::activityCallbackListener = GlobalRef (CreateJavaInterface (
                        new AndroidComponentPeer::StartupActivityCallbackListener,
                        "android/app/Application$ActivityLifecycleCallbacks"));

                env->CallVoidMethod (appContext.get(),
                                     AndroidApplication.registerActivityLifecycleCallbacks,
                                     AndroidComponentPeer::activityCallbackListener.get());
            }
        }
    }

    displays.add (d);
}

//==============================================================================
Image juce_createIconForFile (const File& /*file*/)
{
    return Image();
}

//==============================================================================
class MouseCursor::PlatformSpecificHandle
{
public:
    PlatformSpecificHandle (const MouseCursor::StandardCursorType)      {}
    PlatformSpecificHandle (const CustomMouseCursorInfo&)               {}

    static void showInWindow (PlatformSpecificHandle*, ComponentPeer*)  {}
};

//==============================================================================
bool DragAndDropContainer::performExternalDragDropOfFiles (const StringArray& /*files*/, bool /*canMove*/,
                                                           Component* /*srcComp*/, std::function<void()> /*callback*/)
{
    jassertfalse;    // no such thing on Android!
    return false;
}

bool DragAndDropContainer::performExternalDragDropOfText (const String& /*text*/, Component* /*srcComp*/,
                                                          std::function<void()> /*callback*/)
{
    jassertfalse;    // no such thing on Android!
    return false;
}

//==============================================================================
void LookAndFeel::playAlertSound()
{
}

//==============================================================================
#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (getText,      "getText",            "()Ljava/lang/CharSequence;") \
 METHOD (setText,      "setText",            "(Ljava/lang/CharSequence;)V")

DECLARE_JNI_CLASS (AndroidClipboardManager, "android/content/ClipboardManager")
#undef JNI_CLASS_MEMBERS

//==============================================================================
void SystemClipboard::copyTextToClipboard (const String& text)
{
    auto* env = getEnv();

    LocalRef<jobject> clipboardManager (env->CallObjectMethod (getAppContext().get(), AndroidContext.getSystemService, javaString ("clipboard").get()));
    env->CallVoidMethod (clipboardManager.get(), AndroidClipboardManager.setText, javaString(text).get());
}

String SystemClipboard::getTextFromClipboard()
{
    auto* env = getEnv();

    LocalRef<jobject> clipboardManager (env->CallObjectMethod (getAppContext().get(), AndroidContext.getSystemService, javaString ("clipboard").get()));
    LocalRef<jobject> charSequence (env->CallObjectMethod (clipboardManager.get(), AndroidClipboardManager.getText));

    if (charSequence == nullptr)
        return {};

    return juceString(LocalRef<jstring> ((jstring) env->CallObjectMethod(charSequence.get(), JavaCharSequence.toString)));
}

//==============================================================================
constexpr int extendedKeyModifier           = 0x10000;

const int KeyPress::spaceKey                = ' ';
const int KeyPress::returnKey               = extendedKeyModifier + 2;
const int KeyPress::escapeKey               = extendedKeyModifier + 3;
const int KeyPress::backspaceKey            = extendedKeyModifier + 4;
const int KeyPress::leftKey                 = extendedKeyModifier + 5;
const int KeyPress::rightKey                = extendedKeyModifier + 6;
const int KeyPress::upKey                   = extendedKeyModifier + 7;
const int KeyPress::downKey                 = extendedKeyModifier + 8;
const int KeyPress::pageUpKey               = extendedKeyModifier + 9;
const int KeyPress::pageDownKey             = extendedKeyModifier + 10;
const int KeyPress::endKey                  = extendedKeyModifier + 11;
const int KeyPress::homeKey                 = extendedKeyModifier + 12;
const int KeyPress::deleteKey               = extendedKeyModifier + 13;
const int KeyPress::insertKey               = extendedKeyModifier + 14;
const int KeyPress::tabKey                  = extendedKeyModifier + 15;
const int KeyPress::F1Key                   = extendedKeyModifier + 16;
const int KeyPress::F2Key                   = extendedKeyModifier + 17;
const int KeyPress::F3Key                   = extendedKeyModifier + 18;
const int KeyPress::F4Key                   = extendedKeyModifier + 19;
const int KeyPress::F5Key                   = extendedKeyModifier + 20;
const int KeyPress::F6Key                   = extendedKeyModifier + 21;
const int KeyPress::F7Key                   = extendedKeyModifier + 22;
const int KeyPress::F8Key                   = extendedKeyModifier + 23;
const int KeyPress::F9Key                   = extendedKeyModifier + 24;
const int KeyPress::F10Key                  = extendedKeyModifier + 25;
const int KeyPress::F11Key                  = extendedKeyModifier + 26;
const int KeyPress::F12Key                  = extendedKeyModifier + 27;
const int KeyPress::F13Key                  = extendedKeyModifier + 28;
const int KeyPress::F14Key                  = extendedKeyModifier + 29;
const int KeyPress::F15Key                  = extendedKeyModifier + 30;
const int KeyPress::F16Key                  = extendedKeyModifier + 31;
const int KeyPress::F17Key                  = extendedKeyModifier + 32;
const int KeyPress::F18Key                  = extendedKeyModifier + 33;
const int KeyPress::F19Key                  = extendedKeyModifier + 34;
const int KeyPress::F20Key                  = extendedKeyModifier + 35;
const int KeyPress::F21Key                  = extendedKeyModifier + 36;
const int KeyPress::F22Key                  = extendedKeyModifier + 37;
const int KeyPress::F23Key                  = extendedKeyModifier + 38;
const int KeyPress::F24Key                  = extendedKeyModifier + 39;
const int KeyPress::F25Key                  = extendedKeyModifier + 40;
const int KeyPress::F26Key                  = extendedKeyModifier + 41;
const int KeyPress::F27Key                  = extendedKeyModifier + 42;
const int KeyPress::F28Key                  = extendedKeyModifier + 43;
const int KeyPress::F29Key                  = extendedKeyModifier + 44;
const int KeyPress::F30Key                  = extendedKeyModifier + 45;
const int KeyPress::F31Key                  = extendedKeyModifier + 46;
const int KeyPress::F32Key                  = extendedKeyModifier + 47;
const int KeyPress::F33Key                  = extendedKeyModifier + 48;
const int KeyPress::F34Key                  = extendedKeyModifier + 49;
const int KeyPress::F35Key                  = extendedKeyModifier + 50;
const int KeyPress::numberPad0              = extendedKeyModifier + 51;
const int KeyPress::numberPad1              = extendedKeyModifier + 52;
const int KeyPress::numberPad2              = extendedKeyModifier + 53;
const int KeyPress::numberPad3              = extendedKeyModifier + 54;
const int KeyPress::numberPad4              = extendedKeyModifier + 55;
const int KeyPress::numberPad5              = extendedKeyModifier + 56;
const int KeyPress::numberPad6              = extendedKeyModifier + 57;
const int KeyPress::numberPad7              = extendedKeyModifier + 58;
const int KeyPress::numberPad8              = extendedKeyModifier + 59;
const int KeyPress::numberPad9              = extendedKeyModifier + 60;
const int KeyPress::numberPadAdd            = extendedKeyModifier + 61;
const int KeyPress::numberPadSubtract       = extendedKeyModifier + 62;
const int KeyPress::numberPadMultiply       = extendedKeyModifier + 63;
const int KeyPress::numberPadDivide         = extendedKeyModifier + 64;
const int KeyPress::numberPadSeparator      = extendedKeyModifier + 65;
const int KeyPress::numberPadDecimalPoint   = extendedKeyModifier + 66;
const int KeyPress::numberPadEquals         = extendedKeyModifier + 67;
const int KeyPress::numberPadDelete         = extendedKeyModifier + 68;
const int KeyPress::playKey                 = extendedKeyModifier + 69;
const int KeyPress::stopKey                 = extendedKeyModifier + 70;
const int KeyPress::fastForwardKey          = extendedKeyModifier + 71;
const int KeyPress::rewindKey               = extendedKeyModifier + 72;

//==============================================================================
#ifdef JUCE_PUSH_NOTIFICATIONS_ACTIVITY
 struct JuceActivityNewIntentListener
 {
     #define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
      CALLBACK (appNewIntent, "appNewIntent", "(Landroid/content/Intent;)V") \
      CALLBACK (appOnResume,  "appOnResume",  "()V")

      DECLARE_JNI_CLASS (JavaActivity, JUCE_PUSH_NOTIFICATIONS_ACTIVITY)
     #undef JNI_CLASS_MEMBERS

     static void JNICALL appNewIntent (JNIEnv*, jobject /*activity*/, jobject intentData)
     {
         juce_handleNotificationIntent (static_cast<void*> (intentData));
     }

     static void JNICALL appOnResume (JNIEnv*, jobject)
     {
         juce_handleOnResume();
     }
 };

 JuceActivityNewIntentListener::JavaActivity_Class JuceActivityNewIntentListener::JavaActivity;
#endif

} // namespace juce
