/*
    This file is part of Helio music sequencer.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#pragma once

class Lasso;
class MidiTrack;
class PianoRoll;
class ProjectNode;

#include "MenuPanel.h"
#include "Scale.h"
#include "Note.h"
#include "KeySignaturesSequence.h"

class RescalePreviewTool final : public MenuPanel
{
public:

    RescalePreviewTool(PianoRoll &roll,
        WeakReference<KeySignaturesSequence> harmonicContext);

    void handleCommandMessage(int commandId) override;

private:

    void dismissCalloutAsync();
    void undoIfNeeded();

    PianoRoll &roll;
    WeakReference<KeySignaturesSequence> harmonicContext;

    bool hasMadeChanges = false;
    Scale::Ptr lastChosenScale;

    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR(RescalePreviewTool)
};


class QuickRescaleMenu final : public MenuPanel
{
public:

    QuickRescaleMenu(const ProjectNode &project,
        const KeySignatureEvent &event, float endBeat);

private:

    void dismissCalloutAsync();

    const ProjectNode &project;
    const KeySignatureEvent &event;
    const float endBeat;

    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR(QuickRescaleMenu)
};
