/*
    This file is part of Helio music sequencer.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#include "Common.h"
#include "CommandIDs.h"

#define CASE_FOR(x) \
    case constexprHash(#x): \
    return x;

CommandIDs::Id CommandIDs::getIdForName(const String &command)
{
    switch (constexprHash(command.toRawUTF8()))
    {
        CASE_FOR(Browse)
        CASE_FOR(IconButtonPressed)
        CASE_FOR(DismissModalComponentAsync)
        CASE_FOR(AddAnnotation)
        CASE_FOR(AddTimeSignature)
        CASE_FOR(AddKeySignature)
        CASE_FOR(CreateArpeggiatorFromSelection)
        CASE_FOR(InitWorkspace)
        CASE_FOR(ScanAllPlugins)
        CASE_FOR(ScanPluginsFolder)
        CASE_FOR(DeleteTrack)
        CASE_FOR(RenameTrack)
        CASE_FOR(SetTrackTimeSignature)
        CASE_FOR(SelectAllEvents)
        CASE_FOR(SelectAllClips)
        CASE_FOR(NewTrackFromSelection)
        CASE_FOR(DuplicateTrack)
        CASE_FOR(InstanceToUniqueTrack)
        CASE_FOR(EditCurrentInstrument)
        CASE_FOR(SwitchToClipInViewport)
        CASE_FOR(Tuplet1)
        CASE_FOR(Tuplet2)
        CASE_FOR(Tuplet3)
        CASE_FOR(Tuplet4)
        CASE_FOR(Tuplet5)
        CASE_FOR(Tuplet6)
        CASE_FOR(Tuplet7)
        CASE_FOR(Tuplet8)
        CASE_FOR(Tuplet9)
        CASE_FOR(QuantizeTo1_1)
        CASE_FOR(QuantizeTo1_2)
        CASE_FOR(QuantizeTo1_4)
        CASE_FOR(QuantizeTo1_8)
        CASE_FOR(QuantizeTo1_16)
        CASE_FOR(QuantizeTo1_32)
        CASE_FOR(DeleteEvents)
        CASE_FOR(CopyEvents)
        CASE_FOR(CutEvents)
        CASE_FOR(PasteEvents)
        CASE_FOR(DeleteClips)
        CASE_FOR(CopyClips)
        CASE_FOR(CutClips)
        CASE_FOR(PasteClips)
        CASE_FOR(ClipTransposeUp)
        CASE_FOR(ClipTransposeDown)
        CASE_FOR(ClipTransposeOctaveUp)
        CASE_FOR(ClipTransposeOctaveDown)
        CASE_FOR(ClipTransposeFifthUp)
        CASE_FOR(ClipTransposeFifthDown)
        CASE_FOR(ClipVolumeUp)
        CASE_FOR(ClipVolumeDown)
        CASE_FOR(ToggleMuteClips)
        CASE_FOR(ToggleSoloClips)
        CASE_FOR(ToggleScalesHighlighting)
        CASE_FOR(ToggleNoteNameGuides)
        CASE_FOR(ToggleLoopOverSelection)
        CASE_FOR(ToggleMetronome)
        CASE_FOR(ToggleMuteModifiers)
        CASE_FOR(ZoomIn)
        CASE_FOR(ZoomOut)
        CASE_FOR(ZoomEntireClip)
        CASE_FOR(ToggleLockZoomLevel)
        CASE_FOR(Undo)
        CASE_FOR(Redo)
        CASE_FOR(TimelineJumpNext)
        CASE_FOR(TimelineJumpPrevious)
        CASE_FOR(TimelineJumpHome)
        CASE_FOR(TimelineJumpEnd)
        CASE_FOR(TransportRecordingAwait)
        CASE_FOR(TransportRecordingStart)
        CASE_FOR(TransportPlaybackStart)
        CASE_FOR(TransportStop)
        CASE_FOR(RenderToFLAC)
        CASE_FOR(RenderToWAV)
        CASE_FOR(ImportMidi)
        CASE_FOR(ExportMidi)
        CASE_FOR(DeleteProject)
        CASE_FOR(ProjectTransposeUp)
        CASE_FOR(ProjectTransposeDown)
        CASE_FOR(ProjectSetOneTempo)
        CASE_FOR(TrackSetOneTempo)
        CASE_FOR(ProjectTempoUp1Bpm)
        CASE_FOR(ProjectTempoDown1Bpm)
        CASE_FOR(TempoUp1Bpm)
        CASE_FOR(TempoDown1Bpm)
        CASE_FOR(SwitchBetweenRolls)
        CASE_FOR(SwitchToEditMode)
        CASE_FOR(SwitchToArrangeMode)
        CASE_FOR(SwitchToVersioningMode)
        CASE_FOR(ShowPreviousPage)
        CASE_FOR(ShowNextPage)
        CASE_FOR(ShowRootPage)
        CASE_FOR(ToggleShowHideCombo)
        CASE_FOR(StartDragViewport)
        CASE_FOR(EndDragViewport)
        CASE_FOR(SelectAudioDeviceType)
        CASE_FOR(SelectAudioDevice)
        CASE_FOR(SelectSampleRate)
        CASE_FOR(SelectBufferSize)
        CASE_FOR(SelectMidiInputDevice)
        CASE_FOR(SelectMidiOutputDevice)
        CASE_FOR(SelectMidiNoOutputDevice)
        CASE_FOR(SelectFont)
        CASE_FOR(EditModeDefault)
        CASE_FOR(EditModeDraw)
        CASE_FOR(EditModePan)
        CASE_FOR(EditModeSelect)
        CASE_FOR(EditModeKnife)
        CASE_FOR(BeatShiftLeft)
        CASE_FOR(BeatShiftRight)
        CASE_FOR(LengthIncrease)
        CASE_FOR(LengthDecrease)
        CASE_FOR(TransposeUp)
        CASE_FOR(TransposeDown)
        CASE_FOR(TransposeScaleKeyUp)
        CASE_FOR(TransposeScaleKeyDown)
        CASE_FOR(TransposeOctaveUp)
        CASE_FOR(TransposeOctaveDown)
        CASE_FOR(TransposeFifthUp)
        CASE_FOR(TransposeFifthDown)
        CASE_FOR(AlignToScale)
        CASE_FOR(MakeStaccato)
        CASE_FOR(MakeStaccatissimo)
        CASE_FOR(MakeLegato)
        CASE_FOR(MakeLegatoOverlapping)
        CASE_FOR(ViewportPanLeft)
        CASE_FOR(ViewportPanRight)
        CASE_FOR(ViewportPanUp)
        CASE_FOR(ViewportPanDown)
        CASE_FOR(CursorMoveLeft)
        CASE_FOR(CursorMoveRight)
        CASE_FOR(CursorMoveUp)
        CASE_FOR(CursorMoveDown)
        CASE_FOR(CursorSelectLeft)
        CASE_FOR(CursorSelectRight)
        CASE_FOR(CursorSelectUp)
        CASE_FOR(CursorSelectDown)
        CASE_FOR(CursorInteract)
        CASE_FOR(CursorEditHarmonicContext)
        CASE_FOR(CursorEditTimeContext)
        CASE_FOR(CleanupOverlaps)
        CASE_FOR(InvertChordUp)
        CASE_FOR(InvertChordDown)
        CASE_FOR(MelodicInversion)
        CASE_FOR(Retrograde)
        CASE_FOR(ShowArpeggiatorsPanel)
        CASE_FOR(ShowRescalePanel)
        CASE_FOR(ShowChordPanel)
        CASE_FOR(ShowNewTrackPanel)
        CASE_FOR(ShowMetronomeSettings)
        CASE_FOR(ToggleVolumePanel)
        CASE_FOR(ToggleBottomMiniMap)
        CASE_FOR(NotesVolumeRandom)
        CASE_FOR(NotesVolumeFadeOut)
        CASE_FOR(NotesVolumeUp)
        CASE_FOR(NotesVolumeDown)
        CASE_FOR(VersionControlToggleQuickStash)
        CASE_FOR(VersionControlResetAll)
        CASE_FOR(VersionControlCommitAll)
        CASE_FOR(VersionControlSelectAll)
        CASE_FOR(VersionControlSelectNone)
        CASE_FOR(VersionControlResetSelected)
        CASE_FOR(VersionControlCommitSelected)
        CASE_FOR(VersionControlCheckout)
        CASE_FOR(PatternsGroupByName)
        CASE_FOR(PatternsGroupByColour)
        CASE_FOR(PatternsGroupByInstrument)
        CASE_FOR(PatternsGroupById)
        CASE_FOR(CommandPalette)
        CASE_FOR(CommandPaletteWithMode)
        CASE_FOR(BreadcrumbsMenu)
        CASE_FOR(KeyMapReset)
        CASE_FOR(KeyMapLoadScala)
        CASE_FOR(KeyMapNextPage)
        CASE_FOR(KeyMapPreviousPage)
        CASE_FOR(KeyMapCopyToClipboard)
        CASE_FOR(KeyMapPasteFromClipboard)
        CASE_FOR(SavePreset)
        CASE_FOR(SelectNextPreset)
        CASE_FOR(SelectPreviousPreset)
        CASE_FOR(SelectPreset)
        CASE_FOR(OpenMetronomeSample)
        CASE_FOR(ResetMetronomeSample)
        CASE_FOR(CommandPaletteClear)
        CASE_FOR(CommandPaletteDismiss)
        CASE_FOR(CommandPaletteCursorUp)
        CASE_FOR(CommandPaletteCursorDown)
        CASE_FOR(CommandPaletteCursorPageUp)
        CASE_FOR(CommandPaletteCursorPageDown)
        CASE_FOR(ChordToolDismissApply)
        CASE_FOR(ChordToolDismissCancel)
        CASE_FOR(ChordToolRootKeyUp)
        CASE_FOR(ChordToolRootKeyDown)
        CASE_FOR(ChordToolBeatShiftLeft)
        CASE_FOR(ChordToolBeatShiftRight)
        CASE_FOR(ChordToolNextPreset)
        CASE_FOR(ChordToolPreviousPreset)
        CASE_FOR(ChordToolPreset1)
        CASE_FOR(ChordToolPreset2)
        CASE_FOR(ChordToolPreset3)
        CASE_FOR(ChordToolPreset4)
        CASE_FOR(ChordToolPreset5)
        CASE_FOR(ChordToolPreset6)
        CASE_FOR(ChordToolPreset7)
        CASE_FOR(ChordToolPreset8)
        CASE_FOR(ChordToolPreset9)
        CASE_FOR(ChordToolPreset10)
        CASE_FOR(ChordToolPreset11)
        CASE_FOR(ChordToolPreset12)
        CASE_FOR(MenuDismiss)
        CASE_FOR(MenuSelect)
        CASE_FOR(MenuCursorUp)
        CASE_FOR(MenuCursorDown)
        CASE_FOR(MenuCursorPageUp)
        CASE_FOR(MenuCursorPageDown)
        CASE_FOR(MenuForward)
        CASE_FOR(MenuBack)
        CASE_FOR(MenuCursorHide)
        CASE_FOR(MenuCursorTryExitUp)
        CASE_FOR(MenuCursorTryExitDown)
        CASE_FOR(DialogDismissCancel)
        CASE_FOR(DialogDismissApply)
        CASE_FOR(DialogDismissDelete)
        CASE_FOR(DialogNextPreset)
        CASE_FOR(DialogPreviousPreset)
        CASE_FOR(DialogPreviewPreset)
        CASE_FOR(DialogStopPreviewPreset)
        CASE_FOR(DialogShowPresetsList)
        CASE_FOR(ComboDismissCancel)
        CASE_FOR(ComboDismissApply)
        CASE_FOR(ComboCursorUp)
        CASE_FOR(ComboCursorDown)
        CASE_FOR(ComboCursorPageUp)
        CASE_FOR(ComboCursorPageDown)
        default: return None;
    }
}

#define TRANS_KEY(x, y) \
    case x: \
    return y;

#define TRANS_NONE(x) \
    case x: \
    return 0;

// this is only used for command palette:
// only the commands with translations are displayed
I18n::Key CommandIDs::getTranslationKeyFor(CommandIDs::Id id)
{
    using namespace I18n;

    switch (id)
    {
        //TRANS_NONE(Browse)
        //TRANS_NONE(IconButtonPressed)
        //TRANS_NONE(DismissModalComponentAsync)
        TRANS_KEY(AddAnnotation, Menu::annotationAdd)
        TRANS_KEY(AddTimeSignature, Menu::timeSignatureAdd)
        TRANS_KEY(AddKeySignature, Menu::keySignatureAdd)
        TRANS_KEY(CreateArpeggiatorFromSelection, Menu::arpeggiatorsCreate)
        //TRANS_NONE(InitWorkspace)
        TRANS_KEY(ScanAllPlugins, Menu::instrumentsReload)
        TRANS_KEY(ScanPluginsFolder, Menu::instrumentsScanFolder)
        TRANS_KEY(DeleteTrack, Menu::trackDelete)
        TRANS_KEY(RenameTrack, Menu::trackRename)
        //TRANS_NONE(SetTrackTimeSignature)
        TRANS_KEY(SelectAllEvents, Menu::trackSelectall)
        //TRANS_NONE(SelectAllClips)
        TRANS_KEY(NewTrackFromSelection, Menu::Selection::notesToTrack)
        TRANS_KEY(DuplicateTrack, Menu::trackDuplicate)
        //TRANS_NONE(InstanceToUniqueTrack)
        TRANS_KEY(EditCurrentInstrument, Menu::instrumentShowWindow)
        //TRANS_NONE(SwitchToClipInViewport)
        TRANS_KEY(Tuplet1, Menu::tuplet1)
        TRANS_KEY(Tuplet2, Menu::tuplet2)
        TRANS_KEY(Tuplet3, Menu::tuplet3)
        TRANS_KEY(Tuplet4, Menu::tuplet4)
        TRANS_KEY(Tuplet5, Menu::tuplet5)
        TRANS_KEY(Tuplet6, Menu::tuplet6)
        TRANS_KEY(Tuplet7, Menu::tuplet7)
        TRANS_KEY(Tuplet8, Menu::tuplet8)
        TRANS_KEY(Tuplet9, Menu::tuplet9)
        TRANS_KEY(QuantizeTo1_1, Menu::quantizeTo1_1)
        TRANS_KEY(QuantizeTo1_2, Menu::quantizeTo1_2)
        TRANS_KEY(QuantizeTo1_4, Menu::quantizeTo1_4)
        TRANS_KEY(QuantizeTo1_8, Menu::quantizeTo1_8)
        TRANS_KEY(QuantizeTo1_16, Menu::quantizeTo1_16)
        TRANS_KEY(QuantizeTo1_32, Menu::quantizeTo1_32)
        TRANS_KEY(DeleteEvents, Menu::delete_)
        TRANS_KEY(CopyEvents, Menu::copy)
        TRANS_KEY(CutEvents, Menu::cut)
        TRANS_KEY(PasteEvents, Menu::paste)
        TRANS_KEY(DeleteClips, Menu::delete_)
        TRANS_KEY(CopyClips, Menu::copy)
        TRANS_KEY(CutClips, Menu::cut)
        TRANS_KEY(PasteClips, Menu::paste)
        TRANS_KEY(ClipTransposeUp, Menu::Selection::transposeUp)
        TRANS_KEY(ClipTransposeDown, Menu::Selection::transposeDown)
        //TRANS_NONE(ClipTransposeOctaveUp)
        //TRANS_NONE(ClipTransposeOctaveDown)
        //TRANS_NONE(ClipTransposeFifthUp)
        //TRANS_NONE(ClipTransposeFifthDown)
        //TRANS_NONE(ClipVolumeUp)
        //TRANS_NONE(ClipVolumeDown)
        TRANS_KEY(ToggleMuteClips, CommandPalette::toggleMute)
        TRANS_KEY(ToggleSoloClips, CommandPalette::toggleSolo)
        //TRANS_NONE(ToggleScalesHighlighting)
        TRANS_KEY(ToggleNoteNameGuides, CommandPalette::toggleNoteNameGuides)
        TRANS_KEY(ToggleLoopOverSelection, CommandPalette::toggleLoopOverSelection)
        TRANS_KEY(ToggleMetronome, Tooltips::metronome)
        //TRANS_NONE(ToggleMuteModifiers)
        //TRANS_NONE(ZoomIn)
        //TRANS_NONE(ZoomOut)
        TRANS_KEY(ZoomEntireClip, Tooltips::zoomToFit)
        TRANS_KEY(ToggleLockZoomLevel, Tooltips::lockZoom)
        //TRANS_NONE(Undo)
        //TRANS_NONE(Redo)
        TRANS_KEY(TimelineJumpNext, Tooltips::jumpToNextAnchor)
        TRANS_KEY(TimelineJumpPrevious, Tooltips::jumpToPrevAnchor)
        //TRANS_NONE(TimelineJumpHome)
        //TRANS_NONE(TimelineJumpEnd)
        //TRANS_NONE(TransportRecordingAwait)
        //TRANS_NONE(TransportRecordingStart)
        //TRANS_NONE(TransportPlaybackStart)
        //TRANS_NONE(TransportStop)
        TRANS_KEY(RenderToFLAC, Menu::Project::renderFlac)
        TRANS_KEY(RenderToWAV, Menu::Project::renderWav)
        TRANS_KEY(RenderToOGG, Menu::Project::renderOgg)
        TRANS_KEY(ImportMidi, Menu::Project::importMidi)
        TRANS_KEY(ExportMidi, Menu::Project::renderMidi)
        TRANS_KEY(DeleteProject, Menu::Project::deleteConfirm)
        TRANS_KEY(ProjectTransposeUp, Menu::Project::transposeUp)
        TRANS_KEY(ProjectTransposeDown, Menu::Project::transposeDown)
        //TRANS_NONE(ProjectSetOneTempo)
        TRANS_KEY(TrackSetOneTempo, Menu::setOneTempo)
        //TRANS_NONE(ProjectTempoUp1Bpm)
        //TRANS_NONE(ProjectTempoDown1Bpm)
        TRANS_KEY(TempoUp1Bpm, Menu::tempoUp1Bpm)
        TRANS_KEY(TempoDown1Bpm, Menu::tempoDown1Bpm)
        //TRANS_NONE(SwitchBetweenRolls)
        TRANS_KEY(SwitchToEditMode, Menu::Project::editorLinear)
        TRANS_KEY(SwitchToArrangeMode, Menu::Project::editorPattern)
        TRANS_KEY(SwitchToVersioningMode, Menu::Project::editorVcs)
        //TRANS_NONE(ShowPreviousPage)
        //TRANS_NONE(ShowNextPage)
        //TRANS_NONE(ShowRootPage)
        //TRANS_NONE(ToggleShowHideCombo)
        //TRANS_NONE(StartDragViewport)
        //TRANS_NONE(EndDragViewport)
        //TRANS_NONE(SelectAudioDeviceType)
        //TRANS_NONE(SelectAudioDevice)
        //TRANS_NONE(SelectSampleRate)
        //TRANS_NONE(SelectBufferSize)
        //TRANS_NONE(SelectMidiInputDevice)
        //TRANS_NONE(SelectMidiOutputDevice)
        //TRANS_NONE(SelectMidiNoOutputDevice)
        //TRANS_NONE(SelectFont)
        //TRANS_NONE(EditModeDefault)
        //TRANS_NONE(EditModeDraw)
        //TRANS_NONE(EditModePan)
        //TRANS_NONE(EditModeSelect)
        //TRANS_NONE(EditModeKnife)
        //TRANS_NONE(BeatShiftLeft)
        //TRANS_NONE(BeatShiftRight)
        //TRANS_NONE(LengthIncrease)
        //TRANS_NONE(LengthDecrease)
        TRANS_KEY(TransposeUp, Menu::Selection::transposeUp)
        TRANS_KEY(TransposeDown, Menu::Selection::transposeDown)
        TRANS_KEY(TransposeScaleKeyUp, Menu::Refactor::inScaleTransposeUp)
        TRANS_KEY(TransposeScaleKeyDown, Menu::Refactor::inScaleTransposeDown)
        TRANS_KEY(AlignToScale, Menu::Refactor::alignToScale)
        //TRANS_NONE(TransposeOctaveUp)
        //TRANS_NONE(TransposeOctaveDown)
        //TRANS_NONE(TransposeFifthUp)
        //TRANS_NONE(TransposeFifthDown)
        TRANS_KEY(MakeStaccato, Menu::Refactor::staccato)
        //TRANS_NONE(MakeStaccatissimo)
        TRANS_KEY(MakeLegato, Menu::Refactor::legato)
        //TRANS_NONE(MakeLegatoOverlapping)
        //TRANS_NONE(ViewportPanLeft)
        //TRANS_NONE(ViewportPanRight)
        //TRANS_NONE(ViewportPanUp)
        //TRANS_NONE(ViewportPanDown)
        //TRANS_NONE(CursorMoveLeft)
        //TRANS_NONE(CursorMoveRight)
        //TRANS_NONE(CursorMoveUp)
        //TRANS_NONE(CursorMoveDown)
        //TRANS_NONE(CursorSelectLeft)
        //TRANS_NONE(CursorSelectRight)
        //TRANS_NONE(CursorSelectUp)
        //TRANS_NONE(CursorSelectDown)
        //TRANS_NONE(CursorInteract)
        //TRANS_NONE(CursorEditHarmonicContext)
        //TRANS_NONE(CursorEditTimeContext)
        TRANS_KEY(CleanupOverlaps, Menu::Refactor::cleanup)
        TRANS_KEY(InvertChordUp, Menu::Refactor::inverseUp)
        TRANS_KEY(InvertChordDown, Menu::Refactor::inverseDown)
        TRANS_KEY(MelodicInversion, Menu::Refactor::melodicInversion)
        TRANS_KEY(Retrograde, Menu::Refactor::retrograde)
        //TRANS_NONE(ShowArpeggiatorsPanel)
        //TRANS_NONE(ShowRescalePanel)
        //TRANS_NONE(ShowChordPanel)
        //TRANS_NONE(ShowNewTrackPanel)
        //TRANS_NONE(ShowMetronomeSettings)
        //TRANS_NONE(ToggleVolumePanel)
        //TRANS_NONE(ToggleBottomMiniMap)
        //TRANS_NONE(NotesVolumeRandom)
        //TRANS_NONE(NotesVolumeFadeOut)
        //TRANS_NONE(NotesVolumeUp)
        //TRANS_NONE(NotesVolumeDown)
        TRANS_KEY(VersionControlToggleQuickStash, Menu::vcsChangesToggle)
        TRANS_KEY(VersionControlResetAll, Menu::vcsResetAll)
        TRANS_KEY(VersionControlCommitAll, Menu::vcsCommitAll)
        TRANS_KEY(VersionControlSelectAll, Menu::Selection::vcsSelectAll)
        TRANS_KEY(VersionControlSelectNone, Menu::Selection::vcsSelectNone)
        TRANS_KEY(VersionControlResetSelected, Menu::Selection::vcsReset)
        TRANS_KEY(VersionControlCommitSelected, Menu::Selection::vcsCommit)
        TRANS_KEY(VersionControlCheckout, Menu::Selection::vcsCheckout)
        TRANS_KEY(PatternsGroupByName, Menu::groupByName)
        TRANS_KEY(PatternsGroupByColour, Menu::groupByColour)
        TRANS_KEY(PatternsGroupByInstrument, Menu::groupByInstrument)
        TRANS_KEY(PatternsGroupById, Menu::groupByNone)
        //TRANS_NONE(CommandPalette)
        //TRANS_NONE(CommandPaletteWithMode)
        //TRANS_NONE(BreadcrumbsMenu)
        TRANS_KEY(KeyMapReset, Menu::keyboardMappingLoadScala)
        TRANS_KEY(KeyMapLoadScala, Menu::keyboardMappingReset)
        //TRANS_NONE(KeyMapNextPage)
        //TRANS_NONE(KeyMapPreviousPage)
        TRANS_KEY(KeyMapCopyToClipboard, Menu::copy)
        TRANS_KEY(KeyMapPasteFromClipboard, Menu::paste)
        //TRANS_NONE(SavePreset)
        //TRANS_NONE(SelectPreset)
        //TRANS_NONE(OpenMetronomeSample)
        //TRANS_NONE(ResetMetronomeSample)
        //TRANS_NONE(CommandPaletteClear)
        //TRANS_NONE(CommandPaletteDismiss)
        //TRANS_NONE(CommandPaletteCursorUp)
        //TRANS_NONE(CommandPaletteCursorDown)
        //TRANS_NONE(CommandPaletteCursorPageUp)
        //TRANS_NONE(CommandPaletteCursorPageDown)
        //TRANS_NONE(ChordToolDismissApply)
        //TRANS_NONE(ChordToolDismissCancel)
        //TRANS_NONE(ChordToolRootKeyUp)
        //TRANS_NONE(ChordToolRootKeyDown)
        //TRANS_NONE(ChordToolBeatShiftLeft)
        //TRANS_NONE(ChordToolBeatShiftRight)
        //TRANS_NONE(ChordToolNextPreset)
        //TRANS_NONE(ChordToolPreviousPreset)
        //TRANS_NONE(ChordToolPreset1)
        //TRANS_NONE(ChordToolPreset2)
        //TRANS_NONE(ChordToolPreset3)
        //TRANS_NONE(ChordToolPreset4)
        //TRANS_NONE(ChordToolPreset5)
        //TRANS_NONE(ChordToolPreset6)
        //TRANS_NONE(ChordToolPreset7)
        //TRANS_NONE(ChordToolPreset8)
        //TRANS_NONE(ChordToolPreset9)
        //TRANS_NONE(ChordToolPreset10)
        //TRANS_NONE(ChordToolPreset11)
        //TRANS_NONE(ChordToolPreset12)
        //TRANS_NONE(MenuDismiss)
        //TRANS_NONE(MenuSelect)
        //TRANS_NONE(MenuCursorUp)
        //TRANS_NONE(MenuCursorDown)
        //TRANS_NONE(MenuCursorPageUp)
        //TRANS_NONE(MenuCursorPageDown)
        //TRANS_NONE(MenuForward)
        //TRANS_NONE(MenuBack)
        //TRANS_NONE(MenuCursorHide)
        //TRANS_NONE(MenuCursorTryExitUp)
        //TRANS_NONE(MenuCursorTryExitDown)
        //TRANS_NONE(DialogDismissCancel)
        //TRANS_NONE(DialogDismissApply)
        //TRANS_NONE(DialogDismissDelete)
        //TRANS_NONE(DialogNextPreset)
        //TRANS_NONE(DialogPreviousPreset)
        //TRANS_NONE(DialogPreviewPreset)
        //TRANS_NONE(DialogStopPreviewPreset)
        //TRANS_NONE(DialogShowPresetsList)
        //TRANS_NONE(ComboDismissCancel)
        //TRANS_NONE(ComboDismissApply)
        //TRANS_NONE(ComboCursorUp)
        //TRANS_NONE(ComboCursorDown)
        //TRANS_NONE(ComboCursorPageUp)
        //TRANS_NONE(ComboCursorPageDown)
        default: return 0;
    }
}
