/*
    This file is part of Helio music sequencer.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#pragma once

#include "TreeNode.h"

class SettingsNode final : public TreeNode
{
public:

    SettingsNode();
    
    String getName() const noexcept override;
    Image getIcon() const noexcept override;

    void showPage() override;
    void recreatePage() override;

    bool hasMenu() const noexcept override;
    UniquePointer<Component> createMenu() override;

private:

    UniquePointer<Component> sectionsList;
    UniquePointer<Component> audioSettings;
    UniquePointer<Component> audioSettingsWrapper;
    UniquePointer<Component> uiSettings;
    UniquePointer<Component> uiSettingsWrapper;
    UniquePointer<Component> themeSettings;
    UniquePointer<Component> themeSettingsWrapper;
    UniquePointer<Component> settingsPage;

};
