/*
   Copyright 2012 Harri Smatt

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package fi.harism.wallpaper.flier;

public final class FlierConstants {

	// Cloud constants.
	public static final int CLOUD_COUNT = 10;
	public static final int CLOUD_POINT_COUNT = 10;

	// Full FBO coords.
	public static final byte FULL_QUAD_COORDS[] = { -1, 1, -1, -1, 1, 1, 1, -1 };

	// Color scheme blue.
	public static final float[] SCHEME_BLUE_BG_BOTTOM = { .3f, .4f, .6f };
	public static final float[] SCHEME_BLUE_BG_TOP = { .6f, .7f, .9f };
	public static final float[] SCHEME_BLUE_CLOUD = { .9f, .9f, .9f };
	public static final float[] SCHEME_BLUE_CLOUD_OUTLINE = { .5f, .5f, .5f };
	public static final float[] SCHEME_BLUE_PLANE = { .8f, .8f, .8f };
	public static final float[] SCHEME_BLUE_PLANE_OUTLINE = { .2f, .2f, .2f };
	public static final float[] SCHEME_BLUE_WAVE_BACK = { .3f, .4f, .6f };
	public static final float[] SCHEME_BLUE_WAVE_FRONT = { .5f, .6f, .8f };

	// Color scheme cinnamon.
	public static final float[] SCHEME_CINNAMON_BG_BOTTOM = { .6f, .3f, .1f };
	public static final float[] SCHEME_CINNAMON_BG_TOP = { .9f, .6f, .3f };
	public static final float[] SCHEME_CINNAMON_CLOUD = { .9f, .6f, .3f };
	public static final float[] SCHEME_CINNAMON_CLOUD_OUTLINE = { .6f, .3f, .1f };
	public static final float[] SCHEME_CINNAMON_PLANE = { .8f, .8f, .8f };
	public static final float[] SCHEME_CINNAMON_PLANE_OUTLINE = { .2f, .2f, .2f };
	public static final float[] SCHEME_CINNAMON_WAVE_BACK = { .6f, .3f, .1f };
	public static final float[] SCHEME_CINNAMON_WAVE_FRONT = { .7f, .4f, .1f };

	// Color scheme grey.
	public static final float[] SCHEME_GREY_BG_BOTTOM = { .4f, .4f, .4f };
	public static final float[] SCHEME_GREY_BG_TOP = { .7f, .7f, .7f };
	public static final float[] SCHEME_GREY_CLOUD = { .9f, .9f, .9f };
	public static final float[] SCHEME_GREY_CLOUD_OUTLINE = { .5f, .5f, .5f };
	public static final float[] SCHEME_GREY_PLANE = { .8f, .8f, .8f };
	public static final float[] SCHEME_GREY_PLANE_OUTLINE = { .2f, .2f, .2f };
	public static final float[] SCHEME_GREY_WAVE_BACK = { .4f, .4f, .4f };
	public static final float[] SCHEME_GREY_WAVE_FRONT = { .6f, .6f, .6f };

	// Color scheme strawberry.
	public static final float[] SCHEME_STRAWBERRY_BG_BOTTOM = { .6f, .3f, .4f };
	public static final float[] SCHEME_STRAWBERRY_BG_TOP = { .9f, .6f, .7f };
	public static final float[] SCHEME_STRAWBERRY_CLOUD = { 1.0f, .8f, .85f };
	public static final float[] SCHEME_STRAWBERRY_CLOUD_OUTLINE = { .7f, .4f,
			.45f };
	public static final float[] SCHEME_STRAWBERRY_PLANE = { .8f, .8f, .8f };
	public static final float[] SCHEME_STRAWBERRY_PLANE_OUTLINE = { .2f, .2f,
			.2f };
	public static final float[] SCHEME_STRAWBERRY_WAVE_BACK = { .6f, .3f, .4f };
	public static final float[] SCHEME_STRAWBERRY_WAVE_FRONT = { .8f, .5f, .6f };

}
