# Simple Reminder
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
      alt="Get it on F-Droid"
      height="75">](https://f-droid.org/packages/felixwiemuth.simplereminder/)


## About
Do you know the feeling when something crosses your mind you certainly want to remember to do later? An alarm is the best solution you know of? Then you haven't come across SimpleReminder yet!

This app lets you set up a reminder in very few steps:

1. Click "Add Reminder" on your home screen or use the Quick Settings Tile
2. Select a time, enter a message
3. Click OK

The reminder is saved and will pop up at the time set.

<p float="left">
<img src="https://raw.githubusercontent.com/felixwiemuth/SimpleReminder/develop/metadata/en-US/images/phoneScreenshots/1_AddReminder_v0.9.10.png" height="400">
<img src="https://raw.githubusercontent.com/felixwiemuth/SimpleReminder/develop/metadata/en-US/images/phoneScreenshots/2_RemindersList_v0.9.10.png" height="400">
<img src="https://raw.githubusercontent.com/felixwiemuth/SimpleReminder/develop/metadata/en-US/images/phoneScreenshots/3_Notification_v0.9.10.png" height="400">
<img src="https://raw.githubusercontent.com/felixwiemuth/SimpleReminder/develop/metadata/en-US/images/phoneScreenshots/4_AddReminderCalendar_v0.9.10.png" height="400">
<img src="https://raw.githubusercontent.com/felixwiemuth/SimpleReminder/develop/metadata/en-US/images/phoneScreenshots/5_AddReminderDaysAhead_v0.9.10.png" height="400">
</p>

## Project status
SimpleReminder is currently under development, and new features are added continuously. Your [feedback](#feedback) is welcome!


## Features
- Specific launcher icon and Quick Settings tile (Android 7.0+) to directly reach the "Add Reminder" dialog
- Easily add a reminder within the next 24 hours by using a clock widget
- Alternatively, type the time: absolute (12:30) or relative (+1:30)
- Choose a custom date for a reminder with +/- buttons or in a calendar
- When a reminder is due, a notification is shown (customizable via notification settings)
- Clear breakdown on due, upcoming and past reminders
- **Reschedule** or **edit** a reminder by clicking on the notification or its entry in the list
- **Nagging reminders**: repeat notifications in a given interval until dismissed


## Planned features
See the [issues](https://github.com/felixwiemuth/SimpleReminder/labels/Planned%20feature) for more detailed descriptions of some planned features.
You are welcome to comment and make suggestions − early feedback can help improve a feature before changes become more difficult!

- Create **templates** to quickly add frequent reminders
- Access templates with specific **launcher icons**
- Individual notification settings (including sound, vibration, LED) for each reminder (multiple notification channels on Android 8+)
- Recurring reminders: repeat every day/week/month/year ([#20](https://github.com/felixwiemuth/SimpleReminder/issues/20))
- Auto complete reminder text based on previous reminders / suggestions of templates
- Add **media** to reminders: take a photo, record a sound, ... − it will be shown in the notification!
- Sharing of reminder content
- Add reminders by selecting text anywhere (context menu) or via sharing a text, photo, ...
- Automatic deletion of old reminders after a customizable time
  - Option to delete reminders directly on dismiss
- Support of different languages (with choice), including local date formats

And much more!


## Feedback

If you discover a **problem**, please [create a bug report](https://github.com/felixwiemuth/SimpleReminder/issues/new?assignees=&labels=Bug+report&template=bug_report.md&title=).
Search [existing issues](https://github.com/felixwiemuth/SimpleReminder/issues?q=is%3Aissue) first!

If you have **suggestions**, want to ask a **question** or just have **general feedback**, visit the [discussions](https://github.com/felixwiemuth/SimpleReminder/discussions). Looking forward to hear from you!

If you have a **concrete suggestion**, you can also file a [feature request](https://github.com/felixwiemuth/SimpleReminder/issues/new?assignees=&labels=Feature+request&template=feature_request.md&title=) directly.

In any case, first check the list of planned features above, the discussions and [existing feature requests and planned features](https://github.com/felixwiemuth/SimpleReminder/issues?q=is%3Aissue) for related topics.

## Contributing
If you have ideas on how to improve SimpleReminder, you are welcome to contribute. There are several ways you can contribute:
- Share your ideas (see "Feedback")
- Help with graphics design (more information follows)
- Implement features or maintain code (see [Contributing](CONTRIBUTING.md) for more information)
- Translate SimpleReminder (please wait until the app has reached a more complete state)

For a list of contributors, see [CONTRIBUTORS.md](CONTRIBUTORS.md).


## Donations
To support this app, you can donate through the [Sponsor](https://github.com/sponsors/felixwiemuth) button on Github.
## License ##

Copyright (C) 2018-2025 Felix Wiemuth and [contributors](CONTRIBUTORS.md)


    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

This program includes third party software which is licensed under their own terms.
See [LICENSE.md](LICENSE.md) for details regarding licenses.

<!--  LocalWords:  customizable SimpleReminder Wiemuth
 -->
