<!-- This language menu is for the top-level english README only.
Please add your language here and remove this menu in your translation. -->
<div style="text-align: right">

[DE](https://github.com/Zimbelstern/Tournant/blob/master/docs/README_de-DE.md) |
EN

</div>

<div style="text-align: center">

  <a href="https://tournant.zimbelstern.eu" style="border-radius: 5%"><img src="https://tournant.zimbelstern.eu/favicon-192.png" alt="Tournant"></a>

  ![Latest release date](https://img.shields.io/endpoint?url=https://zimbelstern.eu/fdroid/tournant-date.json)
  ![Latest version](https://img.shields.io/endpoint?url=https://zimbelstern.eu/fdroid/tournant-version.json)
  ![F-Droid version](https://img.shields.io/f-droid/v/eu.zimbelstern.tournant)

  ![Platform: Android](https://img.shields.io/badge/platform-android-brightgreen)
  ![Language: Kotlin](https://img.shields.io/github/languages/top/zimbelstern/tournant?color=purple)
  ![Dishes served](https://img.shields.io/github/commits-since/zimbelstern/tournant/1.0?label=dishes%20served&color=00557f)

  [![GitHub sponsors](https://img.shields.io/github/sponsors/zimbelstern?label=GitHub%20sponsors)](https://github.com/sponsors/zimbelstern)
  [![Liberapay donations](https://img.shields.io/liberapay/receives/zimbelstern?label=Liberapay)](https://liberapay.com/Zimbelstern/donate)

</div>

# Tournant
<p style="font-size: 1.25em;">
  Recipe manager and cookbook for your cooking and baking recipes
</p>

Tournant serves your favorite dishes on your Android device!

<div style="text-align: center;">
  <img src="https://raw.githubusercontent.com/Zimbelstern/Tournant/master/app/src/full/play/listings/en-US/graphics/phone-screenshots/2.jpg" alt="Screenshot 2" style="margin: 5px; min-width: 150px; width: 24%"/>
  <img src="https://raw.githubusercontent.com/Zimbelstern/Tournant/master/app/src/full/play/listings/en-US/graphics/phone-screenshots/3.jpg" alt="Screenshot 3" style="margin: 5px; min-width: 150px; width: 24%"/>
  <img src="https://raw.githubusercontent.com/Zimbelstern/Tournant/master/app/src/full/play/listings/en-US/graphics/phone-screenshots/4.jpg" alt="Screenshot 4" style="margin: 5px; min-width: 150px; width: 24%"/>
  <img src="https://raw.githubusercontent.com/Zimbelstern/Tournant/master/app/src/full/play/listings/en-US/graphics/phone-screenshots/6.jpg" alt="Screenshot 6" style="margin: 5px; min-width: 150px; width: 24%"/>
</div>

## Features
- 📝 Create and edit recipes (with Markdown support)
- 💡 Add ingredients, ingredient groups and linked recipes
- 🔍 Search for recipes and categories and sort by various criteria
- 🧰 Scale ingredient lists, quickly start timers, log preparation dates, and benefit from other useful tools
- 📦 Export and share recipes as JSON files or ZIP archive with friends or use the Gourmand XML format

Tournant is compatible with [Gourmand Recipe Manager](https://github.com/GourmandRecipeManager/gourmand)  (previously known as Gourmet) for desktop. Importing, exporting and syncing with a Gourmand XML file is supported.

## Installation

### With an F-Droid compatible client
For free from Zimbelstern's official repository or F-Droid's main repository

<a href="https://zimbelstern.eu/fdroid/repo"><img alt="Official repository" src="https://zimbelstern.eu/badge.svg" style="height:75px"/></a>
<a href="https://f-droid.org/packages/eu.zimbelstern.tournant/"><img alt="Get it on F-Droid" src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" style="height:75px"/></a>

*Note: F-Droid's repository will be at least 2–3 days behind.*

### Support by purchase
<a href="https://play.google.com/store/apps/details?id=eu.zimbelstern.tournant"><img alt="Get it on Google Play" src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" style="height:75px; margin: 0 5px"/></a>

### Direct download
[APK without updates](https://tournant.zimbelstern.eu/tournant.apk)

## Transfer of recipes from Gourmand
- In Gourmand Recipe Manager, navigate to `File -> Export all recipes` or press `Ctrl + Shift + T`
- Choose `Gourmet XML file format` and give the file the extension `.xml` or `.grmt`
- Push the file to the external storage of your Android device, either manually or by using file synchronisation
- Open Tournant and choose your file

## Source
The source code is [freely available on Github](https://github.com/Zimbelstern/Tournant/).

## License
Tournant is (except for the fonts) licensed under the Apache License Version 2.0. See [LICENSE](https://github.com/Zimbelstern/Tournant/blob/master/LICENSE).

License information for the embedded fonts can be found in the metadata of the corresponding font files.

## Issues
Something is not working? Suggestions for improvements? Please use the [bug tracker](https://github.com/Zimbelstern/Tournant/issues).

## Contributions
Pull requests (especially those without prior acknowledgment) will usually *not* be accepted. Contributions on
translations, however, are very welcome.

## Translations
Translations of the app and metadata (description, documentation, samples) are managed with Weblate hosted on Codeberg.
Feel free to [improve translations or add your language](https://translate.codeberg.org/engage/tournant/).

<figure>
  <figcaption>Translation status</figcaption>
  <img src="https://translate.codeberg.org/widgets/tournant/-/multi-blue.svg" alt="Translation status"/>
</figure>

## Donate
If you would like to spread some love and buy the developer some chocolate, please [follow him here](https://zimbelstern.eu/donate).
