// dart format width=80
import 'package:drift/internal/versioned_schema.dart' as i0;
import 'package:drift/drift.dart' as i1;
import 'package:drift/drift.dart'; // ignore_for_file: type=lint,unused_import

// GENERATED BY drift_dev, DO NOT MODIFY.
final class Schema3 extends i0.VersionedSchema {
  Schema3({required super.database}) : super(version: 3);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    container,
    tab,
    tabFts,
    tabMaintainParentChainOnDelete,
    tabAfterInsert,
    tabAfterDelete,
    tabAfterUpdate,
  ];
  late final Shape0 container = Shape0(
    source: i0.VersionedTable(
      entityName: 'container',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_0, _column_1, _column_2, _column_3],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape1 tab = Shape1(
    source: i0.VersionedTable(
      entityName: 'tab',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [
        _column_0,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
        _column_9,
        _column_10,
        _column_11,
        _column_12,
        _column_13,
        _column_14,
        _column_15,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 tabFts = Shape2(
    source: i0.VersionedVirtualTable(
      entityName: 'tab_fts',
      moduleAndArgs:
          'fts5(title, url, extracted_content_plain, full_content_plain, content=tab, tokenize="trigram")',
      columns: [_column_8, _column_7, _column_12, _column_14],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Trigger tabMaintainParentChainOnDelete = i1.Trigger(
    'CREATE TRIGGER tab_maintain_parent_chain_on_delete BEFORE DELETE ON tab BEGIN UPDATE tab SET parent_id = OLD.parent_id WHERE parent_id = OLD.id;END',
    'tab_maintain_parent_chain_on_delete',
  );
  final i1.Trigger tabAfterInsert = i1.Trigger(
    'CREATE TRIGGER tab_after_insert AFTER INSERT ON tab BEGIN INSERT INTO tab_fts ("rowid", title, url, extracted_content_plain, full_content_plain) VALUES (new."rowid", new.title, new.url, new.extracted_content_plain, new.full_content_plain);END',
    'tab_after_insert',
  );
  final i1.Trigger tabAfterDelete = i1.Trigger(
    'CREATE TRIGGER tab_after_delete AFTER DELETE ON tab BEGIN INSERT INTO tab_fts (tab_fts, "rowid", title, url, extracted_content_plain, full_content_plain) VALUES (\'delete\', old."rowid", old.title, old.url, old.extracted_content_plain, old.full_content_plain);END',
    'tab_after_delete',
  );
  final i1.Trigger tabAfterUpdate = i1.Trigger(
    'CREATE TRIGGER tab_after_update AFTER UPDATE ON tab BEGIN INSERT INTO tab_fts (tab_fts, "rowid", title, url, extracted_content_plain, full_content_plain) VALUES (\'delete\', old."rowid", old.title, old.url, old.extracted_content_plain, old.full_content_plain);INSERT INTO tab_fts ("rowid", title, url, extracted_content_plain, full_content_plain) VALUES (new."rowid", new.title, new.url, new.extracted_content_plain, new.full_content_plain);END',
    'tab_after_update',
  );
}

class Shape0 extends i0.VersionedTable {
  Shape0({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get color =>
      columnsByName['color']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get metadata =>
      columnsByName['metadata']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_0(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'id',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'PRIMARY KEY NOT NULL',
    );
i1.GeneratedColumn<String> _column_1(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'name',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<int> _column_2(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'color',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_3(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'metadata',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );

class Shape1 extends i0.VersionedTable {
  Shape1({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get parentId =>
      columnsByName['parent_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get containerId =>
      columnsByName['container_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get orderKey =>
      columnsByName['order_key']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get url =>
      columnsByName['url']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get title =>
      columnsByName['title']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get isPrivate =>
      columnsByName['is_private']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get isProbablyReaderable =>
      columnsByName['is_probably_readerable']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get extractedContentMarkdown =>
      columnsByName['extracted_content_markdown']!
          as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get extractedContentPlain =>
      columnsByName['extracted_content_plain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get fullContentMarkdown =>
      columnsByName['full_content_markdown']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get fullContentPlain =>
      columnsByName['full_content_plain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timestamp =>
      columnsByName['timestamp']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<String> _column_4(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'parent_id',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: 'REFERENCES tab(id)ON DELETE SET NULL',
    );
i1.GeneratedColumn<String> _column_5(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'container_id',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: 'REFERENCES container(id)ON DELETE CASCADE',
    );
i1.GeneratedColumn<String> _column_6(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'order_key',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_7(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'url',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_8(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'title',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<int> _column_9(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'is_private',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
      $customConstraints: '',
    );
i1.GeneratedColumn<int> _column_10(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'is_probably_readerable',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_11(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'extracted_content_markdown',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_12(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'extracted_content_plain',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_13(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'full_content_markdown',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_14(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'full_content_plain',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<int> _column_15(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'timestamp',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );

class Shape2 extends i0.VersionedVirtualTable {
  Shape2({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get title =>
      columnsByName['title']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get url =>
      columnsByName['url']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get extractedContentPlain =>
      columnsByName['extracted_content_plain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get fullContentPlain =>
      columnsByName['full_content_plain']! as i1.GeneratedColumn<String>;
}

final class Schema4 extends i0.VersionedSchema {
  Schema4({required super.database}) : super(version: 4);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    container,
    tab,
    tabFts,
    tabMaintainParentChainOnDelete,
    tabAfterInsert,
    tabAfterDelete,
    tabAfterUpdate,
  ];
  late final Shape0 container = Shape0(
    source: i0.VersionedTable(
      entityName: 'container',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_0, _column_1, _column_2, _column_3],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 tab = Shape3(
    source: i0.VersionedTable(
      entityName: 'tab',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [
        _column_0,
        _column_16,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
        _column_9,
        _column_10,
        _column_11,
        _column_12,
        _column_13,
        _column_14,
        _column_15,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 tabFts = Shape2(
    source: i0.VersionedVirtualTable(
      entityName: 'tab_fts',
      moduleAndArgs:
          'fts5(title, url, extracted_content_plain, full_content_plain, content=tab, tokenize="trigram")',
      columns: [_column_8, _column_7, _column_12, _column_14],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Trigger tabMaintainParentChainOnDelete = i1.Trigger(
    'CREATE TRIGGER tab_maintain_parent_chain_on_delete BEFORE DELETE ON tab BEGIN UPDATE tab SET parent_id = OLD.parent_id WHERE parent_id = OLD.id;END',
    'tab_maintain_parent_chain_on_delete',
  );
  final i1.Trigger tabAfterInsert = i1.Trigger(
    'CREATE TRIGGER tab_after_insert AFTER INSERT ON tab BEGIN INSERT INTO tab_fts ("rowid", title, url, extracted_content_plain, full_content_plain) VALUES (new."rowid", new.title, new.url, new.extracted_content_plain, new.full_content_plain);END',
    'tab_after_insert',
  );
  final i1.Trigger tabAfterDelete = i1.Trigger(
    'CREATE TRIGGER tab_after_delete AFTER DELETE ON tab BEGIN INSERT INTO tab_fts (tab_fts, "rowid", title, url, extracted_content_plain, full_content_plain) VALUES (\'delete\', old."rowid", old.title, old.url, old.extracted_content_plain, old.full_content_plain);END',
    'tab_after_delete',
  );
  final i1.Trigger tabAfterUpdate = i1.Trigger(
    'CREATE TRIGGER tab_after_update AFTER UPDATE ON tab BEGIN INSERT INTO tab_fts (tab_fts, "rowid", title, url, extracted_content_plain, full_content_plain) VALUES (\'delete\', old."rowid", old.title, old.url, old.extracted_content_plain, old.full_content_plain);INSERT INTO tab_fts ("rowid", title, url, extracted_content_plain, full_content_plain) VALUES (new."rowid", new.title, new.url, new.extracted_content_plain, new.full_content_plain);END',
    'tab_after_update',
  );
}

class Shape3 extends i0.VersionedTable {
  Shape3({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get id =>
      columnsByName['id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get source =>
      columnsByName['source']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get parentId =>
      columnsByName['parent_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get containerId =>
      columnsByName['container_id']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get orderKey =>
      columnsByName['order_key']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get url =>
      columnsByName['url']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get title =>
      columnsByName['title']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get isPrivate =>
      columnsByName['is_private']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get isProbablyReaderable =>
      columnsByName['is_probably_readerable']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get extractedContentMarkdown =>
      columnsByName['extracted_content_markdown']!
          as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get extractedContentPlain =>
      columnsByName['extracted_content_plain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get fullContentMarkdown =>
      columnsByName['full_content_markdown']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get fullContentPlain =>
      columnsByName['full_content_plain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timestamp =>
      columnsByName['timestamp']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_16(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'source',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );

final class Schema5 extends i0.VersionedSchema {
  Schema5({required super.database}) : super(version: 5);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    container,
    tab,
    tabFts,
    tabMaintainParentChainOnDelete,
    tabAfterInsert,
    tabAfterDelete,
    tabAfterUpdate,
  ];
  late final Shape0 container = Shape0(
    source: i0.VersionedTable(
      entityName: 'container',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_0, _column_1, _column_2, _column_3],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 tab = Shape3(
    source: i0.VersionedTable(
      entityName: 'tab',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [
        _column_0,
        _column_16,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_8,
        _column_9,
        _column_10,
        _column_11,
        _column_12,
        _column_13,
        _column_14,
        _column_15,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 tabFts = Shape2(
    source: i0.VersionedVirtualTable(
      entityName: 'tab_fts',
      moduleAndArgs:
          'fts5(title, url, extracted_content_plain, full_content_plain, content=tab, tokenize="trigram")',
      columns: [_column_8, _column_7, _column_12, _column_14],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Trigger tabMaintainParentChainOnDelete = i1.Trigger(
    'CREATE TRIGGER tab_maintain_parent_chain_on_delete BEFORE DELETE ON tab BEGIN UPDATE tab SET parent_id = CASE WHEN OLD.parent_id IS NOT NULL AND EXISTS (SELECT 1 FROM tab WHERE id = OLD.parent_id) THEN OLD.parent_id ELSE NULL END WHERE parent_id = OLD.id;END',
    'tab_maintain_parent_chain_on_delete',
  );
  final i1.Trigger tabAfterInsert = i1.Trigger(
    'CREATE TRIGGER tab_after_insert AFTER INSERT ON tab BEGIN INSERT INTO tab_fts ("rowid", title, url, extracted_content_plain, full_content_plain) VALUES (new."rowid", new.title, new.url, new.extracted_content_plain, new.full_content_plain);END',
    'tab_after_insert',
  );
  final i1.Trigger tabAfterDelete = i1.Trigger(
    'CREATE TRIGGER tab_after_delete AFTER DELETE ON tab BEGIN INSERT INTO tab_fts (tab_fts, "rowid", title, url, extracted_content_plain, full_content_plain) VALUES (\'delete\', old."rowid", old.title, old.url, old.extracted_content_plain, old.full_content_plain);END',
    'tab_after_delete',
  );
  final i1.Trigger tabAfterUpdate = i1.Trigger(
    'CREATE TRIGGER tab_after_update AFTER UPDATE ON tab BEGIN INSERT INTO tab_fts (tab_fts, "rowid", title, url, extracted_content_plain, full_content_plain) VALUES (\'delete\', old."rowid", old.title, old.url, old.extracted_content_plain, old.full_content_plain);INSERT INTO tab_fts ("rowid", title, url, extracted_content_plain, full_content_plain) VALUES (new."rowid", new.title, new.url, new.extracted_content_plain, new.full_content_plain);END',
    'tab_after_update',
  );
}

i0.MigrationStepWithVersion migrationSteps({
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
}) {
  return (currentVersion, database) async {
    switch (currentVersion) {
      case 2:
        final schema = Schema3(database: database);
        final migrator = i1.Migrator(database, schema);
        await from2To3(migrator, schema);
        return 3;
      case 3:
        final schema = Schema4(database: database);
        final migrator = i1.Migrator(database, schema);
        await from3To4(migrator, schema);
        return 4;
      case 4:
        final schema = Schema5(database: database);
        final migrator = i1.Migrator(database, schema);
        await from4To5(migrator, schema);
        return 5;
      default:
        throw ArgumentError.value('Unknown migration from $currentVersion');
    }
  };
}

i1.OnUpgrade stepByStep({
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
}) => i0.VersionedSchema.stepByStepHelper(
  step: migrationSteps(
    from2To3: from2To3,
    from3To4: from3To4,
    from4To5: from4To5,
  ),
);
