// dart format width=80
import 'package:drift/internal/versioned_schema.dart' as i0;
import 'package:drift/drift.dart' as i1;
import 'package:drift/drift.dart'; // ignore_for_file: type=lint,unused_import

// GENERATED BY drift_dev, DO NOT MODIFY.
final class Schema2 extends i0.VersionedSchema {
  Schema2({required super.database}) : super(version: 2);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    bang,
    bangSync,
    bangFrequency,
    bangHistory,
    bangFts,
    bangDataView,
    bangAfterInsert,
    bangAfterDelete,
    bangAfterUpdate,
  ];
  late final Shape0 bang = Shape0(
    source: i0.VersionedTable(
      entityName: 'bang',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY("trigger", "group")'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape1 bangSync = Shape1(
    source: i0.VersionedTable(
      entityName: 'bang_sync',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_8, _column_9],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 bangFrequency = Shape2(
    source: i0.VersionedTable(
      entityName: 'bang_frequency',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'PRIMARY KEY("trigger", "group")',
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")ON DELETE CASCADE',
      ],
      columns: [_column_0, _column_1, _column_10, _column_11],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 bangHistory = Shape3(
    source: i0.VersionedTable(
      entityName: 'bang_history',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")',
      ],
      columns: [_column_12, _column_0, _column_1, _column_13],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape4 bangFts = Shape4(
    source: i0.VersionedVirtualTable(
      entityName: 'bang_fts',
      moduleAndArgs:
          'fts5(trigger, website_name, content=bang, prefix=\'2 3\')',
      columns: [_column_14, _column_15],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape5 bangDataView = Shape5(
    source: i0.VersionedView(
      entityName: 'bang_data_view',
      createViewStmt:
          'CREATE VIEW bang_data_view AS SELECT b.*, bf.frequency, bf.last_used FROM bang AS b LEFT JOIN bang_frequency AS bf ON b."trigger" = bf."trigger" AND b."group" = bf."group";',
      columns: [
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
        _column_22,
        _column_23,
        _column_24,
        _column_25,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Trigger bangAfterInsert = i1.Trigger(
    'CREATE TRIGGER bang_after_insert AFTER INSERT ON bang BEGIN INSERT INTO bang_fts ("rowid", "trigger", website_name) VALUES (new."rowid", new."trigger", new.website_name);END',
    'bang_after_insert',
  );
  final i1.Trigger bangAfterDelete = i1.Trigger(
    'CREATE TRIGGER bang_after_delete AFTER DELETE ON bang BEGIN INSERT INTO bang_fts (bang_fts, "rowid", "trigger", website_name) VALUES (\'delete\', old."rowid", old."trigger", old.website_name);END',
    'bang_after_delete',
  );
  final i1.Trigger bangAfterUpdate = i1.Trigger(
    'CREATE TRIGGER bang_after_update AFTER UPDATE ON bang BEGIN INSERT INTO bang_fts (bang_fts, "rowid", "trigger", website_name) VALUES (\'delete\', old."rowid", old."trigger", old.website_name);INSERT INTO bang_fts ("rowid", "trigger", website_name) VALUES (new."rowid", new."trigger", new.website_name);END',
    'bang_after_update',
  );
}

class Shape0 extends i0.VersionedTable {
  Shape0({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get domain =>
      columnsByName['domain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get urlTemplate =>
      columnsByName['url_template']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get subCategory =>
      columnsByName['sub_category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get format =>
      columnsByName['format']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_0(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'trigger',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<int> _column_1(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'group',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_2(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'website_name',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_3(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'domain',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_4(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'url_template',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_5(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'category',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_6(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'sub_category',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_7(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'format',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );

class Shape1 extends i0.VersionedTable {
  Shape1({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get lastSync =>
      columnsByName['last_sync']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<int> _column_8(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'group',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'PRIMARY KEY NOT NULL',
    );
i1.GeneratedColumn<DateTime> _column_9(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'last_sync',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
      $customConstraints: 'NOT NULL',
    );

class Shape2 extends i0.VersionedTable {
  Shape2({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get frequency =>
      columnsByName['frequency']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get lastUsed =>
      columnsByName['last_used']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<int> _column_10(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'frequency',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<DateTime> _column_11(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'last_used',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
      $customConstraints: 'NOT NULL',
    );

class Shape3 extends i0.VersionedTable {
  Shape3({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get searchQuery =>
      columnsByName['search_query']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get searchDate =>
      columnsByName['search_date']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<String> _column_12(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'search_query',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'UNIQUE NOT NULL',
    );
i1.GeneratedColumn<DateTime> _column_13(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'search_date',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
      $customConstraints: 'NOT NULL',
    );

class Shape4 extends i0.VersionedVirtualTable {
  Shape4({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_14(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'trigger',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_15(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'website_name',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );

class Shape5 extends i0.VersionedView {
  Shape5({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get domain =>
      columnsByName['domain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get urlTemplate =>
      columnsByName['url_template']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get subCategory =>
      columnsByName['sub_category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get format =>
      columnsByName['format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get frequency =>
      columnsByName['frequency']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get lastUsed =>
      columnsByName['last_used']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<String> _column_16(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'trigger',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_17(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'group',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_18(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'website_name',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_19(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'domain',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_20(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'url_template',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_21(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'category',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_22(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'sub_category',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_23(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'format',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_24(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'frequency',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<DateTime> _column_25(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'last_used',
      aliasedName,
      true,
      type: i1.DriftSqlType.dateTime,
    );

final class Schema3 extends i0.VersionedSchema {
  Schema3({required super.database}) : super(version: 3);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    bang,
    bangTriggers,
    idxBangTriggersLookup,
    bangTriggersAfterInsert,
    bangTriggersAfterUpdate,
    bangSync,
    bangFrequency,
    bangHistory,
    bangFts,
    bangTriggersFts,
    bangDataView,
    bangAfterInsert,
    bangAfterDelete,
    bangAfterUpdate,
    bangTriggersAfterInsertFts,
    bangTriggersAfterDeleteFts,
    bangTriggersAfterUpdateFts,
  ];
  late final Shape6 bang = Shape6(
    source: i0.VersionedTable(
      entityName: 'bang',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY("trigger", "group")'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_26,
        _column_27,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 bangTriggers = Shape7(
    source: i0.VersionedTable(
      entityName: 'bang_triggers',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'PRIMARY KEY("trigger", "group", additional_trigger)',
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")ON DELETE CASCADE',
      ],
      columns: [_column_0, _column_1, _column_28],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxBangTriggersLookup = i1.Index(
    'idx_bang_triggers_lookup',
    'CREATE INDEX idx_bang_triggers_lookup ON bang_triggers (additional_trigger, "group")',
  );
  final i1.Trigger bangTriggersAfterInsert = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_insert AFTER INSERT ON bang WHEN new.additional_triggers IS NOT NULL BEGIN INSERT INTO bang_triggers ("trigger", "group", additional_trigger) SELECT new."trigger", new."group", json_each.value FROM json_each(new.additional_triggers);END',
    'bang_triggers_after_insert',
  );
  final i1.Trigger bangTriggersAfterUpdate = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_update AFTER UPDATE ON bang BEGIN DELETE FROM bang_triggers WHERE "trigger" = old."trigger" AND "group" = old."group";INSERT INTO bang_triggers ("trigger", "group", additional_trigger) SELECT new."trigger", new."group", json_each.value FROM json_each(new.additional_triggers)WHERE new.additional_triggers IS NOT NULL;END',
    'bang_triggers_after_update',
  );
  late final Shape1 bangSync = Shape1(
    source: i0.VersionedTable(
      entityName: 'bang_sync',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_8, _column_9],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 bangFrequency = Shape2(
    source: i0.VersionedTable(
      entityName: 'bang_frequency',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'PRIMARY KEY("trigger", "group")',
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")ON DELETE CASCADE',
      ],
      columns: [_column_0, _column_1, _column_10, _column_11],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 bangHistory = Shape3(
    source: i0.VersionedTable(
      entityName: 'bang_history',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")',
      ],
      columns: [_column_12, _column_0, _column_1, _column_13],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape4 bangFts = Shape4(
    source: i0.VersionedVirtualTable(
      entityName: 'bang_fts',
      moduleAndArgs:
          'fts5(trigger, website_name, content=bang, prefix=\'2 3\')',
      columns: [_column_14, _column_15],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 bangTriggersFts = Shape8(
    source: i0.VersionedVirtualTable(
      entityName: 'bang_triggers_fts',
      moduleAndArgs:
          'fts5(additional_trigger, content=bang_triggers, prefix=\'2 3\')',
      columns: [_column_29],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape9 bangDataView = Shape9(
    source: i0.VersionedView(
      entityName: 'bang_data_view',
      createViewStmt:
          'CREATE VIEW bang_data_view AS SELECT b.*, bf.frequency, bf.last_used FROM bang AS b LEFT JOIN bang_frequency AS bf ON b."trigger" = bf."trigger" AND b."group" = bf."group";',
      columns: [
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
        _column_22,
        _column_23,
        _column_30,
        _column_31,
        _column_24,
        _column_25,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Trigger bangAfterInsert = i1.Trigger(
    'CREATE TRIGGER bang_after_insert AFTER INSERT ON bang BEGIN INSERT INTO bang_fts ("rowid", "trigger", website_name) VALUES (new."rowid", new."trigger", new.website_name);END',
    'bang_after_insert',
  );
  final i1.Trigger bangAfterDelete = i1.Trigger(
    'CREATE TRIGGER bang_after_delete AFTER DELETE ON bang BEGIN INSERT INTO bang_fts (bang_fts, "rowid", "trigger", website_name) VALUES (\'delete\', old."rowid", old."trigger", old.website_name);END',
    'bang_after_delete',
  );
  final i1.Trigger bangAfterUpdate = i1.Trigger(
    'CREATE TRIGGER bang_after_update AFTER UPDATE ON bang BEGIN INSERT INTO bang_fts (bang_fts, "rowid", "trigger", website_name) VALUES (\'delete\', old."rowid", old."trigger", old.website_name);INSERT INTO bang_fts ("rowid", "trigger", website_name) VALUES (new."rowid", new."trigger", new.website_name);END',
    'bang_after_update',
  );
  final i1.Trigger bangTriggersAfterInsertFts = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_insert_fts AFTER INSERT ON bang_triggers BEGIN INSERT INTO bang_triggers_fts ("rowid", additional_trigger) VALUES (new."rowid", new.additional_trigger);END',
    'bang_triggers_after_insert_fts',
  );
  final i1.Trigger bangTriggersAfterDeleteFts = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_delete_fts AFTER DELETE ON bang_triggers BEGIN INSERT INTO bang_triggers_fts (bang_triggers_fts, "rowid", additional_trigger) VALUES (\'delete\', old."rowid", old.additional_trigger);END',
    'bang_triggers_after_delete_fts',
  );
  final i1.Trigger bangTriggersAfterUpdateFts = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_update_fts AFTER UPDATE ON bang_triggers BEGIN INSERT INTO bang_triggers_fts (bang_triggers_fts, "rowid", additional_trigger) VALUES (\'delete\', old."rowid", old.additional_trigger);INSERT INTO bang_triggers_fts ("rowid", additional_trigger) VALUES (new."rowid", new.additional_trigger);END',
    'bang_triggers_after_update_fts',
  );
}

class Shape6 extends i0.VersionedTable {
  Shape6({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get domain =>
      columnsByName['domain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get urlTemplate =>
      columnsByName['url_template']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get subCategory =>
      columnsByName['sub_category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get format =>
      columnsByName['format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get additionalTriggers =>
      columnsByName['additional_triggers']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get searxngApi =>
      columnsByName['searxng_api']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<String> _column_26(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'additional_triggers',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<bool> _column_27(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'searxng_api',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      $customConstraints: 'NOT NULL DEFAULT FALSE',
      defaultValue: const CustomExpression('FALSE'),
    );

class Shape7 extends i0.VersionedTable {
  Shape7({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get additionalTrigger =>
      columnsByName['additional_trigger']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_28(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'additional_trigger',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );

class Shape8 extends i0.VersionedVirtualTable {
  Shape8({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get additionalTrigger =>
      columnsByName['additional_trigger']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_29(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'additional_trigger',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );

class Shape9 extends i0.VersionedView {
  Shape9({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get domain =>
      columnsByName['domain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get urlTemplate =>
      columnsByName['url_template']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get subCategory =>
      columnsByName['sub_category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get format =>
      columnsByName['format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get additionalTriggers =>
      columnsByName['additional_triggers']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get searxngApi =>
      columnsByName['searxng_api']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get frequency =>
      columnsByName['frequency']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get lastUsed =>
      columnsByName['last_used']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<String> _column_30(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'additional_triggers',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<bool> _column_31(String aliasedName) =>
    i1.GeneratedColumn<bool>(
      'searxng_api',
      aliasedName,
      false,
      type: i1.DriftSqlType.bool,
      defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
        'CHECK ("searxng_api" IN (0, 1))',
      ),
    );

final class Schema4 extends i0.VersionedSchema {
  Schema4({required super.database}) : super(version: 4);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    bang,
    bangTriggers,
    idxBangTriggersLookup,
    bangTriggersAfterInsert,
    bangTriggersAfterUpdate,
    bangSync,
    bangFrequency,
    bangHistory,
    bangFts,
    bangTriggersFts,
    bangDataView,
    bangAfterInsert,
    bangAfterDelete,
    bangAfterUpdate,
    bangTriggersAfterInsertFts,
    bangTriggersAfterDeleteFts,
    bangTriggersAfterUpdateFts,
  ];
  late final Shape10 bang = Shape10(
    source: i0.VersionedTable(
      entityName: 'bang',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY("trigger", "group")'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
        _column_26,
        _column_32,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape7 bangTriggers = Shape7(
    source: i0.VersionedTable(
      entityName: 'bang_triggers',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'PRIMARY KEY("trigger", "group", additional_trigger)',
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")ON DELETE CASCADE',
      ],
      columns: [_column_0, _column_1, _column_28],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Index idxBangTriggersLookup = i1.Index(
    'idx_bang_triggers_lookup',
    'CREATE INDEX idx_bang_triggers_lookup ON bang_triggers (additional_trigger, "group")',
  );
  final i1.Trigger bangTriggersAfterInsert = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_insert AFTER INSERT ON bang WHEN new.additional_triggers IS NOT NULL BEGIN INSERT INTO bang_triggers ("trigger", "group", additional_trigger) SELECT new."trigger", new."group", json_each.value FROM json_each(new.additional_triggers);END',
    'bang_triggers_after_insert',
  );
  final i1.Trigger bangTriggersAfterUpdate = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_update AFTER UPDATE ON bang BEGIN DELETE FROM bang_triggers WHERE "trigger" = old."trigger" AND "group" = old."group";INSERT INTO bang_triggers ("trigger", "group", additional_trigger) SELECT new."trigger", new."group", json_each.value FROM json_each(new.additional_triggers)WHERE new.additional_triggers IS NOT NULL;END',
    'bang_triggers_after_update',
  );
  late final Shape11 bangSync = Shape11(
    source: i0.VersionedTable(
      entityName: 'bang_sync',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_8, _column_33],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape12 bangFrequency = Shape12(
    source: i0.VersionedTable(
      entityName: 'bang_frequency',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'PRIMARY KEY("trigger", "group")',
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")ON DELETE CASCADE',
      ],
      columns: [_column_0, _column_1, _column_10, _column_34],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape13 bangHistory = Shape13(
    source: i0.VersionedTable(
      entityName: 'bang_history',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")ON DELETE CASCADE',
      ],
      columns: [_column_12, _column_0, _column_1, _column_35],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape4 bangFts = Shape4(
    source: i0.VersionedVirtualTable(
      entityName: 'bang_fts',
      moduleAndArgs:
          'fts5(trigger, website_name, content=bang, prefix=\'2 3\')',
      columns: [_column_36, _column_37],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape8 bangTriggersFts = Shape8(
    source: i0.VersionedVirtualTable(
      entityName: 'bang_triggers_fts',
      moduleAndArgs:
          'fts5(additional_trigger, content=bang_triggers, prefix=\'2 3\')',
      columns: [_column_38],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape14 bangDataView = Shape14(
    source: i0.VersionedView(
      entityName: 'bang_data_view',
      createViewStmt:
          'CREATE VIEW bang_data_view AS SELECT b.*, bf.frequency, bf.last_used FROM bang AS b LEFT JOIN bang_frequency AS bf ON b."trigger" = bf."trigger" AND b."group" = bf."group";',
      columns: [
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
        _column_22,
        _column_23,
        _column_30,
        _column_39,
        _column_24,
        _column_40,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Trigger bangAfterInsert = i1.Trigger(
    'CREATE TRIGGER bang_after_insert AFTER INSERT ON bang BEGIN INSERT INTO bang_fts ("rowid", "trigger", website_name) VALUES (new."rowid", new."trigger", new.website_name);END',
    'bang_after_insert',
  );
  final i1.Trigger bangAfterDelete = i1.Trigger(
    'CREATE TRIGGER bang_after_delete AFTER DELETE ON bang BEGIN INSERT INTO bang_fts (bang_fts, "rowid", "trigger", website_name) VALUES (\'delete\', old."rowid", old."trigger", old.website_name);END',
    'bang_after_delete',
  );
  final i1.Trigger bangAfterUpdate = i1.Trigger(
    'CREATE TRIGGER bang_after_update AFTER UPDATE ON bang BEGIN INSERT INTO bang_fts (bang_fts, "rowid", "trigger", website_name) VALUES (\'delete\', old."rowid", old."trigger", old.website_name);INSERT INTO bang_fts ("rowid", "trigger", website_name) VALUES (new."rowid", new."trigger", new.website_name);END',
    'bang_after_update',
  );
  final i1.Trigger bangTriggersAfterInsertFts = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_insert_fts AFTER INSERT ON bang_triggers BEGIN INSERT INTO bang_triggers_fts ("rowid", additional_trigger) VALUES (new."rowid", new.additional_trigger);END',
    'bang_triggers_after_insert_fts',
  );
  final i1.Trigger bangTriggersAfterDeleteFts = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_delete_fts AFTER DELETE ON bang_triggers BEGIN INSERT INTO bang_triggers_fts (bang_triggers_fts, "rowid", additional_trigger) VALUES (\'delete\', old."rowid", old.additional_trigger);END',
    'bang_triggers_after_delete_fts',
  );
  final i1.Trigger bangTriggersAfterUpdateFts = i1.Trigger(
    'CREATE TRIGGER bang_triggers_after_update_fts AFTER UPDATE ON bang_triggers BEGIN INSERT INTO bang_triggers_fts (bang_triggers_fts, "rowid", additional_trigger) VALUES (\'delete\', old."rowid", old.additional_trigger);INSERT INTO bang_triggers_fts ("rowid", additional_trigger) VALUES (new."rowid", new.additional_trigger);END',
    'bang_triggers_after_update_fts',
  );
}

class Shape10 extends i0.VersionedTable {
  Shape10({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get domain =>
      columnsByName['domain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get urlTemplate =>
      columnsByName['url_template']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get subCategory =>
      columnsByName['sub_category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get format =>
      columnsByName['format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get additionalTriggers =>
      columnsByName['additional_triggers']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get searxngApi =>
      columnsByName['searxng_api']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_32(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'searxng_api',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL DEFAULT FALSE',
      defaultValue: const i1.CustomExpression('FALSE'),
    );

class Shape11 extends i0.VersionedTable {
  Shape11({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get lastSync =>
      columnsByName['last_sync']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_33(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'last_sync',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );

class Shape12 extends i0.VersionedTable {
  Shape12({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get frequency =>
      columnsByName['frequency']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get lastUsed =>
      columnsByName['last_used']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_34(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'last_used',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );

class Shape13 extends i0.VersionedTable {
  Shape13({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get searchQuery =>
      columnsByName['search_query']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get searchDate =>
      columnsByName['search_date']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_35(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'search_date',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_36(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'trigger',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_37(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'website_name',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_38(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'additional_trigger',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );

class Shape14 extends i0.VersionedView {
  Shape14({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get domain =>
      columnsByName['domain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get urlTemplate =>
      columnsByName['url_template']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get subCategory =>
      columnsByName['sub_category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get format =>
      columnsByName['format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get additionalTriggers =>
      columnsByName['additional_triggers']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get searxngApi =>
      columnsByName['searxng_api']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get frequency =>
      columnsByName['frequency']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get lastUsed =>
      columnsByName['last_used']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_39(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'searxng_api',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<int> _column_40(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'last_used',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i0.MigrationStepWithVersion migrationSteps({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
}) {
  return (currentVersion, database) async {
    switch (currentVersion) {
      case 1:
        final schema = Schema2(database: database);
        final migrator = i1.Migrator(database, schema);
        await from1To2(migrator, schema);
        return 2;
      case 2:
        final schema = Schema3(database: database);
        final migrator = i1.Migrator(database, schema);
        await from2To3(migrator, schema);
        return 3;
      case 3:
        final schema = Schema4(database: database);
        final migrator = i1.Migrator(database, schema);
        await from3To4(migrator, schema);
        return 4;
      default:
        throw ArgumentError.value('Unknown migration from $currentVersion');
    }
  };
}

i1.OnUpgrade stepByStep({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
}) => i0.VersionedSchema.stepByStepHelper(
  step: migrationSteps(
    from1To2: from1To2,
    from2To3: from2To3,
    from3To4: from3To4,
  ),
);
