// Autogenerated from Pigeon (v26.1.2), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

List<Object?> wrapResponse({Object? result, PlatformException? error, bool empty = false}) {
  if (empty) {
    return <Object?>[];
  }
  if (error == null) {
    return <Object?>[result];
  }
  return <Object?>[error.code, error.message, error.details];
}
bool _deepEquals(Object? a, Object? b) {
  if (a is List && b is List) {
    return a.length == b.length &&
        a.indexed
        .every(((int, dynamic) item) => _deepEquals(item.$2, b[item.$1]));
  }
  if (a is Map && b is Map) {
    return a.length == b.length && a.entries.every((MapEntry<Object?, Object?> entry) =>
        (b as Map<Object?, Object?>).containsKey(entry.key) &&
        _deepEquals(entry.value, b[entry.key]));
  }
  return a == b;
}


/// Indicates what location the tabs should be restored at
enum RestoreLocation {
  /// Restore tabs at the beginning of the tab list
  beginning,
  /// Restore tabs at the end of the tab list
  end,
  /// Restore tabs at a specific index in the tab list
  atIndex,
}

/// An icon resource type.
enum IconType {
  favicon,
  appleTouchIcon,
  fluidIcon,
  imageSrc,
  openGraph,
  twitter,
  microsoftTile,
  tippyTop,
  manifestIcon,
}

/// Supported sizes.
///
/// We are trying to limit the supported sizes in order to optimize our caching strategy.
enum IconSize {
  defaultSize,
  launcher,
  launcherAdaptive,
}

/// The source of an [Icon].
enum IconSource {
  /// This icon was generated.
  generator,
  /// This icon was downloaded.
  download,
  /// This icon was inlined in the document.
  inline,
  /// This icon was loaded from an in-memory cache.
  memory,
  /// This icon was loaded from a disk cache.
  disk,
}

enum CookieSameSiteStatus {
  noRestriction,
  lax,
  strict,
  unspecified,
}

enum VisitType {
  /// The user followed a link and got a new toplevel window.
  link,
  /// The user typed the page's URL in the URL bar or selected it from
  /// URL bar autocomplete results, clicked on it from a history query
  /// (from the History sidebar, History menu, or history query in the
  /// personal toolbar or Places organizer.
  typed,
  /// The user followed a bookmark to get to the page.
  bookmark,
  /// Some inner content is loaded. This is true of all images on a
  /// page, and the contents of the iframe. It is also true of any
  /// content in a frame if the user did not explicitly follow a link
  /// to get there.
  embed,
  /// Set when the transition was a permanent redirect.
  redirectPermanent,
  /// Set when the transition was a temporary redirect.
  redirectTemporary,
  /// Set when the transition is a download.
  download,
  /// The user followed a link and got a visit in a frame.
  framedLink,
  /// The user reloaded a page.
  reload,
}

enum SelectionPattern {
  phone,
  email,
}

enum WebExtensionActionType {
  browser,
  page,
}

enum GeckoSuggestionType {
  session,
  clipboard,
  history,
}

enum TrackingProtectionPolicy {
  none,
  recommended,
  strict,
  custom,
}

enum HttpsOnlyMode {
  disabled,
  privateOnly,
  enabled,
}

enum QueryParameterStripping {
  disabled,
  privateOnly,
  enabled,
}

enum BounceTrackingProtectionMode {
  /// Fully disabled.
  disabled,
  /// Fully enabled.
  enabled,
  /// Disabled, but collects user interaction data. Use this mode as the
  /// "disabled" state when the feature can be toggled on and off, e.g. via
  /// preferences.
  enabledStandby,
  /// Feature enabled, but tracker purging is only simulated. Used for
  /// testing and telemetry collection.
  enabledDryRun,
}

enum ColorScheme {
  system,
  light,
  dark,
}

enum CookieBannerHandlingMode {
  disabled,
  rejectAll,
  rejectOrAcceptAll,
}

enum WebContentIsolationStrategy {
  isolateNothing,
  isolateEverything,
  isolateHighValue,
}

enum DohSettingsMode {
  geckoDefault,
  increased,
  max,
  off,
}

/// Status that represents every state that a download can be in.
enum DownloadStatus {
  /// Indicates that the download is in the first state after creation but not yet [DOWNLOADING].
  initiated,
  /// Indicates that an [INITIATED] download is now actively being downloaded.
  downloading,
  /// Indicates that the download that has been [DOWNLOADING] has been paused.
  paused,
  /// Indicates that the download that has been [DOWNLOADING] has been cancelled.
  cancelled,
  /// Indicates that the download that has been [DOWNLOADING] has moved to failed because
  /// something unexpected has happened.
  failed,
  /// Indicates that the [DOWNLOADING] download has been completed.
  completed,
}

enum LogLevel {
  debug,
  info,
  warn,
  error,
}

enum GeckoFetchMethod {
  get,
  head,
  post,
  put,
  delete,
  connect,
  options,
  trace,
}

enum GeckoFetchRedircet {
  follow,
  manual,
}

enum GeckoFetchCookiePolicy {
  include,
  omit,
}

enum BookmarkNodeType {
  item,
  folder,
  separator,
}

/// Translation options that map to the Gecko Translations Options.
///
/// @property downloadModel If the necessary models should be downloaded on request. If false, then
/// the translation will not complete and throw an exception if the models are not already available.
class TranslationOptions {
  TranslationOptions({
    required this.downloadModel,
  });

  bool downloadModel;

  List<Object?> _toList() {
    return <Object?>[
      downloadModel,
    ];
  }

  Object encode() {
    return _toList();  }

  static TranslationOptions decode(Object result) {
    result as List<Object?>;
    return TranslationOptions(
      downloadModel: result[0]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! TranslationOptions || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// Value type that represents the state of reader mode/view.
class ReaderState {
  ReaderState({
    required this.readerable,
    required this.active,
    required this.checkRequired,
    required this.connectRequired,
    this.baseUrl,
    this.activeUrl,
    this.scrollY,
  });

  /// Whether or not the current page can be transformed to
  /// be displayed in a reader view.
  bool readerable;

  /// Whether or not reader view is active.
  bool active;

  /// Whether or not a readerable check is required for the
  /// current page.
  bool checkRequired;

  /// Whether or not a new connection to the reader view
  /// content script is required.
  bool connectRequired;

  /// The base URL of the reader view extension page.
  String? baseUrl;

  /// The URL of the page currently displayed in reader view.
  String? activeUrl;

  /// The vertical scroll position of the page currently
  /// displayed in reader view.
  int? scrollY;

  List<Object?> _toList() {
    return <Object?>[
      readerable,
      active,
      checkRequired,
      connectRequired,
      baseUrl,
      activeUrl,
      scrollY,
    ];
  }

  Object encode() {
    return _toList();  }

  static ReaderState decode(Object result) {
    result as List<Object?>;
    return ReaderState(
      readerable: result[0]! as bool,
      active: result[1]! as bool,
      checkRequired: result[2]! as bool,
      connectRequired: result[3]! as bool,
      baseUrl: result[4] as String?,
      activeUrl: result[5] as String?,
      scrollY: result[6] as int?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ReaderState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// Details about the last playing media in this tab.
class LastMediaAccessState {
  LastMediaAccessState({
    required this.lastMediaUrl,
    required this.lastMediaAccess,
    required this.mediaSessionActive,
  });

  /// [TabContentState.url] when media started playing.
  /// This is not the URL of the media but of the page when media started.
  /// Defaults to "" (an empty String) if media hasn't started playing.
  /// This value is only updated when media starts playing.
  /// Can be used as a backup to [mediaSessionActive] for knowing the user is still on the same website
  /// on which media was playing before media started playing in another tab.
  String lastMediaUrl;

  /// The last time media started playing in the current web document.
  /// Defaults to [0] if media hasn't started playing.
  /// This value is only updated when media starts playing.
  int lastMediaAccess;

  /// Whether or not the last accessed media is still active.
  /// Can be used as a backup to [lastMediaUrl] on websites which allow media to continue playing
  /// even when the users accesses another page (with another URL) in that same HTML document.
  bool mediaSessionActive;

  List<Object?> _toList() {
    return <Object?>[
      lastMediaUrl,
      lastMediaAccess,
      mediaSessionActive,
    ];
  }

  Object encode() {
    return _toList();  }

  static LastMediaAccessState decode(Object result) {
    result as List<Object?>;
    return LastMediaAccessState(
      lastMediaUrl: result[0]! as String,
      lastMediaAccess: result[1]! as int,
      mediaSessionActive: result[2]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! LastMediaAccessState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// Represents a set of history metadata values that uniquely identify a record. Note that
/// when recording observations, the same set of values may or may not cause a new record to be
/// created, depending on the de-bouncing logic of the underlying storage i.e. recording history
/// metadata observations with the exact same values may be combined into a single record.
class HistoryMetadataKey {
  HistoryMetadataKey({
    required this.url,
    this.searchTerm,
    this.referrerUrl,
  });

  /// A url of the page.
  String url;

  /// An optional search term if this record was
  /// created as part of a search by the user.
  String? searchTerm;

  /// An optional url of the parent/referrer if
  /// this record was created in response to a user opening
  /// a page in a new tab.
  String? referrerUrl;

  List<Object?> _toList() {
    return <Object?>[
      url,
      searchTerm,
      referrerUrl,
    ];
  }

  Object encode() {
    return _toList();  }

  static HistoryMetadataKey decode(Object result) {
    result as List<Object?>;
    return HistoryMetadataKey(
      url: result[0]! as String,
      searchTerm: result[1] as String?,
      referrerUrl: result[2] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! HistoryMetadataKey || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class PackageCategoryValue {
  PackageCategoryValue({
    required this.value,
  });

  int value;

  List<Object?> _toList() {
    return <Object?>[
      value,
    ];
  }

  Object encode() {
    return _toList();  }

  static PackageCategoryValue decode(Object result) {
    result as List<Object?>;
    return PackageCategoryValue(
      value: result[0]! as int,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! PackageCategoryValue || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// Describes an external package.
class ExternalPackage {
  ExternalPackage({
    required this.packageId,
    required this.category,
  });

  /// An Android package id.
  String packageId;

  /// A [PackageCategory] as defined by the application.
  PackageCategoryValue category;

  List<Object?> _toList() {
    return <Object?>[
      packageId,
      category,
    ];
  }

  Object encode() {
    return _toList();  }

  static ExternalPackage decode(Object result) {
    result as List<Object?>;
    return ExternalPackage(
      packageId: result[0]! as String,
      category: result[1]! as PackageCategoryValue,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ExternalPackage || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class LoadUrlFlagsValue {
  LoadUrlFlagsValue({
    required this.value,
  });

  int value;

  List<Object?> _toList() {
    return <Object?>[
      value,
    ];
  }

  Object encode() {
    return _toList();  }

  static LoadUrlFlagsValue decode(Object result) {
    result as List<Object?>;
    return LoadUrlFlagsValue(
      value: result[0]! as int,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! LoadUrlFlagsValue || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class SourceValue {
  SourceValue({
    required this.id,
    this.caller,
  });

  int id;

  ExternalPackage? caller;

  List<Object?> _toList() {
    return <Object?>[
      id,
      caller,
    ];
  }

  Object encode() {
    return _toList();  }

  static SourceValue decode(Object result) {
    result as List<Object?>;
    return SourceValue(
      id: result[0]! as int,
      caller: result[1] as ExternalPackage?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! SourceValue || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// A tab that is no longer open and in the list of tabs, but that can be restored (recovered) at
/// any time if it's combined with an [EngineSessionState] to form a [RecoverableTab].
///
/// The values of this data class are usually filled with the values of a [TabSessionState] when
/// getting closed.
class TabState {
  TabState({
    required this.id,
    required this.url,
    this.parentId,
    required this.title,
    required this.searchTerm,
    this.contextId,
    required this.readerState,
    required this.lastAccess,
    required this.createdAt,
    required this.lastMediaAccessState,
    required this.private,
    this.historyMetadata,
    required this.source,
    required this.index,
    required this.hasFormData,
  });

  /// Unique ID identifying this tab.
  String id;

  /// The last URL of this tab.
  String url;

  /// The unique ID of the parent tab if this tab was opened from another tab (e.g. via
  /// the context menu).
  String? parentId;

  /// The last title of this tab (or an empty String).
  String title;

  /// The last used search terms, or an empty string if no
  /// search was executed for this session.
  String searchTerm;

  /// The context ID ("container") this tab used (or null).
  String? contextId;

  /// The last [ReaderState] of the tab.
  ReaderState readerState;

  /// The last time this tab was selected.
  int lastAccess;

  /// Timestamp of the tab's creation.
  int createdAt;

  /// Details about the last time was playing in this tab.
  LastMediaAccessState lastMediaAccessState;

  /// If tab was private.
  bool private;

  /// The last [HistoryMetadataKey] of the tab.
  HistoryMetadataKey? historyMetadata;

  /// The last [IconSource] of the tab.
  SourceValue source;

  /// The index the tab should be restored at.
  int index;

  /// Whether the tab has form data.
  bool hasFormData;

  List<Object?> _toList() {
    return <Object?>[
      id,
      url,
      parentId,
      title,
      searchTerm,
      contextId,
      readerState,
      lastAccess,
      createdAt,
      lastMediaAccessState,
      private,
      historyMetadata,
      source,
      index,
      hasFormData,
    ];
  }

  Object encode() {
    return _toList();  }

  static TabState decode(Object result) {
    result as List<Object?>;
    return TabState(
      id: result[0]! as String,
      url: result[1]! as String,
      parentId: result[2] as String?,
      title: result[3]! as String,
      searchTerm: result[4]! as String,
      contextId: result[5] as String?,
      readerState: result[6]! as ReaderState,
      lastAccess: result[7]! as int,
      createdAt: result[8]! as int,
      lastMediaAccessState: result[9]! as LastMediaAccessState,
      private: result[10]! as bool,
      historyMetadata: result[11] as HistoryMetadataKey?,
      source: result[12]! as SourceValue,
      index: result[13]! as int,
      hasFormData: result[14]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! TabState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// A recoverable version of [TabState].
class RecoverableTab {
  RecoverableTab({
    this.engineSessionStateJson,
    required this.state,
  });

  /// The [EngineSessionState] needed for restoring the previous state of this tab.
  String? engineSessionStateJson;

  /// A [TabState] instance containing basic tab state.
  TabState state;

  List<Object?> _toList() {
    return <Object?>[
      engineSessionStateJson,
      state,
    ];
  }

  Object encode() {
    return _toList();  }

  static RecoverableTab decode(Object result) {
    result as List<Object?>;
    return RecoverableTab(
      engineSessionStateJson: result[0] as String?,
      state: result[1]! as TabState,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! RecoverableTab || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// A restored browser state, read from disk.
class RecoverableBrowserState {
  RecoverableBrowserState({
    required this.tabs,
    this.selectedTabId,
  });

  /// The list of restored tabs.
  List<RecoverableTab?> tabs;

  /// The ID of the selected tab in [tabs]. Or `null` if no selection was restored.
  String? selectedTabId;

  List<Object?> _toList() {
    return <Object?>[
      tabs,
      selectedTabId,
    ];
  }

  Object encode() {
    return _toList();  }

  static RecoverableBrowserState decode(Object result) {
    result as List<Object?>;
    return RecoverableBrowserState(
      tabs: (result[0] as List<Object?>?)!.cast<RecoverableTab?>(),
      selectedTabId: result[1] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! RecoverableBrowserState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// A request to load an [Icon].
class IconRequest {
  IconRequest({
    required this.url,
    required this.size,
    required this.resources,
    this.color,
    required this.isPrivate,
    required this.waitOnNetworkLoad,
  });

  String url;

  IconSize size;

  List<Resource?> resources;

  int? color;

  bool isPrivate;

  bool waitOnNetworkLoad;

  List<Object?> _toList() {
    return <Object?>[
      url,
      size,
      resources,
      color,
      isPrivate,
      waitOnNetworkLoad,
    ];
  }

  Object encode() {
    return _toList();  }

  static IconRequest decode(Object result) {
    result as List<Object?>;
    return IconRequest(
      url: result[0]! as String,
      size: result[1]! as IconSize,
      resources: (result[2] as List<Object?>?)!.cast<Resource?>(),
      color: result[3] as int?,
      isPrivate: result[4]! as bool,
      waitOnNetworkLoad: result[5]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! IconRequest || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class ResourceSize {
  ResourceSize({
    required this.height,
    required this.width,
  });

  int height;

  int width;

  List<Object?> _toList() {
    return <Object?>[
      height,
      width,
    ];
  }

  Object encode() {
    return _toList();  }

  static ResourceSize decode(Object result) {
    result as List<Object?>;
    return ResourceSize(
      height: result[0]! as int,
      width: result[1]! as int,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ResourceSize || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// An icon resource that can be loaded.
class Resource {
  Resource({
    required this.url,
    required this.type,
    required this.sizes,
    this.mimeType,
    required this.maskable,
  });

  String url;

  IconType type;

  List<ResourceSize?> sizes;

  String? mimeType;

  bool maskable;

  List<Object?> _toList() {
    return <Object?>[
      url,
      type,
      sizes,
      mimeType,
      maskable,
    ];
  }

  Object encode() {
    return _toList();  }

  static Resource decode(Object result) {
    result as List<Object?>;
    return Resource(
      url: result[0]! as String,
      type: result[1]! as IconType,
      sizes: (result[2] as List<Object?>?)!.cast<ResourceSize?>(),
      mimeType: result[3] as String?,
      maskable: result[4]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! Resource || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// An [Icon] returned by [BrowserIcons] after processing an [IconRequest]
class IconResult {
  IconResult({
    required this.image,
    this.color,
    required this.source,
    required this.maskable,
  });

  /// The loaded icon as an [Uint8List].
  Uint8List image;

  /// The dominant color of the icon. Will be null if no color could be extracted.
  int? color;

  /// The source of the icon.
  IconSource source;

  /// True if the icon represents as full-bleed icon that can be cropped to other shapes.
  bool maskable;

  List<Object?> _toList() {
    return <Object?>[
      image,
      color,
      source,
      maskable,
    ];
  }

  Object encode() {
    return _toList();  }

  static IconResult decode(Object result) {
    result as List<Object?>;
    return IconResult(
      image: result[0]! as Uint8List,
      color: result[1] as int?,
      source: result[2]! as IconSource,
      maskable: result[3]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! IconResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class CookiePartitionKey {
  CookiePartitionKey({
    required this.topLevelSite,
  });

  String topLevelSite;

  List<Object?> _toList() {
    return <Object?>[
      topLevelSite,
    ];
  }

  Object encode() {
    return _toList();  }

  static CookiePartitionKey decode(Object result) {
    result as List<Object?>;
    return CookiePartitionKey(
      topLevelSite: result[0]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! CookiePartitionKey || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class Cookie {
  Cookie({
    required this.domain,
    this.expirationDate,
    required this.firstPartyDomain,
    required this.hostOnly,
    required this.httpOnly,
    required this.name,
    this.partitionKey,
    required this.path,
    required this.secure,
    required this.session,
    required this.sameSite,
    required this.storeId,
    required this.value,
  });

  String domain;

  int? expirationDate;

  String firstPartyDomain;

  bool hostOnly;

  bool httpOnly;

  String name;

  CookiePartitionKey? partitionKey;

  String path;

  bool secure;

  bool session;

  CookieSameSiteStatus sameSite;

  String storeId;

  String value;

  List<Object?> _toList() {
    return <Object?>[
      domain,
      expirationDate,
      firstPartyDomain,
      hostOnly,
      httpOnly,
      name,
      partitionKey,
      path,
      secure,
      session,
      sameSite,
      storeId,
      value,
    ];
  }

  Object encode() {
    return _toList();  }

  static Cookie decode(Object result) {
    result as List<Object?>;
    return Cookie(
      domain: result[0]! as String,
      expirationDate: result[1] as int?,
      firstPartyDomain: result[2]! as String,
      hostOnly: result[3]! as bool,
      httpOnly: result[4]! as bool,
      name: result[5]! as String,
      partitionKey: result[6] as CookiePartitionKey?,
      path: result[7]! as String,
      secure: result[8]! as bool,
      session: result[9]! as bool,
      sameSite: result[10]! as CookieSameSiteStatus,
      storeId: result[11]! as String,
      value: result[12]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! Cookie || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class VisitInfo {
  VisitInfo({
    required this.url,
    this.title,
    required this.visitTime,
    required this.visitType,
    this.previewImageUrl,
    required this.isRemote,
    this.contentId,
  });

  String url;

  String? title;

  int visitTime;

  VisitType visitType;

  String? previewImageUrl;

  bool isRemote;

  String? contentId;

  List<Object?> _toList() {
    return <Object?>[
      url,
      title,
      visitTime,
      visitType,
      previewImageUrl,
      isRemote,
      contentId,
    ];
  }

  Object encode() {
    return _toList();  }

  static VisitInfo decode(Object result) {
    result as List<Object?>;
    return VisitInfo(
      url: result[0]! as String,
      title: result[1] as String?,
      visitTime: result[2]! as int,
      visitType: result[3]! as VisitType,
      previewImageUrl: result[4] as String?,
      isRemote: result[5]! as bool,
      contentId: result[6] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! VisitInfo || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class HistoryItem {
  HistoryItem({
    required this.url,
    required this.title,
  });

  String url;

  String title;

  List<Object?> _toList() {
    return <Object?>[
      url,
      title,
    ];
  }

  Object encode() {
    return _toList();  }

  static HistoryItem decode(Object result) {
    result as List<Object?>;
    return HistoryItem(
      url: result[0]! as String,
      title: result[1]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! HistoryItem || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class HistoryState {
  HistoryState({
    required this.items,
    required this.currentIndex,
    required this.canGoBack,
    required this.canGoForward,
  });

  List<HistoryItem?> items;

  int currentIndex;

  bool canGoBack;

  bool canGoForward;

  List<Object?> _toList() {
    return <Object?>[
      items,
      currentIndex,
      canGoBack,
      canGoForward,
    ];
  }

  Object encode() {
    return _toList();  }

  static HistoryState decode(Object result) {
    result as List<Object?>;
    return HistoryState(
      items: (result[0] as List<Object?>?)!.cast<HistoryItem?>(),
      currentIndex: result[1]! as int,
      canGoBack: result[2]! as bool,
      canGoForward: result[3]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! HistoryState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class ReaderableState {
  ReaderableState({
    required this.readerable,
    required this.active,
  });

  /// Whether or not the current page can be transformed to
  /// be displayed in a reader view.
  bool readerable;

  /// Whether or not reader view is active.
  bool active;

  List<Object?> _toList() {
    return <Object?>[
      readerable,
      active,
    ];
  }

  Object encode() {
    return _toList();  }

  static ReaderableState decode(Object result) {
    result as List<Object?>;
    return ReaderableState(
      readerable: result[0]! as bool,
      active: result[1]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ReaderableState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class SecurityInfoState {
  SecurityInfoState({
    required this.secure,
    required this.host,
    required this.issuer,
  });

  bool secure;

  String host;

  String issuer;

  List<Object?> _toList() {
    return <Object?>[
      secure,
      host,
      issuer,
    ];
  }

  Object encode() {
    return _toList();  }

  static SecurityInfoState decode(Object result) {
    result as List<Object?>;
    return SecurityInfoState(
      secure: result[0]! as bool,
      host: result[1]! as String,
      issuer: result[2]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! SecurityInfoState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class TabContentState {
  TabContentState({
    required this.id,
    this.parentId,
    this.contextId,
    required this.url,
    required this.title,
    required this.progress,
    required this.isPrivate,
    required this.isFullScreen,
    required this.isLoading,
  });

  String id;

  String? parentId;

  String? contextId;

  String url;

  String title;

  int progress;

  bool isPrivate;

  bool isFullScreen;

  bool isLoading;

  List<Object?> _toList() {
    return <Object?>[
      id,
      parentId,
      contextId,
      url,
      title,
      progress,
      isPrivate,
      isFullScreen,
      isLoading,
    ];
  }

  Object encode() {
    return _toList();  }

  static TabContentState decode(Object result) {
    result as List<Object?>;
    return TabContentState(
      id: result[0]! as String,
      parentId: result[1] as String?,
      contextId: result[2] as String?,
      url: result[3]! as String,
      title: result[4]! as String,
      progress: result[5]! as int,
      isPrivate: result[6]! as bool,
      isFullScreen: result[7]! as bool,
      isLoading: result[8]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! TabContentState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class FindResultState {
  FindResultState({
    required this.activeMatchOrdinal,
    required this.numberOfMatches,
    required this.isDoneCounting,
  });

  int activeMatchOrdinal;

  int numberOfMatches;

  bool isDoneCounting;

  List<Object?> _toList() {
    return <Object?>[
      activeMatchOrdinal,
      numberOfMatches,
      isDoneCounting,
    ];
  }

  Object encode() {
    return _toList();  }

  static FindResultState decode(Object result) {
    result as List<Object?>;
    return FindResultState(
      activeMatchOrdinal: result[0]! as int,
      numberOfMatches: result[1]! as int,
      isDoneCounting: result[2]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! FindResultState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class CustomSelectionAction {
  CustomSelectionAction({
    required this.id,
    required this.title,
    this.pattern,
  });

  String id;

  String title;

  SelectionPattern? pattern;

  List<Object?> _toList() {
    return <Object?>[
      id,
      title,
      pattern,
    ];
  }

  Object encode() {
    return _toList();  }

  static CustomSelectionAction decode(Object result) {
    result as List<Object?>;
    return CustomSelectionAction(
      id: result[0]! as String,
      title: result[1]! as String,
      pattern: result[2] as SelectionPattern?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! CustomSelectionAction || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class WebExtensionData {
  WebExtensionData({
    required this.extensionId,
    this.title,
    this.enabled,
    this.badgeText,
    this.badgeTextColor,
    this.badgeBackgroundColor,
  });

  String extensionId;

  String? title;

  bool? enabled;

  String? badgeText;

  int? badgeTextColor;

  int? badgeBackgroundColor;

  List<Object?> _toList() {
    return <Object?>[
      extensionId,
      title,
      enabled,
      badgeText,
      badgeTextColor,
      badgeBackgroundColor,
    ];
  }

  Object encode() {
    return _toList();  }

  static WebExtensionData decode(Object result) {
    result as List<Object?>;
    return WebExtensionData(
      extensionId: result[0]! as String,
      title: result[1] as String?,
      enabled: result[2] as bool?,
      badgeText: result[3] as String?,
      badgeTextColor: result[4] as int?,
      badgeBackgroundColor: result[5] as int?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! WebExtensionData || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class GeckoSuggestion {
  GeckoSuggestion({
    required this.id,
    required this.type,
    required this.score,
    this.title,
    this.description,
    this.editSuggestion,
    this.icon,
  });

  String id;

  GeckoSuggestionType type;

  int score;

  String? title;

  String? description;

  String? editSuggestion;

  Uint8List? icon;

  List<Object?> _toList() {
    return <Object?>[
      id,
      type,
      score,
      title,
      description,
      editSuggestion,
      icon,
    ];
  }

  Object encode() {
    return _toList();  }

  static GeckoSuggestion decode(Object result) {
    result as List<Object?>;
    return GeckoSuggestion(
      id: result[0]! as String,
      type: result[1]! as GeckoSuggestionType,
      score: result[2]! as int,
      title: result[3] as String?,
      description: result[4] as String?,
      editSuggestion: result[5] as String?,
      icon: result[6] as Uint8List?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! GeckoSuggestion || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class TabContent {
  TabContent({
    required this.tabId,
    this.fullContentMarkdown,
    this.fullContentPlain,
    required this.isProbablyReaderable,
    this.extractedContentMarkdown,
    this.extractedContentPlain,
  });

  String tabId;

  String? fullContentMarkdown;

  String? fullContentPlain;

  bool isProbablyReaderable;

  String? extractedContentMarkdown;

  String? extractedContentPlain;

  List<Object?> _toList() {
    return <Object?>[
      tabId,
      fullContentMarkdown,
      fullContentPlain,
      isProbablyReaderable,
      extractedContentMarkdown,
      extractedContentPlain,
    ];
  }

  Object encode() {
    return _toList();  }

  static TabContent decode(Object result) {
    result as List<Object?>;
    return TabContent(
      tabId: result[0]! as String,
      fullContentMarkdown: result[1] as String?,
      fullContentPlain: result[2] as String?,
      isProbablyReaderable: result[3]! as bool,
      extractedContentMarkdown: result[4] as String?,
      extractedContentPlain: result[5] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! TabContent || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class ContentBlocking {
  ContentBlocking({
    required this.queryParameterStripping,
    required this.queryParameterStrippingAllowList,
    required this.queryParameterStrippingStripList,
    required this.bounceTrackingProtectionMode,
  });

  QueryParameterStripping queryParameterStripping;

  String queryParameterStrippingAllowList;

  String queryParameterStrippingStripList;

  BounceTrackingProtectionMode bounceTrackingProtectionMode;

  List<Object?> _toList() {
    return <Object?>[
      queryParameterStripping,
      queryParameterStrippingAllowList,
      queryParameterStrippingStripList,
      bounceTrackingProtectionMode,
    ];
  }

  Object encode() {
    return _toList();  }

  static ContentBlocking decode(Object result) {
    result as List<Object?>;
    return ContentBlocking(
      queryParameterStripping: result[0]! as QueryParameterStripping,
      queryParameterStrippingAllowList: result[1]! as String,
      queryParameterStrippingStripList: result[2]! as String,
      bounceTrackingProtectionMode: result[3]! as BounceTrackingProtectionMode,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ContentBlocking || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class DohSettings {
  DohSettings({
    required this.dohSettingsMode,
    required this.dohProviderUrl,
    required this.dohDefaultProviderUrl,
    required this.dohExceptionsList,
  });

  DohSettingsMode dohSettingsMode;

  String dohProviderUrl;

  String dohDefaultProviderUrl;

  List<String> dohExceptionsList;

  List<Object?> _toList() {
    return <Object?>[
      dohSettingsMode,
      dohProviderUrl,
      dohDefaultProviderUrl,
      dohExceptionsList,
    ];
  }

  Object encode() {
    return _toList();  }

  static DohSettings decode(Object result) {
    result as List<Object?>;
    return DohSettings(
      dohSettingsMode: result[0]! as DohSettingsMode,
      dohProviderUrl: result[1]! as String,
      dohDefaultProviderUrl: result[2]! as String,
      dohExceptionsList: (result[3] as List<Object?>?)!.cast<String>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! DohSettings || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class GeckoEngineSettings {
  GeckoEngineSettings({
    this.javascriptEnabled,
    this.trackingProtectionPolicy,
    this.httpsOnlyMode,
    this.globalPrivacyControlEnabled,
    this.preferredColorScheme,
    this.cookieBannerHandlingMode,
    this.cookieBannerHandlingModePrivateBrowsing,
    this.cookieBannerHandlingGlobalRules,
    this.cookieBannerHandlingGlobalRulesSubFrames,
    this.webContentIsolationStrategy,
    this.userAgent,
    this.contentBlocking,
    this.enterpriseRootsEnabled,
    this.dohSettings,
    this.fingerprintingProtectionOverrides,
    this.locales,
  });

  bool? javascriptEnabled;

  TrackingProtectionPolicy? trackingProtectionPolicy;

  HttpsOnlyMode? httpsOnlyMode;

  bool? globalPrivacyControlEnabled;

  ColorScheme? preferredColorScheme;

  CookieBannerHandlingMode? cookieBannerHandlingMode;

  CookieBannerHandlingMode? cookieBannerHandlingModePrivateBrowsing;

  bool? cookieBannerHandlingGlobalRules;

  bool? cookieBannerHandlingGlobalRulesSubFrames;

  WebContentIsolationStrategy? webContentIsolationStrategy;

  String? userAgent;

  ContentBlocking? contentBlocking;

  bool? enterpriseRootsEnabled;

  DohSettings? dohSettings;

  String? fingerprintingProtectionOverrides;

  List<String>? locales;

  List<Object?> _toList() {
    return <Object?>[
      javascriptEnabled,
      trackingProtectionPolicy,
      httpsOnlyMode,
      globalPrivacyControlEnabled,
      preferredColorScheme,
      cookieBannerHandlingMode,
      cookieBannerHandlingModePrivateBrowsing,
      cookieBannerHandlingGlobalRules,
      cookieBannerHandlingGlobalRulesSubFrames,
      webContentIsolationStrategy,
      userAgent,
      contentBlocking,
      enterpriseRootsEnabled,
      dohSettings,
      fingerprintingProtectionOverrides,
      locales,
    ];
  }

  Object encode() {
    return _toList();  }

  static GeckoEngineSettings decode(Object result) {
    result as List<Object?>;
    return GeckoEngineSettings(
      javascriptEnabled: result[0] as bool?,
      trackingProtectionPolicy: result[1] as TrackingProtectionPolicy?,
      httpsOnlyMode: result[2] as HttpsOnlyMode?,
      globalPrivacyControlEnabled: result[3] as bool?,
      preferredColorScheme: result[4] as ColorScheme?,
      cookieBannerHandlingMode: result[5] as CookieBannerHandlingMode?,
      cookieBannerHandlingModePrivateBrowsing: result[6] as CookieBannerHandlingMode?,
      cookieBannerHandlingGlobalRules: result[7] as bool?,
      cookieBannerHandlingGlobalRulesSubFrames: result[8] as bool?,
      webContentIsolationStrategy: result[9] as WebContentIsolationStrategy?,
      userAgent: result[10] as String?,
      contentBlocking: result[11] as ContentBlocking?,
      enterpriseRootsEnabled: result[12] as bool?,
      dohSettings: result[13] as DohSettings?,
      fingerprintingProtectionOverrides: result[14] as String?,
      locales: (result[15] as List<Object?>?)?.cast<String>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! GeckoEngineSettings || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class AutocompleteResult {
  AutocompleteResult({
    required this.input,
    required this.text,
    required this.url,
    required this.source,
    required this.totalItems,
  });

  String input;

  String text;

  String url;

  String source;

  int totalItems;

  List<Object?> _toList() {
    return <Object?>[
      input,
      text,
      url,
      source,
      totalItems,
    ];
  }

  Object encode() {
    return _toList();  }

  static AutocompleteResult decode(Object result) {
    result as List<Object?>;
    return AutocompleteResult(
      input: result[0]! as String,
      text: result[1]! as String,
      url: result[2]! as String,
      source: result[3]! as String,
      totalItems: result[4]! as int,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! AutocompleteResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// Represents all the different supported types of data that can be found from long clicking
/// an element.
sealed class HitResult {
}

/// Default type if we're unable to match the type to anything. It may or may not have a src.
class UnknownHitResult extends HitResult {
  UnknownHitResult({
    required this.src,
  });

  String src;

  List<Object?> _toList() {
    return <Object?>[
      src,
    ];
  }

  Object encode() {
    return _toList();  }

  static UnknownHitResult decode(Object result) {
    result as List<Object?>;
    return UnknownHitResult(
      src: result[0]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! UnknownHitResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// If the HTML element was of type 'HTMLImageElement'.
class ImageHitResult extends HitResult {
  ImageHitResult({
    required this.src,
    this.title,
  });

  String src;

  String? title;

  List<Object?> _toList() {
    return <Object?>[
      src,
      title,
    ];
  }

  Object encode() {
    return _toList();  }

  static ImageHitResult decode(Object result) {
    result as List<Object?>;
    return ImageHitResult(
      src: result[0]! as String,
      title: result[1] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ImageHitResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// If the HTML element was of type 'HTMLVideoElement'.
class VideoHitResult extends HitResult {
  VideoHitResult({
    required this.src,
    this.title,
  });

  String src;

  String? title;

  List<Object?> _toList() {
    return <Object?>[
      src,
      title,
    ];
  }

  Object encode() {
    return _toList();  }

  static VideoHitResult decode(Object result) {
    result as List<Object?>;
    return VideoHitResult(
      src: result[0]! as String,
      title: result[1] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! VideoHitResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// If the HTML element was of type 'HTMLAudioElement'.
class AudioHitResult extends HitResult {
  AudioHitResult({
    required this.src,
    this.title,
  });

  String src;

  String? title;

  List<Object?> _toList() {
    return <Object?>[
      src,
      title,
    ];
  }

  Object encode() {
    return _toList();  }

  static AudioHitResult decode(Object result) {
    result as List<Object?>;
    return AudioHitResult(
      src: result[0]! as String,
      title: result[1] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! AudioHitResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// If the HTML element was of type 'HTMLImageElement' and contained a URI.
class ImageSrcHitResult extends HitResult {
  ImageSrcHitResult({
    required this.src,
    required this.uri,
  });

  String src;

  String uri;

  List<Object?> _toList() {
    return <Object?>[
      src,
      uri,
    ];
  }

  Object encode() {
    return _toList();  }

  static ImageSrcHitResult decode(Object result) {
    result as List<Object?>;
    return ImageSrcHitResult(
      src: result[0]! as String,
      uri: result[1]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ImageSrcHitResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// The type used if the URI is prepended with 'tel:'.
class PhoneHitResult extends HitResult {
  PhoneHitResult({
    required this.src,
  });

  String src;

  List<Object?> _toList() {
    return <Object?>[
      src,
    ];
  }

  Object encode() {
    return _toList();  }

  static PhoneHitResult decode(Object result) {
    result as List<Object?>;
    return PhoneHitResult(
      src: result[0]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! PhoneHitResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// The type used if the URI is prepended with 'mailto:'.
class EmailHitResult extends HitResult {
  EmailHitResult({
    required this.src,
  });

  String src;

  List<Object?> _toList() {
    return <Object?>[
      src,
    ];
  }

  Object encode() {
    return _toList();  }

  static EmailHitResult decode(Object result) {
    result as List<Object?>;
    return EmailHitResult(
      src: result[0]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! EmailHitResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// The type used if the URI is prepended with 'geo:'.
class GeoHitResult extends HitResult {
  GeoHitResult({
    required this.src,
  });

  String src;

  List<Object?> _toList() {
    return <Object?>[
      src,
    ];
  }

  Object encode() {
    return _toList();  }

  static GeoHitResult decode(Object result) {
    result as List<Object?>;
    return GeoHitResult(
      src: result[0]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! GeoHitResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class DownloadState {
  DownloadState({
    required this.url,
    this.fileName,
    this.contentType,
    this.contentLength,
    this.currentBytesCopied,
    this.status,
    this.userAgent,
    this.destinationDirectory,
    this.directoryPath,
    this.referrerUrl,
    this.skipConfirmation,
    this.openInApp,
    this.id,
    this.sessionId,
    this.private,
    this.createdTime,
    this.notificationId,
  });

  String url;

  String? fileName;

  String? contentType;

  int? contentLength;

  int? currentBytesCopied;

  DownloadStatus? status;

  String? userAgent;

  String? destinationDirectory;

  String? directoryPath;

  String? referrerUrl;

  bool? skipConfirmation;

  bool? openInApp;

  String? id;

  String? sessionId;

  bool? private;

  int? createdTime;

  int? notificationId;

  List<Object?> _toList() {
    return <Object?>[
      url,
      fileName,
      contentType,
      contentLength,
      currentBytesCopied,
      status,
      userAgent,
      destinationDirectory,
      directoryPath,
      referrerUrl,
      skipConfirmation,
      openInApp,
      id,
      sessionId,
      private,
      createdTime,
      notificationId,
    ];
  }

  Object encode() {
    return _toList();  }

  static DownloadState decode(Object result) {
    result as List<Object?>;
    return DownloadState(
      url: result[0]! as String,
      fileName: result[1] as String?,
      contentType: result[2] as String?,
      contentLength: result[3] as int?,
      currentBytesCopied: result[4] as int?,
      status: result[5] as DownloadStatus?,
      userAgent: result[6] as String?,
      destinationDirectory: result[7] as String?,
      directoryPath: result[8] as String?,
      referrerUrl: result[9] as String?,
      skipConfirmation: result[10] as bool?,
      openInApp: result[11] as bool?,
      id: result[12] as String?,
      sessionId: result[13] as String?,
      private: result[14] as bool?,
      createdTime: result[15] as int?,
      notificationId: result[16] as int?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! DownloadState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class ShareInternetResourceState {
  ShareInternetResourceState({
    required this.url,
    this.contentType,
    required this.private,
    this.referrerUrl,
  });

  String url;

  String? contentType;

  bool private;

  String? referrerUrl;

  List<Object?> _toList() {
    return <Object?>[
      url,
      contentType,
      private,
      referrerUrl,
    ];
  }

  Object encode() {
    return _toList();  }

  static ShareInternetResourceState decode(Object result) {
    result as List<Object?>;
    return ShareInternetResourceState(
      url: result[0]! as String,
      contentType: result[1] as String?,
      private: result[2]! as bool,
      referrerUrl: result[3] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ShareInternetResourceState || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class AddonCollection {
  AddonCollection({
    required this.serverURL,
    required this.collectionUser,
    required this.collectionName,
  });

  String serverURL;

  String collectionUser;

  String collectionName;

  List<Object?> _toList() {
    return <Object?>[
      serverURL,
      collectionUser,
      collectionName,
    ];
  }

  Object encode() {
    return _toList();  }

  static AddonCollection decode(Object result) {
    result as List<Object?>;
    return AddonCollection(
      serverURL: result[0]! as String,
      collectionUser: result[1]! as String,
      collectionName: result[2]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! AddonCollection || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class GeckoPref {
  GeckoPref({
    required this.name,
    this.value,
    this.defaultValue,
    this.userValue,
    required this.hasUserChangedValue,
  });

  String name;

  Object? value;

  Object? defaultValue;

  Object? userValue;

  bool hasUserChangedValue;

  List<Object?> _toList() {
    return <Object?>[
      name,
      value,
      defaultValue,
      userValue,
      hasUserChangedValue,
    ];
  }

  Object encode() {
    return _toList();  }

  static GeckoPref decode(Object result) {
    result as List<Object?>;
    return GeckoPref(
      name: result[0]! as String,
      value: result[1],
      defaultValue: result[2],
      userValue: result[3],
      hasUserChangedValue: result[4]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! GeckoPref || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class ContainerSiteAssignment {
  ContainerSiteAssignment({
    required this.requestId,
    this.tabId,
    this.originUrl,
    required this.url,
    required this.blocked,
  });

  String requestId;

  String? tabId;

  String? originUrl;

  String url;

  bool blocked;

  List<Object?> _toList() {
    return <Object?>[
      requestId,
      tabId,
      originUrl,
      url,
      blocked,
    ];
  }

  Object encode() {
    return _toList();  }

  static ContainerSiteAssignment decode(Object result) {
    result as List<Object?>;
    return ContainerSiteAssignment(
      requestId: result[0]! as String,
      tabId: result[1] as String?,
      originUrl: result[2] as String?,
      url: result[3]! as String,
      blocked: result[4]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ContainerSiteAssignment || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class GeckoHeader {
  GeckoHeader({
    required this.key,
    required this.value,
  });

  String key;

  String value;

  List<Object?> _toList() {
    return <Object?>[
      key,
      value,
    ];
  }

  Object encode() {
    return _toList();  }

  static GeckoHeader decode(Object result) {
    result as List<Object?>;
    return GeckoHeader(
      key: result[0]! as String,
      value: result[1]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! GeckoHeader || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class GeckoFetchRequest {
  GeckoFetchRequest({
    required this.url,
    required this.method,
    required this.headers,
    this.connectTimeoutMillis,
    this.readTimeoutMillis,
    this.body,
    required this.redirect,
    required this.cookiePolicy,
    required this.useCaches,
    required this.private,
    required this.useOhttp,
    this.referrerUrl,
    required this.conservative,
  });

  String url;

  GeckoFetchMethod method;

  List<GeckoHeader> headers;

  int? connectTimeoutMillis;

  int? readTimeoutMillis;

  String? body;

  GeckoFetchRedircet redirect;

  GeckoFetchCookiePolicy cookiePolicy;

  bool useCaches;

  bool private;

  bool useOhttp;

  String? referrerUrl;

  bool conservative;

  List<Object?> _toList() {
    return <Object?>[
      url,
      method,
      headers,
      connectTimeoutMillis,
      readTimeoutMillis,
      body,
      redirect,
      cookiePolicy,
      useCaches,
      private,
      useOhttp,
      referrerUrl,
      conservative,
    ];
  }

  Object encode() {
    return _toList();  }

  static GeckoFetchRequest decode(Object result) {
    result as List<Object?>;
    return GeckoFetchRequest(
      url: result[0]! as String,
      method: result[1]! as GeckoFetchMethod,
      headers: (result[2] as List<Object?>?)!.cast<GeckoHeader>(),
      connectTimeoutMillis: result[3] as int?,
      readTimeoutMillis: result[4] as int?,
      body: result[5] as String?,
      redirect: result[6]! as GeckoFetchRedircet,
      cookiePolicy: result[7]! as GeckoFetchCookiePolicy,
      useCaches: result[8]! as bool,
      private: result[9]! as bool,
      useOhttp: result[10]! as bool,
      referrerUrl: result[11] as String?,
      conservative: result[12]! as bool,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! GeckoFetchRequest || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class GeckoFetchResponse {
  GeckoFetchResponse({
    required this.url,
    required this.status,
    required this.headers,
    required this.body,
  });

  String url;

  int status;

  List<GeckoHeader> headers;

  Uint8List body;

  List<Object?> _toList() {
    return <Object?>[
      url,
      status,
      headers,
      body,
    ];
  }

  Object encode() {
    return _toList();  }

  static GeckoFetchResponse decode(Object result) {
    result as List<Object?>;
    return GeckoFetchResponse(
      url: result[0]! as String,
      status: result[1]! as int,
      headers: (result[2] as List<Object?>?)!.cast<GeckoHeader>(),
      body: result[3]! as Uint8List,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! GeckoFetchResponse || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class BookmarkNode {
  BookmarkNode({
    required this.type,
    required this.guid,
    this.parentGuid,
    this.position,
    this.title,
    this.url,
    required this.dateAdded,
    required this.lastModified,
    this.children,
  });

  BookmarkNodeType type;

  String guid;

  String? parentGuid;

  int? position;

  String? title;

  String? url;

  int dateAdded;

  int lastModified;

  List<BookmarkNode>? children;

  List<Object?> _toList() {
    return <Object?>[
      type,
      guid,
      parentGuid,
      position,
      title,
      url,
      dateAdded,
      lastModified,
      children,
    ];
  }

  Object encode() {
    return _toList();  }

  static BookmarkNode decode(Object result) {
    result as List<Object?>;
    return BookmarkNode(
      type: result[0]! as BookmarkNodeType,
      guid: result[1]! as String,
      parentGuid: result[2] as String?,
      position: result[3] as int?,
      title: result[4] as String?,
      url: result[5] as String?,
      dateAdded: result[6]! as int,
      lastModified: result[7]! as int,
      children: (result[8] as List<Object?>?)?.cast<BookmarkNode>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! BookmarkNode || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

/// Class for making alterations to any bookmark node
class BookmarkInfo {
  BookmarkInfo({
    this.parentGuid,
    this.position,
    this.title,
    this.url,
  });

  String? parentGuid;

  int? position;

  String? title;

  String? url;

  List<Object?> _toList() {
    return <Object?>[
      parentGuid,
      position,
      title,
      url,
    ];
  }

  Object encode() {
    return _toList();  }

  static BookmarkInfo decode(Object result) {
    result as List<Object?>;
    return BookmarkInfo(
      parentGuid: result[0] as String?,
      position: result[1] as int?,
      title: result[2] as String?,
      url: result[3] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! BookmarkInfo || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}


class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    }    else if (value is RestoreLocation) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    }    else if (value is IconType) {
      buffer.putUint8(130);
      writeValue(buffer, value.index);
    }    else if (value is IconSize) {
      buffer.putUint8(131);
      writeValue(buffer, value.index);
    }    else if (value is IconSource) {
      buffer.putUint8(132);
      writeValue(buffer, value.index);
    }    else if (value is CookieSameSiteStatus) {
      buffer.putUint8(133);
      writeValue(buffer, value.index);
    }    else if (value is VisitType) {
      buffer.putUint8(134);
      writeValue(buffer, value.index);
    }    else if (value is SelectionPattern) {
      buffer.putUint8(135);
      writeValue(buffer, value.index);
    }    else if (value is WebExtensionActionType) {
      buffer.putUint8(136);
      writeValue(buffer, value.index);
    }    else if (value is GeckoSuggestionType) {
      buffer.putUint8(137);
      writeValue(buffer, value.index);
    }    else if (value is TrackingProtectionPolicy) {
      buffer.putUint8(138);
      writeValue(buffer, value.index);
    }    else if (value is HttpsOnlyMode) {
      buffer.putUint8(139);
      writeValue(buffer, value.index);
    }    else if (value is QueryParameterStripping) {
      buffer.putUint8(140);
      writeValue(buffer, value.index);
    }    else if (value is BounceTrackingProtectionMode) {
      buffer.putUint8(141);
      writeValue(buffer, value.index);
    }    else if (value is ColorScheme) {
      buffer.putUint8(142);
      writeValue(buffer, value.index);
    }    else if (value is CookieBannerHandlingMode) {
      buffer.putUint8(143);
      writeValue(buffer, value.index);
    }    else if (value is WebContentIsolationStrategy) {
      buffer.putUint8(144);
      writeValue(buffer, value.index);
    }    else if (value is DohSettingsMode) {
      buffer.putUint8(145);
      writeValue(buffer, value.index);
    }    else if (value is DownloadStatus) {
      buffer.putUint8(146);
      writeValue(buffer, value.index);
    }    else if (value is LogLevel) {
      buffer.putUint8(147);
      writeValue(buffer, value.index);
    }    else if (value is GeckoFetchMethod) {
      buffer.putUint8(148);
      writeValue(buffer, value.index);
    }    else if (value is GeckoFetchRedircet) {
      buffer.putUint8(149);
      writeValue(buffer, value.index);
    }    else if (value is GeckoFetchCookiePolicy) {
      buffer.putUint8(150);
      writeValue(buffer, value.index);
    }    else if (value is BookmarkNodeType) {
      buffer.putUint8(151);
      writeValue(buffer, value.index);
    }    else if (value is TranslationOptions) {
      buffer.putUint8(152);
      writeValue(buffer, value.encode());
    }    else if (value is ReaderState) {
      buffer.putUint8(153);
      writeValue(buffer, value.encode());
    }    else if (value is LastMediaAccessState) {
      buffer.putUint8(154);
      writeValue(buffer, value.encode());
    }    else if (value is HistoryMetadataKey) {
      buffer.putUint8(155);
      writeValue(buffer, value.encode());
    }    else if (value is PackageCategoryValue) {
      buffer.putUint8(156);
      writeValue(buffer, value.encode());
    }    else if (value is ExternalPackage) {
      buffer.putUint8(157);
      writeValue(buffer, value.encode());
    }    else if (value is LoadUrlFlagsValue) {
      buffer.putUint8(158);
      writeValue(buffer, value.encode());
    }    else if (value is SourceValue) {
      buffer.putUint8(159);
      writeValue(buffer, value.encode());
    }    else if (value is TabState) {
      buffer.putUint8(160);
      writeValue(buffer, value.encode());
    }    else if (value is RecoverableTab) {
      buffer.putUint8(161);
      writeValue(buffer, value.encode());
    }    else if (value is RecoverableBrowserState) {
      buffer.putUint8(162);
      writeValue(buffer, value.encode());
    }    else if (value is IconRequest) {
      buffer.putUint8(163);
      writeValue(buffer, value.encode());
    }    else if (value is ResourceSize) {
      buffer.putUint8(164);
      writeValue(buffer, value.encode());
    }    else if (value is Resource) {
      buffer.putUint8(165);
      writeValue(buffer, value.encode());
    }    else if (value is IconResult) {
      buffer.putUint8(166);
      writeValue(buffer, value.encode());
    }    else if (value is CookiePartitionKey) {
      buffer.putUint8(167);
      writeValue(buffer, value.encode());
    }    else if (value is Cookie) {
      buffer.putUint8(168);
      writeValue(buffer, value.encode());
    }    else if (value is VisitInfo) {
      buffer.putUint8(169);
      writeValue(buffer, value.encode());
    }    else if (value is HistoryItem) {
      buffer.putUint8(170);
      writeValue(buffer, value.encode());
    }    else if (value is HistoryState) {
      buffer.putUint8(171);
      writeValue(buffer, value.encode());
    }    else if (value is ReaderableState) {
      buffer.putUint8(172);
      writeValue(buffer, value.encode());
    }    else if (value is SecurityInfoState) {
      buffer.putUint8(173);
      writeValue(buffer, value.encode());
    }    else if (value is TabContentState) {
      buffer.putUint8(174);
      writeValue(buffer, value.encode());
    }    else if (value is FindResultState) {
      buffer.putUint8(175);
      writeValue(buffer, value.encode());
    }    else if (value is CustomSelectionAction) {
      buffer.putUint8(176);
      writeValue(buffer, value.encode());
    }    else if (value is WebExtensionData) {
      buffer.putUint8(177);
      writeValue(buffer, value.encode());
    }    else if (value is GeckoSuggestion) {
      buffer.putUint8(178);
      writeValue(buffer, value.encode());
    }    else if (value is TabContent) {
      buffer.putUint8(179);
      writeValue(buffer, value.encode());
    }    else if (value is ContentBlocking) {
      buffer.putUint8(180);
      writeValue(buffer, value.encode());
    }    else if (value is DohSettings) {
      buffer.putUint8(181);
      writeValue(buffer, value.encode());
    }    else if (value is GeckoEngineSettings) {
      buffer.putUint8(182);
      writeValue(buffer, value.encode());
    }    else if (value is AutocompleteResult) {
      buffer.putUint8(183);
      writeValue(buffer, value.encode());
    }    else if (value is UnknownHitResult) {
      buffer.putUint8(184);
      writeValue(buffer, value.encode());
    }    else if (value is ImageHitResult) {
      buffer.putUint8(185);
      writeValue(buffer, value.encode());
    }    else if (value is VideoHitResult) {
      buffer.putUint8(186);
      writeValue(buffer, value.encode());
    }    else if (value is AudioHitResult) {
      buffer.putUint8(187);
      writeValue(buffer, value.encode());
    }    else if (value is ImageSrcHitResult) {
      buffer.putUint8(188);
      writeValue(buffer, value.encode());
    }    else if (value is PhoneHitResult) {
      buffer.putUint8(189);
      writeValue(buffer, value.encode());
    }    else if (value is EmailHitResult) {
      buffer.putUint8(190);
      writeValue(buffer, value.encode());
    }    else if (value is GeoHitResult) {
      buffer.putUint8(191);
      writeValue(buffer, value.encode());
    }    else if (value is DownloadState) {
      buffer.putUint8(192);
      writeValue(buffer, value.encode());
    }    else if (value is ShareInternetResourceState) {
      buffer.putUint8(193);
      writeValue(buffer, value.encode());
    }    else if (value is AddonCollection) {
      buffer.putUint8(194);
      writeValue(buffer, value.encode());
    }    else if (value is GeckoPref) {
      buffer.putUint8(195);
      writeValue(buffer, value.encode());
    }    else if (value is ContainerSiteAssignment) {
      buffer.putUint8(196);
      writeValue(buffer, value.encode());
    }    else if (value is GeckoHeader) {
      buffer.putUint8(197);
      writeValue(buffer, value.encode());
    }    else if (value is GeckoFetchRequest) {
      buffer.putUint8(198);
      writeValue(buffer, value.encode());
    }    else if (value is GeckoFetchResponse) {
      buffer.putUint8(199);
      writeValue(buffer, value.encode());
    }    else if (value is BookmarkNode) {
      buffer.putUint8(200);
      writeValue(buffer, value.encode());
    }    else if (value is BookmarkInfo) {
      buffer.putUint8(201);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : RestoreLocation.values[value];
      case 130: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : IconType.values[value];
      case 131: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : IconSize.values[value];
      case 132: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : IconSource.values[value];
      case 133: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : CookieSameSiteStatus.values[value];
      case 134: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : VisitType.values[value];
      case 135: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : SelectionPattern.values[value];
      case 136: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : WebExtensionActionType.values[value];
      case 137: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : GeckoSuggestionType.values[value];
      case 138: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : TrackingProtectionPolicy.values[value];
      case 139: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : HttpsOnlyMode.values[value];
      case 140: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : QueryParameterStripping.values[value];
      case 141: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : BounceTrackingProtectionMode.values[value];
      case 142: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : ColorScheme.values[value];
      case 143: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : CookieBannerHandlingMode.values[value];
      case 144: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : WebContentIsolationStrategy.values[value];
      case 145: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : DohSettingsMode.values[value];
      case 146: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : DownloadStatus.values[value];
      case 147: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : LogLevel.values[value];
      case 148: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : GeckoFetchMethod.values[value];
      case 149: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : GeckoFetchRedircet.values[value];
      case 150: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : GeckoFetchCookiePolicy.values[value];
      case 151: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : BookmarkNodeType.values[value];
      case 152: 
        return TranslationOptions.decode(readValue(buffer)!);
      case 153: 
        return ReaderState.decode(readValue(buffer)!);
      case 154: 
        return LastMediaAccessState.decode(readValue(buffer)!);
      case 155: 
        return HistoryMetadataKey.decode(readValue(buffer)!);
      case 156: 
        return PackageCategoryValue.decode(readValue(buffer)!);
      case 157: 
        return ExternalPackage.decode(readValue(buffer)!);
      case 158: 
        return LoadUrlFlagsValue.decode(readValue(buffer)!);
      case 159: 
        return SourceValue.decode(readValue(buffer)!);
      case 160: 
        return TabState.decode(readValue(buffer)!);
      case 161: 
        return RecoverableTab.decode(readValue(buffer)!);
      case 162: 
        return RecoverableBrowserState.decode(readValue(buffer)!);
      case 163: 
        return IconRequest.decode(readValue(buffer)!);
      case 164: 
        return ResourceSize.decode(readValue(buffer)!);
      case 165: 
        return Resource.decode(readValue(buffer)!);
      case 166: 
        return IconResult.decode(readValue(buffer)!);
      case 167: 
        return CookiePartitionKey.decode(readValue(buffer)!);
      case 168: 
        return Cookie.decode(readValue(buffer)!);
      case 169: 
        return VisitInfo.decode(readValue(buffer)!);
      case 170: 
        return HistoryItem.decode(readValue(buffer)!);
      case 171: 
        return HistoryState.decode(readValue(buffer)!);
      case 172: 
        return ReaderableState.decode(readValue(buffer)!);
      case 173: 
        return SecurityInfoState.decode(readValue(buffer)!);
      case 174: 
        return TabContentState.decode(readValue(buffer)!);
      case 175: 
        return FindResultState.decode(readValue(buffer)!);
      case 176: 
        return CustomSelectionAction.decode(readValue(buffer)!);
      case 177: 
        return WebExtensionData.decode(readValue(buffer)!);
      case 178: 
        return GeckoSuggestion.decode(readValue(buffer)!);
      case 179: 
        return TabContent.decode(readValue(buffer)!);
      case 180: 
        return ContentBlocking.decode(readValue(buffer)!);
      case 181: 
        return DohSettings.decode(readValue(buffer)!);
      case 182: 
        return GeckoEngineSettings.decode(readValue(buffer)!);
      case 183: 
        return AutocompleteResult.decode(readValue(buffer)!);
      case 184: 
        return UnknownHitResult.decode(readValue(buffer)!);
      case 185: 
        return ImageHitResult.decode(readValue(buffer)!);
      case 186: 
        return VideoHitResult.decode(readValue(buffer)!);
      case 187: 
        return AudioHitResult.decode(readValue(buffer)!);
      case 188: 
        return ImageSrcHitResult.decode(readValue(buffer)!);
      case 189: 
        return PhoneHitResult.decode(readValue(buffer)!);
      case 190: 
        return EmailHitResult.decode(readValue(buffer)!);
      case 191: 
        return GeoHitResult.decode(readValue(buffer)!);
      case 192: 
        return DownloadState.decode(readValue(buffer)!);
      case 193: 
        return ShareInternetResourceState.decode(readValue(buffer)!);
      case 194: 
        return AddonCollection.decode(readValue(buffer)!);
      case 195: 
        return GeckoPref.decode(readValue(buffer)!);
      case 196: 
        return ContainerSiteAssignment.decode(readValue(buffer)!);
      case 197: 
        return GeckoHeader.decode(readValue(buffer)!);
      case 198: 
        return GeckoFetchRequest.decode(readValue(buffer)!);
      case 199: 
        return GeckoFetchResponse.decode(readValue(buffer)!);
      case 200: 
        return BookmarkNode.decode(readValue(buffer)!);
      case 201: 
        return BookmarkInfo.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class GeckoBrowserApi {
  /// Constructor for [GeckoBrowserApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoBrowserApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<String> getGeckoVersion() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserApi.getGeckoVersion$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  Future<void> initialize(String profileFolder, LogLevel logLevel, ContentBlocking contentBlocking, AddonCollection? addonCollection) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserApi.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[profileFolder, logLevel, contentBlocking, addonCollection]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<bool> showNativeFragment() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserApi.showNativeFragment$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  Future<void> onTrimMemory(int level) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserApi.onTrimMemory$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[level]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class GeckoEngineSettingsApi {
  /// Constructor for [GeckoEngineSettingsApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoEngineSettingsApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> setDefaultSettings(GeckoEngineSettings settings) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoEngineSettingsApi.setDefaultSettings$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[settings]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> updateRuntimeSettings(GeckoEngineSettings settings) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoEngineSettingsApi.updateRuntimeSettings$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[settings]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class GeckoSessionApi {
  /// Constructor for [GeckoSessionApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoSessionApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> loadUrl({required String? tabId, required String url, required LoadUrlFlagsValue flags, required Map<String, String>? additionalHeaders, }) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.loadUrl$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, url, flags, additionalHeaders]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> loadData({required String? tabId, required String data, required String mimeType, required String encoding, }) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.loadData$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, data, mimeType, encoding]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> reload({required String? tabId, required LoadUrlFlagsValue flags}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.reload$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, flags]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> stopLoading({required String? tabId}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.stopLoading$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> goBack({required String? tabId, required bool userInteraction}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.goBack$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, userInteraction]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> goForward({required String? tabId, required bool userInteraction}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.goForward$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, userInteraction]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> goToHistoryIndex({required int index, required String? tabId}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.goToHistoryIndex$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[index, tabId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> requestDesktopSite({required String? tabId, required bool enable}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.requestDesktopSite$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, enable]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> exitFullscreen({required String? tabId}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.exitFullscreen$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> saveToPdf({required String? tabId}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.saveToPdf$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> printContent({required String? tabId}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.printContent$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> translate({required String? tabId, required String fromLanguage, required String toLanguage, required TranslationOptions? options, }) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.translate$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, fromLanguage, toLanguage, options]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> translateRestore({required String? tabId}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.translateRestore$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> crashRecovery({required List<String>? tabIds}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.crashRecovery$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabIds]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> purgeHistory() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.purgeHistory$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> updateLastAccess({required String? tabId, required int? lastAccess}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.updateLastAccess$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, lastAccess]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<Uint8List?> requestScreenshot(bool sendBack) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.requestScreenshot$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[sendBack]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?);
    }
  }
}

class GeckoTabsApi {
  /// Constructor for [GeckoTabsApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoTabsApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> syncEvents({required bool onSelectedTabChange, required bool onTabListChange, required bool onTabContentStateChange, required bool onIconChange, required bool onSecurityInfoStateChange, required bool onReaderableStateChange, required bool onHistoryStateChange, required bool onFindResults, required bool onThumbnailChange, }) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.syncEvents$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[onSelectedTabChange, onTabListChange, onTabContentStateChange, onIconChange, onSecurityInfoStateChange, onReaderableStateChange, onHistoryStateChange, onFindResults, onThumbnailChange]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> selectTab({required String tabId}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.selectTab$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeTab({required String tabId}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removeTab$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<String> addTab({required String url, required bool selectTab, required bool startLoading, required String? parentId, required LoadUrlFlagsValue flags, required String? contextId, required SourceValue source, required bool private, required HistoryMetadataKey? historyMetadata, required Map<String, String>? additionalHeaders, }) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.addTab$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[url, selectTab, startLoading, parentId, flags, contextId, source, private, historyMetadata, additionalHeaders]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  Future<void> removeAllTabs({required bool recoverable}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removeAllTabs$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[recoverable]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeTabs({required List<String> ids}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removeTabs$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[ids]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeNormalTabs() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removeNormalTabs$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removePrivateTabs() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removePrivateTabs$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> undo() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.undo$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> restoreTabsByList({required List<RecoverableTab> tabs, required String? selectTabId, required RestoreLocation restoreLocation, }) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.restoreTabsByList$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabs, selectTabId, restoreLocation]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> restoreTabsByBrowserState({required RecoverableBrowserState state, required RestoreLocation restoreLocation}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.restoreTabsByBrowserState$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[state, restoreLocation]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Selects an already existing tab with the matching [HistoryMetadataKey] or otherwise
  /// creates a new tab with the given [url].
  Future<String> selectOrAddTabByHistory({required String url, required HistoryMetadataKey historyMetadata}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.selectOrAddTabByHistory$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[url, historyMetadata]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  /// Selects an already existing tab displaying [url] or otherwise creates a new tab.
  Future<String> selectOrAddTabByUrl({required String url, required bool private, required SourceValue source, required LoadUrlFlagsValue flags, required bool ignoreFragment, }) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.selectOrAddTabByUrl$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[url, private, source, flags, ignoreFragment]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  Future<String> duplicateTab({required String? selectTabId, required bool selectNewTab, required String? newContextId, }) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.duplicateTab$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[selectTabId, selectNewTab, newContextId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  Future<void> moveTabs({required List<String> tabIds, required String targetTabId, required bool placeAfter, }) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.moveTabs$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabIds, targetTabId, placeAfter]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<String> migratePrivateTabUseCase({required String tabId, required String? alternativeUrl}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.migratePrivateTabUseCase$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, alternativeUrl]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }
}

class GeckoFindApi {
  /// Constructor for [GeckoFindApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoFindApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> findAll(String? tabId, String text) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoFindApi.findAll$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, text]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> findNext(String? tabId, bool forward) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoFindApi.findNext$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, forward]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> clearMatches(String? tabId) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoFindApi.clearMatches$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class GeckoIconsApi {
  /// Constructor for [GeckoIconsApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoIconsApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<IconResult> loadIcon(IconRequest request) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoIconsApi.loadIcon$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[request]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IconResult?)!;
    }
  }
}

class GeckoPrefApi {
  /// Constructor for [GeckoPrefApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoPrefApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<List<String>> getPrefList() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.getPrefList$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<String>();
    }
  }

  Future<Map<String, GeckoPref>> getPrefs(List<String> preferenceFilter) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.getPrefs$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[preferenceFilter]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)!.cast<String, GeckoPref>();
    }
  }

  Future<Map<String, GeckoPref>> applyPrefs(Map<String, Object> prefs) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.applyPrefs$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[prefs]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)!.cast<String, GeckoPref>();
    }
  }

  Future<void> resetPrefs(List<String> preferenceNames) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.resetPrefs$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[preferenceNames]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> startObserveChanges() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.startObserveChanges$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> stopObserveChanges() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.stopObserveChanges$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> registerPrefForObservation(String name) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.registerPrefForObservation$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[name]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> unregisterPrefForObservation(String name) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.unregisterPrefForObservation$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[name]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class GeckoMlApi {
  /// Constructor for [GeckoMlApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoMlApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<String> predictDocumentTopic(List<String> documents) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoMlApi.predictDocumentTopic$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[documents]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  Future<List<Object?>> generateDocumentEmbeddings(List<String> documents) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoMlApi.generateDocumentEmbeddings$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[documents]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!;
    }
  }
}

class GeckoBrowserExtensionApi {
  /// Constructor for [GeckoBrowserExtensionApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoBrowserExtensionApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<List<Object>> getMarkdown(List<String> htmlList) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserExtensionApi.getMarkdown$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[htmlList]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<Object>();
    }
  }
}

class GeckoContainerProxyApi {
  /// Constructor for [GeckoContainerProxyApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoContainerProxyApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> setProxyPort(int port) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoContainerProxyApi.setProxyPort$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[port]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> addContainerProxy(String contextId) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoContainerProxyApi.addContainerProxy$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[contextId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeContainerProxy(String contextId) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoContainerProxyApi.removeContainerProxy$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[contextId]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> setSiteAssignments(Map<String, String> assignments) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoContainerProxyApi.setSiteAssignments$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[assignments]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<bool> healthcheck() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoContainerProxyApi.healthcheck$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }
}

class GeckoCookieApi {
  /// Constructor for [GeckoCookieApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoCookieApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<Cookie> getCookie(String? firstPartyDomain, String name, CookiePartitionKey? partitionKey, String? storeId, String url) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoCookieApi.getCookie$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[firstPartyDomain, name, partitionKey, storeId, url]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Cookie?)!;
    }
  }

  Future<List<Cookie>> getAllCookies(String? domain, String? firstPartyDomain, String? name, CookiePartitionKey? partitionKey, String? storeId, String url) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoCookieApi.getAllCookies$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[domain, firstPartyDomain, name, partitionKey, storeId, url]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<Cookie>();
    }
  }

  Future<void> setCookie(String? domain, int? expirationDate, String? firstPartyDomain, bool? httpOnly, String? name, CookiePartitionKey? partitionKey, String? path, CookieSameSiteStatus? sameSite, bool? secure, String? storeId, String url, String? value) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoCookieApi.setCookie$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[domain, expirationDate, firstPartyDomain, httpOnly, name, partitionKey, path, sameSite, secure, storeId, url, value]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeCookie(String? firstPartyDomain, String name, CookiePartitionKey? partitionKey, String? storeId, String url) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoCookieApi.removeCookie$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[firstPartyDomain, name, partitionKey, storeId, url]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class GeckoStateEvents {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onViewReadyStateChange(int timestamp, bool state);

  void onEngineReadyStateChange(int timestamp, bool state);

  void onIconUpdate(int timestamp, String url, Uint8List bytes);

  void onTabAdded(int timestamp, String tabId);

  void onTabListChange(int timestamp, List<String> tabIds);

  void onSelectedTabChange(int timestamp, String? id);

  void onTabContentStateChange(int timestamp, TabContentState state);

  void onHistoryStateChange(int timestamp, String id, HistoryState state);

  void onReaderableStateChange(int timestamp, String id, ReaderableState state);

  void onSecurityInfoStateChange(int timestamp, String id, SecurityInfoState state);

  void onIconChange(int timestamp, String id, Uint8List? bytes);

  void onThumbnailChange(int timestamp, String id, Uint8List? bytes);

  void onFindResults(int timestamp, String id, List<FindResultState> results);

  void onLongPress(int timestamp, String id, HitResult hitResult);

  void onScrollChange(int timestamp, String tabId, int scrollY);

  void onPreferenceChange(int timestamp, GeckoPref value);

  void onContainerSiteAssignment(int timestamp, ContainerSiteAssignment details);

  static void setUp(GeckoStateEvents? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onViewReadyStateChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onViewReadyStateChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onViewReadyStateChange was null, expected non-null int.');
          final bool? arg_state = (args[1] as bool?);
          assert(arg_state != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onViewReadyStateChange was null, expected non-null bool.');
          try {
            api.onViewReadyStateChange(arg_timestamp!, arg_state!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onEngineReadyStateChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onEngineReadyStateChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onEngineReadyStateChange was null, expected non-null int.');
          final bool? arg_state = (args[1] as bool?);
          assert(arg_state != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onEngineReadyStateChange was null, expected non-null bool.');
          try {
            api.onEngineReadyStateChange(arg_timestamp!, arg_state!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconUpdate$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconUpdate was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconUpdate was null, expected non-null int.');
          final String? arg_url = (args[1] as String?);
          assert(arg_url != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconUpdate was null, expected non-null String.');
          final Uint8List? arg_bytes = (args[2] as Uint8List?);
          assert(arg_bytes != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconUpdate was null, expected non-null Uint8List.');
          try {
            api.onIconUpdate(arg_timestamp!, arg_url!, arg_bytes!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabAdded$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabAdded was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabAdded was null, expected non-null int.');
          final String? arg_tabId = (args[1] as String?);
          assert(arg_tabId != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabAdded was null, expected non-null String.');
          try {
            api.onTabAdded(arg_timestamp!, arg_tabId!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabListChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabListChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabListChange was null, expected non-null int.');
          final List<String>? arg_tabIds = (args[1] as List<Object?>?)?.cast<String>();
          assert(arg_tabIds != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabListChange was null, expected non-null List<String>.');
          try {
            api.onTabListChange(arg_timestamp!, arg_tabIds!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSelectedTabChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSelectedTabChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSelectedTabChange was null, expected non-null int.');
          final String? arg_id = (args[1] as String?);
          try {
            api.onSelectedTabChange(arg_timestamp!, arg_id);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabContentStateChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabContentStateChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabContentStateChange was null, expected non-null int.');
          final TabContentState? arg_state = (args[1] as TabContentState?);
          assert(arg_state != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabContentStateChange was null, expected non-null TabContentState.');
          try {
            api.onTabContentStateChange(arg_timestamp!, arg_state!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onHistoryStateChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onHistoryStateChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onHistoryStateChange was null, expected non-null int.');
          final String? arg_id = (args[1] as String?);
          assert(arg_id != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onHistoryStateChange was null, expected non-null String.');
          final HistoryState? arg_state = (args[2] as HistoryState?);
          assert(arg_state != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onHistoryStateChange was null, expected non-null HistoryState.');
          try {
            api.onHistoryStateChange(arg_timestamp!, arg_id!, arg_state!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onReaderableStateChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onReaderableStateChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onReaderableStateChange was null, expected non-null int.');
          final String? arg_id = (args[1] as String?);
          assert(arg_id != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onReaderableStateChange was null, expected non-null String.');
          final ReaderableState? arg_state = (args[2] as ReaderableState?);
          assert(arg_state != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onReaderableStateChange was null, expected non-null ReaderableState.');
          try {
            api.onReaderableStateChange(arg_timestamp!, arg_id!, arg_state!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSecurityInfoStateChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSecurityInfoStateChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSecurityInfoStateChange was null, expected non-null int.');
          final String? arg_id = (args[1] as String?);
          assert(arg_id != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSecurityInfoStateChange was null, expected non-null String.');
          final SecurityInfoState? arg_state = (args[2] as SecurityInfoState?);
          assert(arg_state != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSecurityInfoStateChange was null, expected non-null SecurityInfoState.');
          try {
            api.onSecurityInfoStateChange(arg_timestamp!, arg_id!, arg_state!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconChange was null, expected non-null int.');
          final String? arg_id = (args[1] as String?);
          assert(arg_id != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconChange was null, expected non-null String.');
          final Uint8List? arg_bytes = (args[2] as Uint8List?);
          try {
            api.onIconChange(arg_timestamp!, arg_id!, arg_bytes);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onThumbnailChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onThumbnailChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onThumbnailChange was null, expected non-null int.');
          final String? arg_id = (args[1] as String?);
          assert(arg_id != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onThumbnailChange was null, expected non-null String.');
          final Uint8List? arg_bytes = (args[2] as Uint8List?);
          try {
            api.onThumbnailChange(arg_timestamp!, arg_id!, arg_bytes);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onFindResults$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onFindResults was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onFindResults was null, expected non-null int.');
          final String? arg_id = (args[1] as String?);
          assert(arg_id != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onFindResults was null, expected non-null String.');
          final List<FindResultState>? arg_results = (args[2] as List<Object?>?)?.cast<FindResultState>();
          assert(arg_results != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onFindResults was null, expected non-null List<FindResultState>.');
          try {
            api.onFindResults(arg_timestamp!, arg_id!, arg_results!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onLongPress$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onLongPress was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onLongPress was null, expected non-null int.');
          final String? arg_id = (args[1] as String?);
          assert(arg_id != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onLongPress was null, expected non-null String.');
          final HitResult? arg_hitResult = (args[2] as HitResult?);
          assert(arg_hitResult != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onLongPress was null, expected non-null HitResult.');
          try {
            api.onLongPress(arg_timestamp!, arg_id!, arg_hitResult!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onScrollChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onScrollChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onScrollChange was null, expected non-null int.');
          final String? arg_tabId = (args[1] as String?);
          assert(arg_tabId != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onScrollChange was null, expected non-null String.');
          final int? arg_scrollY = (args[2] as int?);
          assert(arg_scrollY != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onScrollChange was null, expected non-null int.');
          try {
            api.onScrollChange(arg_timestamp!, arg_tabId!, arg_scrollY!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onPreferenceChange$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onPreferenceChange was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onPreferenceChange was null, expected non-null int.');
          final GeckoPref? arg_value = (args[1] as GeckoPref?);
          assert(arg_value != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onPreferenceChange was null, expected non-null GeckoPref.');
          try {
            api.onPreferenceChange(arg_timestamp!, arg_value!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onContainerSiteAssignment$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onContainerSiteAssignment was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onContainerSiteAssignment was null, expected non-null int.');
          final ContainerSiteAssignment? arg_details = (args[1] as ContainerSiteAssignment?);
          assert(arg_details != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onContainerSiteAssignment was null, expected non-null ContainerSiteAssignment.');
          try {
            api.onContainerSiteAssignment(arg_timestamp!, arg_details!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

abstract class GeckoLogging {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onLog(LogLevel level, String message);

  static void setUp(GeckoLogging? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoLogging.onLog$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoLogging.onLog was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final LogLevel? arg_level = (args[0] as LogLevel?);
          assert(arg_level != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoLogging.onLog was null, expected non-null LogLevel.');
          final String? arg_message = (args[1] as String?);
          assert(arg_message != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoLogging.onLog was null, expected non-null String.');
          try {
            api.onLog(arg_level!, arg_message!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

class ReaderViewEvents {
  /// Constructor for [ReaderViewEvents].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  ReaderViewEvents({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> onToggleReaderView(bool enable) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.ReaderViewEvents.onToggleReaderView$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[enable]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> onAppearanceButtonTap() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.ReaderViewEvents.onAppearanceButtonTap$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class ReaderViewController {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void appearanceButtonVisibility(int timestamp, bool visible);

  static void setUp(ReaderViewController? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.ReaderViewController.appearanceButtonVisibility$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.ReaderViewController.appearanceButtonVisibility was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.ReaderViewController.appearanceButtonVisibility was null, expected non-null int.');
          final bool? arg_visible = (args[1] as bool?);
          assert(arg_visible != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.ReaderViewController.appearanceButtonVisibility was null, expected non-null bool.');
          try {
            api.appearanceButtonVisibility(arg_timestamp!, arg_visible!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

class GeckoSelectionActionController {
  /// Constructor for [GeckoSelectionActionController].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoSelectionActionController({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> setActions(List<CustomSelectionAction> actions) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSelectionActionController.setActions$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[actions]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class GeckoSelectionActionEvents {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void performSelectionAction(String id, String selectedText);

  static void setUp(GeckoSelectionActionEvents? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoSelectionActionEvents.performSelectionAction$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoSelectionActionEvents.performSelectionAction was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final String? arg_id = (args[0] as String?);
          assert(arg_id != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoSelectionActionEvents.performSelectionAction was null, expected non-null String.');
          final String? arg_selectedText = (args[1] as String?);
          assert(arg_selectedText != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoSelectionActionEvents.performSelectionAction was null, expected non-null String.');
          try {
            api.performSelectionAction(arg_id!, arg_selectedText!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

class GeckoAddonsApi {
  /// Constructor for [GeckoAddonsApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoAddonsApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> startAddonManagerActivity() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonsApi.startAddonManagerActivity$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> invokeAddonAction(String extensionId, WebExtensionActionType actionType) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonsApi.invokeAddonAction$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[extensionId, actionType]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> installAddon(String url) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonsApi.installAddon$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[url]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class GeckoAddonEvents {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onUpsertWebExtensionAction(int timestamp, String extensionId, WebExtensionActionType actionType, WebExtensionData extensionData);

  void onRemoveWebExtensionAction(int timestamp, String extensionId, WebExtensionActionType actionType);

  void onUpdateWebExtensionIcon(int timestamp, String extensionId, WebExtensionActionType actionType, Uint8List icon);

  static void setUp(GeckoAddonEvents? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpsertWebExtensionAction$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpsertWebExtensionAction was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpsertWebExtensionAction was null, expected non-null int.');
          final String? arg_extensionId = (args[1] as String?);
          assert(arg_extensionId != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpsertWebExtensionAction was null, expected non-null String.');
          final WebExtensionActionType? arg_actionType = (args[2] as WebExtensionActionType?);
          assert(arg_actionType != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpsertWebExtensionAction was null, expected non-null WebExtensionActionType.');
          final WebExtensionData? arg_extensionData = (args[3] as WebExtensionData?);
          assert(arg_extensionData != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpsertWebExtensionAction was null, expected non-null WebExtensionData.');
          try {
            api.onUpsertWebExtensionAction(arg_timestamp!, arg_extensionId!, arg_actionType!, arg_extensionData!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onRemoveWebExtensionAction$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onRemoveWebExtensionAction was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onRemoveWebExtensionAction was null, expected non-null int.');
          final String? arg_extensionId = (args[1] as String?);
          assert(arg_extensionId != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onRemoveWebExtensionAction was null, expected non-null String.');
          final WebExtensionActionType? arg_actionType = (args[2] as WebExtensionActionType?);
          assert(arg_actionType != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onRemoveWebExtensionAction was null, expected non-null WebExtensionActionType.');
          try {
            api.onRemoveWebExtensionAction(arg_timestamp!, arg_extensionId!, arg_actionType!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpdateWebExtensionIcon$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpdateWebExtensionIcon was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpdateWebExtensionIcon was null, expected non-null int.');
          final String? arg_extensionId = (args[1] as String?);
          assert(arg_extensionId != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpdateWebExtensionIcon was null, expected non-null String.');
          final WebExtensionActionType? arg_actionType = (args[2] as WebExtensionActionType?);
          assert(arg_actionType != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpdateWebExtensionIcon was null, expected non-null WebExtensionActionType.');
          final Uint8List? arg_icon = (args[3] as Uint8List?);
          assert(arg_icon != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpdateWebExtensionIcon was null, expected non-null Uint8List.');
          try {
            api.onUpdateWebExtensionIcon(arg_timestamp!, arg_extensionId!, arg_actionType!, arg_icon!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

class GeckoSuggestionApi {
  /// Constructor for [GeckoSuggestionApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoSuggestionApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<AutocompleteResult?> getAutocompleteSuggestion(String query) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionApi.getAutocompleteSuggestion$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[query]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as AutocompleteResult?);
    }
  }

  Future<void> querySuggestions(String text, List<GeckoSuggestionType> providers) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionApi.querySuggestions$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[text, providers]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class GeckoSuggestionEvents {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onSuggestionResult(int timestamp, GeckoSuggestionType suggestionType, List<GeckoSuggestion> suggestions);

  static void setUp(GeckoSuggestionEvents? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionEvents.onSuggestionResult$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionEvents.onSuggestionResult was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionEvents.onSuggestionResult was null, expected non-null int.');
          final GeckoSuggestionType? arg_suggestionType = (args[1] as GeckoSuggestionType?);
          assert(arg_suggestionType != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionEvents.onSuggestionResult was null, expected non-null GeckoSuggestionType.');
          final List<GeckoSuggestion>? arg_suggestions = (args[2] as List<Object?>?)?.cast<GeckoSuggestion>();
          assert(arg_suggestions != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionEvents.onSuggestionResult was null, expected non-null List<GeckoSuggestion>.');
          try {
            api.onSuggestionResult(arg_timestamp!, arg_suggestionType!, arg_suggestions!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

abstract class GeckoTabContentEvents {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onContentUpdate(int timestamp, TabContent content);

  static void setUp(GeckoTabContentEvents? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.GeckoTabContentEvents.onContentUpdate$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoTabContentEvents.onContentUpdate was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoTabContentEvents.onContentUpdate was null, expected non-null int.');
          final TabContent? arg_content = (args[1] as TabContent?);
          assert(arg_content != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.GeckoTabContentEvents.onContentUpdate was null, expected non-null TabContent.');
          try {
            api.onContentUpdate(arg_timestamp!, arg_content!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

class GeckoDeleteBrowsingDataController {
  /// Constructor for [GeckoDeleteBrowsingDataController].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoDeleteBrowsingDataController({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> deleteTabs() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteTabs$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> deleteBrowsingHistory() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteBrowsingHistory$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> deleteCookiesAndSiteData() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteCookiesAndSiteData$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> deleteCachedFiles() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteCachedFiles$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> deleteSitePermissions() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteSitePermissions$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> deleteDownloads() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteDownloads$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class GeckoHistoryApi {
  /// Constructor for [GeckoHistoryApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoHistoryApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<List<VisitInfo>> getDetailedVisits(int startMillis, int endMillis, List<VisitType> excludeTypes) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoHistoryApi.getDetailedVisits$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[startMillis, endMillis, excludeTypes]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<VisitInfo>();
    }
  }

  Future<void> deleteVisit(String url, int timestamp) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoHistoryApi.deleteVisit$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[url, timestamp]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> deleteDownload(String id) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoHistoryApi.deleteDownload$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[id]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> deleteVisitsBetween(int startMillis, int endMillis) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoHistoryApi.deleteVisitsBetween$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[startMillis, endMillis]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class GeckoDownloadsApi {
  /// Constructor for [GeckoDownloadsApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoDownloadsApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> requestDownload(String tabId, DownloadState state) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoDownloadsApi.requestDownload$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, state]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> copyInternetResource(String tabId, ShareInternetResourceState state) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoDownloadsApi.copyInternetResource$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, state]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> shareInternetResource(String tabId, ShareInternetResourceState state) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoDownloadsApi.shareInternetResource$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tabId, state]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class BrowserExtensionEvents {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onFeedRequested(int timestamp, String url);

  static void setUp(BrowserExtensionEvents? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.flutter_mozilla_components.BrowserExtensionEvents.onFeedRequested$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.flutter_mozilla_components.BrowserExtensionEvents.onFeedRequested was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_timestamp = (args[0] as int?);
          assert(arg_timestamp != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.BrowserExtensionEvents.onFeedRequested was null, expected non-null int.');
          final String? arg_url = (args[1] as String?);
          assert(arg_url != null,
              'Argument for dev.flutter.pigeon.flutter_mozilla_components.BrowserExtensionEvents.onFeedRequested was null, expected non-null String.');
          try {
            api.onFeedRequested(arg_timestamp!, arg_url!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

class GeckoFetchApi {
  /// Constructor for [GeckoFetchApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoFetchApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<GeckoFetchResponse> fetch(GeckoFetchRequest request) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoFetchApi.fetch$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[request]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as GeckoFetchResponse?)!;
    }
  }
}

class GeckoBookmarksApi {
  /// Constructor for [GeckoBookmarksApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  GeckoBookmarksApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  /// Produces a bookmarks tree for the given guid string.
  ///
  /// @param guid The bookmark guid to obtain.
  /// @param recursive Whether to recurse and obtain all levels of children.
  /// @return The populated root starting from the guid.
  Future<BookmarkNode?> getTree(String guid, bool recursive) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBookmarksApi.getTree$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[guid, recursive]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as BookmarkNode?);
    }
  }

  /// Obtains the details of a bookmark without children, if one exists with that guid. Otherwise, null.
  ///
  /// @param guid The bookmark guid to obtain.
  /// @return The bookmark node or null if it does not exist.
  Future<BookmarkNode?> getBookmark(String guid) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBookmarksApi.getBookmark$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[guid]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as BookmarkNode?);
    }
  }

  /// Produces a list of all bookmarks with the given URL.
  ///
  /// @param url The URL string.
  /// @return The list of bookmarks that match the URL
  Future<List<BookmarkNode>> getBookmarksWithUrl(String url) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBookmarksApi.getBookmarksWithUrl$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[url]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<BookmarkNode>();
    }
  }

  /// Produces a list of the most recently added bookmarks.
  ///
  /// @param limit The maximum number of entries to return.
  /// @param maxAge Optional parameter used to filter out entries older than this number of milliseconds.
  /// @param currentTime Optional parameter for current time. Defaults toSystem.currentTimeMillis()
  /// @return The list of bookmarks that have been recently added up to the limit number of items.
  Future<List<BookmarkNode>> getRecentBookmarks(int limit, int? maxAge, int currentTime) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBookmarksApi.getRecentBookmarks$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[limit, maxAge, currentTime]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<BookmarkNode>();
    }
  }

  /// Searches bookmarks with a query string.
  ///
  /// @param query The query string to search.
  /// @param limit The maximum number of entries to return.
  /// @return The list of matching bookmark nodes up to the limit number of items.
  Future<List<BookmarkNode>> searchBookmarks(String query, int limit) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBookmarksApi.searchBookmarks$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[query, limit]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<BookmarkNode>();
    }
  }

  /// Adds a new bookmark item to a given node.
  ///
  /// Sync behavior: will add new bookmark item to remote devices.
  ///
  /// @param parentGuid The parent guid of the new node.
  /// @param url The URL of the bookmark item to add.
  /// @param title The title of the bookmark item to add.
  /// @param position The optional position to add the new node or null to append.
  /// @return The guid of the newly inserted bookmark item.
  Future<String> addItem(String parentGuid, String url, String title, int? position) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBookmarksApi.addItem$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[parentGuid, url, title, position]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  /// Adds a new bookmark folder to a given node.
  ///
  /// Sync behavior: will add new separator to remote devices.
  ///
  /// @param parentGuid The parent guid of the new node.
  /// @param title The title of the bookmark folder to add.
  /// @param position The optional position to add the new node or null to append.
  /// @return The guid of the newly inserted bookmark item.
  Future<String> addFolder(String parentGuid, String title, int? position) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBookmarksApi.addFolder$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[parentGuid, title, position]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  /// Edits the properties of an existing bookmark item and/or moves an existing one underneath a new parent guid.
  ///
  /// Sync behavior: will alter bookmark item on remote devices.
  ///
  /// @param guid The guid of the item to update.
  /// @param info The info to change in the bookmark.
  Future<void> updateNode(String guid, BookmarkInfo info) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBookmarksApi.updateNode$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[guid, info]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Deletes a bookmark node and all of its children, if any.
  ///
  /// Sync behavior: will remove bookmark from remote devices.
  ///
  /// @return Whether the bookmark existed or not.
  Future<bool> deleteNode(String guid) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.flutter_mozilla_components.GeckoBookmarksApi.deleteNode$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[guid]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }
}
