/*
 * Copyright (c) 2024-2025 Fabian Freund.
 *
 * This file is part of WebLibre
 * (see https://weblibre.eu).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
import 'package:fast_equatable/fast_equatable.dart';
import 'package:json_annotation/json_annotation.dart';

part 'rfp_target.g.dart';

@JsonSerializable()
class RFPTarget with FastEquatable {
  final String name;
  final int id;
  final String? description;
  final List<String> keywords;

  RFPTarget({
    required this.name,
    required this.id,
    this.description,
    required this.keywords,
  });

  factory RFPTarget.fromJson(Map<String, dynamic> json) =>
      _$RFPTargetFromJson(json);

  Map<String, dynamic> toJson() => _$RFPTargetToJson(this);

  @override
  List<Object?> get hashParameters => [name, id, description, keywords];
}
