/*
 * Copyright (c) 2024-2025 Fabian Freund.
 *
 * This file is part of WebLibre
 * (see https://weblibre.eu).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
import 'package:fast_equatable/fast_equatable.dart';
import 'package:weblibre/utils/uri_parser.dart' as uri_parser;

sealed class SharedContent with FastEquatable {
  SharedContent();

  factory SharedContent.parse(String content) {
    if (uri_parser.tryParseUrl(content, eagerParsing: true)
        case final Uri uri) {
      return SharedUrl(uri);
    } else {
      return SharedText(content);
    }
  }
}

final class SharedUrl extends SharedContent {
  final Uri url;

  SharedUrl(this.url);

  @override
  String toString() => url.toString();

  @override
  List<Object?> get hashParameters => [url];
}

final class SharedText extends SharedContent {
  final String text;

  SharedText(this.text);

  @override
  String toString() => text;

  @override
  List<Object?> get hashParameters => [text];
}
