/*
 * Copyright (c) 2024-2025 Fabian Freund.
 *
 * This file is part of WebLibre
 * (see https://weblibre.eu).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
import 'package:flutter/material.dart';
import 'package:flutter_hooks/flutter_hooks.dart';
import 'package:hooks_riverpod/hooks_riverpod.dart';
import 'package:weblibre/core/routing/routes.dart';
import 'package:weblibre/features/geckoview/domain/providers/tab_state.dart';
import 'package:weblibre/features/geckoview/features/browser/presentation/controllers/tree_view.dart';
import 'package:weblibre/features/geckoview/features/browser/presentation/widgets/view_tabs.dart';
import 'package:weblibre/features/user/domain/repositories/general_settings.dart';

class TabViewScreen extends HookConsumerWidget {
  const TabViewScreen();

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final treeModeEnabled = ref.watch(treeViewControllerProvider);

    final scrollController = useScrollController();

    return Dialog.fullscreen(
      child: Scaffold(
        body: SafeArea(
          child: treeModeEnabled
              ? ViewTabTreesWidget(
                  scrollController: scrollController,
                  showNewTabFab: false,
                  onClose: () {
                    const BrowserRoute().go(context);
                  },
                )
              : ViewTabsWidget(
                  scrollController: scrollController,
                  showNewTabFab: false,
                  onClose: () {
                    const BrowserRoute().go(context);
                  },
                ),
        ),
        floatingActionButton: FloatingActionButton(
          onPressed: () async {
            final settings = ref.read(generalSettingsWithDefaultsProvider);

            await SearchRoute(
              tabType:
                  ref.read(selectedTabTypeProvider) ??
                  settings.defaultCreateTabType,
            ).push(context);

            if (context.mounted) {
              const BrowserRoute().go(context);
            }
          },
          child: const Icon(Icons.add),
        ),
      ),
    );
  }
}
