// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "core_tests.gen.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>

namespace core_tests_pigeontest {
using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

FlutterError CreateConnectionError(const std::string channel_name) {
  return FlutterError(
      "channel-error",
      "Unable to establish connection on channel: '" + channel_name + "'.",
      EncodableValue(""));
}

// UnusedClass

UnusedClass::UnusedClass() {}

UnusedClass::UnusedClass(const EncodableValue* a_field)
    : a_field_(a_field ? std::optional<EncodableValue>(*a_field)
                       : std::nullopt) {}

const EncodableValue* UnusedClass::a_field() const {
  return a_field_ ? &(*a_field_) : nullptr;
}

void UnusedClass::set_a_field(const EncodableValue* value_arg) {
  a_field_ =
      value_arg ? std::optional<EncodableValue>(*value_arg) : std::nullopt;
}

void UnusedClass::set_a_field(const EncodableValue& value_arg) {
  a_field_ = value_arg;
}

EncodableList UnusedClass::ToEncodableList() const {
  EncodableList list;
  list.reserve(1);
  list.push_back(a_field_ ? *a_field_ : EncodableValue());
  return list;
}

UnusedClass UnusedClass::FromEncodableList(const EncodableList& list) {
  UnusedClass decoded;
  auto& encodable_a_field = list[0];
  if (!encodable_a_field.IsNull()) {
    decoded.set_a_field(encodable_a_field);
  }
  return decoded;
}

// AllTypes

AllTypes::AllTypes(bool a_bool, int64_t an_int, int64_t an_int64,
                   double a_double, const std::vector<uint8_t>& a_byte_array,
                   const std::vector<int32_t>& a4_byte_array,
                   const std::vector<int64_t>& a8_byte_array,
                   const std::vector<double>& a_float_array,
                   const AnEnum& an_enum, const AnotherEnum& another_enum,
                   const std::string& a_string, const EncodableValue& an_object,
                   const EncodableList& list, const EncodableList& string_list,
                   const EncodableList& int_list,
                   const EncodableList& double_list,
                   const EncodableList& bool_list,
                   const EncodableList& enum_list,
                   const EncodableList& object_list,
                   const EncodableList& list_list,
                   const EncodableList& map_list, const EncodableMap& map,
                   const EncodableMap& string_map, const EncodableMap& int_map,
                   const EncodableMap& enum_map, const EncodableMap& object_map,
                   const EncodableMap& list_map, const EncodableMap& map_map)
    : a_bool_(a_bool),
      an_int_(an_int),
      an_int64_(an_int64),
      a_double_(a_double),
      a_byte_array_(a_byte_array),
      a4_byte_array_(a4_byte_array),
      a8_byte_array_(a8_byte_array),
      a_float_array_(a_float_array),
      an_enum_(an_enum),
      another_enum_(another_enum),
      a_string_(a_string),
      an_object_(an_object),
      list_(list),
      string_list_(string_list),
      int_list_(int_list),
      double_list_(double_list),
      bool_list_(bool_list),
      enum_list_(enum_list),
      object_list_(object_list),
      list_list_(list_list),
      map_list_(map_list),
      map_(map),
      string_map_(string_map),
      int_map_(int_map),
      enum_map_(enum_map),
      object_map_(object_map),
      list_map_(list_map),
      map_map_(map_map) {}

bool AllTypes::a_bool() const { return a_bool_; }

void AllTypes::set_a_bool(bool value_arg) { a_bool_ = value_arg; }

int64_t AllTypes::an_int() const { return an_int_; }

void AllTypes::set_an_int(int64_t value_arg) { an_int_ = value_arg; }

int64_t AllTypes::an_int64() const { return an_int64_; }

void AllTypes::set_an_int64(int64_t value_arg) { an_int64_ = value_arg; }

double AllTypes::a_double() const { return a_double_; }

void AllTypes::set_a_double(double value_arg) { a_double_ = value_arg; }

const std::vector<uint8_t>& AllTypes::a_byte_array() const {
  return a_byte_array_;
}

void AllTypes::set_a_byte_array(const std::vector<uint8_t>& value_arg) {
  a_byte_array_ = value_arg;
}

const std::vector<int32_t>& AllTypes::a4_byte_array() const {
  return a4_byte_array_;
}

void AllTypes::set_a4_byte_array(const std::vector<int32_t>& value_arg) {
  a4_byte_array_ = value_arg;
}

const std::vector<int64_t>& AllTypes::a8_byte_array() const {
  return a8_byte_array_;
}

void AllTypes::set_a8_byte_array(const std::vector<int64_t>& value_arg) {
  a8_byte_array_ = value_arg;
}

const std::vector<double>& AllTypes::a_float_array() const {
  return a_float_array_;
}

void AllTypes::set_a_float_array(const std::vector<double>& value_arg) {
  a_float_array_ = value_arg;
}

const AnEnum& AllTypes::an_enum() const { return an_enum_; }

void AllTypes::set_an_enum(const AnEnum& value_arg) { an_enum_ = value_arg; }

const AnotherEnum& AllTypes::another_enum() const { return another_enum_; }

void AllTypes::set_another_enum(const AnotherEnum& value_arg) {
  another_enum_ = value_arg;
}

const std::string& AllTypes::a_string() const { return a_string_; }

void AllTypes::set_a_string(std::string_view value_arg) {
  a_string_ = value_arg;
}

const EncodableValue& AllTypes::an_object() const { return an_object_; }

void AllTypes::set_an_object(const EncodableValue& value_arg) {
  an_object_ = value_arg;
}

const EncodableList& AllTypes::list() const { return list_; }

void AllTypes::set_list(const EncodableList& value_arg) { list_ = value_arg; }

const EncodableList& AllTypes::string_list() const { return string_list_; }

void AllTypes::set_string_list(const EncodableList& value_arg) {
  string_list_ = value_arg;
}

const EncodableList& AllTypes::int_list() const { return int_list_; }

void AllTypes::set_int_list(const EncodableList& value_arg) {
  int_list_ = value_arg;
}

const EncodableList& AllTypes::double_list() const { return double_list_; }

void AllTypes::set_double_list(const EncodableList& value_arg) {
  double_list_ = value_arg;
}

const EncodableList& AllTypes::bool_list() const { return bool_list_; }

void AllTypes::set_bool_list(const EncodableList& value_arg) {
  bool_list_ = value_arg;
}

const EncodableList& AllTypes::enum_list() const { return enum_list_; }

void AllTypes::set_enum_list(const EncodableList& value_arg) {
  enum_list_ = value_arg;
}

const EncodableList& AllTypes::object_list() const { return object_list_; }

void AllTypes::set_object_list(const EncodableList& value_arg) {
  object_list_ = value_arg;
}

const EncodableList& AllTypes::list_list() const { return list_list_; }

void AllTypes::set_list_list(const EncodableList& value_arg) {
  list_list_ = value_arg;
}

const EncodableList& AllTypes::map_list() const { return map_list_; }

void AllTypes::set_map_list(const EncodableList& value_arg) {
  map_list_ = value_arg;
}

const EncodableMap& AllTypes::map() const { return map_; }

void AllTypes::set_map(const EncodableMap& value_arg) { map_ = value_arg; }

const EncodableMap& AllTypes::string_map() const { return string_map_; }

void AllTypes::set_string_map(const EncodableMap& value_arg) {
  string_map_ = value_arg;
}

const EncodableMap& AllTypes::int_map() const { return int_map_; }

void AllTypes::set_int_map(const EncodableMap& value_arg) {
  int_map_ = value_arg;
}

const EncodableMap& AllTypes::enum_map() const { return enum_map_; }

void AllTypes::set_enum_map(const EncodableMap& value_arg) {
  enum_map_ = value_arg;
}

const EncodableMap& AllTypes::object_map() const { return object_map_; }

void AllTypes::set_object_map(const EncodableMap& value_arg) {
  object_map_ = value_arg;
}

const EncodableMap& AllTypes::list_map() const { return list_map_; }

void AllTypes::set_list_map(const EncodableMap& value_arg) {
  list_map_ = value_arg;
}

const EncodableMap& AllTypes::map_map() const { return map_map_; }

void AllTypes::set_map_map(const EncodableMap& value_arg) {
  map_map_ = value_arg;
}

EncodableList AllTypes::ToEncodableList() const {
  EncodableList list;
  list.reserve(28);
  list.push_back(EncodableValue(a_bool_));
  list.push_back(EncodableValue(an_int_));
  list.push_back(EncodableValue(an_int64_));
  list.push_back(EncodableValue(a_double_));
  list.push_back(EncodableValue(a_byte_array_));
  list.push_back(EncodableValue(a4_byte_array_));
  list.push_back(EncodableValue(a8_byte_array_));
  list.push_back(EncodableValue(a_float_array_));
  list.push_back(CustomEncodableValue(an_enum_));
  list.push_back(CustomEncodableValue(another_enum_));
  list.push_back(EncodableValue(a_string_));
  list.push_back(an_object_);
  list.push_back(EncodableValue(list_));
  list.push_back(EncodableValue(string_list_));
  list.push_back(EncodableValue(int_list_));
  list.push_back(EncodableValue(double_list_));
  list.push_back(EncodableValue(bool_list_));
  list.push_back(EncodableValue(enum_list_));
  list.push_back(EncodableValue(object_list_));
  list.push_back(EncodableValue(list_list_));
  list.push_back(EncodableValue(map_list_));
  list.push_back(EncodableValue(map_));
  list.push_back(EncodableValue(string_map_));
  list.push_back(EncodableValue(int_map_));
  list.push_back(EncodableValue(enum_map_));
  list.push_back(EncodableValue(object_map_));
  list.push_back(EncodableValue(list_map_));
  list.push_back(EncodableValue(map_map_));
  return list;
}

AllTypes AllTypes::FromEncodableList(const EncodableList& list) {
  AllTypes decoded(
      std::get<bool>(list[0]), std::get<int64_t>(list[1]),
      std::get<int64_t>(list[2]), std::get<double>(list[3]),
      std::get<std::vector<uint8_t>>(list[4]),
      std::get<std::vector<int32_t>>(list[5]),
      std::get<std::vector<int64_t>>(list[6]),
      std::get<std::vector<double>>(list[7]),
      std::any_cast<const AnEnum&>(std::get<CustomEncodableValue>(list[8])),
      std::any_cast<const AnotherEnum&>(
          std::get<CustomEncodableValue>(list[9])),
      std::get<std::string>(list[10]), list[11],
      std::get<EncodableList>(list[12]), std::get<EncodableList>(list[13]),
      std::get<EncodableList>(list[14]), std::get<EncodableList>(list[15]),
      std::get<EncodableList>(list[16]), std::get<EncodableList>(list[17]),
      std::get<EncodableList>(list[18]), std::get<EncodableList>(list[19]),
      std::get<EncodableList>(list[20]), std::get<EncodableMap>(list[21]),
      std::get<EncodableMap>(list[22]), std::get<EncodableMap>(list[23]),
      std::get<EncodableMap>(list[24]), std::get<EncodableMap>(list[25]),
      std::get<EncodableMap>(list[26]), std::get<EncodableMap>(list[27]));
  return decoded;
}

// AllNullableTypes

AllNullableTypes::AllNullableTypes() {}

AllNullableTypes::AllNullableTypes(
    const bool* a_nullable_bool, const int64_t* a_nullable_int,
    const int64_t* a_nullable_int64, const double* a_nullable_double,
    const std::vector<uint8_t>* a_nullable_byte_array,
    const std::vector<int32_t>* a_nullable4_byte_array,
    const std::vector<int64_t>* a_nullable8_byte_array,
    const std::vector<double>* a_nullable_float_array,
    const AnEnum* a_nullable_enum, const AnotherEnum* another_nullable_enum,
    const std::string* a_nullable_string,
    const EncodableValue* a_nullable_object,
    const AllNullableTypes* all_nullable_types, const EncodableList* list,
    const EncodableList* string_list, const EncodableList* int_list,
    const EncodableList* double_list, const EncodableList* bool_list,
    const EncodableList* enum_list, const EncodableList* object_list,
    const EncodableList* list_list, const EncodableList* map_list,
    const EncodableList* recursive_class_list, const EncodableMap* map,
    const EncodableMap* string_map, const EncodableMap* int_map,
    const EncodableMap* enum_map, const EncodableMap* object_map,
    const EncodableMap* list_map, const EncodableMap* map_map,
    const EncodableMap* recursive_class_map)
    : a_nullable_bool_(a_nullable_bool ? std::optional<bool>(*a_nullable_bool)
                                       : std::nullopt),
      a_nullable_int_(a_nullable_int ? std::optional<int64_t>(*a_nullable_int)
                                     : std::nullopt),
      a_nullable_int64_(a_nullable_int64
                            ? std::optional<int64_t>(*a_nullable_int64)
                            : std::nullopt),
      a_nullable_double_(a_nullable_double
                             ? std::optional<double>(*a_nullable_double)
                             : std::nullopt),
      a_nullable_byte_array_(
          a_nullable_byte_array
              ? std::optional<std::vector<uint8_t>>(*a_nullable_byte_array)
              : std::nullopt),
      a_nullable4_byte_array_(
          a_nullable4_byte_array
              ? std::optional<std::vector<int32_t>>(*a_nullable4_byte_array)
              : std::nullopt),
      a_nullable8_byte_array_(
          a_nullable8_byte_array
              ? std::optional<std::vector<int64_t>>(*a_nullable8_byte_array)
              : std::nullopt),
      a_nullable_float_array_(
          a_nullable_float_array
              ? std::optional<std::vector<double>>(*a_nullable_float_array)
              : std::nullopt),
      a_nullable_enum_(a_nullable_enum ? std::optional<AnEnum>(*a_nullable_enum)
                                       : std::nullopt),
      another_nullable_enum_(another_nullable_enum ? std::optional<AnotherEnum>(
                                                         *another_nullable_enum)
                                                   : std::nullopt),
      a_nullable_string_(a_nullable_string
                             ? std::optional<std::string>(*a_nullable_string)
                             : std::nullopt),
      a_nullable_object_(a_nullable_object
                             ? std::optional<EncodableValue>(*a_nullable_object)
                             : std::nullopt),
      all_nullable_types_(
          all_nullable_types
              ? std::make_unique<AllNullableTypes>(*all_nullable_types)
              : nullptr),
      list_(list ? std::optional<EncodableList>(*list) : std::nullopt),
      string_list_(string_list ? std::optional<EncodableList>(*string_list)
                               : std::nullopt),
      int_list_(int_list ? std::optional<EncodableList>(*int_list)
                         : std::nullopt),
      double_list_(double_list ? std::optional<EncodableList>(*double_list)
                               : std::nullopt),
      bool_list_(bool_list ? std::optional<EncodableList>(*bool_list)
                           : std::nullopt),
      enum_list_(enum_list ? std::optional<EncodableList>(*enum_list)
                           : std::nullopt),
      object_list_(object_list ? std::optional<EncodableList>(*object_list)
                               : std::nullopt),
      list_list_(list_list ? std::optional<EncodableList>(*list_list)
                           : std::nullopt),
      map_list_(map_list ? std::optional<EncodableList>(*map_list)
                         : std::nullopt),
      recursive_class_list_(recursive_class_list ? std::optional<EncodableList>(
                                                       *recursive_class_list)
                                                 : std::nullopt),
      map_(map ? std::optional<EncodableMap>(*map) : std::nullopt),
      string_map_(string_map ? std::optional<EncodableMap>(*string_map)
                             : std::nullopt),
      int_map_(int_map ? std::optional<EncodableMap>(*int_map) : std::nullopt),
      enum_map_(enum_map ? std::optional<EncodableMap>(*enum_map)
                         : std::nullopt),
      object_map_(object_map ? std::optional<EncodableMap>(*object_map)
                             : std::nullopt),
      list_map_(list_map ? std::optional<EncodableMap>(*list_map)
                         : std::nullopt),
      map_map_(map_map ? std::optional<EncodableMap>(*map_map) : std::nullopt),
      recursive_class_map_(recursive_class_map ? std::optional<EncodableMap>(
                                                     *recursive_class_map)
                                               : std::nullopt) {}

AllNullableTypes::AllNullableTypes(const AllNullableTypes& other)
    : a_nullable_bool_(other.a_nullable_bool_
                           ? std::optional<bool>(*other.a_nullable_bool_)
                           : std::nullopt),
      a_nullable_int_(other.a_nullable_int_
                          ? std::optional<int64_t>(*other.a_nullable_int_)
                          : std::nullopt),
      a_nullable_int64_(other.a_nullable_int64_
                            ? std::optional<int64_t>(*other.a_nullable_int64_)
                            : std::nullopt),
      a_nullable_double_(other.a_nullable_double_
                             ? std::optional<double>(*other.a_nullable_double_)
                             : std::nullopt),
      a_nullable_byte_array_(other.a_nullable_byte_array_
                                 ? std::optional<std::vector<uint8_t>>(
                                       *other.a_nullable_byte_array_)
                                 : std::nullopt),
      a_nullable4_byte_array_(other.a_nullable4_byte_array_
                                  ? std::optional<std::vector<int32_t>>(
                                        *other.a_nullable4_byte_array_)
                                  : std::nullopt),
      a_nullable8_byte_array_(other.a_nullable8_byte_array_
                                  ? std::optional<std::vector<int64_t>>(
                                        *other.a_nullable8_byte_array_)
                                  : std::nullopt),
      a_nullable_float_array_(other.a_nullable_float_array_
                                  ? std::optional<std::vector<double>>(
                                        *other.a_nullable_float_array_)
                                  : std::nullopt),
      a_nullable_enum_(other.a_nullable_enum_
                           ? std::optional<AnEnum>(*other.a_nullable_enum_)
                           : std::nullopt),
      another_nullable_enum_(
          other.another_nullable_enum_
              ? std::optional<AnotherEnum>(*other.another_nullable_enum_)
              : std::nullopt),
      a_nullable_string_(
          other.a_nullable_string_
              ? std::optional<std::string>(*other.a_nullable_string_)
              : std::nullopt),
      a_nullable_object_(
          other.a_nullable_object_
              ? std::optional<EncodableValue>(*other.a_nullable_object_)
              : std::nullopt),
      all_nullable_types_(
          other.all_nullable_types_
              ? std::make_unique<AllNullableTypes>(*other.all_nullable_types_)
              : nullptr),
      list_(other.list_ ? std::optional<EncodableList>(*other.list_)
                        : std::nullopt),
      string_list_(other.string_list_
                       ? std::optional<EncodableList>(*other.string_list_)
                       : std::nullopt),
      int_list_(other.int_list_ ? std::optional<EncodableList>(*other.int_list_)
                                : std::nullopt),
      double_list_(other.double_list_
                       ? std::optional<EncodableList>(*other.double_list_)
                       : std::nullopt),
      bool_list_(other.bool_list_
                     ? std::optional<EncodableList>(*other.bool_list_)
                     : std::nullopt),
      enum_list_(other.enum_list_
                     ? std::optional<EncodableList>(*other.enum_list_)
                     : std::nullopt),
      object_list_(other.object_list_
                       ? std::optional<EncodableList>(*other.object_list_)
                       : std::nullopt),
      list_list_(other.list_list_
                     ? std::optional<EncodableList>(*other.list_list_)
                     : std::nullopt),
      map_list_(other.map_list_ ? std::optional<EncodableList>(*other.map_list_)
                                : std::nullopt),
      recursive_class_list_(
          other.recursive_class_list_
              ? std::optional<EncodableList>(*other.recursive_class_list_)
              : std::nullopt),
      map_(other.map_ ? std::optional<EncodableMap>(*other.map_)
                      : std::nullopt),
      string_map_(other.string_map_
                      ? std::optional<EncodableMap>(*other.string_map_)
                      : std::nullopt),
      int_map_(other.int_map_ ? std::optional<EncodableMap>(*other.int_map_)
                              : std::nullopt),
      enum_map_(other.enum_map_ ? std::optional<EncodableMap>(*other.enum_map_)
                                : std::nullopt),
      object_map_(other.object_map_
                      ? std::optional<EncodableMap>(*other.object_map_)
                      : std::nullopt),
      list_map_(other.list_map_ ? std::optional<EncodableMap>(*other.list_map_)
                                : std::nullopt),
      map_map_(other.map_map_ ? std::optional<EncodableMap>(*other.map_map_)
                              : std::nullopt),
      recursive_class_map_(
          other.recursive_class_map_
              ? std::optional<EncodableMap>(*other.recursive_class_map_)
              : std::nullopt) {}

AllNullableTypes& AllNullableTypes::operator=(const AllNullableTypes& other) {
  a_nullable_bool_ = other.a_nullable_bool_;
  a_nullable_int_ = other.a_nullable_int_;
  a_nullable_int64_ = other.a_nullable_int64_;
  a_nullable_double_ = other.a_nullable_double_;
  a_nullable_byte_array_ = other.a_nullable_byte_array_;
  a_nullable4_byte_array_ = other.a_nullable4_byte_array_;
  a_nullable8_byte_array_ = other.a_nullable8_byte_array_;
  a_nullable_float_array_ = other.a_nullable_float_array_;
  a_nullable_enum_ = other.a_nullable_enum_;
  another_nullable_enum_ = other.another_nullable_enum_;
  a_nullable_string_ = other.a_nullable_string_;
  a_nullable_object_ = other.a_nullable_object_;
  all_nullable_types_ =
      other.all_nullable_types_
          ? std::make_unique<AllNullableTypes>(*other.all_nullable_types_)
          : nullptr;
  list_ = other.list_;
  string_list_ = other.string_list_;
  int_list_ = other.int_list_;
  double_list_ = other.double_list_;
  bool_list_ = other.bool_list_;
  enum_list_ = other.enum_list_;
  object_list_ = other.object_list_;
  list_list_ = other.list_list_;
  map_list_ = other.map_list_;
  recursive_class_list_ = other.recursive_class_list_;
  map_ = other.map_;
  string_map_ = other.string_map_;
  int_map_ = other.int_map_;
  enum_map_ = other.enum_map_;
  object_map_ = other.object_map_;
  list_map_ = other.list_map_;
  map_map_ = other.map_map_;
  recursive_class_map_ = other.recursive_class_map_;
  return *this;
}

const bool* AllNullableTypes::a_nullable_bool() const {
  return a_nullable_bool_ ? &(*a_nullable_bool_) : nullptr;
}

void AllNullableTypes::set_a_nullable_bool(const bool* value_arg) {
  a_nullable_bool_ = value_arg ? std::optional<bool>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_a_nullable_bool(bool value_arg) {
  a_nullable_bool_ = value_arg;
}

const int64_t* AllNullableTypes::a_nullable_int() const {
  return a_nullable_int_ ? &(*a_nullable_int_) : nullptr;
}

void AllNullableTypes::set_a_nullable_int(const int64_t* value_arg) {
  a_nullable_int_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_a_nullable_int(int64_t value_arg) {
  a_nullable_int_ = value_arg;
}

const int64_t* AllNullableTypes::a_nullable_int64() const {
  return a_nullable_int64_ ? &(*a_nullable_int64_) : nullptr;
}

void AllNullableTypes::set_a_nullable_int64(const int64_t* value_arg) {
  a_nullable_int64_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_a_nullable_int64(int64_t value_arg) {
  a_nullable_int64_ = value_arg;
}

const double* AllNullableTypes::a_nullable_double() const {
  return a_nullable_double_ ? &(*a_nullable_double_) : nullptr;
}

void AllNullableTypes::set_a_nullable_double(const double* value_arg) {
  a_nullable_double_ =
      value_arg ? std::optional<double>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_a_nullable_double(double value_arg) {
  a_nullable_double_ = value_arg;
}

const std::vector<uint8_t>* AllNullableTypes::a_nullable_byte_array() const {
  return a_nullable_byte_array_ ? &(*a_nullable_byte_array_) : nullptr;
}

void AllNullableTypes::set_a_nullable_byte_array(
    const std::vector<uint8_t>* value_arg) {
  a_nullable_byte_array_ = value_arg
                               ? std::optional<std::vector<uint8_t>>(*value_arg)
                               : std::nullopt;
}

void AllNullableTypes::set_a_nullable_byte_array(
    const std::vector<uint8_t>& value_arg) {
  a_nullable_byte_array_ = value_arg;
}

const std::vector<int32_t>* AllNullableTypes::a_nullable4_byte_array() const {
  return a_nullable4_byte_array_ ? &(*a_nullable4_byte_array_) : nullptr;
}

void AllNullableTypes::set_a_nullable4_byte_array(
    const std::vector<int32_t>* value_arg) {
  a_nullable4_byte_array_ =
      value_arg ? std::optional<std::vector<int32_t>>(*value_arg)
                : std::nullopt;
}

void AllNullableTypes::set_a_nullable4_byte_array(
    const std::vector<int32_t>& value_arg) {
  a_nullable4_byte_array_ = value_arg;
}

const std::vector<int64_t>* AllNullableTypes::a_nullable8_byte_array() const {
  return a_nullable8_byte_array_ ? &(*a_nullable8_byte_array_) : nullptr;
}

void AllNullableTypes::set_a_nullable8_byte_array(
    const std::vector<int64_t>* value_arg) {
  a_nullable8_byte_array_ =
      value_arg ? std::optional<std::vector<int64_t>>(*value_arg)
                : std::nullopt;
}

void AllNullableTypes::set_a_nullable8_byte_array(
    const std::vector<int64_t>& value_arg) {
  a_nullable8_byte_array_ = value_arg;
}

const std::vector<double>* AllNullableTypes::a_nullable_float_array() const {
  return a_nullable_float_array_ ? &(*a_nullable_float_array_) : nullptr;
}

void AllNullableTypes::set_a_nullable_float_array(
    const std::vector<double>* value_arg) {
  a_nullable_float_array_ =
      value_arg ? std::optional<std::vector<double>>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_a_nullable_float_array(
    const std::vector<double>& value_arg) {
  a_nullable_float_array_ = value_arg;
}

const AnEnum* AllNullableTypes::a_nullable_enum() const {
  return a_nullable_enum_ ? &(*a_nullable_enum_) : nullptr;
}

void AllNullableTypes::set_a_nullable_enum(const AnEnum* value_arg) {
  a_nullable_enum_ =
      value_arg ? std::optional<AnEnum>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_a_nullable_enum(const AnEnum& value_arg) {
  a_nullable_enum_ = value_arg;
}

const AnotherEnum* AllNullableTypes::another_nullable_enum() const {
  return another_nullable_enum_ ? &(*another_nullable_enum_) : nullptr;
}

void AllNullableTypes::set_another_nullable_enum(const AnotherEnum* value_arg) {
  another_nullable_enum_ =
      value_arg ? std::optional<AnotherEnum>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_another_nullable_enum(const AnotherEnum& value_arg) {
  another_nullable_enum_ = value_arg;
}

const std::string* AllNullableTypes::a_nullable_string() const {
  return a_nullable_string_ ? &(*a_nullable_string_) : nullptr;
}

void AllNullableTypes::set_a_nullable_string(
    const std::string_view* value_arg) {
  a_nullable_string_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_a_nullable_string(std::string_view value_arg) {
  a_nullable_string_ = value_arg;
}

const EncodableValue* AllNullableTypes::a_nullable_object() const {
  return a_nullable_object_ ? &(*a_nullable_object_) : nullptr;
}

void AllNullableTypes::set_a_nullable_object(const EncodableValue* value_arg) {
  a_nullable_object_ =
      value_arg ? std::optional<EncodableValue>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_a_nullable_object(const EncodableValue& value_arg) {
  a_nullable_object_ = value_arg;
}

const AllNullableTypes* AllNullableTypes::all_nullable_types() const {
  return all_nullable_types_.get();
}

void AllNullableTypes::set_all_nullable_types(
    const AllNullableTypes* value_arg) {
  all_nullable_types_ =
      value_arg ? std::make_unique<AllNullableTypes>(*value_arg) : nullptr;
}

void AllNullableTypes::set_all_nullable_types(
    const AllNullableTypes& value_arg) {
  all_nullable_types_ = std::make_unique<AllNullableTypes>(value_arg);
}

const EncodableList* AllNullableTypes::list() const {
  return list_ ? &(*list_) : nullptr;
}

void AllNullableTypes::set_list(const EncodableList* value_arg) {
  list_ = value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_list(const EncodableList& value_arg) {
  list_ = value_arg;
}

const EncodableList* AllNullableTypes::string_list() const {
  return string_list_ ? &(*string_list_) : nullptr;
}

void AllNullableTypes::set_string_list(const EncodableList* value_arg) {
  string_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_string_list(const EncodableList& value_arg) {
  string_list_ = value_arg;
}

const EncodableList* AllNullableTypes::int_list() const {
  return int_list_ ? &(*int_list_) : nullptr;
}

void AllNullableTypes::set_int_list(const EncodableList* value_arg) {
  int_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_int_list(const EncodableList& value_arg) {
  int_list_ = value_arg;
}

const EncodableList* AllNullableTypes::double_list() const {
  return double_list_ ? &(*double_list_) : nullptr;
}

void AllNullableTypes::set_double_list(const EncodableList* value_arg) {
  double_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_double_list(const EncodableList& value_arg) {
  double_list_ = value_arg;
}

const EncodableList* AllNullableTypes::bool_list() const {
  return bool_list_ ? &(*bool_list_) : nullptr;
}

void AllNullableTypes::set_bool_list(const EncodableList* value_arg) {
  bool_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_bool_list(const EncodableList& value_arg) {
  bool_list_ = value_arg;
}

const EncodableList* AllNullableTypes::enum_list() const {
  return enum_list_ ? &(*enum_list_) : nullptr;
}

void AllNullableTypes::set_enum_list(const EncodableList* value_arg) {
  enum_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_enum_list(const EncodableList& value_arg) {
  enum_list_ = value_arg;
}

const EncodableList* AllNullableTypes::object_list() const {
  return object_list_ ? &(*object_list_) : nullptr;
}

void AllNullableTypes::set_object_list(const EncodableList* value_arg) {
  object_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_object_list(const EncodableList& value_arg) {
  object_list_ = value_arg;
}

const EncodableList* AllNullableTypes::list_list() const {
  return list_list_ ? &(*list_list_) : nullptr;
}

void AllNullableTypes::set_list_list(const EncodableList* value_arg) {
  list_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_list_list(const EncodableList& value_arg) {
  list_list_ = value_arg;
}

const EncodableList* AllNullableTypes::map_list() const {
  return map_list_ ? &(*map_list_) : nullptr;
}

void AllNullableTypes::set_map_list(const EncodableList* value_arg) {
  map_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_map_list(const EncodableList& value_arg) {
  map_list_ = value_arg;
}

const EncodableList* AllNullableTypes::recursive_class_list() const {
  return recursive_class_list_ ? &(*recursive_class_list_) : nullptr;
}

void AllNullableTypes::set_recursive_class_list(
    const EncodableList* value_arg) {
  recursive_class_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_recursive_class_list(
    const EncodableList& value_arg) {
  recursive_class_list_ = value_arg;
}

const EncodableMap* AllNullableTypes::map() const {
  return map_ ? &(*map_) : nullptr;
}

void AllNullableTypes::set_map(const EncodableMap* value_arg) {
  map_ = value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_map(const EncodableMap& value_arg) {
  map_ = value_arg;
}

const EncodableMap* AllNullableTypes::string_map() const {
  return string_map_ ? &(*string_map_) : nullptr;
}

void AllNullableTypes::set_string_map(const EncodableMap* value_arg) {
  string_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_string_map(const EncodableMap& value_arg) {
  string_map_ = value_arg;
}

const EncodableMap* AllNullableTypes::int_map() const {
  return int_map_ ? &(*int_map_) : nullptr;
}

void AllNullableTypes::set_int_map(const EncodableMap* value_arg) {
  int_map_ = value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_int_map(const EncodableMap& value_arg) {
  int_map_ = value_arg;
}

const EncodableMap* AllNullableTypes::enum_map() const {
  return enum_map_ ? &(*enum_map_) : nullptr;
}

void AllNullableTypes::set_enum_map(const EncodableMap* value_arg) {
  enum_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_enum_map(const EncodableMap& value_arg) {
  enum_map_ = value_arg;
}

const EncodableMap* AllNullableTypes::object_map() const {
  return object_map_ ? &(*object_map_) : nullptr;
}

void AllNullableTypes::set_object_map(const EncodableMap* value_arg) {
  object_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_object_map(const EncodableMap& value_arg) {
  object_map_ = value_arg;
}

const EncodableMap* AllNullableTypes::list_map() const {
  return list_map_ ? &(*list_map_) : nullptr;
}

void AllNullableTypes::set_list_map(const EncodableMap* value_arg) {
  list_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_list_map(const EncodableMap& value_arg) {
  list_map_ = value_arg;
}

const EncodableMap* AllNullableTypes::map_map() const {
  return map_map_ ? &(*map_map_) : nullptr;
}

void AllNullableTypes::set_map_map(const EncodableMap* value_arg) {
  map_map_ = value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_map_map(const EncodableMap& value_arg) {
  map_map_ = value_arg;
}

const EncodableMap* AllNullableTypes::recursive_class_map() const {
  return recursive_class_map_ ? &(*recursive_class_map_) : nullptr;
}

void AllNullableTypes::set_recursive_class_map(const EncodableMap* value_arg) {
  recursive_class_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypes::set_recursive_class_map(const EncodableMap& value_arg) {
  recursive_class_map_ = value_arg;
}

EncodableList AllNullableTypes::ToEncodableList() const {
  EncodableList list;
  list.reserve(31);
  list.push_back(a_nullable_bool_ ? EncodableValue(*a_nullable_bool_)
                                  : EncodableValue());
  list.push_back(a_nullable_int_ ? EncodableValue(*a_nullable_int_)
                                 : EncodableValue());
  list.push_back(a_nullable_int64_ ? EncodableValue(*a_nullable_int64_)
                                   : EncodableValue());
  list.push_back(a_nullable_double_ ? EncodableValue(*a_nullable_double_)
                                    : EncodableValue());
  list.push_back(a_nullable_byte_array_
                     ? EncodableValue(*a_nullable_byte_array_)
                     : EncodableValue());
  list.push_back(a_nullable4_byte_array_
                     ? EncodableValue(*a_nullable4_byte_array_)
                     : EncodableValue());
  list.push_back(a_nullable8_byte_array_
                     ? EncodableValue(*a_nullable8_byte_array_)
                     : EncodableValue());
  list.push_back(a_nullable_float_array_
                     ? EncodableValue(*a_nullable_float_array_)
                     : EncodableValue());
  list.push_back(a_nullable_enum_ ? CustomEncodableValue(*a_nullable_enum_)
                                  : EncodableValue());
  list.push_back(another_nullable_enum_
                     ? CustomEncodableValue(*another_nullable_enum_)
                     : EncodableValue());
  list.push_back(a_nullable_string_ ? EncodableValue(*a_nullable_string_)
                                    : EncodableValue());
  list.push_back(a_nullable_object_ ? *a_nullable_object_ : EncodableValue());
  list.push_back(all_nullable_types_
                     ? CustomEncodableValue(*all_nullable_types_)
                     : EncodableValue());
  list.push_back(list_ ? EncodableValue(*list_) : EncodableValue());
  list.push_back(string_list_ ? EncodableValue(*string_list_)
                              : EncodableValue());
  list.push_back(int_list_ ? EncodableValue(*int_list_) : EncodableValue());
  list.push_back(double_list_ ? EncodableValue(*double_list_)
                              : EncodableValue());
  list.push_back(bool_list_ ? EncodableValue(*bool_list_) : EncodableValue());
  list.push_back(enum_list_ ? EncodableValue(*enum_list_) : EncodableValue());
  list.push_back(object_list_ ? EncodableValue(*object_list_)
                              : EncodableValue());
  list.push_back(list_list_ ? EncodableValue(*list_list_) : EncodableValue());
  list.push_back(map_list_ ? EncodableValue(*map_list_) : EncodableValue());
  list.push_back(recursive_class_list_ ? EncodableValue(*recursive_class_list_)
                                       : EncodableValue());
  list.push_back(map_ ? EncodableValue(*map_) : EncodableValue());
  list.push_back(string_map_ ? EncodableValue(*string_map_) : EncodableValue());
  list.push_back(int_map_ ? EncodableValue(*int_map_) : EncodableValue());
  list.push_back(enum_map_ ? EncodableValue(*enum_map_) : EncodableValue());
  list.push_back(object_map_ ? EncodableValue(*object_map_) : EncodableValue());
  list.push_back(list_map_ ? EncodableValue(*list_map_) : EncodableValue());
  list.push_back(map_map_ ? EncodableValue(*map_map_) : EncodableValue());
  list.push_back(recursive_class_map_ ? EncodableValue(*recursive_class_map_)
                                      : EncodableValue());
  return list;
}

AllNullableTypes AllNullableTypes::FromEncodableList(
    const EncodableList& list) {
  AllNullableTypes decoded;
  auto& encodable_a_nullable_bool = list[0];
  if (!encodable_a_nullable_bool.IsNull()) {
    decoded.set_a_nullable_bool(std::get<bool>(encodable_a_nullable_bool));
  }
  auto& encodable_a_nullable_int = list[1];
  if (!encodable_a_nullable_int.IsNull()) {
    decoded.set_a_nullable_int(std::get<int64_t>(encodable_a_nullable_int));
  }
  auto& encodable_a_nullable_int64 = list[2];
  if (!encodable_a_nullable_int64.IsNull()) {
    decoded.set_a_nullable_int64(std::get<int64_t>(encodable_a_nullable_int64));
  }
  auto& encodable_a_nullable_double = list[3];
  if (!encodable_a_nullable_double.IsNull()) {
    decoded.set_a_nullable_double(
        std::get<double>(encodable_a_nullable_double));
  }
  auto& encodable_a_nullable_byte_array = list[4];
  if (!encodable_a_nullable_byte_array.IsNull()) {
    decoded.set_a_nullable_byte_array(
        std::get<std::vector<uint8_t>>(encodable_a_nullable_byte_array));
  }
  auto& encodable_a_nullable4_byte_array = list[5];
  if (!encodable_a_nullable4_byte_array.IsNull()) {
    decoded.set_a_nullable4_byte_array(
        std::get<std::vector<int32_t>>(encodable_a_nullable4_byte_array));
  }
  auto& encodable_a_nullable8_byte_array = list[6];
  if (!encodable_a_nullable8_byte_array.IsNull()) {
    decoded.set_a_nullable8_byte_array(
        std::get<std::vector<int64_t>>(encodable_a_nullable8_byte_array));
  }
  auto& encodable_a_nullable_float_array = list[7];
  if (!encodable_a_nullable_float_array.IsNull()) {
    decoded.set_a_nullable_float_array(
        std::get<std::vector<double>>(encodable_a_nullable_float_array));
  }
  auto& encodable_a_nullable_enum = list[8];
  if (!encodable_a_nullable_enum.IsNull()) {
    decoded.set_a_nullable_enum(std::any_cast<const AnEnum&>(
        std::get<CustomEncodableValue>(encodable_a_nullable_enum)));
  }
  auto& encodable_another_nullable_enum = list[9];
  if (!encodable_another_nullable_enum.IsNull()) {
    decoded.set_another_nullable_enum(std::any_cast<const AnotherEnum&>(
        std::get<CustomEncodableValue>(encodable_another_nullable_enum)));
  }
  auto& encodable_a_nullable_string = list[10];
  if (!encodable_a_nullable_string.IsNull()) {
    decoded.set_a_nullable_string(
        std::get<std::string>(encodable_a_nullable_string));
  }
  auto& encodable_a_nullable_object = list[11];
  if (!encodable_a_nullable_object.IsNull()) {
    decoded.set_a_nullable_object(encodable_a_nullable_object);
  }
  auto& encodable_all_nullable_types = list[12];
  if (!encodable_all_nullable_types.IsNull()) {
    decoded.set_all_nullable_types(std::any_cast<const AllNullableTypes&>(
        std::get<CustomEncodableValue>(encodable_all_nullable_types)));
  }
  auto& encodable_list = list[13];
  if (!encodable_list.IsNull()) {
    decoded.set_list(std::get<EncodableList>(encodable_list));
  }
  auto& encodable_string_list = list[14];
  if (!encodable_string_list.IsNull()) {
    decoded.set_string_list(std::get<EncodableList>(encodable_string_list));
  }
  auto& encodable_int_list = list[15];
  if (!encodable_int_list.IsNull()) {
    decoded.set_int_list(std::get<EncodableList>(encodable_int_list));
  }
  auto& encodable_double_list = list[16];
  if (!encodable_double_list.IsNull()) {
    decoded.set_double_list(std::get<EncodableList>(encodable_double_list));
  }
  auto& encodable_bool_list = list[17];
  if (!encodable_bool_list.IsNull()) {
    decoded.set_bool_list(std::get<EncodableList>(encodable_bool_list));
  }
  auto& encodable_enum_list = list[18];
  if (!encodable_enum_list.IsNull()) {
    decoded.set_enum_list(std::get<EncodableList>(encodable_enum_list));
  }
  auto& encodable_object_list = list[19];
  if (!encodable_object_list.IsNull()) {
    decoded.set_object_list(std::get<EncodableList>(encodable_object_list));
  }
  auto& encodable_list_list = list[20];
  if (!encodable_list_list.IsNull()) {
    decoded.set_list_list(std::get<EncodableList>(encodable_list_list));
  }
  auto& encodable_map_list = list[21];
  if (!encodable_map_list.IsNull()) {
    decoded.set_map_list(std::get<EncodableList>(encodable_map_list));
  }
  auto& encodable_recursive_class_list = list[22];
  if (!encodable_recursive_class_list.IsNull()) {
    decoded.set_recursive_class_list(
        std::get<EncodableList>(encodable_recursive_class_list));
  }
  auto& encodable_map = list[23];
  if (!encodable_map.IsNull()) {
    decoded.set_map(std::get<EncodableMap>(encodable_map));
  }
  auto& encodable_string_map = list[24];
  if (!encodable_string_map.IsNull()) {
    decoded.set_string_map(std::get<EncodableMap>(encodable_string_map));
  }
  auto& encodable_int_map = list[25];
  if (!encodable_int_map.IsNull()) {
    decoded.set_int_map(std::get<EncodableMap>(encodable_int_map));
  }
  auto& encodable_enum_map = list[26];
  if (!encodable_enum_map.IsNull()) {
    decoded.set_enum_map(std::get<EncodableMap>(encodable_enum_map));
  }
  auto& encodable_object_map = list[27];
  if (!encodable_object_map.IsNull()) {
    decoded.set_object_map(std::get<EncodableMap>(encodable_object_map));
  }
  auto& encodable_list_map = list[28];
  if (!encodable_list_map.IsNull()) {
    decoded.set_list_map(std::get<EncodableMap>(encodable_list_map));
  }
  auto& encodable_map_map = list[29];
  if (!encodable_map_map.IsNull()) {
    decoded.set_map_map(std::get<EncodableMap>(encodable_map_map));
  }
  auto& encodable_recursive_class_map = list[30];
  if (!encodable_recursive_class_map.IsNull()) {
    decoded.set_recursive_class_map(
        std::get<EncodableMap>(encodable_recursive_class_map));
  }
  return decoded;
}

// AllNullableTypesWithoutRecursion

AllNullableTypesWithoutRecursion::AllNullableTypesWithoutRecursion() {}

AllNullableTypesWithoutRecursion::AllNullableTypesWithoutRecursion(
    const bool* a_nullable_bool, const int64_t* a_nullable_int,
    const int64_t* a_nullable_int64, const double* a_nullable_double,
    const std::vector<uint8_t>* a_nullable_byte_array,
    const std::vector<int32_t>* a_nullable4_byte_array,
    const std::vector<int64_t>* a_nullable8_byte_array,
    const std::vector<double>* a_nullable_float_array,
    const AnEnum* a_nullable_enum, const AnotherEnum* another_nullable_enum,
    const std::string* a_nullable_string,
    const EncodableValue* a_nullable_object, const EncodableList* list,
    const EncodableList* string_list, const EncodableList* int_list,
    const EncodableList* double_list, const EncodableList* bool_list,
    const EncodableList* enum_list, const EncodableList* object_list,
    const EncodableList* list_list, const EncodableList* map_list,
    const EncodableMap* map, const EncodableMap* string_map,
    const EncodableMap* int_map, const EncodableMap* enum_map,
    const EncodableMap* object_map, const EncodableMap* list_map,
    const EncodableMap* map_map)
    : a_nullable_bool_(a_nullable_bool ? std::optional<bool>(*a_nullable_bool)
                                       : std::nullopt),
      a_nullable_int_(a_nullable_int ? std::optional<int64_t>(*a_nullable_int)
                                     : std::nullopt),
      a_nullable_int64_(a_nullable_int64
                            ? std::optional<int64_t>(*a_nullable_int64)
                            : std::nullopt),
      a_nullable_double_(a_nullable_double
                             ? std::optional<double>(*a_nullable_double)
                             : std::nullopt),
      a_nullable_byte_array_(
          a_nullable_byte_array
              ? std::optional<std::vector<uint8_t>>(*a_nullable_byte_array)
              : std::nullopt),
      a_nullable4_byte_array_(
          a_nullable4_byte_array
              ? std::optional<std::vector<int32_t>>(*a_nullable4_byte_array)
              : std::nullopt),
      a_nullable8_byte_array_(
          a_nullable8_byte_array
              ? std::optional<std::vector<int64_t>>(*a_nullable8_byte_array)
              : std::nullopt),
      a_nullable_float_array_(
          a_nullable_float_array
              ? std::optional<std::vector<double>>(*a_nullable_float_array)
              : std::nullopt),
      a_nullable_enum_(a_nullable_enum ? std::optional<AnEnum>(*a_nullable_enum)
                                       : std::nullopt),
      another_nullable_enum_(another_nullable_enum ? std::optional<AnotherEnum>(
                                                         *another_nullable_enum)
                                                   : std::nullopt),
      a_nullable_string_(a_nullable_string
                             ? std::optional<std::string>(*a_nullable_string)
                             : std::nullopt),
      a_nullable_object_(a_nullable_object
                             ? std::optional<EncodableValue>(*a_nullable_object)
                             : std::nullopt),
      list_(list ? std::optional<EncodableList>(*list) : std::nullopt),
      string_list_(string_list ? std::optional<EncodableList>(*string_list)
                               : std::nullopt),
      int_list_(int_list ? std::optional<EncodableList>(*int_list)
                         : std::nullopt),
      double_list_(double_list ? std::optional<EncodableList>(*double_list)
                               : std::nullopt),
      bool_list_(bool_list ? std::optional<EncodableList>(*bool_list)
                           : std::nullopt),
      enum_list_(enum_list ? std::optional<EncodableList>(*enum_list)
                           : std::nullopt),
      object_list_(object_list ? std::optional<EncodableList>(*object_list)
                               : std::nullopt),
      list_list_(list_list ? std::optional<EncodableList>(*list_list)
                           : std::nullopt),
      map_list_(map_list ? std::optional<EncodableList>(*map_list)
                         : std::nullopt),
      map_(map ? std::optional<EncodableMap>(*map) : std::nullopt),
      string_map_(string_map ? std::optional<EncodableMap>(*string_map)
                             : std::nullopt),
      int_map_(int_map ? std::optional<EncodableMap>(*int_map) : std::nullopt),
      enum_map_(enum_map ? std::optional<EncodableMap>(*enum_map)
                         : std::nullopt),
      object_map_(object_map ? std::optional<EncodableMap>(*object_map)
                             : std::nullopt),
      list_map_(list_map ? std::optional<EncodableMap>(*list_map)
                         : std::nullopt),
      map_map_(map_map ? std::optional<EncodableMap>(*map_map) : std::nullopt) {
}

const bool* AllNullableTypesWithoutRecursion::a_nullable_bool() const {
  return a_nullable_bool_ ? &(*a_nullable_bool_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_bool(
    const bool* value_arg) {
  a_nullable_bool_ = value_arg ? std::optional<bool>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_bool(bool value_arg) {
  a_nullable_bool_ = value_arg;
}

const int64_t* AllNullableTypesWithoutRecursion::a_nullable_int() const {
  return a_nullable_int_ ? &(*a_nullable_int_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_int(
    const int64_t* value_arg) {
  a_nullable_int_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_int(int64_t value_arg) {
  a_nullable_int_ = value_arg;
}

const int64_t* AllNullableTypesWithoutRecursion::a_nullable_int64() const {
  return a_nullable_int64_ ? &(*a_nullable_int64_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_int64(
    const int64_t* value_arg) {
  a_nullable_int64_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_int64(int64_t value_arg) {
  a_nullable_int64_ = value_arg;
}

const double* AllNullableTypesWithoutRecursion::a_nullable_double() const {
  return a_nullable_double_ ? &(*a_nullable_double_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_double(
    const double* value_arg) {
  a_nullable_double_ =
      value_arg ? std::optional<double>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_double(double value_arg) {
  a_nullable_double_ = value_arg;
}

const std::vector<uint8_t>*
AllNullableTypesWithoutRecursion::a_nullable_byte_array() const {
  return a_nullable_byte_array_ ? &(*a_nullable_byte_array_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_byte_array(
    const std::vector<uint8_t>* value_arg) {
  a_nullable_byte_array_ = value_arg
                               ? std::optional<std::vector<uint8_t>>(*value_arg)
                               : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_byte_array(
    const std::vector<uint8_t>& value_arg) {
  a_nullable_byte_array_ = value_arg;
}

const std::vector<int32_t>*
AllNullableTypesWithoutRecursion::a_nullable4_byte_array() const {
  return a_nullable4_byte_array_ ? &(*a_nullable4_byte_array_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable4_byte_array(
    const std::vector<int32_t>* value_arg) {
  a_nullable4_byte_array_ =
      value_arg ? std::optional<std::vector<int32_t>>(*value_arg)
                : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable4_byte_array(
    const std::vector<int32_t>& value_arg) {
  a_nullable4_byte_array_ = value_arg;
}

const std::vector<int64_t>*
AllNullableTypesWithoutRecursion::a_nullable8_byte_array() const {
  return a_nullable8_byte_array_ ? &(*a_nullable8_byte_array_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable8_byte_array(
    const std::vector<int64_t>* value_arg) {
  a_nullable8_byte_array_ =
      value_arg ? std::optional<std::vector<int64_t>>(*value_arg)
                : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable8_byte_array(
    const std::vector<int64_t>& value_arg) {
  a_nullable8_byte_array_ = value_arg;
}

const std::vector<double>*
AllNullableTypesWithoutRecursion::a_nullable_float_array() const {
  return a_nullable_float_array_ ? &(*a_nullable_float_array_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_float_array(
    const std::vector<double>* value_arg) {
  a_nullable_float_array_ =
      value_arg ? std::optional<std::vector<double>>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_float_array(
    const std::vector<double>& value_arg) {
  a_nullable_float_array_ = value_arg;
}

const AnEnum* AllNullableTypesWithoutRecursion::a_nullable_enum() const {
  return a_nullable_enum_ ? &(*a_nullable_enum_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_enum(
    const AnEnum* value_arg) {
  a_nullable_enum_ =
      value_arg ? std::optional<AnEnum>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_enum(
    const AnEnum& value_arg) {
  a_nullable_enum_ = value_arg;
}

const AnotherEnum* AllNullableTypesWithoutRecursion::another_nullable_enum()
    const {
  return another_nullable_enum_ ? &(*another_nullable_enum_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_another_nullable_enum(
    const AnotherEnum* value_arg) {
  another_nullable_enum_ =
      value_arg ? std::optional<AnotherEnum>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_another_nullable_enum(
    const AnotherEnum& value_arg) {
  another_nullable_enum_ = value_arg;
}

const std::string* AllNullableTypesWithoutRecursion::a_nullable_string() const {
  return a_nullable_string_ ? &(*a_nullable_string_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_string(
    const std::string_view* value_arg) {
  a_nullable_string_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_string(
    std::string_view value_arg) {
  a_nullable_string_ = value_arg;
}

const EncodableValue* AllNullableTypesWithoutRecursion::a_nullable_object()
    const {
  return a_nullable_object_ ? &(*a_nullable_object_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_object(
    const EncodableValue* value_arg) {
  a_nullable_object_ =
      value_arg ? std::optional<EncodableValue>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_a_nullable_object(
    const EncodableValue& value_arg) {
  a_nullable_object_ = value_arg;
}

const EncodableList* AllNullableTypesWithoutRecursion::list() const {
  return list_ ? &(*list_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_list(
    const EncodableList* value_arg) {
  list_ = value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_list(
    const EncodableList& value_arg) {
  list_ = value_arg;
}

const EncodableList* AllNullableTypesWithoutRecursion::string_list() const {
  return string_list_ ? &(*string_list_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_string_list(
    const EncodableList* value_arg) {
  string_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_string_list(
    const EncodableList& value_arg) {
  string_list_ = value_arg;
}

const EncodableList* AllNullableTypesWithoutRecursion::int_list() const {
  return int_list_ ? &(*int_list_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_int_list(
    const EncodableList* value_arg) {
  int_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_int_list(
    const EncodableList& value_arg) {
  int_list_ = value_arg;
}

const EncodableList* AllNullableTypesWithoutRecursion::double_list() const {
  return double_list_ ? &(*double_list_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_double_list(
    const EncodableList* value_arg) {
  double_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_double_list(
    const EncodableList& value_arg) {
  double_list_ = value_arg;
}

const EncodableList* AllNullableTypesWithoutRecursion::bool_list() const {
  return bool_list_ ? &(*bool_list_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_bool_list(
    const EncodableList* value_arg) {
  bool_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_bool_list(
    const EncodableList& value_arg) {
  bool_list_ = value_arg;
}

const EncodableList* AllNullableTypesWithoutRecursion::enum_list() const {
  return enum_list_ ? &(*enum_list_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_enum_list(
    const EncodableList* value_arg) {
  enum_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_enum_list(
    const EncodableList& value_arg) {
  enum_list_ = value_arg;
}

const EncodableList* AllNullableTypesWithoutRecursion::object_list() const {
  return object_list_ ? &(*object_list_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_object_list(
    const EncodableList* value_arg) {
  object_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_object_list(
    const EncodableList& value_arg) {
  object_list_ = value_arg;
}

const EncodableList* AllNullableTypesWithoutRecursion::list_list() const {
  return list_list_ ? &(*list_list_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_list_list(
    const EncodableList* value_arg) {
  list_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_list_list(
    const EncodableList& value_arg) {
  list_list_ = value_arg;
}

const EncodableList* AllNullableTypesWithoutRecursion::map_list() const {
  return map_list_ ? &(*map_list_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_map_list(
    const EncodableList* value_arg) {
  map_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_map_list(
    const EncodableList& value_arg) {
  map_list_ = value_arg;
}

const EncodableMap* AllNullableTypesWithoutRecursion::map() const {
  return map_ ? &(*map_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_map(const EncodableMap* value_arg) {
  map_ = value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_map(const EncodableMap& value_arg) {
  map_ = value_arg;
}

const EncodableMap* AllNullableTypesWithoutRecursion::string_map() const {
  return string_map_ ? &(*string_map_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_string_map(
    const EncodableMap* value_arg) {
  string_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_string_map(
    const EncodableMap& value_arg) {
  string_map_ = value_arg;
}

const EncodableMap* AllNullableTypesWithoutRecursion::int_map() const {
  return int_map_ ? &(*int_map_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_int_map(
    const EncodableMap* value_arg) {
  int_map_ = value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_int_map(
    const EncodableMap& value_arg) {
  int_map_ = value_arg;
}

const EncodableMap* AllNullableTypesWithoutRecursion::enum_map() const {
  return enum_map_ ? &(*enum_map_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_enum_map(
    const EncodableMap* value_arg) {
  enum_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_enum_map(
    const EncodableMap& value_arg) {
  enum_map_ = value_arg;
}

const EncodableMap* AllNullableTypesWithoutRecursion::object_map() const {
  return object_map_ ? &(*object_map_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_object_map(
    const EncodableMap* value_arg) {
  object_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_object_map(
    const EncodableMap& value_arg) {
  object_map_ = value_arg;
}

const EncodableMap* AllNullableTypesWithoutRecursion::list_map() const {
  return list_map_ ? &(*list_map_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_list_map(
    const EncodableMap* value_arg) {
  list_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_list_map(
    const EncodableMap& value_arg) {
  list_map_ = value_arg;
}

const EncodableMap* AllNullableTypesWithoutRecursion::map_map() const {
  return map_map_ ? &(*map_map_) : nullptr;
}

void AllNullableTypesWithoutRecursion::set_map_map(
    const EncodableMap* value_arg) {
  map_map_ = value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllNullableTypesWithoutRecursion::set_map_map(
    const EncodableMap& value_arg) {
  map_map_ = value_arg;
}

EncodableList AllNullableTypesWithoutRecursion::ToEncodableList() const {
  EncodableList list;
  list.reserve(28);
  list.push_back(a_nullable_bool_ ? EncodableValue(*a_nullable_bool_)
                                  : EncodableValue());
  list.push_back(a_nullable_int_ ? EncodableValue(*a_nullable_int_)
                                 : EncodableValue());
  list.push_back(a_nullable_int64_ ? EncodableValue(*a_nullable_int64_)
                                   : EncodableValue());
  list.push_back(a_nullable_double_ ? EncodableValue(*a_nullable_double_)
                                    : EncodableValue());
  list.push_back(a_nullable_byte_array_
                     ? EncodableValue(*a_nullable_byte_array_)
                     : EncodableValue());
  list.push_back(a_nullable4_byte_array_
                     ? EncodableValue(*a_nullable4_byte_array_)
                     : EncodableValue());
  list.push_back(a_nullable8_byte_array_
                     ? EncodableValue(*a_nullable8_byte_array_)
                     : EncodableValue());
  list.push_back(a_nullable_float_array_
                     ? EncodableValue(*a_nullable_float_array_)
                     : EncodableValue());
  list.push_back(a_nullable_enum_ ? CustomEncodableValue(*a_nullable_enum_)
                                  : EncodableValue());
  list.push_back(another_nullable_enum_
                     ? CustomEncodableValue(*another_nullable_enum_)
                     : EncodableValue());
  list.push_back(a_nullable_string_ ? EncodableValue(*a_nullable_string_)
                                    : EncodableValue());
  list.push_back(a_nullable_object_ ? *a_nullable_object_ : EncodableValue());
  list.push_back(list_ ? EncodableValue(*list_) : EncodableValue());
  list.push_back(string_list_ ? EncodableValue(*string_list_)
                              : EncodableValue());
  list.push_back(int_list_ ? EncodableValue(*int_list_) : EncodableValue());
  list.push_back(double_list_ ? EncodableValue(*double_list_)
                              : EncodableValue());
  list.push_back(bool_list_ ? EncodableValue(*bool_list_) : EncodableValue());
  list.push_back(enum_list_ ? EncodableValue(*enum_list_) : EncodableValue());
  list.push_back(object_list_ ? EncodableValue(*object_list_)
                              : EncodableValue());
  list.push_back(list_list_ ? EncodableValue(*list_list_) : EncodableValue());
  list.push_back(map_list_ ? EncodableValue(*map_list_) : EncodableValue());
  list.push_back(map_ ? EncodableValue(*map_) : EncodableValue());
  list.push_back(string_map_ ? EncodableValue(*string_map_) : EncodableValue());
  list.push_back(int_map_ ? EncodableValue(*int_map_) : EncodableValue());
  list.push_back(enum_map_ ? EncodableValue(*enum_map_) : EncodableValue());
  list.push_back(object_map_ ? EncodableValue(*object_map_) : EncodableValue());
  list.push_back(list_map_ ? EncodableValue(*list_map_) : EncodableValue());
  list.push_back(map_map_ ? EncodableValue(*map_map_) : EncodableValue());
  return list;
}

AllNullableTypesWithoutRecursion
AllNullableTypesWithoutRecursion::FromEncodableList(const EncodableList& list) {
  AllNullableTypesWithoutRecursion decoded;
  auto& encodable_a_nullable_bool = list[0];
  if (!encodable_a_nullable_bool.IsNull()) {
    decoded.set_a_nullable_bool(std::get<bool>(encodable_a_nullable_bool));
  }
  auto& encodable_a_nullable_int = list[1];
  if (!encodable_a_nullable_int.IsNull()) {
    decoded.set_a_nullable_int(std::get<int64_t>(encodable_a_nullable_int));
  }
  auto& encodable_a_nullable_int64 = list[2];
  if (!encodable_a_nullable_int64.IsNull()) {
    decoded.set_a_nullable_int64(std::get<int64_t>(encodable_a_nullable_int64));
  }
  auto& encodable_a_nullable_double = list[3];
  if (!encodable_a_nullable_double.IsNull()) {
    decoded.set_a_nullable_double(
        std::get<double>(encodable_a_nullable_double));
  }
  auto& encodable_a_nullable_byte_array = list[4];
  if (!encodable_a_nullable_byte_array.IsNull()) {
    decoded.set_a_nullable_byte_array(
        std::get<std::vector<uint8_t>>(encodable_a_nullable_byte_array));
  }
  auto& encodable_a_nullable4_byte_array = list[5];
  if (!encodable_a_nullable4_byte_array.IsNull()) {
    decoded.set_a_nullable4_byte_array(
        std::get<std::vector<int32_t>>(encodable_a_nullable4_byte_array));
  }
  auto& encodable_a_nullable8_byte_array = list[6];
  if (!encodable_a_nullable8_byte_array.IsNull()) {
    decoded.set_a_nullable8_byte_array(
        std::get<std::vector<int64_t>>(encodable_a_nullable8_byte_array));
  }
  auto& encodable_a_nullable_float_array = list[7];
  if (!encodable_a_nullable_float_array.IsNull()) {
    decoded.set_a_nullable_float_array(
        std::get<std::vector<double>>(encodable_a_nullable_float_array));
  }
  auto& encodable_a_nullable_enum = list[8];
  if (!encodable_a_nullable_enum.IsNull()) {
    decoded.set_a_nullable_enum(std::any_cast<const AnEnum&>(
        std::get<CustomEncodableValue>(encodable_a_nullable_enum)));
  }
  auto& encodable_another_nullable_enum = list[9];
  if (!encodable_another_nullable_enum.IsNull()) {
    decoded.set_another_nullable_enum(std::any_cast<const AnotherEnum&>(
        std::get<CustomEncodableValue>(encodable_another_nullable_enum)));
  }
  auto& encodable_a_nullable_string = list[10];
  if (!encodable_a_nullable_string.IsNull()) {
    decoded.set_a_nullable_string(
        std::get<std::string>(encodable_a_nullable_string));
  }
  auto& encodable_a_nullable_object = list[11];
  if (!encodable_a_nullable_object.IsNull()) {
    decoded.set_a_nullable_object(encodable_a_nullable_object);
  }
  auto& encodable_list = list[12];
  if (!encodable_list.IsNull()) {
    decoded.set_list(std::get<EncodableList>(encodable_list));
  }
  auto& encodable_string_list = list[13];
  if (!encodable_string_list.IsNull()) {
    decoded.set_string_list(std::get<EncodableList>(encodable_string_list));
  }
  auto& encodable_int_list = list[14];
  if (!encodable_int_list.IsNull()) {
    decoded.set_int_list(std::get<EncodableList>(encodable_int_list));
  }
  auto& encodable_double_list = list[15];
  if (!encodable_double_list.IsNull()) {
    decoded.set_double_list(std::get<EncodableList>(encodable_double_list));
  }
  auto& encodable_bool_list = list[16];
  if (!encodable_bool_list.IsNull()) {
    decoded.set_bool_list(std::get<EncodableList>(encodable_bool_list));
  }
  auto& encodable_enum_list = list[17];
  if (!encodable_enum_list.IsNull()) {
    decoded.set_enum_list(std::get<EncodableList>(encodable_enum_list));
  }
  auto& encodable_object_list = list[18];
  if (!encodable_object_list.IsNull()) {
    decoded.set_object_list(std::get<EncodableList>(encodable_object_list));
  }
  auto& encodable_list_list = list[19];
  if (!encodable_list_list.IsNull()) {
    decoded.set_list_list(std::get<EncodableList>(encodable_list_list));
  }
  auto& encodable_map_list = list[20];
  if (!encodable_map_list.IsNull()) {
    decoded.set_map_list(std::get<EncodableList>(encodable_map_list));
  }
  auto& encodable_map = list[21];
  if (!encodable_map.IsNull()) {
    decoded.set_map(std::get<EncodableMap>(encodable_map));
  }
  auto& encodable_string_map = list[22];
  if (!encodable_string_map.IsNull()) {
    decoded.set_string_map(std::get<EncodableMap>(encodable_string_map));
  }
  auto& encodable_int_map = list[23];
  if (!encodable_int_map.IsNull()) {
    decoded.set_int_map(std::get<EncodableMap>(encodable_int_map));
  }
  auto& encodable_enum_map = list[24];
  if (!encodable_enum_map.IsNull()) {
    decoded.set_enum_map(std::get<EncodableMap>(encodable_enum_map));
  }
  auto& encodable_object_map = list[25];
  if (!encodable_object_map.IsNull()) {
    decoded.set_object_map(std::get<EncodableMap>(encodable_object_map));
  }
  auto& encodable_list_map = list[26];
  if (!encodable_list_map.IsNull()) {
    decoded.set_list_map(std::get<EncodableMap>(encodable_list_map));
  }
  auto& encodable_map_map = list[27];
  if (!encodable_map_map.IsNull()) {
    decoded.set_map_map(std::get<EncodableMap>(encodable_map_map));
  }
  return decoded;
}

// AllClassesWrapper

AllClassesWrapper::AllClassesWrapper(const AllNullableTypes& all_nullable_types,
                                     const EncodableList& class_list,
                                     const EncodableMap& class_map)
    : all_nullable_types_(
          std::make_unique<AllNullableTypes>(all_nullable_types)),
      class_list_(class_list),
      class_map_(class_map) {}

AllClassesWrapper::AllClassesWrapper(const AllNullableTypes& all_nullable_types,
                                     const AllNullableTypesWithoutRecursion*
                                         all_nullable_types_without_recursion,
                                     const AllTypes* all_types,
                                     const EncodableList& class_list,
                                     const EncodableList* nullable_class_list,
                                     const EncodableMap& class_map,
                                     const EncodableMap* nullable_class_map)
    : all_nullable_types_(
          std::make_unique<AllNullableTypes>(all_nullable_types)),
      all_nullable_types_without_recursion_(
          all_nullable_types_without_recursion
              ? std::make_unique<AllNullableTypesWithoutRecursion>(
                    *all_nullable_types_without_recursion)
              : nullptr),
      all_types_(all_types ? std::make_unique<AllTypes>(*all_types) : nullptr),
      class_list_(class_list),
      nullable_class_list_(nullable_class_list ? std::optional<EncodableList>(
                                                     *nullable_class_list)
                                               : std::nullopt),
      class_map_(class_map),
      nullable_class_map_(nullable_class_map
                              ? std::optional<EncodableMap>(*nullable_class_map)
                              : std::nullopt) {}

AllClassesWrapper::AllClassesWrapper(const AllClassesWrapper& other)
    : all_nullable_types_(
          std::make_unique<AllNullableTypes>(*other.all_nullable_types_)),
      all_nullable_types_without_recursion_(
          other.all_nullable_types_without_recursion_
              ? std::make_unique<AllNullableTypesWithoutRecursion>(
                    *other.all_nullable_types_without_recursion_)
              : nullptr),
      all_types_(other.all_types_
                     ? std::make_unique<AllTypes>(*other.all_types_)
                     : nullptr),
      class_list_(other.class_list_),
      nullable_class_list_(
          other.nullable_class_list_
              ? std::optional<EncodableList>(*other.nullable_class_list_)
              : std::nullopt),
      class_map_(other.class_map_),
      nullable_class_map_(
          other.nullable_class_map_
              ? std::optional<EncodableMap>(*other.nullable_class_map_)
              : std::nullopt) {}

AllClassesWrapper& AllClassesWrapper::operator=(
    const AllClassesWrapper& other) {
  all_nullable_types_ =
      std::make_unique<AllNullableTypes>(*other.all_nullable_types_);
  all_nullable_types_without_recursion_ =
      other.all_nullable_types_without_recursion_
          ? std::make_unique<AllNullableTypesWithoutRecursion>(
                *other.all_nullable_types_without_recursion_)
          : nullptr;
  all_types_ = other.all_types_ ? std::make_unique<AllTypes>(*other.all_types_)
                                : nullptr;
  class_list_ = other.class_list_;
  nullable_class_list_ = other.nullable_class_list_;
  class_map_ = other.class_map_;
  nullable_class_map_ = other.nullable_class_map_;
  return *this;
}

const AllNullableTypes& AllClassesWrapper::all_nullable_types() const {
  return *all_nullable_types_;
}

void AllClassesWrapper::set_all_nullable_types(
    const AllNullableTypes& value_arg) {
  all_nullable_types_ = std::make_unique<AllNullableTypes>(value_arg);
}

const AllNullableTypesWithoutRecursion*
AllClassesWrapper::all_nullable_types_without_recursion() const {
  return all_nullable_types_without_recursion_.get();
}

void AllClassesWrapper::set_all_nullable_types_without_recursion(
    const AllNullableTypesWithoutRecursion* value_arg) {
  all_nullable_types_without_recursion_ =
      value_arg ? std::make_unique<AllNullableTypesWithoutRecursion>(*value_arg)
                : nullptr;
}

void AllClassesWrapper::set_all_nullable_types_without_recursion(
    const AllNullableTypesWithoutRecursion& value_arg) {
  all_nullable_types_without_recursion_ =
      std::make_unique<AllNullableTypesWithoutRecursion>(value_arg);
}

const AllTypes* AllClassesWrapper::all_types() const {
  return all_types_.get();
}

void AllClassesWrapper::set_all_types(const AllTypes* value_arg) {
  all_types_ = value_arg ? std::make_unique<AllTypes>(*value_arg) : nullptr;
}

void AllClassesWrapper::set_all_types(const AllTypes& value_arg) {
  all_types_ = std::make_unique<AllTypes>(value_arg);
}

const EncodableList& AllClassesWrapper::class_list() const {
  return class_list_;
}

void AllClassesWrapper::set_class_list(const EncodableList& value_arg) {
  class_list_ = value_arg;
}

const EncodableList* AllClassesWrapper::nullable_class_list() const {
  return nullable_class_list_ ? &(*nullable_class_list_) : nullptr;
}

void AllClassesWrapper::set_nullable_class_list(
    const EncodableList* value_arg) {
  nullable_class_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void AllClassesWrapper::set_nullable_class_list(
    const EncodableList& value_arg) {
  nullable_class_list_ = value_arg;
}

const EncodableMap& AllClassesWrapper::class_map() const { return class_map_; }

void AllClassesWrapper::set_class_map(const EncodableMap& value_arg) {
  class_map_ = value_arg;
}

const EncodableMap* AllClassesWrapper::nullable_class_map() const {
  return nullable_class_map_ ? &(*nullable_class_map_) : nullptr;
}

void AllClassesWrapper::set_nullable_class_map(const EncodableMap* value_arg) {
  nullable_class_map_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void AllClassesWrapper::set_nullable_class_map(const EncodableMap& value_arg) {
  nullable_class_map_ = value_arg;
}

EncodableList AllClassesWrapper::ToEncodableList() const {
  EncodableList list;
  list.reserve(7);
  list.push_back(CustomEncodableValue(*all_nullable_types_));
  list.push_back(
      all_nullable_types_without_recursion_
          ? CustomEncodableValue(*all_nullable_types_without_recursion_)
          : EncodableValue());
  list.push_back(all_types_ ? CustomEncodableValue(*all_types_)
                            : EncodableValue());
  list.push_back(EncodableValue(class_list_));
  list.push_back(nullable_class_list_ ? EncodableValue(*nullable_class_list_)
                                      : EncodableValue());
  list.push_back(EncodableValue(class_map_));
  list.push_back(nullable_class_map_ ? EncodableValue(*nullable_class_map_)
                                     : EncodableValue());
  return list;
}

AllClassesWrapper AllClassesWrapper::FromEncodableList(
    const EncodableList& list) {
  AllClassesWrapper decoded(std::any_cast<const AllNullableTypes&>(
                                std::get<CustomEncodableValue>(list[0])),
                            std::get<EncodableList>(list[3]),
                            std::get<EncodableMap>(list[5]));
  auto& encodable_all_nullable_types_without_recursion = list[1];
  if (!encodable_all_nullable_types_without_recursion.IsNull()) {
    decoded.set_all_nullable_types_without_recursion(
        std::any_cast<const AllNullableTypesWithoutRecursion&>(
            std::get<CustomEncodableValue>(
                encodable_all_nullable_types_without_recursion)));
  }
  auto& encodable_all_types = list[2];
  if (!encodable_all_types.IsNull()) {
    decoded.set_all_types(std::any_cast<const AllTypes&>(
        std::get<CustomEncodableValue>(encodable_all_types)));
  }
  auto& encodable_nullable_class_list = list[4];
  if (!encodable_nullable_class_list.IsNull()) {
    decoded.set_nullable_class_list(
        std::get<EncodableList>(encodable_nullable_class_list));
  }
  auto& encodable_nullable_class_map = list[6];
  if (!encodable_nullable_class_map.IsNull()) {
    decoded.set_nullable_class_map(
        std::get<EncodableMap>(encodable_nullable_class_map));
  }
  return decoded;
}

// TestMessage

TestMessage::TestMessage() {}

TestMessage::TestMessage(const EncodableList* test_list)
    : test_list_(test_list ? std::optional<EncodableList>(*test_list)
                           : std::nullopt) {}

const EncodableList* TestMessage::test_list() const {
  return test_list_ ? &(*test_list_) : nullptr;
}

void TestMessage::set_test_list(const EncodableList* value_arg) {
  test_list_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void TestMessage::set_test_list(const EncodableList& value_arg) {
  test_list_ = value_arg;
}

EncodableList TestMessage::ToEncodableList() const {
  EncodableList list;
  list.reserve(1);
  list.push_back(test_list_ ? EncodableValue(*test_list_) : EncodableValue());
  return list;
}

TestMessage TestMessage::FromEncodableList(const EncodableList& list) {
  TestMessage decoded;
  auto& encodable_test_list = list[0];
  if (!encodable_test_list.IsNull()) {
    decoded.set_test_list(std::get<EncodableList>(encodable_test_list));
  }
  return decoded;
}

PigeonInternalCodecSerializer::PigeonInternalCodecSerializer() {}

EncodableValue PigeonInternalCodecSerializer::ReadValueOfType(
    uint8_t type, flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 129: {
      const auto& encodable_enum_arg = ReadValue(stream);
      const int64_t enum_arg_value =
          encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
      return encodable_enum_arg.IsNull()
                 ? EncodableValue()
                 : CustomEncodableValue(static_cast<AnEnum>(enum_arg_value));
    }
    case 130: {
      const auto& encodable_enum_arg = ReadValue(stream);
      const int64_t enum_arg_value =
          encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
      return encodable_enum_arg.IsNull()
                 ? EncodableValue()
                 : CustomEncodableValue(
                       static_cast<AnotherEnum>(enum_arg_value));
    }
    case 131: {
      return CustomEncodableValue(UnusedClass::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    case 132: {
      return CustomEncodableValue(AllTypes::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    case 133: {
      return CustomEncodableValue(AllNullableTypes::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    case 134: {
      return CustomEncodableValue(
          AllNullableTypesWithoutRecursion::FromEncodableList(
              std::get<EncodableList>(ReadValue(stream))));
    }
    case 135: {
      return CustomEncodableValue(AllClassesWrapper::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    case 136: {
      return CustomEncodableValue(TestMessage::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void PigeonInternalCodecSerializer::WriteValue(
    const EncodableValue& value, flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(AnEnum)) {
      stream->WriteByte(129);
      WriteValue(EncodableValue(
                     static_cast<int>(std::any_cast<AnEnum>(*custom_value))),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(AnotherEnum)) {
      stream->WriteByte(130);
      WriteValue(EncodableValue(static_cast<int>(
                     std::any_cast<AnotherEnum>(*custom_value))),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(UnusedClass)) {
      stream->WriteByte(131);
      WriteValue(
          EncodableValue(
              std::any_cast<UnusedClass>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(AllTypes)) {
      stream->WriteByte(132);
      WriteValue(EncodableValue(
                     std::any_cast<AllTypes>(*custom_value).ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(AllNullableTypes)) {
      stream->WriteByte(133);
      WriteValue(
          EncodableValue(
              std::any_cast<AllNullableTypes>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(AllNullableTypesWithoutRecursion)) {
      stream->WriteByte(134);
      WriteValue(EncodableValue(std::any_cast<AllNullableTypesWithoutRecursion>(
                                    *custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(AllClassesWrapper)) {
      stream->WriteByte(135);
      WriteValue(EncodableValue(std::any_cast<AllClassesWrapper>(*custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(TestMessage)) {
      stream->WriteByte(136);
      WriteValue(
          EncodableValue(
              std::any_cast<TestMessage>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by HostIntegrationCoreApi.
const flutter::StandardMessageCodec& HostIntegrationCoreApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &PigeonInternalCodecSerializer::GetInstance());
}

// Sets up an instance of `HostIntegrationCoreApi` to handle messages through
// the `binary_messenger`.
void HostIntegrationCoreApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                   HostIntegrationCoreApi* api) {
  HostIntegrationCoreApi::SetUp(binary_messenger, api, "");
}

void HostIntegrationCoreApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                   HostIntegrationCoreApi* api,
                                   const std::string& message_channel_suffix) {
  const std::string prepended_suffix =
      message_channel_suffix.length() > 0
          ? std::string(".") + message_channel_suffix
          : "";
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.noop" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              std::optional<FlutterError> output = api->Noop();
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAllTypes" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_everything_arg = args.at(0);
              if (encodable_everything_arg.IsNull()) {
                reply(WrapError("everything_arg unexpectedly null."));
                return;
              }
              const auto& everything_arg = std::any_cast<const AllTypes&>(
                  std::get<CustomEncodableValue>(encodable_everything_arg));
              ErrorOr<AllTypes> output = api->EchoAllTypes(everything_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(
                  CustomEncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.throwError" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<std::optional<EncodableValue>> output = api->ThrowError();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.throwErrorFromVoid" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              std::optional<FlutterError> output = api->ThrowErrorFromVoid();
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.throwFlutterError" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<std::optional<EncodableValue>> output =
                  api->ThrowFlutterError();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoInt" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_int_arg = args.at(0);
              if (encodable_an_int_arg.IsNull()) {
                reply(WrapError("an_int_arg unexpectedly null."));
                return;
              }
              const int64_t an_int_arg = encodable_an_int_arg.LongValue();
              ErrorOr<int64_t> output = api->EchoInt(an_int_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoDouble" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_double_arg = args.at(0);
              if (encodable_a_double_arg.IsNull()) {
                reply(WrapError("a_double_arg unexpectedly null."));
                return;
              }
              const auto& a_double_arg =
                  std::get<double>(encodable_a_double_arg);
              ErrorOr<double> output = api->EchoDouble(a_double_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoBool" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_bool_arg = args.at(0);
              if (encodable_a_bool_arg.IsNull()) {
                reply(WrapError("a_bool_arg unexpectedly null."));
                return;
              }
              const auto& a_bool_arg = std::get<bool>(encodable_a_bool_arg);
              ErrorOr<bool> output = api->EchoBool(a_bool_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoString" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_string_arg = args.at(0);
              if (encodable_a_string_arg.IsNull()) {
                reply(WrapError("a_string_arg unexpectedly null."));
                return;
              }
              const auto& a_string_arg =
                  std::get<std::string>(encodable_a_string_arg);
              ErrorOr<std::string> output = api->EchoString(a_string_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoUint8List" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_uint8_list_arg = args.at(0);
              if (encodable_a_uint8_list_arg.IsNull()) {
                reply(WrapError("a_uint8_list_arg unexpectedly null."));
                return;
              }
              const auto& a_uint8_list_arg =
                  std::get<std::vector<uint8_t>>(encodable_a_uint8_list_arg);
              ErrorOr<std::vector<uint8_t>> output =
                  api->EchoUint8List(a_uint8_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoObject" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_object_arg = args.at(0);
              if (encodable_an_object_arg.IsNull()) {
                reply(WrapError("an_object_arg unexpectedly null."));
                return;
              }
              const auto& an_object_arg = encodable_an_object_arg;
              ErrorOr<EncodableValue> output = api->EchoObject(an_object_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoList" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_list_arg = args.at(0);
              if (encodable_list_arg.IsNull()) {
                reply(WrapError("list_arg unexpectedly null."));
                return;
              }
              const auto& list_arg =
                  std::get<EncodableList>(encodable_list_arg);
              ErrorOr<EncodableList> output = api->EchoList(list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoEnumList" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              if (encodable_enum_list_arg.IsNull()) {
                reply(WrapError("enum_list_arg unexpectedly null."));
                return;
              }
              const auto& enum_list_arg =
                  std::get<EncodableList>(encodable_enum_list_arg);
              ErrorOr<EncodableList> output = api->EchoEnumList(enum_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoClassList" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              if (encodable_class_list_arg.IsNull()) {
                reply(WrapError("class_list_arg unexpectedly null."));
                return;
              }
              const auto& class_list_arg =
                  std::get<EncodableList>(encodable_class_list_arg);
              ErrorOr<EncodableList> output =
                  api->EchoClassList(class_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNonNullEnumList" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              if (encodable_enum_list_arg.IsNull()) {
                reply(WrapError("enum_list_arg unexpectedly null."));
                return;
              }
              const auto& enum_list_arg =
                  std::get<EncodableList>(encodable_enum_list_arg);
              ErrorOr<EncodableList> output =
                  api->EchoNonNullEnumList(enum_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNonNullClassList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              if (encodable_class_list_arg.IsNull()) {
                reply(WrapError("class_list_arg unexpectedly null."));
                return;
              }
              const auto& class_list_arg =
                  std::get<EncodableList>(encodable_class_list_arg);
              ErrorOr<EncodableList> output =
                  api->EchoNonNullClassList(class_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_map_arg = args.at(0);
              if (encodable_map_arg.IsNull()) {
                reply(WrapError("map_arg unexpectedly null."));
                return;
              }
              const auto& map_arg = std::get<EncodableMap>(encodable_map_arg);
              ErrorOr<EncodableMap> output = api->EchoMap(map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoStringMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              if (encodable_string_map_arg.IsNull()) {
                reply(WrapError("string_map_arg unexpectedly null."));
                return;
              }
              const auto& string_map_arg =
                  std::get<EncodableMap>(encodable_string_map_arg);
              ErrorOr<EncodableMap> output = api->EchoStringMap(string_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoIntMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              if (encodable_int_map_arg.IsNull()) {
                reply(WrapError("int_map_arg unexpectedly null."));
                return;
              }
              const auto& int_map_arg =
                  std::get<EncodableMap>(encodable_int_map_arg);
              ErrorOr<EncodableMap> output = api->EchoIntMap(int_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoEnumMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              if (encodable_enum_map_arg.IsNull()) {
                reply(WrapError("enum_map_arg unexpectedly null."));
                return;
              }
              const auto& enum_map_arg =
                  std::get<EncodableMap>(encodable_enum_map_arg);
              ErrorOr<EncodableMap> output = api->EchoEnumMap(enum_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoClassMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              if (encodable_class_map_arg.IsNull()) {
                reply(WrapError("class_map_arg unexpectedly null."));
                return;
              }
              const auto& class_map_arg =
                  std::get<EncodableMap>(encodable_class_map_arg);
              ErrorOr<EncodableMap> output = api->EchoClassMap(class_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNonNullStringMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              if (encodable_string_map_arg.IsNull()) {
                reply(WrapError("string_map_arg unexpectedly null."));
                return;
              }
              const auto& string_map_arg =
                  std::get<EncodableMap>(encodable_string_map_arg);
              ErrorOr<EncodableMap> output =
                  api->EchoNonNullStringMap(string_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNonNullIntMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              if (encodable_int_map_arg.IsNull()) {
                reply(WrapError("int_map_arg unexpectedly null."));
                return;
              }
              const auto& int_map_arg =
                  std::get<EncodableMap>(encodable_int_map_arg);
              ErrorOr<EncodableMap> output =
                  api->EchoNonNullIntMap(int_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNonNullEnumMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              if (encodable_enum_map_arg.IsNull()) {
                reply(WrapError("enum_map_arg unexpectedly null."));
                return;
              }
              const auto& enum_map_arg =
                  std::get<EncodableMap>(encodable_enum_map_arg);
              ErrorOr<EncodableMap> output =
                  api->EchoNonNullEnumMap(enum_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNonNullClassMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              if (encodable_class_map_arg.IsNull()) {
                reply(WrapError("class_map_arg unexpectedly null."));
                return;
              }
              const auto& class_map_arg =
                  std::get<EncodableMap>(encodable_class_map_arg);
              ErrorOr<EncodableMap> output =
                  api->EchoNonNullClassMap(class_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoClassWrapper" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_wrapper_arg = args.at(0);
              if (encodable_wrapper_arg.IsNull()) {
                reply(WrapError("wrapper_arg unexpectedly null."));
                return;
              }
              const auto& wrapper_arg = std::any_cast<const AllClassesWrapper&>(
                  std::get<CustomEncodableValue>(encodable_wrapper_arg));
              ErrorOr<AllClassesWrapper> output =
                  api->EchoClassWrapper(wrapper_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(
                  CustomEncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoEnum" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_enum_arg = args.at(0);
              if (encodable_an_enum_arg.IsNull()) {
                reply(WrapError("an_enum_arg unexpectedly null."));
                return;
              }
              const auto& an_enum_arg = std::any_cast<const AnEnum&>(
                  std::get<CustomEncodableValue>(encodable_an_enum_arg));
              ErrorOr<AnEnum> output = api->EchoEnum(an_enum_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(
                  CustomEncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAnotherEnum" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_another_enum_arg = args.at(0);
              if (encodable_another_enum_arg.IsNull()) {
                reply(WrapError("another_enum_arg unexpectedly null."));
                return;
              }
              const auto& another_enum_arg = std::any_cast<const AnotherEnum&>(
                  std::get<CustomEncodableValue>(encodable_another_enum_arg));
              ErrorOr<AnotherEnum> output =
                  api->EchoAnotherEnum(another_enum_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(
                  CustomEncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNamedDefaultString" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_string_arg = args.at(0);
              if (encodable_a_string_arg.IsNull()) {
                reply(WrapError("a_string_arg unexpectedly null."));
                return;
              }
              const auto& a_string_arg =
                  std::get<std::string>(encodable_a_string_arg);
              ErrorOr<std::string> output =
                  api->EchoNamedDefaultString(a_string_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoOptionalDefaultDouble" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_double_arg = args.at(0);
              if (encodable_a_double_arg.IsNull()) {
                reply(WrapError("a_double_arg unexpectedly null."));
                return;
              }
              const auto& a_double_arg =
                  std::get<double>(encodable_a_double_arg);
              ErrorOr<double> output =
                  api->EchoOptionalDefaultDouble(a_double_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoRequiredInt" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_int_arg = args.at(0);
              if (encodable_an_int_arg.IsNull()) {
                reply(WrapError("an_int_arg unexpectedly null."));
                return;
              }
              const int64_t an_int_arg = encodable_an_int_arg.LongValue();
              ErrorOr<int64_t> output = api->EchoRequiredInt(an_int_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAllNullableTypes" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_everything_arg = args.at(0);
              const auto* everything_arg =
                  encodable_everything_arg.IsNull()
                      ? nullptr
                      : &(std::any_cast<const AllNullableTypes&>(
                            std::get<CustomEncodableValue>(
                                encodable_everything_arg)));
              ErrorOr<std::optional<AllNullableTypes>> output =
                  api->EchoAllNullableTypes(everything_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    CustomEncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAllNullableTypesWithoutRecursion" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](
                                    const EncodableValue& message,
                                    const flutter::MessageReply<EncodableValue>&
                                        reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_everything_arg = args.at(0);
          const auto* everything_arg =
              encodable_everything_arg.IsNull()
                  ? nullptr
                  : &(std::any_cast<const AllNullableTypesWithoutRecursion&>(
                        std::get<CustomEncodableValue>(
                            encodable_everything_arg)));
          ErrorOr<std::optional<AllNullableTypesWithoutRecursion>> output =
              api->EchoAllNullableTypesWithoutRecursion(everything_arg);
          if (output.has_error()) {
            reply(WrapError(output.error()));
            return;
          }
          EncodableList wrapped;
          auto output_optional = std::move(output).TakeValue();
          if (output_optional) {
            wrapped.push_back(
                CustomEncodableValue(std::move(output_optional).value()));
          } else {
            wrapped.push_back(EncodableValue());
          }
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "extractNestedNullableString" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_wrapper_arg = args.at(0);
              if (encodable_wrapper_arg.IsNull()) {
                reply(WrapError("wrapper_arg unexpectedly null."));
                return;
              }
              const auto& wrapper_arg = std::any_cast<const AllClassesWrapper&>(
                  std::get<CustomEncodableValue>(encodable_wrapper_arg));
              ErrorOr<std::optional<std::string>> output =
                  api->ExtractNestedNullableString(wrapper_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "createNestedNullableString" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_nullable_string_arg = args.at(0);
              const auto* nullable_string_arg =
                  std::get_if<std::string>(&encodable_nullable_string_arg);
              ErrorOr<AllClassesWrapper> output =
                  api->CreateNestedNullableString(nullable_string_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(
                  CustomEncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "sendMultipleNullableTypes" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_bool_arg = args.at(0);
              const auto* a_nullable_bool_arg =
                  std::get_if<bool>(&encodable_a_nullable_bool_arg);
              const auto& encodable_a_nullable_int_arg = args.at(1);
              const auto* a_nullable_int_arg =
                  std::get_if<int64_t>(&encodable_a_nullable_int_arg);
              const auto& encodable_a_nullable_string_arg = args.at(2);
              const auto* a_nullable_string_arg =
                  std::get_if<std::string>(&encodable_a_nullable_string_arg);
              ErrorOr<AllNullableTypes> output = api->SendMultipleNullableTypes(
                  a_nullable_bool_arg, a_nullable_int_arg,
                  a_nullable_string_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(
                  CustomEncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "sendMultipleNullableTypesWithoutRecursion" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_bool_arg = args.at(0);
              const auto* a_nullable_bool_arg =
                  std::get_if<bool>(&encodable_a_nullable_bool_arg);
              const auto& encodable_a_nullable_int_arg = args.at(1);
              const auto* a_nullable_int_arg =
                  std::get_if<int64_t>(&encodable_a_nullable_int_arg);
              const auto& encodable_a_nullable_string_arg = args.at(2);
              const auto* a_nullable_string_arg =
                  std::get_if<std::string>(&encodable_a_nullable_string_arg);
              ErrorOr<AllNullableTypesWithoutRecursion> output =
                  api->SendMultipleNullableTypesWithoutRecursion(
                      a_nullable_bool_arg, a_nullable_int_arg,
                      a_nullable_string_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(
                  CustomEncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableInt" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_int_arg = args.at(0);
              const auto* a_nullable_int_arg =
                  std::get_if<int64_t>(&encodable_a_nullable_int_arg);
              ErrorOr<std::optional<int64_t>> output =
                  api->EchoNullableInt(a_nullable_int_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableDouble" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_double_arg = args.at(0);
              const auto* a_nullable_double_arg =
                  std::get_if<double>(&encodable_a_nullable_double_arg);
              ErrorOr<std::optional<double>> output =
                  api->EchoNullableDouble(a_nullable_double_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableBool" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_bool_arg = args.at(0);
              const auto* a_nullable_bool_arg =
                  std::get_if<bool>(&encodable_a_nullable_bool_arg);
              ErrorOr<std::optional<bool>> output =
                  api->EchoNullableBool(a_nullable_bool_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableString" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_string_arg = args.at(0);
              const auto* a_nullable_string_arg =
                  std::get_if<std::string>(&encodable_a_nullable_string_arg);
              ErrorOr<std::optional<std::string>> output =
                  api->EchoNullableString(a_nullable_string_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableUint8List" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_uint8_list_arg = args.at(0);
              const auto* a_nullable_uint8_list_arg =
                  std::get_if<std::vector<uint8_t>>(
                      &encodable_a_nullable_uint8_list_arg);
              ErrorOr<std::optional<std::vector<uint8_t>>> output =
                  api->EchoNullableUint8List(a_nullable_uint8_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableObject" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_object_arg = args.at(0);
              const auto* a_nullable_object_arg =
                  &encodable_a_nullable_object_arg;
              ErrorOr<std::optional<EncodableValue>> output =
                  api->EchoNullableObject(a_nullable_object_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableList" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_list_arg = args.at(0);
              const auto* a_nullable_list_arg =
                  std::get_if<EncodableList>(&encodable_a_nullable_list_arg);
              ErrorOr<std::optional<EncodableList>> output =
                  api->EchoNullableList(a_nullable_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableEnumList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              const auto* enum_list_arg =
                  std::get_if<EncodableList>(&encodable_enum_list_arg);
              ErrorOr<std::optional<EncodableList>> output =
                  api->EchoNullableEnumList(enum_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableClassList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              const auto* class_list_arg =
                  std::get_if<EncodableList>(&encodable_class_list_arg);
              ErrorOr<std::optional<EncodableList>> output =
                  api->EchoNullableClassList(class_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableNonNullEnumList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              const auto* enum_list_arg =
                  std::get_if<EncodableList>(&encodable_enum_list_arg);
              ErrorOr<std::optional<EncodableList>> output =
                  api->EchoNullableNonNullEnumList(enum_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableNonNullClassList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              const auto* class_list_arg =
                  std::get_if<EncodableList>(&encodable_class_list_arg);
              ErrorOr<std::optional<EncodableList>> output =
                  api->EchoNullableNonNullClassList(class_list_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_map_arg = args.at(0);
              const auto* map_arg =
                  std::get_if<EncodableMap>(&encodable_map_arg);
              ErrorOr<std::optional<EncodableMap>> output =
                  api->EchoNullableMap(map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableStringMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              const auto* string_map_arg =
                  std::get_if<EncodableMap>(&encodable_string_map_arg);
              ErrorOr<std::optional<EncodableMap>> output =
                  api->EchoNullableStringMap(string_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableIntMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              const auto* int_map_arg =
                  std::get_if<EncodableMap>(&encodable_int_map_arg);
              ErrorOr<std::optional<EncodableMap>> output =
                  api->EchoNullableIntMap(int_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableEnumMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              const auto* enum_map_arg =
                  std::get_if<EncodableMap>(&encodable_enum_map_arg);
              ErrorOr<std::optional<EncodableMap>> output =
                  api->EchoNullableEnumMap(enum_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableClassMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              const auto* class_map_arg =
                  std::get_if<EncodableMap>(&encodable_class_map_arg);
              ErrorOr<std::optional<EncodableMap>> output =
                  api->EchoNullableClassMap(class_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableNonNullStringMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              const auto* string_map_arg =
                  std::get_if<EncodableMap>(&encodable_string_map_arg);
              ErrorOr<std::optional<EncodableMap>> output =
                  api->EchoNullableNonNullStringMap(string_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableNonNullIntMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              const auto* int_map_arg =
                  std::get_if<EncodableMap>(&encodable_int_map_arg);
              ErrorOr<std::optional<EncodableMap>> output =
                  api->EchoNullableNonNullIntMap(int_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableNonNullEnumMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              const auto* enum_map_arg =
                  std::get_if<EncodableMap>(&encodable_enum_map_arg);
              ErrorOr<std::optional<EncodableMap>> output =
                  api->EchoNullableNonNullEnumMap(enum_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNullableNonNullClassMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              const auto* class_map_arg =
                  std::get_if<EncodableMap>(&encodable_class_map_arg);
              ErrorOr<std::optional<EncodableMap>> output =
                  api->EchoNullableNonNullClassMap(class_map_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoNullableEnum" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_enum_arg = args.at(0);
              AnEnum an_enum_arg_value;
              const AnEnum* an_enum_arg = nullptr;
              if (!encodable_an_enum_arg.IsNull()) {
                an_enum_arg_value = std::any_cast<const AnEnum&>(
                    std::get<CustomEncodableValue>(encodable_an_enum_arg));
                an_enum_arg = &an_enum_arg_value;
              }
              ErrorOr<std::optional<AnEnum>> output = api->EchoNullableEnum(
                  an_enum_arg ? &(*an_enum_arg) : nullptr);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    CustomEncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAnotherNullableEnum" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_another_enum_arg = args.at(0);
              AnotherEnum another_enum_arg_value;
              const AnotherEnum* another_enum_arg = nullptr;
              if (!encodable_another_enum_arg.IsNull()) {
                another_enum_arg_value = std::any_cast<const AnotherEnum&>(
                    std::get<CustomEncodableValue>(encodable_another_enum_arg));
                another_enum_arg = &another_enum_arg_value;
              }
              ErrorOr<std::optional<AnotherEnum>> output =
                  api->EchoAnotherNullableEnum(
                      another_enum_arg ? &(*another_enum_arg) : nullptr);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    CustomEncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoOptionalNullableInt" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_int_arg = args.at(0);
              const auto* a_nullable_int_arg =
                  std::get_if<int64_t>(&encodable_a_nullable_int_arg);
              ErrorOr<std::optional<int64_t>> output =
                  api->EchoOptionalNullableInt(a_nullable_int_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoNamedNullableString" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_string_arg = args.at(0);
              const auto* a_nullable_string_arg =
                  std::get_if<std::string>(&encodable_a_nullable_string_arg);
              ErrorOr<std::optional<std::string>> output =
                  api->EchoNamedNullableString(a_nullable_string_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.noopAsync" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              api->NoopAsync([reply](std::optional<FlutterError>&& output) {
                if (output.has_value()) {
                  reply(WrapError(output.value()));
                  return;
                }
                EncodableList wrapped;
                wrapped.push_back(EncodableValue());
                reply(EncodableValue(std::move(wrapped)));
              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncInt" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_int_arg = args.at(0);
              if (encodable_an_int_arg.IsNull()) {
                reply(WrapError("an_int_arg unexpectedly null."));
                return;
              }
              const int64_t an_int_arg = encodable_an_int_arg.LongValue();
              api->EchoAsyncInt(an_int_arg, [reply](ErrorOr<int64_t>&& output) {
                if (output.has_error()) {
                  reply(WrapError(output.error()));
                  return;
                }
                EncodableList wrapped;
                wrapped.push_back(
                    EncodableValue(std::move(output).TakeValue()));
                reply(EncodableValue(std::move(wrapped)));
              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncDouble" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_double_arg = args.at(0);
              if (encodable_a_double_arg.IsNull()) {
                reply(WrapError("a_double_arg unexpectedly null."));
                return;
              }
              const auto& a_double_arg =
                  std::get<double>(encodable_a_double_arg);
              api->EchoAsyncDouble(
                  a_double_arg, [reply](ErrorOr<double>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncBool" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_bool_arg = args.at(0);
              if (encodable_a_bool_arg.IsNull()) {
                reply(WrapError("a_bool_arg unexpectedly null."));
                return;
              }
              const auto& a_bool_arg = std::get<bool>(encodable_a_bool_arg);
              api->EchoAsyncBool(a_bool_arg, [reply](ErrorOr<bool>&& output) {
                if (output.has_error()) {
                  reply(WrapError(output.error()));
                  return;
                }
                EncodableList wrapped;
                wrapped.push_back(
                    EncodableValue(std::move(output).TakeValue()));
                reply(EncodableValue(std::move(wrapped)));
              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncString" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_string_arg = args.at(0);
              if (encodable_a_string_arg.IsNull()) {
                reply(WrapError("a_string_arg unexpectedly null."));
                return;
              }
              const auto& a_string_arg =
                  std::get<std::string>(encodable_a_string_arg);
              api->EchoAsyncString(
                  a_string_arg, [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncUint8List" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_uint8_list_arg = args.at(0);
              if (encodable_a_uint8_list_arg.IsNull()) {
                reply(WrapError("a_uint8_list_arg unexpectedly null."));
                return;
              }
              const auto& a_uint8_list_arg =
                  std::get<std::vector<uint8_t>>(encodable_a_uint8_list_arg);
              api->EchoAsyncUint8List(
                  a_uint8_list_arg,
                  [reply](ErrorOr<std::vector<uint8_t>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncObject" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_object_arg = args.at(0);
              if (encodable_an_object_arg.IsNull()) {
                reply(WrapError("an_object_arg unexpectedly null."));
                return;
              }
              const auto& an_object_arg = encodable_an_object_arg;
              api->EchoAsyncObject(
                  an_object_arg, [reply](ErrorOr<EncodableValue>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncList" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_list_arg = args.at(0);
              if (encodable_list_arg.IsNull()) {
                reply(WrapError("list_arg unexpectedly null."));
                return;
              }
              const auto& list_arg =
                  std::get<EncodableList>(encodable_list_arg);
              api->EchoAsyncList(
                  list_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncEnumList" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              if (encodable_enum_list_arg.IsNull()) {
                reply(WrapError("enum_list_arg unexpectedly null."));
                return;
              }
              const auto& enum_list_arg =
                  std::get<EncodableList>(encodable_enum_list_arg);
              api->EchoAsyncEnumList(
                  enum_list_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncClassList" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              if (encodable_class_list_arg.IsNull()) {
                reply(WrapError("class_list_arg unexpectedly null."));
                return;
              }
              const auto& class_list_arg =
                  std::get<EncodableList>(encodable_class_list_arg);
              api->EchoAsyncClassList(
                  class_list_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_map_arg = args.at(0);
              if (encodable_map_arg.IsNull()) {
                reply(WrapError("map_arg unexpectedly null."));
                return;
              }
              const auto& map_arg = std::get<EncodableMap>(encodable_map_arg);
              api->EchoAsyncMap(
                  map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncStringMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              if (encodable_string_map_arg.IsNull()) {
                reply(WrapError("string_map_arg unexpectedly null."));
                return;
              }
              const auto& string_map_arg =
                  std::get<EncodableMap>(encodable_string_map_arg);
              api->EchoAsyncStringMap(
                  string_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncIntMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              if (encodable_int_map_arg.IsNull()) {
                reply(WrapError("int_map_arg unexpectedly null."));
                return;
              }
              const auto& int_map_arg =
                  std::get<EncodableMap>(encodable_int_map_arg);
              api->EchoAsyncIntMap(
                  int_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncEnumMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              if (encodable_enum_map_arg.IsNull()) {
                reply(WrapError("enum_map_arg unexpectedly null."));
                return;
              }
              const auto& enum_map_arg =
                  std::get<EncodableMap>(encodable_enum_map_arg);
              api->EchoAsyncEnumMap(
                  enum_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncClassMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              if (encodable_class_map_arg.IsNull()) {
                reply(WrapError("class_map_arg unexpectedly null."));
                return;
              }
              const auto& class_map_arg =
                  std::get<EncodableMap>(encodable_class_map_arg);
              api->EchoAsyncClassMap(
                  class_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncEnum" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_enum_arg = args.at(0);
              if (encodable_an_enum_arg.IsNull()) {
                reply(WrapError("an_enum_arg unexpectedly null."));
                return;
              }
              const auto& an_enum_arg = std::any_cast<const AnEnum&>(
                  std::get<CustomEncodableValue>(encodable_an_enum_arg));
              api->EchoAsyncEnum(
                  an_enum_arg, [reply](ErrorOr<AnEnum>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAnotherAsyncEnum" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_another_enum_arg = args.at(0);
              if (encodable_another_enum_arg.IsNull()) {
                reply(WrapError("another_enum_arg unexpectedly null."));
                return;
              }
              const auto& another_enum_arg = std::any_cast<const AnotherEnum&>(
                  std::get<CustomEncodableValue>(encodable_another_enum_arg));
              api->EchoAnotherAsyncEnum(
                  another_enum_arg, [reply](ErrorOr<AnotherEnum>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.throwAsyncError" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              api->ThrowAsyncError(
                  [reply](ErrorOr<std::optional<EncodableValue>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "throwAsyncErrorFromVoid" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              api->ThrowAsyncErrorFromVoid(
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(EncodableValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "throwAsyncFlutterError" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              api->ThrowAsyncFlutterError(
                  [reply](ErrorOr<std::optional<EncodableValue>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.echoAsyncAllTypes" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_everything_arg = args.at(0);
              if (encodable_everything_arg.IsNull()) {
                reply(WrapError("everything_arg unexpectedly null."));
                return;
              }
              const auto& everything_arg = std::any_cast<const AllTypes&>(
                  std::get<CustomEncodableValue>(encodable_everything_arg));
              api->EchoAsyncAllTypes(
                  everything_arg, [reply](ErrorOr<AllTypes>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableAllNullableTypes" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_everything_arg = args.at(0);
              const auto* everything_arg =
                  encodable_everything_arg.IsNull()
                      ? nullptr
                      : &(std::any_cast<const AllNullableTypes&>(
                            std::get<CustomEncodableValue>(
                                encodable_everything_arg)));
              api->EchoAsyncNullableAllNullableTypes(
                  everything_arg,
                  [reply](ErrorOr<std::optional<AllNullableTypes>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(CustomEncodableValue(
                          std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableAllNullableTypesWithoutRecursion" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](
                                    const EncodableValue& message,
                                    const flutter::MessageReply<EncodableValue>&
                                        reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_everything_arg = args.at(0);
          const auto* everything_arg =
              encodable_everything_arg.IsNull()
                  ? nullptr
                  : &(std::any_cast<const AllNullableTypesWithoutRecursion&>(
                        std::get<CustomEncodableValue>(
                            encodable_everything_arg)));
          api->EchoAsyncNullableAllNullableTypesWithoutRecursion(
              everything_arg,
              [reply](ErrorOr<std::optional<AllNullableTypesWithoutRecursion>>&&
                          output) {
                if (output.has_error()) {
                  reply(WrapError(output.error()));
                  return;
                }
                EncodableList wrapped;
                auto output_optional = std::move(output).TakeValue();
                if (output_optional) {
                  wrapped.push_back(
                      CustomEncodableValue(std::move(output_optional).value()));
                } else {
                  wrapped.push_back(EncodableValue());
                }
                reply(EncodableValue(std::move(wrapped)));
              });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableInt" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_int_arg = args.at(0);
              const auto* an_int_arg =
                  std::get_if<int64_t>(&encodable_an_int_arg);
              api->EchoAsyncNullableInt(
                  an_int_arg,
                  [reply](ErrorOr<std::optional<int64_t>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableDouble" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_double_arg = args.at(0);
              const auto* a_double_arg =
                  std::get_if<double>(&encodable_a_double_arg);
              api->EchoAsyncNullableDouble(
                  a_double_arg,
                  [reply](ErrorOr<std::optional<double>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableBool" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_bool_arg = args.at(0);
              const auto* a_bool_arg = std::get_if<bool>(&encodable_a_bool_arg);
              api->EchoAsyncNullableBool(
                  a_bool_arg, [reply](ErrorOr<std::optional<bool>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableString" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_string_arg = args.at(0);
              const auto* a_string_arg =
                  std::get_if<std::string>(&encodable_a_string_arg);
              api->EchoAsyncNullableString(
                  a_string_arg,
                  [reply](ErrorOr<std::optional<std::string>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableUint8List" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_uint8_list_arg = args.at(0);
              const auto* a_uint8_list_arg = std::get_if<std::vector<uint8_t>>(
                  &encodable_a_uint8_list_arg);
              api->EchoAsyncNullableUint8List(
                  a_uint8_list_arg,
                  [reply](
                      ErrorOr<std::optional<std::vector<uint8_t>>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableObject" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_object_arg = args.at(0);
              const auto* an_object_arg = &encodable_an_object_arg;
              api->EchoAsyncNullableObject(
                  an_object_arg,
                  [reply](ErrorOr<std::optional<EncodableValue>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_list_arg = args.at(0);
              const auto* list_arg =
                  std::get_if<EncodableList>(&encodable_list_arg);
              api->EchoAsyncNullableList(
                  list_arg,
                  [reply](ErrorOr<std::optional<EncodableList>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableEnumList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              const auto* enum_list_arg =
                  std::get_if<EncodableList>(&encodable_enum_list_arg);
              api->EchoAsyncNullableEnumList(
                  enum_list_arg,
                  [reply](ErrorOr<std::optional<EncodableList>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableClassList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              const auto* class_list_arg =
                  std::get_if<EncodableList>(&encodable_class_list_arg);
              api->EchoAsyncNullableClassList(
                  class_list_arg,
                  [reply](ErrorOr<std::optional<EncodableList>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_map_arg = args.at(0);
              const auto* map_arg =
                  std::get_if<EncodableMap>(&encodable_map_arg);
              api->EchoAsyncNullableMap(
                  map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableStringMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              const auto* string_map_arg =
                  std::get_if<EncodableMap>(&encodable_string_map_arg);
              api->EchoAsyncNullableStringMap(
                  string_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableIntMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              const auto* int_map_arg =
                  std::get_if<EncodableMap>(&encodable_int_map_arg);
              api->EchoAsyncNullableIntMap(
                  int_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableEnumMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              const auto* enum_map_arg =
                  std::get_if<EncodableMap>(&encodable_enum_map_arg);
              api->EchoAsyncNullableEnumMap(
                  enum_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableClassMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              const auto* class_map_arg =
                  std::get_if<EncodableMap>(&encodable_class_map_arg);
              api->EchoAsyncNullableClassMap(
                  class_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAsyncNullableEnum" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_enum_arg = args.at(0);
              AnEnum an_enum_arg_value;
              const AnEnum* an_enum_arg = nullptr;
              if (!encodable_an_enum_arg.IsNull()) {
                an_enum_arg_value = std::any_cast<const AnEnum&>(
                    std::get<CustomEncodableValue>(encodable_an_enum_arg));
                an_enum_arg = &an_enum_arg_value;
              }
              api->EchoAsyncNullableEnum(
                  an_enum_arg ? &(*an_enum_arg) : nullptr,
                  [reply](ErrorOr<std::optional<AnEnum>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(CustomEncodableValue(
                          std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "echoAnotherAsyncNullableEnum" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_another_enum_arg = args.at(0);
              AnotherEnum another_enum_arg_value;
              const AnotherEnum* another_enum_arg = nullptr;
              if (!encodable_another_enum_arg.IsNull()) {
                another_enum_arg_value = std::any_cast<const AnotherEnum&>(
                    std::get<CustomEncodableValue>(encodable_another_enum_arg));
                another_enum_arg = &another_enum_arg_value;
              }
              api->EchoAnotherAsyncNullableEnum(
                  another_enum_arg ? &(*another_enum_arg) : nullptr,
                  [reply](ErrorOr<std::optional<AnotherEnum>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(CustomEncodableValue(
                          std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.defaultIsMainThread" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<bool> output = api->DefaultIsMainThread();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "taskQueueIsBackgroundThread" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<bool> output = api->TaskQueueIsBackgroundThread();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.callFlutterNoop" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              api->CallFlutterNoop(
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(EncodableValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterThrowError" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              api->CallFlutterThrowError(
                  [reply](ErrorOr<std::optional<EncodableValue>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterThrowErrorFromVoid" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              api->CallFlutterThrowErrorFromVoid(
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(EncodableValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoAllTypes" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_everything_arg = args.at(0);
              if (encodable_everything_arg.IsNull()) {
                reply(WrapError("everything_arg unexpectedly null."));
                return;
              }
              const auto& everything_arg = std::any_cast<const AllTypes&>(
                  std::get<CustomEncodableValue>(encodable_everything_arg));
              api->CallFlutterEchoAllTypes(
                  everything_arg, [reply](ErrorOr<AllTypes>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoAllNullableTypes" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_everything_arg = args.at(0);
              const auto* everything_arg =
                  encodable_everything_arg.IsNull()
                      ? nullptr
                      : &(std::any_cast<const AllNullableTypes&>(
                            std::get<CustomEncodableValue>(
                                encodable_everything_arg)));
              api->CallFlutterEchoAllNullableTypes(
                  everything_arg,
                  [reply](ErrorOr<std::optional<AllNullableTypes>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(CustomEncodableValue(
                          std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterSendMultipleNullableTypes" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_bool_arg = args.at(0);
              const auto* a_nullable_bool_arg =
                  std::get_if<bool>(&encodable_a_nullable_bool_arg);
              const auto& encodable_a_nullable_int_arg = args.at(1);
              const auto* a_nullable_int_arg =
                  std::get_if<int64_t>(&encodable_a_nullable_int_arg);
              const auto& encodable_a_nullable_string_arg = args.at(2);
              const auto* a_nullable_string_arg =
                  std::get_if<std::string>(&encodable_a_nullable_string_arg);
              api->CallFlutterSendMultipleNullableTypes(
                  a_nullable_bool_arg, a_nullable_int_arg,
                  a_nullable_string_arg,
                  [reply](ErrorOr<AllNullableTypes>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoAllNullableTypesWithoutRecursion" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](
                                    const EncodableValue& message,
                                    const flutter::MessageReply<EncodableValue>&
                                        reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_everything_arg = args.at(0);
          const auto* everything_arg =
              encodable_everything_arg.IsNull()
                  ? nullptr
                  : &(std::any_cast<const AllNullableTypesWithoutRecursion&>(
                        std::get<CustomEncodableValue>(
                            encodable_everything_arg)));
          api->CallFlutterEchoAllNullableTypesWithoutRecursion(
              everything_arg,
              [reply](ErrorOr<std::optional<AllNullableTypesWithoutRecursion>>&&
                          output) {
                if (output.has_error()) {
                  reply(WrapError(output.error()));
                  return;
                }
                EncodableList wrapped;
                auto output_optional = std::move(output).TakeValue();
                if (output_optional) {
                  wrapped.push_back(
                      CustomEncodableValue(std::move(output_optional).value()));
                } else {
                  wrapped.push_back(EncodableValue());
                }
                reply(EncodableValue(std::move(wrapped)));
              });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterSendMultipleNullableTypesWithoutRecursion" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_nullable_bool_arg = args.at(0);
              const auto* a_nullable_bool_arg =
                  std::get_if<bool>(&encodable_a_nullable_bool_arg);
              const auto& encodable_a_nullable_int_arg = args.at(1);
              const auto* a_nullable_int_arg =
                  std::get_if<int64_t>(&encodable_a_nullable_int_arg);
              const auto& encodable_a_nullable_string_arg = args.at(2);
              const auto* a_nullable_string_arg =
                  std::get_if<std::string>(&encodable_a_nullable_string_arg);
              api->CallFlutterSendMultipleNullableTypesWithoutRecursion(
                  a_nullable_bool_arg, a_nullable_int_arg,
                  a_nullable_string_arg,
                  [reply](ErrorOr<AllNullableTypesWithoutRecursion>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.callFlutterEchoBool" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_bool_arg = args.at(0);
              if (encodable_a_bool_arg.IsNull()) {
                reply(WrapError("a_bool_arg unexpectedly null."));
                return;
              }
              const auto& a_bool_arg = std::get<bool>(encodable_a_bool_arg);
              api->CallFlutterEchoBool(
                  a_bool_arg, [reply](ErrorOr<bool>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.callFlutterEchoInt" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_int_arg = args.at(0);
              if (encodable_an_int_arg.IsNull()) {
                reply(WrapError("an_int_arg unexpectedly null."));
                return;
              }
              const int64_t an_int_arg = encodable_an_int_arg.LongValue();
              api->CallFlutterEchoInt(
                  an_int_arg, [reply](ErrorOr<int64_t>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoDouble" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_double_arg = args.at(0);
              if (encodable_a_double_arg.IsNull()) {
                reply(WrapError("a_double_arg unexpectedly null."));
                return;
              }
              const auto& a_double_arg =
                  std::get<double>(encodable_a_double_arg);
              api->CallFlutterEchoDouble(
                  a_double_arg, [reply](ErrorOr<double>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoString" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_string_arg = args.at(0);
              if (encodable_a_string_arg.IsNull()) {
                reply(WrapError("a_string_arg unexpectedly null."));
                return;
              }
              const auto& a_string_arg =
                  std::get<std::string>(encodable_a_string_arg);
              api->CallFlutterEchoString(
                  a_string_arg, [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoUint8List" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_list_arg = args.at(0);
              if (encodable_list_arg.IsNull()) {
                reply(WrapError("list_arg unexpectedly null."));
                return;
              }
              const auto& list_arg =
                  std::get<std::vector<uint8_t>>(encodable_list_arg);
              api->CallFlutterEchoUint8List(
                  list_arg, [reply](ErrorOr<std::vector<uint8_t>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.callFlutterEchoList" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_list_arg = args.at(0);
              if (encodable_list_arg.IsNull()) {
                reply(WrapError("list_arg unexpectedly null."));
                return;
              }
              const auto& list_arg =
                  std::get<EncodableList>(encodable_list_arg);
              api->CallFlutterEchoList(
                  list_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoEnumList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              if (encodable_enum_list_arg.IsNull()) {
                reply(WrapError("enum_list_arg unexpectedly null."));
                return;
              }
              const auto& enum_list_arg =
                  std::get<EncodableList>(encodable_enum_list_arg);
              api->CallFlutterEchoEnumList(
                  enum_list_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoClassList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              if (encodable_class_list_arg.IsNull()) {
                reply(WrapError("class_list_arg unexpectedly null."));
                return;
              }
              const auto& class_list_arg =
                  std::get<EncodableList>(encodable_class_list_arg);
              api->CallFlutterEchoClassList(
                  class_list_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNonNullEnumList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              if (encodable_enum_list_arg.IsNull()) {
                reply(WrapError("enum_list_arg unexpectedly null."));
                return;
              }
              const auto& enum_list_arg =
                  std::get<EncodableList>(encodable_enum_list_arg);
              api->CallFlutterEchoNonNullEnumList(
                  enum_list_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNonNullClassList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              if (encodable_class_list_arg.IsNull()) {
                reply(WrapError("class_list_arg unexpectedly null."));
                return;
              }
              const auto& class_list_arg =
                  std::get<EncodableList>(encodable_class_list_arg);
              api->CallFlutterEchoNonNullClassList(
                  class_list_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.callFlutterEchoMap" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_map_arg = args.at(0);
              if (encodable_map_arg.IsNull()) {
                reply(WrapError("map_arg unexpectedly null."));
                return;
              }
              const auto& map_arg = std::get<EncodableMap>(encodable_map_arg);
              api->CallFlutterEchoMap(
                  map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoStringMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              if (encodable_string_map_arg.IsNull()) {
                reply(WrapError("string_map_arg unexpectedly null."));
                return;
              }
              const auto& string_map_arg =
                  std::get<EncodableMap>(encodable_string_map_arg);
              api->CallFlutterEchoStringMap(
                  string_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoIntMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              if (encodable_int_map_arg.IsNull()) {
                reply(WrapError("int_map_arg unexpectedly null."));
                return;
              }
              const auto& int_map_arg =
                  std::get<EncodableMap>(encodable_int_map_arg);
              api->CallFlutterEchoIntMap(
                  int_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoEnumMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              if (encodable_enum_map_arg.IsNull()) {
                reply(WrapError("enum_map_arg unexpectedly null."));
                return;
              }
              const auto& enum_map_arg =
                  std::get<EncodableMap>(encodable_enum_map_arg);
              api->CallFlutterEchoEnumMap(
                  enum_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoClassMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              if (encodable_class_map_arg.IsNull()) {
                reply(WrapError("class_map_arg unexpectedly null."));
                return;
              }
              const auto& class_map_arg =
                  std::get<EncodableMap>(encodable_class_map_arg);
              api->CallFlutterEchoClassMap(
                  class_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNonNullStringMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              if (encodable_string_map_arg.IsNull()) {
                reply(WrapError("string_map_arg unexpectedly null."));
                return;
              }
              const auto& string_map_arg =
                  std::get<EncodableMap>(encodable_string_map_arg);
              api->CallFlutterEchoNonNullStringMap(
                  string_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNonNullIntMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              if (encodable_int_map_arg.IsNull()) {
                reply(WrapError("int_map_arg unexpectedly null."));
                return;
              }
              const auto& int_map_arg =
                  std::get<EncodableMap>(encodable_int_map_arg);
              api->CallFlutterEchoNonNullIntMap(
                  int_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNonNullEnumMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              if (encodable_enum_map_arg.IsNull()) {
                reply(WrapError("enum_map_arg unexpectedly null."));
                return;
              }
              const auto& enum_map_arg =
                  std::get<EncodableMap>(encodable_enum_map_arg);
              api->CallFlutterEchoNonNullEnumMap(
                  enum_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNonNullClassMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              if (encodable_class_map_arg.IsNull()) {
                reply(WrapError("class_map_arg unexpectedly null."));
                return;
              }
              const auto& class_map_arg =
                  std::get<EncodableMap>(encodable_class_map_arg);
              api->CallFlutterEchoNonNullClassMap(
                  class_map_arg, [reply](ErrorOr<EncodableMap>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.pigeon_integration_tests."
                                  "HostIntegrationCoreApi.callFlutterEchoEnum" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_enum_arg = args.at(0);
              if (encodable_an_enum_arg.IsNull()) {
                reply(WrapError("an_enum_arg unexpectedly null."));
                return;
              }
              const auto& an_enum_arg = std::any_cast<const AnEnum&>(
                  std::get<CustomEncodableValue>(encodable_an_enum_arg));
              api->CallFlutterEchoEnum(
                  an_enum_arg, [reply](ErrorOr<AnEnum>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoAnotherEnum" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_another_enum_arg = args.at(0);
              if (encodable_another_enum_arg.IsNull()) {
                reply(WrapError("another_enum_arg unexpectedly null."));
                return;
              }
              const auto& another_enum_arg = std::any_cast<const AnotherEnum&>(
                  std::get<CustomEncodableValue>(encodable_another_enum_arg));
              api->CallFlutterEchoAnotherEnum(
                  another_enum_arg, [reply](ErrorOr<AnotherEnum>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableBool" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_bool_arg = args.at(0);
              const auto* a_bool_arg = std::get_if<bool>(&encodable_a_bool_arg);
              api->CallFlutterEchoNullableBool(
                  a_bool_arg, [reply](ErrorOr<std::optional<bool>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableInt" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_int_arg = args.at(0);
              const auto* an_int_arg =
                  std::get_if<int64_t>(&encodable_an_int_arg);
              api->CallFlutterEchoNullableInt(
                  an_int_arg,
                  [reply](ErrorOr<std::optional<int64_t>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableDouble" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_double_arg = args.at(0);
              const auto* a_double_arg =
                  std::get_if<double>(&encodable_a_double_arg);
              api->CallFlutterEchoNullableDouble(
                  a_double_arg,
                  [reply](ErrorOr<std::optional<double>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableString" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_string_arg = args.at(0);
              const auto* a_string_arg =
                  std::get_if<std::string>(&encodable_a_string_arg);
              api->CallFlutterEchoNullableString(
                  a_string_arg,
                  [reply](ErrorOr<std::optional<std::string>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableUint8List" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_list_arg = args.at(0);
              const auto* list_arg =
                  std::get_if<std::vector<uint8_t>>(&encodable_list_arg);
              api->CallFlutterEchoNullableUint8List(
                  list_arg,
                  [reply](
                      ErrorOr<std::optional<std::vector<uint8_t>>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_list_arg = args.at(0);
              const auto* list_arg =
                  std::get_if<EncodableList>(&encodable_list_arg);
              api->CallFlutterEchoNullableList(
                  list_arg,
                  [reply](ErrorOr<std::optional<EncodableList>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableEnumList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              const auto* enum_list_arg =
                  std::get_if<EncodableList>(&encodable_enum_list_arg);
              api->CallFlutterEchoNullableEnumList(
                  enum_list_arg,
                  [reply](ErrorOr<std::optional<EncodableList>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableClassList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              const auto* class_list_arg =
                  std::get_if<EncodableList>(&encodable_class_list_arg);
              api->CallFlutterEchoNullableClassList(
                  class_list_arg,
                  [reply](ErrorOr<std::optional<EncodableList>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableNonNullEnumList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_list_arg = args.at(0);
              const auto* enum_list_arg =
                  std::get_if<EncodableList>(&encodable_enum_list_arg);
              api->CallFlutterEchoNullableNonNullEnumList(
                  enum_list_arg,
                  [reply](ErrorOr<std::optional<EncodableList>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableNonNullClassList" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_list_arg = args.at(0);
              const auto* class_list_arg =
                  std::get_if<EncodableList>(&encodable_class_list_arg);
              api->CallFlutterEchoNullableNonNullClassList(
                  class_list_arg,
                  [reply](ErrorOr<std::optional<EncodableList>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_map_arg = args.at(0);
              const auto* map_arg =
                  std::get_if<EncodableMap>(&encodable_map_arg);
              api->CallFlutterEchoNullableMap(
                  map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableStringMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              const auto* string_map_arg =
                  std::get_if<EncodableMap>(&encodable_string_map_arg);
              api->CallFlutterEchoNullableStringMap(
                  string_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableIntMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              const auto* int_map_arg =
                  std::get_if<EncodableMap>(&encodable_int_map_arg);
              api->CallFlutterEchoNullableIntMap(
                  int_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableEnumMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              const auto* enum_map_arg =
                  std::get_if<EncodableMap>(&encodable_enum_map_arg);
              api->CallFlutterEchoNullableEnumMap(
                  enum_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableClassMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              const auto* class_map_arg =
                  std::get_if<EncodableMap>(&encodable_class_map_arg);
              api->CallFlutterEchoNullableClassMap(
                  class_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableNonNullStringMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_string_map_arg = args.at(0);
              const auto* string_map_arg =
                  std::get_if<EncodableMap>(&encodable_string_map_arg);
              api->CallFlutterEchoNullableNonNullStringMap(
                  string_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableNonNullIntMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_int_map_arg = args.at(0);
              const auto* int_map_arg =
                  std::get_if<EncodableMap>(&encodable_int_map_arg);
              api->CallFlutterEchoNullableNonNullIntMap(
                  int_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableNonNullEnumMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enum_map_arg = args.at(0);
              const auto* enum_map_arg =
                  std::get_if<EncodableMap>(&encodable_enum_map_arg);
              api->CallFlutterEchoNullableNonNullEnumMap(
                  enum_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableNonNullClassMap" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_class_map_arg = args.at(0);
              const auto* class_map_arg =
                  std::get_if<EncodableMap>(&encodable_class_map_arg);
              api->CallFlutterEchoNullableNonNullClassMap(
                  class_map_arg,
                  [reply](ErrorOr<std::optional<EncodableMap>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoNullableEnum" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_an_enum_arg = args.at(0);
              AnEnum an_enum_arg_value;
              const AnEnum* an_enum_arg = nullptr;
              if (!encodable_an_enum_arg.IsNull()) {
                an_enum_arg_value = std::any_cast<const AnEnum&>(
                    std::get<CustomEncodableValue>(encodable_an_enum_arg));
                an_enum_arg = &an_enum_arg_value;
              }
              api->CallFlutterEchoNullableEnum(
                  an_enum_arg ? &(*an_enum_arg) : nullptr,
                  [reply](ErrorOr<std::optional<AnEnum>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(CustomEncodableValue(
                          std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterEchoAnotherNullableEnum" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_another_enum_arg = args.at(0);
              AnotherEnum another_enum_arg_value;
              const AnotherEnum* another_enum_arg = nullptr;
              if (!encodable_another_enum_arg.IsNull()) {
                another_enum_arg_value = std::any_cast<const AnotherEnum&>(
                    std::get<CustomEncodableValue>(encodable_another_enum_arg));
                another_enum_arg = &another_enum_arg_value;
              }
              api->CallFlutterEchoAnotherNullableEnum(
                  another_enum_arg ? &(*another_enum_arg) : nullptr,
                  [reply](ErrorOr<std::optional<AnotherEnum>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(CustomEncodableValue(
                          std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
        "callFlutterSmallApiEchoString" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_string_arg = args.at(0);
              if (encodable_a_string_arg.IsNull()) {
                reply(WrapError("a_string_arg unexpectedly null."));
                return;
              }
              const auto& a_string_arg =
                  std::get<std::string>(encodable_a_string_arg);
              api->CallFlutterSmallApiEchoString(
                  a_string_arg, [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
}

EncodableValue HostIntegrationCoreApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue HostIntegrationCoreApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
FlutterIntegrationCoreApi::FlutterIntegrationCoreApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger), message_channel_suffix_("") {}

FlutterIntegrationCoreApi::FlutterIntegrationCoreApi(
    flutter::BinaryMessenger* binary_messenger,
    const std::string& message_channel_suffix)
    : binary_messenger_(binary_messenger),
      message_channel_suffix_(message_channel_suffix.length() > 0
                                  ? std::string(".") + message_channel_suffix
                                  : "") {}

const flutter::StandardMessageCodec& FlutterIntegrationCoreApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &PigeonInternalCodecSerializer::GetInstance());
}

void FlutterIntegrationCoreApi::Noop(
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "noop" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue();
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            on_success();
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::ThrowError(
    std::function<void(const EncodableValue*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "throwError" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue();
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value = &list_return_value->at(0);
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::ThrowErrorFromVoid(
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "throwErrorFromVoid" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue();
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            on_success();
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoAllTypes(
    const AllTypes& everything_arg,
    std::function<void(const AllTypes&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoAllTypes" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      CustomEncodableValue(everything_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value = std::any_cast<const AllTypes&>(
                std::get<CustomEncodableValue>(list_return_value->at(0)));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoAllNullableTypes(
    const AllNullableTypes* everything_arg,
    std::function<void(const AllNullableTypes*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoAllNullableTypes" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      everything_arg ? CustomEncodableValue(*everything_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                list_return_value->at(0).IsNull()
                    ? nullptr
                    : &(std::any_cast<const AllNullableTypes&>(
                          std::get<CustomEncodableValue>(
                              list_return_value->at(0))));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::SendMultipleNullableTypes(
    const bool* a_nullable_bool_arg, const int64_t* a_nullable_int_arg,
    const std::string* a_nullable_string_arg,
    std::function<void(const AllNullableTypes&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "sendMultipleNullableTypes" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      a_nullable_bool_arg ? EncodableValue(*a_nullable_bool_arg)
                          : EncodableValue(),
      a_nullable_int_arg ? EncodableValue(*a_nullable_int_arg)
                         : EncodableValue(),
      a_nullable_string_arg ? EncodableValue(*a_nullable_string_arg)
                            : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value = std::any_cast<const AllNullableTypes&>(
                std::get<CustomEncodableValue>(list_return_value->at(0)));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoAllNullableTypesWithoutRecursion(
    const AllNullableTypesWithoutRecursion* everything_arg,
    std::function<void(const AllNullableTypesWithoutRecursion*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoAllNullableTypesWithoutRecursion" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      everything_arg ? CustomEncodableValue(*everything_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                list_return_value->at(0).IsNull()
                    ? nullptr
                    : &(std::any_cast<const AllNullableTypesWithoutRecursion&>(
                          std::get<CustomEncodableValue>(
                              list_return_value->at(0))));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::SendMultipleNullableTypesWithoutRecursion(
    const bool* a_nullable_bool_arg, const int64_t* a_nullable_int_arg,
    const std::string* a_nullable_string_arg,
    std::function<void(const AllNullableTypesWithoutRecursion&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "sendMultipleNullableTypesWithoutRecursion" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      a_nullable_bool_arg ? EncodableValue(*a_nullable_bool_arg)
                          : EncodableValue(),
      a_nullable_int_arg ? EncodableValue(*a_nullable_int_arg)
                         : EncodableValue(),
      a_nullable_string_arg ? EncodableValue(*a_nullable_string_arg)
                            : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::any_cast<const AllNullableTypesWithoutRecursion&>(
                    std::get<CustomEncodableValue>(list_return_value->at(0)));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoBool(
    bool a_bool_arg, std::function<void(bool)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoBool" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(a_bool_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value = std::get<bool>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoInt(
    int64_t an_int_arg, std::function<void(int64_t)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoInt" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(an_int_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const int64_t return_value = list_return_value->at(0).LongValue();
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoDouble(
    double a_double_arg, std::function<void(double)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoDouble" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(a_double_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name,
                                       on_success = std::move(on_success),
                                       on_error = std::move(on_error)](
                                          const uint8_t* reply,
                                          size_t reply_size) {
    std::unique_ptr<EncodableValue> response =
        GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value =
        std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)),
                              std::get<std::string>(list_return_value->at(1)),
                              list_return_value->at(2)));
      } else {
        const auto& return_value = std::get<double>(list_return_value->at(0));
        on_success(return_value);
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    }
  });
}

void FlutterIntegrationCoreApi::EchoString(
    const std::string& a_string_arg,
    std::function<void(const std::string&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoString" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(a_string_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<std::string>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoUint8List(
    const std::vector<uint8_t>& list_arg,
    std::function<void(const std::vector<uint8_t>&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoUint8List" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(list_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<std::vector<uint8_t>>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoList(
    const EncodableList& list_arg,
    std::function<void(const EncodableList&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(list_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableList>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoEnumList(
    const EncodableList& enum_list_arg,
    std::function<void(const EncodableList&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoEnumList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(enum_list_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableList>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoClassList(
    const EncodableList& class_list_arg,
    std::function<void(const EncodableList&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoClassList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(class_list_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableList>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNonNullEnumList(
    const EncodableList& enum_list_arg,
    std::function<void(const EncodableList&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNonNullEnumList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(enum_list_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableList>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNonNullClassList(
    const EncodableList& class_list_arg,
    std::function<void(const EncodableList&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNonNullClassList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(class_list_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableList>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoMap(
    const EncodableMap& map_arg,
    std::function<void(const EncodableMap&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(map_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableMap>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoStringMap(
    const EncodableMap& string_map_arg,
    std::function<void(const EncodableMap&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoStringMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(string_map_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableMap>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoIntMap(
    const EncodableMap& int_map_arg,
    std::function<void(const EncodableMap&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoIntMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(int_map_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableMap>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoEnumMap(
    const EncodableMap& enum_map_arg,
    std::function<void(const EncodableMap&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoEnumMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(enum_map_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableMap>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoClassMap(
    const EncodableMap& class_map_arg,
    std::function<void(const EncodableMap&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoClassMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(class_map_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableMap>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNonNullStringMap(
    const EncodableMap& string_map_arg,
    std::function<void(const EncodableMap&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNonNullStringMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(string_map_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableMap>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNonNullIntMap(
    const EncodableMap& int_map_arg,
    std::function<void(const EncodableMap&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNonNullIntMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(int_map_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableMap>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNonNullEnumMap(
    const EncodableMap& enum_map_arg,
    std::function<void(const EncodableMap&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNonNullEnumMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(enum_map_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableMap>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNonNullClassMap(
    const EncodableMap& class_map_arg,
    std::function<void(const EncodableMap&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNonNullClassMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(class_map_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<EncodableMap>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoEnum(
    const AnEnum& an_enum_arg, std::function<void(const AnEnum&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoEnum" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      CustomEncodableValue(an_enum_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value = std::any_cast<const AnEnum&>(
                std::get<CustomEncodableValue>(list_return_value->at(0)));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoAnotherEnum(
    const AnotherEnum& another_enum_arg,
    std::function<void(const AnotherEnum&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoAnotherEnum" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      CustomEncodableValue(another_enum_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value = std::any_cast<const AnotherEnum&>(
                std::get<CustomEncodableValue>(list_return_value->at(0)));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableBool(
    const bool* a_bool_arg, std::function<void(const bool*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableBool" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      a_bool_arg ? EncodableValue(*a_bool_arg) : EncodableValue(),
  });
  channel.Send(encoded_api_arguments, [channel_name,
                                       on_success = std::move(on_success),
                                       on_error = std::move(on_error)](
                                          const uint8_t* reply,
                                          size_t reply_size) {
    std::unique_ptr<EncodableValue> response =
        GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value =
        std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)),
                              std::get<std::string>(list_return_value->at(1)),
                              list_return_value->at(2)));
      } else {
        const auto* return_value = std::get_if<bool>(&list_return_value->at(0));
        on_success(return_value);
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    }
  });
}

void FlutterIntegrationCoreApi::EchoNullableInt(
    const int64_t* an_int_arg, std::function<void(const int64_t*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableInt" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      an_int_arg ? EncodableValue(*an_int_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<int64_t>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableDouble(
    const double* a_double_arg, std::function<void(const double*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableDouble" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      a_double_arg ? EncodableValue(*a_double_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<double>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableString(
    const std::string* a_string_arg,
    std::function<void(const std::string*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableString" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      a_string_arg ? EncodableValue(*a_string_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<std::string>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableUint8List(
    const std::vector<uint8_t>* list_arg,
    std::function<void(const std::vector<uint8_t>*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableUint8List" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      list_arg ? EncodableValue(*list_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<std::vector<uint8_t>>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableList(
    const EncodableList* list_arg,
    std::function<void(const EncodableList*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      list_arg ? EncodableValue(*list_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableList>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableEnumList(
    const EncodableList* enum_list_arg,
    std::function<void(const EncodableList*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableEnumList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      enum_list_arg ? EncodableValue(*enum_list_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableList>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableClassList(
    const EncodableList* class_list_arg,
    std::function<void(const EncodableList*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableClassList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      class_list_arg ? EncodableValue(*class_list_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableList>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableNonNullEnumList(
    const EncodableList* enum_list_arg,
    std::function<void(const EncodableList*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableNonNullEnumList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      enum_list_arg ? EncodableValue(*enum_list_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableList>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableNonNullClassList(
    const EncodableList* class_list_arg,
    std::function<void(const EncodableList*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableNonNullClassList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      class_list_arg ? EncodableValue(*class_list_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableList>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableMap(
    const EncodableMap* map_arg,
    std::function<void(const EncodableMap*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      map_arg ? EncodableValue(*map_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableMap>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableStringMap(
    const EncodableMap* string_map_arg,
    std::function<void(const EncodableMap*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableStringMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      string_map_arg ? EncodableValue(*string_map_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableMap>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableIntMap(
    const EncodableMap* int_map_arg,
    std::function<void(const EncodableMap*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableIntMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      int_map_arg ? EncodableValue(*int_map_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableMap>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableEnumMap(
    const EncodableMap* enum_map_arg,
    std::function<void(const EncodableMap*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableEnumMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      enum_map_arg ? EncodableValue(*enum_map_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableMap>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableClassMap(
    const EncodableMap* class_map_arg,
    std::function<void(const EncodableMap*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableClassMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      class_map_arg ? EncodableValue(*class_map_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableMap>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableNonNullStringMap(
    const EncodableMap* string_map_arg,
    std::function<void(const EncodableMap*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableNonNullStringMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      string_map_arg ? EncodableValue(*string_map_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableMap>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableNonNullIntMap(
    const EncodableMap* int_map_arg,
    std::function<void(const EncodableMap*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableNonNullIntMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      int_map_arg ? EncodableValue(*int_map_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableMap>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableNonNullEnumMap(
    const EncodableMap* enum_map_arg,
    std::function<void(const EncodableMap*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableNonNullEnumMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      enum_map_arg ? EncodableValue(*enum_map_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableMap>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableNonNullClassMap(
    const EncodableMap* class_map_arg,
    std::function<void(const EncodableMap*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableNonNullClassMap" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      class_map_arg ? EncodableValue(*class_map_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto* return_value =
                std::get_if<EncodableMap>(&list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoNullableEnum(
    const AnEnum* an_enum_arg, std::function<void(const AnEnum*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoNullableEnum" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      an_enum_arg ? CustomEncodableValue(*an_enum_arg) : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            AnEnum return_value_value;
            const AnEnum* return_value = nullptr;
            if (!list_return_value->at(0).IsNull()) {
              return_value_value = std::any_cast<const AnEnum&>(
                  std::get<CustomEncodableValue>(list_return_value->at(0)));
              return_value = &return_value_value;
            }
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoAnotherNullableEnum(
    const AnotherEnum* another_enum_arg,
    std::function<void(const AnotherEnum*)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoAnotherNullableEnum" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      another_enum_arg ? CustomEncodableValue(*another_enum_arg)
                       : EncodableValue(),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            AnotherEnum return_value_value;
            const AnotherEnum* return_value = nullptr;
            if (!list_return_value->at(0).IsNull()) {
              return_value_value = std::any_cast<const AnotherEnum&>(
                  std::get<CustomEncodableValue>(list_return_value->at(0)));
              return_value = &return_value_value;
            }
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::NoopAsync(
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "noopAsync" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue();
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            on_success();
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterIntegrationCoreApi::EchoAsyncString(
    const std::string& a_string_arg,
    std::function<void(const std::string&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterIntegrationCoreApi."
      "echoAsyncString" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(a_string_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<std::string>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

/// The codec used by HostTrivialApi.
const flutter::StandardMessageCodec& HostTrivialApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &PigeonInternalCodecSerializer::GetInstance());
}

// Sets up an instance of `HostTrivialApi` to handle messages through the
// `binary_messenger`.
void HostTrivialApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                           HostTrivialApi* api) {
  HostTrivialApi::SetUp(binary_messenger, api, "");
}

void HostTrivialApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                           HostTrivialApi* api,
                           const std::string& message_channel_suffix) {
  const std::string prepended_suffix =
      message_channel_suffix.length() > 0
          ? std::string(".") + message_channel_suffix
          : "";
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostTrivialApi.noop" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              std::optional<FlutterError> output = api->Noop();
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
}

EncodableValue HostTrivialApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue HostTrivialApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

/// The codec used by HostSmallApi.
const flutter::StandardMessageCodec& HostSmallApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &PigeonInternalCodecSerializer::GetInstance());
}

// Sets up an instance of `HostSmallApi` to handle messages through the
// `binary_messenger`.
void HostSmallApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                         HostSmallApi* api) {
  HostSmallApi::SetUp(binary_messenger, api, "");
}

void HostSmallApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                         HostSmallApi* api,
                         const std::string& message_channel_suffix) {
  const std::string prepended_suffix =
      message_channel_suffix.length() > 0
          ? std::string(".") + message_channel_suffix
          : "";
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostSmallApi.echo" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_a_string_arg = args.at(0);
              if (encodable_a_string_arg.IsNull()) {
                reply(WrapError("a_string_arg unexpectedly null."));
                return;
              }
              const auto& a_string_arg =
                  std::get<std::string>(encodable_a_string_arg);
              api->Echo(a_string_arg, [reply](ErrorOr<std::string>&& output) {
                if (output.has_error()) {
                  reply(WrapError(output.error()));
                  return;
                }
                EncodableList wrapped;
                wrapped.push_back(
                    EncodableValue(std::move(output).TakeValue()));
                reply(EncodableValue(std::move(wrapped)));
              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.pigeon_integration_tests.HostSmallApi.voidVoid" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              api->VoidVoid([reply](std::optional<FlutterError>&& output) {
                if (output.has_value()) {
                  reply(WrapError(output.value()));
                  return;
                }
                EncodableList wrapped;
                wrapped.push_back(EncodableValue());
                reply(EncodableValue(std::move(wrapped)));
              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
}

EncodableValue HostSmallApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue HostSmallApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
FlutterSmallApi::FlutterSmallApi(flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger), message_channel_suffix_("") {}

FlutterSmallApi::FlutterSmallApi(flutter::BinaryMessenger* binary_messenger,
                                 const std::string& message_channel_suffix)
    : binary_messenger_(binary_messenger),
      message_channel_suffix_(message_channel_suffix.length() > 0
                                  ? std::string(".") + message_channel_suffix
                                  : "") {}

const flutter::StandardMessageCodec& FlutterSmallApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &PigeonInternalCodecSerializer::GetInstance());
}

void FlutterSmallApi::EchoWrappedList(
    const TestMessage& msg_arg,
    std::function<void(const TestMessage&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterSmallApi."
      "echoWrappedList" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      CustomEncodableValue(msg_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value = std::any_cast<const TestMessage&>(
                std::get<CustomEncodableValue>(list_return_value->at(0)));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

void FlutterSmallApi::EchoString(
    const std::string& a_string_arg,
    std::function<void(const std::string&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name =
      "dev.flutter.pigeon.pigeon_integration_tests.FlutterSmallApi.echoString" +
      message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(a_string_arg),
  });
  channel.Send(
      encoded_api_arguments, [channel_name, on_success = std::move(on_success),
                              on_error = std::move(on_error)](
                                 const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto* list_return_value =
            std::get_if<EncodableList>(&encodable_return_value);
        if (list_return_value) {
          if (list_return_value->size() > 1) {
            on_error(
                FlutterError(std::get<std::string>(list_return_value->at(0)),
                             std::get<std::string>(list_return_value->at(1)),
                             list_return_value->at(2)));
          } else {
            const auto& return_value =
                std::get<std::string>(list_return_value->at(0));
            on_success(return_value);
          }
        } else {
          on_error(CreateConnectionError(channel_name));
        }
      });
}

}  // namespace core_tests_pigeontest
