# FFIgen testing

## Running Tests

1.  Some tests require that dynamic libraries be built before running the tests.
    You can do so with:

    ```shell
    dart run test/setup.dart
    ```

2.  Run the tests with:

    ```shell
    dart test
    ```

## Development

Some tests verify that the generated Dart FFI bindings match a golden file.

For example, the test
[`test/native_test/native_test.dart`](https://github.com/dart-lang/native/tree/main/pkgs/ffigen/test/native_test/native_test.dart)
works by:

1.  Loading the dynamic library for
    [`test/native_test/native_test.c`](https://github.com/dart-lang/native/tree/main/pkgs/ffigen/test/native_test/native_test.c)
    (which was generated by `dart run test/setup.dart`).

2.  Generating binding files for that dynamic library in the
    `test/debug_generated` directory.

3.  Comparing the golden file (i.e.
    [`test/native_test/_expected_native_test_bindings.dart`](https://github.com/dart-lang/native/tree/main/pkgs/ffigen/test/native_test/_expected_native_test_bindings.dart))
    to the generated file and generating a test failure if they do not match.

4.  Using the *golden* bindings to excercise the dynamic library.

If you modify any source for a dynamic library (e.g. any `.c`, `.h` or `.m`
files), then you should run:

```shell
   dart run test/setup.dart  # Rebuild the dynamic libraries.
   dart run test/regen.dart  # Rebuild the golden FFI bindings.
```

If you modify any code that changes how FFI bindings are generated, then you
should run:

  ```shell
  dart run test/regen.dart  # Rebuild the golden FFI bindings.
  ```

A conservative way to run tests is with:

  ```shell
  dart run test/setup.dart && dart run test/regen.dart && dart test
  ```

> Note: you should verify that the changes to the golden bindings are
> reasonable with `git diff`.
