// Copyright (c) 2024, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint, unused_import
import 'dart:ffi' as ffi;
import 'package:objective_c/objective_c.dart' as objc;
import 'package:ffi/ffi.dart' as pkg_ffi;

final class AudioStreamBasicDescription extends ffi.Opaque {}

final class AudioChannelLayout extends ffi.Opaque {}

final class opaqueCMFormatDescription extends ffi.Opaque {}

enum AVAudioCommonFormat {
  AVAudioOtherFormat(0),
  AVAudioPCMFormatFloat32(1),
  AVAudioPCMFormatFloat64(2),
  AVAudioPCMFormatInt16(3),
  AVAudioPCMFormatInt32(4);

  final int value;
  const AVAudioCommonFormat(this.value);

  static AVAudioCommonFormat fromValue(int value) => switch (value) {
    0 => AVAudioOtherFormat,
    1 => AVAudioPCMFormatFloat32,
    2 => AVAudioPCMFormatFloat64,
    3 => AVAudioPCMFormatInt16,
    4 => AVAudioPCMFormatInt32,
    _ => throw ArgumentError('Unknown value for AVAudioCommonFormat: $value'),
  };
}

/// WARNING: AVAudioFormat is a stub. To generate bindings for this class, include
/// AVAudioFormat in your config's objc-interfaces list.
///
/// AVAudioFormat
extension type AVAudioFormat._(objc.ObjCObject object$)
    implements objc.ObjCObject, objc.NSObject, objc.NSSecureCoding {
  /// Constructs a [AVAudioFormat] that points to the same underlying object as [other].
  AVAudioFormat.as(objc.ObjCObject other) : object$ = other {
    objc.checkOsVersionInternal(
      'AVAudioFormat',
      iOS: (false, (8, 0, 0)),
      macOS: (false, (10, 10, 0)),
    );
  }

  /// Constructs a [AVAudioFormat] that wraps the given raw object pointer.
  AVAudioFormat.fromPointer(
    ffi.Pointer<objc.ObjCObjectImpl> other, {
    bool retain = false,
    bool release = false,
  }) : object$ = objc.ObjCObject(other, retain: retain, release: release) {
    objc.checkOsVersionInternal(
      'AVAudioFormat',
      iOS: (false, (8, 0, 0)),
      macOS: (false, (10, 10, 0)),
    );
  }
}

late final _class_AVAudioPlayer = objc.getClass("AVAudioPlayer");
late final _sel_isKindOfClass_ = objc.registerName("isKindOfClass:");
final _objc_msgSend_19nvye5 = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Bool Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Pointer<objc.ObjCObjectImpl>,
        )
      >
    >()
    .asFunction<
      bool Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        ffi.Pointer<objc.ObjCObjectImpl>,
      )
    >();
typedef instancetype = ffi.Pointer<objc.ObjCObjectImpl>;
typedef Dartinstancetype = objc.ObjCObject;
late final _sel_initWithContentsOfURL_error_ = objc.registerName(
  "initWithContentsOfURL:error:",
);
final _objc_msgSend_1lhpu4m = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Pointer<objc.ObjCObjectImpl> Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<ffi.Pointer<objc.ObjCObjectImpl>>,
        )
      >
    >()
    .asFunction<
      ffi.Pointer<objc.ObjCObjectImpl> Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<ffi.Pointer<objc.ObjCObjectImpl>>,
      )
    >();
late final _sel_initWithData_error_ = objc.registerName("initWithData:error:");
late final _sel_initWithContentsOfURL_fileTypeHint_error_ = objc.registerName(
  "initWithContentsOfURL:fileTypeHint:error:",
);
final _objc_msgSend_1pnyuds = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Pointer<objc.ObjCObjectImpl> Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<ffi.Pointer<objc.ObjCObjectImpl>>,
        )
      >
    >()
    .asFunction<
      ffi.Pointer<objc.ObjCObjectImpl> Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<ffi.Pointer<objc.ObjCObjectImpl>>,
      )
    >();
late final _sel_initWithData_fileTypeHint_error_ = objc.registerName(
  "initWithData:fileTypeHint:error:",
);
late final _sel_prepareToPlay = objc.registerName("prepareToPlay");
final _objc_msgSend_91o635 = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Bool Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
        )
      >
    >()
    .asFunction<
      bool Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
      )
    >();
late final _sel_play = objc.registerName("play");
late final _sel_playAtTime_ = objc.registerName("playAtTime:");
final _objc_msgSend_18chyc = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Bool Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Double,
        )
      >
    >()
    .asFunction<
      bool Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        double,
      )
    >();
late final _sel_pause = objc.registerName("pause");
final _objc_msgSend_1pl9qdv = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Void Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
        )
      >
    >()
    .asFunction<
      void Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
      )
    >();
late final _sel_stop = objc.registerName("stop");
late final _sel_isPlaying = objc.registerName("isPlaying");
late final _sel_numberOfChannels = objc.registerName("numberOfChannels");
final _objc_msgSend_xw2lbc = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.UnsignedLong Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
        )
      >
    >()
    .asFunction<
      int Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
      )
    >();
late final _sel_duration = objc.registerName("duration");
final _objc_msgSend_1ukqyt8 = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Double Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
        )
      >
    >()
    .asFunction<
      double Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
      )
    >();
final _objc_msgSend_1ukqyt8Fpret = objc.msgSendFpretPointer
    .cast<
      ffi.NativeFunction<
        ffi.Double Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
        )
      >
    >()
    .asFunction<
      double Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
      )
    >();
late final _sel_currentDevice = objc.registerName("currentDevice");
final _objc_msgSend_151sglz = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Pointer<objc.ObjCObjectImpl> Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
        )
      >
    >()
    .asFunction<
      ffi.Pointer<objc.ObjCObjectImpl> Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
      )
    >();
late final _sel_setCurrentDevice_ = objc.registerName("setCurrentDevice:");
final _objc_msgSend_xtuoz7 = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Void Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Pointer<objc.ObjCObjectImpl>,
        )
      >
    >()
    .asFunction<
      void Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        ffi.Pointer<objc.ObjCObjectImpl>,
      )
    >();

/// WARNING: AVAudioPlayerDelegate is a stub. To generate bindings for this class, include
/// AVAudioPlayerDelegate in your config's objc-protocols list.
///
/// AVAudioPlayerDelegate
extension type AVAudioPlayerDelegate._(objc.ObjCProtocol object$)
    implements objc.ObjCProtocol, objc.NSObjectProtocol {
  /// Constructs a [AVAudioPlayerDelegate] that points to the same underlying object as [other].
  AVAudioPlayerDelegate.as(objc.ObjCObject other) : object$ = other;

  /// Constructs a [AVAudioPlayerDelegate] that wraps the given raw object pointer.
  AVAudioPlayerDelegate.fromPointer(
    ffi.Pointer<objc.ObjCObjectImpl> other, {
    bool retain = false,
    bool release = false,
  }) : object$ = objc.ObjCProtocol(other, retain: retain, release: release);
}

late final _sel_delegate = objc.registerName("delegate");
late final _sel_setDelegate_ = objc.registerName("setDelegate:");
late final _sel_url = objc.registerName("url");
late final _sel_data = objc.registerName("data");
late final _sel_pan = objc.registerName("pan");
final _objc_msgSend_2cgrxl = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Float Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
        )
      >
    >()
    .asFunction<
      double Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
      )
    >();
final _objc_msgSend_2cgrxlFpret = objc.msgSendFpretPointer
    .cast<
      ffi.NativeFunction<
        ffi.Float Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
        )
      >
    >()
    .asFunction<
      double Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
      )
    >();
late final _sel_setPan_ = objc.registerName("setPan:");
final _objc_msgSend_v5hmet = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Void Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Float,
        )
      >
    >()
    .asFunction<
      void Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        double,
      )
    >();
late final _sel_volume = objc.registerName("volume");
late final _sel_setVolume_ = objc.registerName("setVolume:");
late final _sel_setVolume_fadeDuration_ = objc.registerName(
  "setVolume:fadeDuration:",
);
final _objc_msgSend_1p4uk9e = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Void Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Float,
          ffi.Double,
        )
      >
    >()
    .asFunction<
      void Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        double,
        double,
      )
    >();
late final _sel_enableRate = objc.registerName("enableRate");
late final _sel_setEnableRate_ = objc.registerName("setEnableRate:");
final _objc_msgSend_1s56lr9 = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Void Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Bool,
        )
      >
    >()
    .asFunction<
      void Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        bool,
      )
    >();
late final _sel_rate = objc.registerName("rate");
late final _sel_setRate_ = objc.registerName("setRate:");
late final _sel_currentTime = objc.registerName("currentTime");
late final _sel_setCurrentTime_ = objc.registerName("setCurrentTime:");
final _objc_msgSend_hwm8nu = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Void Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Double,
        )
      >
    >()
    .asFunction<
      void Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        double,
      )
    >();
late final _sel_deviceCurrentTime = objc.registerName("deviceCurrentTime");
late final _sel_numberOfLoops = objc.registerName("numberOfLoops");
final _objc_msgSend_1hz7y9r = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Long Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
        )
      >
    >()
    .asFunction<
      int Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
      )
    >();
late final _sel_setNumberOfLoops_ = objc.registerName("setNumberOfLoops:");
final _objc_msgSend_4sp4xj = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Void Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Long,
        )
      >
    >()
    .asFunction<
      void Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        int,
      )
    >();
late final _sel_settings = objc.registerName("settings");
late final _sel_format = objc.registerName("format");
late final _sel_isMeteringEnabled = objc.registerName("isMeteringEnabled");
late final _sel_setMeteringEnabled_ = objc.registerName("setMeteringEnabled:");
late final _sel_updateMeters = objc.registerName("updateMeters");
late final _sel_peakPowerForChannel_ = objc.registerName(
  "peakPowerForChannel:",
);
final _objc_msgSend_65s5yw = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Float Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.UnsignedLong,
        )
      >
    >()
    .asFunction<
      double Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        int,
      )
    >();
final _objc_msgSend_65s5ywFpret = objc.msgSendFpretPointer
    .cast<
      ffi.NativeFunction<
        ffi.Float Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.UnsignedLong,
        )
      >
    >()
    .asFunction<
      double Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        int,
      )
    >();
late final _sel_averagePowerForChannel_ = objc.registerName(
  "averagePowerForChannel:",
);
late final _sel_channelAssignments = objc.registerName("channelAssignments");
late final _sel_setChannelAssignments_ = objc.registerName(
  "setChannelAssignments:",
);

/// WARNING: CASpatialAudioExperience is a stub. To generate bindings for this class, include
/// CASpatialAudioExperience in your config's objc-interfaces list.
///
/// CASpatialAudioExperience
extension type CASpatialAudioExperience._(objc.ObjCObject object$)
    implements objc.ObjCObject {
  /// Constructs a [CASpatialAudioExperience] that points to the same underlying object as [other].
  CASpatialAudioExperience.as(objc.ObjCObject other) : object$ = other {}

  /// Constructs a [CASpatialAudioExperience] that wraps the given raw object pointer.
  CASpatialAudioExperience.fromPointer(
    ffi.Pointer<objc.ObjCObjectImpl> other, {
    bool retain = false,
    bool release = false,
  }) : object$ = objc.ObjCObject(other, retain: retain, release: release) {}
}

late final _sel_intendedSpatialExperience = objc.registerName(
  "intendedSpatialExperience",
);
late final _sel_setIntendedSpatialExperience_ = objc.registerName(
  "setIntendedSpatialExperience:",
);
late final _sel_init = objc.registerName("init");
late final _sel_new = objc.registerName("new");
late final _sel_allocWithZone_ = objc.registerName("allocWithZone:");
final _objc_msgSend_1cwp428 = objc.msgSendPointer
    .cast<
      ffi.NativeFunction<
        ffi.Pointer<objc.ObjCObjectImpl> Function(
          ffi.Pointer<objc.ObjCObjectImpl>,
          ffi.Pointer<objc.ObjCSelector>,
          ffi.Pointer<objc.NSZone>,
        )
      >
    >()
    .asFunction<
      ffi.Pointer<objc.ObjCObjectImpl> Function(
        ffi.Pointer<objc.ObjCObjectImpl>,
        ffi.Pointer<objc.ObjCSelector>,
        ffi.Pointer<objc.NSZone>,
      )
    >();
late final _sel_alloc = objc.registerName("alloc");

/// AVAudioPlayer
extension type AVAudioPlayer._(objc.ObjCObject object$)
    implements objc.ObjCObject, objc.NSObject {
  /// Constructs a [AVAudioPlayer] that points to the same underlying object as [other].
  AVAudioPlayer.as(objc.ObjCObject other) : object$ = other {
    objc.checkOsVersionInternal(
      'AVAudioPlayer',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    assert(isA(object$));
  }

  /// Constructs a [AVAudioPlayer] that wraps the given raw object pointer.
  AVAudioPlayer.fromPointer(
    ffi.Pointer<objc.ObjCObjectImpl> other, {
    bool retain = false,
    bool release = false,
  }) : object$ = objc.ObjCObject(other, retain: retain, release: release) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    assert(isA(object$));
  }

  /// Returns whether [obj] is an instance of [AVAudioPlayer].
  static bool isA(objc.ObjCObject obj) => _objc_msgSend_19nvye5(
    obj.ref.pointer,
    _sel_isKindOfClass_,
    _class_AVAudioPlayer,
  );

  /// alloc
  static AVAudioPlayer alloc() {
    final $ret = _objc_msgSend_151sglz(_class_AVAudioPlayer, _sel_alloc);
    return AVAudioPlayer.fromPointer($ret, retain: false, release: true);
  }

  /// allocWithZone:
  static AVAudioPlayer allocWithZone(ffi.Pointer<objc.NSZone> zone) {
    final $ret = _objc_msgSend_1cwp428(
      _class_AVAudioPlayer,
      _sel_allocWithZone_,
      zone,
    );
    return AVAudioPlayer.fromPointer($ret, retain: false, release: true);
  }

  /// new
  static AVAudioPlayer new$() {
    final $ret = _objc_msgSend_151sglz(_class_AVAudioPlayer, _sel_new);
    return AVAudioPlayer.fromPointer($ret, retain: false, release: true);
  }

  /// Returns a new instance of AVAudioPlayer constructed with the default `new` method.
  AVAudioPlayer() : this.as(new$().object$);
}

extension AVAudioPlayer$Methods on AVAudioPlayer {
  /// averagePowerForChannel:
  double averagePowerForChannel(int channelNumber) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.averagePowerForChannel:',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return objc.useMsgSendVariants
        ? _objc_msgSend_65s5ywFpret(
            object$.ref.pointer,
            _sel_averagePowerForChannel_,
            channelNumber,
          )
        : _objc_msgSend_65s5yw(
            object$.ref.pointer,
            _sel_averagePowerForChannel_,
            channelNumber,
          );
  }

  /// channelAssignments
  objc.NSArray? get channelAssignments {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.channelAssignments',
      iOS: (false, (7, 0, 0)),
      macOS: (true, null),
    );
    final $ret = _objc_msgSend_151sglz(
      object$.ref.pointer,
      _sel_channelAssignments,
    );
    return $ret.address == 0
        ? null
        : objc.NSArray.fromPointer($ret, retain: true, release: true);
  }

  /// currentDevice
  objc.NSString? get currentDevice {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.currentDevice',
      iOS: (true, null),
      macOS: (false, (10, 13, 0)),
    );
    final $ret = _objc_msgSend_151sglz(object$.ref.pointer, _sel_currentDevice);
    return $ret.address == 0
        ? null
        : objc.NSString.fromPointer($ret, retain: true, release: true);
  }

  /// currentTime
  double get currentTime {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.currentTime',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(object$.ref.pointer, _sel_currentTime)
        : _objc_msgSend_1ukqyt8(object$.ref.pointer, _sel_currentTime);
  }

  /// data
  objc.NSData? get data {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.data',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    final $ret = _objc_msgSend_151sglz(object$.ref.pointer, _sel_data);
    return $ret.address == 0
        ? null
        : objc.NSData.fromPointer($ret, retain: true, release: true);
  }

  /// delegate
  AVAudioPlayerDelegate? get delegate {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.delegate',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    final $ret = _objc_msgSend_151sglz(object$.ref.pointer, _sel_delegate);
    return $ret.address == 0
        ? null
        : AVAudioPlayerDelegate.fromPointer($ret, retain: true, release: true);
  }

  /// deviceCurrentTime
  double get deviceCurrentTime {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.deviceCurrentTime',
      iOS: (false, (4, 0, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(
            object$.ref.pointer,
            _sel_deviceCurrentTime,
          )
        : _objc_msgSend_1ukqyt8(object$.ref.pointer, _sel_deviceCurrentTime);
  }

  /// duration
  double get duration {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.duration',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(object$.ref.pointer, _sel_duration)
        : _objc_msgSend_1ukqyt8(object$.ref.pointer, _sel_duration);
  }

  /// enableRate
  bool get enableRate {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.enableRate',
      iOS: (false, (5, 0, 0)),
      macOS: (false, (10, 8, 0)),
    );
    return _objc_msgSend_91o635(object$.ref.pointer, _sel_enableRate);
  }

  /// format
  AVAudioFormat get format {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.format',
      iOS: (false, (10, 0, 0)),
      macOS: (false, (10, 12, 0)),
    );
    final $ret = _objc_msgSend_151sglz(object$.ref.pointer, _sel_format);
    return AVAudioFormat.fromPointer($ret, retain: true, release: true);
  }

  /// init
  AVAudioPlayer init() {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.init',
      iOS: (false, (2, 0, 0)),
      macOS: (false, (10, 0, 0)),
    );
    final $ret = _objc_msgSend_151sglz(
      object$.ref.retainAndReturnPointer(),
      _sel_init,
    );
    return AVAudioPlayer.fromPointer($ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:error:
  AVAudioPlayer? initWithContentsOfURL(objc.NSURL url) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.initWithContentsOfURL:error:',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    final $err = pkg_ffi.calloc<ffi.Pointer<objc.ObjCObjectImpl>>();
    try {
      final $ret = _objc_msgSend_1lhpu4m(
        object$.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_error_,
        url.ref.pointer,
        $err,
      );
      objc.NSErrorException.checkErrorPointer($err.value);
      return $ret.address == 0
          ? null
          : AVAudioPlayer.fromPointer($ret, retain: false, release: true);
    } finally {
      pkg_ffi.calloc.free($err);
    }
  }

  /// initWithContentsOfURL:fileTypeHint:error:
  AVAudioPlayer? initWithContentsOfURL$1(
    objc.NSURL url, {
    objc.NSString? fileTypeHint,
  }) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.initWithContentsOfURL:fileTypeHint:error:',
      iOS: (false, (7, 0, 0)),
      macOS: (false, (10, 9, 0)),
    );
    final $err = pkg_ffi.calloc<ffi.Pointer<objc.ObjCObjectImpl>>();
    try {
      final $ret = _objc_msgSend_1pnyuds(
        object$.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_fileTypeHint_error_,
        url.ref.pointer,
        fileTypeHint?.ref.pointer ?? ffi.nullptr,
        $err,
      );
      objc.NSErrorException.checkErrorPointer($err.value);
      return $ret.address == 0
          ? null
          : AVAudioPlayer.fromPointer($ret, retain: false, release: true);
    } finally {
      pkg_ffi.calloc.free($err);
    }
  }

  /// initWithData:error:
  AVAudioPlayer? initWithData(objc.NSData data) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.initWithData:error:',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    final $err = pkg_ffi.calloc<ffi.Pointer<objc.ObjCObjectImpl>>();
    try {
      final $ret = _objc_msgSend_1lhpu4m(
        object$.ref.retainAndReturnPointer(),
        _sel_initWithData_error_,
        data.ref.pointer,
        $err,
      );
      objc.NSErrorException.checkErrorPointer($err.value);
      return $ret.address == 0
          ? null
          : AVAudioPlayer.fromPointer($ret, retain: false, release: true);
    } finally {
      pkg_ffi.calloc.free($err);
    }
  }

  /// initWithData:fileTypeHint:error:
  AVAudioPlayer? initWithData$1(
    objc.NSData data, {
    objc.NSString? fileTypeHint,
  }) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.initWithData:fileTypeHint:error:',
      iOS: (false, (7, 0, 0)),
      macOS: (false, (10, 9, 0)),
    );
    final $err = pkg_ffi.calloc<ffi.Pointer<objc.ObjCObjectImpl>>();
    try {
      final $ret = _objc_msgSend_1pnyuds(
        object$.ref.retainAndReturnPointer(),
        _sel_initWithData_fileTypeHint_error_,
        data.ref.pointer,
        fileTypeHint?.ref.pointer ?? ffi.nullptr,
        $err,
      );
      objc.NSErrorException.checkErrorPointer($err.value);
      return $ret.address == 0
          ? null
          : AVAudioPlayer.fromPointer($ret, retain: false, release: true);
    } finally {
      pkg_ffi.calloc.free($err);
    }
  }

  /// intendedSpatialExperience
  CASpatialAudioExperience get intendedSpatialExperience {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.intendedSpatialExperience',
      iOS: (true, null),
      macOS: (true, null),
    );
    final $ret = _objc_msgSend_151sglz(
      object$.ref.pointer,
      _sel_intendedSpatialExperience,
    );
    return CASpatialAudioExperience.fromPointer(
      $ret,
      retain: true,
      release: true,
    );
  }

  /// isMeteringEnabled
  bool get isMeteringEnabled {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.isMeteringEnabled',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return _objc_msgSend_91o635(object$.ref.pointer, _sel_isMeteringEnabled);
  }

  /// isPlaying
  bool get isPlaying {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.isPlaying',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return _objc_msgSend_91o635(object$.ref.pointer, _sel_isPlaying);
  }

  /// numberOfChannels
  int get numberOfChannels {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.numberOfChannels',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return _objc_msgSend_xw2lbc(object$.ref.pointer, _sel_numberOfChannels);
  }

  /// numberOfLoops
  int get numberOfLoops {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.numberOfLoops',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return _objc_msgSend_1hz7y9r(object$.ref.pointer, _sel_numberOfLoops);
  }

  /// pan
  double get pan {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.pan',
      iOS: (false, (4, 0, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return objc.useMsgSendVariants
        ? _objc_msgSend_2cgrxlFpret(object$.ref.pointer, _sel_pan)
        : _objc_msgSend_2cgrxl(object$.ref.pointer, _sel_pan);
  }

  /// pause
  void pause() {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.pause',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    _objc_msgSend_1pl9qdv(object$.ref.pointer, _sel_pause);
  }

  /// peakPowerForChannel:
  double peakPowerForChannel(int channelNumber) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.peakPowerForChannel:',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return objc.useMsgSendVariants
        ? _objc_msgSend_65s5ywFpret(
            object$.ref.pointer,
            _sel_peakPowerForChannel_,
            channelNumber,
          )
        : _objc_msgSend_65s5yw(
            object$.ref.pointer,
            _sel_peakPowerForChannel_,
            channelNumber,
          );
  }

  /// play
  bool play() {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.play',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return _objc_msgSend_91o635(object$.ref.pointer, _sel_play);
  }

  /// playAtTime:
  bool playAtTime(double time) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.playAtTime:',
      iOS: (false, (4, 0, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return _objc_msgSend_18chyc(object$.ref.pointer, _sel_playAtTime_, time);
  }

  /// prepareToPlay
  bool prepareToPlay() {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.prepareToPlay',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return _objc_msgSend_91o635(object$.ref.pointer, _sel_prepareToPlay);
  }

  /// rate
  double get rate {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.rate',
      iOS: (false, (5, 0, 0)),
      macOS: (false, (10, 8, 0)),
    );
    return objc.useMsgSendVariants
        ? _objc_msgSend_2cgrxlFpret(object$.ref.pointer, _sel_rate)
        : _objc_msgSend_2cgrxl(object$.ref.pointer, _sel_rate);
  }

  /// setChannelAssignments:
  set channelAssignments(objc.NSArray? value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setChannelAssignments:',
      iOS: (false, (7, 0, 0)),
      macOS: (true, null),
    );
    _objc_msgSend_xtuoz7(
      object$.ref.pointer,
      _sel_setChannelAssignments_,
      value?.ref.pointer ?? ffi.nullptr,
    );
  }

  /// setCurrentDevice:
  set currentDevice(objc.NSString? value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setCurrentDevice:',
      iOS: (true, null),
      macOS: (false, (10, 13, 0)),
    );
    _objc_msgSend_xtuoz7(
      object$.ref.pointer,
      _sel_setCurrentDevice_,
      value?.ref.pointer ?? ffi.nullptr,
    );
  }

  /// setCurrentTime:
  set currentTime(double value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setCurrentTime:',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    _objc_msgSend_hwm8nu(object$.ref.pointer, _sel_setCurrentTime_, value);
  }

  /// setDelegate:
  set delegate(AVAudioPlayerDelegate? value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setDelegate:',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    _objc_msgSend_xtuoz7(
      object$.ref.pointer,
      _sel_setDelegate_,
      value?.ref.pointer ?? ffi.nullptr,
    );
  }

  /// setEnableRate:
  set enableRate(bool value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setEnableRate:',
      iOS: (false, (5, 0, 0)),
      macOS: (false, (10, 8, 0)),
    );
    _objc_msgSend_1s56lr9(object$.ref.pointer, _sel_setEnableRate_, value);
  }

  /// setIntendedSpatialExperience:
  set intendedSpatialExperience(CASpatialAudioExperience value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setIntendedSpatialExperience:',
      iOS: (true, null),
      macOS: (true, null),
    );
    _objc_msgSend_xtuoz7(
      object$.ref.pointer,
      _sel_setIntendedSpatialExperience_,
      value.ref.pointer,
    );
  }

  /// setMeteringEnabled:
  set isMeteringEnabled(bool value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setMeteringEnabled:',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    _objc_msgSend_1s56lr9(object$.ref.pointer, _sel_setMeteringEnabled_, value);
  }

  /// setNumberOfLoops:
  set numberOfLoops(int value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setNumberOfLoops:',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    _objc_msgSend_4sp4xj(object$.ref.pointer, _sel_setNumberOfLoops_, value);
  }

  /// setPan:
  set pan(double value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setPan:',
      iOS: (false, (4, 0, 0)),
      macOS: (false, (10, 7, 0)),
    );
    _objc_msgSend_v5hmet(object$.ref.pointer, _sel_setPan_, value);
  }

  /// setRate:
  set rate(double value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setRate:',
      iOS: (false, (5, 0, 0)),
      macOS: (false, (10, 8, 0)),
    );
    _objc_msgSend_v5hmet(object$.ref.pointer, _sel_setRate_, value);
  }

  /// setVolume:
  set volume(double value) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setVolume:',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    _objc_msgSend_v5hmet(object$.ref.pointer, _sel_setVolume_, value);
  }

  /// setVolume:fadeDuration:
  void setVolume(double volume, {required double fadeDuration}) {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.setVolume:fadeDuration:',
      iOS: (false, (10, 0, 0)),
      macOS: (false, (10, 12, 0)),
    );
    _objc_msgSend_1p4uk9e(
      object$.ref.pointer,
      _sel_setVolume_fadeDuration_,
      volume,
      fadeDuration,
    );
  }

  /// settings
  objc.NSDictionary get settings {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.settings',
      iOS: (false, (4, 0, 0)),
      macOS: (false, (10, 7, 0)),
    );
    final $ret = _objc_msgSend_151sglz(object$.ref.pointer, _sel_settings);
    return objc.NSDictionary.fromPointer($ret, retain: true, release: true);
  }

  /// stop
  void stop() {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.stop',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    _objc_msgSend_1pl9qdv(object$.ref.pointer, _sel_stop);
  }

  /// updateMeters
  void updateMeters() {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.updateMeters',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    _objc_msgSend_1pl9qdv(object$.ref.pointer, _sel_updateMeters);
  }

  /// url
  objc.NSURL? get url {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.url',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    final $ret = _objc_msgSend_151sglz(object$.ref.pointer, _sel_url);
    return $ret.address == 0
        ? null
        : objc.NSURL.fromPointer($ret, retain: true, release: true);
  }

  /// volume
  double get volume {
    objc.checkOsVersionInternal(
      'AVAudioPlayer.volume',
      iOS: (false, (2, 2, 0)),
      macOS: (false, (10, 7, 0)),
    );
    return objc.useMsgSendVariants
        ? _objc_msgSend_2cgrxlFpret(object$.ref.pointer, _sel_volume)
        : _objc_msgSend_2cgrxl(object$.ref.pointer, _sel_volume);
  }
}
