// Autogenerated from Pigeon (v26.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package eu.weblibre.flutter_mozilla_components.pigeons

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMethodCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer
private object GeckoPigeonUtils {

  fun createConnectionError(channelName: String): FlutterError {
    return FlutterError("channel-error",  "Unable to establish connection on channel: '$channelName'.", "")  }

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is FlutterError) {
      listOf(
        exception.code,
        exception.message,
        exception.details
      )
    } else {
      listOf(
        exception.javaClass.simpleName,
        exception.toString(),
        "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception)
      )
    }
  }
  fun deepEquals(a: Any?, b: Any?): Boolean {
    if (a is ByteArray && b is ByteArray) {
        return a.contentEquals(b)
    }
    if (a is IntArray && b is IntArray) {
        return a.contentEquals(b)
    }
    if (a is LongArray && b is LongArray) {
        return a.contentEquals(b)
    }
    if (a is DoubleArray && b is DoubleArray) {
        return a.contentEquals(b)
    }
    if (a is Array<*> && b is Array<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is List<*> && b is List<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is Map<*, *> && b is Map<*, *>) {
      return a.size == b.size && a.all {
          (b as Map<Any?, Any?>).containsKey(it.key) &&
          deepEquals(it.value, b[it.key])
      }
    }
    return a == b
  }
      
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError (
  val code: String,
  override val message: String? = null,
  val details: Any? = null
) : Throwable()

/** Indicates what location the tabs should be restored at */
enum class RestoreLocation(val raw: Int) {
  /** Restore tabs at the beginning of the tab list */
  BEGINNING(0),
  /** Restore tabs at the end of the tab list */
  END(1),
  /** Restore tabs at a specific index in the tab list */
  AT_INDEX(2);

  companion object {
    fun ofRaw(raw: Int): RestoreLocation? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/** An icon resource type. */
enum class IconType(val raw: Int) {
  FAVICON(0),
  APPLE_TOUCH_ICON(1),
  FLUID_ICON(2),
  IMAGE_SRC(3),
  OPEN_GRAPH(4),
  TWITTER(5),
  MICROSOFT_TILE(6),
  TIPPY_TOP(7),
  MANIFEST_ICON(8);

  companion object {
    fun ofRaw(raw: Int): IconType? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * Supported sizes.
 *
 * We are trying to limit the supported sizes in order to optimize our caching strategy.
 */
enum class IconSize(val raw: Int) {
  DEFAULT_SIZE(0),
  LAUNCHER(1),
  LAUNCHER_ADAPTIVE(2);

  companion object {
    fun ofRaw(raw: Int): IconSize? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/** The source of an [Icon]. */
enum class IconSource(val raw: Int) {
  /** This icon was generated. */
  GENERATOR(0),
  /** This icon was downloaded. */
  DOWNLOAD(1),
  /** This icon was inlined in the document. */
  INLINE(2),
  /** This icon was loaded from an in-memory cache. */
  MEMORY(3),
  /** This icon was loaded from a disk cache. */
  DISK(4);

  companion object {
    fun ofRaw(raw: Int): IconSource? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class CookieSameSiteStatus(val raw: Int) {
  NO_RESTRICTION(0),
  LAX(1),
  STRICT(2),
  UNSPECIFIED(3);

  companion object {
    fun ofRaw(raw: Int): CookieSameSiteStatus? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class VisitType(val raw: Int) {
  /** The user followed a link and got a new toplevel window. */
  LINK(0),
  /**
   * The user typed the page's URL in the URL bar or selected it from
   * URL bar autocomplete results, clicked on it from a history query
   * (from the History sidebar, History menu, or history query in the
   * personal toolbar or Places organizer.
   */
  TYPED(1),
  /** The user followed a bookmark to get to the page. */
  BOOKMARK(2),
  /**
   * Some inner content is loaded. This is true of all images on a
   * page, and the contents of the iframe. It is also true of any
   * content in a frame if the user did not explicitly follow a link
   * to get there.
   */
  EMBED(3),
  /** Set when the transition was a permanent redirect. */
  REDIRECT_PERMANENT(4),
  /** Set when the transition was a temporary redirect. */
  REDIRECT_TEMPORARY(5),
  /** Set when the transition is a download. */
  DOWNLOAD(6),
  /** The user followed a link and got a visit in a frame. */
  FRAMED_LINK(7),
  /** The user reloaded a page. */
  RELOAD(8);

  companion object {
    fun ofRaw(raw: Int): VisitType? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class SelectionPattern(val raw: Int) {
  PHONE(0),
  EMAIL(1);

  companion object {
    fun ofRaw(raw: Int): SelectionPattern? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class WebExtensionActionType(val raw: Int) {
  BROWSER(0),
  PAGE(1);

  companion object {
    fun ofRaw(raw: Int): WebExtensionActionType? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class GeckoSuggestionType(val raw: Int) {
  SESSION(0),
  CLIPBOARD(1),
  HISTORY(2);

  companion object {
    fun ofRaw(raw: Int): GeckoSuggestionType? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class TrackingProtectionPolicy(val raw: Int) {
  NONE(0),
  RECOMMENDED(1),
  STRICT(2),
  CUSTOM(3);

  companion object {
    fun ofRaw(raw: Int): TrackingProtectionPolicy? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class HttpsOnlyMode(val raw: Int) {
  DISABLED(0),
  PRIVATE_ONLY(1),
  ENABLED(2);

  companion object {
    fun ofRaw(raw: Int): HttpsOnlyMode? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class QueryParameterStripping(val raw: Int) {
  DISABLED(0),
  PRIVATE_ONLY(1),
  ENABLED(2);

  companion object {
    fun ofRaw(raw: Int): QueryParameterStripping? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class BounceTrackingProtectionMode(val raw: Int) {
  /** Fully disabled. */
  DISABLED(0),
  /** Fully enabled. */
  ENABLED(1),
  /**
   * Disabled, but collects user interaction data. Use this mode as the
   * "disabled" state when the feature can be toggled on and off, e.g. via
   * preferences.
   */
  ENABLED_STANDBY(2),
  /**
   * Feature enabled, but tracker purging is only simulated. Used for
   * testing and telemetry collection.
   */
  ENABLED_DRY_RUN(3);

  companion object {
    fun ofRaw(raw: Int): BounceTrackingProtectionMode? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class ColorScheme(val raw: Int) {
  SYSTEM(0),
  LIGHT(1),
  DARK(2);

  companion object {
    fun ofRaw(raw: Int): ColorScheme? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class CookieBannerHandlingMode(val raw: Int) {
  DISABLED(0),
  REJECT_ALL(1),
  REJECT_OR_ACCEPT_ALL(2);

  companion object {
    fun ofRaw(raw: Int): CookieBannerHandlingMode? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class WebContentIsolationStrategy(val raw: Int) {
  ISOLATE_NOTHING(0),
  ISOLATE_EVERYTHING(1),
  ISOLATE_HIGH_VALUE(2);

  companion object {
    fun ofRaw(raw: Int): WebContentIsolationStrategy? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class DohSettingsMode(val raw: Int) {
  GECKO_DEFAULT(0),
  INCREASED(1),
  MAX(2),
  OFF(3);

  companion object {
    fun ofRaw(raw: Int): DohSettingsMode? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/** Status that represents every state that a download can be in. */
enum class DownloadStatus(val raw: Int) {
  /** Indicates that the download is in the first state after creation but not yet [DOWNLOADING]. */
  INITIATED(0),
  /** Indicates that an [INITIATED] download is now actively being downloaded. */
  DOWNLOADING(1),
  /** Indicates that the download that has been [DOWNLOADING] has been paused. */
  PAUSED(2),
  /** Indicates that the download that has been [DOWNLOADING] has been cancelled. */
  CANCELLED(3),
  /**
   * Indicates that the download that has been [DOWNLOADING] has moved to failed because
   * something unexpected has happened.
   */
  FAILED(4),
  /** Indicates that the [DOWNLOADING] download has been completed. */
  COMPLETED(5);

  companion object {
    fun ofRaw(raw: Int): DownloadStatus? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class LogLevel(val raw: Int) {
  DEBUG(0),
  INFO(1),
  WARN(2),
  ERROR(3);

  companion object {
    fun ofRaw(raw: Int): LogLevel? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * Translation options that map to the Gecko Translations Options.
 *
 * @property downloadModel If the necessary models should be downloaded on request. If false, then
 * the translation will not complete and throw an exception if the models are not already available.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class TranslationOptions (
  val downloadModel: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): TranslationOptions {
      val downloadModel = pigeonVar_list[0] as Boolean
      return TranslationOptions(downloadModel)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      downloadModel,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is TranslationOptions) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * Value type that represents the state of reader mode/view.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class ReaderState (
  /**
   * Whether or not the current page can be transformed to
   * be displayed in a reader view.
   */
  val readerable: Boolean,
  /** Whether or not reader view is active. */
  val active: Boolean,
  /**
   * Whether or not a readerable check is required for the
   * current page.
   */
  val checkRequired: Boolean,
  /**
   * Whether or not a new connection to the reader view
   * content script is required.
   */
  val connectRequired: Boolean,
  /** The base URL of the reader view extension page. */
  val baseUrl: String? = null,
  /** The URL of the page currently displayed in reader view. */
  val activeUrl: String? = null,
  /**
   * The vertical scroll position of the page currently
   * displayed in reader view.
   */
  val scrollY: Long? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): ReaderState {
      val readerable = pigeonVar_list[0] as Boolean
      val active = pigeonVar_list[1] as Boolean
      val checkRequired = pigeonVar_list[2] as Boolean
      val connectRequired = pigeonVar_list[3] as Boolean
      val baseUrl = pigeonVar_list[4] as String?
      val activeUrl = pigeonVar_list[5] as String?
      val scrollY = pigeonVar_list[6] as Long?
      return ReaderState(readerable, active, checkRequired, connectRequired, baseUrl, activeUrl, scrollY)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      readerable,
      active,
      checkRequired,
      connectRequired,
      baseUrl,
      activeUrl,
      scrollY,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is ReaderState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * Details about the last playing media in this tab.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class LastMediaAccessState (
  /**
   * [TabContentState.url] when media started playing.
   * This is not the URL of the media but of the page when media started.
   * Defaults to "" (an empty String) if media hasn't started playing.
   * This value is only updated when media starts playing.
   * Can be used as a backup to [mediaSessionActive] for knowing the user is still on the same website
   * on which media was playing before media started playing in another tab.
   */
  val lastMediaUrl: String,
  /**
   * The last time media started playing in the current web document.
   * Defaults to [0] if media hasn't started playing.
   * This value is only updated when media starts playing.
   */
  val lastMediaAccess: Long,
  /**
   * Whether or not the last accessed media is still active.
   * Can be used as a backup to [lastMediaUrl] on websites which allow media to continue playing
   * even when the users accesses another page (with another URL) in that same HTML document.
   */
  val mediaSessionActive: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): LastMediaAccessState {
      val lastMediaUrl = pigeonVar_list[0] as String
      val lastMediaAccess = pigeonVar_list[1] as Long
      val mediaSessionActive = pigeonVar_list[2] as Boolean
      return LastMediaAccessState(lastMediaUrl, lastMediaAccess, mediaSessionActive)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      lastMediaUrl,
      lastMediaAccess,
      mediaSessionActive,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is LastMediaAccessState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * Represents a set of history metadata values that uniquely identify a record. Note that
 * when recording observations, the same set of values may or may not cause a new record to be
 * created, depending on the de-bouncing logic of the underlying storage i.e. recording history
 * metadata observations with the exact same values may be combined into a single record.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class HistoryMetadataKey (
  /** A url of the page. */
  val url: String,
  /**
   * An optional search term if this record was
   * created as part of a search by the user.
   */
  val searchTerm: String? = null,
  /**
   * An optional url of the parent/referrer if
   * this record was created in response to a user opening
   * a page in a new tab.
   */
  val referrerUrl: String? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): HistoryMetadataKey {
      val url = pigeonVar_list[0] as String
      val searchTerm = pigeonVar_list[1] as String?
      val referrerUrl = pigeonVar_list[2] as String?
      return HistoryMetadataKey(url, searchTerm, referrerUrl)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      url,
      searchTerm,
      referrerUrl,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is HistoryMetadataKey) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class PackageCategoryValue (
  val value: Long
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): PackageCategoryValue {
      val value = pigeonVar_list[0] as Long
      return PackageCategoryValue(value)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      value,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is PackageCategoryValue) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * Describes an external package.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class ExternalPackage (
  /** An Android package id. */
  val packageId: String,
  /** A [PackageCategory] as defined by the application. */
  val category: PackageCategoryValue
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): ExternalPackage {
      val packageId = pigeonVar_list[0] as String
      val category = pigeonVar_list[1] as PackageCategoryValue
      return ExternalPackage(packageId, category)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      packageId,
      category,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is ExternalPackage) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class LoadUrlFlagsValue (
  val value: Long
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): LoadUrlFlagsValue {
      val value = pigeonVar_list[0] as Long
      return LoadUrlFlagsValue(value)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      value,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is LoadUrlFlagsValue) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class SourceValue (
  val id: Long,
  val caller: ExternalPackage? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): SourceValue {
      val id = pigeonVar_list[0] as Long
      val caller = pigeonVar_list[1] as ExternalPackage?
      return SourceValue(id, caller)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      id,
      caller,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is SourceValue) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * A tab that is no longer open and in the list of tabs, but that can be restored (recovered) at
 * any time if it's combined with an [EngineSessionState] to form a [RecoverableTab].
 *
 * The values of this data class are usually filled with the values of a [TabSessionState] when
 * getting closed.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class TabState (
  /** Unique ID identifying this tab. */
  val id: String,
  /** The last URL of this tab. */
  val url: String,
  /**
   * The unique ID of the parent tab if this tab was opened from another tab (e.g. via
   * the context menu).
   */
  val parentId: String? = null,
  /** The last title of this tab (or an empty String). */
  val title: String,
  /**
   * The last used search terms, or an empty string if no
   * search was executed for this session.
   */
  val searchTerm: String,
  /** The context ID ("container") this tab used (or null). */
  val contextId: String? = null,
  /** The last [ReaderState] of the tab. */
  val readerState: ReaderState,
  /** The last time this tab was selected. */
  val lastAccess: Long,
  /** Timestamp of the tab's creation. */
  val createdAt: Long,
  /** Details about the last time was playing in this tab. */
  val lastMediaAccessState: LastMediaAccessState,
  /** If tab was private. */
  val private: Boolean,
  /** The last [HistoryMetadataKey] of the tab. */
  val historyMetadata: HistoryMetadataKey? = null,
  /** The last [IconSource] of the tab. */
  val source: SourceValue,
  /** The index the tab should be restored at. */
  val index: Long,
  /** Whether the tab has form data. */
  val hasFormData: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): TabState {
      val id = pigeonVar_list[0] as String
      val url = pigeonVar_list[1] as String
      val parentId = pigeonVar_list[2] as String?
      val title = pigeonVar_list[3] as String
      val searchTerm = pigeonVar_list[4] as String
      val contextId = pigeonVar_list[5] as String?
      val readerState = pigeonVar_list[6] as ReaderState
      val lastAccess = pigeonVar_list[7] as Long
      val createdAt = pigeonVar_list[8] as Long
      val lastMediaAccessState = pigeonVar_list[9] as LastMediaAccessState
      val private = pigeonVar_list[10] as Boolean
      val historyMetadata = pigeonVar_list[11] as HistoryMetadataKey?
      val source = pigeonVar_list[12] as SourceValue
      val index = pigeonVar_list[13] as Long
      val hasFormData = pigeonVar_list[14] as Boolean
      return TabState(id, url, parentId, title, searchTerm, contextId, readerState, lastAccess, createdAt, lastMediaAccessState, private, historyMetadata, source, index, hasFormData)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      id,
      url,
      parentId,
      title,
      searchTerm,
      contextId,
      readerState,
      lastAccess,
      createdAt,
      lastMediaAccessState,
      private,
      historyMetadata,
      source,
      index,
      hasFormData,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is TabState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * A recoverable version of [TabState].
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class RecoverableTab (
  /** The [EngineSessionState] needed for restoring the previous state of this tab. */
  val engineSessionStateJson: String? = null,
  /** A [TabState] instance containing basic tab state. */
  val state: TabState
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): RecoverableTab {
      val engineSessionStateJson = pigeonVar_list[0] as String?
      val state = pigeonVar_list[1] as TabState
      return RecoverableTab(engineSessionStateJson, state)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      engineSessionStateJson,
      state,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is RecoverableTab) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * A restored browser state, read from disk.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class RecoverableBrowserState (
  /** The list of restored tabs. */
  val tabs: List<RecoverableTab?>,
  /** The ID of the selected tab in [tabs]. Or `null` if no selection was restored. */
  val selectedTabId: String? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): RecoverableBrowserState {
      val tabs = pigeonVar_list[0] as List<RecoverableTab?>
      val selectedTabId = pigeonVar_list[1] as String?
      return RecoverableBrowserState(tabs, selectedTabId)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      tabs,
      selectedTabId,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is RecoverableBrowserState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * A request to load an [Icon].
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class IconRequest (
  val url: String,
  val size: IconSize,
  val resources: List<Resource?>,
  val color: Long? = null,
  val isPrivate: Boolean,
  val waitOnNetworkLoad: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): IconRequest {
      val url = pigeonVar_list[0] as String
      val size = pigeonVar_list[1] as IconSize
      val resources = pigeonVar_list[2] as List<Resource?>
      val color = pigeonVar_list[3] as Long?
      val isPrivate = pigeonVar_list[4] as Boolean
      val waitOnNetworkLoad = pigeonVar_list[5] as Boolean
      return IconRequest(url, size, resources, color, isPrivate, waitOnNetworkLoad)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      url,
      size,
      resources,
      color,
      isPrivate,
      waitOnNetworkLoad,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is IconRequest) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class ResourceSize (
  val height: Long,
  val width: Long
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): ResourceSize {
      val height = pigeonVar_list[0] as Long
      val width = pigeonVar_list[1] as Long
      return ResourceSize(height, width)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      height,
      width,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is ResourceSize) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * An icon resource that can be loaded.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class Resource (
  val url: String,
  val type: IconType,
  val sizes: List<ResourceSize?>,
  val mimeType: String? = null,
  val maskable: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): Resource {
      val url = pigeonVar_list[0] as String
      val type = pigeonVar_list[1] as IconType
      val sizes = pigeonVar_list[2] as List<ResourceSize?>
      val mimeType = pigeonVar_list[3] as String?
      val maskable = pigeonVar_list[4] as Boolean
      return Resource(url, type, sizes, mimeType, maskable)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      url,
      type,
      sizes,
      mimeType,
      maskable,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is Resource) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * An [Icon] returned by [BrowserIcons] after processing an [IconRequest]
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class IconResult (
  /** The loaded icon as an [Uint8List]. */
  val image: ByteArray,
  /** The dominant color of the icon. Will be null if no color could be extracted. */
  val color: Long? = null,
  /** The source of the icon. */
  val source: IconSource,
  /** True if the icon represents as full-bleed icon that can be cropped to other shapes. */
  val maskable: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): IconResult {
      val image = pigeonVar_list[0] as ByteArray
      val color = pigeonVar_list[1] as Long?
      val source = pigeonVar_list[2] as IconSource
      val maskable = pigeonVar_list[3] as Boolean
      return IconResult(image, color, source, maskable)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      image,
      color,
      source,
      maskable,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is IconResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class CookiePartitionKey (
  val topLevelSite: String
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): CookiePartitionKey {
      val topLevelSite = pigeonVar_list[0] as String
      return CookiePartitionKey(topLevelSite)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      topLevelSite,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is CookiePartitionKey) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class Cookie (
  val domain: String,
  val expirationDate: Long? = null,
  val firstPartyDomain: String,
  val hostOnly: Boolean,
  val httpOnly: Boolean,
  val name: String,
  val partitionKey: CookiePartitionKey? = null,
  val path: String,
  val secure: Boolean,
  val session: Boolean,
  val sameSite: CookieSameSiteStatus,
  val storeId: String,
  val value: String
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): Cookie {
      val domain = pigeonVar_list[0] as String
      val expirationDate = pigeonVar_list[1] as Long?
      val firstPartyDomain = pigeonVar_list[2] as String
      val hostOnly = pigeonVar_list[3] as Boolean
      val httpOnly = pigeonVar_list[4] as Boolean
      val name = pigeonVar_list[5] as String
      val partitionKey = pigeonVar_list[6] as CookiePartitionKey?
      val path = pigeonVar_list[7] as String
      val secure = pigeonVar_list[8] as Boolean
      val session = pigeonVar_list[9] as Boolean
      val sameSite = pigeonVar_list[10] as CookieSameSiteStatus
      val storeId = pigeonVar_list[11] as String
      val value = pigeonVar_list[12] as String
      return Cookie(domain, expirationDate, firstPartyDomain, hostOnly, httpOnly, name, partitionKey, path, secure, session, sameSite, storeId, value)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      domain,
      expirationDate,
      firstPartyDomain,
      hostOnly,
      httpOnly,
      name,
      partitionKey,
      path,
      secure,
      session,
      sameSite,
      storeId,
      value,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is Cookie) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class VisitInfo (
  val url: String,
  val title: String? = null,
  val visitTime: Long,
  val visitType: VisitType,
  val previewImageUrl: String? = null,
  val isRemote: Boolean,
  val contentId: String? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): VisitInfo {
      val url = pigeonVar_list[0] as String
      val title = pigeonVar_list[1] as String?
      val visitTime = pigeonVar_list[2] as Long
      val visitType = pigeonVar_list[3] as VisitType
      val previewImageUrl = pigeonVar_list[4] as String?
      val isRemote = pigeonVar_list[5] as Boolean
      val contentId = pigeonVar_list[6] as String?
      return VisitInfo(url, title, visitTime, visitType, previewImageUrl, isRemote, contentId)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      url,
      title,
      visitTime,
      visitType,
      previewImageUrl,
      isRemote,
      contentId,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is VisitInfo) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class HistoryItem (
  val url: String,
  val title: String
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): HistoryItem {
      val url = pigeonVar_list[0] as String
      val title = pigeonVar_list[1] as String
      return HistoryItem(url, title)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      url,
      title,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is HistoryItem) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class HistoryState (
  val items: List<HistoryItem?>,
  val currentIndex: Long,
  val canGoBack: Boolean,
  val canGoForward: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): HistoryState {
      val items = pigeonVar_list[0] as List<HistoryItem?>
      val currentIndex = pigeonVar_list[1] as Long
      val canGoBack = pigeonVar_list[2] as Boolean
      val canGoForward = pigeonVar_list[3] as Boolean
      return HistoryState(items, currentIndex, canGoBack, canGoForward)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      items,
      currentIndex,
      canGoBack,
      canGoForward,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is HistoryState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class ReaderableState (
  /**
   * Whether or not the current page can be transformed to
   * be displayed in a reader view.
   */
  val readerable: Boolean,
  /** Whether or not reader view is active. */
  val active: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): ReaderableState {
      val readerable = pigeonVar_list[0] as Boolean
      val active = pigeonVar_list[1] as Boolean
      return ReaderableState(readerable, active)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      readerable,
      active,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is ReaderableState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class SecurityInfoState (
  val secure: Boolean,
  val host: String,
  val issuer: String
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): SecurityInfoState {
      val secure = pigeonVar_list[0] as Boolean
      val host = pigeonVar_list[1] as String
      val issuer = pigeonVar_list[2] as String
      return SecurityInfoState(secure, host, issuer)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      secure,
      host,
      issuer,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is SecurityInfoState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class TabContentState (
  val id: String,
  val parentId: String? = null,
  val contextId: String? = null,
  val url: String,
  val title: String,
  val progress: Long,
  val isPrivate: Boolean,
  val isFullScreen: Boolean,
  val isLoading: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): TabContentState {
      val id = pigeonVar_list[0] as String
      val parentId = pigeonVar_list[1] as String?
      val contextId = pigeonVar_list[2] as String?
      val url = pigeonVar_list[3] as String
      val title = pigeonVar_list[4] as String
      val progress = pigeonVar_list[5] as Long
      val isPrivate = pigeonVar_list[6] as Boolean
      val isFullScreen = pigeonVar_list[7] as Boolean
      val isLoading = pigeonVar_list[8] as Boolean
      return TabContentState(id, parentId, contextId, url, title, progress, isPrivate, isFullScreen, isLoading)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      id,
      parentId,
      contextId,
      url,
      title,
      progress,
      isPrivate,
      isFullScreen,
      isLoading,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is TabContentState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class FindResultState (
  val activeMatchOrdinal: Long,
  val numberOfMatches: Long,
  val isDoneCounting: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): FindResultState {
      val activeMatchOrdinal = pigeonVar_list[0] as Long
      val numberOfMatches = pigeonVar_list[1] as Long
      val isDoneCounting = pigeonVar_list[2] as Boolean
      return FindResultState(activeMatchOrdinal, numberOfMatches, isDoneCounting)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      activeMatchOrdinal,
      numberOfMatches,
      isDoneCounting,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is FindResultState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class CustomSelectionAction (
  val id: String,
  val title: String,
  val pattern: SelectionPattern? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): CustomSelectionAction {
      val id = pigeonVar_list[0] as String
      val title = pigeonVar_list[1] as String
      val pattern = pigeonVar_list[2] as SelectionPattern?
      return CustomSelectionAction(id, title, pattern)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      id,
      title,
      pattern,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is CustomSelectionAction) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class WebExtensionData (
  val extensionId: String,
  val title: String? = null,
  val enabled: Boolean? = null,
  val badgeText: String? = null,
  val badgeTextColor: Long? = null,
  val badgeBackgroundColor: Long? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): WebExtensionData {
      val extensionId = pigeonVar_list[0] as String
      val title = pigeonVar_list[1] as String?
      val enabled = pigeonVar_list[2] as Boolean?
      val badgeText = pigeonVar_list[3] as String?
      val badgeTextColor = pigeonVar_list[4] as Long?
      val badgeBackgroundColor = pigeonVar_list[5] as Long?
      return WebExtensionData(extensionId, title, enabled, badgeText, badgeTextColor, badgeBackgroundColor)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      extensionId,
      title,
      enabled,
      badgeText,
      badgeTextColor,
      badgeBackgroundColor,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is WebExtensionData) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class GeckoSuggestion (
  val id: String,
  val type: GeckoSuggestionType,
  val score: Long,
  val title: String? = null,
  val description: String? = null,
  val editSuggestion: String? = null,
  val icon: ByteArray? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): GeckoSuggestion {
      val id = pigeonVar_list[0] as String
      val type = pigeonVar_list[1] as GeckoSuggestionType
      val score = pigeonVar_list[2] as Long
      val title = pigeonVar_list[3] as String?
      val description = pigeonVar_list[4] as String?
      val editSuggestion = pigeonVar_list[5] as String?
      val icon = pigeonVar_list[6] as ByteArray?
      return GeckoSuggestion(id, type, score, title, description, editSuggestion, icon)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      id,
      type,
      score,
      title,
      description,
      editSuggestion,
      icon,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is GeckoSuggestion) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class TabContent (
  val tabId: String,
  val fullContentMarkdown: String? = null,
  val fullContentPlain: String? = null,
  val isProbablyReaderable: Boolean,
  val extractedContentMarkdown: String? = null,
  val extractedContentPlain: String? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): TabContent {
      val tabId = pigeonVar_list[0] as String
      val fullContentMarkdown = pigeonVar_list[1] as String?
      val fullContentPlain = pigeonVar_list[2] as String?
      val isProbablyReaderable = pigeonVar_list[3] as Boolean
      val extractedContentMarkdown = pigeonVar_list[4] as String?
      val extractedContentPlain = pigeonVar_list[5] as String?
      return TabContent(tabId, fullContentMarkdown, fullContentPlain, isProbablyReaderable, extractedContentMarkdown, extractedContentPlain)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      tabId,
      fullContentMarkdown,
      fullContentPlain,
      isProbablyReaderable,
      extractedContentMarkdown,
      extractedContentPlain,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is TabContent) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class ContentBlocking (
  val queryParameterStripping: QueryParameterStripping,
  val queryParameterStrippingAllowList: String,
  val queryParameterStrippingStripList: String,
  val bounceTrackingProtectionMode: BounceTrackingProtectionMode
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): ContentBlocking {
      val queryParameterStripping = pigeonVar_list[0] as QueryParameterStripping
      val queryParameterStrippingAllowList = pigeonVar_list[1] as String
      val queryParameterStrippingStripList = pigeonVar_list[2] as String
      val bounceTrackingProtectionMode = pigeonVar_list[3] as BounceTrackingProtectionMode
      return ContentBlocking(queryParameterStripping, queryParameterStrippingAllowList, queryParameterStrippingStripList, bounceTrackingProtectionMode)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      queryParameterStripping,
      queryParameterStrippingAllowList,
      queryParameterStrippingStripList,
      bounceTrackingProtectionMode,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is ContentBlocking) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class DohSettings (
  val dohSettingsMode: DohSettingsMode,
  val dohProviderUrl: String,
  val dohDefaultProviderUrl: String,
  val dohExceptionsList: List<String>
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): DohSettings {
      val dohSettingsMode = pigeonVar_list[0] as DohSettingsMode
      val dohProviderUrl = pigeonVar_list[1] as String
      val dohDefaultProviderUrl = pigeonVar_list[2] as String
      val dohExceptionsList = pigeonVar_list[3] as List<String>
      return DohSettings(dohSettingsMode, dohProviderUrl, dohDefaultProviderUrl, dohExceptionsList)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      dohSettingsMode,
      dohProviderUrl,
      dohDefaultProviderUrl,
      dohExceptionsList,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is DohSettings) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class GeckoEngineSettings (
  val javascriptEnabled: Boolean? = null,
  val trackingProtectionPolicy: TrackingProtectionPolicy? = null,
  val httpsOnlyMode: HttpsOnlyMode? = null,
  val globalPrivacyControlEnabled: Boolean? = null,
  val preferredColorScheme: ColorScheme? = null,
  val cookieBannerHandlingMode: CookieBannerHandlingMode? = null,
  val cookieBannerHandlingModePrivateBrowsing: CookieBannerHandlingMode? = null,
  val cookieBannerHandlingGlobalRules: Boolean? = null,
  val cookieBannerHandlingGlobalRulesSubFrames: Boolean? = null,
  val webContentIsolationStrategy: WebContentIsolationStrategy? = null,
  val userAgent: String? = null,
  val contentBlocking: ContentBlocking? = null,
  val enterpriseRootsEnabled: Boolean? = null,
  val dohSettings: DohSettings? = null,
  val fingerprintingProtectionOverrides: String? = null,
  val locales: List<String>? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): GeckoEngineSettings {
      val javascriptEnabled = pigeonVar_list[0] as Boolean?
      val trackingProtectionPolicy = pigeonVar_list[1] as TrackingProtectionPolicy?
      val httpsOnlyMode = pigeonVar_list[2] as HttpsOnlyMode?
      val globalPrivacyControlEnabled = pigeonVar_list[3] as Boolean?
      val preferredColorScheme = pigeonVar_list[4] as ColorScheme?
      val cookieBannerHandlingMode = pigeonVar_list[5] as CookieBannerHandlingMode?
      val cookieBannerHandlingModePrivateBrowsing = pigeonVar_list[6] as CookieBannerHandlingMode?
      val cookieBannerHandlingGlobalRules = pigeonVar_list[7] as Boolean?
      val cookieBannerHandlingGlobalRulesSubFrames = pigeonVar_list[8] as Boolean?
      val webContentIsolationStrategy = pigeonVar_list[9] as WebContentIsolationStrategy?
      val userAgent = pigeonVar_list[10] as String?
      val contentBlocking = pigeonVar_list[11] as ContentBlocking?
      val enterpriseRootsEnabled = pigeonVar_list[12] as Boolean?
      val dohSettings = pigeonVar_list[13] as DohSettings?
      val fingerprintingProtectionOverrides = pigeonVar_list[14] as String?
      val locales = pigeonVar_list[15] as List<String>?
      return GeckoEngineSettings(javascriptEnabled, trackingProtectionPolicy, httpsOnlyMode, globalPrivacyControlEnabled, preferredColorScheme, cookieBannerHandlingMode, cookieBannerHandlingModePrivateBrowsing, cookieBannerHandlingGlobalRules, cookieBannerHandlingGlobalRulesSubFrames, webContentIsolationStrategy, userAgent, contentBlocking, enterpriseRootsEnabled, dohSettings, fingerprintingProtectionOverrides, locales)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      javascriptEnabled,
      trackingProtectionPolicy,
      httpsOnlyMode,
      globalPrivacyControlEnabled,
      preferredColorScheme,
      cookieBannerHandlingMode,
      cookieBannerHandlingModePrivateBrowsing,
      cookieBannerHandlingGlobalRules,
      cookieBannerHandlingGlobalRulesSubFrames,
      webContentIsolationStrategy,
      userAgent,
      contentBlocking,
      enterpriseRootsEnabled,
      dohSettings,
      fingerprintingProtectionOverrides,
      locales,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is GeckoEngineSettings) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class AutocompleteResult (
  val input: String,
  val text: String,
  val url: String,
  val source: String,
  val totalItems: Long
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): AutocompleteResult {
      val input = pigeonVar_list[0] as String
      val text = pigeonVar_list[1] as String
      val url = pigeonVar_list[2] as String
      val source = pigeonVar_list[3] as String
      val totalItems = pigeonVar_list[4] as Long
      return AutocompleteResult(input, text, url, source, totalItems)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      input,
      text,
      url,
      source,
      totalItems,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is AutocompleteResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * Represents all the different supported types of data that can be found from long clicking
 * an element.
 *
 * Generated class from Pigeon that represents data sent in messages.
 * This class should not be extended by any user class outside of the generated file.
 */
sealed class HitResult 
/**
 * Default type if we're unable to match the type to anything. It may or may not have a src.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class UnknownHitResult (
  val src: String
) : HitResult()
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): UnknownHitResult {
      val src = pigeonVar_list[0] as String
      return UnknownHitResult(src)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      src,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is UnknownHitResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * If the HTML element was of type 'HTMLImageElement'.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class ImageHitResult (
  val src: String,
  val title: String? = null
) : HitResult()
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): ImageHitResult {
      val src = pigeonVar_list[0] as String
      val title = pigeonVar_list[1] as String?
      return ImageHitResult(src, title)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      src,
      title,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is ImageHitResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * If the HTML element was of type 'HTMLVideoElement'.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class VideoHitResult (
  val src: String,
  val title: String? = null
) : HitResult()
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): VideoHitResult {
      val src = pigeonVar_list[0] as String
      val title = pigeonVar_list[1] as String?
      return VideoHitResult(src, title)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      src,
      title,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is VideoHitResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * If the HTML element was of type 'HTMLAudioElement'.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class AudioHitResult (
  val src: String,
  val title: String? = null
) : HitResult()
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): AudioHitResult {
      val src = pigeonVar_list[0] as String
      val title = pigeonVar_list[1] as String?
      return AudioHitResult(src, title)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      src,
      title,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is AudioHitResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * If the HTML element was of type 'HTMLImageElement' and contained a URI.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class ImageSrcHitResult (
  val src: String,
  val uri: String
) : HitResult()
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): ImageSrcHitResult {
      val src = pigeonVar_list[0] as String
      val uri = pigeonVar_list[1] as String
      return ImageSrcHitResult(src, uri)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      src,
      uri,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is ImageSrcHitResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * The type used if the URI is prepended with 'tel:'.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class PhoneHitResult (
  val src: String
) : HitResult()
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): PhoneHitResult {
      val src = pigeonVar_list[0] as String
      return PhoneHitResult(src)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      src,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is PhoneHitResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * The type used if the URI is prepended with 'mailto:'.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class EmailHitResult (
  val src: String
) : HitResult()
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): EmailHitResult {
      val src = pigeonVar_list[0] as String
      return EmailHitResult(src)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      src,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is EmailHitResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * The type used if the URI is prepended with 'geo:'.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class GeoHitResult (
  val src: String
) : HitResult()
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): GeoHitResult {
      val src = pigeonVar_list[0] as String
      return GeoHitResult(src)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      src,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is GeoHitResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class DownloadState (
  val url: String,
  val fileName: String? = null,
  val contentType: String? = null,
  val contentLength: Long? = null,
  val currentBytesCopied: Long? = null,
  val status: DownloadStatus? = null,
  val userAgent: String? = null,
  val destinationDirectory: String? = null,
  val directoryPath: String? = null,
  val referrerUrl: String? = null,
  val skipConfirmation: Boolean? = null,
  val openInApp: Boolean? = null,
  val id: String? = null,
  val sessionId: String? = null,
  val private: Boolean? = null,
  val createdTime: Long? = null,
  val notificationId: Long? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): DownloadState {
      val url = pigeonVar_list[0] as String
      val fileName = pigeonVar_list[1] as String?
      val contentType = pigeonVar_list[2] as String?
      val contentLength = pigeonVar_list[3] as Long?
      val currentBytesCopied = pigeonVar_list[4] as Long?
      val status = pigeonVar_list[5] as DownloadStatus?
      val userAgent = pigeonVar_list[6] as String?
      val destinationDirectory = pigeonVar_list[7] as String?
      val directoryPath = pigeonVar_list[8] as String?
      val referrerUrl = pigeonVar_list[9] as String?
      val skipConfirmation = pigeonVar_list[10] as Boolean?
      val openInApp = pigeonVar_list[11] as Boolean?
      val id = pigeonVar_list[12] as String?
      val sessionId = pigeonVar_list[13] as String?
      val private = pigeonVar_list[14] as Boolean?
      val createdTime = pigeonVar_list[15] as Long?
      val notificationId = pigeonVar_list[16] as Long?
      return DownloadState(url, fileName, contentType, contentLength, currentBytesCopied, status, userAgent, destinationDirectory, directoryPath, referrerUrl, skipConfirmation, openInApp, id, sessionId, private, createdTime, notificationId)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      url,
      fileName,
      contentType,
      contentLength,
      currentBytesCopied,
      status,
      userAgent,
      destinationDirectory,
      directoryPath,
      referrerUrl,
      skipConfirmation,
      openInApp,
      id,
      sessionId,
      private,
      createdTime,
      notificationId,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is DownloadState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class ShareInternetResourceState (
  val url: String,
  val contentType: String? = null,
  val private: Boolean,
  val referrerUrl: String? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): ShareInternetResourceState {
      val url = pigeonVar_list[0] as String
      val contentType = pigeonVar_list[1] as String?
      val private = pigeonVar_list[2] as Boolean
      val referrerUrl = pigeonVar_list[3] as String?
      return ShareInternetResourceState(url, contentType, private, referrerUrl)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      url,
      contentType,
      private,
      referrerUrl,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is ShareInternetResourceState) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class AddonCollection (
  val serverURL: String,
  val collectionUser: String,
  val collectionName: String
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): AddonCollection {
      val serverURL = pigeonVar_list[0] as String
      val collectionUser = pigeonVar_list[1] as String
      val collectionName = pigeonVar_list[2] as String
      return AddonCollection(serverURL, collectionUser, collectionName)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      serverURL,
      collectionUser,
      collectionName,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is AddonCollection) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class GeckoPref (
  val name: String,
  val value: Any? = null,
  val defaultValue: Any? = null,
  val userValue: Any? = null,
  val hasUserChangedValue: Boolean
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): GeckoPref {
      val name = pigeonVar_list[0] as String
      val value = pigeonVar_list[1]
      val defaultValue = pigeonVar_list[2]
      val userValue = pigeonVar_list[3]
      val hasUserChangedValue = pigeonVar_list[4] as Boolean
      return GeckoPref(name, value, defaultValue, userValue, hasUserChangedValue)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      name,
      value,
      defaultValue,
      userValue,
      hasUserChangedValue,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is GeckoPref) {
      return false
    }
    if (this === other) {
      return true
    }
    return GeckoPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}
private open class GeckoPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          RestoreLocation.ofRaw(it.toInt())
        }
      }
      130.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          IconType.ofRaw(it.toInt())
        }
      }
      131.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          IconSize.ofRaw(it.toInt())
        }
      }
      132.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          IconSource.ofRaw(it.toInt())
        }
      }
      133.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          CookieSameSiteStatus.ofRaw(it.toInt())
        }
      }
      134.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          VisitType.ofRaw(it.toInt())
        }
      }
      135.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          SelectionPattern.ofRaw(it.toInt())
        }
      }
      136.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          WebExtensionActionType.ofRaw(it.toInt())
        }
      }
      137.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          GeckoSuggestionType.ofRaw(it.toInt())
        }
      }
      138.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          TrackingProtectionPolicy.ofRaw(it.toInt())
        }
      }
      139.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          HttpsOnlyMode.ofRaw(it.toInt())
        }
      }
      140.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          QueryParameterStripping.ofRaw(it.toInt())
        }
      }
      141.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          BounceTrackingProtectionMode.ofRaw(it.toInt())
        }
      }
      142.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          ColorScheme.ofRaw(it.toInt())
        }
      }
      143.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          CookieBannerHandlingMode.ofRaw(it.toInt())
        }
      }
      144.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          WebContentIsolationStrategy.ofRaw(it.toInt())
        }
      }
      145.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          DohSettingsMode.ofRaw(it.toInt())
        }
      }
      146.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          DownloadStatus.ofRaw(it.toInt())
        }
      }
      147.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          LogLevel.ofRaw(it.toInt())
        }
      }
      148.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          TranslationOptions.fromList(it)
        }
      }
      149.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          ReaderState.fromList(it)
        }
      }
      150.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          LastMediaAccessState.fromList(it)
        }
      }
      151.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          HistoryMetadataKey.fromList(it)
        }
      }
      152.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          PackageCategoryValue.fromList(it)
        }
      }
      153.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          ExternalPackage.fromList(it)
        }
      }
      154.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          LoadUrlFlagsValue.fromList(it)
        }
      }
      155.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          SourceValue.fromList(it)
        }
      }
      156.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          TabState.fromList(it)
        }
      }
      157.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          RecoverableTab.fromList(it)
        }
      }
      158.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          RecoverableBrowserState.fromList(it)
        }
      }
      159.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          IconRequest.fromList(it)
        }
      }
      160.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          ResourceSize.fromList(it)
        }
      }
      161.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          Resource.fromList(it)
        }
      }
      162.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          IconResult.fromList(it)
        }
      }
      163.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          CookiePartitionKey.fromList(it)
        }
      }
      164.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          Cookie.fromList(it)
        }
      }
      165.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          VisitInfo.fromList(it)
        }
      }
      166.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          HistoryItem.fromList(it)
        }
      }
      167.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          HistoryState.fromList(it)
        }
      }
      168.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          ReaderableState.fromList(it)
        }
      }
      169.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          SecurityInfoState.fromList(it)
        }
      }
      170.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          TabContentState.fromList(it)
        }
      }
      171.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          FindResultState.fromList(it)
        }
      }
      172.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          CustomSelectionAction.fromList(it)
        }
      }
      173.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          WebExtensionData.fromList(it)
        }
      }
      174.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          GeckoSuggestion.fromList(it)
        }
      }
      175.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          TabContent.fromList(it)
        }
      }
      176.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          ContentBlocking.fromList(it)
        }
      }
      177.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          DohSettings.fromList(it)
        }
      }
      178.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          GeckoEngineSettings.fromList(it)
        }
      }
      179.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          AutocompleteResult.fromList(it)
        }
      }
      180.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          UnknownHitResult.fromList(it)
        }
      }
      181.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          ImageHitResult.fromList(it)
        }
      }
      182.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          VideoHitResult.fromList(it)
        }
      }
      183.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          AudioHitResult.fromList(it)
        }
      }
      184.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          ImageSrcHitResult.fromList(it)
        }
      }
      185.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          PhoneHitResult.fromList(it)
        }
      }
      186.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          EmailHitResult.fromList(it)
        }
      }
      187.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          GeoHitResult.fromList(it)
        }
      }
      188.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          DownloadState.fromList(it)
        }
      }
      189.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          ShareInternetResourceState.fromList(it)
        }
      }
      190.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          AddonCollection.fromList(it)
        }
      }
      191.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          GeckoPref.fromList(it)
        }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }
  override fun writeValue(stream: ByteArrayOutputStream, value: Any?)   {
    when (value) {
      is RestoreLocation -> {
        stream.write(129)
        writeValue(stream, value.raw)
      }
      is IconType -> {
        stream.write(130)
        writeValue(stream, value.raw)
      }
      is IconSize -> {
        stream.write(131)
        writeValue(stream, value.raw)
      }
      is IconSource -> {
        stream.write(132)
        writeValue(stream, value.raw)
      }
      is CookieSameSiteStatus -> {
        stream.write(133)
        writeValue(stream, value.raw)
      }
      is VisitType -> {
        stream.write(134)
        writeValue(stream, value.raw)
      }
      is SelectionPattern -> {
        stream.write(135)
        writeValue(stream, value.raw)
      }
      is WebExtensionActionType -> {
        stream.write(136)
        writeValue(stream, value.raw)
      }
      is GeckoSuggestionType -> {
        stream.write(137)
        writeValue(stream, value.raw)
      }
      is TrackingProtectionPolicy -> {
        stream.write(138)
        writeValue(stream, value.raw)
      }
      is HttpsOnlyMode -> {
        stream.write(139)
        writeValue(stream, value.raw)
      }
      is QueryParameterStripping -> {
        stream.write(140)
        writeValue(stream, value.raw)
      }
      is BounceTrackingProtectionMode -> {
        stream.write(141)
        writeValue(stream, value.raw)
      }
      is ColorScheme -> {
        stream.write(142)
        writeValue(stream, value.raw)
      }
      is CookieBannerHandlingMode -> {
        stream.write(143)
        writeValue(stream, value.raw)
      }
      is WebContentIsolationStrategy -> {
        stream.write(144)
        writeValue(stream, value.raw)
      }
      is DohSettingsMode -> {
        stream.write(145)
        writeValue(stream, value.raw)
      }
      is DownloadStatus -> {
        stream.write(146)
        writeValue(stream, value.raw)
      }
      is LogLevel -> {
        stream.write(147)
        writeValue(stream, value.raw)
      }
      is TranslationOptions -> {
        stream.write(148)
        writeValue(stream, value.toList())
      }
      is ReaderState -> {
        stream.write(149)
        writeValue(stream, value.toList())
      }
      is LastMediaAccessState -> {
        stream.write(150)
        writeValue(stream, value.toList())
      }
      is HistoryMetadataKey -> {
        stream.write(151)
        writeValue(stream, value.toList())
      }
      is PackageCategoryValue -> {
        stream.write(152)
        writeValue(stream, value.toList())
      }
      is ExternalPackage -> {
        stream.write(153)
        writeValue(stream, value.toList())
      }
      is LoadUrlFlagsValue -> {
        stream.write(154)
        writeValue(stream, value.toList())
      }
      is SourceValue -> {
        stream.write(155)
        writeValue(stream, value.toList())
      }
      is TabState -> {
        stream.write(156)
        writeValue(stream, value.toList())
      }
      is RecoverableTab -> {
        stream.write(157)
        writeValue(stream, value.toList())
      }
      is RecoverableBrowserState -> {
        stream.write(158)
        writeValue(stream, value.toList())
      }
      is IconRequest -> {
        stream.write(159)
        writeValue(stream, value.toList())
      }
      is ResourceSize -> {
        stream.write(160)
        writeValue(stream, value.toList())
      }
      is Resource -> {
        stream.write(161)
        writeValue(stream, value.toList())
      }
      is IconResult -> {
        stream.write(162)
        writeValue(stream, value.toList())
      }
      is CookiePartitionKey -> {
        stream.write(163)
        writeValue(stream, value.toList())
      }
      is Cookie -> {
        stream.write(164)
        writeValue(stream, value.toList())
      }
      is VisitInfo -> {
        stream.write(165)
        writeValue(stream, value.toList())
      }
      is HistoryItem -> {
        stream.write(166)
        writeValue(stream, value.toList())
      }
      is HistoryState -> {
        stream.write(167)
        writeValue(stream, value.toList())
      }
      is ReaderableState -> {
        stream.write(168)
        writeValue(stream, value.toList())
      }
      is SecurityInfoState -> {
        stream.write(169)
        writeValue(stream, value.toList())
      }
      is TabContentState -> {
        stream.write(170)
        writeValue(stream, value.toList())
      }
      is FindResultState -> {
        stream.write(171)
        writeValue(stream, value.toList())
      }
      is CustomSelectionAction -> {
        stream.write(172)
        writeValue(stream, value.toList())
      }
      is WebExtensionData -> {
        stream.write(173)
        writeValue(stream, value.toList())
      }
      is GeckoSuggestion -> {
        stream.write(174)
        writeValue(stream, value.toList())
      }
      is TabContent -> {
        stream.write(175)
        writeValue(stream, value.toList())
      }
      is ContentBlocking -> {
        stream.write(176)
        writeValue(stream, value.toList())
      }
      is DohSettings -> {
        stream.write(177)
        writeValue(stream, value.toList())
      }
      is GeckoEngineSettings -> {
        stream.write(178)
        writeValue(stream, value.toList())
      }
      is AutocompleteResult -> {
        stream.write(179)
        writeValue(stream, value.toList())
      }
      is UnknownHitResult -> {
        stream.write(180)
        writeValue(stream, value.toList())
      }
      is ImageHitResult -> {
        stream.write(181)
        writeValue(stream, value.toList())
      }
      is VideoHitResult -> {
        stream.write(182)
        writeValue(stream, value.toList())
      }
      is AudioHitResult -> {
        stream.write(183)
        writeValue(stream, value.toList())
      }
      is ImageSrcHitResult -> {
        stream.write(184)
        writeValue(stream, value.toList())
      }
      is PhoneHitResult -> {
        stream.write(185)
        writeValue(stream, value.toList())
      }
      is EmailHitResult -> {
        stream.write(186)
        writeValue(stream, value.toList())
      }
      is GeoHitResult -> {
        stream.write(187)
        writeValue(stream, value.toList())
      }
      is DownloadState -> {
        stream.write(188)
        writeValue(stream, value.toList())
      }
      is ShareInternetResourceState -> {
        stream.write(189)
        writeValue(stream, value.toList())
      }
      is AddonCollection -> {
        stream.write(190)
        writeValue(stream, value.toList())
      }
      is GeckoPref -> {
        stream.write(191)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}


/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoBrowserApi {
  fun getGeckoVersion(): String
  fun initialize(logLevel: LogLevel, contentBlocking: ContentBlocking, addonCollection: AddonCollection?)
  fun showNativeFragment(): Boolean
  fun onTrimMemory(level: Long)

  companion object {
    /** The codec used by GeckoBrowserApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoBrowserApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoBrowserApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserApi.getGeckoVersion$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.getGeckoVersion())
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserApi.initialize$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val logLevelArg = args[0] as LogLevel
            val contentBlockingArg = args[1] as ContentBlocking
            val addonCollectionArg = args[2] as AddonCollection?
            val wrapped: List<Any?> = try {
              api.initialize(logLevelArg, contentBlockingArg, addonCollectionArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserApi.showNativeFragment$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.showNativeFragment())
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserApi.onTrimMemory$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val levelArg = args[0] as Long
            val wrapped: List<Any?> = try {
              api.onTrimMemory(levelArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoEngineSettingsApi {
  fun setDefaultSettings(settings: GeckoEngineSettings)
  fun updateRuntimeSettings(settings: GeckoEngineSettings)

  companion object {
    /** The codec used by GeckoEngineSettingsApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoEngineSettingsApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoEngineSettingsApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoEngineSettingsApi.setDefaultSettings$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val settingsArg = args[0] as GeckoEngineSettings
            val wrapped: List<Any?> = try {
              api.setDefaultSettings(settingsArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoEngineSettingsApi.updateRuntimeSettings$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val settingsArg = args[0] as GeckoEngineSettings
            val wrapped: List<Any?> = try {
              api.updateRuntimeSettings(settingsArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoSessionApi {
  fun loadUrl(tabId: String?, url: String, flags: LoadUrlFlagsValue, additionalHeaders: Map<String, String>?)
  fun loadData(tabId: String?, data: String, mimeType: String, encoding: String)
  fun reload(tabId: String?, flags: LoadUrlFlagsValue)
  fun stopLoading(tabId: String?)
  fun goBack(tabId: String?, userInteraction: Boolean)
  fun goForward(tabId: String?, userInteraction: Boolean)
  fun goToHistoryIndex(index: Long, tabId: String?)
  fun requestDesktopSite(tabId: String?, enable: Boolean)
  fun exitFullscreen(tabId: String?)
  fun saveToPdf(tabId: String?)
  fun printContent(tabId: String?)
  fun translate(tabId: String?, fromLanguage: String, toLanguage: String, options: TranslationOptions?)
  fun translateRestore(tabId: String?)
  fun crashRecovery(tabIds: List<String>?)
  fun purgeHistory()
  fun updateLastAccess(tabId: String?, lastAccess: Long?)
  fun requestScreenshot(sendBack: Boolean, callback: (Result<ByteArray?>) -> Unit)

  companion object {
    /** The codec used by GeckoSessionApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoSessionApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoSessionApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.loadUrl$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val urlArg = args[1] as String
            val flagsArg = args[2] as LoadUrlFlagsValue
            val additionalHeadersArg = args[3] as Map<String, String>?
            val wrapped: List<Any?> = try {
              api.loadUrl(tabIdArg, urlArg, flagsArg, additionalHeadersArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.loadData$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val dataArg = args[1] as String
            val mimeTypeArg = args[2] as String
            val encodingArg = args[3] as String
            val wrapped: List<Any?> = try {
              api.loadData(tabIdArg, dataArg, mimeTypeArg, encodingArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.reload$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val flagsArg = args[1] as LoadUrlFlagsValue
            val wrapped: List<Any?> = try {
              api.reload(tabIdArg, flagsArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.stopLoading$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val wrapped: List<Any?> = try {
              api.stopLoading(tabIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.goBack$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val userInteractionArg = args[1] as Boolean
            val wrapped: List<Any?> = try {
              api.goBack(tabIdArg, userInteractionArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.goForward$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val userInteractionArg = args[1] as Boolean
            val wrapped: List<Any?> = try {
              api.goForward(tabIdArg, userInteractionArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.goToHistoryIndex$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val indexArg = args[0] as Long
            val tabIdArg = args[1] as String?
            val wrapped: List<Any?> = try {
              api.goToHistoryIndex(indexArg, tabIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.requestDesktopSite$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val enableArg = args[1] as Boolean
            val wrapped: List<Any?> = try {
              api.requestDesktopSite(tabIdArg, enableArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.exitFullscreen$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val wrapped: List<Any?> = try {
              api.exitFullscreen(tabIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.saveToPdf$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val wrapped: List<Any?> = try {
              api.saveToPdf(tabIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.printContent$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val wrapped: List<Any?> = try {
              api.printContent(tabIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.translate$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val fromLanguageArg = args[1] as String
            val toLanguageArg = args[2] as String
            val optionsArg = args[3] as TranslationOptions?
            val wrapped: List<Any?> = try {
              api.translate(tabIdArg, fromLanguageArg, toLanguageArg, optionsArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.translateRestore$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val wrapped: List<Any?> = try {
              api.translateRestore(tabIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.crashRecovery$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdsArg = args[0] as List<String>?
            val wrapped: List<Any?> = try {
              api.crashRecovery(tabIdsArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.purgeHistory$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.purgeHistory()
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.updateLastAccess$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val lastAccessArg = args[1] as Long?
            val wrapped: List<Any?> = try {
              api.updateLastAccess(tabIdArg, lastAccessArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSessionApi.requestScreenshot$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val sendBackArg = args[0] as Boolean
            api.requestScreenshot(sendBackArg) { result: Result<ByteArray?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoTabsApi {
  fun syncEvents(onSelectedTabChange: Boolean, onTabListChange: Boolean, onTabContentStateChange: Boolean, onIconChange: Boolean, onSecurityInfoStateChange: Boolean, onReaderableStateChange: Boolean, onHistoryStateChange: Boolean, onFindResults: Boolean, onThumbnailChange: Boolean)
  fun selectTab(tabId: String)
  fun removeTab(tabId: String)
  fun addTab(url: String, selectTab: Boolean, startLoading: Boolean, parentId: String?, flags: LoadUrlFlagsValue, contextId: String?, source: SourceValue, private: Boolean, historyMetadata: HistoryMetadataKey?, additionalHeaders: Map<String, String>?): String
  fun removeAllTabs(recoverable: Boolean)
  fun removeTabs(ids: List<String>)
  fun removeNormalTabs()
  fun removePrivateTabs()
  fun undo()
  fun restoreTabsByList(tabs: List<RecoverableTab>, selectTabId: String?, restoreLocation: RestoreLocation)
  fun restoreTabsByBrowserState(state: RecoverableBrowserState, restoreLocation: RestoreLocation)
  /**
   * Selects an already existing tab with the matching [HistoryMetadataKey] or otherwise
   * creates a new tab with the given [url].
   */
  fun selectOrAddTabByHistory(url: String, historyMetadata: HistoryMetadataKey): String
  /** Selects an already existing tab displaying [url] or otherwise creates a new tab. */
  fun selectOrAddTabByUrl(url: String, private: Boolean, source: SourceValue, flags: LoadUrlFlagsValue, ignoreFragment: Boolean): String
  fun duplicateTab(selectTabId: String?, selectNewTab: Boolean, newContextId: String?): String
  fun moveTabs(tabIds: List<String>, targetTabId: String, placeAfter: Boolean)
  fun migratePrivateTabUseCase(tabId: String, alternativeUrl: String?): String

  companion object {
    /** The codec used by GeckoTabsApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoTabsApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoTabsApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.syncEvents$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val onSelectedTabChangeArg = args[0] as Boolean
            val onTabListChangeArg = args[1] as Boolean
            val onTabContentStateChangeArg = args[2] as Boolean
            val onIconChangeArg = args[3] as Boolean
            val onSecurityInfoStateChangeArg = args[4] as Boolean
            val onReaderableStateChangeArg = args[5] as Boolean
            val onHistoryStateChangeArg = args[6] as Boolean
            val onFindResultsArg = args[7] as Boolean
            val onThumbnailChangeArg = args[8] as Boolean
            val wrapped: List<Any?> = try {
              api.syncEvents(onSelectedTabChangeArg, onTabListChangeArg, onTabContentStateChangeArg, onIconChangeArg, onSecurityInfoStateChangeArg, onReaderableStateChangeArg, onHistoryStateChangeArg, onFindResultsArg, onThumbnailChangeArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.selectTab$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String
            val wrapped: List<Any?> = try {
              api.selectTab(tabIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removeTab$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String
            val wrapped: List<Any?> = try {
              api.removeTab(tabIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.addTab$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val urlArg = args[0] as String
            val selectTabArg = args[1] as Boolean
            val startLoadingArg = args[2] as Boolean
            val parentIdArg = args[3] as String?
            val flagsArg = args[4] as LoadUrlFlagsValue
            val contextIdArg = args[5] as String?
            val sourceArg = args[6] as SourceValue
            val privateArg = args[7] as Boolean
            val historyMetadataArg = args[8] as HistoryMetadataKey?
            val additionalHeadersArg = args[9] as Map<String, String>?
            val wrapped: List<Any?> = try {
              listOf(api.addTab(urlArg, selectTabArg, startLoadingArg, parentIdArg, flagsArg, contextIdArg, sourceArg, privateArg, historyMetadataArg, additionalHeadersArg))
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removeAllTabs$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val recoverableArg = args[0] as Boolean
            val wrapped: List<Any?> = try {
              api.removeAllTabs(recoverableArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removeTabs$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val idsArg = args[0] as List<String>
            val wrapped: List<Any?> = try {
              api.removeTabs(idsArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removeNormalTabs$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.removeNormalTabs()
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.removePrivateTabs$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.removePrivateTabs()
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.undo$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.undo()
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.restoreTabsByList$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabsArg = args[0] as List<RecoverableTab>
            val selectTabIdArg = args[1] as String?
            val restoreLocationArg = args[2] as RestoreLocation
            val wrapped: List<Any?> = try {
              api.restoreTabsByList(tabsArg, selectTabIdArg, restoreLocationArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.restoreTabsByBrowserState$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val stateArg = args[0] as RecoverableBrowserState
            val restoreLocationArg = args[1] as RestoreLocation
            val wrapped: List<Any?> = try {
              api.restoreTabsByBrowserState(stateArg, restoreLocationArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.selectOrAddTabByHistory$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val urlArg = args[0] as String
            val historyMetadataArg = args[1] as HistoryMetadataKey
            val wrapped: List<Any?> = try {
              listOf(api.selectOrAddTabByHistory(urlArg, historyMetadataArg))
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.selectOrAddTabByUrl$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val urlArg = args[0] as String
            val privateArg = args[1] as Boolean
            val sourceArg = args[2] as SourceValue
            val flagsArg = args[3] as LoadUrlFlagsValue
            val ignoreFragmentArg = args[4] as Boolean
            val wrapped: List<Any?> = try {
              listOf(api.selectOrAddTabByUrl(urlArg, privateArg, sourceArg, flagsArg, ignoreFragmentArg))
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.duplicateTab$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val selectTabIdArg = args[0] as String?
            val selectNewTabArg = args[1] as Boolean
            val newContextIdArg = args[2] as String?
            val wrapped: List<Any?> = try {
              listOf(api.duplicateTab(selectTabIdArg, selectNewTabArg, newContextIdArg))
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.moveTabs$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdsArg = args[0] as List<String>
            val targetTabIdArg = args[1] as String
            val placeAfterArg = args[2] as Boolean
            val wrapped: List<Any?> = try {
              api.moveTabs(tabIdsArg, targetTabIdArg, placeAfterArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabsApi.migratePrivateTabUseCase$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String
            val alternativeUrlArg = args[1] as String?
            val wrapped: List<Any?> = try {
              listOf(api.migratePrivateTabUseCase(tabIdArg, alternativeUrlArg))
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoFindApi {
  fun findAll(tabId: String?, text: String)
  fun findNext(tabId: String?, forward: Boolean)
  fun clearMatches(tabId: String?)

  companion object {
    /** The codec used by GeckoFindApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoFindApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoFindApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoFindApi.findAll$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val textArg = args[1] as String
            val wrapped: List<Any?> = try {
              api.findAll(tabIdArg, textArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoFindApi.findNext$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val forwardArg = args[1] as Boolean
            val wrapped: List<Any?> = try {
              api.findNext(tabIdArg, forwardArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoFindApi.clearMatches$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String?
            val wrapped: List<Any?> = try {
              api.clearMatches(tabIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoIconsApi {
  fun loadIcon(request: IconRequest, callback: (Result<IconResult>) -> Unit)

  companion object {
    /** The codec used by GeckoIconsApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoIconsApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoIconsApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoIconsApi.loadIcon$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val requestArg = args[0] as IconRequest
            api.loadIcon(requestArg) { result: Result<IconResult> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoPrefApi {
  fun getPrefList(callback: (Result<List<String>>) -> Unit)
  fun getPrefs(preferenceFilter: List<String>, callback: (Result<Map<String, GeckoPref>>) -> Unit)
  fun applyPrefs(prefs: Map<String, Any>, callback: (Result<Map<String, GeckoPref>>) -> Unit)
  fun resetPrefs(preferenceNames: List<String>, callback: (Result<Unit>) -> Unit)
  fun startObserveChanges()
  fun stopObserveChanges()
  fun registerPrefForObservation(name: String, callback: (Result<Unit>) -> Unit)
  fun unregisterPrefForObservation(name: String, callback: (Result<Unit>) -> Unit)

  companion object {
    /** The codec used by GeckoPrefApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoPrefApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoPrefApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.getPrefList$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.getPrefList{ result: Result<List<String>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.getPrefs$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val preferenceFilterArg = args[0] as List<String>
            api.getPrefs(preferenceFilterArg) { result: Result<Map<String, GeckoPref>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.applyPrefs$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val prefsArg = args[0] as Map<String, Any>
            api.applyPrefs(prefsArg) { result: Result<Map<String, GeckoPref>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.resetPrefs$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val preferenceNamesArg = args[0] as List<String>
            api.resetPrefs(preferenceNamesArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.startObserveChanges$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.startObserveChanges()
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.stopObserveChanges$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.stopObserveChanges()
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.registerPrefForObservation$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val nameArg = args[0] as String
            api.registerPrefForObservation(nameArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoPrefApi.unregisterPrefForObservation$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val nameArg = args[0] as String
            api.unregisterPrefForObservation(nameArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoMlApi {
  fun predictDocumentTopic(documents: List<String>, callback: (Result<String>) -> Unit)
  fun generateDocumentEmbeddings(documents: List<String>, callback: (Result<List<Any?>>) -> Unit)

  companion object {
    /** The codec used by GeckoMlApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoMlApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoMlApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoMlApi.predictDocumentTopic$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val documentsArg = args[0] as List<String>
            api.predictDocumentTopic(documentsArg) { result: Result<String> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoMlApi.generateDocumentEmbeddings$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val documentsArg = args[0] as List<String>
            api.generateDocumentEmbeddings(documentsArg) { result: Result<List<Any?>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoBrowserExtensionApi {
  fun getMarkdown(htmlList: List<String>, callback: (Result<List<Any>>) -> Unit)

  companion object {
    /** The codec used by GeckoBrowserExtensionApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoBrowserExtensionApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoBrowserExtensionApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoBrowserExtensionApi.getMarkdown$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val htmlListArg = args[0] as List<String>
            api.getMarkdown(htmlListArg) { result: Result<List<Any>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoContainerProxyApi {
  fun setProxyPort(port: Long)
  fun addContainerProxy(contextId: String)
  fun removeContainerProxy(contextId: String)
  fun healthcheck(callback: (Result<Boolean>) -> Unit)

  companion object {
    /** The codec used by GeckoContainerProxyApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoContainerProxyApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoContainerProxyApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoContainerProxyApi.setProxyPort$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val portArg = args[0] as Long
            val wrapped: List<Any?> = try {
              api.setProxyPort(portArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoContainerProxyApi.addContainerProxy$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val contextIdArg = args[0] as String
            val wrapped: List<Any?> = try {
              api.addContainerProxy(contextIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoContainerProxyApi.removeContainerProxy$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val contextIdArg = args[0] as String
            val wrapped: List<Any?> = try {
              api.removeContainerProxy(contextIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoContainerProxyApi.healthcheck$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.healthcheck{ result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoCookieApi {
  fun getCookie(firstPartyDomain: String?, name: String, partitionKey: CookiePartitionKey?, storeId: String?, url: String, callback: (Result<Cookie>) -> Unit)
  fun getAllCookies(domain: String?, firstPartyDomain: String?, name: String?, partitionKey: CookiePartitionKey?, storeId: String?, url: String, callback: (Result<List<Cookie>>) -> Unit)
  fun setCookie(domain: String?, expirationDate: Long?, firstPartyDomain: String?, httpOnly: Boolean?, name: String?, partitionKey: CookiePartitionKey?, path: String?, sameSite: CookieSameSiteStatus?, secure: Boolean?, storeId: String?, url: String, value: String?, callback: (Result<Unit>) -> Unit)
  fun removeCookie(firstPartyDomain: String?, name: String, partitionKey: CookiePartitionKey?, storeId: String?, url: String, callback: (Result<Unit>) -> Unit)

  companion object {
    /** The codec used by GeckoCookieApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoCookieApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoCookieApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoCookieApi.getCookie$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val firstPartyDomainArg = args[0] as String?
            val nameArg = args[1] as String
            val partitionKeyArg = args[2] as CookiePartitionKey?
            val storeIdArg = args[3] as String?
            val urlArg = args[4] as String
            api.getCookie(firstPartyDomainArg, nameArg, partitionKeyArg, storeIdArg, urlArg) { result: Result<Cookie> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoCookieApi.getAllCookies$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val domainArg = args[0] as String?
            val firstPartyDomainArg = args[1] as String?
            val nameArg = args[2] as String?
            val partitionKeyArg = args[3] as CookiePartitionKey?
            val storeIdArg = args[4] as String?
            val urlArg = args[5] as String
            api.getAllCookies(domainArg, firstPartyDomainArg, nameArg, partitionKeyArg, storeIdArg, urlArg) { result: Result<List<Cookie>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoCookieApi.setCookie$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val domainArg = args[0] as String?
            val expirationDateArg = args[1] as Long?
            val firstPartyDomainArg = args[2] as String?
            val httpOnlyArg = args[3] as Boolean?
            val nameArg = args[4] as String?
            val partitionKeyArg = args[5] as CookiePartitionKey?
            val pathArg = args[6] as String?
            val sameSiteArg = args[7] as CookieSameSiteStatus?
            val secureArg = args[8] as Boolean?
            val storeIdArg = args[9] as String?
            val urlArg = args[10] as String
            val valueArg = args[11] as String?
            api.setCookie(domainArg, expirationDateArg, firstPartyDomainArg, httpOnlyArg, nameArg, partitionKeyArg, pathArg, sameSiteArg, secureArg, storeIdArg, urlArg, valueArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoCookieApi.removeCookie$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val firstPartyDomainArg = args[0] as String?
            val nameArg = args[1] as String
            val partitionKeyArg = args[2] as CookiePartitionKey?
            val storeIdArg = args[3] as String?
            val urlArg = args[4] as String
            api.removeCookie(firstPartyDomainArg, nameArg, partitionKeyArg, storeIdArg, urlArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class GeckoStateEvents(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by GeckoStateEvents. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
  }
  fun onViewReadyStateChange(timestampArg: Long, stateArg: Boolean, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onViewReadyStateChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, stateArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onEngineReadyStateChange(timestampArg: Long, stateArg: Boolean, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onEngineReadyStateChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, stateArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onIconUpdate(timestampArg: Long, urlArg: String, bytesArg: ByteArray, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconUpdate$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, urlArg, bytesArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onTabAdded(timestampArg: Long, tabIdArg: String, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabAdded$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, tabIdArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onTabListChange(timestampArg: Long, tabIdsArg: List<String>, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabListChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, tabIdsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onSelectedTabChange(timestampArg: Long, idArg: String?, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSelectedTabChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, idArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onTabContentStateChange(timestampArg: Long, stateArg: TabContentState, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onTabContentStateChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, stateArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onHistoryStateChange(timestampArg: Long, idArg: String, stateArg: HistoryState, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onHistoryStateChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, idArg, stateArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onReaderableStateChange(timestampArg: Long, idArg: String, stateArg: ReaderableState, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onReaderableStateChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, idArg, stateArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onSecurityInfoStateChange(timestampArg: Long, idArg: String, stateArg: SecurityInfoState, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onSecurityInfoStateChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, idArg, stateArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onIconChange(timestampArg: Long, idArg: String, bytesArg: ByteArray?, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onIconChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, idArg, bytesArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onThumbnailChange(timestampArg: Long, idArg: String, bytesArg: ByteArray?, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onThumbnailChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, idArg, bytesArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onFindResults(timestampArg: Long, idArg: String, resultsArg: List<FindResultState>, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onFindResults$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, idArg, resultsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onLongPress(timestampArg: Long, idArg: String, hitResultArg: HitResult, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onLongPress$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, idArg, hitResultArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onScrollChange(timestampArg: Long, tabIdArg: String, scrollYArg: Long, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onScrollChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, tabIdArg, scrollYArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onPreferenceChange(timestampArg: Long, valueArg: GeckoPref, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoStateEvents.onPreferenceChange$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, valueArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class GeckoLogging(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by GeckoLogging. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
  }
  fun onLog(levelArg: LogLevel, messageArg: String, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoLogging.onLog$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(levelArg, messageArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface ReaderViewEvents {
  fun onToggleReaderView(enable: Boolean)
  fun onAppearanceButtonTap()

  companion object {
    /** The codec used by ReaderViewEvents. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `ReaderViewEvents` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: ReaderViewEvents?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.ReaderViewEvents.onToggleReaderView$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val enableArg = args[0] as Boolean
            val wrapped: List<Any?> = try {
              api.onToggleReaderView(enableArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.ReaderViewEvents.onAppearanceButtonTap$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.onAppearanceButtonTap()
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class ReaderViewController(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by ReaderViewController. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
  }
  fun appearanceButtonVisibility(timestampArg: Long, visibleArg: Boolean, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.ReaderViewController.appearanceButtonVisibility$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, visibleArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoSelectionActionController {
  fun setActions(actions: List<CustomSelectionAction>)

  companion object {
    /** The codec used by GeckoSelectionActionController. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoSelectionActionController` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoSelectionActionController?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSelectionActionController.setActions$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val actionsArg = args[0] as List<CustomSelectionAction>
            val wrapped: List<Any?> = try {
              api.setActions(actionsArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class GeckoSelectionActionEvents(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by GeckoSelectionActionEvents. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
  }
  fun performSelectionAction(idArg: String, selectedTextArg: String, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoSelectionActionEvents.performSelectionAction$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(idArg, selectedTextArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoAddonsApi {
  fun startAddonManagerActivity()
  fun invokeAddonAction(extensionId: String, actionType: WebExtensionActionType)
  fun installAddon(url: String, callback: (Result<Unit>) -> Unit)

  companion object {
    /** The codec used by GeckoAddonsApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoAddonsApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoAddonsApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonsApi.startAddonManagerActivity$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.startAddonManagerActivity()
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonsApi.invokeAddonAction$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val extensionIdArg = args[0] as String
            val actionTypeArg = args[1] as WebExtensionActionType
            val wrapped: List<Any?> = try {
              api.invokeAddonAction(extensionIdArg, actionTypeArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonsApi.installAddon$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val urlArg = args[0] as String
            api.installAddon(urlArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class GeckoAddonEvents(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by GeckoAddonEvents. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
  }
  fun onUpsertWebExtensionAction(timestampArg: Long, extensionIdArg: String, actionTypeArg: WebExtensionActionType, extensionDataArg: WebExtensionData, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpsertWebExtensionAction$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, extensionIdArg, actionTypeArg, extensionDataArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onRemoveWebExtensionAction(timestampArg: Long, extensionIdArg: String, actionTypeArg: WebExtensionActionType, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onRemoveWebExtensionAction$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, extensionIdArg, actionTypeArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onUpdateWebExtensionIcon(timestampArg: Long, extensionIdArg: String, actionTypeArg: WebExtensionActionType, iconArg: ByteArray, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoAddonEvents.onUpdateWebExtensionIcon$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, extensionIdArg, actionTypeArg, iconArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoSuggestionApi {
  fun getAutocompleteSuggestion(query: String, callback: (Result<AutocompleteResult?>) -> Unit)
  fun querySuggestions(text: String, providers: List<GeckoSuggestionType>)

  companion object {
    /** The codec used by GeckoSuggestionApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoSuggestionApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoSuggestionApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionApi.getAutocompleteSuggestion$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val queryArg = args[0] as String
            api.getAutocompleteSuggestion(queryArg) { result: Result<AutocompleteResult?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionApi.querySuggestions$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val textArg = args[0] as String
            val providersArg = args[1] as List<GeckoSuggestionType>
            val wrapped: List<Any?> = try {
              api.querySuggestions(textArg, providersArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class GeckoSuggestionEvents(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by GeckoSuggestionEvents. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
  }
  fun onSuggestionResult(timestampArg: Long, suggestionTypeArg: GeckoSuggestionType, suggestionsArg: List<GeckoSuggestion>, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoSuggestionEvents.onSuggestionResult$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, suggestionTypeArg, suggestionsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class GeckoTabContentEvents(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by GeckoTabContentEvents. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
  }
  fun onContentUpdate(timestampArg: Long, contentArg: TabContent, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.GeckoTabContentEvents.onContentUpdate$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, contentArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoDeleteBrowsingDataController {
  fun deleteTabs(callback: (Result<Unit>) -> Unit)
  fun deleteBrowsingHistory(callback: (Result<Unit>) -> Unit)
  fun deleteCookiesAndSiteData(callback: (Result<Unit>) -> Unit)
  fun deleteCachedFiles(callback: (Result<Unit>) -> Unit)
  fun deleteSitePermissions(callback: (Result<Unit>) -> Unit)
  fun deleteDownloads(callback: (Result<Unit>) -> Unit)

  companion object {
    /** The codec used by GeckoDeleteBrowsingDataController. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoDeleteBrowsingDataController` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoDeleteBrowsingDataController?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteTabs$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.deleteTabs{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteBrowsingHistory$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.deleteBrowsingHistory{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteCookiesAndSiteData$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.deleteCookiesAndSiteData{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteCachedFiles$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.deleteCachedFiles{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteSitePermissions$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.deleteSitePermissions{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoDeleteBrowsingDataController.deleteDownloads$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.deleteDownloads{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoHistoryApi {
  fun getDetailedVisits(startMillis: Long, endMillis: Long, excludeTypes: List<VisitType>, callback: (Result<List<VisitInfo>>) -> Unit)
  fun deleteVisit(url: String, timestamp: Long, callback: (Result<Unit>) -> Unit)
  fun deleteDownload(id: String, callback: (Result<Unit>) -> Unit)
  fun deleteVisitsBetween(startMillis: Long, endMillis: Long, callback: (Result<Unit>) -> Unit)

  companion object {
    /** The codec used by GeckoHistoryApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoHistoryApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoHistoryApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoHistoryApi.getDetailedVisits$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val startMillisArg = args[0] as Long
            val endMillisArg = args[1] as Long
            val excludeTypesArg = args[2] as List<VisitType>
            api.getDetailedVisits(startMillisArg, endMillisArg, excludeTypesArg) { result: Result<List<VisitInfo>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(GeckoPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoHistoryApi.deleteVisit$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val urlArg = args[0] as String
            val timestampArg = args[1] as Long
            api.deleteVisit(urlArg, timestampArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoHistoryApi.deleteDownload$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val idArg = args[0] as String
            api.deleteDownload(idArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoHistoryApi.deleteVisitsBetween$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val startMillisArg = args[0] as Long
            val endMillisArg = args[1] as Long
            api.deleteVisitsBetween(startMillisArg, endMillisArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(GeckoPigeonUtils.wrapError(error))
              } else {
                reply.reply(GeckoPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface GeckoDownloadsApi {
  fun requestDownload(tabId: String, state: DownloadState)
  fun copyInternetResource(tabId: String, state: ShareInternetResourceState)
  fun shareInternetResource(tabId: String, state: ShareInternetResourceState)

  companion object {
    /** The codec used by GeckoDownloadsApi. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
    /** Sets up an instance of `GeckoDownloadsApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: GeckoDownloadsApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoDownloadsApi.requestDownload$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String
            val stateArg = args[1] as DownloadState
            val wrapped: List<Any?> = try {
              api.requestDownload(tabIdArg, stateArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoDownloadsApi.copyInternetResource$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String
            val stateArg = args[1] as ShareInternetResourceState
            val wrapped: List<Any?> = try {
              api.copyInternetResource(tabIdArg, stateArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.flutter_mozilla_components.GeckoDownloadsApi.shareInternetResource$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tabIdArg = args[0] as String
            val stateArg = args[1] as ShareInternetResourceState
            val wrapped: List<Any?> = try {
              api.shareInternetResource(tabIdArg, stateArg)
              listOf(null)
            } catch (exception: Throwable) {
              GeckoPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class BrowserExtensionEvents(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by BrowserExtensionEvents. */
    val codec: MessageCodec<Any?> by lazy {
      GeckoPigeonCodec()
    }
  }
  fun onFeedRequested(timestampArg: Long, urlArg: String, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.flutter_mozilla_components.BrowserExtensionEvents.onFeedRequested$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(timestampArg, urlArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(GeckoPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
