// dart format width=80
import 'package:drift/internal/versioned_schema.dart' as i0;
import 'package:drift/drift.dart' as i1;
import 'package:drift/drift.dart'; // ignore_for_file: type=lint,unused_import

// GENERATED BY drift_dev, DO NOT MODIFY.
final class Schema2 extends i0.VersionedSchema {
  Schema2({required super.database}) : super(version: 2);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    bang,
    bangSync,
    bangFrequency,
    bangHistory,
    bangFts,
    bangDataView,
    bangAfterInsert,
    bangAfterDelete,
    bangAfterUpdate,
  ];
  late final Shape0 bang = Shape0(
    source: i0.VersionedTable(
      entityName: 'bang',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: ['PRIMARY KEY("trigger", "group")'],
      columns: [
        _column_0,
        _column_1,
        _column_2,
        _column_3,
        _column_4,
        _column_5,
        _column_6,
        _column_7,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape1 bangSync = Shape1(
    source: i0.VersionedTable(
      entityName: 'bang_sync',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [],
      columns: [_column_8, _column_9],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape2 bangFrequency = Shape2(
    source: i0.VersionedTable(
      entityName: 'bang_frequency',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'PRIMARY KEY("trigger", "group")',
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")ON DELETE CASCADE',
      ],
      columns: [_column_0, _column_1, _column_10, _column_11],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape3 bangHistory = Shape3(
    source: i0.VersionedTable(
      entityName: 'bang_history',
      withoutRowId: false,
      isStrict: false,
      tableConstraints: [
        'FOREIGN KEY("trigger", "group")REFERENCES bang("trigger", "group")',
      ],
      columns: [_column_12, _column_0, _column_1, _column_13],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape4 bangFts = Shape4(
    source: i0.VersionedVirtualTable(
      entityName: 'bang_fts',
      moduleAndArgs:
          'fts5(trigger, website_name, content=bang, prefix=\'2 3\')',
      columns: [_column_14, _column_15],
      attachedDatabase: database,
    ),
    alias: null,
  );
  late final Shape5 bangDataView = Shape5(
    source: i0.VersionedView(
      entityName: 'bang_data_view',
      createViewStmt:
          'CREATE VIEW bang_data_view AS SELECT b.*, bf.frequency, bf.last_used FROM bang AS b LEFT JOIN bang_frequency AS bf ON b."trigger" = bf."trigger" AND b."group" = bf."group";',
      columns: [
        _column_16,
        _column_17,
        _column_18,
        _column_19,
        _column_20,
        _column_21,
        _column_22,
        _column_23,
        _column_24,
        _column_25,
      ],
      attachedDatabase: database,
    ),
    alias: null,
  );
  final i1.Trigger bangAfterInsert = i1.Trigger(
    'CREATE TRIGGER bang_after_insert AFTER INSERT ON bang BEGIN INSERT INTO bang_fts ("rowid", "trigger", website_name) VALUES (new."rowid", new."trigger", new.website_name);END',
    'bang_after_insert',
  );
  final i1.Trigger bangAfterDelete = i1.Trigger(
    'CREATE TRIGGER bang_after_delete AFTER DELETE ON bang BEGIN INSERT INTO bang_fts (bang_fts, "rowid", "trigger", website_name) VALUES (\'delete\', old."rowid", old."trigger", old.website_name);END',
    'bang_after_delete',
  );
  final i1.Trigger bangAfterUpdate = i1.Trigger(
    'CREATE TRIGGER bang_after_update AFTER UPDATE ON bang BEGIN INSERT INTO bang_fts (bang_fts, "rowid", "trigger", website_name) VALUES (\'delete\', old."rowid", old."trigger", old.website_name);INSERT INTO bang_fts ("rowid", "trigger", website_name) VALUES (new."rowid", new."trigger", new.website_name);END',
    'bang_after_update',
  );
}

class Shape0 extends i0.VersionedTable {
  Shape0({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get domain =>
      columnsByName['domain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get urlTemplate =>
      columnsByName['url_template']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get subCategory =>
      columnsByName['sub_category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get format =>
      columnsByName['format']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_0(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'trigger',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<int> _column_1(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'group',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_2(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'website_name',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_3(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'domain',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_4(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'url_template',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<String> _column_5(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'category',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_6(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'sub_category',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_7(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'format',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );

class Shape1 extends i0.VersionedTable {
  Shape1({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get lastSync =>
      columnsByName['last_sync']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<int> _column_8(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'group',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'PRIMARY KEY NOT NULL',
    );
i1.GeneratedColumn<DateTime> _column_9(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'last_sync',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
      $customConstraints: 'NOT NULL',
    );

class Shape2 extends i0.VersionedTable {
  Shape2({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get frequency =>
      columnsByName['frequency']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get lastUsed =>
      columnsByName['last_used']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<int> _column_10(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'frequency',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
      $customConstraints: 'NOT NULL',
    );
i1.GeneratedColumn<DateTime> _column_11(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'last_used',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
      $customConstraints: 'NOT NULL',
    );

class Shape3 extends i0.VersionedTable {
  Shape3({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get searchQuery =>
      columnsByName['search_query']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get searchDate =>
      columnsByName['search_date']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<String> _column_12(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'search_query',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: 'UNIQUE NOT NULL',
    );
i1.GeneratedColumn<DateTime> _column_13(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'search_date',
      aliasedName,
      false,
      type: i1.DriftSqlType.dateTime,
      $customConstraints: 'NOT NULL',
    );

class Shape4 extends i0.VersionedVirtualTable {
  Shape4({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_14(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'trigger',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );
i1.GeneratedColumn<String> _column_15(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'website_name',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
      $customConstraints: '',
    );

class Shape5 extends i0.VersionedView {
  Shape5({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get trigger =>
      columnsByName['trigger']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get group =>
      columnsByName['group']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get websiteName =>
      columnsByName['website_name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get domain =>
      columnsByName['domain']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get urlTemplate =>
      columnsByName['url_template']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get subCategory =>
      columnsByName['sub_category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get format =>
      columnsByName['format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get frequency =>
      columnsByName['frequency']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<DateTime> get lastUsed =>
      columnsByName['last_used']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<String> _column_16(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'trigger',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_17(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'group',
      aliasedName,
      false,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<String> _column_18(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'website_name',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_19(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'domain',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_20(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'url_template',
      aliasedName,
      false,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_21(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'category',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_22(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'sub_category',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<String> _column_23(String aliasedName) =>
    i1.GeneratedColumn<String>(
      'format',
      aliasedName,
      true,
      type: i1.DriftSqlType.string,
    );
i1.GeneratedColumn<int> _column_24(String aliasedName) =>
    i1.GeneratedColumn<int>(
      'frequency',
      aliasedName,
      true,
      type: i1.DriftSqlType.int,
    );
i1.GeneratedColumn<DateTime> _column_25(String aliasedName) =>
    i1.GeneratedColumn<DateTime>(
      'last_used',
      aliasedName,
      true,
      type: i1.DriftSqlType.dateTime,
    );
i0.MigrationStepWithVersion migrationSteps({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
}) {
  return (currentVersion, database) async {
    switch (currentVersion) {
      case 1:
        final schema = Schema2(database: database);
        final migrator = i1.Migrator(database, schema);
        await from1To2(migrator, schema);
        return 2;
      default:
        throw ArgumentError.value('Unknown migration from $currentVersion');
    }
  };
}

i1.OnUpgrade stepByStep({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
}) => i0.VersionedSchema.stepByStepHelper(
  step: migrationSteps(from1To2: from1To2),
);
