/*
 *     Copyright (C) 2020  Marek Materzok
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package eu.tilk.cdlcplayer.shapes

import android.util.Log
import java.nio.IntBuffer
import android.opengl.GLES31.*
import kotlin.math.tanh

const val COORDS_PER_VERTEX = 3

fun logistic(x : Float) = 0.5f + 0.5f * tanh(x)
fun dLogistic(x : Float) = logistic(x) * logistic(-x)

val shapes = listOf(
    Anchor, Beat, Chord, ChordInfo, ChordSustain, EmptyStringNote, Finger, FretNumbers,
    Frets, Neck, NeckInlays, Note, NoteLocator, NotePredictor, NoteTail
)