package eu.pretix.libpretixprint

import eu.pretix.libpretixprint.templating.ContentProvider
import eu.pretix.libpretixprint.templating.FontRegistry
import eu.pretix.libpretixprint.templating.FontSpecification
import eu.pretix.libpretixprint.templating.Layout
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import org.junit.Test
import java.io.InputStream
import kotlin.io.path.Path
import kotlin.io.path.absolutePathString

class ManualTest() {

    @Test
    fun testTextContainer() {
        val testData = "[{\"type\":\"poweredby\",\"page\":1,\"left\":\"88.72\",\"bottom\":\"10.00\",\"size\":\"20.00\",\"content\":\"dark\"},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"10.00\",\"bottom\":\"257.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"center top\",\"text_i18n\":{},\"rotation\":0,\"align\":\"center\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"10.00\",\"bottom\":\"277.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"left top\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"50.00\",\"bottom\":\"277.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"left center\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"90.00\",\"bottom\":\"277.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"left bottom\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"bottom\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"130.00\",\"bottom\":\"277.00\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":false,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"regular\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"170.00\",\"bottom\":\"277.00\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"bold\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"170.00\",\"bottom\":\"257.00\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Baloo Bhaijaan\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"other font\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"130.00\",\"bottom\":\"257.00\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":false,\"italic\":true,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"italic\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"90.00\",\"bottom\":\"257.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"center bottom\",\"text_i18n\":{},\"rotation\":0,\"align\":\"center\",\"verticalalign\":\"bottom\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"50.00\",\"bottom\":\"257.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"center center\",\"text_i18n\":{},\"rotation\":0,\"align\":\"center\",\"verticalalign\":\"middle\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"10.00\",\"bottom\":\"237.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"right top\",\"text_i18n\":{},\"rotation\":0,\"align\":\"right\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"170.00\",\"bottom\":\"237.00\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other_i18n\",\"text\":\"german text\",\"text_i18n\":{\"de\":\"german text\",\"en\":\"english text\"},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"130.00\",\"bottom\":\"237.00\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[255,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"other color\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"90.00\",\"bottom\":\"237.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"right bottom\",\"text_i18n\":{},\"rotation\":0,\"align\":\"right\",\"verticalalign\":\"bottom\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"50.00\",\"bottom\":\"237.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"right center\",\"text_i18n\":{},\"rotation\":0,\"align\":\"right\",\"verticalalign\":\"middle\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"10.00\",\"bottom\":\"217.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Text splits to muitiple lines\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"9.36\",\"bottom\":\"144.28\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"top center -10deg\",\"text_i18n\":{},\"rotation\":-10,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"170.89\",\"bottom\":\"135.01\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"bottom right -45deg\",\"text_i18n\":{},\"rotation\":-45,\"align\":\"right\",\"verticalalign\":\"bottom\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"150.23\",\"bottom\":\"157.02\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"center center 90deg\",\"text_i18n\":{},\"rotation\":90,\"align\":\"center\",\"verticalalign\":\"middle\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"100.02\",\"bottom\":\"126.95\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"center center -90deg\",\"text_i18n\":{},\"rotation\":-90,\"align\":\"center\",\"verticalalign\":\"middle\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"49.11\",\"bottom\":\"141.63\",\"fontsize\":\"12.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"center center -20deg but text is too long and flows out of field\",\"text_i18n\":{},\"rotation\":-20,\"align\":\"center\",\"verticalalign\":\"middle\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"50.00\",\"bottom\":\"217.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"TestIsHardToSplitSpaceless\",\"text_i18n\":{},\"rotation\":0,\"align\":\"center\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"90.00\",\"bottom\":\"217.00\",\"fontsize\":\"12.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Large Text\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"170.00\",\"bottom\":\"217.00\",\"fontsize\":\"12.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Large Text Way to Long for this Field flowing up\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"bottom\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"130.00\",\"bottom\":\"217.00\",\"fontsize\":\"12.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Large Text Way to Long for this Field flowing down\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"10.00\",\"bottom\":\"197.00\",\"fontsize\":\"12.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Large Text Way to Long for this Field flowing centered\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"50.00\",\"bottom\":\"197.00\",\"fontsize\":\"12.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Large Text Way to Long for this Field being resized centered\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"90.00\",\"bottom\":\"197.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1.5\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Text splits to muitiple lines line height 1.5\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"170.00\",\"bottom\":\"197.00\",\"fontsize\":\"12.0\",\"lineheight\":\"1.5\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Text too large for field lineheight 1.5 autoscaled\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":true,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"130.00\",\"bottom\":\"197.00\",\"fontsize\":\"12.0\",\"lineheight\":\"1.5\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Text too large for field lineheight 1.5\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"10.00\",\"bottom\":\"177.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"text\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"50.00\",\"bottom\":\"177.00\",\"fontsize\":\"16.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Dr. Sabine Leutheusser-Schnarrenberger\",\"text_i18n\":{},\"rotation\":0,\"align\":\"center\",\"verticalalign\":\"top\",\"autoresize\":true,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"90.00\",\"bottom\":\"177.00\",\"fontsize\":\"16.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Vielzulangernamedernichtpasst\",\"text_i18n\":{},\"rotation\":0,\"align\":\"center\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":true},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"170.00\",\"bottom\":\"177.00\",\"fontsize\":\"8.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"textthatislongandhardtosplit\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"top\",\"autoresize\":false,\"splitlongwords\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"130.00\",\"bottom\":\"177.00\",\"fontsize\":\"16.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":true,\"italic\":false,\"width\":\"30.00\",\"height\":\"10.00\",\"content\":\"other\",\"text\":\"Vielzulangernamedernichtpasst\",\"text_i18n\":{},\"rotation\":0,\"align\":\"center\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":false}]";
        FontRegistry.getInstance().add("Open Sans", FontSpecification.Style.REGULAR, getResource("fonts/OpenSans-Regular.ttf")!!.path)
        FontRegistry.getInstance().add("Open Sans", FontSpecification.Style.BOLD, getResource("fonts/OpenSans-Bold.ttf")!!.path)
        FontRegistry.getInstance().add("Open Sans", FontSpecification.Style.BOLDITALIC, getResource("fonts/OpenSans-BoldItalic.ttf")!!.path)
        FontRegistry.getInstance().add("Open Sans", FontSpecification.Style.ITALIC, getResource("fonts/OpenSans-Italic.ttf")!!.path)
        System.out.println(getResource("fonts/OpenSans-Regular.ttf")!!.path)
        val cp: ContentProvider = object : ContentProvider {
            override fun getTextContent(content: String, text: String?, textI18n: JSONObject?): String {
                return text ?: content
            }

            override fun getBarcodeContent(content: String, text: String?, textI18n: JSONObject?): String {
                return "asdsdgncvbcövjbhdkfjghd"
            }

            override fun getImageContent(content: String): InputStream {
                throw NotImplementedError()
            }
        }
        val i: MutableList<ContentProvider> = ArrayList()
        i.add(cp)
        val l = Layout(
                JSONArray(testData),
                getResource("bg-textcontainer-test.pdf")!!.file,
                i.iterator()
        )
        val outfile = Path(javaClass.getResource("/").path, "textcontainer-test.pdf")
        l.render(outfile.absolutePathString())
        System.out.println("Out: " + outfile.absolutePathString())
    }

    @Test
    fun testQRCode() {
        val testData = "[{\"type\":\"barcodearea\",\"page\":1,\"left\":\"12.00\",\"bottom\":\"250.05\",\"size\":\"30.00\",\"content\":\"secret\",\"text\":\"\",\"text_i18n\":{},\"nowhitespace\":true,\"color\":[0,0,0,1]},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"12.70\",\"bottom\":\"280.61\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":false,\"italic\":false,\"width\":\"38.11\",\"height\":\"3.68\",\"content\":\"other\",\"text\":\"Black 30mm gapless\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":true},{\"type\":\"barcodearea\",\"page\":1,\"left\":\"72.00\",\"bottom\":\"250.05\",\"size\":\"30.00\",\"content\":\"secret\",\"text\":\"\",\"text_i18n\":{},\"nowhitespace\":true,\"color\":[255,0,0,1]},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"72.70\",\"bottom\":\"280.61\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":false,\"italic\":false,\"width\":\"38.11\",\"height\":\"3.68\",\"content\":\"other\",\"text\":\"Red 30mm gapless\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":true},{\"type\":\"barcodearea\",\"page\":1,\"left\":\"132.00\",\"bottom\":\"250.05\",\"size\":\"30.00\",\"content\":\"secret\",\"text\":\"\",\"text_i18n\":{},\"nowhitespace\":true,\"color\":[59,28,74,1]},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"132.70\",\"bottom\":\"280.61\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":false,\"italic\":false,\"width\":\"38.11\",\"height\":\"3.68\",\"content\":\"other\",\"text\":\"Purple 30mm gapless\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":true},{\"type\":\"barcodearea\",\"page\":1,\"left\":\"12.00\",\"bottom\":\"210.05\",\"size\":\"30.00\",\"content\":\"secret\",\"text\":\"tdmruoekvkpbv1o2mv8xccvqcikvr58u\",\"text_i18n\":{},\"nowhitespace\":false},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"12.70\",\"bottom\":\"240.61\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":false,\"italic\":false,\"width\":\"38.11\",\"height\":\"3.68\",\"content\":\"other\",\"text\":\"Black 30mm\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":true},{\"type\":\"barcodearea\",\"page\":1,\"left\":\"72.00\",\"bottom\":\"210.05\",\"size\":\"30.00\",\"content\":\"secret\",\"text\":\"tdmruoekvkpbv1o2mv8xccvqcikvr58u\",\"text_i18n\":{},\"nowhitespace\":false,\"color\":[255,0,0,1]},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"72.70\",\"bottom\":\"240.61\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":false,\"italic\":false,\"width\":\"38.11\",\"height\":\"3.68\",\"content\":\"other\",\"text\":\"Red 30mm\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":true},{\"type\":\"barcodearea\",\"page\":1,\"left\":\"132.00\",\"bottom\":\"210.05\",\"size\":\"30.00\",\"content\":\"secret\",\"text\":\"tdmruoekvkpbv1o2mv8xccvqcikvr58u\",\"text_i18n\":{},\"nowhitespace\":false,\"color\":[59,28,74,1]},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"132.70\",\"bottom\":\"240.61\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":false,\"italic\":false,\"width\":\"38.11\",\"height\":\"3.68\",\"content\":\"other\",\"text\":\"Purple 30mm\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":true},{\"type\":\"barcodearea\",\"page\":1,\"left\":\"12.00\",\"bottom\":\"170.05\",\"size\":\"30.00\",\"content\":\"other\",\"text\":\"YES I AM A QR CODE\",\"text_i18n\":{},\"nowhitespace\":true,\"color\":[0,0,0,1]},{\"type\":\"textcontainer\",\"page\":1,\"locale\":\"\",\"left\":\"12.70\",\"bottom\":\"200.61\",\"fontsize\":\"13.0\",\"lineheight\":\"1\",\"color\":[0,0,0,1],\"fontfamily\":\"Open Sans\",\"bold\":false,\"italic\":false,\"width\":\"38.11\",\"height\":\"3.68\",\"content\":\"other\",\"text\":\"Static content\",\"text_i18n\":{},\"rotation\":0,\"align\":\"left\",\"verticalalign\":\"middle\",\"autoresize\":true,\"splitlongwords\":true}]"
        FontRegistry.getInstance().add("Open Sans", FontSpecification.Style.REGULAR, getResource("fonts/OpenSans-Regular.ttf")!!.path)
        FontRegistry.getInstance().add("Open Sans", FontSpecification.Style.BOLD, getResource("fonts/OpenSans-Bold.ttf")!!.path)
        FontRegistry.getInstance().add("Open Sans", FontSpecification.Style.BOLDITALIC, getResource("fonts/OpenSans-BoldItalic.ttf")!!.path)
        FontRegistry.getInstance().add("Open Sans", FontSpecification.Style.ITALIC, getResource("fonts/OpenSans-Italic.ttf")!!.path)
        System.out.println(getResource("fonts/OpenSans-Regular.ttf")!!.path)
        val cp: ContentProvider = object : ContentProvider {
            override fun getTextContent(content: String, text: String?, textI18n: JSONObject?): String {
                return text ?: content
            }

            override fun getBarcodeContent(content: String, text: String?, textI18n: JSONObject?): String {
                if (content == "other") {
                    return text ?: content
                }
                return "NoY+a0uDu1436Jba8PpV5slMJkCz1zH0R/2x+qIG+PLVCFJjlMwL/TPZhrmtfO/4RqbITBwprlG2l+Up7p8e8CAMAgyApCxbql2NxpWO0JVCKAEASAQA"
            }

            override fun getImageContent(content: String): InputStream {
                throw NotImplementedError()
            }
        }
        val i: MutableList<ContentProvider> = ArrayList()
        i.add(cp)
        val l = Layout(
            JSONArray(testData),
            getResource("bg-a4-empty.pdf")!!.file,
            i.iterator()
        )
        val outfile = Path(javaClass.getResource("/").path, "qrcode-test.pdf")
        l.render(outfile.absolutePathString())
        System.out.println("Out: " + outfile.absolutePathString())
    }
}
