// // Copyright 2024 The Flutter Workmanager Authors. All rights reserved.
// // Use of this source code is governed by a MIT-style license that can be
// // found in the LICENSE file.
// Autogenerated from Pigeon (v26.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

List<Object?> wrapResponse({Object? result, PlatformException? error, bool empty = false}) {
  if (empty) {
    return <Object?>[];
  }
  if (error == null) {
    return <Object?>[result];
  }
  return <Object?>[error.code, error.message, error.details];
}
bool _deepEquals(Object? a, Object? b) {
  if (a is List && b is List) {
    return a.length == b.length &&
        a.indexed
        .every(((int, dynamic) item) => _deepEquals(item.$2, b[item.$1]));
  }
  if (a is Map && b is Map) {
    return a.length == b.length && a.entries.every((MapEntry<Object?, Object?> entry) =>
        (b as Map<Object?, Object?>).containsKey(entry.key) &&
        _deepEquals(entry.value, b[entry.key]));
  }
  return a == b;
}


/// Task status for debugging and monitoring.
enum TaskStatus {
  /// Task has been scheduled
  scheduled,
  /// Task has started execution
  started,
  /// Task completed successfully
  completed,
  /// Task failed
  failed,
  /// Task was cancelled
  cancelled,
  /// Task is being retried
  retrying,
  /// Task was rescheduled for later execution
  rescheduled,
}

/// An enumeration of various network types that can be used as Constraints for work.
///
/// Fully supported on Android.
///
/// On iOS, this enumeration is used to define whether a piece of work requires
/// internet connectivity, by checking for either [NetworkType.connected] or
/// [NetworkType.metered].
enum NetworkType {
  /// Any working network connection is required for this work.
  connected,
  /// A metered network connection is required for this work.
  metered,
  /// Default value. A network is not required for this work.
  notRequired,
  /// A non-roaming network connection is required for this work.
  notRoaming,
  /// An unmetered network connection is required for this work.
  unmetered,
  /// A temporarily unmetered Network. This capability will be set for
  /// networks that are generally metered, but are currently unmetered.
  ///
  /// Android API 30+
  temporarilyUnmetered,
}

/// An enumeration of backoff policies when retrying work.
/// These policies are used when you have a return ListenableWorker.Result.retry() from a worker to determine the correct backoff time.
/// Backoff policies are set in WorkRequest.Builder.setBackoffCriteria(BackoffPolicy, long, TimeUnit) or one of its variants.
enum BackoffPolicy {
  /// Used to indicate that WorkManager should increase the backoff time exponentially
  exponential,
  /// Used to indicate that WorkManager should increase the backoff time linearly
  linear,
}

/// An enumeration of the conflict resolution policies when registering one-off work with the same unique name.
///
/// This policy determines what happens when you register a one-off task with a unique name that already exists.
///
/// See: https://developer.android.com/reference/androidx/work/ExistingWorkPolicy
enum ExistingWorkPolicy {
  /// If there is existing pending (uncompleted) work with the same unique name, append the newly-specified work as a child of all the leaves of that work sequence.
  append,
  /// If there is existing pending (uncompleted) work with the same unique name, do nothing.
  /// The new work request is ignored and the existing work continues unchanged.
  keep,
  /// If there is existing pending (uncompleted) work with the same unique name, cancel and delete it.
  /// The new work request replaces the existing one entirely.
  replace,
  /// If there is existing pending (uncompleted) work with the same unique name, it will be updated with the new specification.
  /// Note: This maps to appendOrReplace in the native implementation.
  update,
}

/// An enumeration of the conflict resolution policies when registering periodic work with the same unique name.
///
/// This policy determines what happens when you register a periodic task with a unique name that already exists.
/// This is especially important during development when you might register the same task multiple times
/// with different frequencies or configurations.
///
/// See: https://developer.android.com/reference/androidx/work/ExistingPeriodicWorkPolicy
enum ExistingPeriodicWorkPolicy {
  /// If there is existing pending (uncompleted) work with the same unique name, do nothing.
  /// The new work request is ignored and the existing work continues unchanged.
  ///
  /// **Warning**: If you previously registered a periodic task with a short frequency
  /// (e.g., 15 minutes) and later register the same task with a longer frequency (e.g., 2 hours),
  /// the task will continue running at the original short frequency. This can cause confusion
  /// during development. Consider using [update] instead.
  keep,
  /// If there is existing pending (uncompleted) work with the same unique name, cancel and delete it.
  /// The new work request replaces the existing one entirely.
  ///
  /// **Deprecated**: Android recommends using [update] instead for less disruptive updates.
  replace,
  /// If there is existing pending (uncompleted) work with the same unique name, it will be updated with the new specification.
  ///
  /// **Recommended** - updates existing work without canceling running workers and preserves original timing.
  /// This is the default policy for periodic tasks to prevent frequency confusion.
  ///
  /// Available since WorkManager 2.8.0.
  update,
}

/// An enumeration of policies that help determine out of quota behavior for expedited jobs.
///
/// Only supported on Android.
enum OutOfQuotaPolicy {
  /// When the app does not have any expedited job quota, the expedited work request will
  /// fallback to a regular work request.
  runAsNonExpeditedWorkRequest,
  /// When the app does not have any expedited job quota, the expedited work request will
  /// we dropped and no work requests are enqueued.
  dropWorkRequest,
}

class Constraints {
  Constraints({
    this.networkType,
    this.requiresBatteryNotLow,
    this.requiresCharging,
    this.requiresDeviceIdle,
    this.requiresStorageNotLow,
  });

  NetworkType? networkType;

  bool? requiresBatteryNotLow;

  bool? requiresCharging;

  bool? requiresDeviceIdle;

  bool? requiresStorageNotLow;

  List<Object?> _toList() {
    return <Object?>[
      networkType,
      requiresBatteryNotLow,
      requiresCharging,
      requiresDeviceIdle,
      requiresStorageNotLow,
    ];
  }

  Object encode() {
    return _toList();  }

  static Constraints decode(Object result) {
    result as List<Object?>;
    return Constraints(
      networkType: result[0] as NetworkType?,
      requiresBatteryNotLow: result[1] as bool?,
      requiresCharging: result[2] as bool?,
      requiresDeviceIdle: result[3] as bool?,
      requiresStorageNotLow: result[4] as bool?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! Constraints || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class BackoffPolicyConfig {
  BackoffPolicyConfig({
    this.backoffPolicy,
    this.backoffDelayMillis,
  });

  BackoffPolicy? backoffPolicy;

  int? backoffDelayMillis;

  List<Object?> _toList() {
    return <Object?>[
      backoffPolicy,
      backoffDelayMillis,
    ];
  }

  Object encode() {
    return _toList();  }

  static BackoffPolicyConfig decode(Object result) {
    result as List<Object?>;
    return BackoffPolicyConfig(
      backoffPolicy: result[0] as BackoffPolicy?,
      backoffDelayMillis: result[1] as int?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! BackoffPolicyConfig || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class InitializeRequest {
  InitializeRequest({
    required this.callbackHandle,
  });

  int callbackHandle;

  List<Object?> _toList() {
    return <Object?>[
      callbackHandle,
    ];
  }

  Object encode() {
    return _toList();  }

  static InitializeRequest decode(Object result) {
    result as List<Object?>;
    return InitializeRequest(
      callbackHandle: result[0]! as int,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! InitializeRequest || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class OneOffTaskRequest {
  OneOffTaskRequest({
    required this.uniqueName,
    required this.taskName,
    this.inputData,
    this.initialDelaySeconds,
    this.constraints,
    this.backoffPolicy,
    this.tag,
    this.existingWorkPolicy,
    this.outOfQuotaPolicy,
  });

  String uniqueName;

  String taskName;

  Map<String?, Object?>? inputData;

  int? initialDelaySeconds;

  Constraints? constraints;

  BackoffPolicyConfig? backoffPolicy;

  String? tag;

  ExistingWorkPolicy? existingWorkPolicy;

  OutOfQuotaPolicy? outOfQuotaPolicy;

  List<Object?> _toList() {
    return <Object?>[
      uniqueName,
      taskName,
      inputData,
      initialDelaySeconds,
      constraints,
      backoffPolicy,
      tag,
      existingWorkPolicy,
      outOfQuotaPolicy,
    ];
  }

  Object encode() {
    return _toList();  }

  static OneOffTaskRequest decode(Object result) {
    result as List<Object?>;
    return OneOffTaskRequest(
      uniqueName: result[0]! as String,
      taskName: result[1]! as String,
      inputData: (result[2] as Map<Object?, Object?>?)?.cast<String?, Object?>(),
      initialDelaySeconds: result[3] as int?,
      constraints: result[4] as Constraints?,
      backoffPolicy: result[5] as BackoffPolicyConfig?,
      tag: result[6] as String?,
      existingWorkPolicy: result[7] as ExistingWorkPolicy?,
      outOfQuotaPolicy: result[8] as OutOfQuotaPolicy?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! OneOffTaskRequest || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class PeriodicTaskRequest {
  PeriodicTaskRequest({
    required this.uniqueName,
    required this.taskName,
    required this.frequencySeconds,
    this.flexIntervalSeconds,
    this.inputData,
    this.initialDelaySeconds,
    this.constraints,
    this.backoffPolicy,
    this.tag,
    this.existingWorkPolicy,
  });

  String uniqueName;

  String taskName;

  int frequencySeconds;

  int? flexIntervalSeconds;

  Map<String?, Object?>? inputData;

  int? initialDelaySeconds;

  Constraints? constraints;

  BackoffPolicyConfig? backoffPolicy;

  String? tag;

  ExistingPeriodicWorkPolicy? existingWorkPolicy;

  List<Object?> _toList() {
    return <Object?>[
      uniqueName,
      taskName,
      frequencySeconds,
      flexIntervalSeconds,
      inputData,
      initialDelaySeconds,
      constraints,
      backoffPolicy,
      tag,
      existingWorkPolicy,
    ];
  }

  Object encode() {
    return _toList();  }

  static PeriodicTaskRequest decode(Object result) {
    result as List<Object?>;
    return PeriodicTaskRequest(
      uniqueName: result[0]! as String,
      taskName: result[1]! as String,
      frequencySeconds: result[2]! as int,
      flexIntervalSeconds: result[3] as int?,
      inputData: (result[4] as Map<Object?, Object?>?)?.cast<String?, Object?>(),
      initialDelaySeconds: result[5] as int?,
      constraints: result[6] as Constraints?,
      backoffPolicy: result[7] as BackoffPolicyConfig?,
      tag: result[8] as String?,
      existingWorkPolicy: result[9] as ExistingPeriodicWorkPolicy?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! PeriodicTaskRequest || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}

class ProcessingTaskRequest {
  ProcessingTaskRequest({
    required this.uniqueName,
    required this.taskName,
    this.inputData,
    this.initialDelaySeconds,
    this.networkType,
    this.requiresCharging,
  });

  String uniqueName;

  String taskName;

  Map<String?, Object?>? inputData;

  int? initialDelaySeconds;

  NetworkType? networkType;

  bool? requiresCharging;

  List<Object?> _toList() {
    return <Object?>[
      uniqueName,
      taskName,
      inputData,
      initialDelaySeconds,
      networkType,
      requiresCharging,
    ];
  }

  Object encode() {
    return _toList();  }

  static ProcessingTaskRequest decode(Object result) {
    result as List<Object?>;
    return ProcessingTaskRequest(
      uniqueName: result[0]! as String,
      taskName: result[1]! as String,
      inputData: (result[2] as Map<Object?, Object?>?)?.cast<String?, Object?>(),
      initialDelaySeconds: result[3] as int?,
      networkType: result[4] as NetworkType?,
      requiresCharging: result[5] as bool?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ProcessingTaskRequest || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList())
;
}


class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    }    else if (value is TaskStatus) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    }    else if (value is NetworkType) {
      buffer.putUint8(130);
      writeValue(buffer, value.index);
    }    else if (value is BackoffPolicy) {
      buffer.putUint8(131);
      writeValue(buffer, value.index);
    }    else if (value is ExistingWorkPolicy) {
      buffer.putUint8(132);
      writeValue(buffer, value.index);
    }    else if (value is ExistingPeriodicWorkPolicy) {
      buffer.putUint8(133);
      writeValue(buffer, value.index);
    }    else if (value is OutOfQuotaPolicy) {
      buffer.putUint8(134);
      writeValue(buffer, value.index);
    }    else if (value is Constraints) {
      buffer.putUint8(135);
      writeValue(buffer, value.encode());
    }    else if (value is BackoffPolicyConfig) {
      buffer.putUint8(136);
      writeValue(buffer, value.encode());
    }    else if (value is InitializeRequest) {
      buffer.putUint8(137);
      writeValue(buffer, value.encode());
    }    else if (value is OneOffTaskRequest) {
      buffer.putUint8(138);
      writeValue(buffer, value.encode());
    }    else if (value is PeriodicTaskRequest) {
      buffer.putUint8(139);
      writeValue(buffer, value.encode());
    }    else if (value is ProcessingTaskRequest) {
      buffer.putUint8(140);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : TaskStatus.values[value];
      case 130: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : NetworkType.values[value];
      case 131: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : BackoffPolicy.values[value];
      case 132: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : ExistingWorkPolicy.values[value];
      case 133: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : ExistingPeriodicWorkPolicy.values[value];
      case 134: 
        final int? value = readValue(buffer) as int?;
        return value == null ? null : OutOfQuotaPolicy.values[value];
      case 135: 
        return Constraints.decode(readValue(buffer)!);
      case 136: 
        return BackoffPolicyConfig.decode(readValue(buffer)!);
      case 137: 
        return InitializeRequest.decode(readValue(buffer)!);
      case 138: 
        return OneOffTaskRequest.decode(readValue(buffer)!);
      case 139: 
        return PeriodicTaskRequest.decode(readValue(buffer)!);
      case 140: 
        return ProcessingTaskRequest.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class WorkmanagerHostApi {
  /// Constructor for [WorkmanagerHostApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  WorkmanagerHostApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> initialize(InitializeRequest request) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[request]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> registerOneOffTask(OneOffTaskRequest request) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.registerOneOffTask$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[request]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> registerPeriodicTask(PeriodicTaskRequest request) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.registerPeriodicTask$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[request]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> registerProcessingTask(ProcessingTaskRequest request) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.registerProcessingTask$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[request]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> cancelByUniqueName(String uniqueName) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.cancelByUniqueName$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[uniqueName]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> cancelByTag(String tag) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.cancelByTag$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[tag]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> cancelAll() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.cancelAll$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<bool> isScheduledByUniqueName(String uniqueName) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.isScheduledByUniqueName$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(<Object?>[uniqueName]);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  Future<String> printScheduledTasks() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.printScheduledTasks$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }
}

abstract class WorkmanagerFlutterApi {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  Future<void> backgroundChannelInitialized();

  Future<bool> executeTask(String taskName, Map<String?, Object?>? inputData);

  static void setUp(WorkmanagerFlutterApi? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerFlutterApi.backgroundChannelInitialized$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          try {
            await api.backgroundChannelInitialized();
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerFlutterApi.executeTask$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerFlutterApi.executeTask was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final String? arg_taskName = (args[0] as String?);
          assert(arg_taskName != null,
              'Argument for dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerFlutterApi.executeTask was null, expected non-null String.');
          final Map<String?, Object?>? arg_inputData = (args[1] as Map<Object?, Object?>?)?.cast<String?, Object?>();
          try {
            final bool output = await api.executeTask(arg_taskName!, arg_inputData);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}
