/**
 * ON/OFF Widget implementation
 * 
 * Copyright (C) 2009-2011  Rodrigo Zechin Rosauro
 * Copyright (C) 2012 Umakanthan Chandran
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Rodrigo Zechin Rosauro, Umakanthan Chandran
 * @version 1.1
 */

package dev.ukanth.ufirewall.widget;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.content.Intent;
import android.widget.RemoteViews;

import dev.ukanth.ufirewall.R;

/**
 * ON/OFF Widget implementation
 */
public class ToggleWidget extends AppWidgetProvider {
	@Override
	public void onReceive(final Context context, final Intent intent) {
		super.onReceive(context, intent);
	}

	@Override
	public void onUpdate(Context context, AppWidgetManager appWidgetManager,
			int[] appWidgetIds) {
		super.onUpdate(context, appWidgetManager, appWidgetIds);

		RemoteViews remoteViews = new RemoteViews(context.getPackageName(),R.layout.toggle_widget_layout);
		Intent configIntent = new Intent(context, ToggleWidgetActivity.class);

		PendingIntent configPendingIntent = PendingIntent.getActivity(context,0, configIntent, PendingIntent.FLAG_MUTABLE);
		remoteViews.setOnClickPendingIntent(R.id.toggle_widget_icon,configPendingIntent);
		appWidgetManager.updateAppWidget(appWidgetIds, remoteViews);
	}

}
