/*
 * SPDX-FileCopyrightText: Sebastiano Barezzi
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <cstdlib>
#include <jni.h>

#define JNI_CHECK(env)                \
    do {                              \
        if (env->ExceptionCheck()) {  \
            env->ExceptionDescribe(); \
            abort();                  \
        }                             \
    } while (0)

#define OBJECT_CLASS_SIG "Ljava/lang/Object;"
#define STRING_CLASS_SIG "Ljava/lang/String;"

static jmethodID getArrayListAddMethodID(JNIEnv *env, jobject object) {
    auto arrayListClazz = env->GetObjectClass(object);
    JNI_CHECK(env);

    auto methodID = env->GetMethodID(arrayListClazz, "add", "(" OBJECT_CLASS_SIG ")Z");
    JNI_CHECK(env);

    return methodID;
}
