<!--
SPDX-FileCopyrightText: 2025 Gusted
SPDX-FileCopyrightText: 2025 The FlorisBoard Contributors

SPDX-License-Identifier: CC-BY-4.0

Derived from: https://codeberg.org/forgejo/governance/src/commit/ff60d7ed4b0f3d411e6a0b5ebe5813fcad87b9dd/AIAgreement.md
-->

## Terminology

Software and services that heavily rely on large language model technology (LLMs) to generate their outcomes are referred to as Artificial Intelligence (AI). Examples of products that fit this definition are: GitHub Copilot, ChatGPT, Claude Sonnet, DeepSeek, Llama, Mistral and Gemini.

There's a distinction between general and narrow AI, all the previous examples fall under general AI as they were not trained to execute a specific well-defined task. Narrow AI is trained to be used for specific well-defined tasks with a problem space that is known in advance.

The use of AI agents ("vibe coding") involves an AI generating code changes, such as new features, bug fixes, tests, or refactors, based on a human's description of what needs to be implemented with little to no human supervision.

## Agreement

1. If at any point you used AI's work in your contribution you must ensure that you can submit this under the [license of the project](https://github.com/florisboard/florisboard/blob/main/LICENSE).
2. Accountability for the use of AI in a contribution lies with the person that makes that contribution.
3. All communications, including commit message bodies, pull request messages, documentation, code comments and issues (and comments on issues/pull requests), that are intended to be read by people to understand your thoughts and work must not have been generated with AI. We exclude machine translation and tooling that helps with grammar and spelling check.
4. Using general AI for review is forbidden. All changes have to be approved by a human reviewer.
5. The use of AI in an autonomous manner to contribute to FlorisBoard is prohibited. This restriction also applies to the usage of AI agents or "vibe coding".
6. Upon violation of this agreement it is up to the discretion of the maintainer team to handle it like a violation of [FlorisBoard's Code of Conduct](https://github.com/florisboard/florisboard/blob/main/CODE_OF_CONDUCT.md).
