package dev.octoshrimpy.quik.service

import android.annotation.SuppressLint
import android.app.job.JobInfo
import android.app.job.JobParameters
import android.app.job.JobService
import android.content.ComponentName
import android.content.Context
import dagger.android.AndroidInjection
import dev.octoshrimpy.quik.common.util.extensions.jobScheduler
import dev.octoshrimpy.quik.interactor.DeleteOldMessages
import io.reactivex.disposables.CompositeDisposable
import io.reactivex.rxkotlin.plusAssign
import timber.log.Timber
import java.util.concurrent.TimeUnit
import javax.inject.Inject

class AutoDeleteService : JobService() {

    companion object {
        private const val JOB_ID = 8120235

        @SuppressLint("MissingPermission") // Added in [presentation]'s AndroidManifest.xml
        fun scheduleJob(context: Context) {
            Timber.i("Scheduling job")
            val serviceComponent = ComponentName(context, AutoDeleteService::class.java)
            val periodicJob = JobInfo.Builder(JOB_ID, serviceComponent)
                    .setPeriodic(TimeUnit.DAYS.toMillis(1))
                    .setPersisted(true)
                    .build()

            context.jobScheduler.schedule(periodicJob)
        }

        fun cancelJob(context: Context) {
            Timber.i("Canceling job")
            context.jobScheduler.cancel(JOB_ID)
        }
    }

    @Inject lateinit var deleteOldMessages: DeleteOldMessages

    private val disposables = CompositeDisposable()

    override fun onStartJob(params: JobParameters?): Boolean {
        Timber.i("onStartJob")
        AndroidInjection.inject(this)
        disposables += deleteOldMessages
        deleteOldMessages.execute(Unit) {
            jobFinished(params, false)
        }
        return true
    }

    override fun onStopJob(params: JobParameters?): Boolean {
        Timber.i("onStopJob")
        disposables.dispose()
        return true
    }
}
