"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAction = createAction;
exports.initialState = void 0;
exports.reducer = reducer;
function createAction(payload) {
  return {
    payload
  };
}
const initialState = exports.initialState = {
  isSoftInputShown: false,
  softInputHeight: 0
};
function reducer(state, action) {
  if (action.payload === 0) {
    return {
      ...state,
      isSoftInputShown: false,
      softInputHeight: action.payload
    };
  }
  if (!state.isSoftInputShown) {
    return {
      ...state,
      isSoftInputShown: true,
      softInputHeight: action.payload
    };
  }
  return {
    ...state,
    softInputHeight: action.payload
  };
}
//# sourceMappingURL=stateReducer.js.map