"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AvoidSoftInput = void 0;
var _reactNative = require("react-native");
var _reactNativeIsEdgeToEdge = require("react-native-is-edge-to-edge");
var _AvoidSoftInputModule = _interopRequireDefault(require("./AvoidSoftInputModule"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const EDGE_TO_EDGE = (0, _reactNativeIsEdgeToEdge.isEdgeToEdge)();
const eventEmitter = new _reactNative.NativeEventEmitter(_reactNative.Platform.OS !== 'ios' ? undefined : _AvoidSoftInputModule.default);

/**
 * Fires event with current soft input height, when soft input is shown
 */
function onSoftInputShown(listener) {
  return eventEmitter.addListener('softInputShown', listener);
}

/**
 * Fires event when soft input is hidden
 */
function onSoftInputHidden(listener) {
  return eventEmitter.addListener('softInputHidden', listener);
}

/**
 * Fires event when soft input height changed
 */
function onSoftInputAppliedOffsetChange(listener) {
  return eventEmitter.addListener('softInputAppliedOffsetChanged', listener);
}

/**
 * Fires event when soft input's height changes
 */
function onSoftInputHeightChange(listener) {
  return eventEmitter.addListener('softInputHeightChanged', listener);
}

/**
 * Set whether module is enabled
 */
function setEnabled(enabled) {
  _AvoidSoftInputModule.default.setEnabled(enabled);
}

/**
 * Set should mimic IOS ime behavior (true), or let Android OS handle (resize) window (false)
 *
 * @platform `Android`
 * @deprecated Since v7 use `react-native-edge-to-edge` to control "edge to edge" mode on Android
 */
function setShouldMimicIOSBehavior(shouldMimic) {
  if (_reactNative.Platform.OS !== 'android') {
    return;
  }
  if (__DEV__) {
    (0, _reactNativeIsEdgeToEdge.controlEdgeToEdgeValues)({
      shouldMimic
    });
  }
  if (!EDGE_TO_EDGE) {
    _AvoidSoftInputModule.default.setShouldMimicIOSBehavior(shouldMimic);
  }
}

/**
 * Sets additional offset that will be added to value applied to root view/scroll view
 *
 * Can be negative (then final value will be smaller, so that some part of focused view will be covered by soft input frame)
 */
function setAvoidOffset(offset) {
  _AvoidSoftInputModule.default.setAvoidOffset(offset);
}

/**
 * Sets easing function that will be applied to applied offset animation, default is `linear`
 */
function setEasing(easing) {
  _AvoidSoftInputModule.default.setEasing(easing);
}

/**
 * Sets hide animation delay, takes value in milliseconds, if no value is provided, it will set default value which is `0` ms
 */
function setHideAnimationDelay(delay) {
  _AvoidSoftInputModule.default.setHideAnimationDelay(delay ?? 0);
}

/**
 * Sets hide animation duration, takes value in milliseconds, if no value is provided, it will set default value which is `220` ms
 */
function setHideAnimationDuration(duration) {
  _AvoidSoftInputModule.default.setHideAnimationDuration(duration ?? 220);
}

/**
 * Sets show animation delay, takes value in milliseconds, if no value is provided, it will set default value which is `300` ms on iOS and `0` ms on Android
 */
function setShowAnimationDelay(delay) {
  _AvoidSoftInputModule.default.setShowAnimationDelay(delay ?? _reactNative.Platform.select({
    default: 0,
    ios: 300
  }));
}

/**
 * Sets show animation duration, takes value in milliseconds, if no value is provided, it will set default value which is `660` ms
 */
function setShowAnimationDuration(duration) {
  _AvoidSoftInputModule.default.setShowAnimationDuration(duration ?? 660);
}

/**
 * Sets `android:windowSoftInputMode` attribute to `adjustNothing`
 *
 * @platform `Android`
 */
function setAdjustNothing() {
  if (_reactNative.Platform.OS !== 'android') {
    return;
  }
  _AvoidSoftInputModule.default.setAdjustNothing();
}

/**
 * Sets `android:windowSoftInputMode` attribute to `adjustPan`
 *
 * @platform `Android`
 */
function setAdjustPan() {
  if (_reactNative.Platform.OS !== 'android') {
    return;
  }
  _AvoidSoftInputModule.default.setAdjustPan();
}

/**
 * Sets `android:windowSoftInputMode` attribute to `adjustResize`
 *
 * @platform `Android`
 */
function setAdjustResize() {
  if (_reactNative.Platform.OS !== 'android') {
    return;
  }
  _AvoidSoftInputModule.default.setAdjustResize();
}

/**
 * Sets `android:windowSoftInputMode` attribute to `adjustUnspecified`
 *
 * @platform `Android`
 */
function setAdjustUnspecified() {
  if (_reactNative.Platform.OS !== 'android') {
    return;
  }
  _AvoidSoftInputModule.default.setAdjustUnspecified();
}

/**
 * Sets `android:windowSoftInputMode` attribute to default value that is set in manifest
 *
 * @platform `Android`
 */
function setDefaultAppSoftInputMode() {
  if (_reactNative.Platform.OS !== 'android') {
    return;
  }
  _AvoidSoftInputModule.default.setDefaultAppSoftInputMode();
}
const AvoidSoftInput = exports.AvoidSoftInput = {
  onSoftInputAppliedOffsetChange,
  onSoftInputHeightChange,
  onSoftInputHidden,
  onSoftInputShown,
  setAdjustNothing,
  setAdjustPan,
  setAdjustResize,
  setAdjustUnspecified,
  setAvoidOffset,
  setDefaultAppSoftInputMode,
  setEasing,
  setEnabled,
  setHideAnimationDelay,
  setHideAnimationDuration,
  setShouldMimicIOSBehavior,
  setShowAnimationDelay,
  setShowAnimationDuration
};
//# sourceMappingURL=AvoidSoftInput.js.map