#!/usr/bin/env node
import * as fs from "node:fs";
import { scanDependencies } from "@callstack/licenses/node";

function unwrap(text) {
  return text
    .split("\n")
    .map((line) => line.trim())
    .join("\n")
    .replace(/\n\n/g, "NLNLNLNL")
    .replace(/\n/g, " ")
    .replace(/ +/g, " ")
    .replace(/NLNLNLNL/g, "\n\n")
    .trim();
}

const options = {
  includeTransitiveDependencies: false,
};

const resultFull = scanDependencies("package.json", () => options);
const resultSimple = Object.values(resultFull).map((pkg) => ({
  name: pkg.name,
  content: unwrap(pkg.content),
}));

fs.writeFileSync("src/license-data.json", JSON.stringify(resultSimple));
