// NOTES FOR TRANSLATORS:
//
// - Do not translate the app name.
// - Keep the message list sorted.
// - Keep messages short and concise.
// - Avoid masculine or feminine forms.
// - Use LanguageTool to make sure the translation is correct.

const translation = {
  bookmarks_empty: "Favorite stations will be shown here",
  bookmarks_full: "No more bookmarks can be added. Remove some.",
  bookmarks_remove_confirm: "Are you sure to remove {{name}} from favorites?",
  bookmarks_suggest: 'Add "{{name}}" to favorites',
  button_refresh: "Refresh",
  data_export_failure: "Could not export the data.",
  data_export_success: 'Favorites and history have been exported to "{{name}}".',
  data_import_failure: "Could not import the data. Make sure this is a valid JSON file.",
  data_import_success: 'Favorites and history have been imported from "{{name}}".',
  dialog_cancel: "Cancel",
  dialog_no: "No",
  dialog_ok: "OK",
  dialog_yes: "Yes",
  error: 'An error occurred: "{{message}}"',
  history_empty: "Last played stations will be shown here",
  loading: "Loading",
  menu_bookmarks: "Favorites",
  menu_history: "History",
  menu_search: "Search",
  menu_settings: "Settings",
  net_error_connection: "Could not connect. This may be a temporary problem.",
  net_error_other: "Could not connect. An unknown error occurred.",
  net_error_response: "Could not connect. The server has sent invalid data.",
  player_bookmarks_empty: "No favorites",
  player_buffering: "Buffering...",
  player_error: "Error: {{error}}",
  player_loading: "Connecting...",
  player_playing: "Playing",
  player_stopped: "Stopped",
  search: "Search",
  search_empty: "No results",
  settings_audio_effects: "Audio effects",
  settings_clear_history: "Clear history",
  settings_clear_history_confirm: "Are you sure to clear the history?",
  settings_credits_oss: "Open source licenses",
  settings_custom_country: "Custom country",
  settings_custom_country_auto: "Automatic",
  settings_custom_country_description:
    "The country you are currently in is detected automatically from the mobile carrier data or the system language. If it appears to be incorrect, you can enter a valid two-letter ISO-3166-1 code down below.\n\nThis setting is used only for showing the popular stations list, and it does not affect the search results.",
  settings_data_export: "Export to...",
  settings_data_import: "Import from...",
  settings_debug: "For developers",
  settings_prevent_deep_sleep: "Prevent app from being put to sleep",
  settings_prevent_deep_sleep_description: "Open the system settings for battery optimization",
  settings_section_about: "About",
  settings_section_advanced: "Advanced",
  settings_section_data_management: "Data management",
  settings_section_main: "Settings",
  settings_send_usage_stats: "Optional features",
  settings_send_usage_stats_description:
    "Demodulate retrieves the internet radio station data from radio-browser.info service, but favorites and history are stored only on this device.\n\nIf you consent, Demodulate will also:\n\n• Send the favorites and history periodically, to check for updates, such as new valid audio stream addresses.\n\n• Send the unique identifier of the currently played station, to detect popular and broken stations.\n\nWould you like to enable these features? You can change this later in the app settings.",
  settings_send_usage_stats_disabled: "Disabled",
  settings_send_usage_stats_enabled: "Enabled",
  station_broken: "May not work",
  station_playing: "Playing",
};

export default { translation };
