import { useTranslation } from "react-i18next";
import { Text } from "react-native-paper";

import { Modal } from "../components";
import { getLogs } from "../logging";

function getLogsText() {
  return getLogs()
    .map((l) => `[${l.date.toLocaleTimeString()} ${l.name}]\n${l.msg}`)
    .join("\n\n");
}

export function DebugModal({ hide }) {
  const { t } = useTranslation();

  return (
    <Modal
      buttonPositive={{ label: t("dialog_ok"), onPress: hide }}
      onDismiss={hide}
      title={t("settings_debug")}
    >
      <Text>{getLogsText()}</Text>
    </Modal>
  );
}
