// NOTES FOR TRANSLATORS:
//
// - Do not translate the app name.
// - Keep the message list sorted.
// - Keep messages short and concise.
// - Avoid masculine or feminine forms.
// - Use LanguageTool to make sure the translation is correct.

const translation = {
  bookmarks_empty: "Tutaj będą wyświetlane ulubione stacje",
  bookmarks_full: "Nie można dodać więcej ulubionych stacji. Usuń kilka z nich.",
  bookmarks_remove_confirm: "Czy na pewno usunąć {{name}} z listy ulubionych?",
  bookmarks_suggest: 'Dodaj "{{name}}" do ulubionych',
  button_refresh: "Odśwież",
  data_export_failure: "Nie udało się wyeksportować danych.",
  data_export_success: 'Lista ulubionych i historia zostały wyeksportowane do "{{name}}".',
  data_import_failure: "Nie udało się zaimportować danych. Upewnij się, że to poprawny plik JSON.",
  data_import_success: 'Lista ulubionych i historia zostały zaimportowane z "{{name}}".',
  dialog_cancel: "Anuluj",
  dialog_no: "Nie",
  dialog_ok: "OK",
  dialog_yes: "Tak",
  error: 'Wystąpił błąd: "{{message}}"',
  history_empty: "Tutaj będą wyświetlane ostatnie stacje",
  loading: "Wczytywanie",
  menu_bookmarks: "Ulubione",
  menu_history: "Historia",
  menu_search: "Szukaj",
  menu_settings: "Ustawienia",
  net_error_connection: "Nie można się połączyć. Może być to tymczasowy problem.",
  net_error_other: "Nie można się połączyć. Wystąpił nieznany błąd.",
  net_error_response: "Nie można się połączyć. Serwer zwrócił niepoprawne dane.",
  player_bookmarks_empty: "Brak ulubionych",
  player_buffering: "Buforowanie...",
  player_error: "Błąd: {{error}}",
  player_loading: "Łączenie...",
  player_playing: "Odtwarzanie",
  player_stopped: "Zatrzymano",
  search: "Szukaj",
  search_empty: "Brak wyników",
  settings_audio_effects: "Efekty audio",
  settings_clear_history: "Wyczyść historię",
  settings_clear_history_confirm: "Czy na pewno wyczyścić historię?",
  settings_credits_oss: "Licencje open source",
  settings_custom_country: "Niestandardowy kraj",
  settings_custom_country_auto: "Automatycznie",
  settings_custom_country_description:
    "Kraj, w którym aktualnie przebywasz, jest wykrywany automatycznie na podstawie danych operatora lub języka systemu. Jeśli wydaje się błędny, możesz wpisać poprawny dwuliterowy kod ISO-3166-1 poniżej.\n\nTo ustawienie wykorzystywane jest tylko do wyświetlenia listy popularnych stacji i nie wpływa na wyniki wyszukiwania.",
  settings_data_export: "Eksportuj do...",
  settings_data_import: "Importuj z...",
  settings_debug: "Dla programistów",
  settings_prevent_deep_sleep: "Zapobiegnij usypianiu aplikacji",
  settings_prevent_deep_sleep_description: "Otwiera systemowe ustawienia optymalizacji baterii",
  settings_section_about: "Informacje",
  settings_section_advanced: "Zaawansowane",
  settings_section_data_management: "Zarządzanie danymi",
  settings_section_main: "Ustawienia",
  settings_send_usage_stats: "Dodatkowe funkcje",
  settings_send_usage_stats_description:
    "Demodulate pobiera dane internetowych stacji radiowych z usługi radio-browser.info, ale lista ulubionych i historia są przechowywane tylko na tym urządzeniu.\n\nJeśli wyrazisz zgodę, Demodulate będzie również:\n\n• Przesyłać listę ulubionych i historię, aby sprawdzać, czy są aktualizacje, takie jak nowe poprawne adresy strumieni audio.\n\n• Przesyłać unikatowy identyfikator odtwarzanej stacji, w celu wykrywania popularnych i uszkodzonych stacji.\n\nCzy chcesz, aby włączyć te funkcje? Możesz to zmienić później w ustawieniach aplikacji.",
  settings_send_usage_stats_disabled: "Wyłączone",
  settings_send_usage_stats_enabled: "Włączone",
  station_broken: "Może nie działać",
  station_playing: "Odtwarzanie",
};

export default { translation };
