import { useTranslation } from "react-i18next";

import { StationList } from "../components";
import { useStore } from "../store";
import { styles } from "../styles";

export function HistoryScene() {
  const { t } = useTranslation();

  const history = useStore((state) => state.history);

  return (
    <StationList
      data={history}
      emptyIcon="History"
      emptyText={t("history_empty")}
      role="history"
      style={{ marginBottom: styles.scene.marginBottom }}
    />
  );
}
