import { useTranslation } from "react-i18next";
import { Text } from "react-native-paper";

import { removeBookmark } from "../api/LocalStorage";
import { Modal } from "../components";

export function RemoveBookmarkModal({ data, hide }) {
  const { t } = useTranslation();

  return (
    <Modal
      buttonNegative={{ label: t("dialog_no"), onPress: hide }}
      buttonPositive={{ label: t("dialog_yes"), onPress: () => removeBookmark(data).then(hide) }}
      onDismiss={hide}
    >
      <Text>{t("bookmarks_remove_confirm", data)}</Text>
    </Modal>
  );
}
