import { Fragment } from "react";
import { useTranslation } from "react-i18next";
import { Text } from "react-native-paper";

import { Modal } from "../components";
import licenses from "../license-data.json";

function getLicensesText() {
  return licenses;
}

export function LicensesModal({ hide }) {
  const { t } = useTranslation();

  return (
    <Modal
      buttonPositive={{ label: t("dialog_ok"), onPress: hide }}
      onDismiss={hide}
      title={t("settings_credits_oss")}
    >
      {getLicensesText().map((pkg) => (
        <Fragment key={pkg.name}>
          <Text style={{ fontWeight: 700 }}>{pkg.name}</Text>
          <Text style={{ paddingBottom: 32, paddingTop: 16 }}>{pkg.content}</Text>
        </Fragment>
      ))}
    </Modal>
  );
}
