import { useEffect, useState } from "react";
import { useTranslation } from "react-i18next";
import { Text } from "react-native-paper";

import { importFromScopedStorage } from "../api/LocalStorage";
import { Modal } from "../components";
import i18next from "../i18n";

function getModalText(data) {
  const t = i18next.t;

  switch (data.status) {
    case "success":
      return t("data_import_success", { name: data.name });
    case "failure":
      return t("data_import_failure");
  }
}

export function DataImportModal({ hide }) {
  const { t } = useTranslation();

  const [data, setData] = useState({ status: "pending" });

  useEffect(() => {
    importFromScopedStorage()
      .then((result) => setData(result))
      .catch(() => setData({ status: "failure" }));
  }, []);

  useEffect(() => {
    if (data.status === "canceled") {
      hide();
    }
  }, [data]);

  if (!["success", "failure"].includes(data.status)) {
    return;
  }

  return (
    <Modal buttonPositive={{ label: t("dialog_ok"), onPress: hide }} onDismiss={hide}>
      <Text>{getModalText(data)}</Text>
    </Modal>
  );
}
