import { useState } from "react";
import { useTranslation } from "react-i18next";
import { Text, TextInput } from "react-native-paper";

import { setCustomCountry } from "../api/LocalStorage";
import { Modal } from "../components";
import { useStore } from "../store";

export function CustomCountryModal({ hide }) {
  const { t } = useTranslation();

  const origValue = useStore.getState().customCountry;
  const [value, setValue] = useState(origValue);

  return (
    <Modal
      buttonNegative={{ label: t("dialog_cancel"), onPress: hide }}
      buttonPositive={{ label: t("dialog_ok"), onPress: () => setCustomCountry(value).then(hide) }}
      onDismiss={hide}
      title={t("settings_custom_country")}
    >
      <Text>{t("settings_custom_country_description")}</Text>
      <TextInput value={value} onChangeText={setValue} style={{ marginTop: 16 }} />
    </Modal>
  );
}
