import { NativeModules } from "react-native";

let IN_MEMORY_LOG_HISTORY = [];

function log(level, name, msg) {
  if (level === "e") {
    NativeModules.NativeLogger.e(name, msg);
  } else {
    NativeModules.NativeLogger.i(name, msg);
  }

  IN_MEMORY_LOG_HISTORY = [{ date: new Date(), name, msg }, ...IN_MEMORY_LOG_HISTORY.slice(0, 99)];
}

export function getLogger(name) {
  return {
    e: (msg) => log("e", name, msg),
    i: (msg) => log("i", name, msg),
  };
}

export function getLogs() {
  return [...IN_MEMORY_LOG_HISTORY];
}
