import { View } from "react-native";
import { Button, Text, useTheme } from "react-native-paper";

import { LucideIcon } from "./LucideIcon";

export function Splash({ icon, action, actionText, children, style }) {
  const theme = useTheme();

  return (
    <View
      style={{
        alignItems: "center",
        flexGrow: 1,
        justifyContent: "center",
        paddingHorizontal: 32,
        ...style,
      }}
    >
      <LucideIcon color={theme.colors.primary} name={icon} size={64} strokeWidth={1} />
      <Text
        style={{ letterSpacing: 0.5, marginTop: 16, textAlign: "center" }}
        variant="titleMedium"
      >
        {children}
      </Text>
      {actionText && (
        <Button mode="outlined" onPress={action} style={{ marginTop: 16, minWidth: 128 }}>
          {actionText}
        </Button>
      )}
    </View>
  );
}
