"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  findBestLanguageTag: true,
  getCalendar: true,
  getCountry: true,
  getCurrencies: true,
  getLocales: true,
  getNumberFormatSettings: true,
  getTemperatureUnit: true,
  getTimeZone: true,
  openAppLanguageSettings: true,
  uses24HourClock: true,
  usesAutoDateAndTime: true,
  usesAutoTimeZone: true,
  usesMetricSystem: true
};
exports.findBestLanguageTag = findBestLanguageTag;
Object.defineProperty(exports, "getCalendar", {
  enumerable: true,
  get: function () {
    return _module.getCalendar;
  }
});
Object.defineProperty(exports, "getCountry", {
  enumerable: true,
  get: function () {
    return _module.getCountry;
  }
});
Object.defineProperty(exports, "getCurrencies", {
  enumerable: true,
  get: function () {
    return _module.getCurrencies;
  }
});
Object.defineProperty(exports, "getLocales", {
  enumerable: true,
  get: function () {
    return _module.getLocales;
  }
});
Object.defineProperty(exports, "getNumberFormatSettings", {
  enumerable: true,
  get: function () {
    return _module.getNumberFormatSettings;
  }
});
Object.defineProperty(exports, "getTemperatureUnit", {
  enumerable: true,
  get: function () {
    return _module.getTemperatureUnit;
  }
});
Object.defineProperty(exports, "getTimeZone", {
  enumerable: true,
  get: function () {
    return _module.getTimeZone;
  }
});
Object.defineProperty(exports, "openAppLanguageSettings", {
  enumerable: true,
  get: function () {
    return _module.openAppLanguageSettings;
  }
});
Object.defineProperty(exports, "uses24HourClock", {
  enumerable: true,
  get: function () {
    return _module.uses24HourClock;
  }
});
Object.defineProperty(exports, "usesAutoDateAndTime", {
  enumerable: true,
  get: function () {
    return _module.usesAutoDateAndTime;
  }
});
Object.defineProperty(exports, "usesAutoTimeZone", {
  enumerable: true,
  get: function () {
    return _module.usesAutoTimeZone;
  }
});
Object.defineProperty(exports, "usesMetricSystem", {
  enumerable: true,
  get: function () {
    return _module.usesMetricSystem;
  }
});
var _module = require("./module");
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
function findBestLanguageTag(languageTags) {
  const locales = (0, _module.getLocales)();
  const loweredLanguageTags = languageTags.map(tag => tag.toLowerCase());
  for (let i = 0; i < locales.length; i++) {
    const currentLocale = locales[i];
    if (!currentLocale) {
      continue;
    }
    const {
      languageTag,
      languageCode,
      scriptCode,
      countryCode,
      isRTL
    } = currentLocale;
    const combinaisons = [languageTag, !!scriptCode ? languageCode + "-" + scriptCode : null, languageCode + "-" + countryCode, languageCode].filter(value => !!value);
    for (let j = 0; j < combinaisons.length; j++) {
      const combinaison = combinaisons[j]?.toLowerCase();
      if (!combinaison) {
        continue;
      }
      const tagIndex = loweredLanguageTags.indexOf(combinaison);
      const languageTag = languageTags[tagIndex];
      if (languageTag && tagIndex !== -1) {
        return {
          languageTag,
          isRTL
        };
      }
    }
  }
}
//# sourceMappingURL=index.js.map