"use strict";

import { useEffect, useReducer } from 'react';
import { AvoidSoftInput } from './AvoidSoftInput';
import { createAction, initialState, reducer } from './stateReducer';
export function useSoftInputAppliedOffsetChanged(callback) {
  useEffect(() => {
    const unsubscribeAppliedOffsetChanged = AvoidSoftInput.onSoftInputAppliedOffsetChange(callback);
    return () => {
      unsubscribeAppliedOffsetChanged.remove();
    };
  }, [callback]);
}
export function useSoftInputHeightChanged(callback) {
  useEffect(() => {
    const unsubscribeHeightChanged = AvoidSoftInput.onSoftInputHeightChange(callback);
    return () => {
      unsubscribeHeightChanged.remove();
    };
  }, [callback]);
}
export function useSoftInputHidden(callback) {
  useEffect(() => {
    const unsubscribeHidden = AvoidSoftInput.onSoftInputHidden(callback);
    return () => {
      unsubscribeHidden.remove();
    };
  }, [callback]);
}
export function useSoftInputShown(callback) {
  useEffect(() => {
    const unsubscribeShown = AvoidSoftInput.onSoftInputShown(callback);
    return () => {
      unsubscribeShown.remove();
    };
  }, [callback]);
}
export function useSoftInputState() {
  const [state, dispatch] = useReducer(reducer, initialState);
  useSoftInputHeightChanged(({
    softInputHeight
  }) => {
    dispatch(createAction(softInputHeight));
  });
  return state;
}
//# sourceMappingURL=hooks.js.map